

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CT_getChangeTrackingInfo.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CT_getChangeTrackingInfo.sp,v $ $Id: CT_getChangeTrackingInfo.sp,v 1.1.2.3 2019/06/12 18:17:10 cnaik Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CT_getChangeTrackingInfo')
BEGIN
	print '>>> Drop Stored Procedure: CT_getChangeTrackingInfo <<<'
	drop procedure CT_getChangeTrackingInfo
END
IF EXISTS (select * from GxQscripts where name='CT_getChangeTrackingInfo')
	delete from GxQscripts where name = 'CT_getChangeTrackingInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CT_getChangeTrackingInfo')
	delete from GXDBVersions where aliasname = 'CT_getChangeTrackingInfo'
GO
print '... Creating Procedure: CT_getChangeTrackingInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CT_getChangeTrackingInfo
  @prevTrackingVersion bigint,
  @batchSize int = 500,
  @xmlResult xml output,
  @generateOutput int = 1
AS
  DECLARE @xmloutput xml
EXECUTE AS USER = 'sqladmin_cv'
-- Get a list of table with change tracking enabled
declare @trackedTableName nvarchar(1000);
DECLARE db_cursor CURSOR FOR
select sys.tables.name from sys.change_tracking_tables
join sys.tables ON tables.object_id = change_tracking_tables.object_id
declare @sql nvarchar(2500), @retVal int, @tableName nvarchar(1000), @curVersion bigint, @newVersion bigint, @newCTVersion bigint,@maxNewVersion bigint = @prevTrackingVersion, @maxNewCTVersion bigint = @prevTrackingVersion;
set @curVersion = @prevTrackingVersion + @batchSize;
set @newVersion = @prevTrackingVersion;
set @newCTVersion = @prevTrackingVersion;
declare @epochTime int
set @epochTime = dbo.GetUnixTime(GETUTCDATE())
OPEN db_cursor
FETCH NEXT FROM db_cursor INTO @trackedTableName
while @@FETCH_STATUS = 0
begin
  -- Set the current table name
  set @tableName = @trackedTableName
  declare @xmlrows xml,  @tableResult xml;
  -- Determine if the table has changed since the previous version
  set @sql = 'select @retVal = count(*) from changetable(changes ' + @tableName + ', ' + cast(@prevTrackingVersion as varchar) + ') as changedTable'
  exec sp_executesql @sql, N'@retVal int output', @retVal output
  if @retval > 0
  begin
	DECLARE @primarykey_result varchar(1000)
	SET @primarykey_result = ''
	SELECT @primarykey_result = @primarykey_result + (column_name + ' as "primaryKeyField' + '/@' + column_name + '"' + ',')
	FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS TC
	INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE AS KU
	ON TC.CONSTRAINT_TYPE = 'PRIMARY KEY' AND
		TC.CONSTRAINT_NAME = KU.CONSTRAINT_NAME AND
		KU.table_name=@tableName
	ORDER BY KU.TABLE_NAME, KU.ORDINAL_POSITION;
	SET @primarykey_result = substring(@primarykey_result, 1, len(@primarykey_result) - 1)
	-- Get changes within lastversion + batch size (ex: 1000 - 1500)
	set @sql = 'set @xmlrows = (SELECT SYS_CHANGE_VERSION as "@sysChangeVersion", SYS_CHANGE_OPERATION as "@sysChangeOperation",  SYS_CHANGE_COLUMNS as "@sysChangeColumns", ' + @primarykey_result +
	' FROM CHANGETABLE(CHANGES ' +  @tableName + ',' +  Convert(nvarchar,@prevTrackingVersion)
		+  ') AS CT1 WHERE SYS_CHANGE_VERSION <= ' + Convert(nvarchar,@curVersion)  +' ORDER BY SYS_CHANGE_VERSION for xml path(''ctRowList''))'
	exec sp_executesql @sql, N'@xmlrows xml output', @xmlrows output
	-- Get max version for the payload
	set @sql = 'set @newCTVersion = (SELECT MAX(SYS_CHANGE_VERSION) FROM CHANGETABLE(CHANGES ' +  @tableName + ',' +  Convert(nvarchar,@prevTrackingVersion)
		+  ') AS CT1 WHERE SYS_CHANGE_VERSION <=' + Convert(nvarchar,@curVersion) + ')'
	exec sp_executesql @sql, N'@newCTVersion bigint output', @newCTVersion output
	set @sql = 'set @newVersion = (SELECT MAX(SYS_CHANGE_VERSION) FROM CHANGETABLE(CHANGES ' +  @tableName + ',' +  Convert(nvarchar,@prevTrackingVersion)
		+  ') AS CT1 )'
	exec sp_executesql @sql, N'@newVersion bigint output', @newVersion output
	if @newVersion > @maxNewVersion
	begin
		set @maxNewVersion = @newVersion
	end
	if @newCTVersion > @maxNewCTVersion
	begin
		set @maxNewCTVersion = @newCTVersion
	end
	if @xmlrows is not NULL AND @xmlrows.exist('*') != 0
	begin
		set @tableResult = (select @xmlrows for xml path('ctTableList'))
		-- add attribute name & new version into XML
		set @tableResult.modify('
				insert attribute name {sql:variable("@tableName") }
				into (/ctTableList)[1]
			')
		set @tableResult.modify('
			insert attribute newVersion {sql:variable("@newCTVersion") }
			into (/ctTableList)[1]
		')
		set @tableResult.modify('
			insert attribute epochTime {sql:variable("@epochTime") }
			into (/ctTableList)[1]
		')
		set @xmlResult = (select @xmlResult, @tableResult for xml path(''))
	end
  end
  -- get next list of tables
  FETCH NEXT FROM db_cursor INTO @trackedTableName
end
CLOSE db_cursor
DEALLOCATE db_cursor
set @xmlResult = (select @maxNewVersion as "@maxNewVersion", @maxNewCTVersion as "@payloadMaxVersion", @xmlResult for xml path('CTResult'))
GENERATE_OUTPUT:
		if @generateOutput = 1
		BEGIN
			SET @xmloutput = @xmlResult
			SELECT @xmloutput
		END
GO

IF EXISTS (select * from GxQscripts where name = 'CT_getChangeTrackingInfo')
	delete from GxQscripts where name = 'CT_getChangeTrackingInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CT_getChangeTrackingInfo')
	delete from GXDBVersions where aliasname = 'CT_getChangeTrackingInfo'
GO

insert into GXDBVersions values(2, 'CT_getChangeTrackingInfo',  '00010001000200030000', 'CT_getChangeTrackingInfo', '00010001000200030000')
GO

