

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CT_appSetMessageQueueConfig.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CT_appSetMessageQueueConfig.sp,v $ $Id: CT_appSetMessageQueueConfig.sp,v 1.1.2.1 2018/10/23 03:07:50 cnaik Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CT_appSetMessageQueueConfig')
BEGIN
	print '>>> Drop Stored Procedure: CT_appSetMessageQueueConfig <<<'
	drop procedure CT_appSetMessageQueueConfig
END
IF EXISTS (select * from GxQscripts where name='CT_appSetMessageQueueConfig')
	delete from GxQscripts where name = 'CT_appSetMessageQueueConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CT_appSetMessageQueueConfig')
	delete from GXDBVersions where aliasname = 'CT_appSetMessageQueueConfig'
GO
print '... Creating Procedure: CT_appSetMessageQueueConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CT_appSetMessageQueueConfig
  @in_xml XML,
  @out_xml xml output,
  @generateOutput int = 1
AS
BEGIN TRY
SET NOCOUNT ON
DECLARE @userId						      		INT
DECLARE @localeId           					INT
DECLARE @isAdminUser        					INT
DECLARE @ChangeTrackingActiveMQServerId				    INT
DECLARE @CacheWebServerId						INT
DECLARE @nowTime							INT
DECLARE @errorCode 							INT
DECLARE @errorMessage 						VARCHAR(MAX)
DECLARE @outXml                            XML
set @errorCode = 0
set @errorMessage = ''
select  @userId 						= isnull(userRef.value('@userId', 'int'),0),
		@localeId 						= isnull(locRef.value('@localeId', 'int'),0),
		@ChangeTrackingActiveMQServerId 		= isnull(activeMqRef.value('@clientId', 'int'),0),
		@CacheWebServerId 		= isnull(webServerRef.value('@clientId', 'int'),0)
FROM    @in_xml.nodes('App_SetMessageQueueConfigReq') A ( ref )
		outer apply ref.nodes('./config/ActiveMQServer') B ( activeMqRef )
		outer apply ref.nodes('./config/CacheWebServer') C ( webServerRef )
        outer apply ref.nodes('./processinginstructioninfo/user') D ( userRef )
		outer apply ref.nodes('./processinginstructioninfo/locale') E ( locRef )
--check requesting user details
IF (NOT EXISTS(SELECT 1 FROM UMUsers WITH(nolock) WHERE id = @userId))
BEGIN
	SET @errorCode  = 1
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3290 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
	SET @errorMessage = REPLACE(@errorMessage, '^1%s', @userId)
	GOTO SEND_RESPONSE
END
--Users with Administrative capability at commcell level
EXEC sec_checkPermissionOnEntity @userId, 1, @isAdminUser OUT,1,2
IF(@isAdminUser = 0)
BEGIN
	SET @errorCode  = 1
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2034 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
	GOTO SEND_RESPONSE
END
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
BEGIN TRAN
	-- Update property to set ActiveMQ server
	if(exists(select 1 from GxGlobalParam with(nolock) where name = 'ChangeTrackingActiveMQServerId'))
	begin
		update GxGlobalParam set value = CAST(@ChangeTrackingActiveMQServerId as nvarchar(10)) where name = 'ChangeTrackingActiveMQServerId'
	end
	else
	begin
		insert into GxGlobalParam(name, value, created, modified)
		values('ChangeTrackingActiveMQServerId', @ChangeTrackingActiveMQServerId, @nowTime, 0)
	end
	-- Update property to set CacheWeb server
	if(exists(select 1 from GxGlobalParam with(nolock) where name = 'CacheWebServerId'))
	begin
		update GxGlobalParam set value = CAST(@CacheWebServerId as nvarchar(10)) where name = 'CacheWebServerId'
	end
	else
	begin
		insert into GxGlobalParam(name, value, created, modified)
		values('CacheWebServerId', @CacheWebServerId, @nowTime, 0)
	end
COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode     = ERROR_NUMBER()
    SET @errorMessage  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
    IF @@TRANCOUNT > 0
        ROLLBACK TRANSACTION;
END CATCH
SEND_RESPONSE:
SET @outXml = ( SELECT  @errorCode AS '@errorCode', @errorMessage AS '@errorString'
                 FOR xml path('error'),ROOT('App_SetPushNotificationConfigResp')
               )
GENERATE_OUTPUT:
	if @generateOutput = 1
		BEGIN
			select @outXml
		END
SET NOCOUNT OFF

IF EXISTS (select * from GxQscripts where name = 'CT_appSetMessageQueueConfig')
	delete from GxQscripts where name = 'CT_appSetMessageQueueConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CT_appSetMessageQueueConfig')
	delete from GXDBVersions where aliasname = 'CT_appSetMessageQueueConfig'
GO

insert into GXDBVersions values(2, 'CT_appSetMessageQueueConfig',  '00010001000200010000', 'CT_appSetMessageQueueConfig', '00010001000200010000')
GO

