

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CT_appGetMessageQueueConfig.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CT_appGetMessageQueueConfig.sp,v $ $Id: CT_appGetMessageQueueConfig.sp,v 1.1.2.2 2019/03/19 01:44:49 shebbarshankar Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CT_appGetMessageQueueConfig')
BEGIN
	print '>>> Drop Stored Procedure: CT_appGetMessageQueueConfig <<<'
	drop procedure CT_appGetMessageQueueConfig
END
IF EXISTS (select * from GxQscripts where name='CT_appGetMessageQueueConfig')
	delete from GxQscripts where name = 'CT_appGetMessageQueueConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CT_appGetMessageQueueConfig')
	delete from GXDBVersions where aliasname = 'CT_appGetMessageQueueConfig'
GO
print '... Creating Procedure: CT_appGetMessageQueueConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CT_appGetMessageQueueConfig
  @in_xml XML,
  @out_xml xml output,
  @generateOutput int = 1
AS
  DECLARE @outXml XML
BEGIN TRY
SET NOCOUNT ON
DECLARE @userId						      		INT
DECLARE @localeId           					INT
DECLARE @isAdminUser        					INT
DECLARE @pushNotifConfigXml					XML
DECLARE @errorCode 							INT
DECLARE @errorMessage 						VARCHAR(MAX)
DECLARE @bDisableMobileNotification      		INT
DECLARE @bMobileNotificatonFreq		      		INT
declare @r_errorsXml						XML
declare @r_pushConfigXml					XML
declare @r_notifServerXml					XML
declare @r_activeMqServerXml				XML
set @errorCode = 0
set @errorMessage = ''
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS col1
                         FROM    @in_xml.nodes('App_GetMessageQueueConfigReq/processinginstructioninfo/user') R ( ref )),1)
SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS col1
                         FROM    @in_xml.nodes('App_GetMessageQueueConfigReq/processinginstructioninfo/locale') R ( ref )),0)
--check requesting user details
IF (NOT EXISTS(SELECT 1 FROM UMUsers WITH(nolock) WHERE id = @userId))
BEGIN
	SET @errorCode  = 1
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3290 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
	SET @errorMessage = REPLACE(@errorMessage, '^1%s', @userId)
	GOTO SEND_RESPONSE
END
--Users with Administrative capability at commcell level
EXEC sec_checkPermissionOnEntity @userId, 1, @isAdminUser OUT,1,2
IF(@isAdminUser = 0)
BEGIN
	SET @errorCode  = 1
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2034 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
	GOTO SEND_RESPONSE
END
--Set the config values here
SET @r_notifServerXml = (select A.id as '@clientId', A.name as '@clientName' from App_Client A
						  where A.id in (select top 1 CAST(value as INT) from GxGlobalParam with(nolock) where name = 'ChangeTrackingActiveMQServerId')
						  for xml path('activeMQServer'))
SET @r_activeMqServerXml = (select A.id as '@clientId', A.name as '@clientName' from App_Client A
						  where A.id in (select top 1 CAST(value as INT) from GxGlobalParam with(nolock) where name = 'CacheWebServerId')
						  for xml path('cacheWebServer'))
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode     = ERROR_NUMBER()
    SET @errorMessage  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
    IF @@TRANCOUNT > 0
        ROLLBACK TRANSACTION;
END CATCH
SEND_RESPONSE:
SET @r_errorsXml = (SELECT @errorCode   AS '@errorCode',
                        @errorMessage AS '@errorString'
                    FOR xml PATH('error'))
SET @r_pushConfigXml = (select	ISNULL(@r_notifServerXml,''),
								ISNULL(@r_activeMqServerXml,'')
						for xml path('config'))
SET @outXml = ( select isnull(@r_errorsXml, ''),
						isnull(@r_pushConfigXml, '')
				for xml path(''),
				ROOT('App_GetMessageQueueConfigResp'))
SET @out_xml = @outXml
GENERATE_OUTPUT:
	if @generateOutput = 1
		BEGIN
			select @outXml
		END
SET NOCOUNT OFF

IF EXISTS (select * from GxQscripts where name = 'CT_appGetMessageQueueConfig')
	delete from GxQscripts where name = 'CT_appGetMessageQueueConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CT_appGetMessageQueueConfig')
	delete from GXDBVersions where aliasname = 'CT_appGetMessageQueueConfig'
GO

insert into GXDBVersions values(2, 'CT_appGetMessageQueueConfig',  '00010001000200020000', 'CT_appGetMessageQueueConfig', '00010001000200020000')
GO

