

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CTClientPropertiesLoading.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CTClientPropertiesLoading.sp,v $ $Id: CTClientPropertiesLoading.sp,v 1.1.2.2 2018/06/09 00:42:51 vdevassy Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CTClientPropertiesLoading <<<'

IF EXISTS (select * from sysobjects where name='CTClientPropertiesLoading')
	drop procedure CTClientPropertiesLoading
IF EXISTS (select * from GxQscripts where name='CTClientPropertiesLoading')
	delete from GxQscripts where name = 'CTClientPropertiesLoading'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CTClientPropertiesLoading')
	delete from GXDBVersions where aliasname = 'CTClientPropertiesLoading'
GO
print '... Creating Procedure: CTClientPropertiesLoading'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CTClientPropertiesLoading
-- Input arguments
-- Reload the CT_ClientProperties table: 0 OR 1
  @i_ReloadTable INT,
-- Indicates CS Services are starting up: 0 OR 1
  @i_ServiceStartup INT,
  @i_exitCode INT OUTPUT,
  @i_exitMessage VARCHAR(1024) OUTPUT,
-- i_returnResultSet 0 error info returned only output variables
  @i_returnResultSet INT = 1,
  @i_logLevel INT = 0
AS
--
-- NCVS:: $Id: CTClientPropertiesLoading.sp,v 1.1.2.2 2018/06/09 00:42:51 vdevassy Exp $
--
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @o_exitCode int = 0
  DECLARE @o_exitMessage varchar(1024) = ''
BEGIN
	SET NOCOUNT ON
	DECLARE @reloadTable	TINYINT = @i_ReloadTable		-- Reload the CT_ClientProperties table: 0 OR 1
	DECLARE @startUp		TINYINT = @i_ServiceStartup		-- Indicates CS Services are starting up: 0 OR 1
	DECLARE @debug			TINYINT = 0						-- Used for manually debugging problems with SP
	DECLARE @logLevel		TINYINT = CAST(@i_logLevel AS TINYINT)	-- inputted Event Log Level
	DECLARE @disableCTClientProperties       INT = 0
	SELECT
	       @disableCTClientProperties = (CASE WHEN value <> '0' THEN 1 ELSE 0 END)
	FROM GXGlobalParam WITH(NOLOCK)
	WHERE name = 'CTDisablePropertyCaching'
	IF (@disableCTClientProperties = 0)
	BEGIN
--- CODE BELOW HERE IS FROM CTClientPropertiesLoading.spb  ----------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/SPBodies/CTClientPropertiesLoading.spb,v $ $Id: CTClientPropertiesLoading.spb,v 1.1.2.3 2018/10/04 04:38:41 bzhu Exp $";
	-- External Variables set by loader / user of script
	--DECLARE @reloadTable	TINYINT = 0								-- Reload the CT_ClientProperties table: 0 OR 1
	--DECLARE @startUp		TINYINT = 0								-- Indicates CS Services are starting up: 0 OR 1
	--DECLARE @debug		TINYINT = 0								-- Used for manually debugging problems with SP
	--DECLARE @logLevel		TINYINT = CAST(@i_logLevel AS TINYINT)	-- inputted Event Log Level
	-- Start of SP Body SQL Script for use in tbl scripts, post upgrade scripts, and Stored Procedures
	SET NOCOUNT ON
	-- Get last cache table change tracking sync data
	DECLARE @exitCode			INT = 0
	DECLARE @exitMsg			VARCHAR(1024) = 'Success'
	DECLARE @rwcnt				INT = 0
	DECLARE @rowInserted		INT = 0
	DECLARE @rowUpdated			INT = 0
	DECLARE @rowDeleted			INT = 0
	DECLARE @lastSyncVersion	BIGINT
	DECLARE @minTblVersion		BIGINT = CHANGE_TRACKING_MIN_VALID_VERSION(OBJECT_ID('APP_ClientProp'))
	DECLARE @currentVersion		BIGINT = CHANGE_TRACKING_CURRENT_VERSION()
	DECLARE @lastSyncTime		INT
	DECLARE @now				DATETIME = GETUTCDATE()
	DECLARE @logLevelWarn		TINYINT = 2
	DECLARE @logLevelInfo		TINYINT = 4
	IF (@reloadTable = 0 AND NOT EXISTS(SELECT 1 FROM CT_ClientProperties))
	BEGIN
		SET @reloadTable = 1
	END
	IF (@debug > 0)
	BEGIN
		SELECT * FROM CT_CacheAssociations
	END
	SELECT
		@lastSyncVersion = ca.syncVersion,
		@lastSyncTime = ca.syncTime
	FROM CT_CacheAssociations ca WITH(NOLOCK)
	WHERE
		ca.cacheTable = 'CT_ClientProperties'
	IF (
		@reloadTable = 0
		AND @lastSyncVersion = @currentVersion
	)
	BEGIN
		-- If versions are the same nothing to update
		IF (@logLevel >= @logLevelInfo)
		BEGIN
			PRINT 'CTClientPropertiesLoading SPB: CT_ClientProperties Cache Table is Up-to-date.'
		END
		GOTO END_PROC
	END
	DECLARE @lastSyncDT		DATETIME = DATEADD(SECOND, @lastSyncTime, '01/01/1970')
	DECLARE @minDiff		INT = DATEDIFF(MINUTE, @lastSyncDT, @now)
	DECLARE @OneDays		INT = (24 * 60)		-- hours * minutes   -- Make tunable?
	IF (@debug > 0)
	BEGIN
		SELECT @now now, @lastSyncDT lastSyncDT, @minDiff minDiff
	END
	DECLARE @comma		TINYINT = 0
	DECLARE @nl			NVARCHAR(3) = NCHAR(13) + NCHAR(10)
	DECLARE @pivotVars	NVARCHAR(MAX) = @nl
	DECLARE @attrNames	NVARCHAR(MAX) = @nl
	DECLARE @colNames	NVARCHAR(MAX) = @nl
	DECLARE @sqlCmd		NVARCHAR(MAX) = ''
	SELECT
		@attrNames += (CASE WHEN @comma = 1 THEN ',' ELSE '' END) + '''' + propertyName + '''' + @nl,
		@pivotVars += (CASE WHEN @comma = 1 THEN ',' ELSE '' END) + '[' + propertyName + ']' + @nl,
		@colNames += (CASE WHEN @comma = 1 THEN ',' ELSE '' END) + columnName + @nl,
		@comma = 1
	FROM CT_CachePropertyAssociations cpa
WHERE cpa.tableType = 1
	-- Generate the Client Properties INSERT PIVOT Command
	DECLARE @pivotCmd		NVARCHAR(MAX) = @nl + '
INSERT INTO CT_ClientProperties (clientId, dirtyBit, ' + @colNames + ' )
	SELECT
		id clientId,
		0 dirtyBit,' + @pivotVars + '
	FROM (
			SELECT
				c.id,
				cp.attrName,
				cp.attrVal
			FROM
				APP_Client c
				LEFT OUTER JOIN App_ClientProp cp ON
					c.id = cp.componentNameId
					AND cp.modified = 0
					AND cp.attrName IN ( ' + @attrNames + ' )
		) AS clients
	PIVOT ( MAX(attrVal) FOR attrName IN ( ' + @pivotVars + ' ) ) AS P' + @nl
	-- Check if Cache Table is out-of-date and needs to be reloaded
	IF (@lastSyncVersion < @minTblVersion)
	BEGIN
		-- Versioning of last sync version is out-of-date RELOAD!
		SET @reloadTable = 1
		IF (@logLevel >= @logLevelWarn)
		BEGIN
			PRINT 'CTClientPropertiesLoading SPB: Warning CT_ClientProperties Cache Table (@lastSyncVersion[' + CAST(@lastSyncVersion AS VARCHAR(24)) + '] < @minTblVersion[' +  CAST(@minTblVersion AS VARCHAR(24)) + ']) is Out-of-date, Reloading!'
		END
	END
	ELSE IF (@startUp = 1 AND @reloadTable = 0)
	BEGIN
		-- Check last sync time with current time to
		-- see if the cache table has not been updated
		-- in 24 hours.  System possibly down and SQL Server
		-- Change Tracking may have cleaned up changes
		-- automatically.  Note Change Tracking Retention
		-- is set for 3 days.
		IF (@minDiff >= @OneDays)
		BEGIN
			-- Cache Table sync has not run in 24 hours -> RELOAD it!
			SET @reloadTable = 1
			IF (@logLevel >= @logLevelWarn)
			BEGIN
				PRINT 'CTClientPropertiesLoading SPB: Warning CT_ClientProperties Cache Table is 24 Hours Out-of-date, Reloading!'
			END
		END
	END
	-- Syncing Cache Table
	IF (@reloadTable = 1)
	BEGIN
		-- Reload the client properties table from scratch
		TRUNCATE TABLE CT_ClientProperties
		-- Execute command to populate the CT_ClientProperties cache table
		SET @currentVersion = CHANGE_TRACKING_CURRENT_VERSION()
		SET @pivotCmd += ' WHERE id > 1' + @nl
		EXEC(@pivotCmd)
		SET @rowInserted = @@ROWCOUNT
		--SELECT @rowInserted inserted
		IF (@logLevel >= @logLevelInfo)
		BEGIN
			PRINT 'CTClientPropertiesLoading SPB: CT_ClientProperties Cache Table reloaded to version ' + CAST(@currentVersion AS VARCHAR(24)) + '.'
		END
	END
	ELSE
	BEGIN
		-- Change Tracking Sync Cache Table
		IF OBJECT_ID('tempdb.dbo.#ClientList') IS NOT NULL
			DROP TABLE #ClientList
		CREATE TABLE #ClientList (
			propertyId		INT,		-- property row id that was updated, if 0 property row deleted perform a full update of all client properties
			clientId		INT,
			phyDeleted		TINYINT,
			propName		VARCHAR(128) NULL,
			colName			VARCHAR(64) NULL
			PRIMARY KEY (clientId, propertyId)
		)
		SET @currentVersion = CHANGE_TRACKING_CURRENT_VERSION()
		IF (@logLevel >= @logLevelInfo)
		BEGIN
			PRINT 'CTClientPropertiesLoading SPB: CT_ClientProperties Cache Table being sync''d from version ' + CAST(@lastSyncVersion AS VARCHAR(24)) + ' to '  + CAST(@currentVersion AS VARCHAR(24)) + '.'
		END
		;WITH FullUpdate (id, clientId, deleted) AS (
			-- This happens when a client property row is delete and there is
			-- no way via Change Tracking to tell what property was deleted,
			-- so perform a full update of all client properties. If it was
			-- a property that was cached it will be NULLed out.
			SELECT
				0,	-- indicates full update needed
				ct.componentNameId clientId,
				CASE
					WHEN c.id IS NULL THEN 1		-- client row no longer exist physically deleted
					ELSE 0
				END phyDeleted
			FROM CHANGETABLE(CHANGES APP_ClientProp, @lastSyncVersion) ct
				LEFT OUTER JOIN APP_Client c WITH(NOLOCK) ON
					c.id = ct.componentNameId
			WHERE
				ct.SYS_CHANGE_OPERATION = 'D'	-- client property row deleted
				OR c.id IS NULL					-- could be change tracking row capture then client deleted afterward?
			UNION
			-- new client row inserted and assocaited client property row does not exist
			SELECT
				0,
				c.id,
				0
			FROM APP_Client c WITH(NOLOCK)
				LEFT OUTER JOIN CT_ClientProperties cp WITH(NOLOCK) ON
					c.id = cp.clientId
					AND c.id > 1
			WHERE
				cp.clientId IS NULL		-- client added, missing property row
		),
		PropertyUpdate (id, clientId, deleted, propName, colName) AS (
			SELECT
				ct.id,
				ct.componentNameId clientId,
				0 phyDeleted,
				al.propertyName,
				al.columnName
			FROM CHANGETABLE(CHANGES APP_ClientProp, @lastSyncVersion) ct
				INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON
					cp.id = ct.id
					AND cp.componentNameId = ct.componentNameId
				INNER JOIN CT_CachePropertyAssociations al ON			-- only monitor the properties needed. remove all others
					al.propertyName = cp.attrName
AND al.tableType = 1
				LEFT OUTER JOIN FullUpdate f ON				-- if row deletion exist, remove from this list
					f.clientId = ct.componentNameId
			WHERE
				f.id IS NULL
		)
			INSERT INTO #ClientList
				SELECT
					f.id,
					f.clientId,
					f.deleted,
					NULL,
					NULL
				FROM FullUpdate f
				UNION ALL
				SELECT
					p.id,
					p.clientId,
					0 deleted,
					p.propName,
					p.colName
				FROM PropertyUpdate p
		SET @rwcnt = @@ROWCOUNT
		IF (@debug > 0)
		BEGIN
			SELECT * FROM #ClientList
		END
		IF (@rwcnt > 0)
		BEGIN
			-- Any delete operations to be done?
			DECLARE @doDeletion TINYINT = 0
			SELECT TOP 1
				@doDeletion = 1
			FROM #ClientList cld
				INNER JOIN APP_Client c WITH(NOLOCK) ON
					cld.clientId = c.id
					AND cld.propertyId = 0
			IF (@doDeletion = 1)
			BEGIN
				-- Generate insertion statement outside of transaction
				-- Delete these client rows and re-insert all client properties to fully update the client data
				SET @comma = 0
				SELECT
					@sqlCmd += (CASE WHEN @comma = 1 THEN ',' ELSE '' END) + CAST(cld.clientId AS NVARCHAR(12)) + @nl,
					@comma = 1
				FROM #ClientList cld
				WHERE cld.propertyId = 0
					AND cld.phyDeleted = 0
				SET @pivotCmd += ' WHERE id IN ( ' + @nl + @sqlCmd + @nl + ' ) ' + @nl
			END
			-- Generate update statement outside of transaction for client properties to be updated from Change Tracking Rows Updated or Inserted.
			DECLARE @upCmd NVARCHAR(MAX) = ''
			SELECT
				@upCmd += '
	UPDATE cps
		SET ' + q.colName + ' = cp.attrVal
	FROM #ClientList cl
		INNER JOIN CT_ClientProperties cps ON
			cl.propertyId > 0
			AND cl.clientId = cps.clientId
			AND cl.propName = ''' + q.propName + '''
		INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON
			cp.componentNameId = cl.clientId
			AND cp.attrName = ''' + q.propName + '''
			AND cp.modified = 0;
	SET @rwcnt += @@ROWCOUNT;' + @nl + @nl
			FROM (
					SELECT DISTINCT
						propName,
						colName
					FROM #ClientList cl
					WHERE
						cl.propertyId > 0
				) q
			BEGIN TRY
				-- Setup a Transaction and only do the things that have to done within the transaction!
				DECLARE @tranCnt INT = @@TRANCOUNT
				IF (@tranCnt > 0)
				BEGIN
					-- Transaction started outside of this script
					SAVE TRANSACTION CT_ClientProperties_SyncTrans
				END
				ELSE
				BEGIN
					-- Start a regular transaction
					BEGIN TRANSACTION CT_ClientProperties_SyncTrans
				END
				-- Have data that needs to be updated
				IF (@doDeletion = 1)
				BEGIN
					-- Delete these client rows and re-insert all client properties to fully update the client data
					DELETE cp
					FROM CT_ClientProperties cp
						INNER JOIN #ClientList cld ON
							cld.clientId = cp.clientId
							AND cld.propertyId = 0
					SET @rowDeleted = @@ROWCOUNT
					--SELECT @rowDeleted deleted
					-- Execute command to re-insert full updated client properties rows into CT_ClientProperties cache table
					EXEC(@pivotCmd)
					SET @rowInserted = @@ROWCOUNT
					--SELECT @rowInserted inserted
				END
				-- Update client properties that have Change Tracking update and / or insert operations
				SET @rwcnt = 0
				EXEC sp_executesql @upCmd, N'@rwcnt INT OUTPUT', @rwcnt = @rwcnt OUTPUT
				SET @rowUpdated = @rwcnt
				--SELECT @rowUpdated updated
				IF (@tranCnt = 0)
				BEGIN
					COMMIT TRANSACTION CT_ClientProperties_SyncTrans
   			END
			END TRY
			BEGIN CATCH
				ROLLBACK TRANSACTION CT_ClientProperties_SyncTrans
				PRINT  'CTClientPropertiesLoading SPB: INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
				PRINT 'CTClientPropertiesLoading SPB: Failure to sync CT_ClientProperties Cache Table!'
				SET @exitCode = ERROR_NUMBER()
				SET @exitMsg = 'Failure to sync CT_ClientProperties Cache Table.'
				GOTO END_PROC
			END CATCH
			DROP TABLE #ClientList
		END
	END
	-- Now update the Sync Version for the Cache Table
	-- to persist the version last sync'd with.
	DECLARE @uxNow	INT = dbo.GetUnixTime(GETUTCDATE())
	UPDATE CT_CacheAssociations
		SET syncVersion = @currentVersion,
			syncTime = @uxNow
	WHERE cacheTable = 'CT_ClientProperties'
	IF (@logLevel >= @logLevelInfo)
	BEGIN
		PRINT 'CTClientPropertiesLoading SPB: CT_ClientProperties Cache Table Rows Inserted[' + CAST(@rowInserted AS VARCHAR(12)) + '] Updated[' + CAST(@rowUpdated AS VARCHAR(12)) + '] Deleted[' + CAST(@rowDeleted AS VARCHAR(12)) + ']'
	END
END_PROC:
	IF (@debug > 0)
	BEGIN
		SELECT * FROM CT_CacheAssociations
	END
--- CODE ABOVE HERE IS FROM CTClientPropertiesLoading.spb  ----------
	END
	SET @i_exitCode = @exitCode
	SET @i_exitMessage = @exitMsg
	IF (@i_returnResultSet = 1)
	BEGIN
		SELECT @i_exitCode o_exitCode, @i_exitMessage o_exitMessage
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'CTClientPropertiesLoading')
	delete from GxQscripts where name = 'CTClientPropertiesLoading'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CTClientPropertiesLoading')
	delete from GXDBVersions where aliasname = 'CTClientPropertiesLoading'
GO

insert into GXDBVersions values(2, 'CTClientPropertiesLoading',  '00010001000200020000', 'CTClientPropertiesLoading', '00010001000200020000')
GO

