

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CSRAPerformOperations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CSRAPerformOperations')
BEGIN
	print '>>> Drop Stored Procedure: CSRAPerformOperations <<<'
	drop procedure CSRAPerformOperations
END
IF EXISTS (select * from GxQscripts where name='CSRAPerformOperations')
	delete from GxQscripts where name = 'CSRAPerformOperations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CSRAPerformOperations')
	delete from GXDBVersions where aliasname = 'CSRAPerformOperations'
GO
print '... Creating Procedure: CSRAPerformOperations'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CSRAPerformOperations
  @i_spOpType INTEGER
AS
SET NOCOUNT ON
DECLARE @now  		INTEGER 		= dbo.GetUnixTime(GETUTCDATE())
DECLARE @emailSuffix varchar(10) 	= '.STAGING'
DECLARE @commonSuffix varchar(50) 	= '-CHANGED-BY-STAGING'
DECLARE @None 	INT = 0
DECLARE @Staging INT = 1				--Staging
DECLARE @Recovery INT = 2				--Production Failover
DECLARE @Maintenance INT = 3			--Test Failover
DECLARE @StandbyOff INT = 4
DECLARE @ReadOnlyProduction INT = 5 	--Read Only Failover
--Passwords
IF	@i_spOpType IN (@Staging)
BEGIN
	Exec archSetCvPwdV5EncryptionInfo 3 /*RESET*/, '', '', 0, 0, 0
	EXEC('DISABLE TRIGGER APP_InstancePropTableChange ON APP_InstanceProp')
	EXEC('DISABLE TRIGGER APP_ClientPropTableChange ON App_ClientProp')
	EXEC('DISABLE TRIGGER APP_BackupSetPropTableChange ON APP_BackupSetProp')
	EXEC('DISABLE TRIGGER APP_IDAPropTableChange ON APP_IDAProp')
	-- Reset ALL Passwords
	UPDATE UMUsers set password = '2ALXqLLXNLLX0LLXcLLXxLL' WHERE id>1 and UMUsers.login not in ('ROMS','wba_gui__')
    UPDATE APP_COMMCELL SET userPassword = '1' WHERE userPassword NOT IN ('', 'N/A')
    UPDATE NTnotificationAction SET runAsUserPassword = '1' WHERE runAsUserPassword NOT IN ('', 'N/A')
	UPDATE GX set value = '1' FROM GXGlobalParam GX	JOIN APP_CredProps ACP WITH (NOLOCK)
	ON ACP.attrPwdName = GX.name AND ACP.cs_attrPwdName = CHECKSUM(GX.name)
	WHERE value NOT IN ('', 'N/A')
	UPDATE AP set attrVal = '1' FROM APP_SubClientProp AP JOIN APP_CredProps ACP WITH (NOLOCK)
		ON ACP.attrPwdName = AP.attrName AND ACP.cs_attrPwdName = CHECKSUM(AP.attrName)
	WHERE attrVal NOT IN ('', 'N/A')
	UPDATE AP set attrVal = '1' FROM APP_BackupsetProp AP JOIN APP_CredProps ACP WITH (NOLOCK)
		ON ACP.attrPwdName = AP.attrName AND ACP.cs_attrPwdName = CHECKSUM(AP.attrName)
	WHERE attrVal NOT IN ('', 'N/A')
	UPDATE AP set attrVal = '1' FROM APP_InstanceProp AP JOIN APP_CredProps ACP WITH (NOLOCK)
		ON ACP.attrPwdName = AP.attrName AND ACP.cs_attrPwdName = CHECKSUM(AP.attrName)
	WHERE attrVal NOT IN ('', 'N/A')
	UPDATE AP set attrVal = '1' FROM APP_IDAProp AP JOIN APP_CredProps ACP WITH (NOLOCK)
		ON ACP.attrPwdName = AP.attrName AND ACP.cs_attrPwdName = CHECKSUM(AP.attrName)
	WHERE attrVal NOT IN ('', 'N/A')
	UPDATE AP set attrVal = '1' FROM APP_ClientProp AP JOIN APP_CredProps ACP WITH (NOLOCK)
		ON ACP.attrPwdName = AP.attrName AND ACP.cs_attrPwdName = CHECKSUM(AP.attrName)
	WHERE attrVal NOT IN ('', 'N/A')
	UPDATE TM set value = '1' FROM TM_SubTaskOptions TM JOIN APP_CredProps ACP WITH (NOLOCK)
		ON ACP.attrPwdName = CAST(TM.optionId AS NVARCHAR(128)) AND ACP.cs_attrPwdName = CHECKSUM(TM.optionId)
	WHERE value NOT IN ('', 'N/A')
    UPDATE IdxAccessPath set Password = '1' WHERE Password NOT IN ('', 'N/A')
    UPDATE MMDeviceController set UserPassword = '1' WHERE UserPassword NOT IN ('', 'N/A')
    UPDATE MMDRUInfo set DRUPassword = '1' WHERE DRUPassword NOT IN ('', 'N/A')
    UPDATE MMHost set IndexCachePassword = '1' WHERE IndexCachePassword NOT IN ('', 'N/A')
    UPDATE MMMountPath set UserPassword = '1' WHERE UserPassword NOT IN ('', 'N/A')
    UPDATE MMNDMPHostInfo set Password = '1' WHERE Password NOT IN ('', 'N/A')
    UPDATE MMSanSwitchProxy set SwitchPassword = '1' WHERE SwitchPassword NOT IN ('', 'N/A')
    UPDATE SMArray set LoginPassword = '1' WHERE LoginPassword NOT IN ('', 'N/A')
    UPDATE SMControlHost set SMHostPassword = '1' WHERE SMHostPassword NOT IN ('', 'N/A')
	EXEC('ENABLE TRIGGER APP_InstancePropTableChange ON APP_InstanceProp')
	EXEC('ENABLE TRIGGER APP_ClientPropTableChange ON App_ClientProp')
	EXEC('ENABLE TRIGGER APP_BackupSetPropTableChange ON APP_BackupSetProp')
	EXEC('ENABLE TRIGGER APP_IDAPropTableChange ON APP_IDAProp')
	--remove private keys from app_thirdpartyapp for SP < SP25
	declare @dummyPrivateKey NVARCHAR(20) = 'dummyPrivateKey'
	IF EXISTS(SELECT TOP 1 1 FROM simInstalledPackages WITH(NOLOCK) WHERE ClientId = 2 AND HighestSP < 25)
	BEGIN
		 UPDATE App_ThirdPartyApp set props.modify('replace value of (/props/nameValues[@name="JKS Private Key"]/@value)[1] with (sql:variable("@dummyPrivateKey"))') WHERE props IS NOT NULL
	END
END
--Mail Server/ Emails
IF	@i_spOpType = @Staging
BEGIN
	UPDATE 	APP_commcell
	SET 	smtpServer = ''
	WHERE 	smtpServer <> ''
	-- Reset Email Address to prevent any mails from staging machine
	UPDATE  UMUsers
SET 	email = RIGHT(email + @emailSuffix, 255)
	WHERE   email NOT IN ('', 'No Email') AND email IS NOT NULL
	UPDATE  UMGroups
SET 	email = RIGHT(email + @emailSuffix, 255)
	WHERE   email NOT IN ('', 'No Email') AND email IS NOT NULL
	UPDATE  UMDSgroups
SET 	email = RIGHT(email + @emailSuffix, 255)
	WHERE  	email NOT IN ('', 'No Email') AND email IS NOT NULL
	UPDATE 	NTnotificationNonGalaxyUsers
SET 	nonGalaxyUserName = RIGHT(nonGalaxyUserName + @emailSuffix, 255)
	WHERE 	nonGalaxyUserName NOT IN ('') AND nonGalaxyUserName IS NOT NULL
END
--SMTP/HTTP Params
IF	@i_spOpType IN (@Staging)
BEGIN
	UPDATE 	GXGlobalParam
	SET 	value += @commonSuffix
	WHERE 	name IN (N'EVSMTPUsername', N'EVSMTPPassword', N'EVSMTPSender', N'EVSMTPDisplayName', N'SendLogsHTTPProxySite')
END
--CommserveSurvey Information
IF	@i_spOpType IN (@Staging, @Maintenance)
BEGIN
	UPDATE 	GXGlobalParam
	SET 	value = CASE
						WHEN name IN (N'CommservSurveyFreqDays') THEN '7'
						WHEN name IN (N'CommservSurveyEnabled') THEN '1'
						WHEN name IN (N'CommservSurveyLastCollectionTime', N'CommservSurveyLastScriptDownloadTime', N'CommservSurveyPrivateEnabled', N'CommservMetricsDirectDipLastCollectionTime') THEN '0'
						WHEN name IN (N'CommservSurveyDownloadsite') THEN 'https://edc.commvault.com/downloads/TestSQLScripts/'
						WHEN name IN (N'CommservSurveyUploadsite') THEN 'https://edc.commvault.com/httplogupload/testsurveyupload/'
						ELSE value + @commonSuffix
					END
	WHERE 	name IN (
				N'CommservSurveyFreqDays',
				N'CommservSurveyEnabled',
				N'CommservSurveyLastCollectionTime', N'CommservSurveyLastScriptDownloadTime', N'CommservSurveyPrivateEnabled', N'CommservMetricsDirectDipLastCollectionTime',
				N'CommservSurveyDownloadsite',
				N'CommservSurveyUploadsite',
				N'CommservSurveyPrivateDownloadsite', N'CommservSurveyPrivateUploadsite'
			)
END
--Reset Index Cache location
IF @i_spOpType IN (@Staging)
BEGIN
	UPDATE 	APP_ClientProp
	SET 	attrVal = 'C:\Program Files\Commvault\ContentStore\IndexCache'
	WHERE 	componentNameId = 2 AND attrName = 'Idx: cache path'
END

IF EXISTS (select * from GxQscripts where name = 'CSRAPerformOperations')
	delete from GxQscripts where name = 'CSRAPerformOperations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CSRAPerformOperations')
	delete from GXDBVersions where aliasname = 'CSRAPerformOperations'
GO

insert into GXDBVersions values(2, 'CSRAPerformOperations',  '00000000000000000000', 'CSRAPerformOperations', '00000000000000000000')
GO

