

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CSProactiveDBMaintainanceSQLJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CSProactiveDBMaintainanceSQLJob.sp,v $ $Id: CSProactiveDBMaintainanceSQLJob.sp,v 1.1.2.2 2018/10/16 21:33:06 vsubramanian Exp $";
--===================================================================
--	SQL Server Agent Job to  run Online index maintainance
--===================================================================
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CSProactiveDBMaintainanceSQLJob')
BEGIN
	print '>>> Drop Stored Procedure: CSProactiveDBMaintainanceSQLJob <<<'
	drop procedure CSProactiveDBMaintainanceSQLJob
END
IF EXISTS (select * from GxQscripts where name='CSProactiveDBMaintainanceSQLJob')
	delete from GxQscripts where name = 'CSProactiveDBMaintainanceSQLJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CSProactiveDBMaintainanceSQLJob')
	delete from GXDBVersions where aliasname = 'CSProactiveDBMaintainanceSQLJob'
GO
print '... Creating Procedure: CSProactiveDBMaintainanceSQLJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CSProactiveDBMaintainanceSQLJob
-- opCode Flag Bit Argument: add:1, delete:2, enable:4, disable:8
  @opCode INT = 0,
  @help INT = 0
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @now DATETIME = GETUTCDATE()
	DECLARE @startDate INT
    SET @startDate = CAST(FORMAT(@now, 'yyyyMMdd', 'en-US') AS INT)
	DECLARE @errorCode  INT = 0
	IF (@help > 0 OR @opCode = 0 OR @opCode IS NULL)
	BEGIN
		PRINT 'CSProactiveDBMaintainanceSQLJob: Usage @opCode=(Flag Bits: add, delete, enable, disable,help) , The script would create/delete/enable/disable the SQL Agent job, responsible for Automatic DB Maintenance '
		GOTO END_PROC
	END
	-- Is job aready configured?
	DECLARE @cfgJobId UNIQUEIDENTIFIER = NULL
	SELECT
		@cfgJobId = job_id
	FROM msdb.dbo.sysjobs WITH(NOLOCK)
	WHERE
		name = N'CSProactiveDBMaintainanceJob'
	-- Perform requested operation
	DECLARE @jobEnabled TINYINT = 0
	IF ((@opCode & 1) = 1)
	BEGIN
		-- Add SQL Agent Job
		IF (@cfgJobId IS NOT NULL)
		BEGIN
			-- Nothing to add, already configured
			GOTO END_PROC
		END
		BEGIN TRANSACTION
		DECLARE @ReturnCode INT
		DECLARE @schGUID NVARCHAR(40) = NEWID()
		SET @ReturnCode = 0
		IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=N'Commserver Database Diagnostic Utilities' AND category_class=1)
		BEGIN
			EXEC @ReturnCode = msdb.dbo.sp_add_category @class=N'JOB', @type=N'LOCAL', @name=N'Commserver Database Diagnostic Utilities'
			IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO ERROR_PROC
		END
		IF ((@opCode & 4) = 4)
		BEGIN
			SET @jobEnabled = 1
		END
		DECLARE @jobId UNIQUEIDENTIFIER
		EXEC @ReturnCode =  msdb.dbo.sp_add_job
				@job_name=N'CSProactiveDBMaintainanceJob',
				@enabled=@jobEnabled,
				@notify_level_eventlog=0,
				@notify_level_email=0,
				@notify_level_netsend=0,
				@notify_level_page=0,
				@delete_level=0,
				@description=N' Performs periodic Index rebuild based on index fragmentation ',
				@category_name=N'Commserver Database Diagnostic Utilities',
				@owner_login_name=N'sqladmin_cv',
				@job_id = @jobId OUTPUT
		IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO ERROR_PROC
		DECLARE @db NVARCHAR(MAX) = DB_NAME()
		DECLARE @cmd NVARCHAR(MAX) = N'EXEC ' + @db + '.dbo.CSProactiveDBMaintainance @MaxTimeLimit=10,@ClearBatch=0,@MaxindexOP =5,@HistoryRetentionDays=30  '
		EXEC @ReturnCode = msdb.dbo.sp_add_jobstep
				@job_id=@jobId,
				@step_name=N'Perform DBMaintainance.',
				@step_id=1,
				@cmdexec_success_code=0,
				@on_success_action=1,
				@on_success_step_id=0,
				@on_fail_action=2,
				@on_fail_step_id=0,
				@retry_attempts=0,
				@retry_interval=0,
				@os_run_priority=0,
				@subsystem=N'TSQL',
				@command=@cmd,
				@database_name=@db,
				@flags=0
		IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO ERROR_PROC
		EXEC @ReturnCode = msdb.dbo.sp_add_jobschedule
				@job_id=@jobId,
				@name=N'CSProactiveDBMaintainanceJob_Schedule',
				@enabled=1,			-- enabled the job schedule
				@freq_type=4,
				@freq_interval=1,
				@freq_subday_type=4,
				@freq_subday_interval=30,
				@freq_relative_interval=0,
				@freq_recurrence_factor=0,
				@active_start_date=@startDate,
				@active_end_date=99991231,
				@active_start_time=0,
				@active_end_time=215959,
				@schedule_uid=@schGUID
		IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO ERROR_PROC
		EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId, @server_name = N'(local)'
		IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO ERROR_PROC
		COMMIT TRANSACTION
		GOTO END_PROC
	END
	ELSE IF ((@opCode & 2) = 2)
	BEGIN
		IF (@cfgJobId IS NULL)
		BEGIN
			-- Nothing to delete
			GOTO END_PROC
		END
		-- Delete SQL Agent Job
		BEGIN TRANSACTION
		UPDATE gxglobalparam SET Value='0' WHERE NAME ='OIRB: OnlineIndexRebuildEnabled'
		EXEC @ReturnCode =  msdb.dbo.sp_delete_job
				@job_name=N'CSProactiveDBMaintainanceJob'
		IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO ERROR_PROC
		COMMIT TRANSACTION
		GOTO END_PROC
	END
	ELSE IF ((@opCode & (4|8)) > 0)
	BEGIN
		-- Enable or Disable SQL Agent Job
		IF (@cfgJobId IS NULL)
		BEGIN
			SET @errorCode = 1
			PRINT 'CSProactiveDBMaintainanceJob: SQL Agent Job does not exist'
			GOTO END_PROC
		END
		BEGIN TRANSACTION
		IF ((@opCode & 4) = 4)
		BEGIN
			SET @jobEnabled = 1
			UPDATE gxglobalparam SET Value='1' WHERE NAME ='OIRB: OnlineIndexRebuildEnabled'
		END
		IF ((@opCode & 8) = 8)
		BEGIN
			SET @jobEnabled = 0
			UPDATE gxglobalparam SET Value='0' WHERE NAME ='OIRB: OnlineIndexRebuildEnabled'
		END
		EXEC @ReturnCode = msdb.dbo.sp_update_job
				@job_id = @cfgJobId,
				@start_step_id = 1,
				@enabled=@jobEnabled
		IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO ERROR_PROC
		COMMIT TRANSACTION
		GOTO END_PROC
	END
	ELSE
	BEGIN
		-- Unknown opCode operation
		SET @errorCode = 1
		PRINT 'CSProactiveDBMaintainanceJob: Invalid input for @opCode argument'
		GOTO END_PROC
	END
	ERROR_PROC:
		IF (@ReturnCode > 0)
		BEGIN
			SET @errorCode = @ReturnCode
		END
		ELSE IF (@@ERROR > 0)
		BEGIN
			SET @errorCode = @@ERROR
		END
		ELSE
		BEGIN
			SET @errorCode = 1
		END
		IF (@@TRANCOUNT > 0)
			ROLLBACK TRANSACTION
	END_PROC:
	RETURN @errorCode
END
GO

IF EXISTS (select * from GxQscripts where name = 'CSProactiveDBMaintainanceSQLJob')
	delete from GxQscripts where name = 'CSProactiveDBMaintainanceSQLJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CSProactiveDBMaintainanceSQLJob')
	delete from GXDBVersions where aliasname = 'CSProactiveDBMaintainanceSQLJob'
GO

insert into GXDBVersions values(2, 'CSProactiveDBMaintainanceSQLJob',  '00010001000200020000', 'CSProactiveDBMaintainanceSQLJob', '00010001000200020000')
GO

