

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CSProactiveDBMaintainance.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CSProactiveDBMaintainance')
BEGIN
	print '>>> Drop Stored Procedure: CSProactiveDBMaintainance <<<'
	drop procedure CSProactiveDBMaintainance
END
IF EXISTS (select * from GxQscripts where name='CSProactiveDBMaintainance')
	delete from GxQscripts where name = 'CSProactiveDBMaintainance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CSProactiveDBMaintainance')
	delete from GXDBVersions where aliasname = 'CSProactiveDBMaintainance'
GO
print '... Creating Procedure: CSProactiveDBMaintainance'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CSProactiveDBMaintainance
  @MaxTimeLimit int=10,
  @ClearBatch int=0,
  @MaxindexOP int=5,
  @HistoryRetentionDays int=30 
AS
BEGIN
 --HistoryRetentionDays for Future Use
DECLARE @Nowdate datetime =GETUTCDATE()
IF NOT EXISTS
(
    SELECT 1
    FROM GXGlobalParam
    WHERE name = 'OIRB: OnlineIndexRebuildEnabled'
          AND Value = '1'
          AND Modified = 0
)
    RETURN;
IF NOT EXISTS (SELECT 1 FROM CSDbIndexMaintOps)
SELECT @ClearBatch=1
IF @ClearBatch =0
BEGIN
	 IF															--User Killed the Spid or Server restart it would clear after a day
			(DATEDIFF(day,
				   (
					   SELECT MAX(lastupdated)
					   FROM CSDbIndexMaintOps where CurrentStatus=1
				   ), @Nowdate) > 1 ) AND @ClearBatch =0
			   		SELECT @ClearBatch=1
	IF EXISTS
	(
		SELECT 1
		FROM CSDbIndexMaintOps
		WHERE Currentstatus = 1 AND @ClearBatch=0
	)
		RETURN;  -- Only one instance of reindex is to be running anytime
END
DECLARE @XML XML;
DECLARE @Databases NVARCHAR(50), @Fragmentationlow NVARCHAR(50), @FragmentationMedium NVARCHAR(50), @FragmentationHigh NVARCHAR(50), @FragmentationLevel1 INT, @FragmentationLevel2 INT, @LockTimeout INT, @WaitAtLowPriorityMaxDuration INT, @WaitAtLowPriorityAbortAfterWait NVARCHAR(50), @PageCountLevel INT, @Edition NVARCHAR(100)= '', @ProductVersion NVARCHAR(100), @IsOnlineRebuildSupported INT= 0, @OpStartDate DATETIME=@Nowdate , @FullIndexName VARCHAR(2500)= '', @Error INT= 0, @ErrMsg VARCHAR(MAX), @IndexOrgOpStartTime DATETIME, @MaxIndexPerBatch INT= 5
, @IndexCounter INT= 1, @BatchExpiryDays INT,@MaxDOP INT,@UpdateStatistics nvarchar(50),@OnlyModifiedStatistics nvarchar(1)
,@FillFactor INT
DECLARE @ms BIGINT, @total_ms BIGINT, @Dbname VARCHAR(100), @ObJectname VARCHAR(250), @IndexName VARCHAR(250);
SELECT @XML = CAST(value AS XML)
FROM GXGlobalParam
WHERE name = 'OIRB: OnlineIndexRebuildConfig'
      AND Modified = 0;
SELECT @Databases = @XML.value('(CSOnlineReindexRebuild/@Databases)[1]', 'Nvarchar(50)'),
       @Fragmentationlow = @XML.value('(CSOnlineReindexRebuild/@FragmentationlowOp)[1]', 'VARCHAR(50)'),
       @FragmentationMedium = @XML.value('(CSOnlineReindexRebuild/@FragmentationMediumOp)[1]', 'VARCHAR(50)'),
       @FragmentationHigh = @XML.value('(CSOnlineReindexRebuild/@FragmentationHighOp)[1]', 'VARCHAR(50)'),
       @FragmentationLevel1 = @XML.value('(CSOnlineReindexRebuild/@FragmentationLevel1)[1]', 'int'),
       @FragmentationLevel2 = @XML.value('(CSOnlineReindexRebuild/@FragmentationLevel2)[1]', 'int'),
       @LockTimeout = @XML.value('(CSOnlineReindexRebuild/@LockTimeout)[1]', 'int'),
       @WaitAtLowPriorityMaxDuration = @XML.value('(CSOnlineReindexRebuild/@WaitForLockDuration)[1]', 'int'),
       @WaitAtLowPriorityAbortAfterWait = @XML.value('(CSOnlineReindexRebuild/@WaitandAbort)[1]', 'VARCHAR(10)'),
       @PageCountLevel = @XML.value('(CSOnlineReindexRebuild/@PageCountLevel)[1]', 'int'),
       @BatchExpiryDays = @XML.value('(CSOnlineReindexRebuild/@BatchExpiryDays)[1]','int') ,
	   @MaxDOP =@XML.value('(CSOnlineReindexRebuild/@MAXDOP)[1]','int')  ,
       @FillFactor = @XML.value('(CSOnlineReindexRebuild/@FillFactor)[1]','int'),
	   @UpdateStatistics=@XML.value('(CSOnlineReindexRebuild/@UpdateStatistics)[1]', 'NVARCHAR(50)'),
	   @OnlyModifiedStatistics=ISNULL(@XML.value('(CSOnlineReindexRebuild/@OnlyModifiedStatistics)[1]', 'NVARCHAR(1)'),'N'),
       @OpStartDate = @Nowdate
IF @Fragmentationlow LIKE '%INDEX_REBUILD_ONLINE%'
   OR @FragmentationMedium LIKE '%INDEX_REBUILD_ONLINE%'
   OR @FragmentationHigh LIKE '%INDEX_REBUILD_ONLINE%'
    BEGIN
        SELECT @Edition = CAST(SERVERPROPERTY('Edition') AS NVARCHAR(255));
        SELECT @ProductVersion = CAST(SERVERPROPERTY('ProductVersion') AS NVARCHAR(255));
        SELECT @IsOnlineRebuildSupported = CASE
                                               WHEN((@ProductVersion LIKE '12%'
                                                     OR @ProductVersion LIKE '13%'
                                                     OR @ProductVersion LIKE '14%')
                                                    AND @Edition LIKE '%Enterprise%')
                                               THEN 1
                                               ELSE 0
                                           END;
        IF @IsOnlineRebuildSupported = 0
            BEGIN
                SELECT @Fragmentationlow = replace(replace(@Fragmentationlow, 'INDEX_REBUILD_ONLINE', ''), ',,', ',');
                SELECT @FragmentationMedium = replace(replace(@FragmentationMedium, 'INDEX_REBUILD_ONLINE', ''), ',,', ',');
                SELECT @FragmentationHigh = replace(replace(@FragmentationHigh, 'INDEX_REBUILD_ONLINE', ''), ',,', ',');
                SELECT @Fragmentationlow = CASE
                                               WHEN RIGHT(@Fragmentationlow, 1) = ','
                                               THEN SUBSTRING(@Fragmentationlow, 1, LEN(@Fragmentationlow)-1)
                                               ELSE @Fragmentationlow
                                           END;
                SELECT @FragmentationMedium = CASE
                                                  WHEN RIGHT(@FragmentationMedium, 1) = ','
                                                  THEN SUBSTRING(@FragmentationMedium, 1, LEN(@FragmentationMedium)-1)
                                                  ELSE @FragmentationMedium
                                              END;
                SELECT @FragmentationHigh = CASE
                                                WHEN RIGHT(@FragmentationHigh, 1) = ','
                                                THEN SUBSTRING(@FragmentationHigh, 1, LEN(@FragmentationHigh)-1)
                                                ELSE @Fragmentationlow
                                            END;
			--UPDATE GXGlobalParam
			--	SET vXMl.modify('Replace value of (CSOnlineReindexRebuild/@FragmentationlowOp/text())[1] WITH sql:variable("@Fragmentationlow")')
			--CAST ( value as XML) FROM GXGlobalParam WHERE name='OnlineIndexRebuildConfig' and Modified=0
        END;
END;
--Check We have information of list of fragmented index , if present work on it else populate it
-- If the @Bacth is expired clear and repopulate it
 IF
		(DATEDIFF(day,
               (
                   SELECT MAX(BatchStartDate)
                   FROM CSDbIndexMaintOps
               ), @Nowdate) > @BatchExpiryDays)
		SELECT @ClearBatch=1
IF NOT EXISTS		--Populate Data a) IF not present or batch expired
(
    SELECT 1
    FROM CSDBfragmentationInfo
    WHERE Status = 0
          AND Errorcode = 0
    ) or   ( @ClearBatch=1)
    BEGIN
	    DELETE from  CSDBMaintenanceSummaryView WHERE   DATEDIFF(Day,BatchStartDaTe,@Nowdate) > @HistoryRetentionDays
        TRUNCATE TABLE CSDBfragmentationInfo;
        TRUNCATE TABLE CSDbIndexMaintOps;
        INSERT INTO CSDbIndexMaintOps
        (BatchID,
         BatchStartDate,
         CurrentStatus,
		 LastUpdated
        )
               SELECT NEWID(),
                      @Nowdate,
                      1,
					  @Nowdate
		-- Index Defrag Exclusion List added since some tables are so large and defragging them on an an active Commserver can caused the TempDb / disk to run out of space.
		DECLARE @xList XML
		SELECT
			@xList = CAST(value AS XML)
		FROM GXGlobalParam
		WHERE name = N'DbMaintenanceExcludeIdxDefrag'
		DECLARE @IdxExclList TABLE (
			tableName		SYSNAME
		)
		IF (@xList IS NOT NULL)
		BEGIN
			INSERT INTO @IdxExclList (tableName)
				SELECT
					t.value('@name', 'SYSNAME') tableName
				FROM
					@xList.nodes('/DbMaintenanceExcludeIdxDefrag/Table') d(t)
		END
        ;WITH Fragstats AS (
             SELECT DB_ID() DBID,
                    DB_NAME() DBName,
                    idx.OBJECT_ID ObjectID,
                    OBJECT_NAME(idx.OBJECT_ID) Objectname,
                    idx.index_id,
                    idx.NAME,
                    idx.type,
                    idx.fill_factor,
                    p.rows,
                    ROUND(ips.avg_fragmentation_in_percent, 2) FragPercent,
                    CAST(avg_fragmentation_in_percent / 10 AS INT) fragPctWindow,
                    ips.page_count,
                    CAST(ips.fragment_count AS BIGINT) fragment_count,
			                     CEILING(PERCENT_RANK() OVER(ORDER BY CAST(avg_fragmentation_in_percent / 10 AS INT) * fragment_count ASC) * 10) AS Points --  Smaller Number indicates smaller index.
             FROM sys.dm_db_index_physical_stats(DB_ID(), NULL, NULL, NULL, NULL) ips
                  INNER JOIN sys.indexes idx ON idx.object_id = ips.object_id
                                                AND idx.index_id = ips.index_id
                                                AND idx.type > 0
                                                AND ips.avg_fragmentation_in_percent >= 30.0
                  INNER JOIN sys.partitions p ON p.object_id = idx.object_id
                                                 AND p.index_id = idx.index_id
			    WHERE ips.fragment_count IS NOT NULL AND  ips.page_count >@PageCountLevel
			)
             INSERT INTO CSDBfragmentationInfo
             (DBID,
              DBName,
              ObjectID,
              Objectname,
              index_id,
              NAME,
              type,
              fill_factor,
              rows,
              FragPercent,
              fragPctWindow,
              page_count,
              fragment_count,
              Points,
              Status,
              ErrorCode,
              ErrorDescription
             )
                    SELECT DBID,
                           DBName,
                           ObjectID,
                           Objectname,
                           index_id,
                           NAME,
                           type,
                           fill_factor,
                           rows,
                           FragPercent,
                           fragPctWindow,
                           page_count,
                           fragment_count,
                           Points,
                           0,
                           0,
                           ''
                    FROM Fragstats
					WHERE
						Objectname NOT IN (SELECT tableName FROM @IdxExclList)
                    ORDER BY Points DESC;
END;
UPDATE CSDbIndexMaintOps
  SET
      CurrentStatus = 1 , lastUpdated=@Nowdate Where CurrentStatus =0
--Check CPU per Each Index Operation
--Decide Which Index to choose
--  DECLARE @TmpIndexforRebuild (ID,)
-- WHen CPU >70 Quit
-- WHEN CPU >50 AND CPU < 70 Choose Records with Points 0-5 , If nothing choose Minimum points
-- WHEN CPU >40 AND CPU < 50 Choose Records with Points 5-10 ,start from 5
-- WHEN CPU <40			  Choose Records with Points 5-10 ,start from 10
WHILE(@IndexCounter <= @MaxindexOP
      AND DATEDIFF(minute, @OpStartDate, GETUTCDATE()) < @MaxTimeLimit) -- The Index Operation has  been running for more than 10 mins or has  finished 5 index rebuilds
    BEGIN
																			--If the Online Index Op is disabled -- Quit
        IF NOT EXISTS
        (
            SELECT 1
            FROM GXGlobalParam
            WHERE name = 'OIRB: OnlineIndexRebuildEnabled'
                  AND Value = '1'
                  AND Modified = 0
        )
            BREAK;
		IF NOT EXISTS
        (
            SELECT 1
            FROM CSDBfragmentationInfo
            WHERE Status=0 AND   ErrorCode = 0
        )
            BREAK;
        SELECT @ms = ms_ticks,
               @total_ms = process_kernel_time_ms + process_user_time_ms
        FROM sys.dm_os_sys_info;
        DECLARE @cpu_util TABLE
        (ID INT IDENTITY(1,1),
         Cpu_utlization INT
        );
        WAITFOR DELAY '00:00:01';
        INSERT INTO @cpu_util (Cpu_utlization)
               SELECT  CONVERT(INT, ((process_kernel_time_ms + process_user_time_ms - @total_ms) / CAST(cpu_count AS DECIMAL(10, 2))) / (ms_ticks - @ms) * 100) cpu_utilization
               FROM sys.dm_os_sys_info;
        WITH CPU(CPURAngeLow,
                 CpuRangeHigh,
                 LowPoint,
                 HighPoint,
                 OrderBy)
             AS (
             SELECT 50,
                    70,
                    0,
                    4,
                    0
             UNION
             SELECT 40,
                    50,
                    5,
                    7,
                    0
             UNION
             SELECT 0,
                    40,
                    8,
                    10,
                    1),
             DefragIndexList(DbName,
                             ObjectName,
                             Name,
                             Ordering)
             AS (
             SELECT TOP 1 DBName,
                          ObjectName,
                          name,
                          CASE
                              WHEN Orderby = 0
                              THEN ROW_NUMBER() OVER(ORDER BY points ASC,
                                                              fragPctWindow ASC)
                              ELSE ROW_NUMBER() OVER(ORDER BY points DESC,
                                                              fragPctWindow DESC)
                          END Ordering
								-- @IndexName=DBName+'.dbo.'+ObjectName+'.'+name
					  -- INTO IndexforRebuild
             FROM CSDBfragmentationInfo db
                  CROSS APPLY
             (
                 SELECT TOP 1 CPU_Utlization
                 FROM @cpu_util
                 ORDER BY ID DESC
             ) AS b
                  JOIN CPU ON db.Points BETWEEN cpu.LowPoint AND cpu.HighPoint
             WHERE(b.Cpu_utlization BETWEEN CPURAngeLow AND CpuRangeHigh)
                  AND Status = 0
                  AND ErrorCode = 0
             ORDER BY Ordering ASC --points desc,fragPctWindow desc
             )
             SELECT @DBName = DBName,
                    @IndexName = Name,
                    @ObjectName = ObjectName
             FROM
             (
                 SELECT DbName,
                        ObjectName,
                        Name,
                        Ordering
                 FROM DefragIndexList
                 UNION																--- So when range is exhaused it picks one row
                 SELECT TOP 1 DbName,
                              ObjectName,
                              Name,
                              CASE
                                  WHEN CPU_Utlization > 50
                                  THEN ROW_NUMBER() OVER(ORDER BY points ASC,
                                                                  fragPctWindow ASC)
                                  ELSE ROW_NUMBER() OVER(ORDER BY points DESC,
                                                                  fragPctWindow DESC)
                              END Ordering
                 FROM CSDBfragmentationInfo
                      CROSS APPLY
                 (
                     SELECT TOP 1 CPU_Utlization
                     FROM @cpu_util
                     ORDER BY ID DESC
                 ) AS b
                 WHERE NOT EXISTS
                 (
                     SELECT 1
                     FROM DefragIndexList
                 )
                       AND Status = 0
                       AND ErrorCode = 0
                       AND b.CPU_Utlization < 70
                 ORDER BY Ordering ASC
             ) b;  --points asc,fragPctWindow asc ) b
        SELECT @FullIndexName = @Dbname+'.dbo.'+@ObJectname+'.'+@IndexName;
		IF @FullIndexName is NULL
		BEGIN
					 UPDATE CSDbIndexMaintOps  SET       CurrentStatus = 0 ,LastUpdated=@Nowdate;
					 BREAK;
		END
			--	select * from DBFragmentationInfo order by points desc
        BEGIN TRY
            SELECT @IndexOrgOpStartTime = GETUTCDATE();
            EXECUTE dbo.IndexOptimize
                    @Databases = @Databases,
                    @Fragmentationlow = @Fragmentationlow,
                    @FragmentationMedium = @FragmentationMedium,
                    @FragmentationHigh = @FragmentationHigh,
                    @FragmentationLevel1 = @FragmentationLevel1,
                    @FragmentationLevel2 = @FragmentationLevel2,
                    @PageCountLevel = @PageCountLevel,
                    @Indexes = @FullIndexName,
                    @LockTimeout = @LockTimeout,
                    @WaitAtLowPriorityMaxDuration = @WaitAtLowPriorityMaxDuration,
                    @WaitAtLowPriorityAbortAfterWait = @WaitAtLowPriorityAbortAfterWait,
					@MaxDOP = @MaxDOP,
					@FillFactor=@FillFactor,
					@UpdateStatistics=@UpdateStatistics,
				    @OnlyModifiedStatistics=@OnlyModifiedStatistics
           UPDATE C
              SET
                  IndexOrgOpStartTime = @IndexOrgOpStartTime,
                  IndexOrgOpEndTime = GETUTCDATE(),
                  Status = 1,
                  PostFragPercent = ROUND(b.avg_fragmentation_in_percent, 2),
                  PostFragment_Count = b.fragment_count,
                  PostFragment_Pagecount = b.page_count
            FROM CSDBfragmentationInfo C
                 CROSS APPLY sys.dm_db_index_physical_stats(c.DbID, c.ObjectID, c.Index_ID, NULL, NULL) B
            WHERE DBName = @Dbname
                  AND Objectname = @ObjectName
                  AND name = @IndexName;
            SELECT @IndexCounter = @IndexCounter + 1;
        END TRY
        BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
          BEGIN
            SELECT @Error = ERROR_NUMBER(),
                   @ErrMsg = ERROR_MESSAGE()
		  END
            UPDATE CSDBfragmentationInfo
              SET
                  Status = 1,
                  ErrorCode = 1,
                  errordescription = @ErrMsg,
                  IndexOrgOpStartTime = @IndexOrgOpStartTime,
                  IndexOrgOpEndTime = GETUTCDATE()
            WHERE DBName = @Dbname
                  AND Objectname = @ObjectName
                  AND name = @IndexName;
            --SELECT @IndexCounter = @IndexCounter + 1;
        END CATCH;
    END;
LOGINFO:
INSERT INTO CSDBMaintenanceSummaryView
(DBID,
 DBName,
 ObjectID,
 Objectname,
 index_id,
 NAME,
 type,
 fill_factor,
 rows,
 FragPercent,
 fragPctWindow,
 page_count,
 fragment_count,
 IndexOrgOpStartTime,
 IndexOrgOpEndTime,
 PostFragPercent,
 PostFragment_Count,
 PostFragment_Pagecount,
 Points,
 Status,
 ErrorCode,
 ErrorDescription,
 BatchID,
 BatchStartDate,
 LastUpdated
)
       SELECT DBID,
              DBName,
              ObjectID,
              Objectname,
              index_id,
              NAME,
              type,
              fill_factor,
              rows,
              ROUND(FragPercent,0),
              fragPctWindow,
              page_count,
              fragment_count,
              IndexOrgOpStartTime,
              IndexOrgOpEndTime,
              PostFragPercent,
              PostFragment_Count,
              PostFragment_Pagecount,
              Points,
              Status,
              ErrorCode,
              ErrorDescription,
			  BatchID,
			  BatchStartDate,
			  @Nowdate
       FROM CSDBfragmentationInfo CROSS APPLY (SELECT BatchID,BatchStartDate  FROM CSDbIndexMaintOps) b
       WHERE Status > 0
DELETE FROM CSDBfragmentationInfo
WHERE status > 0;
 UPDATE CSDbIndexMaintOps
  SET
       CurrentStatus = 0 ,LastUpdated=@Nowdate;
END

IF EXISTS (select * from GxQscripts where name = 'CSProactiveDBMaintainance')
	delete from GxQscripts where name = 'CSProactiveDBMaintainance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CSProactiveDBMaintainance')
	delete from GXDBVersions where aliasname = 'CSProactiveDBMaintainance'
GO

insert into GXDBVersions values(2, 'CSProactiveDBMaintainance',  '00000000000000000000', 'CSProactiveDBMaintainance', '00000000000000000000')
GO

