

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CRUpdateCommcellReportAssociation.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CRUpdateCommcellReportAssociation.sp,v $ $Id: CRUpdateCommcellReportAssociation.sp,v 1.4.80.1 2018/03/20 00:38:50 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CRUpdateCommcellReportAssociation <<<'

IF EXISTS (select * from sysobjects where name='CRUpdateCommcellReportAssociation')
	drop procedure CRUpdateCommcellReportAssociation
IF EXISTS (select * from GxQscripts where name='CRUpdateCommcellReportAssociation')
	delete from GxQscripts where name = 'CRUpdateCommcellReportAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CRUpdateCommcellReportAssociation')
	delete from GXDBVersions where aliasname = 'CRUpdateCommcellReportAssociation'
GO
print '... Creating Procedure: CRUpdateCommcellReportAssociation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CRUpdateCommcellReportAssociation
  @reportList NVARCHAR(MAX) = N'', 
  @csId INTEGER = 0
AS
	SET NOCOUNT ON
	--If commcell ID is invalid, do nothing
	IF NOT EXISTS(SELECT * FROM APP_CommCell WHERE id = @csId) AND NOT EXISTS(SELECT * FROM CVConnections WHERE ID = @csId)
		RETURN
	DECLARE @SplitChar VARCHAR(10) = ',';
	--Tokenize the reports listed in the input
	DECLARE @reports TABLE ( reportId INT);
	IF CHARINDEX( @SplitChar, @reportList ) = 0
	BEGIN
		INSERT INTO @reports select CAST(@reportList as int)
	END
	ELSE
	BEGIN
		WITH StrINgToSplit AS (
		  SELECT
			  LTRIM( RTRIM( SUBSTRING( @reportList, 1, CHARINDEX( @SplitChar, @reportList ) - 1 ) ) ) Head
			, SUBSTRING( @reportList, CHARINDEX( @SplitChar, @reportList ) + 1, LEN( @reportList ) ) Tail
		  UNION ALL
		  SELECT
			  LTRIM( RTRIM( SUBSTRING( Tail, 1, CHARINDEX( @SplitChar, Tail ) - 1 ) ) ) Head
			, SUBSTRING( Tail, CHARINDEX( @SplitChar, Tail ) + 1, LEN( Tail ) ) Tail
		  FROM StrINgToSplit
		  WHERE CHARINDEX( @SplitChar, Tail ) > 0
		  UNION ALL
		  SELECT
			  LTRIM( RTRIM( Tail ) ) Head
			, '' Tail
		  FROM StrINgToSplit
		  WHERE CHARINDEX( @SplitChar, Tail ) = 0
			AND LEN( Tail ) > 0
		)
		INSERT INTO @reports SELECT CAST(Head AS INT) FROM StrINgToSplit
	END
	--Get the reportid commcellid map from CustomReports, by tokenizing DBConnectionName
	DECLARE @repCSMap TABLE (
		reportId INT,
		commcellId INT);
	WITH StrINgToSplit AS (
	  SELECT
		ID
		,  LTRIM( RTRIM( SUBSTRING( DBConnectionName, 1, CHARINDEX( @SplitChar, DBConnectionName ) - 1 ) ) ) Head
		, SUBSTRING( DBConnectionName, CHARINDEX( @SplitChar, DBConnectionName ) + 1, LEN( DBConnectionName ) ) Tail
	  FROM CustomReports
	  WHERE CHARINDEX( @SplitChar, DBConnectionName ) <> 0
	  UNION ALL
	  SELECT
		  ID
		, LTRIM( RTRIM( SUBSTRING( Tail, 1, CHARINDEX( @SplitChar, Tail ) - 1 ) ) ) Head
		, SUBSTRING( Tail, CHARINDEX( @SplitChar, Tail ) + 1, LEN( Tail ) ) Tail
	  FROM StrINgToSplit
	  WHERE CHARINDEX( @SplitChar, Tail ) > 0
	  UNION ALL
	  SELECT
		ID
		, LTRIM( RTRIM( Tail ) ) Head
		, '' Tail
	  FROM StrINgToSplit
	  WHERE CHARINDEX( @SplitChar, Tail ) = 0
		AND LEN( Tail ) > 0
	)
	INSERT INTO @repCSMap SELECT CAST(ID AS INT), CAST(Head AS INT) FROM StrINgToSplit order by CAST(ID AS INT), CAST(Head AS INT)
	--insert the reportid commcell map for records where there only os commcell associated
	--these records will not be updated by tokenizing logic
	INSERT INTO @repCSMap
	SELECT CAST(ID AS INT), CAST(DBConnectionName AS INT ) FROM CustomReports WHERE CHARINDEX( @SplitChar, DBConnectionName ) = 0 AND ISNULL(DBConnectionName, '') <> ''
	--reports with empty  DBConnectionName are associated with default commcell, for commserv reports (CSID > 100000 are non commserv data sources)
	if (@csId < 100000)
		INSERT INTO @repCSMap
		select CAST(ID AS INT), 2 FROM CustomReports where DBConnectionName = ''
	--create the reportid commcellid map for reports that need to be updated
	DECLARE @retCSMap TABLE (
		reportId INT,
		commcellId INT);
	INSERT INTO @retCSMap SELECT reportId, commcellId FROM @repCSMap
	--Insert the the new reports for the given report id
	INSERT INTO @retCSMap SELECT reportId, @csId FROM @reports WHERE reportId NOT IN (SELECT reportId from @retCSMap WHERE commcellId = @csId)
	--delete the unneeded report entries from the reports to be updated
	DELETE FROM @retCSMap WHERE reportId not IN (SELECT reportId FROM @reports )
	--insert the entries for reports which are no longer associated with the commcell
	INSERT INTO @retCSMap
	SELECT reportId, commcellId FROM @repCSMap WHERE reportId IN
	(SELECT reportId FROM @repCSMap WHERE commcellId = @csId AND reportId not IN (SELECT reportId FROM @reports)) AND commcellId <> @csId
	--insert reports that need to be updated as cs is not associated with it
	INSERT INTO @reports
	SELECT reportId FROM @repCSMap WHERE commcellId = @csId AND reportId not IN (SELECT reportId FROM @reports)
	UPDATE CustomReports   SET DBConnectionName = R.MemberList
	FROM CustomReports C
	INNER JOIN
	(SELECT
	   m1.reportId AS repid,
	   MemberList = SUBSTRING((SELECT ( ',' + CAST(commcellId AS nVARCHAR(10)) )
							   FROM @retCSMap m2
							   WHERE m1.reportId = m2.reportId
							   ORDER BY
								  reportId,
								  CAST(commcellId AS nVARCHAR(10) )
							   FOR XML PATH( '' )
							  ), 2, 1000 )FROM @retCSMap m1
	WHERE reportId IN (SELECT reportId FROM @reports)
	GROUP BY reportId ) R
	on C.ID = R.repid
	UPDATE CustomReports SET DBConnectionName = '' where ID in (SELECT reportId FROM @reports WHERE reportId NOT IN (select reportId from @retCSMap))
GO

IF EXISTS (select * from GxQscripts where name = 'CRUpdateCommcellReportAssociation')
	delete from GxQscripts where name = 'CRUpdateCommcellReportAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CRUpdateCommcellReportAssociation')
	delete from GXDBVersions where aliasname = 'CRUpdateCommcellReportAssociation'
GO

insert into GXDBVersions values(2, 'CRUpdateCommcellReportAssociation',  '00010004008000010000', 'CRUpdateCommcellReportAssociation', '00010004008000010000')
GO

