

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CRGetCommcellReportAssociation.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CRGetCommcellReportAssociation.sp,v $ $Id: CRGetCommcellReportAssociation.sp,v 1.3.86.1 2018/03/20 00:29:21 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CRGetCommcellReportAssociation <<<'

IF EXISTS (select * from sysobjects where name='CRGetCommcellReportAssociation')
	drop procedure CRGetCommcellReportAssociation
IF EXISTS (select * from GxQscripts where name='CRGetCommcellReportAssociation')
	delete from GxQscripts where name = 'CRGetCommcellReportAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CRGetCommcellReportAssociation')
	delete from GXDBVersions where aliasname = 'CRGetCommcellReportAssociation'
GO
print '... Creating Procedure: CRGetCommcellReportAssociation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CRGetCommcellReportAssociation
  @csId INTEGER = 0
AS
	SET NOCOUNT ON
	--If commcell ID is invalid, do nothing
	IF NOT EXISTS(SELECT * FROM APP_CommCell WHERE id = @csId) AND NOT EXISTS(SELECT * FROM CVConnections WHERE ID = @csId)
		RETURN
	DECLARE @SplitChar VARCHAR(10) = ',';
	--Get the reportid commcellid map from CustomReports, by tokenizing DBConnectionName
	DECLARE @repCSMap TABLE (
		reportId INT,
		commcellId INT);
	WITH StrINgToSplit AS (
	  SELECT
		ID
		,  LTRIM( RTRIM( SUBSTRING( DBConnectionName, 1, CHARINDEX( @SplitChar, DBConnectionName ) - 1 ) ) ) Head
		, SUBSTRING( DBConnectionName, CHARINDEX( @SplitChar, DBConnectionName ) + 1, LEN( DBConnectionName ) ) Tail
	  FROM CustomReports
	  WHERE CHARINDEX( @SplitChar, DBConnectionName ) <> 0
	  UNION ALL
	  SELECT
		  ID
		, LTRIM( RTRIM( SUBSTRING( Tail, 1, CHARINDEX( @SplitChar, Tail ) - 1 ) ) ) Head
		, SUBSTRING( Tail, CHARINDEX( @SplitChar, Tail ) + 1, LEN( Tail ) ) Tail
	  FROM StrINgToSplit
	  WHERE CHARINDEX( @SplitChar, Tail ) > 0
	  UNION ALL
	  SELECT
		ID
		, LTRIM( RTRIM( Tail ) ) Head
		, '' Tail
	  FROM StrINgToSplit
	  WHERE CHARINDEX( @SplitChar, Tail ) = 0
		AND LEN( Tail ) > 0
	)
	INSERT INTO @repCSMap SELECT CAST(ID AS INT), CAST(Head AS INT) FROM StrINgToSplit order by CAST(ID AS INT), CAST(Head AS INT)
	--insert the reportid commcell map for records where there only os commcell associated
	--these records will not be updated by tokenizing logic
	INSERT INTO @repCSMap
	SELECT CAST(ID AS INT), CAST(DBConnectionName AS INT ) FROM CustomReports WHERE CHARINDEX( @SplitChar, DBConnectionName ) = 0 AND ISNULL(DBConnectionName, '') <> ''
	--reports with empty  DBConnectionName are associated with default commcell
	INSERT INTO @repCSMap
	select CAST(ID AS INT), 2 FROM CustomReports where DBConnectionName = ''
	SELECT ID, EntityLabel FROM CustomReports where ID in (select reportId from @repCSMap where commcellId = @csId) ORDER BY ID
GO

IF EXISTS (select * from GxQscripts where name = 'CRGetCommcellReportAssociation')
	delete from GxQscripts where name = 'CRGetCommcellReportAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CRGetCommcellReportAssociation')
	delete from GXDBVersions where aliasname = 'CRGetCommcellReportAssociation'
GO

insert into GXDBVersions values(2, 'CRGetCommcellReportAssociation',  '00010003008600010000', 'CRGetCommcellReportAssociation', '00010003008600010000')
GO

