

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CNCCRPopulate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CNCCRPopulate.sp,v $ $Id: CNCCRPopulate.sp,v 1.13.180.1 2018/03/20 00:32:30 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: CNCCRPopulate
--  |
--  | Description:
--  |   Used to Populate subclient into CCRToSubClient table
--  |	for SubClient Readiness Check, It is used for QNet Server
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Chandru  Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CNCCRPopulate <<<'

IF EXISTS (select * from sysobjects where name='CNCCRPopulate')
	drop procedure CNCCRPopulate
IF EXISTS (select * from GxQscripts where name='CNCCRPopulate')
	delete from GxQscripts where name = 'CNCCRPopulate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CNCCRPopulate')
	delete from GXDBVersions where aliasname = 'CNCCRPopulate'
GO
print '... Creating Procedure: CNCCRPopulate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CNCCRPopulate
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--DECLARE	@retVal		INTEGER
--To disable the CCR Check from Commnet and also to give an ability for the user to re-enable it.
--Bheemesh & Rajesh 03/28/2011
DECLARE @val integer
DECLARE @temp nvarchar
SET @retVal = -1
SET @val = 0
SET @temp = ''
SET @temp = ISNULL((select value from GXGlobalParam where name = 'Re-Enable CCRCheck With CommNet'), '')
IF (@temp <> '')
BEGIN
	SET @val = CONVERT (int, @temp)
END
IF(@val <> 1)
BEGIN
	DELETE FROM CCRToSubClient WHERE CCRId = 1
	GOTO SKIP_POPULATION
END
DECLARE	@CCRId		INTEGER
SET	@CCRID		= 1 -- Default for QNet Agent
DECLARE	@Stats		INTEGER
DECLARE	@StatsTime	DATETIME
SET @Stats	 	= 0
IF object_id('tempdb.dbo.#CNCCRPopulate_DATAPATH') IS NOT null DROP TABLE #CNCCRPopulate_DATAPATH
IF object_id('tempdb.dbo.#CNCCRPopulate_SC') IS NOT null DROP TABLE #CNCCRPopulate_SC
IF object_id('tempdb.dbo.#CNCCRPopulate_SC_DataPath') IS NOT null DROP TABLE #CNCCRPopulate_SC_DataPath
IF object_id('tempdb.dbo.#CNCCRPopulate_Stats') IS NOT null DROP TABLE #CNCCRPopulate_Stats
IF object_id('tempdb.dbo.#tempCCRToSubClient') IS NOT null DROP TABLE #tempCCRToSubClient
-- Statistics Support
IF @Stats = 1 CREATE TABLE #CNCCRPopulate_Stats (type varchar(50), timeSpentMili int)
CREATE TABLE #CNCCRPopulate_DATAPATH(
		dataPathId		integer,
		drivePoolId		integer,
		drivePoolName		varchar(256),
		drivePoolType		integer,
		mediaAgentId		integer,
		NDMPHostId		integer,
		mediaAgentName		varchar(256),
		libraryId		integer,
		libraryName		varchar(256),
		libraryAliasName	varchar(256),
		libraryType		integer,
		clientInterface		varchar(256),
		mediaAgentInterface	varchar(256),
		HWCompression		integer,
		DataPathFlag		integer,
		numRows			integer,
		archGroupId		integer,
		clientId		integer
)
CREATE TABLE #CNCCRPopulate_SC (
		SubClientID	integer,
		ClientID	integer,
		AppTypeID	integer,
		InstanceID	integer,
		DataArchGrpID	integer,
		LogArchGrpID	integer,
		SubClientName	varchar(256)
)
CREATE TABLE #CNCCRPopulate_SC_DataPath (
		ID			integer IDENTITY(1, 1),
		SubClientID		integer,
		ClientID		integer,
		AppTypeID		integer,
		ArchGrpID		integer
)
IF @Stats = 1 SET @StatsTime = GetDate()
-- get subclient list
INSERT	INTO #CNCCRPopulate_SC
SELECT	SubClientID = id, clientId, appTypeId,
		InstanceID = instance, dataArchGrpId,logArchGrpId,subclientName
FROM	APP_Application
WITH	(READUNCOMMITTED)
WHERE	(subclientStatus&2)=0 AND (subclientStatus&4)=0
		AND AppTypeID < 1000
-- remove the hidden subclients
DELETE	#CNCCRPopulate_SC
FROM	#CNCCRPopulate_SC
WHERE	appTypeId IN (25,27,31,47,50,58,65,67,68)
		AND subClientName='default'
DELETE	#CNCCRPopulate_SC
FROM	#CNCCRPopulate_SC, APP_InstanceName
WITH	(READUNCOMMITTED)
WHERE	id = InstanceID
		AND name='defaultDummyInstanceForOracle'
IF @Stats = 1 INSERT INTO #CNCCRPopulate_Stats VALUES ('Populate Subclients', datediff(millisecond, @StatsTime, GetDate()))
IF @Stats = 1 SET @StatsTime = GetDate()
-- get the list with subclient, storage policy pair
INSERT INTO #CNCCRPopulate_SC_DataPath
SELECT	subClientId, clientId, appTypeId, archGrpId = dataArchGrpId
FROM	#CNCCRPopulate_SC
--SET IDENTITY_INSERT #CNCCRPopulate_SC_DataPath ON
INSERT INTO #CNCCRPopulate_SC_DataPath (subClientId, clientId, appTypeId, archGrpId)
SELECT	subClientId, clientId, appTypeId, logArchGrpId
FROM	#CNCCRPopulate_SC
WHERE	dataArchGrpId <> logArchGrpId
--SET IDENTITY_INSERT #CNCCRPopulate_SC_DataPath OFF
IF @Stats = 1 INSERT INTO #CNCCRPopulate_Stats VALUES ('Populate SC-Datapath', datediff(millisecond, @StatsTime, GetDate()))
IF @Stats = 1 SET @StatsTime = GetDate()
-- get data path
DECLARE @clientId	INTEGER
DECLARE @archGrpId	INTEGER
DECLARE dataPathListCCR CURSOR FOR
 	SELECT DISTINCT clientId, archGrpId FROM #CNCCRPopulate_SC_DataPath
OPEN dataPathListCCR
FETCH NEXT FROM dataPathListCCR INTO @clientId,@archGrpId
WHILE @@FETCH_STATUS <> -1
BEGIN
	INSERT INTO #CNCCRPopulate_DATAPATH
	EXEC getdataPathsForSubClient @archGrpId, @clientId, 1
	FETCH NEXT FROM dataPathListCCR INTO @clientId,@archGrpId
END
CLOSE dataPathListCCR
DEALLOCATE dataPathListCCR
IF @Stats = 1 INSERT INTO #CNCCRPopulate_Stats VALUES ('Populate CCR-Datapath', datediff(millisecond, @StatsTime, GetDate()))
--IF @Stats = 1 SET @StatsTime = GetDate()
--DELETE	FROM	CCRToSubClient
--WHERE	NOT EXISTS ( SELECT *
--		FROM	#CNCCRPopulate_SC_DataPath A, #CNCCRPopulate_DATAPATH t
--		WHERE	 A.clientId=t.clientId
--				AND A.archGrpId=t.archGroupId
--				AND @CCRID = CCRToSubClient.CCRId
--				AND A.clientId = CCRToSubClient.clientId
--				AND A.subClientId = CCRToSubClient.SubClientID
--				AND t.DataPathID = CCRToSubClient.DataPathID)
--IF @Stats = 1 INSERT INTO #CNCCRPopulate_Stats VALUES ('DELETE CCRToSubClient', datediff(millisecond, @StatsTime, GetDate()))
--IF @Stats = 1 SET @StatsTime = GetDate()
--DELETE FROM #CNCCRPopulate_SC_DataPath
--WHERE	#CNCCRPopulate_SC_DataPath.SubClientID IN (SELECT CCRToSubClient.SubClientID FROM CCRToSubClient WHERE	CCRToSubClient.CCRId = @CCRID)
--INSERT INTO CCRToSubClient
--SELECT	@CCRID, A.clientId, A.subClientId, t.dataPathId, 0, 0, 0, 0, appTypeId
--FROM	#CNCCRPopulate_SC_DataPath A, #CNCCRPopulate_DATAPATH t
--WHERE	A.clientId=t.clientId
--		AND A.archGrpId=t.archGroupId
--IF @Stats = 1 INSERT INTO #CNCCRPopulate_Stats VALUES ('INSERT CCRToSubClient', datediff(millisecond, @StatsTime, GetDate()))
IF @Stats = 1 SET @StatsTime = GetDate()
SELECT * into #tempCCRToSubClient
FROM CCRToSubClient
WHERE 1 = 0
INSERT INTO #tempCCRToSubClient
SELECT	@CCRID, A.clientId, A.subClientId, t.dataPathId, 0, 0, 0, 0, appTypeId, 0
FROM	#CNCCRPopulate_SC_DataPath A, #CNCCRPopulate_DATAPATH t
WHERE	A.clientId=t.clientId
		AND A.archGrpId=t.archGroupId
-- forward port form 8.0. Original changes made by Milind for R8 (formid:07288)
-- Remove rows from CCRToSubClient that dont exist in #tempCCRToSubClient for CCCRId = 1
DELETE FROM CCRToSubClient WHERE CCRId = 1 AND NOT EXISTS
(SELECT  * FROM #tempCCRToSubClient T WHERE  T.ClientID = CCRToSubClient.ClientID
	AND T.SubClientId  = CCRToSubClient.SubClientId AND T.DataPathId  = CCRToSubClient.DataPathId
AND T.CCRId = 1)
--remove duplicate rows
DELETE #tempCCRToSubClient from #tempCCRToSubClient t, CCRToSubClient C
WHERE C.SubClientID =t.SubClientID and C.clientId = t.clientId and C.dataPathId =t.dataPathId
		and C.ccrid = 1
INSERT INTO CCRToSubClient
SELECT * from #tempCCRToSubClient
IF @Stats = 1 INSERT INTO #CNCCRPopulate_Stats VALUES ('INSERT CCRToSubClient', datediff(millisecond, @StatsTime, GetDate()))
UPDATE	CCRCommCellReadiness
SET		CCRStartTime = dbo.GetUnixTime(GetUTCDate())
WHERE	CCRId = 1
DROP TABLE #CNCCRPopulate_DATAPATH
DROP TABLE #CNCCRPopulate_SC
DROP TABLE #CNCCRPopulate_SC_DataPath
DROP TABLE #tempCCRToSubClient
-- ----------------------------------------------------------------------------
--   STATS
-- ----------------------------------------------------------------------------
IF @Stats = 1
BEGIN
	SELECT * FROM #CNCCRPopulate_Stats
	DROP TABLE #CNCCRPopulate_Stats
END
SET @retVal = @@ERROR
SKIP_POPULATION:
SELECT @retVal
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'CNCCRPopulate')
	delete from GxQscripts where name = 'CNCCRPopulate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CNCCRPopulate')
	delete from GXDBVersions where aliasname = 'CNCCRPopulate'
GO

insert into GXDBVersions values(2, 'CNCCRPopulate',  '00010013018000010000', 'CNCCRPopulate', '00010013018000010000')
GO

