

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CN2SetRunningJobsInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2010  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CN2SetRunningJobsInfo')
BEGIN
	print '>>> Drop Stored Procedure: CN2SetRunningJobsInfo <<<'
	drop procedure CN2SetRunningJobsInfo
END
IF EXISTS (select * from GxQscripts where name='CN2SetRunningJobsInfo')
	delete from GxQscripts where name = 'CN2SetRunningJobsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CN2SetRunningJobsInfo')
	delete from GXDBVersions where aliasname = 'CN2SetRunningJobsInfo'
GO
print '... Creating Procedure: CN2SetRunningJobsInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CN2SetRunningJobsInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ForeignCCID int,
  @jobsXML NVARCHAR(MAX)
AS
BEGIN
-- Throw the first one away :-) .... DONE   (Until you get better at it .. not there yet?).
DECLARE	  @idoc			integer
DECLARE   @curJobGatherTime			INTEGER
DECLARE	  @lastJobStateChangeTime	BIGINT
DECLARE	  @stTimeMagic				BIGINT
-- SET @ForeignCCID = 3
--SET @jobsXML  = N'<CommNet2_CN2FastSyncRunningJobs>
 -- <lastJobUpdateTime timeVal="1287664265" />
 -- <JMJobInfo>
 --   <job jobId="117" initFrom="2" opType="4" userId="1" clientPriority="6" opPriority="1" appPriority="6" combPriority="166" currentPhase="7" jobStartTime="1287664192" attemptStartTime="1287664259" serverEndTime="-1" jobElapsedTime="63" elapsedTime="63" lastStartOrRun="1287664258" phaseParams="  -ab 0 -r 1287664202  -c 0 -appType 42" restartString="" startAttempts="1" runAttempts="1" state="1" pendingCause="5" restartable="1" appArgs="" numOfFailures="0" failureReason="" preemptable="1" taskLinkID="1" percentcomplete="25" displayState="1" commCellId="2" resourcesAllocated="1" currentContext="0" libraryList="hercule_disklib" driveList="Folder_New" opUsername="" phaseOnSuccess="0" interruptedPhase="0" errorType="0" licenseVerified="0" currentPhaseName="Backup" timeToComplete="0" lastUpdateFromClient="1287664259" lastStateChangeTime="2765237940316537359" jobCategory="1" recoveredFromServiceRestart="0" noOfGUIMonitors="0" isScheduledAlert="0" jobBasedAlertId="0" alertName=" " shortMediaAgent="hercule" seqNumber="0" activeFile="" guiAlertColorLevel="0" jobDescription="" xmlJobInfo="&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot; ?&gt;&lt;JobManager_BkpJobDetailsXml appType=&quot;42&quot; compType=&quot;2&quot; jobType=&quot;1&quot;/&gt;" subOpType="0" foreignToken="" preparedJobId="0" />
 --   <job jobId="118" initFrom="2" opType="11" userId="1" clientPriority="9" opPriority="0" appPriority="9" combPriority="66" currentPhase="8" jobStartTime="1287664198" attemptStartTime="1287664232" serverEndTime="-1" jobElapsedTime="29" elapsedTime="29" lastStartOrRun="1287664232" phaseParams="" restartString="" startAttempts="1" runAttempts="1" state="1" pendingCause="5" restartable="1" appArgs="" numOfFailures="0" failureReason="" preemptable="1" taskLinkID="1" percentcomplete="50" displayState="1" commCellId="2" resourcesAllocated="1" currentContext="0" libraryList="hercule_disklib" driveList="Folder_New" opUsername="" phaseOnSuccess="0" interruptedPhase="0" errorType="0" licenseVerified="0" currentPhaseName="Backup" timeToComplete="-1" lastUpdateFromClient="1287664245" lastStateChangeTime="2765237910251765772" jobCategory="3" recoveredFromServiceRestart="0" noOfGUIMonitors="0" isScheduledAlert="0" jobBasedAlertId="0" alertName=" " shortMediaAgent="" seqNumber="0" activeFile="" guiAlertColorLevel="0" jobDescription="" xmlJobInfo="" subOpType="0" foreignToken="" preparedJobId="0" />
 -- </JMJobInfo>
 -- <JMJobStats>
  --  <job jobId="117" status="1" opType="4" commCellId="2" jobCategory="1" jobDescription="" xmlJobInfo="&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot; ?&gt;&lt;JobManager_BkpJobDetailsXml appType=&quot;42&quot; compType=&quot;2&quot; jobType=&quot;1&quot;/&gt;" subOpType="0" foreignToken="" />
  --  <job jobId="118" status="1" opType="11" commCellId="2" jobCategory="3" jobDescription="" xmlJobInfo="" subOpType="0" foreignToken="" />
 -- </JMJobStats>
 -- <JMBkpJobInfo>
 --   <job jobId="117" commcellId="2" applicationId="7" numStreams="1" currentPolicy="3" targetCopyList="2:" bkpLevel="2" indexOverride="0" startNewMedia="0" compBytes="0" unCompBytes="0" filesToXfer="6" backupTaskId="71" scanFileFailures="0" scanFolderFailures="0" backupFileFailures="0" backupFolderFailures="0" shadowCopyId="" bkpOptions="6296576" oraSubLevel="0" bkpattributes="0" dataPolicy="3" logPolicy="0" filesXfered="0" currentThroughput="0.000000000000000e+000" averageThroughput="0.000000000000000e+000" filesIndexed="0" filesFailedToIndex="0" filesSkippedForIndex="0" contentIndexDBSize="0" totalMediaUsageTime="0" mediaAgentName="hercule.gp.cv.commvault.com" scanType="3" scanTypeChangeReason="" numStreamsAllocated="1" maxRestarts="144" restartInterval="1200" cloudId="0" diffPolicy="0" targetClientId="0" unCompBytesToXfer="0" secondaryBkpLevel="0" jobIdActedOn="0" fromTime="0" toTime="0" nwTransBytes="0" />
 -- </JMBkpJobInfo>
 -- <JMBkpAttemptInfo>
 --   <at jobId="117" attemptNum="1" phaseNum="4" phaseName="Scan" status="1" startTime="1287664194" endTime="1287664257" elapsedTime="63" unCompBytes="0" compBytes="0" numFiles="0" failureReason="" writeTime="0" restartString="" attributes="7" numFolders="0" archGrpId="0" archGroupName="" copyId="0" copyName="" mediaAgent="" libraryName="" drivePoolName="" maxStreamsUsed="0" nwTransBytes="0" />
 -- </JMBkpAttemptInfo>
--  <JMAdminJobInfoTable>
 --   <job jobId="118" opType="11" status="0" servStart="1287664198" servEnd="-1" archGrpID="2" archGrpName="CommServeDR(hercule)" AP_NumDays="0" AP_IsForecast="0" AP_SeqNum="0" AC_NewMediaFlag="0" ER_BkpLevel="1" ER_DbName="commserv" ER_Destination="G:\DR" ER_SendCount="0" ER_MediasUsed="" TotalObjects="0" ObjectsDone="0" ObjectsFailed="0" archGrpCopyID="0" LibraryID="0" MI_InventoryType="0" currentWriteTime="0" noOfStreams="0" appID="0" dependantJobId="0" workFlowId="0" srcMediaAgent="" destMediaAgent="hercule.gp.cv.commvault.com" drivePoolId="0" mediaId="0" sourceJobId="0" TotalSize="0" noOfStreamsAllocated="0" maxRestarts="144" restartInterval="1200" embeddedObjects="0" uncompBytes="0" numFiles="0" skippedItems="0" writeTime="0" reportType="0" cloudId="0" reportSetId="0" reportName="" reportSetName="" fromTime="0" toTime="0" subTaskId="72" otherOpName="" nwTransBytes="0" />
 -- </JMAdminJobInfoTable>
 -- <JMAdminJobAttemptInfoTable>
  --  <job jobId="118" attemptNum="1" phaseNum="1" phaseName="Backup To Disk" status="1" startTime="1287664198" endTime="1287664226" elapsedTime="28" failureReason="" writeTime="0" embeddedObjects="0" uncompBytes="0" numFiles="0" skippedItems="0" TotalSize="0" nwTransBytes="0" />
  --  <job jobId="118" attemptNum="1" phaseNum="5" phaseName="Scan" status="1" startTime="1287664227" endTime="1287664228" elapsedTime="1" failureReason="" writeTime="0" embeddedObjects="0" uncompBytes="0" numFiles="0" skippedItems="0" TotalSize="0" nwTransBytes="0" />
  --</JMAdminJobAttemptInfoTable>
  --<appidguidmap>
   -- <itm appID="7" guid="39CCADD3-6BED-48B7-9402-D9981880FF6A" />
  --</appidguidmap>
  --<respjobstatus />
--</CommNet2_CN2FastSyncRunningJobs>
IF OBJECT_ID('tempdb.dbo.#CN2JMJobInfoTemp') is not null DROP TABLE #CN2JMJobInfoTemp
IF OBJECT_ID('tempdb.dbo.#CN2SubClientGUIDMap') is not null DROP TABLE #CN2SubClientGUIDMap
IF OBJECT_ID('tempdb.dbo.#CN2JMBkpJobInfoTemp') is not null DROP TABLE #CN2JMBkpJobInfoTemp
-- if object_id('tempdb.dbo.#CN2SubClientInfoTemp') is not null DROP TABLE #CN2SubClientInfoTemp
IF OBJECT_ID('tempdb.dbo.#CN2JMJobStatsTemp') is not null DROP TABLE #CN2JMJobStatsTemp
IF OBJECT_ID('tempdb.dbo.#CN2JMBkpAttemptInfoTemp') is not null DROP TABLE #CN2JMBkpAttemptInfoTemp
IF OBJECT_ID('tempdb.dbo.#CN2JMJobStatsReqTemp') is not null DROP TABLE #CN2JMJobStatsReqTemp
IF OBJECT_ID('tempdb.dbo.#CN2Jobs') is not null DROP TABLE #CN2Jobs
IF OBJECT_ID('tempdb.dbo.#CN2JobCategory') is not null DROP TABLE #CN2JobCategory
IF OBJECT_ID('tempdb.dbo.#CN2JMAdminJobInfoTableTemp')  is not null DROP TABLE #CN2JMAdminJobInfoTableTemp
IF OBJECT_ID('tempdb.dbo.#CN2JMAdminJobAttemptInfoTableTemp') is not null DROP TABLE #CN2JMAdminJobAttemptInfoTableTemp
IF OBJECT_ID('tempdb.dbo.#CN2JMJobStreamsTemp') is not null DROP TABLE #CN2JMJobStreamsTemp
IF OBJECT_ID('tempdb.dbo.#CN2JMJobCopyInfoTemp') is not null DROP TABLE #CN2JMJobCopyInfoTemp
IF OBJECT_ID('tempdb.dbo.#CN2BkpSetGUIDMap') is not null DROP TABLE #CN2BkpSetGUIDMap
IF OBJECT_ID('tempdb.dbo.#CN2InstanceGUIDMap') is not null DROP TABLE #CN2InstanceGUIDMap
IF OBJECT_ID('tempdb.dbo.#CN2JMRstJobInfoTemp') is not null DROP TABLE #CN2JMRstJobInfoTemp
IF OBJECT_ID('tempdb.dbo.#CN2JMRstAttemptInfoTemp') is not null DROP TABLE #CN2JMRstAttemptInfoTemp
DECLARE @lastJobUpdateTime INTEGER
-- CREATE TEMP TABLES
SELECT * INTO #CN2JMJobStatsTemp FROM JMJobStats WHERE 1 = 2
SELECT * INTO #CN2JMJobInfoTemp FROM JMJobInfo WHERE 1 = 2
--Backup Jobs tables
SELECT * INTO #CN2JMBkpJobInfoTemp FROM JMBkpJobInfo WHERE 1 = 2
SELECT * INTO #CN2JMBkpAttemptInfoTemp FROM JMBkpAttemptInfo WHERE 1 = 2
SELECT * INTO #CN2JMJobStreamsTemp FROM JMJobStreams WHERE 1 = 2
SELECT * INTO #CN2JMJobCopyInfoTemp FROM JMJobCopyInfo WHERE 1 = 2
-- Admin Job Tables
SELECT * INTO #CN2JMAdminJobInfoTableTemp FROM JMAdminJobInfoTable WHERE 1 = 2
SELECT * INTO #CN2JMAdminJobAttemptInfoTableTemp FROM JMAdminJobAttemptInfoTable WHERE 1 = 2
-- Restore Jobs tables
SELECT * INTO #CN2JMRstJobInfoTemp FROM JMRstJobInfo WHERE 1 = 2
SELECT * INTO #CN2JMRstAttemptInfoTemp FROM JMRstAttemptInfo WHERE 1 = 2
CREATE TABLE #CN2SubClientGUIDMap
(
  appID		INT,
  guid	uniqueidentifier
)
CREATE TABLE #CN2Jobs
(
  jobId		INTEGER,
  opType	INTEGER,
  category	INTEGER,
  isNew		INTEGER, -- to indicate that we are seeing this job for the first time.
  isBkpNew	INTEGER, -- to indicate that we are seeing this bkp job (in incoming bkp XML section) for the first time.
  isAdmNew	INTEGER, ---- to indicate that we are seeing this admin job (in incoming admin XML section) for the first time.
  noMap	INTEGER -- used to indicate we should not map this job.
)
-- Status of requested jobs
CREATE TABLE #CN2JMJobStatsReqTemp
(
	jobId			integer,
	status			integer,
	opType			integer,
	commCellId		integer,
	jobCategory		integer,
	jobDescription		nvarchar(max),
	xmlJobInfo			nvarchar(max),
	subOpType				integer,
	foreignToken		nvarchar(2048),
	cvJobStatus		integer
)
CREATE TABLE #CN2BkpSetGUIDMap
(
   bkpSetID		INT,
   bkpGUID		uniqueidentifier
)
CREATE TABLE #CN2InstanceGUIDMap
(
	instID		INT,
	instGUID	uniqueidentifier
)
EXEC sp_xml_preparedocument @idoc OUTPUT, @jobsXML
-- Read last job update time
SELECT @lastJobUpdateTime  = timeVal FROM OPENXML(@idoc, '/CommNet2_CN2FastSyncRunningJobs/lastJobUpdateTime', 0)
  WITH (timeVal INTEGER)
-- Read Job Stats
INSERT  INTO #CN2JMJobStatsTemp
SELECT  *
FROM    OPENXML(@idoc, '/CommNet2_CN2FastSyncRunningJobs/JMJobStats/job', 0)
WITH    #CN2JMJobStatsTemp
-- Read All Running Jobs
INSERT  INTO #CN2JMJobInfoTemp
SELECT  *
FROM    OPENXML(@idoc, '/CommNet2_CN2FastSyncRunningJobs/JMJobInfo/job', 0)
WITH    #CN2JMJobInfoTemp
-- Read Backup Jobs
INSERT  INTO #CN2JMBkpJobInfoTemp
SELECT  *
FROM    OPENXML(@idoc, '/CommNet2_CN2FastSyncRunningJobs/JMBkpJobInfo/job', 0)
WITH    #CN2JMBkpJobInfoTemp
-- Read backup attempts info.
INSERT INTO #CN2JMBkpAttemptInfoTemp
SELECT  *
FROM    OPENXML(@idoc, '/CommNet2_CN2FastSyncRunningJobs/JMBkpAttemptInfo/jobat',0)
WITH #CN2JMBkpAttemptInfoTemp
-- Read backup jobs stream info
INSERT INTO #CN2JMJobStreamsTemp
SELECT  *
FROM    OPENXML(@idoc, '/CommNet2_CN2FastSyncRunningJobs/JMJobStreams/job',0)
WITH #CN2JMJobStreamsTemp
-- Read JobCopy retention info
INSERT INTO #CN2JMJobCopyInfoTemp
SELECT  *
FROM    OPENXML(@idoc, '/CommNet2_CN2FastSyncRunningJobs/JMJobCopyInfo/job',0)
WITH #CN2JMJobCopyInfoTemp
-- Read admin jobs
INSERT INTO #CN2JMAdminJobInfoTableTemp
SELECT *
FROM    OPENXML(@idoc, '/CommNet2_CN2FastSyncRunningJobs/JMAdminJobInfoTable/job', 0)
WITH #CN2JMAdminJobInfoTableTemp
-- Read admin job attempts
INSERT INTO #CN2JMAdminJobAttemptInfoTableTemp
SELECT *
FROM    OPENXML(@idoc, '/CommNet2_CN2FastSyncRunningJobs/JMAdminJobAttemptInfoTable/jobat', 0)
WITH #CN2JMAdminJobAttemptInfoTableTemp
-- Read restore jobs
INSERT  INTO #CN2JMRstJobInfoTemp
SELECT  *
FROM    OPENXML(@idoc, '/CommNet2_CN2FastSyncRunningJobs/JMRstJobInfo/job', 0)
WITH    #CN2JMRstJobInfoTemp
-- Read restore attempts info
INSERT INTO #CN2JMRstAttemptInfoTemp
SELECT  *
FROM    OPENXML(@idoc, '/CommNet2_CN2FastSyncRunningJobs/JMRstAttemptInfo/jobat',0)
WITH #CN2JMRstAttemptInfoTemp
-- Read AppId to GUID Map
INSERT  INTO #CN2SubClientGUIDMap
SELECT  *
FROM    OPENXML(@idoc, '/CommNet2_CN2FastSyncRunningJobs/appidguidmap/itm', 0)
WITH    #CN2SubClientGUIDMap
-- Read backupsetID GUID map
INSERT INTO #CN2BkpSetGUIDMap
SELECT *
FROM OPENXML(@idoc, '/CommNet2_CN2FastSyncRunningJobs/bkpsetguidmap/itm', 0)
WITH #CN2BkpSetGUIDMap
--Read instanceID GUID Map
INSERT INTO #CN2InstanceGUIDMap
SELECT *
FROM OPENXML(@idoc, '/CommNet2_CN2FastSyncRunningJobs/instanceguidmap/itm', 0)
WITH #CN2InstanceGUIDMap
-- Read status of all requested  running jobs
INSERT  INTO #CN2JMJobStatsReqTemp
SELECT  *
FROM    OPENXML(@idoc, '/CommNet2_CN2FastSyncRunningJobs/respjobstatus/job', 0)
WITH    #CN2JMJobStatsReqTemp
EXEC sp_xml_removedocument @idoc
-- Set whether a job is new and its category info
INSERT INTO #CN2Jobs
SELECT jobId,opType,0,1,0,0,0 FROM #CN2JMJobInfoTemp
UPDATE #CN2Jobs SET category = 1 WHERE opType
IN (43,30,14,18,22,23,24,50,51,4,70,59,65,60,57,58,78,75) -- backup
UPDATE #CN2Jobs SET category = 2 WHERE opType
IN (15,16,19,25,26,27,29,34,37,40,45,12,48,49,55,52,5,54,66) -- restore
UPDATE #CN2Jobs SET category = 3 WHERE category = 0 -- Rest are admin
-- Mark job as old
UPDATE #CN2Jobs SET isNew = 0
WHERE EXISTS (SELECT jobId FROM JMJobInfo WHERE jobId = #CN2Jobs.jobId AND commcellId = @ForeignCCID)
-- Mark Bkp Job as New
UPDATE #CN2Jobs SET isNew = 1
WHERE EXISTS (SELECT jobId FROM JMJobInfo WHERE jobId = #CN2Jobs.jobId AND commcellId = @ForeignCCID)
-- Translate incoming AppIds to new appIds
ALTER TABLE #CN2SubClientGUIDMap ADD newAppId INTEGER
UPDATE #CN2SubClientGUIDMap SET newAppId = 0
UPDATE #CN2SubClientGUIDMap SET newAppId  = ISNULL(APP.id,0)
FROM APP_Application AS APP
WHERE #CN2SubClientGUIDMap.newAppId = 0 AND APP.origCCId = @ForeignCCID AND APP.GUID = #CN2SubClientGUIDMap.guid
-- Translate incoming backupset to new backupset
ALTER TABLE #CN2BkpSetGUIDMap ADD newbkpSetID INTEGER
UPDATE #CN2BkpSetGUIDMap SET newbkpSetID = 0
UPDATE #CN2BkpSetGUIDMap SET newbkpSetID = ISNULL(ABS.Id,0)
FROM APP_BackupSetName AS ABS WHERE ABS.origCCId = @ForeignCCID AND ABS.GUID = #CN2BkpSetGUIDMap.bkpGUID
-- Translate incoming instance to new instance
ALTER TABLE #CN2InstanceGUIDMap ADD newInstanceID INTEGER
UPDATE #CN2InstanceGUIDMap SET newInstanceID = 0
UPDATE #CN2InstanceGUIDMap SET newInstanceID = ISNULL(AIS.Id,0)
FROM APP_InstanceName AS AIS WHERE AIS.origCCId = @ForeignCCID AND AIS.GUID = #CN2InstanceGUIDMap.instGUID
-- Check if there are any jobs for which we cannot find the right appId
UPDATE #CN2Jobs SET noMap = 1
WHERE jobId IN (
SELECT jobId FROM #CN2JMBkpJobInfoTemp WHERE applicationId IN
	(SELECT appID FROM #CN2SubClientGUIDMap WHERE newAppId = 0)
UNION ALL
SELECT jobId FROM #CN2JMAdminJobInfoTableTemp WHERE appId > 0 AND appId IN
  (SELECT appID FROM #CN2SubClientGUIDMap WHERE newAppId = 0)
)
-- Update appid for backup jobs (fresh ones, old ones are already mapped)
UPDATE #CN2JMBkpJobInfoTemp SET applicationId = APGUI.newAppId
FROM  #CN2Jobs AS J, #CN2SubClientGUIDMap AS APGUI
WHERE #CN2JMBkpJobInfoTemp.jobId = J.JobId AND J.noMap = 0
AND #CN2JMBkpJobInfoTemp.applicationId = APGUI.appID
AND NOT EXISTS(SELECT jobId FROM JMBkpJobInfo WHERE jobId = #CN2JMBkpJobInfoTemp.jobId AND commcellId = @ForeignCCID)
-- Update appid for admin jobs (fresh ones, old ones are already mapped)
UPDATE #CN2JMAdminJobInfoTableTemp SET appId = APGUI.newAppId
FROM  #CN2Jobs AS J, #CN2SubClientGUIDMap AS APGUI
WHERE #CN2JMAdminJobInfoTableTemp.appId > 0  AND #CN2JMAdminJobInfoTableTemp.jobId = J.JobId AND J.noMap = 0
AND #CN2JMAdminJobInfoTableTemp.appId = APGUI.appID
AND NOT EXISTS (SELECT jobid FROM JMAdminJobInfoTable WHERE jobId = #CN2JMAdminJobInfoTableTemp.jobId
AND commcellId = @ForeignCCID)
-- Update storage policy and copy values for backup jobs
UPDATE #CN2JMBkpJobInfoTemp SET currentPolicy  = AG.Id
FROM #CN2Jobs AS J, archGroup AS AG
WHERE #CN2JMBkpJobInfoTemp.currentPolicy > 0 AND #CN2JMBkpJobInfoTemp.applicationId > 0 AND
J.jobId = #CN2JMBkpJobInfoTemp.jobId AND J.noMap = 0 AND #CN2JMBkpJobInfoTemp.currentPolicy = AG.origCCarchGroupId
AND AG.origCCcommCellID  = @ForeignCCID
UPDATE #CN2JMBkpJobInfoTemp SET dataPolicy  = AG.Id
FROM #CN2Jobs AS J, archGroup AS AG
WHERE #CN2JMBkpJobInfoTemp.dataPolicy > 0 AND #CN2JMBkpJobInfoTemp.applicationId > 0 AND
J.jobId = #CN2JMBkpJobInfoTemp.jobId AND J.noMap = 0 AND #CN2JMBkpJobInfoTemp.dataPolicy = AG.origCCarchGroupId
AND AG.origCCcommCellID  = @ForeignCCID
UPDATE #CN2JMBkpJobInfoTemp SET logPolicy  = AG.Id
FROM #CN2Jobs AS J, archGroup AS AG
WHERE #CN2JMBkpJobInfoTemp.logPolicy > 0 AND #CN2JMBkpJobInfoTemp.applicationId > 0 AND
J.jobId = #CN2JMBkpJobInfoTemp.jobId AND J.noMap = 0 AND #CN2JMBkpJobInfoTemp.logPolicy = AG.origCCarchGroupId
AND AG.origCCcommCellID  = @ForeignCCID
-- Update storage policy info in bkp attempts info.
UPDATE #CN2JMBkpAttemptInfoTemp SET archGrpId = AG.Id, archGroupName = AG.name
FROM archGroup AS AG, #CN2Jobs AS J
WHERE #CN2JMBkpAttemptInfoTemp.archGrpId > 0 AND AG.origCCcommCellID = @ForeignCCID AND
J.jobId = #CN2JMBkpAttemptInfoTemp.jobId AND J.noMap = 0 AND #CN2JMBkpAttemptInfoTemp.archGrpId  = AG.origCCarchGroupId
-- Update strorage policy copy id and name in bkp attempts info
UPDATE #CN2JMBkpAttemptInfoTemp SET copyId = AGC.Id, copyName = AGC.name
FROM archGroupCopy AS AGC,#CN2Jobs AS J
WHERE #CN2JMBkpAttemptInfoTemp.copyId > 0 AND #CN2JMBkpAttemptInfoTemp.archGrpId = AGC.archGroupId AND
J.jobId = #CN2JMBkpAttemptInfoTemp.jobId AND J.noMap = 0 AND #CN2JMBkpAttemptInfoTemp.copyId = AGC.origCCarchCopyId
AND AGC.origCCcommCellID = @ForeignCCID
-- Update storage policy and copy Id for job retention
UPDATE #CN2JMJobCopyInfoTemp SET archGrpId = AG.Id
FROM archGroup AS AG, #CN2Jobs AS J
WHERE #CN2JMJobCopyInfoTemp.archGrpId > 0 AND AG.origCCcommCellID = @ForeignCCID AND
J.jobId = #CN2JMJobCopyInfoTemp.jobId AND J.noMap = 0 AND #CN2JMJobCopyInfoTemp.archGrpId  = AG.origCCarchGroupId
UPDATE #CN2JMJobCopyInfoTemp SET archGrpCopyId = AGC.Id
FROM archGroupCopy AS AGC,#CN2Jobs AS J
WHERE #CN2JMJobCopyInfoTemp.archGrpCopyId > 0 AND #CN2JMJobCopyInfoTemp.archGrpId = AGC.archGroupId AND
J.jobId = #CN2JMJobCopyInfoTemp.jobId AND J.noMap = 0 AND #CN2JMJobCopyInfoTemp.archGrpCopyId = AGC.origCCarchCopyId
AND AGC.origCCcommCellID = @ForeignCCID
-- Update storage policy and copyId info for job streams
UPDATE #CN2JMJobStreamsTemp SET archGrpID  = AG.Id , archGrpName = AG.name
FROM #CN2Jobs AS J, archGroup AS AG
WHERE #CN2JMJobStreamsTemp.archGrpID > 0 AND J.jobId = #CN2JMJobStreamsTemp.jobId AND J.noMap = 0
AND #CN2JMJobStreamsTemp.archGrpID = AG.origCCarchGroupId
AND AG.origCCcommCellID = @ForeignCCID
UPDATE #CN2JMJobStreamsTemp SET destCopyId  = AGC.Id , destCopyName = AGC.name
FROM #CN2Jobs AS J, archGroupCopy AS AGC
WHERE #CN2JMJobStreamsTemp.destCopyId > 0 AND #CN2JMJobStreamsTemp.archGrpID = AGC.archGroupId
AND J.jobId = #CN2JMJobStreamsTemp.jobId AND J.noMap = 0 AND #CN2JMJobStreamsTemp.destCopyId = AGC.origCCarchCopyId
AND AGC.origCCcommCellID = @ForeignCCID
UPDATE #CN2JMJobStreamsTemp SET srcCopyId  = AGC.Id , srcCopyName = AGC.name
FROM #CN2Jobs AS J, archGroupCopy AS AGC
WHERE #CN2JMJobStreamsTemp.srcCopyId > 0 AND #CN2JMJobStreamsTemp.archGrpID = AGC.archGroupId
AND J.jobId = #CN2JMJobStreamsTemp.jobId AND J.noMap = 0 AND #CN2JMJobStreamsTemp.srcCopyId = AGC.origCCarchCopyId
AND AGC.origCCcommCellID = @ForeignCCID
-- Update storage/copy policy for admin jobs
UPDATE #CN2JMAdminJobInfoTableTemp SET archGrpID  = AG.Id , archGrpName = AG.name
FROM #CN2Jobs AS J, archGroup AS AG
WHERE #CN2JMAdminJobInfoTableTemp.archGrpID > 0 AND J.jobId = #CN2JMAdminJobInfoTableTemp.jobId AND J.noMap = 0
AND #CN2JMAdminJobInfoTableTemp.archGrpID = AG.origCCarchGroupId
AND AG.origCCcommCellID = @ForeignCCID
UPDATE #CN2JMAdminJobInfoTableTemp SET archGrpCopyId = AGC.Id
FROM #CN2Jobs AS J, archGroupCopy AS AGC
WHERE #CN2JMAdminJobInfoTableTemp.archGrpCopyId > 0 AND #CN2JMAdminJobInfoTableTemp.archGrpID = AGC.archGroupId
AND J.jobId = #CN2JMAdminJobInfoTableTemp.jobId AND J.noMap = 0 AND #CN2JMAdminJobInfoTableTemp.archGrpCopyId = AGC.origCCarchCopyId
AND AGC.origCCcommCellID = @ForeignCCID
-- Restore Jobs: Update backupset
UPDATE #CN2JMRstJobInfoTemp SET bkpSetID = BSG.newbkpSetID
FROM #CN2BkpSetGUIDMap AS BSG WHERE BSG.bkpSetID = #CN2JMRstJobInfoTemp.bkpSetID
AND #CN2JMRstJobInfoTemp.bkpSetID > 0 AND
NOT EXISTS (SELECT * FROM JMRstJobInfo WHERE jobId = #CN2JMRstJobInfoTemp.jobId
			AND commCellId = @ForeignCCID)
-- Restore Jobs: Update instance
UPDATE #CN2JMRstJobInfoTemp SET instanceID = IG.newInstanceID
FROM #CN2InstanceGUIDMap AS IG WHERE IG.instID = #CN2JMRstJobInfoTemp.instanceID
AND #CN2JMRstJobInfoTemp.instanceID > 0 AND
NOT EXISTS (SELECT * FROM JMRstJobInfo WHERE jobId = #CN2JMRstJobInfoTemp.jobId
			AND commCellId = @ForeignCCID)
-- Restore Jobs: Update srcClient
UPDATE #CN2JMRstJobInfoTemp SET srcClientId = ISNULL(A.Id,0)
FROM APP_Client AS A WHERE A.net_hostname = CONVERT(nvarchar(255),#CN2JMRstJobInfoTemp.srcClientName)
AND NOT EXISTS (SELECT * FROM JMRstJobInfo WHERE jobId = #CN2JMRstJobInfoTemp.jobId
			AND commCellId = @ForeignCCID)
-- Restore Jobs: Update destClient
UPDATE #CN2JMRstJobInfoTemp SET destClientId = ISNULL(A.Id,0)
FROM APP_Client AS A WHERE A.net_hostname = CONVERT(nvarchar(255),#CN2JMRstJobInfoTemp.destClientName)
AND NOT EXISTS (SELECT * FROM JMRstJobInfo WHERE jobId = #CN2JMRstJobInfoTemp.jobId
			AND commCellId = @ForeignCCID)
UPDATE #CN2JMJobInfoTemp SET commcellId = @ForeignCCID
UPDATE #CN2JMJobStatsTemp SET commcellId = @ForeignCCID
UPDATE #CN2JMBkpJobInfoTemp SET commcellId = @ForeignCCID
UPDATE #CN2JMJobStreamsTemp SET commcellId = @ForeignCCID
UPDATE #CN2JMJobCopyInfoTemp SET commcellId = @ForeignCCID
UPDATE #CN2JMJobStatsReqTemp SET commcellId = @ForeignCCID
UPDATE #CN2JMBkpAttemptInfoTemp SET commcellId = @ForeignCCID
UPDATE #CN2JMAdminJobInfoTableTemp SET commcellId = @ForeignCCID
UPDATE #CN2JMAdminJobAttemptInfoTableTemp SET commcellId = @ForeignCCID
UPDATE #CN2JMRstJobInfoTemp SET commcellId = @ForeignCCID
UPDATE #CN2JMRstAttemptInfoTemp SET commcellId = @ForeignCCID
-- Update lastStateChangeTime in JMJobInfo to current time.
SET @stTimeMagic = 2147483648
SET @curJobGatherTime = dbo.GetUnixTime(GetUTCDate())
SET @lastJobStateChangeTime = CONVERT(BIGINT, @curJobGatherTime * @stTimeMagic)
UPDATE #CN2JMJobInfoTemp SET lastStateChangeTime = @lastJobStateChangeTime
FROM #CN2Jobs
WHERE #CN2JMJobInfoTemp.jobId = #CN2Jobs.jobId AND #CN2Jobs.noMap = 0
-- ALL SET. START ADDING NEW JOBS, UPDATING OLD JOBS
-- UDPATE OLD RUNNING JOBS START --
--Update JMJobStats
UPDATE JMJobStats SET status = #CN2JMJobStatsTemp.status
FROM #CN2JMJobStatsTemp,#CN2Jobs
WHERE #CN2JMJobStatsTemp.jobId = #CN2Jobs.jobId AND #CN2Jobs.noMap = 0
AND #CN2JMJobStatsTemp.jobId = JMJobStats.jobId AND JMJobStats.commcellId = #CN2JMJobStatsTemp.commcellId
-- Update JMJobInfo
UPDATE JMJobInfo SET
     initFrom=JMJI.initFrom,opType=JMJI.opType,userId=JMJI.userId,
	 clientPriority=JMJI.clientPriority,opPriority=JMJI.opPriority,appPriority=JMJI.appPriority,
	 combPriority=JMJI.combPriority,currentPhase=JMJI.currentPhase,jobStartTime=JMJI.jobStartTime,
	 attemptStartTime=JMJI.attemptStartTime,serverEndTime=JMJI.serverEndTime,jobElapsedTime=JMJI.jobElapsedTime,
	 elapsedTime=JMJI.elapsedTime,lastStartOrRun=JMJI.lastStartOrRun,phaseParams=JMJI.phaseParams,
	 restartString=JMJI.restartString,startAttempts=JMJI.startAttempts,runAttempts=JMJI.runAttempts,
	 state=JMJI.state,pendingCause=JMJI.pendingCause,restartable=JMJI.restartable,appArgs=JMJI.appArgs,
	 numOfFailures=JMJI.numOfFailures,failureReason=JMJI.failureReason,preemptable=JMJI.preemptable,
	 taskLinkID=JMJI.taskLinkID,percentcomplete=JMJI.percentcomplete,displayState=JMJI.displayState,
	 resourcesAllocated=JMJI.resourcesAllocated,currentContext=JMJI.currentContext,
	 libraryList=JMJI.libraryList,driveList=JMJI.driveList,opUsername=JMJI.opUsername,
	 phaseOnSuccess=JMJI.phaseOnSuccess,interruptedPhase=JMJI.interruptedPhase,errorType=JMJI.errorType,
	 licenseVerified=JMJI.licenseVerified,currentPhaseName=JMJI.currentPhaseName,timeToComplete=JMJI.timeToComplete,
	 lastUpdateFromClient=JMJI.lastUpdateFromClient,lastStateChangeTime=JMJI.lastStateChangeTime,
	 jobCategory=JMJI.jobCategory,recoveredFromServiceRestart=JMJI.recoveredFromServiceRestart,
	 noOfGUIMonitors=JMJI.noOfGUIMonitors,isScheduledAlert=JMJI.isScheduledAlert,
	 jobBasedAlertId=JMJI.jobBasedAlertId,alertName=JMJI.alertName,shortMediaAgent=JMJI.shortMediaAgent,
	 seqNumber=JMJI.seqNumber,activeFile=JMJI.activeFile,guiAlertColorLevel=JMJI.guiAlertColorLevel,
	 jobDescription=JMJI.jobDescription,xmlJobInfo=JMJI.xmlJobInfo,subOpType=JMJI.subOpType,
	 foreignToken=JMJI.foreignToken,preparedJobId=JMJI.preparedJobId
FROM #CN2JMJobInfoTemp AS JMJI, #CN2Jobs AS J
WHERE J.jobId = JMJI.jobId AND J.noMap = 0 AND JMJI.jobId  = JMJobInfo.jobId
AND JMJobInfo.commcellId = JMJI.commcellId
--Update JMBkpJobInfo
UPDATE JMBkpJobInfo SET
		numStreams=JMBJI.numStreams,currentPolicy=JMBJI.currentPolicy,targetCopyList=JMBJI.targetCopyList,
		bkpLevel=JMBJI.bkpLevel,indexOverride=JMBJI.indexOverride,startNewMedia=JMBJI.startNewMedia,
		compBytes=JMBJI.compBytes,unCompBytes=JMBJI.unCompBytes,filesToXfer=JMBJI.filesToXfer,
		backupTaskId=JMBJI.backupTaskId,scanFileFailures=JMBJI.scanFileFailures,scanFolderFailures=JMBJI.scanFolderFailures,
		backupFileFailures=JMBJI.backupFileFailures,backupFolderFailures=JMBJI.backupFolderFailures,shadowCopyId=JMBJI.shadowCopyId,
		bkpOptions=JMBJI.bkpOptions,oraSubLevel=JMBJI.oraSubLevel,bkpattributes=JMBJI.bkpattributes,dataPolicy=JMBJI.dataPolicy,
		logPolicy=JMBJI.logPolicy,filesXfered=JMBJI.filesXfered,currentThroughput=JMBJI.currentThroughput,
		averageThroughput=JMBJI.averageThroughput,filesIndexed=JMBJI.filesIndexed,filesFailedToIndex=JMBJI.filesFailedToIndex,
		filesSkippedForIndex=JMBJI.filesSkippedForIndex,contentIndexDBSize=JMBJI.contentIndexDBSize,
		totalMediaUsageTime=JMBJI.totalMediaUsageTime,mediaAgentName=JMBJI.mediaAgentName,scanType=JMBJI.scanType,
		scanTypeChangeReason=JMBJI.scanTypeChangeReason,numStreamsAllocated=JMBJI.numStreamsAllocated,maxRestarts=JMBJI.maxRestarts,
		restartInterval=JMBJI.restartInterval,cloudId=JMBJI.cloudId,diffPolicy=JMBJI.diffPolicy,targetClientId=JMBJI.targetClientId,
		unCompBytesToXfer=JMBJI.unCompBytesToXfer,secondaryBkpLevel=JMBJI.secondaryBkpLevel,jobIdActedOn=JMBJI.jobIdActedOn,
		fromTime=JMBJI.fromTime,toTime=JMBJI.toTime,nwTransBytes=JMBJI.nwTransBytes
FROM #CN2JMBkpJobInfoTemp AS JMBJI, #CN2Jobs AS J
WHERE J.jobId = JMBJI.jobId AND J.noMap= 0 AND JMBkpJobInfo.jobId = JMBJI.jobId
AND JMBkpJobInfo.commcellId = JMBJI.commcellId
-- Update JMBkpAttemptInfo
UPDATE JMBkpAttemptInfo SET
		attemptNum=JMBAI.attemptNum,status=JMBAI.status,startTime=JMBAI.startTime,
		endTime=JMBAI.endTime,elapsedTime=JMBAI.elapsedTime,unCompBytes=JMBAI.unCompBytes,
		compBytes=JMBAI.compBytes,numFiles=JMBAI.numFiles,failureReason=JMBAI.failureReason,
		writeTime=JMBAI.writeTime,restartString=JMBAI.restartString,attributes=JMBAI.attributes,
		numFolders=JMBAI.numFolders,archGrpId=JMBAI.archGrpId,archGroupName=JMBAI.archGroupName,
		copyId=JMBAI.copyId,copyName=JMBAI.copyName,mediaAgent=JMBAI.mediaAgent,libraryName=JMBAI.libraryName,
		drivePoolName=JMBAI.drivePoolName,maxStreamsUsed=JMBAI.maxStreamsUsed,nwTransBytes=JMBAI.nwTransBytes
FROM #CN2JMBkpAttemptInfoTemp AS JMBAI,#CN2Jobs AS J
		WHERE J.jobId = JMBAI.jobId AND J.noMap = 0
		AND JMBkpAttemptInfo.jobId = JMBAI.jobId AND JMBkpAttemptInfo.phaseNum = JMBAI.phaseNum AND
		JMBkpAttemptInfo.attemptNum = JMBAI.attemptNum AND JMBkpAttemptInfo.copyId = JMBAI.copyId
		AND JMBkpAttemptInfo.commCellId = JMBAI.commCellId
-- Update JMJobStreams
UPDATE JMJobStreams SET
		destReservationId=JMJS.destReservationId,srcReservationId=JMJS.srcReservationId,
		destMedAgent=JMJS.destMedAgent,srcClient=JMJS.srcClient,destDriveName=JMJS.destDriveName,
		srcDriveName=JMJS.srcDriveName,archGrpId=JMJS.archGrpId,archGrpName=JMJS.archGrpName,
		destCopyId=JMJS.destCopyId,destCopyName=JMJS.destCopyName,srcCopyId=JMJS.srcCopyId,
		srcCopyName=JMJS.srcCopyName,status=JMJS.status,streamNum=JMJS.streamNum,isPrimary=JMJS.isPrimary,
		unCompBytes=JMJS.unCompBytes,compBytes=JMJS.compBytes,writeTime=JMJS.writeTime,
		committedUncompBytes=JMJS.committedUncompBytes,committedCompBytes=JMJS.committedCompBytes,
		committedWriteTime=JMJS.committedWriteTime,numFiles=JMJS.numFiles,
		numFolders=JMJS.numFolders,numFailures=JMJS.numFailures,numSkipped=JMJS.numSkipped,
		compScheme=JMJS.compScheme,restartString=JMJS.restartString,activeFile=JMJS.activeFile,
		failureReason=JMJS.failureReason,phaseNumber=JMJS.phaseNumber,attemptNumber=JMJS.attemptNumber,
		guiAlertColorLevel=JMJS.guiAlertColorLevel,throughput=JMJS.throughput,totalToCopy=JMJS.totalToCopy,
		embeddedObjects=JMJS.embeddedObjects,transCalcParams=JMJS.transCalcParams,destStreamNum=JMJS.destStreamNum,
		srcBarCode=JMJS.srcBarCode,destBarCode=JMJS.destBarCode,nwTransBytes=JMJS.nwTransBytes
FROM #CN2JMJobStreamsTemp AS JMJS , #CN2Jobs AS J
WHERE JMJS.jobId = J.jobId AND J.noMap = 0 AND JMJobStreams.jobId = JMJS.jobId
  AND JMJobStreams.commCellId = JMJS.commCellId
  AND JMJobStreams.destRcId = JMJS.destRcId AND JMJobStreams.srcRcId= JMJS.srcRcId
-- Update JMJobCopyInfo  do we have to do this? will the info ever change for a running job?
-- Update JMAdminInfoTable
UPDATE   JMAdminJobInfoTable  SET
		status=JMAJI.status,servStart=JMAJI.servStart,servEnd=JMAJI.servEnd,archGrpID=JMAJI.archGrpID,
		archGrpName=JMAJI.archGrpName,AP_NumDays=JMAJI.AP_NumDays,AP_IsForecast=JMAJI.AP_IsForecast,
		AP_SeqNum=JMAJI.AP_SeqNum,AC_NewMediaFlag=JMAJI.AC_NewMediaFlag,ER_BkpLevel=JMAJI.ER_BkpLevel,
		ER_DbName=JMAJI.ER_DbName,ER_Destination=JMAJI.ER_Destination,ER_SendCount=JMAJI.ER_SendCount,
		ER_MediasUsed=JMAJI.ER_MediasUsed,TotalObjects=JMAJI.TotalObjects,ObjectsDone=JMAJI.ObjectsDone,
		ObjectsFailed=JMAJI.ObjectsFailed,archGrpCopyID=JMAJI.archGrpCopyID,LibraryID=JMAJI.LibraryID,
		MI_InventoryType=JMAJI.MI_InventoryType,currentWriteTime=JMAJI.currentWriteTime,noOfStreams=JMAJI.noOfStreams,
		appID=JMAJI.appID,dependantJobId=JMAJI.dependantJobId,workFlowId=JMAJI.workFlowId,srcMediaAgent=JMAJI.srcMediaAgent,
		destMediaAgent=JMAJI.destMediaAgent,drivePoolId=JMAJI.drivePoolId,mediaId=JMAJI.mediaId,sourceJobId=JMAJI.sourceJobId,
		TotalSize=JMAJI.TotalSize,noOfStreamsAllocated=JMAJI.noOfStreamsAllocated,maxRestarts=JMAJI.maxRestarts,
		restartInterval=JMAJI.restartInterval,embeddedObjects=JMAJI.embeddedObjects,uncompBytes=JMAJI.uncompBytes,
		numFiles=JMAJI.numFiles,skippedItems=JMAJI.skippedItems,writeTime=JMAJI.writeTime,reportType=JMAJI.reportType,
		cloudId=JMAJI.cloudId,reportSetId=JMAJI.reportSetId,reportName=JMAJI.reportName,reportSetName=JMAJI.reportSetName,
		fromTime=JMAJI.fromTime,toTime=JMAJI.toTime,subTaskId=JMAJI.subTaskId,otherOpName=JMAJI.otherOpName,
		nwTransBytes=JMAJI.nwTransBytes
FROM  #CN2JMAdminJobInfoTableTemp AS JMAJI, #CN2Jobs AS J
WHERE J.jobId = JMAJI.jobId AND J.noMap = 0 AND
JMAdminJobInfoTable.jobId =  JMAJI.jobId AND JMAdminJobInfoTable.commCellId = JMAJI.commCellId
-- Update JMAdminJobAttemptInfoTable
UPDATE JMAdminJobAttemptInfoTable SET
		attemptNum=JMAAI.attemptNum,phaseName=JMAAI.phaseName,
		status=JMAAI.status,startTime=JMAAI.startTime,endTime=JMAAI.endTime,
		elapsedTime=JMAAI.elapsedTime,failureReason=JMAAI.failureReason,
		writeTime=JMAAI.writeTime,embeddedObjects=JMAAI.embeddedObjects,
		uncompBytes=JMAAI.uncompBytes,numFiles=JMAAI.numFiles,skippedItems=JMAAI.skippedItems,
		TotalSize=JMAAI.TotalSize,nwTransBytes=JMAAI.nwTransBytes
FROM #CN2JMAdminJobAttemptInfoTableTemp AS JMAAI,#CN2Jobs AS J
	  WHERE J.jobId = JMAAI.jobId AND J.noMap = 0 AND JMAdminJobAttemptInfoTable.jobId = JMAAI.jobId
	  AND JMAdminJobAttemptInfoTable.commCellId = JMAAI.commCellId
	  AND JMAdminJobAttemptInfoTable.phaseNum = JMAAI.phaseNum AND
	  JMAdminJobAttemptInfoTable.attemptNum = JMAAI.attemptNum
-- Update JMRstJobInfo
UPDATE JMRstJobInfo SET
	totCompBytes = JMRI.totCompBytes, totUnCompBytes = JMRI.totUnCompBytes,
	totSuccess = JMRI.totSuccess, totFailures = JMRI.totFailures, totFiles2Xfer = JMRI.totFiles2Xfer,
	rstTaskID = JMRI.rstTaskID, totBytes2Xfer = JMRI.totBytes2Xfer,dmUserName = JMRI.dmUserName,
	volumeId = JMRI.volumeId, totSkipped = JMRI.totSkipped, curDatabase = JMRI.curDatabase,
	mediaAgent = JMRI.mediaAgent, maxRestarts = JMRI.maxRestarts, restartInterval = JMRI.restartInterval,
	rstattributes = JMRI.rstattributes
FROM #CN2JMRstJobInfoTemp AS JMRI WHERE JMRI.jobId = JMRstJobInfo.jobId
	 AND JMRI.commCellId = JMRstJobInfo.commCellId
--Update JMRstAttemptInfo
UPDATE JMRstAttemptInfo SET
	status = JRAI.status,numSuccess_h = JRAI.numSuccess_h,numSuccess_l = JRAI.numSuccess_l,
	numFailures_h = JRAI.numFailures_h,numFailures_l = JRAI.numFailures_l,compBytes_h = JRAI.compBytes_h,
	compBytes_l = JRAI.compBytes_l,uCompBytes_h = JRAI.uCompBytes_h,uCompBytes_l = JRAI.uCompBytes_l,
	elapsedTime = JRAI.elapsedTime,startTime = JRAI.startTime, endTime = JRAI.endTime,failureReason = JRAI.failureReason,
	numSkipped = JRAI.numSkipped
FROM #CN2JMRstAttemptInfoTemp AS JRAI WHERE JRAI.commCellId = JMRstAttemptInfo.commCellId AND
	JMRstAttemptInfo.jobId  = JMRstAttemptInfo.jobId AND
	JMRstAttemptInfo.attemptNum = JRAI.attemptNum AND JMRstAttemptInfo.phaseNum = JRAI.phaseNum
-- OLD RUNNING JOBS END --
-- NEW RUNNING JOBS START --
-- Add in JMJobStats
-- TODO: Have an index defined on JMJobStats(jobId,commcellId)
INSERT INTO JMJobStats
  SELECT JMJS.* FROM #CN2JMJobStatsTemp AS JMJS
  LEFT JOIN JMJobStats AS JS ON JS.jobId = JMJS.jobId AND JS.commcellId = JMJS.commcellId
  JOIN #CN2Jobs AS J ON J.jobId = JMJS.jobId
  WHERE J.noMap = 0 AND JS.jobId IS NULL
-- Add in JMJobInfo
-- TODO: Have an index defined on JMJobInfo(jobId,commcellId)
INSERT INTO JMJobInfo
  SELECT JMJI.* FROM #CN2JMJobInfoTemp AS JMJI
  LEFT JOIN JMJobInfo AS JI ON JI.jobId = JMJI.jobId AND JI.commcellId = JMJI.commcellId
  JOIN #CN2Jobs AS J ON J.jobId = JMJI.jobId
  WHERE J.noMap = 0 AND JI.jobId IS NULL
--Add in JMBkpJobInfo
-- TODO: Have an index defined on JMBkpJobInfo(jobId,commcellId)
INSERT INTO JMBkpJobInfo
  SELECT JMBJI.* FROM #CN2JMBkpJobInfoTemp  AS JMBJI
  LEFT JOIN JMBkpJobInfo AS BJI ON BJI.jobId = JMBJI.jobId AND BJI.commcellId = JMBJI.commcellId
  JOIN #CN2Jobs AS J ON J.jobId = JMBJI.jobId
  WHERE J.noMap = 0 AND BJI.jobId IS NULL
-- Add in JMBkpAttemptInfo
-- TODO: Have an index defined on JMJobInfo(jobId,commcellId,attemptNum, phaseNum,copyId)
-- TODO: Add commcellId
INSERT INTO JMBkpAttemptInfo
  SELECT JMBAI.* FROM  #CN2JMBkpAttemptInfoTemp AS JMBAI
  LEFT JOIN JMBkpAttemptInfo AS BAI ON BAI.jobId = JMBAI.jobId AND BAI.commCellId = JMBAI.commCellId
  AND BAI.attemptNum = JMBAI.attemptNum AND BAI.phaseNum = JMBAI.phaseNum AND BAI.copyId = JMBAI.copyId
  JOIN #CN2Jobs AS J ON J.jobId = JMBAI.jobId
  WHERE J.noMap = 0 AND BAI.jobId IS NULL AND BAI.attemptNum IS NULL AND BAI.phaseNum IS NULL
		AND BAI.copyId IS NULL
-- Add in JMJobStreams
INSERT INTO JMJobStreams
  SELECT JMJS.* FROM #CN2JMJobStreamsTemp AS JMJS
  LEFT JOIN JMJobStreams AS JS ON JS.jobId = JMJS.jobId AND JS.commCellId = JMJS.commCellId
  AND JS.destRcId = JMJS.destRcId AND JS.srcRcId= JMJS.srcRcId
  JOIN #CN2Jobs AS J ON J.jobId = JMJS.jobId
  WHERE J.noMap = 0 AND JS.jobId IS NULL AND JS.destRcId IS NULL AND JS.srcRcId IS NULL
-- Add in JMJobCopyInfo
INSERT INTO JMJobCopyInfo
 SELECT JCI.* FROM #CN2JMJobCopyInfoTemp AS JCI
 LEFT JOIN JMJobCopyInfo AS JC ON JC.jobId = JCI.jobId AND JC.commCellId = JCI.commCellId
 AND JC.archGrpCopyId = JCI.archGrpCopyId
 JOIN #CN2Jobs AS J ON J.jobId = JCI.jobId
 WHERE J.noMap = 0 AND JC.jobId IS NULL AND JC.archGrpCopyId IS NULL
-- Add in JMAdminInfoTable
INSERT INTO JMAdminJobInfoTable
  SELECT JMAJI.* FROM #CN2JMAdminJobInfoTableTemp JMAJI
  LEFT JOIN JMAdminJobInfoTable AS AJI ON AJI.jobId = JMAJI.jobId AND AJI.commCellId = JMAJI.commCellId
  JOIN #CN2Jobs AS J ON J.jobId = JMAJI.jobId
  WHERE J.noMap = 0 AND AJI.jobId IS NULL
-- Add in JMAdminJobAttemptInfoTable
INSERT INTO JMAdminJobAttemptInfoTable
  SELECT JMAAI.* FROM #CN2JMAdminJobAttemptInfoTableTemp AS JMAAI
  LEFT JOIN JMAdminJobAttemptInfoTable AS AAI ON AAI.jobId = JMAAI.jobId AND AAI.commCellId = JMAAI.commCellId
  AND AAI.attemptNum = JMAAI.attemptNum AND
  AAI.phaseNum = JMAAI.phaseNum
  JOIN #CN2Jobs AS J ON J.jobId = JMAAI.jobId
  WHERE J.noMap = 0 AND AAI.jobId IS NULL AND AAI.attemptNum IS NULL AND AAI.phaseNum IS NULL
-- Add in JMRstJobInfo
INSERT INTO JMRstJobInfo
  SELECT JMRI.* FROM #CN2JMRstJobInfoTemp AS JMRI
  LEFT JOIN JMRstJobInfo AS RJI on RJI.commCellId = JMRI.commCellId AND RJI.jobId = JMRI.jobId
  WHERE RJI.jobId IS NULL
-- Add in JMRstAttemptInfo
INSERT INTO JMRstAttemptInfo
	SELECT JMRAI.* FROM #CN2JMRstAttemptInfoTemp AS JMRAI
	LEFT JOIN JMRstAttemptInfo AS RAI ON RAI.jobId = JMRAI.JobId AND RAI.commCellId = JMRAI.commCellId
	AND RAI.attemptNum = JMRAI.attemptNum AND RAI.phaseNum = JMRAI.phaseNum
	WHERE RAI.jobId IS NULL AND RAI.attemptNum IS NULL AND RAI.phaseNum IS NULL
-- NEW RUNNING JOBS END --
-- UPDATE LAST JOB UPDATE TIME
IF EXISTS (SELECT * FROM APP_CommCellProp WHERE CommCellId = @ForeignCCID)
BEGIN
  UPDATE APP_CommCellProp SET LastJobUpdateTime = dbo.GetDateTime(@lastJobUpdateTime) WHERE CommCellId = @ForeignCCID
END
ELSE
BEGIN
  INSERT INTO APP_CommCellProp VALUES
		(@ForeignCCID,0,dbo.GetDateTime(0),dbo.GetDateTime(@lastJobUpdateTime),dbo.GetDateTime(0),0,NULL,NULL)
END
-- Update requested jobs status
UPDATE JMJobStats SET status = JRS.status
FROM #CN2JMJobStatsReqTemp AS JRS
WHERE JRS.jobId = JMJobStats.jobId AND JRS.commcellId = JMJobStats.commcellId
-- Update state info of source commcell jobs in JMJobInfo for completed jobs
UPDATE JMJobInfo SET state = (CASE JRS.cvJobStatus
								WHEN 1 THEN 9	-- JMSUCCESS				: COMPLETEDSUCCESS
								WHEN 3 THEN 12	-- PARTIALSUCCESS			: COMPLETEDPARTIAL
								WHEN 14 THEN 19 -- JMSUCCESSWITHWARNINGS	: COMPLETEDWITHWARNINGS
								WHEN 15 THEN 10 -- SYSTEMFAILED				: COMPLETEDFAIL
								WHEN 2 THEN 10	-- FAIL						: COMPLETEDFAIL
								WHEN 9 THEN 10	-- DROPPED					: COMPLETEDFAIL
								WHEN 4 THEN 11	-- KILLED					: STATEKILLED
								ELSE 0 END),
						displayState = (CASE JRS.cvJobStatus
								WHEN 1 THEN 9	-- JMSUCCESS				: COMPLETEDSUCCESS
								WHEN 3 THEN 12	-- PARTIALSUCCESS			: COMPLETEDPARTIAL
								WHEN 14 THEN 19 -- JMSUCCESSWITHWARNINGS	: COMPLETEDWITHWARNINGS
								WHEN 15 THEN 10 -- SYSTEMFAILED				: COMPLETEDFAIL
								WHEN 2 THEN 10	-- FAIL						: COMPLETEDFAIL
								WHEN 9 THEN 10	-- DROPPED					: COMPLETEDFAIL
								WHEN 4 THEN 11	-- KILLED					: STATEKILLED
								ELSE 0 END),
						percentcomplete = (CASE JRS.cvJobStatus
											WHEN 1 THEN 100		--JMSUCCESS
											WHEN 3 THEN 100		--PARTIALSUCCESS
											WHEN 14 THEN 100	--JMSUCCESSWITHWARNINGS
											ELSE percentcomplete END)
FROM #CN2JMJobStatsReqTemp AS JRS
WHERE JRS.jobId = JMJobInfo.jobId AND JRS.status = 2
AND JRS.commcellId = JMJobInfo.commcellId
-- return those jobs that completed
SELECT
 (SELECT  @ForeignCCID as [@fccID],
   (SELECT
     jobId as [@jobId],status as [@status], opType as [@opType],commCellId as [@commCellId]
    FROM #CN2JMJobStatsReqTemp WHERE status = 2
    FOR XML PATH ('jobOpTypePair'),TYPE)
  FOR XML PATH('finishedJobs'),TYPE)
FOR XML PATH('CommNet2_CN2FastSyncUpdateCompletedJobsInfo')
--SELECT * FROM #CN2JMJobInfoTemp
--SELECT * FROM #CN2JMBkpJobInfoTemp
--SELECT * FROM #CN2SubClientGUIDMap
--SELECT * FROM  #CN2JMJobStatsTemp
--SELECT * FROM  #CN2JMBkpAttemptInfoTemp
DROP TABLE #CN2JMJobInfoTemp
DROP TABLE #CN2JMBkpJobInfoTemp
DROP TABLE #CN2SubClientGUIDMap
DROP TABLE #CN2JMJobStatsTemp
DROP TABLE #CN2JMBkpAttemptInfoTemp
DROP TABLE #CN2JMJobStatsReqTemp
DROP TABLE #CN2Jobs
DROP TABLE #CN2JMAdminJobInfoTableTemp
DROP TABLE #CN2JMAdminJobAttemptInfoTableTemp
DROP TABLE #CN2JMJobStreamsTemp
DROP TABLE #CN2JMJobCopyInfoTemp
DROP TABLE #CN2BkpSetGUIDMap
DROP TABLE #CN2InstanceGUIDMap
DROP TABLE #CN2JMRstJobInfoTemp
DROP TABLE #CN2JMRstAttemptInfoTemp
END
GO

IF EXISTS (select * from GxQscripts where name = 'CN2SetRunningJobsInfo')
	delete from GxQscripts where name = 'CN2SetRunningJobsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CN2SetRunningJobsInfo')
	delete from GXDBVersions where aliasname = 'CN2SetRunningJobsInfo'
GO

insert into GXDBVersions values(2, 'CN2SetRunningJobsInfo',  '00000000000000000000', 'CN2SetRunningJobsInfo', '00000000000000000000')
GO

