

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CN2SetEvMsgs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PROCNAME   - Should be IDENTICAL TO FILENAME
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CN2SetEvMsgs')
BEGIN
	print '>>> Drop Stored Procedure: CN2SetEvMsgs <<<'
	drop procedure CN2SetEvMsgs
END
IF EXISTS (select * from GxQscripts where name='CN2SetEvMsgs')
	delete from GxQscripts where name = 'CN2SetEvMsgs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CN2SetEvMsgs')
	delete from GXDBVersions where aliasname = 'CN2SetEvMsgs'
GO
print '... Creating Procedure: CN2SetEvMsgs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CN2SetEvMsgs
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ForeignCCID int,
  @EvMsgsXML NVARCHAR(MAX)
AS
DECLARE		@dummyNum		integer
DECLARE		@minInsId		integer
DECLARE		@maxInsId		integer
DECLARE		@outXML			NVARCHAR(MAX)
DECLARE		@idoc			integer
DECLARE		@Debug			integer
DECLARE		@LatestEventGenTime		integer
SET @Debug = 0
--DECLARE  @ForeignCCID		INT
-- DECLARE @EvMsgsXML		NVARCHAR(MAX)
-- SET @ForeignCCID	= 3
-- SET @EvMsgsXML = N'<CNCommCell_CN2FastSyncEvMsg>
--  <evmsg id="1" timeSource="1284734752" timeServer="1284734752" severity="0" ack="0" acked="0" type="0" paramNum="1" messageId="536870956" jobId_h="0" jobId_l="0" clientID="2" commCellID="2" userID="0" subsystemID="0" client="hercule" commCell="" userName="" subsystem="MediaManager" msgEnglish="" repeatCount="1" lastOccurrence="1284734752" nextPost="1" mediaId="0" driveId="0" libraryId="0" maClientId="2" />
--  <evmsg id="2" timeSource="1284734793" timeServer="1284734793" severity="0" ack="0" acked="0" type="0" paramNum="2" messageId="536871107" jobId_h="0" jobId_l="0" clientID="2" commCellID="2" userID="0" subsystemID="0" client="hercule" commCell="" userName="" subsystem="MediaManager" msgEnglish="" repeatCount="1" lastOccurrence="1284734793" nextPost="1" mediaId="0" driveId="0" libraryId="0" maClientId="2" />
--  <evParams evMsgId="1" position="1" type="11" size="27" data="hercule.gp.cv.commvault.com" eventId="536870956" />
--  <evParams evMsgId="2" position="1" type="11" size="46" data="C:\Program Files\CommVault\90B84_CS\IndexCache" eventId="536871107" />
--  <evParams evMsgId="2" position="2" type="11" size="27" data="hercule.gp.cv.commvault.com" eventId="536871107" />
--</CNCommCell_CN2FastSyncEvMsg>'
IF OBJECT_ID('tempdb.dbo.#CN2Set_TempEvMSg') IS NOT NULL DROP TABLE #CN2Set_TempEvMSg
IF OBJECT_ID('tempdb.dbo.#CN2Set_TempEvParams') IS NOT NULL DROP TABLE #CN2Set_TempEvParams
CREATE TABLE #CN2Set_TempEvMSg(
	id					INTEGER NOT NULL,
	timeSource     INTEGER NOT NULL,
	timeServer     INTEGER NOT NULL,
	severity       integer NOT NULL,
	ack            integer NOT NULL,
	acked          integer NOT NULL,
	type           integer NOT NULL,
	paramNum       integer NOT NULL,
	messageId      integer NOT NULL,
	jobId_h integer NOT NULL,
	jobId_l integer NOT NULL,
	clientID       integer NOT NULL,
	commCellID     integer NOT NULL,
	userID         integer NOT NULL,
	subsystemID    integer NOT NULL,
	client         varchar(128)   NOT NULL,
	commCell       varchar(128)   NOT NULL,
	userName       varchar(128)   NOT NULL,
	subsystem      varchar(128)   NOT NULL,
	msgEnglish     varchar(1024)   NOT NULL,
	repeatCount    integer NOT NULL,
	lastOccurrence INTEGER NOT NULL,
	nextPost       INTEGER NOT NULL,
	mediaId					integer NOT NULL,
	driveId					integer NOT NULL,
	libraryId				integer NOT NULL,
	maClientId			integer NOT NULL
)
CREATE TABLE #CN2Set_TempEvParams
(
	evMsgId				integer,
	position			integer,
	type				integer,
	size				integer,
	data				nvarchar(MAX),
	eventId				integer
 )
EXEC sp_xml_preparedocument @idoc OUTPUT, @EvMsgsXML
--SELECT * INTO #CN2Set_TempEvMSg  FROM evMsg WHERE 1 = 2
INSERT  INTO #CN2Set_TempEvMSg
SELECT  *
FROM    OPENXML(@idoc, '/CNCommCell_CN2FastSyncEvMsg/evmsg', 0)
WITH    #CN2Set_TempEvMSg
UPDATE #CN2Set_TempEvMSg SET commCellID = @ForeignCCID
-- Delete entries that already exist in evMsg table.
DELETE FROM #CN2Set_TempEvMSg WHERE EXISTS
(SELECT * FROM evMsg WHERE commCellID = #CN2Set_TempEvMSg.commCellID AND Id = #CN2Set_TempEvMSg.Id)
SELECT @minInsId = MIN(Id) FROM #CN2Set_TempEvMSg
SELECT @maxInsId = MAX(Id) FROM #CN2Set_TempEvMSg
INSERT  INTO #CN2Set_TempEvParams
SELECT  *
FROM    OPENXML(@idoc, '/CNCommCell_CN2FastSyncEvMsg/evParams', 0)
WITH    #CN2Set_TempEvParams
ALTER TABLE #CN2Set_TempEvParams ADD commCellID INT
UPDATE #CN2Set_TempEvParams SET commCellID = @ForeignCCID
DELETE FROM #CN2Set_TempEvParams WHERE EXISTS
(SELECT * FROM evParam WHERE commCellID = #CN2Set_TempEvParams.commCellID AND evMsgId = #CN2Set_TempEvParams.EvMsgId)
-- IDENTITY_INSERT does not work without a GO statement that I cant use here. Let me try cursor.
-- Inserting one value ata time is slow. Let me create an empty cursor and insert all values.
--DECLARE CN2InsertEvMsgCur CURSOR FOR
--SELECT 1
--OPEN CN2InsertEvMsgCur
--FETCH CN2InsertEvMsgCur INTO
--	@dummyNum
--IF @@FETCH_STATUS  = 0
--BEGIN
--  SET IDENTITY_INSERT evMsg ON
  INSERT INTO EvMsg(id,timeSource,timeServer,severity,ack,acked,type,paramNum,messageId,jobId_h,
    jobId_l,clientID,commCellID,userID,subsystemID,client,commCell,userName,subsystem,
    msgEnglish,repeatCount,lastOccurrence,nextPost,mediaId,driveId,libraryId,maClientId)
	SELECT * FROM #CN2Set_TempEvMSg
--  SET IDENTITY_INSERT evMsg OFF
--END
--CLOSE		CN2InsertEvMsgCur
--DEALLOCATE	CN2InsertEvMsgCur
-- Insert values into evParam
INSERT INTO evParam
SELECT * FROM #CN2Set_TempEvParams
-- Fetch and update the latest event gen time.
SELECT @LatestEventGenTime = ISNULL(MAX(timeServer),0) FROM #CN2Set_TempEvMSg
IF(@LatestEventGenTime > 0)
BEGIN
  IF EXISTS (SELECT * FROM APP_CommCellProp WHERE CommCellId = @ForeignCCID)
  BEGIN
    UPDATE APP_CommCellProp SET LastEventUpdateTime = dbo.GetDateTime(@LatestEventGenTime)
      WHERE CommCellId = @ForeignCCID
  END
  ELSE
  BEGIN
    INSERT INTO APP_CommCellProp VALUES
		(@ForeignCCID,@maxInsId,dbo.GetDateTime(@LatestEventGenTime),dbo.GetDateTime(0),dbo.GetDateTime(0),0,NULL,NULL)
  END
END
EXEC sp_xml_removedocument @idoc
DROP TABLE #CN2Set_TempEvMSg
DROP TABLE #CN2Set_TempEvParams
SET @outXML = (
SELECT @minInsId AS [@startEvId],
 @maxInsId as [@endEvId],
@ForeignCCID as [@fccID],
@LatestEventGenTime as [@lastEventGenTime]
FOR XML PATH('CommNet2_CN2FastSyncSendPendingEvent'))
SELECT @outXML
GO

IF EXISTS (select * from GxQscripts where name = 'CN2SetEvMsgs')
	delete from GxQscripts where name = 'CN2SetEvMsgs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CN2SetEvMsgs')
	delete from GXDBVersions where aliasname = 'CN2SetEvMsgs'
GO

insert into GXDBVersions values(2, 'CN2SetEvMsgs',  '00000000000000000000', 'CN2SetEvMsgs', '00000000000000000000')
GO

