

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CN2GetRunningJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CN2GetRunningJobs <<<'

IF EXISTS (select * from sysobjects where name='CN2GetRunningJobs')
	drop procedure CN2GetRunningJobs
IF EXISTS (select * from GxQscripts where name='CN2GetRunningJobs')
	delete from GxQscripts where name = 'CN2GetRunningJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CN2GetRunningJobs')
	delete from GXDBVersions where aliasname = 'CN2GetRunningJobs'
GO
print '... Creating Procedure: CN2GetRunningJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CN2GetRunningJobs
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @InLastJobUpdateTime INTEGER,
  @jobsXML VARCHAR(MAX) 
AS
BEGIN
DECLARE	  @lastJobStateChangeTime	BIGINT
DECLARE	  @stTimeMagic				BIGINT
DECLARE	  @idoc						INTEGER
DECLARE   @curJobGatherTime			INTEGER
--SET @InLastJobUpdateTime = 0
--SET @jobsXML = '<CN2RunningJobsReq><runningJobs /></CN2RunningJobsReq>'
--SET @jobsXML = '<dummyroot><CN2RunningJobsReq><runningJobs /></CN2RunningJobsReq>
--<EVGui_GRCShareEntities>
--<entities _type_="3" clientId="2" clientName="hercule" commCellId="2" commCellName="hercule"/>
--<entities _type_="4" appName="SQL" applicationId="81" clientId="5" clientName="milind_sql" commCellId="2" commCellName="hercule"/>
--<entities _type_="5" appName="SQL" applicationId="81" clientId="5" clientName="milind_sql" commCellId="2" commCellName="hercule" instanceId="2" instanceName="MRENAPURKAR\COMMVAULT"/>
--<entities _type_="6" appName="File System" applicationId="42" backupsetId="7" backupsetName="defaultBackupSet" clientId="4" clientName="milind_FS" commCellId="2" commCellName="hercule" instanceId="1" instanceName="DefaultInstanceName"/>
--<entities _type_="7" appName="File System" applicationId="42" backupsetId="9" backupsetName="defaultBackupSet" clientId="5" clientName="milind_sql" commCellId="2" commCellName="hercule" instanceId="1" instanceName="DefaultInstanceName" subclientId="9" subclientName="default"/>
--</EVGui_GRCShareEntities>
--</dummyroot>'
-- Change:
-- We now support selective live monitoring. Selection is at client and lower levels. (Storage Policy selection will come in later)
-- So we now get the selected entity list with every live request. This is only temporary as we will optimize selected entity list
-- processing later.
IF OBJECT_ID('tempdb.dbo.#CN2AllRunningJobsList') is not null DROP TABLE #CN2AllRunningJobsList
IF OBJECT_ID('tempdb.dbo.#CN2SubClientGUIDMap') is not null DROP TABLE #CN2SubClientGUIDMap
IF OBJECT_ID('tempdb.dbo.#CN2InReqJobsList') is not null DROP TABLE #CN2InReqJobsList
IF OBJECT_ID('tempdb.dbo.#CN2BkpSetGUIDMap') is not null DROP TABLE #CN2BkpSetGUIDMap
IF OBJECT_ID('tempdb.dbo.#CN2InstanceGUIDMap') is not null DROP TABLE #CN2InstanceGUIDMap
-- Live monitoring tables.
IF OBJECT_ID('tempdb.dbo.#GRC2SelectedEntities') is not null DROP TABLE #GRC2SelectedEntities
IF OBJECT_ID('tempdb.dbo.#GRC2MonitoredAppIds') is not null DROP TABLE #GRC2MonitoredAppIds
CREATE TABLE #GRC2SelectedEntities (
			_type_  INT,
            commCellId INT,
            commCellName varchar(255),
            clientId INT,
            clientName varchar(255),
            applicationId INT,
            appName varchar(255),
            instanceId INT,
            instanceName varchar(255),
            backupsetId INT,
            backupsetName varchar(255),
            subclientId INT,
            subclientName varchar(255))
CREATE TABLE #GRC2MonitoredAppIds (appId INT)
-- We have to fetch running jobs that have had some activity since the last time we picked up jobs.
-- Also there is an input list of jobs whose current status is requested.
-- Fetch running jobs list
CREATE TABLE #CN2AllRunningJobsList
(
  jobId		INT,
  opType	INT
 -- category	INT
)
 -- Mike K said AppID GUIDs can be safely used.
CREATE TABLE #CN2SubClientGUIDMap
(
  appID		INT,
  appGUID	uniqueidentifier
)
CREATE TABLE #CN2InReqJobsList
(
   jobId			INT
)
CREATE TABLE #CN2BkpSetGUIDMap
(
   bkpSetID		INT,
   bkpGUID		uniqueidentifier
)
CREATE TABLE #CN2InstanceGUIDMap
(
	instID		INT,
	instGUID	uniqueidentifier
)
-- Job manager seems to multiply this magic number (2^31) to the current time (in ms)
SET @stTimeMagic = 2147483648
SET @lastJobStateChangeTime = CONVERT(BIGINT, @InLastJobUpdateTime * @stTimeMagic)
EXEC sp_xml_preparedocument @idoc OUTPUT, @jobsXML
-- Live Data Monitoring: Build list of applicationIds that user want us monitor for backup jobs.
INSERT INTO #GRC2SelectedEntities
SELECT  *
FROM     OPENXML (@idoc, '//EVGui_GRCShareEntities/entities',1)
            WITH (
            _type_  INT,
            commCellId INT,
            commCellName varchar(255),
            clientId INT,
            clientName varchar(255),
            applicationId INT,
            appName varchar(255),
            instanceId INT,
            instanceName varchar(255),
            backupsetId INT,
            backupsetName varchar(255),
            subclientId INT,
            subclientName varchar(255)
            )
-- Optimization Note:
-- user selection and deduced applicationIds should be stored permanently stored on remote CS so that this computation does naot happen for every
-- live data request that gets sent to remote CS.
--------------------------------------------------------------- For backup jobs ----------------------------------------------------------------
IF EXISTS (SELECT * FROM #GRC2SelectedEntities WHERE _type_ IN (1,2))
BEGIN
		-- get all appIds
		INSERT INTO #GRC2MonitoredAppIds
			SELECT id FROM APP_Application
END
ELSE
BEGIN
		-- Client has been selected _type_ = 3
		INSERT INTO #GRC2MonitoredAppIds
			SELECT APP.id FROM #GRC2SelectedEntities SE
				JOIN APP_Application APP ON SE.clientId = APP.clientId
				WHERE SE._type_ = 3 AND APP.id NOT IN(SELECT * FROM #GRC2MonitoredAppIds)
		 -- iDA  has been selected _type_ = 4
		 INSERT INTO #GRC2MonitoredAppIds
			SELECT APP.id FROM #GRC2SelectedEntities SE
				JOIN APP_Application APP ON SE.clientId = APP.clientId AND SE.applicationId = APP.appTypeId
				WHERE SE._type_ = 4 AND APP.id NOT IN(SELECT * FROM #GRC2MonitoredAppIds)
		-- instance has been selected. _type_ = 5
		INSERT INTO #GRC2MonitoredAppIds
			SELECT APP.id FROM #GRC2SelectedEntities SE
				JOIN APP_Application APP ON SE.clientId = APP.clientId AND SE.applicationId = APP.appTypeId
				AND SE.instanceId = APP.instance
				WHERE SE._type_ = 5 AND APP.id NOT IN(SELECT * FROM #GRC2MonitoredAppIds)
		-- backupset has been selected _type_ = 6
		INSERT INTO #GRC2MonitoredAppIds
			SELECT APP.id FROM #GRC2SelectedEntities SE
				JOIN APP_Application APP ON SE.clientId = APP.clientId AND SE.applicationId = APP.appTypeId
				AND SE.backupsetId = APP.backupSet
				WHERE SE._type_ = 6 AND APP.id NOT IN(SELECT * FROM #GRC2MonitoredAppIds)
		-- subclient has been selected _type_ = 7
		INSERT INTO #GRC2MonitoredAppIds
			SELECT APP.id FROM #GRC2SelectedEntities SE
				JOIN APP_Application APP ON SE.clientId = APP.clientId AND SE.applicationId = APP.appTypeId
				AND SE.subclientId = APP.id
				WHERE SE._type_ = 7 AND APP.id NOT IN(SELECT * FROM #GRC2MonitoredAppIds)
END
IF NOT EXISTS (SELECT * FROM #GRC2MonitoredAppIds)
BEGIN
		INSERT INTO #GRC2MonitoredAppIds
			SELECT id FROM APP_Application
END
-- Live Data Monitoring: Got the list applicationIds to monitor.
INSERT  INTO #CN2InReqJobsList
SELECT  *
FROM    OPENXML(@idoc, '//CN2RunningJobsReq/runningJobs/job', 0)
WITH    #CN2InReqJobsList
ALTER TABLE #CN2InReqJobsList ADD  cvJobStatus INT
UPDATE #CN2InReqJobsList SET cvJobStatus  = -1
EXEC sp_xml_removedocument @idoc
-- GATHER ALL NATIVE RUNNING JOBS WHOSE STATUS CHANGED SINCE LAST FETCH
INSERT INTO #CN2AllRunningJobsList
  SELECT jobId,opType FROM JMJobInfo WHERE commCellId = 2 AND lastStateChangeTime > @lastJobStateChangeTime
-- Update the job category (backup/restore/admin) for there jobs
--UPDATE #CN2AllRunningJobsList SET category  = 1 WHERE
--opType IN (43,30,14,18,22,23,24,50,51,4,70,59,65,60,57,58,78,75) -- backup jobs
--UPDATE #CN2AllRunningJobsList SET category  = 2 WHERE
--opType IN (15,16,19,25,26,27,29,34,37,40,45,12,48,49,55,52,5,54,66) -- restore jobs
--UPDATE #CN2AllRunningJobsList SET category  = 3 WHERE category  = 0 -- admin jobs
-- Live Data Monitoring: Filter out backups jobs that user does not want monitored.
-- But take care that you dont filter out those jobs whose current status is requested.
DELETE FROM #CN2AllRunningJobsList
FROM
	JMBkpJobInfo RBJ
	LEFT JOIN #GRC2MonitoredAppIds MAPID ON RBJ.applicationId = MAPID.appId
	WHERE MAPID.appId IS NULL AND
	RBJ.jobId NOT IN (SELECT jobId FROM #CN2InReqJobsList)
AND #CN2AllRunningJobsList.jobId = RBJ.jobId
-- Now for each running backup job gather subclient info for which the job is running.
-- From backup jobs
INSERT INTO #CN2SubClientGUIDMap
SELECT AP.id, AP.GUID FROM JMBkpJobInfo AS BKPI
JOIN #CN2AllRunningJobsList as RJ ON BKPI.jobId = RJ.jobId
JOIN APP_Application AP ON BKPI.applicationId = AP.id
WHERE BKPI.commcellId = 2
-- From admin jobs
INSERT INTO #CN2SubClientGUIDMap
SELECT AP.id, AP.GUID FROM JMAdminJobInfoTable AS ADI
JOIN #CN2AllRunningJobsList as RJ ON ADI.jobId = RJ.jobId
JOIN APP_Application AP ON ADI.appID = AP.id
WHERE ADI.commcellId =  2 AND ADI.appID > 0
-- Gather bkpset/instance guids for restore jobs
INSERT INTO #CN2BkpSetGUIDMap
SELECT R.bkpSetID,AB.GUID
FROM JMRstJobInfo AS R
JOIN APP_BackupSetName AS AB ON AB.Id = R.bkpSetID AND AB.origCCID = R.commCellId
JOIN #CN2AllRunningJobsList as RJ ON R.jobId = RJ.jobId
WHERE R.commCellId = 2 AND R.bkpSetID > 0
INSERT INTO #CN2InstanceGUIDMap
SELECT R.instanceID,AI.GUID
FROM JMRstJobInfo AS R
JOIN APP_InstanceName AS AI ON AI.Id = R.instanceID AND AI.origCCID = R.commCellId
JOIN #CN2AllRunningJobsList as RJ ON R.jobId = RJ.jobId
WHERE R.commCellId = 2 AND R.instanceID > 0
UPDATE #CN2InReqJobsList SET  cvJobStatus = JMA.status
FROM JMAdminJobStatsTable AS JMA
WHERE JMA.jobId = #CN2InReqJobsList.jobId AND JMA.commcellID = 2
UPDATE #CN2InReqJobsList SET  cvJobStatus = JMB.status
FROM JMBkpStats AS JMB
WHERE JMB.jobId = #CN2InReqJobsList.jobId AND JMB.commcellID = 2
UPDATE #CN2InReqJobsList SET  cvJobStatus = JMR.status
FROM JMRestoreStats AS JMR
WHERE JMR.jobId = #CN2InReqJobsList.jobId AND JMR.commcellID = 2
SET @curJobGatherTime = dbo.GetUnixTime(GetUTCDate())
-- BUILD XML
SELECT
-- last job gather utc time
(SELECT @curJobGatherTime as [@timeVal] FOR XML PATH('lastJobUpdateTime'), TYPE),
(SELECT
-- ALL RUNNING JOBS
  (SELECT
	 	JMJI.jobId as [@jobId], initFrom as [@initFrom], JMJI.opType as [@opType], userId as [@userId],
		clientPriority as [@clientPriority],opPriority as [@opPriority], appPriority as [@appPriority],
		combPriority as [@combPriority],currentPhase as [@currentPhase],jobStartTime as [@jobStartTime],
		attemptStartTime as [@attemptStartTime],serverEndTime as [@serverEndTime], jobElapsedTime as [@jobElapsedTime],
		elapsedTime	as [@elapsedTime],lastStartOrRun as [@lastStartOrRun],phaseParams as [@phaseParams],
		restartString as [@restartString],startAttempts	as [@startAttempts],runAttempts as [@runAttempts],
		state as [@state],pendingCause as [@pendingCause],restartable as [@restartable],appArgs as [@appArgs],
		numOfFailures as [@numOfFailures],failureReason as [@failureReason],preemptable as [@preemptable],
		taskLinkID as [@taskLinkID],percentcomplete as [@percentcomplete],displayState	as [@displayState],
		commCellId as [@commCellId],resourcesAllocated as [@resourcesAllocated],currentContext as [@currentContext],
		libraryList	as [@libraryList],driveList	as [@driveList],opUsername as [@opUsername],phaseOnSuccess as [@phaseOnSuccess],
		interruptedPhase as [@interruptedPhase], errorType as [@errorType],licenseVerified as [@licenseVerified],
		currentPhaseName as [@currentPhaseName],timeToComplete as [@timeToComplete],lastUpdateFromClient as [@lastUpdateFromClient],
		lastStateChangeTime	as [@lastStateChangeTime],jobCategory as [@jobCategory],
		recoveredFromServiceRestart	as [@recoveredFromServiceRestart],noOfGUIMonitors as [@noOfGUIMonitors],
		isScheduledAlert as [@isScheduledAlert],jobBasedAlertId as [@jobBasedAlertId],alertName as [@alertName],
		shortMediaAgent as [@shortMediaAgent], seqNumber as [@seqNumber],activeFile	as [@activeFile],
		guiAlertColorLevel	as [@guiAlertColorLevel],jobDescription	as [@jobDescription],xmlJobInfo	as [@xmlJobInfo],
		subOpType as [@subOpType],foreignToken as [@foreignToken],preparedJobId	as [@preparedJobId]
		FROM  JMJobInfo AS JMJI
		JOIN  #CN2AllRunningJobsList as JR ON JR.jobId = JMJI.jobId
		WHERE JMJI.commCellId = 2
		order by JMJI.jobId
		FOR XML PATH ('job'),TYPE)
FOR XML PATH ('JMJobInfo'),TYPE),
--JobStats
(SELECT
  (SELECT  JMS.jobId as [@jobId],status as [@status],JMS.opType as [@opType],commCellId as [@commCellId],
	jobCategory as [@jobCategory], jobDescription as [@jobDescription],xmlJobInfo as [@xmlJobInfo],
	subOpType as [@subOpType],foreignToken as [@foreignToken]
		FROM JMJobStats AS  JMS
		JOIN  #CN2AllRunningJobsList as JR ON JR.jobId = JMS.jobId
		AND JMS.commCellId = 2
		FOR XML PATH ('job'),TYPE)
FOR XML PATH ('JMJobStats'),TYPE),
-- RUNNING BACKUP JOBS
(SELECT
	 (SELECT
	    JMBJI.jobId as [@jobId],commcellId as [@commcellId],applicationId as [@applicationId],numStreams as [@numStreams],
		currentPolicy as [@currentPolicy],targetCopyList as [@targetCopyList],bkpLevel as [@bkpLevel],
		indexOverride as [@indexOverride],startNewMedia as [@startNewMedia],compBytes as [@compBytes],
		unCompBytes as [@unCompBytes],filesToXfer as [@filesToXfer],backupTaskId as [@backupTaskId],
		scanFileFailures as [@scanFileFailures],scanFolderFailures as [@scanFolderFailures],
		backupFileFailures as [@backupFileFailures],backupFolderFailures as [@backupFolderFailures],
		shadowCopyId as [@shadowCopyId],bkpOptions as [@bkpOptions],oraSubLevel as [@oraSubLevel],
		bkpattributes as [@bkpattributes],dataPolicy as [@dataPolicy],logPolicy as [@logPolicy],
		filesXfered as [@filesXfered],currentThroughput as [@currentThroughput],averageThroughput as [@averageThroughput],
		filesIndexed as [@filesIndexed],filesFailedToIndex as [@filesFailedToIndex],filesSkippedForIndex as [@filesSkippedForIndex],
		contentIndexDBSize as [@contentIndexDBSize], totalMediaUsageTime as [@totalMediaUsageTime],mediaAgentName as [@mediaAgentName],
		scanType as [@scanType],scanTypeChangeReason as [@scanTypeChangeReason],numStreamsAllocated as [@numStreamsAllocated],
		maxRestarts as [@maxRestarts],restartInterval as [@restartInterval],cloudId as [@cloudId],diffPolicy as [@diffPolicy],
		targetClientId as [@targetClientId],unCompBytesToXfer as [@unCompBytesToXfer],secondaryBkpLevel as [@secondaryBkpLevel],
		jobIdActedOn as [@jobIdActedOn],fromTime as [@fromTime],toTime as [@toTime],nwTransBytes as [@nwTransBytes], totSkippedObjects as [@totSkippedObjects]
		FROM JMBkpJobInfo as JMBJI
		JOIN  #CN2AllRunningJobsList as JR ON JR.jobId = JMBJI.jobId
		WHERE JMBJI.commcellId = 2
	   FOR XML PATH ('job'),TYPE)
FOR XML PATH ('JMBkpJobInfo'),TYPE),
-- backup jobs attempts info
(SELECT
  (SELECT
    JMBAI.jobId as [@jobId],attemptNum as [@attemptNum],phaseNum as [@phaseNum],phaseName as [@phaseName],
	status as [@status],startTime as [@startTime],endTime as [@endTime],elapsedTime as [@elapsedTime],
	unCompBytes as [@unCompBytes],compBytes as [@compBytes],numFiles as [@numFiles],failureReason as [@failureReason],
	writeTime as [@writeTime],restartString as [@restartString],attributes as [@attributes],numFolders as [@numFolders],
	archGrpId as [@archGrpId],archGroupName as [@archGroupName],copyId as [@copyId],copyName as [@copyName],mediaAgent as [@mediaAgent],
	libraryName as [@libraryName],drivePoolName as [@drivePoolName],maxStreamsUsed as [@maxStreamsUsed],nwTransBytes as [@nwTransBytes],
    commCellId as [@commCellId],totalAllocationTime as [@totalAllocationTime],totalWaitTimeBeforeAllocation as [@totalWaitTimeBeforeAllocation]
  FROM JMBkpAttemptInfo AS JMBAI
  JOIN  #CN2AllRunningJobsList as JR ON JR.jobId = JMBAI.jobId
  WHERE JMBAI.commcellId  = 2
  FOR XML PATH ('jobat'),TYPE)
FOR XML PATH ('JMBkpAttemptInfo'),TYPE),
-- backup jobs streams info
(SELECT
 (SELECT
   JS.jobId as [@jobId],destRcId as [@destRcId],destReservationId as [@destReservationId],
   srcRcId as [@srcRcId],srcReservationId as [@srcReservationId],destMedAgent as [@destMedAgent],
   srcClient as [@srcClient],destDriveName as [@destDriveName],srcDriveName as [@srcDriveName],
   archGrpId as [@archGrpId],archGrpName as [@archGrpName],destCopyId as [@destCopyId],
   destCopyName as [@destCopyName],srcCopyId as [@srcCopyId],srcCopyName as [@srcCopyName],
   status as [@status],streamNum as [@streamNum],isPrimary as [@isPrimary],unCompBytes as [@unCompBytes],
   compBytes as [@compBytes],writeTime as [@writeTime],committedUncompBytes as [@committedUncompBytes],
   committedCompBytes as [@committedCompBytes],committedWriteTime as [@committedWriteTime],
   numFiles as [@numFiles],numFolders as [@numFolders],numFailures as [@numFailures],
   numSkipped as [@numSkipped],compScheme as [@compScheme],restartString as [@restartString],
   activeFile as [@activeFile],failureReason as [@failureReason],phaseNumber as [@phaseNumber],
   attemptNumber as [@attemptNumber],guiAlertColorLevel as [@guiAlertColorLevel],throughput as [@throughput],
   totalToCopy as [@totalToCopy],embeddedObjects as [@embeddedObjects],commCellId as [@commCellId],
   transCalcParams as [@transCalcParams],destStreamNum as [@destStreamNum],srcBarCode as [@srcBarCode],
   destBarCode as [@destBarCode],nwTransBytes as [@nwTransBytes]
 FROM JMJobStreams AS JS
 JOIN  #CN2AllRunningJobsList as JR ON JR.jobId = JS.jobId
 WHERE JS.commcellId = 2
 FOR XML PATH ('job'),TYPE)
 FOR XML PATH ('JMJobStreams'),TYPE),
 -- Job retention info.
(SELECT
  (SELECT
	JC.jobId as [@jobId],appId as [@appId],archGrpId as [@archGrpId],archGrpCopyId as[@archGrpCopyId],
	commCellId as [@commCellId],retentionFlags as [@retentionFlags],retentionDays as [@retentionDays]
   FROM JMJobCopyInfo AS JC
   JOIN  #CN2AllRunningJobsList as JR ON JR.jobId = JC.jobId
   WHERE JC.commcellId = 2
   FOR XML PATH('job'),TYPE)
FOR XML PATH('JMJobCopyInfo'),TYPE),
-- admin jobs
(SELECT
 (SELECT
	JMAI.jobId as [@jobId],JMAI.opType as [@opType],status as [@status],servStart as [@servStart],servEnd as [@servEnd],
	archGrpID as [@archGrpID],archGrpName as [@archGrpName],AP_NumDays as [@AP_NumDays],AP_IsForecast as [@AP_IsForecast],
	AP_SeqNum as [@AP_SeqNum],AC_NewMediaFlag as [@AC_NewMediaFlag],ER_BkpLevel as [@ER_BkpLevel],ER_DbName as [@ER_DbName],
	ER_Destination as [@ER_Destination],ER_SendCount as [@ER_SendCount],ER_MediasUsed as [@ER_MediasUsed],
	TotalObjects as [@TotalObjects],ObjectsDone as [@ObjectsDone],ObjectsFailed as [@ObjectsFailed],
	archGrpCopyID as [@archGrpCopyID],LibraryID as [@LibraryID],MI_InventoryType as [@MI_InventoryType],
	currentWriteTime as [@currentWriteTime],noOfStreams as [@noOfStreams],appID as [@appID],
	dependantJobId as [@dependantJobId],workFlowId as [@workFlowId],srcMediaAgent as [@srcMediaAgent],
	destMediaAgent as [@destMediaAgent],drivePoolId as [@drivePoolId],mediaId as [@mediaId],
	sourceJobId as [@sourceJobId],TotalSize as [@TotalSize],noOfStreamsAllocated as [@noOfStreamsAllocated],
	maxRestarts as [@maxRestarts],restartInterval as [@restartInterval],embeddedObjects as [@embeddedObjects],
	uncompBytes as [@uncompBytes],numFiles as [@numFiles],skippedItems as [@skippedItems],writeTime as [@writeTime],
	reportType as [@reportType],cloudId as [@cloudId],reportSetId as [@reportSetId],reportName as [@reportName],
	reportSetName as [@reportSetName],fromTime as [@fromTime],toTime as [@toTime],subTaskId as [@subTaskId],
	otherOpName as [@otherOpName],nwTransBytes as [@nwTransBytes],commCellId as [@commCellId]
  FROM JMAdminJobInfoTable AS JMAI
  JOIN  #CN2AllRunningJobsList as JR ON JR.jobId = JMAI.jobId
  WHERE JMAI.commcellId = 2
  FOR XML PATH ('job'),TYPE)
FOR XML PATH ('JMAdminJobInfoTable'),TYPE),
-- admin job attempts
(SELECT
  (SELECT
	JMAAI.jobId as [@jobId],attemptNum as [@attemptNum],phaseNum as [@phaseNum],phaseName as [@phaseName],
	status as [@status],startTime as [@startTime],endTime as [@endTime],elapsedTime as [@elapsedTime],
	failureReason as [@failureReason],writeTime as [@writeTime],embeddedObjects as [@embeddedObjects],
	uncompBytes as [@uncompBytes],numFiles as [@numFiles],skippedItems as [@skippedItems],
	TotalSize as [@TotalSize],nwTransBytes as [@nwTransBytes],commCellId as [@commCellId],
	totalAllocationTime as [@totalAllocationTime], totalWaitTimeBeforeAllocation as [@totalWaitTimeBeforeAllocation]
  FROM JMAdminJobAttemptInfoTable AS JMAAI
  JOIN  #CN2AllRunningJobsList as JR ON JR.jobId = JMAAI.jobId
  WHERE JMAAI.commcellId = 2
  FOR XML PATH('jobat'),TYPE)
FOR XML PATH ('JMAdminJobAttemptInfoTable'),TYPE),
-- RUNNING RESTORE JOBS
 (SELECT
	 (SELECT
	    JMRJI.jobId as [@jobId],appType as [@appType],srcClientId as [@srcClientId],destClientId as [@destClientId],
		commCellId as [@commCellId],srcClientName as [@srcClientName],destClientName as [@destClientName],
		bkpSetID as [@bkpSetID],totCompBytes as [@totCompBytes],totUnCompBytes as [@totUnCompBytes],
		totSuccess as [@totSuccess],totFailures as [@totFailures],totFiles2Xfer as [@totFiles2Xfer],
		rstTaskID as [@rstTaskID],instanceID as [@instanceID],
		totBytes2Xfer as [@totBytes2Xfer],dmUserName as [@dmUserName],volumeId as [@volumeId],
		totSkipped as [@totSkipped],curDatabase as [@curDatabase],mediaAgent as [@mediaAgent],
		maxRestarts as [@maxRestarts],restartInterval as [@restartInterval],rstattributes as [@rstattributes]
		FROM JMRstJobInfo as JMRJI
		JOIN  #CN2AllRunningJobsList as JR ON JR.jobId = JMRJI.jobId
		WHERE JMRJI.commcellId = 2
	   FOR XML PATH ('job'),TYPE)
FOR XML PATH ('JMRstJobInfo'),TYPE),
-- restore jobs attempts info
(SELECT
  (SELECT
    JMRAI.jobId as [@jobId],attemptNum as [@attemptNum],phaseNum as [@phaseNum],
	status as [@status],numSuccess_h as [@numSuccess_h],numSuccess_l as [@numSuccess_l],numFailures_h as [@numFailures_h],
	numFailures_l as [@numFailures_l],compBytes_h as [@compBytes_h],compBytes_l as [@compBytes_l],uCompBytes_h as [@uCompBytes_h],
	uCompBytes_l as [@uCompBytes_l],elapsedTime as [@elapsedTime],startTime as [@startTime],endTime as [@endTime],
	failureReason as [@failureReason],numSkipped as [@numSkipped],commCellId as [@commCellId]
  FROM JMRstAttemptInfo AS JMRAI
  JOIN  #CN2AllRunningJobsList as JR ON JR.jobId = JMRAI.jobId
  WHERE JMRAI.commCellId  = 2
  FOR XML PATH ('jobat'),TYPE)
FOR XML PATH ('JMRstAttemptInfo'),TYPE),
-- APPID-GUID MAP
(SELECT
	(SELECT appID	as [@appID], appGUID as [@guid]
    FROM #CN2SubClientGUIDMap
		FOR XML PATH ('itm'),TYPE)
 FOR XML PATH ('appidguidmap'),TYPE),
--BKPSET GUID MAP
(SELECT
  (SELECT  bkpSetID as [@bkpSetID], bkpGUID	as [@bkpGUID]
	FROM #CN2BkpSetGUIDMap
	FOR XML PATH ('itm'),TYPE)
FOR XML PATH('bkpsetguidmap'),TYPE),
--INSTANCE GUID MAP
(SELECT
  (SELECT  instID as [@instID], instGUID	as [@instGUID]
	FROM #CN2InstanceGUIDMap
	FOR XML PATH ('itm'),TYPE)
FOR XML PATH('instanceguidmap'),TYPE),
 -- Send status of requested jobs
 (SELECT
   (SELECT  JMS.jobId as [@jobId],status as [@status],opType as [@opType],commCellId as [@commCellId],
	jobCategory as [@jobCategory], jobDescription as [@jobDescription],xmlJobInfo as [@xmlJobInfo],
	subOpType as [@subOpType],foreignToken as [@foreignToken], INR.cvJobStatus as [@cvJobStatus]
		FROM JMJobStats as JMS,#CN2InReqJobsList AS INR
		WHERE JMS.jobId = INR.jobId AND JMS.commcellId = 2
	FOR XML PATH ('job'),TYPE)
 FOR XML PATH ('respjobstatus'),TYPE)
FOR XML PATH('CommNet2_CN2FastSyncRunningJobs')
DROP TABLE #CN2AllRunningJobsList
DROP TABLE #CN2SubClientGUIDMap
DROP TABLE #CN2InReqJobsList
DROP TABLE #CN2BkpSetGUIDMap
DROP TABLE #CN2InstanceGUIDMap
DROP TABLE #GRC2SelectedEntities
DROP TABLE #GRC2MonitoredAppIds
END
GO

IF EXISTS (select * from GxQscripts where name = 'CN2GetRunningJobs')
	delete from GxQscripts where name = 'CN2GetRunningJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CN2GetRunningJobs')
	delete from GXDBVersions where aliasname = 'CN2GetRunningJobs'
GO

insert into GXDBVersions values(2, 'CN2GetRunningJobs',  '00000000000000000000', 'CN2GetRunningJobs', '00000000000000000000')
GO

