

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/CM_GenerateInvoice.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/CM_GenerateInvoice.sp,v $ $Id: CM_GenerateInvoice.sp,v 1.1.2.49 2020/01/05 03:53:34 bheemesh Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CM_GenerateInvoice')
BEGIN
	print '>>> Drop Stored Procedure: CM_GenerateInvoice <<<'
	drop procedure CM_GenerateInvoice
END
IF EXISTS (select * from GxQscripts where name='CM_GenerateInvoice')
	delete from GxQscripts where name = 'CM_GenerateInvoice'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CM_GenerateInvoice')
	delete from GXDBVersions where aliasname = 'CM_GenerateInvoice'
GO
print '... Creating Procedure: CM_GenerateInvoice'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CM_GenerateInvoice
  @i_UserId INT = NULL,
  @i_GroupId INT = 0,
  @i_Month DATETIME = NULL,
  @i_IsQuarterly INT = 0,
  @i_AggregatorId INT = 0,
  @i_DetailedReport INT = 0,
  @i_InvokedFrom INT = 0 --0-stored procedure is invoked from billing portal, 1-sp is invoked from billing history custom report, 2-sp is invoked from SP13 custom report to display details, 3-sp is invoked from SP14 custom report to display details
AS
SET NOCOUNT ON
-- ----------------------------------------------------------------------------
--   VARIABLES
-- ----------------------------------------------------------------------------
DECLARE @retValue   INT = 0
DECLARE @errMsg     VARCHAR(256) = 'Procedure Completed Successfully'
DECLARE @bytesInTB  BIGINT = 1099511627776
DECLARE @contractId INT = 0
DECLARE @subMonth   INT = -1
DECLARE @monthCount INT = 1
DECLARE @baseCurrency NVARCHAR(10) = 'USD'
DECLARE @totalAmountDue FLOAT = 0
DECLARE @useAsPO INT = 0 -- [0=use Royalty Report as Purchase Order] [1=there is a seperate PO and hence do not use RR as PO]
DECLARE @minFee FLOAT = 0
DECLARE @spName NVARCHAR(256) = '(default)'
DECLARE @contractType INT = 0 --[0=Generate CommCell based Royalty Report (which is the default), 1=Generate Tenant based Royalty Report (newly introduced from V11-SP12)]
-- variables for eSim check
DECLARE @eSimOn INT = 0 -- [0=flag is ON, bill at eSim rate] [1,2,3=flag is OFF, bill at DPF rate]
DECLARE @userCount INT = 0
DECLARE @deviceCount INT = 0
DECLARE @deviceSize BIGINT = 0
DECLARE @maxDeviceCount INT = 5
DECLARE @maxDeviceSizeInGB INT = 2048 -- 2TB
DECLARE @DPF_billingGroupID INT = 0 -- placeholder for the Data Protection Foundation billing group at which the 'Server File System' usage is charged in this contract
DECLARE @eSIM_billingGroupID INT = 0 -- placeholder for the eSIM billing group at which the 'end point user' usage is charged in this contract
DECLARE @comment VARCHAR(250) = ''
DECLARE @FSOLicType INT = 0
DECLARE @DLOLicType INT = 0
DECLARE @bullet varchar(10) = ''--char(187) + ' ';
-- ----------------------------------------------------------------------------
--   Start a Transaction
-- ----------------------------------------------------------------------------
BEGIN TRANSACTION
    -- ----------------------------------------------------------------------------
    --   TRY-CATCH Block
    -- ----------------------------------------------------------------------------
    BEGIN TRY
        -- ----------------------------------------------------------------------------
        -- ------------assign variables that needs to be set only once and need not be iterated in below WHILE loop------------ --
        -- find contract mapped to this client group/aggregator
        -- starting V11SP10 there are 3 levels of royalty reports - commcell group level with no minimum fee, service provider (also called aggregator here) with minimum fee, partners with no minimum fee but having discount
        IF @i_AggregatorId = 0
        BEGIN
            SELECT @contractId=contractId, @useAsPO=useAsPO, @minFee=0 FROM cm_ClientGroupToContractMap WITH (NOLOCK) WHERE clientGroupId=@i_GroupId
        END
        ELSE
        BEGIN
            SELECT @spName=aggregatorName FROM cm_Aggregator WHERE aggregatorId=@i_AggregatorId
            SET @spName=@spName+' (default)'--if organization name is NULL, we have to default it to the Service Provider name
            DECLARE @contractName NVARCHAR(255)=''
            -- there is no minimum fee requirement for aggregators
            SELECT @contractId=contractId, @useAsPO=useAsPO, @minFee=0 FROM cm_AggregatorToContractMap WITH (NOLOCK) WHERE aggregatorId=@i_AggregatorId
            SET @contractName='Legacy Partner Contract'--all aggregator and partner reports should be associated to legacy contract from V11SP10
            IF @contractName='Legacy Partner Contract'
            BEGIN
                -- existing aggregators have separate pricing defined for each CommCell Group. Hence need to find their contracts from cm_ClientGroupToContractMap table
                SELECT @contractId=contractId, @minFee=0 FROM cm_ClientGroupToContractMap WITH (NOLOCK) WHERE clientGroupId=@i_GroupId
            END
        END
        -- find currency in which the Royalty Report should be generated
        SELECT @baseCurrency=currencyCode, @contractType=flag
        FROM cm_Contract WITH (NOLOCK)
        WHERE contractId=@contractId
        DECLARE @currencySymbol NVARCHAR(10)=''
        DECLARE @xml1 XML
        SELECT @xml1=Value
        FROM cf_SurveyConfig
        WHERE Name='BillingCurrencyList'
        SELECT @currencySymbol=doc.currency.value('@currencySymbol', 'NVARCHAR(10)')
        FROM @xml1.nodes('/BillingCurrencies/Currency') doc(currency)
        WHERE doc.currency.value('@currencyCode', 'NVARCHAR(10)')=@baseCurrency
        IF ISNULL(LEN(@currencySymbol),0) > 0
        BEGIN
            SELECT @baseCurrency=@currencySymbol
        END
        -- find eSim limits
        SELECT @maxDeviceCount=value FROM cf_SurveyConfig WITH (NOLOCK) WHERE name='eSimMaxDeviceLimit'
        SELECT @maxDeviceSizeInGB=value FROM cf_SurveyConfig WITH (NOLOCK) WHERE name='eSimMaxSizeLimit'
        -- ----------------------------------------------------------------------------
        IF object_id('tempdb.dbo.#tempAgents') IS NOT null DROP TABLE #tempAgents
            CREATE TABLE #tempAgents(csid NVARCHAR(40),typeId INT, capacityUsage BIGINT, agentUsage INT, bgid INT, licType INT)
		IF object_id('tempdb.dbo.#tempSkuLicenses') IS NOT null DROP TABLE #tempSkuLicenses
            CREATE TABLE #tempSkuLicenses(csid NVARCHAR(40), lictype INT, capacityUsage BIGINT, licenseUsage INT, bgid INT, planName NVARCHAR(1024), basePlanName NVARCHAR(1024))
        IF object_id('tempdb.dbo.#tempLicenses') IS NOT null DROP TABLE #tempLicenses
            CREATE TABLE #tempLicenses(csid NVARCHAR(40), lictype INT, capacityUsage BIGINT, licenseUsage INT, bgid INT)
        IF object_id('tempdb.dbo.#tempUsage') IS NOT null DROP TABLE #tempUsage
            CREATE TABLE #tempUsage(id INT IDENTITY(1,1),csid NVARCHAR(40), bgid INT, bgName NVARCHAR(1024), countingType INT, usage BIGINT, ccid VARCHAR(32), ccname NVARCHAR(1024), baseline FLOAT, utilityUsage FLOAT, averageCost FLOAT, costPerSku FLOAT)
        IF object_id('tempdb.dbo.#tempBilling') IS NOT null DROP TABLE #tempBilling
            CREATE TABLE #tempBilling(id INT IDENTITY(1,1),BillingGroupId INT, BillingGroupName NVARCHAR(1024), Description NVARCHAR(MAX), CountingType INT, BaseLine FLOAT, Price FLOAT, LowerLimit INT, UpperLimit INT, TotalUsage FLOAT, UsagePerTier FLOAT, CostPerTier FLOAT, TotalCost FLOAT, ActualUsage FLOAT,tenantId NVARCHAR(40),tenantName NVARCHAR(1024))
        IF object_id('tempdb.dbo.#tempDetails') IS NOT null DROP TABLE #tempDetails
            CREATE TABLE #tempDetails(csid INT,clientId INT,spId INT,appId INT,appTypeId INT,licType INT,isVM INT,jobId INT,jobType INT,appSizeMB BIGINT,vmClientId INT, bgid INT, entityType INT, countingType INT, countingEntity INT, organization NVARCHAR(1024), organizationId NVARCHAR(40))
        IF object_id('tempdb.dbo.#tempTenantUsage') IS NOT null DROP TABLE #tempTenantUsage
            CREATE TABLE #tempTenantUsage(id INT IDENTITY(1,1),tenantId NVARCHAR(40), tenantName NVARCHAR(1024), bgName NVARCHAR(1024), countingType FLOAT, totalUsage FLOAT, baseline FLOAT, utilityUsage FLOAT, averageCost FLOAT, totalCost FLOAT)
        IF object_id('tempdb.dbo.#tempSCLUsageDetails') IS NOT null DROP TABLE #tempSCLUsageDetails
            CREATE TABLE #tempSCLUsageDetails(id INT IDENTITY(1,1), csid INT, nJobType INT, appId INT, jobId INT, clientId INT, appTypeId INT, spId INT, appSizeMB BIGINT, licType INT, organization NVARCHAR(1024), organizationId VARCHAR(40), bgId INT, entityType INT, planName NVARCHAR(1024))
        IF object_id('tempdb.dbo.#tempSCLCALDetails') IS NOT null DROP TABLE #tempSCLCALDetails
            CREATE TABLE #tempSCLCALDetails(id INT IDENTITY(1,1), csid INT, ObjectId INT, objectName NVARCHAR(1024), licType INT, organization NVARCHAR(1024), organizationId VARCHAR(40), bgId INT, entityType INT, planName NVARCHAR(1024))
        IF object_id('tempdb.dbo.#tempUsageDetails') IS NOT null DROP TABLE #tempUsageDetails
            CREATE TABLE #tempUsageDetails(nJobType INT, AppId INT, JobId INT, ClientId INT, AppTypeId INT, SPId INT, AppSizeMB BIGINT, LicType INT, IsVM INT, CapacityFlag INT, Organization NVARCHAR(1024), OrgGUID VARCHAR(40), PlanName NVARCHAR(1024))
        IF object_id('tempdb.dbo.#tempCALDetails') IS NOT null DROP TABLE #tempCALDetails
            CREATE TABLE #tempCALDetails(ObjectType INT, ClientId INT, JobId INT, AppSizeMB BIGINT, ObjectId INT, ObjectName NVARCHAR(1024), Organization NVARCHAR(1024), OrgGUID VARCHAR(40), PlanName NVARCHAR(1024))
        IF object_id('tempdb.dbo.#tempPeakUsage') IS NOT null DROP TABLE #tempPeakUsage
            CREATE TABLE #tempPeakUsage(UsageType INT, ClientId INT, ClientName NVARCHAR(255), SubclientId INT, SubclientName NVARCHAR(255), AppTypeId INT, LicType INT, BackupSetId BIGINT, BackupSetName NVARCHAR(1024), InstanceId INT, InstanceName NVARCHAR(1024), SPId INT, SPName NVARCHAR(1024), JobId INT, AppSizeMB BIGINT, CapacityFlag INT, VMFlag INT, ObjectName NVARCHAR(1024), ObjectId INT, Organization NVARCHAR(1024), OrgGUID VARCHAR(40), PlanName NVARCHAR(1024), BasePlanName NVARCHAR(1024))
        IF object_id('tempdb.dbo.#tempBillingDetails') IS NOT null DROP TABLE #tempBillingDetails
            CREATE TABLE #tempBillingDetails(id INT IDENTITY(1,1), csid INT, ClientId INT, ClientName NVARCHAR(255), SubclientId INT, SubclientName NVARCHAR(255), AppTypeId INT, LicType INT, BackupSetId BIGINT, BackupSetName NVARCHAR(1024), InstanceId INT, InstanceName NVARCHAR(1024), SPId INT, SPName NVARCHAR(1024), JobId INT, JobType INT, AppSizeMB BIGINT, ObjectName NVARCHAR(1024), ObjectId INT, Organization NVARCHAR(1024), OrgGUID VARCHAR(40), PlanName NVARCHAR(1024), bgId INT, entityType INT, countingType INT, BasePlanName NVARCHAR(1024))
		IF object_id('tempdb.dbo.#appClientsUnderFSO_Backup') IS NOT null DROP TABLE #appClientsUnderFSO_Backup
            CREATE TABLE #appClientsUnderFSO_Backup(clientId INT)
		IF object_id('tempdb.dbo.#tblAgents') IS NOT null DROP TABLE #tblAgents
            CREATE TABLE #tblAgents(csid NVARCHAR(40),typeId INT, capacityUsage BIGINT, agentUsage INT, bgid INT, licType INT)
		IF object_id('tempdb.dbo.#tblLicenses') IS NOT null DROP TABLE #tblLicenses
            CREATE TABLE #tblLicenses(csid NVARCHAR(40), lictype INT, capacityUsage BIGINT, licenseUsage INT, bgid INT)
		IF object_id('tempdb.dbo.#tblSkuLicenses') IS NOT null DROP TABLE #tblSkuLicenses
            CREATE TABLE #tblSkuLicenses(csid NVARCHAR(40), lictype INT, capacityUsage BIGINT, licenseUsage INT, bgid INT, planName NVARCHAR(1024), basePlanName NVARCHAR(1024))
		IF object_id('tempdb.dbo.#appJobs') IS NOT null DROP TABLE #appJobs
            CREATE TABLE #appJobs(jobId INT)
		IF object_id('tempdb.dbo.#latestTenantDetails') IS NOT null DROP TABLE #latestTenantDetails
            CREATE TABLE #latestTenantDetails(tenantId NVARCHAR(40), tenant NVARCHAR(1024), peakDate DATETIME)
		IF object_id('tempdb.dbo.#licMapTbl') IS NOT null DROP TABLE #licMapTbl
            CREATE TABLE #licMapTbl(licType INT, countingType INT, bgId INT, planType INT, planName NVARCHAR(1024))
		IF object_id('tempdb.dbo.#agMapTbl') IS NOT null DROP TABLE #agMapTbl
            CREATE TABLE #agMapTbl(agType INT, countingType INT, bgId INT)
		IF object_id('tempdb.dbo.#bgMapTbl') IS NOT null DROP TABLE #bgMapTbl
            CREATE TABLE #bgMapTbl(bgid INT)
		IF object_id('tempdb.dbo.#CIObjectTenantTable') IS NOT null DROP TABLE #CIObjectTenantTable
            CREATE TABLE #CIObjectTenantTable(tenantId VARCHAR(40), usage DECIMAL(18,3))
		IF object_id('tempdb.dbo.#tempRegularLicDetails') IS NOT null DROP TABLE #tempRegularLicDetails
            CREATE TABLE #tempRegularLicDetails(clientId INT,spId INT,appId INT,appTypeId INT,licType INT,isVM INT,jobId INT,jobType INT,appSizeMB BIGINT,vmClientId INT,organization NVARCHAR(1024),organizationId NVARCHAR(40))
		IF object_id('tempdb.dbo.#tempNewVMLicTypes') IS NOT null DROP TABLE #tempNewVMLicTypes
            CREATE TABLE #tempNewVMLicTypes(clientId INT, VMClientId INT, licType INT, appTypeId INT, jobId INT, organization NVARCHAR(1024), organizationId NVARCHAR(40))
		IF object_id('tempdb.dbo.#AppUsers') IS NOT NULL DROP TABLE #AppUsers
			CREATE TABLE #AppUsers(Smtp NVARCHAR(1024), OrgGUID VARCHAR(40), Organization NVARCHAR(1024), PlanName NVARCHAR(1024), BasePlanName NVARCHAR(1024), VMFlag INT)
        IF @i_IsQuarterly = 1
            SET @monthCount = 3
        WHILE (@monthCount > 0)
        BEGIN
        --clean all the temp tables before each iteration of while loop
        TRUNCATE TABLE #tempAgents
		TRUNCATE TABLE #tempSkuLicenses
        TRUNCATE TABLE #tempLicenses
        TRUNCATE TABLE #tempUsage
        TRUNCATE TABLE #tempBilling
        TRUNCATE TABLE #tempDetails
        TRUNCATE TABLE #tempTenantUsage
        TRUNCATE TABLE #tempSCLUsageDetails
        TRUNCATE TABLE #tempSCLCALDetails
        TRUNCATE TABLE #tempBillingDetails
		TRUNCATE TABLE #appClientsUnderFSO_Backup
		TRUNCATE TABLE #tblAgents
		TRUNCATE TABLE #tblLicenses
		TRUNCATE TABLE #tblSkuLicenses
		TRUNCATE TABLE #appJobs
		TRUNCATE TABLE #latestTenantDetails
		TRUNCATE TABLE #licMapTbl
		TRUNCATE TABLE #agMapTbl
		TRUNCATE TABLE #bgMapTbl
		TRUNCATE TABLE #CIObjectTenantTable
		TRUNCATE TABLE #tempRegularLicDetails
		TRUNCATE TABLE #tempNewVMLicTypes
		TRUNCATE TABLE #AppUsers
        -- ----------------------------------------------------------------------------
        DECLARE @table1Exist INT=0, @table2Exist INT=0
        DECLARE @FSOnlyServerLicType INT = 100029, @DLOnlyLicType INT = 200002, @APPServerLicType INT = 100030, @LiveSyncVMLicType INT = 200016, @FSOnlyVMLicType INT = 200017, @OILicType INT = 100032, @VOILicType INT = 100033
        DECLARE @ACVLicType INT = 100027, @VMWithAppLicType INT = 200003, @VMOnlyLicType INT = 200001, @ProtectedVMLicType INT = 100019, @VirtualMachineLicType INT = 100011, @ProtectedVMLicTypeInSku INT = 0, @VMSocketsLicType INT = 100018
        DECLARE @DPELicType INT = 100002, @DAELicType INT = 100004, @DPSLicType INT = 100005, @DPRLicType INT = 100006
        DECLARE @epUsers INT = 100024, @sharingUsers INT = 100025, @eDiscoveryUsers INT = 100026, @mSimUsers INT = 100028, @CIObjects INT = 100017, @appStoreUsage INT = 100031, @dedupeStoreSpace INT = 100016, @diskLibrarySpace INT = 100015
        DECLARE @mbUsers INT = 200011, @spUsers INT = 200012, @gmUsers INT = 200013, @gdUsers INT = 200014, @odUsers INT = 200015, @sfUsers INT = 200018, @ntUsers INT = 200019, @ciUsers INT = 300001, @csUsers INT = 300002, @cmUsers INT = 300003, @hyperScale INT = 300004
		DECLARE @mbxe INT = 0, @mbxf INT = 0, @mbxa INT = 0
        DECLARE @CIObjectFlg INT = 0, @esimFlag INT =0
        DECLARE @CIObjectTenantCount INT = 0, @CIObjectUsage BIGINT = 0
		DECLARE @commServUniqueId INT = 0
        IF @contractType=0
        BEGIN
            INSERT #bgMapTbl
            SELECT billingGroupId FROM cm_ContractToBillingGroupMap WITH (NOLOCK) WHERE contractId=@contractId
        END
        ELSE
        BEGIN
            INSERT #bgMapTbl
            SELECT billingGroupId FROM cm_ContractToTenantToBillingGroupMap WITH (NOLOCK) WHERE contractId=@contractId
        END
        SET @ProtectedVMLicTypeInSku = @ProtectedVMLicType --Protected Virtual Machines (100019)
        IF EXISTS(SELECT TOP 1 billingGroupId FROM cm_BillingGroupToLicenseMap WITH (NOLOCK) WHERE billingGroupId IN (SELECT bgid FROM #bgMapTbl)
        AND entityType=1 AND entityId=@VirtualMachineLicType)
        BEGIN
            --Currently all SKUs charging Protected VMs are mapped to old license type 100011 (Virtual Machines)
            SET @ProtectedVMLicTypeInSku = @VirtualMachineLicType
        END
        --get usage details of licenses
        INSERT #licMapTbl
        SELECT DISTINCT L.entityId, B.countingType, B.billingGroupId, B.flag, ISNULL(B.planName,'N/A') FROM cm_BillingGroupToLicenseMap L
        LEFT JOIN cm_BillingGroup B ON B.billingGroupId=L.billingGroupId
        WHERE L.billingGroupId IN (SELECT DISTINCT bgid FROM #bgMapTbl) AND entityType=1
        --UPDATE #licMapTbl SET licType=@ProtectedVMLicType WHERE licType=@VirtualMachineLicType
        --get usage details of agents
        INSERT #agMapTbl
        SELECT DISTINCT L.entityId, B.countingType, B.billingGroupId FROM cm_BillingGroupToLicenseMap L
        LEFT JOIN cm_BillingGroup B ON B.billingGroupId=L.billingGroupId
        WHERE L.billingGroupId IN (SELECT DISTINCT bgid FROM #bgMapTbl) AND entityType=0
        DECLARE @CommCellsCursor AS CURSOR;
        SET @CommCellsCursor = CURSOR FAST_FORWARD FOR
        SELECT CommcellIdNameMap_ID FROM cf_CommcellGroupAssoc WITH (NOLOCK) WHERE commcellGroupId=@i_GroupId;
        OPEN @CommCellsCursor;
        FETCH NEXT FROM @CommCellsCursor INTO @commServUniqueId
        WHILE @@FETCH_STATUS = 0
        BEGIN
            SET @table1Exist=0
            SET @table2Exist=0
            IF object_id('dbo.Lic_PeakUsage') IS NOT NULL--license reporting V3 tables. This will be used for V4 of billing
            BEGIN--there should be atleast one SCL peak entry in this new table (PeakType=1 for SCL data). Collected by query238
                IF EXISTS (SELECT 1 FROM Lic_PeakUsage WITH (NOLOCK) WHERE CommServUniqueId = @commServUniqueId AND PeakType=1 AND MonthStart BETWEEN (SELECT DATEADD(MONTH,@subMonth,@i_Month)) AND @i_Month)
                BEGIN
                    SET @table1Exist=3
                    SET @table2Exist=3--we have only 1 table here. But still need to set this variable for some conditions below to work correctly
                END
            END
            IF (@table1Exist<>3 OR @table2Exist<>3)--check for usage from query231 only if usages from query238 are not present
            BEGIN--Collected by query231
                IF object_id('dbo.cf_SurveyLicSCLPeakUsageDetails') IS NOT NULL--license reporting V2 tables. This will be used for V3 of billing
                BEGIN--there should be atleast one entry in this new table
                    IF EXISTS (SELECT 1 FROM cf_SurveyLicSCLPeakUsageDetails WITH (NOLOCK) WHERE CommServUniqueId = @commServUniqueId AND MonthStart BETWEEN (SELECT DATEADD(MONTH,@subMonth,@i_Month)) AND @i_Month)
                    BEGIN
                        SET @table1Exist=2
                        IF object_id('dbo.cf_SurveyLicSCLPeakCALDetails') IS NOT NULL
                        BEGIN--there should be atleast one entry in this new table
                            IF EXISTS (SELECT 1 FROM cf_SurveyLicSCLPeakCALDetails WITH (NOLOCK) WHERE CommServUniqueId = @commServUniqueId AND MonthStart BETWEEN (SELECT DATEADD(MONTH,@subMonth,@i_Month)) AND @i_Month)
                            BEGIN
                                SET @table2Exist=2
                            END
                        END
                    END
                END
                IF (@table1Exist<>2 OR @table2Exist<>2)--check for usage from query216 only if usages from query231 are not present
                BEGIN--Collected by query216
                    IF object_id('dbo.cf_SurveyLicPeakUsageDetails') IS NOT NULL
                    BEGIN--there should be atleast one entry in this new table and, should have data in the new format i.e., LicType column should have non zero numbers
                        IF EXISTS (SELECT TOP 1 CommServUniqueId FROM cf_SurveyLicPeakUsageDetails WITH (NOLOCK) WHERE ISNULL(LicType,0) > 0 AND CommServUniqueId = @commServUniqueId AND MonthStart BETWEEN (SELECT DATEADD(MONTH,@subMonth,@i_Month)) AND @i_Month)
                        BEGIN
                            SET @table1Exist=1
                        END
                    END
                    IF object_id('dbo.cf_SurveyLicPeakCLALicClientCount') IS NOT NULL
                    BEGIN
                        --If the 1st table has data in the required format then, it means the required updates are available in that CommServe
                        --but cases where found where we had entries in first table but not in CLA table. In such cases we still have to go back to old logic instead of new. Hence we have to further validate 2nd table
                        --first check if there is any VM related jobs in the first table (i.e., VSA agent jobs with AppType=106)
                        --if there is then, check if there is VM entries for that month in the CLA table. If yes - use new logic, if no - use old logic
                        IF @table1Exist=1
                        BEGIN
                            IF EXISTS (SELECT TOP 1 CommServUniqueId FROM cf_SurveyLicPeakUsageDetails WITH (NOLOCK) WHERE AppTypeId=106 AND CommServUniqueId = @commServUniqueId AND MonthStart BETWEEN (SELECT DATEADD(MONTH,-1,@i_Month)) AND @i_Month)
                            BEGIN
                                IF EXISTS (SELECT TOP 1 CommServUniqueId from cf_SurveyLicPeakCLALicClientCount WITH (NOLOCK) WHERE CommServUniqueId = @commServUniqueId AND MonthStart BETWEEN (SELECT DATEADD(MONTH,-1,@i_Month)) AND @i_Month)
                                BEGIN
                                    SET @table2Exist=1
                                END
                            END
                            ELSE
                            BEGIN
                                --there are no VM entries in first table. Hence we don't have to validate CLA table
                                --We will use the new logic irrespective of whether there are entries in CLA table or not
                                SET @table2Exist=1
                            END
                        END
                    END
                END
            END
            IF (@table1Exist=3)
            BEGIN
                -------------- collect usages of various licenses --------------
                TRUNCATE TABLE #tempPeakUsage
				TRUNCATE TABLE #AppUsers
				--get all billing usages
				INSERT #tempPeakUsage
				SELECT DISTINCT C.UsageType, ISNULL(C.ClientId,-1), CASE WHEN C.UsageType IN (26,33) THEN ISNULL(C.ClientName,'N/A') ELSE 'N/A' END,
			    CASE WHEN C.UsageType IN (1,2,3,4) THEN ISNULL(C.SubclientId,-1) ELSE -1 END, 'N/A', ISNULL(C.AppTypeId,-1), C.LicType,
				CASE WHEN C.UsageType=33 THEN CONVERT(BIGINT,ISNULL(C.ObjectName,-1)) ELSE -1 END, 'N/A', 0, 'N/A', 0, 'N/A', ISNULL(C.JobId,-1), ISNULL(C.AppSizeMB,-1),
				ISNULL(C.CapacityFlag,-1), ISNULL(C.VMFlag,-1), CASE WHEN C.UsageType IN (20,25,26) THEN ISNULL(C.ObjectName,'N/A') ELSE 'N/A' END, ISNULL(C.ObjectId,-1),
				CASE WHEN OrgGUID IS NULL THEN @spName END, ISNULL(CONVERT(VARCHAR(40),OrgGUID),'-1'), ISNULL(PlanName, 'N/A'), ISNULL(BasePlanName, 'N/A')
				FROM Lic_PeakUsage C WITH (NOLOCK)
                INNER JOIN cf_SurveyResultFuncV1(238, @commServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
				WHERE C.MonthStart BETWEEN (SELECT DATEADD(MONTH,@subMonth,@i_Month)) AND @i_Month
                AND C.PeakType=1--subclient peak is PeakType=1
                AND C.UsageType IN (1,2,3,4,5,8,9,19,20,22,23,24,25,26,27,28,29,30,31,33)
				--update capacity usages
				UPDATE C
				SET C.ClientName=ISNULL(CL.ClientName,'N/A'),C.SubclientName=ISNULL(SCL.SubclientName,'N/A'), C.AppTypeId=ISNULL(SCL.AppTypeId,0),
				C.BackupsetId=ISNULL(SCL.BackupSetId,0), C.BackupsetName=ISNULL(SCL.BackupSetName,'N/A'), C.InstanceId=ISNULL(SCL.InstanceId,0),
				C.InstanceName=ISNULL(SCL.InstanceName,'N/A'), C.SPId=ISNULL(SP.PolicyId,0), C.SPName=ISNULL(SP.PolicyName,'N/A')
				FROM #tempPeakUsage C
				LEFT JOIN cf_SurveyClient CL WITH(NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=@commServUniqueId
				LEFT JOIN cf_SurveySubclientAssociation SCL WITH(NOLOCK) ON SCL.ClientId=C.ClientId AND SCL.AppId=C.SubclientId AND SCL.CommServUniqueId=@commServUniqueId
				LEFT JOIN cf_SurveyCopyBasicRetention SP WITH(NOLOCK) ON SP.PolicyId=SCL.DataPolicyId AND SP.CommServUniqueId=@commServUniqueId
				WHERE C.UsageType IN (1,2,3,4)
				IF object_id('tempdb.dbo.#NoNeedBackupSet') IS NOT NULL DROP TABLE #NoNeedBackupSet
				CREATE TABLE #NoNeedBackupSet (apptype INT)
				INSERT INTO #NoNeedBackupSet VALUES
				(6),(32),(15),(9),(24),(25),(27),(31),(40),(2),(22),(23),(5),(48),(51),(47),(59),(67),(68),(65),(76),(75),(77),(80),(104),(4),(16),(70),(81),(61),(79),(53),(600),(601),(602),(604),(605),(606),(607),(128)
				UPDATE #tempPeakUsage
				SET BackupsetName = 'N/A'
				WHERE AppTypeId IN (SELECT apptype FROM #NoNeedBackupSet)
				IF object_id('tempdb.dbo.#NeedInstance') IS NOT NULL DROP TABLE #NeedInstance
				CREATE TABLE #NeedInstance (apptype INT)
				INSERT INTO #NeedInstance VALUES
				(3),(4),(16),(6),(7),(5),(126), (51),(52), (9),(8),(15),(14),(45), (2),(22),(23), (27),(31), (32),(35), (44), (37), (106), (54), (53), (55), (56),(60), (59), (57), (62), (67),(68),(69), (70),(77),(82),(80),(81),(90),(103),(104),(125),(58), (124), (131), (128),(79), (61), (134), (64), (135)
				UPDATE #tempPeakUsage
				SET InstanceName = 'N/A'
				WHERE AppTypeId NOT IN (SELECT apptype FROM #NeedInstance)
				IF object_id('tempdb.dbo.#NoNeedBackupSet') IS NOT NULL DROP TABLE #NoNeedBackupSet
				IF object_id('tempdb.dbo.#NeedInstance') IS NOT NULL DROP TABLE #NeedInstance
				--update dummy license usages
				UPDATE C
				SET C.ClientName=ISNULL(CL.ClientName,'N/A')
				FROM #tempPeakUsage C
				LEFT JOIN cf_SurveyClient CL WITH(NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=@commServUniqueId
				WHERE C.UsageType IN (27,28,29,30,31)
				--update endpoint license usages
				UPDATE C
				SET C.BackupsetName=ISNULL(E.UserLogin,'N/A'), C.InstanceName=ISNULL(E.UserEmail,'N/A'), C.SPName=ISNULL(E.Associations,'N/A'), C.ObjectName=ISNULL(E.UserName,'N/A')
				FROM #tempPeakUsage C
				LEFT JOIN cf_SurveyEndusers E WITH(NOLOCK) ON E.UserId=C.ObjectId AND E.CommServUniqueId=@commServUniqueId
				WHERE C.UsageType IN (22,23,24)
				--update vm usages
				UPDATE C
				SET C.ObjectName=ISNULL(CL.ClientName,'N/A')
				FROM #tempPeakUsage C
				LEFT JOIN cf_SurveyClient CL WITH(NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=@commServUniqueId
				WHERE C.UsageType IN (19)
				--get sharepoint online users (usagetype=18, lictype=200012)
                INSERT #AppUsers
                SELECT DISTINCT ObjectName, ISNULL(CONVERT(VARCHAR(40),OrgGUID),'-1'), CASE WHEN OrgGUID IS NULL THEN @spName END, ISNULL(PlanName, 'N/A'), ISNULL(BasePlanName, 'N/A'), VMFlag
                FROM Lic_PeakUsage C WITH (NOLOCK)
                INNER JOIN cf_SurveyResultFuncV1(238, @commServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
                WHERE C.CommServUniqueId = @commServUniqueId
                AND C.MonthStart BETWEEN (SELECT DATEADD(MONTH,@subMonth,@i_Month)) AND @i_Month
                AND C.PeakType=1--subclient peak is PeakType=1
                AND C.UsageType=18
				AND LicType=@spUsers
				--remove rows with default plan if any row with non-default plan is present for the same sharepoint user
				DELETE A1 FROM #AppUsers A1
				INNER JOIN #AppUsers A2 ON A1.Smtp=A2.Smtp AND (A1.OrgGUID=A2.OrgGUID OR (A1.OrgGUID IS NULL AND A2.OrgGUID IS NULL))
				WHERE (A1.PlanName='N/A' AND A2.PlanName<>'N/A') OR (A1.BasePlanName='N/A' AND A2.BasePlanName<>'N/A')
				--add all application users including corrected sharepoint users to #temppeakusage table
				INSERT #tempPeakUsage
				SELECT 18,-1,'N/A',-1,'N/A',-1,@spUsers,-1,'N/A',-1,'N/A',-1,'N/A',0,0,-1,VMFlag,Smtp,0,Organization,OrgGUID,PlanName,BasePlanName
				FROM #AppUsers
				UNION
				SELECT 18,-1,'N/A',-1,'N/A',-1,LicType,-1,'N/A',-1,'N/A',-1,'N/A',0,0,-1,VMFlag,ObjectName,0,
				CASE WHEN OrgGUID IS NULL THEN @spName END, ISNULL(CONVERT(VARCHAR(40),OrgGUID),'-1'), ISNULL(PlanName, 'N/A'), ISNULL(BasePlanName, 'N/A')
                FROM Lic_PeakUsage C WITH (NOLOCK)
                INNER JOIN cf_SurveyResultFuncV1(238, @commServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
                WHERE C.CommServUniqueId = @commServUniqueId
                AND C.MonthStart BETWEEN (SELECT DATEADD(MONTH,@subMonth,@i_Month)) AND @i_Month
                AND C.PeakType=1--subclient peak is PeakType=1
                AND C.UsageType=18
				AND LicType<>@spUsers
				--update tenant names
				UPDATE C
				SET Organization=ISNULL(T.TenantName,'N/A')
				FROM #tempPeakUsage C
				LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=C.OrgGUID AND T.CommServUniqueId=@commServUniqueId
				WHERE C.OrgGUID<>'-1'
                --find those clients which should be billed as applicationServers but are actually mapped under FSO
                DELETE FROM #appClientsUnderFSO_Backup
                INSERT #appClientsUnderFSO_Backup
                SELECT DISTINCT ClientId FROM #tempPeakUsage WHERE UsageType=27--appserver
                UNION
                SELECT DISTINCT ClientId FROM #tempPeakUsage WHERE UsageType=19 AND VMFlag IN (4)--acv which are not protected
				--MR250226 - Temporary hack to prevent regression breakage in billing if plan usages are present
				update #tempPeakUsage set PlanName='N/A', BasePlanName='N/A'
				--VSA V2 change
				UPDATE #tempPeakUsage SET LicType=143 WHERE AppTypeId=106
                --FSOserver usage (backup)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@FSOnlyServerLicType AND countingType=1)--fsoserver with backup TB usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, U.ClientId, U.ClientName, U.SubclientId, U.SubclientName, U.AppTypeId, @FSOnlyServerLicType, U.BackupSetId, U.BackupSetName, U.InstanceId, U.InstanceName,
                    U.SPId, U.SPName, U.JobId, 0, U.AppSizeMB, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 1, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=1--backup jobs
                    AND U.ClientId IN (SELECT DISTINCT F.ClientId FROM #tempPeakUsage F WHERE F.UsageType=29 AND F.LicType=@FSOnlyServerLicType)--clients marked as FSOserver
                    AND U.ClientId NOT IN (SELECT DISTINCT ClientId FROM #appClientsUnderFSO_Backup)--ACV clients should be charged as AppServers
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@FSOnlyServerLicType AND countingType=0)--fsoserver backup CAL usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId,U.ClientId, U.ClientName,-1,'',-1,@FSOnlyServerLicType,-1,'',-1,'',-1,'',-1,-1,-1,'',-1,U.Organization,U.OrgGUID,U.PlanName,0,1,0,U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=1--backup jobs
					AND U.ClientId IN (SELECT DISTINCT F.ClientId FROM #tempPeakUsage F WHERE F.UsageType=29 AND F.LicType=@FSOnlyServerLicType)--clients marked as FSOserver
					AND U.ClientId NOT IN (SELECT DISTINCT ClientId FROM #appClientsUnderFSO_Backup)--ACV clients should be charged as AppServers
				END
				--FSOvm usage (backup)
				IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@FSOnlyVMLicType AND countingType=1)--fsovm with backup TB usage
				BEGIN
					INSERT #tempBillingDetails
					SELECT DISTINCT @commServUniqueId, U.ClientId, U.ClientName, U.SubclientId, U.SubclientName, U.AppTypeId, @FSOnlyVMLicType, U.BackupSetId, U.BackupSetName, U.InstanceId, U.InstanceName,
					U.SPId, U.SPName, U.JobId, 0, U.AppSizeMB, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 1, U.BasePlanName
					FROM #tempPeakUsage U
					WHERE U.UsageType=1--backup jobs
					AND U.ClientId IN (SELECT DISTINCT F.ClientId FROM #tempPeakUsage F WHERE F.UsageType=29 AND F.LicType=@FSOnlyVMLicType)--clients marked as FSOvm
					AND U.ClientId NOT IN (SELECT DISTINCT ClientId FROM #appClientsUnderFSO_Backup)--ACV clients should be charged as AppServers
				END
				ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@FSOnlyVMLicType AND countingType=0)--fsovm backup CAL usage
				BEGIN
					INSERT #tempBillingDetails
					SELECT DISTINCT @commServUniqueId,U.ClientId, U.ClientName,-1,'',-1,@FSOnlyVMLicType,-1,'',-1,'',-1,'',-1,-1,-1,'',-1,U.Organization,U.OrgGUID,U.PlanName,0,1,0,U.BasePlanName
					FROM #tempPeakUsage U
					WHERE U.UsageType=1--backup jobs
					AND U.ClientId IN (SELECT DISTINCT F.ClientId FROM #tempPeakUsage F WHERE F.UsageType=29 AND F.LicType=@FSOnlyVMLicType)--clients marked as FSOvm
                    AND U.ClientId NOT IN (SELECT DISTINCT ClientId FROM #appClientsUnderFSO_Backup)--ACV clients should be charged as AppServers
                END
				SET @esimFlag=0
			    IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType IN (@epUsers,@sharingUsers,@eDiscoveryUsers))
					SET @esimFlag=1
                --DLO usage (backup)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@DLOnlyLicType AND countingType=1) OR @esimFlag=1--dlo with backup TB usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, U.ClientId, U.ClientName, U.SubclientId, U.SubclientName, U.AppTypeId, @DLOnlyLicType, U.BackupSetId, U.BackupSetName, U.InstanceId, U.InstanceName,
                    U.SPId, U.SPName, U.JobId, 0, U.AppSizeMB, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 1, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=1--backup jobs
                    AND U.ClientId IN (SELECT DISTINCT D.ClientId FROM #tempPeakUsage D WHERE D.UsageType=28)--clients marked as DLO
                    AND U.ClientId NOT IN (SELECT DISTINCT ClientId FROM #appClientsUnderFSO_Backup)--ACV clients should be charged as AppServers
                END
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@DLOnlyLicType AND countingType=0) OR @esimFlag=1--dlo backup CAL usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId,U.ClientId, U.ClientName,-1,'',-1,@DLOnlyLicType,-1,'',-1,'',-1,'',-1,-1,-1,'',-1,U.Organization,U.OrgGUID,U.PlanName,0,1,0,U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=1--backup jobs
                    AND U.ClientId IN (SELECT DISTINCT D.ClientId FROM #tempPeakUsage D WHERE D.UsageType=28)--clients marked as DLO
                    AND U.ClientId NOT IN (SELECT DISTINCT ClientId FROM #appClientsUnderFSO_Backup)--ACV clients should be charged as AppServers
                END
                --AppServer usage (backup)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@APPServerLicType AND countingType=1)--appServer with backup TB usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, U.ClientId, U.ClientName, U.SubclientId, U.SubclientName, U.AppTypeId, @APPServerLicType, U.BackupSetId, U.BackupSetName, U.InstanceId, U.InstanceName,
                    U.SPId, U.SPName, U.JobId, 0, U.AppSizeMB, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 1, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=1--backup jobs
                    AND U.ClientId IN (SELECT DISTINCT ClientId FROM #appClientsUnderFSO_Backup)
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@APPServerLicType AND countingType=0)--appServer backup CAL usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId,U.ClientId, U.ClientName,-1,'',-1,@APPServerLicType,-1,'',-1,'',-1,'',-1,-1,-1,'',-1,U.Organization,U.OrgGUID,U.PlanName,0,1,0,U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=1--backup jobs
                    AND U.ClientId IN (SELECT DISTINCT ClientId FROM #appClientsUnderFSO_Backup)
                END
                --VM with App usage
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@VMWithAppLicType AND countingType=1)--VM with App TB usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, -1, '', -1, '', U.AppTypeId, @VMWithAppLicType, -1, '', -1, '', -1, '', U.JobId, -1, U.AppSizeMB, U.ObjectName, U.ObjectId, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 1, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=19 AND VMFlag=3
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@VMWithAppLicType AND countingType=0)--VM with App CAL usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, -1, '', -1, '', -1, @VMWithAppLicType, -1, '', -1, '', -1, '', -1, -1, -1, U.ObjectName, U.ObjectId, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=19 AND VMFlag=3
                END
                --VM only usage
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@VMOnlyLicType AND countingType=1)--VM only TB usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, -1, '', -1, '', U.AppTypeId, @VMOnlyLicType, -1, '', -1, '', -1, '', U.JobId, -1, U.AppSizeMB, U.ObjectName, U.ObjectId, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 1, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=19 AND VMFlag=2
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@VMOnlyLicType AND countingType=0)--VM only CAL usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, -1, '', -1, '', -1, @VMOnlyLicType, -1, '', -1, '', -1, '', -1, -1, -1, U.ObjectName, U.ObjectId, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=19 AND VMFlag=2
                END
                --Backup usage (DPE)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@DPELicType AND countingType=1)--Backup TB usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, U.ClientId, U.ClientName, U.SubclientId, U.SubclientName, U.AppTypeId, @DPELicType, U.BackupSetId, U.BackupSetName, U.InstanceId, U.InstanceName,
                    U.SPId, U.SPName, U.JobId, 0, U.AppSizeMB, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 1, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=1--backup jobs
                    AND U.CapacityFlag=0
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@DPELicType AND countingType=0)--Backup CAL usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, U.ClientId, U.ClientName, -1, '', -1, @DPELicType, -1, '', -1, '', -1, '', -1, -1, -1, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=1--backup jobs
                    AND U.CapacityFlag=0
                END
                --Archive usage (DAE)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@DAELicType AND countingType=1)--Archive TB usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, U.ClientId, U.ClientName, U.SubclientId, U.SubclientName, U.AppTypeId, @DAELicType, U.BackupSetId, U.BackupSetName, U.InstanceId, U.InstanceName,
                    U.SPId, U.SPName, U.JobId, 1, U.AppSizeMB, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 1, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=2--archive jobs
                    AND U.CapacityFlag=0
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@DAELicType AND countingType=0)--Archive CAL usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, U.ClientId, U.ClientName, -1, '', -1, @DAELicType, -1, '', -1, '', -1, '', -1, -1, -1, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=2--archive jobs
                    AND U.CapacityFlag=0
                END
                --Snap usage (DPS)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@DPSLicType AND countingType=1)--Snap TB usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, U.ClientId, U.ClientName, U.SubclientId, U.SubclientName, U.AppTypeId, @DPSLicType, U.BackupSetId, U.BackupSetName, U.InstanceId, U.InstanceName,
                    U.SPId, U.SPName, U.JobId, 2, U.AppSizeMB, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 1, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=3--snap jobs
                    AND U.CapacityFlag=0
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@DPSLicType AND countingType=0)--Snap CAL usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, U.ClientId, U.ClientName, -1, '', -1, @DPSLicType, -1, '', -1, '', -1, '', -1, -1, -1, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=3--snap jobs
                    AND U.CapacityFlag=0
                END
                --Replication usage (DPR)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@DPRLicType AND countingType=1)--Replication TB usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, U.ClientId, U.ClientName, U.SubclientId, U.SubclientName, U.AppTypeId, @DPRLicType, U.BackupSetId, U.BackupSetName, U.InstanceId, U.InstanceName,
                    U.SPId, U.SPName, U.JobId, 3, U.AppSizeMB, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 1, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=4--replication jobs
                    AND U.CapacityFlag=0
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@DPRLicType AND countingType=0)--Replication CAL usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, U.ClientId, U.ClientName, -1, '', -1, @DPRLicType, -1, '', -1, '', -1, '', -1, -1, -1, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=4--replication jobs
                    AND U.CapacityFlag=0
                END
                --VM sockets (only CAL is billed)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@VMSocketsLicType AND countingType=0)--VM Sockets CAL usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, -1, -1, -1, '', -1, @VMSocketsLicType, -1, '', -1, '', -1, '', -1, -1, U.AppSizeMB, U.ObjectName, -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=20--vm sockets
                END
				--Protected VMs
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType IN (@ProtectedVMLicType,@VirtualMachineLicType) AND countingType=1)--protected VM TB usage
                BEGIN
					SELECT TOP 1 @ProtectedVMLicTypeInSku=licType FROM #licMapTbl WHERE licType IN (@ProtectedVMLicType,@VirtualMachineLicType) AND countingType=1
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, -1, '', -1, '', U.AppTypeId, @ProtectedVMLicTypeInSku, -1, '', -1, '', -1, '', U.JobId, -1, U.AppSizeMB, U.ObjectName, U.ObjectId, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 1, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=19 AND VMFlag IN (2,3)
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType IN (@ProtectedVMLicType,@VirtualMachineLicType) AND countingType=0)--protected VM CAL usage
                BEGIN
					SELECT TOP 1 @ProtectedVMLicTypeInSku=licType FROM #licMapTbl WHERE licType IN (@ProtectedVMLicType,@VirtualMachineLicType) AND countingType=0
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, -1, '', -1, '', -1, @ProtectedVMLicTypeInSku, -1, '', -1, '', -1, '', -1, -1, -1, U.ObjectName, U.ObjectId, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=19 AND VMFlag IN (2,3)
                END
				--Endpoint Users (only CAL is billed)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@epUsers AND countingType=0)--ep users CAL usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, -1, '', -1, '', -1, @epUsers, -1, '', -1, '', -1, '', -1, -1, -1, U.ObjectName, U.ObjectId, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=22
                END
                --Sharing Users (only CAL is billed)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@sharingUsers AND countingType=0)--ep sharing users CAL usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, -1, '', -1, '', -1, @sharingUsers, -1, '', -1, '', -1, '', -1, -1, -1, U.ObjectName, U.ObjectId, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=23
                END
                --eDiscovery Users (only CAL is billed)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@eDiscoveryUsers AND countingType=0)--ep ediscovery users CAL usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, -1, '', -1, '', -1, @eDiscoveryUsers, -1, '', -1, '', -1, '', -1, -1, -1, U.ObjectName, U.ObjectId, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=24
                END
                --mSim Users (only CAL is billed)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@mSimUsers AND countingType=0)--mSim users CAL usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, -1, '', -1, '', -1, @mSimUsers, -1, '', -1, '', -1, '', -1, -1, -1, U.ObjectName, -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=18
                END
				--granular application users (only CAL is billed)
				IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType IN (@mbUsers,@spUsers,@gmUsers,@gdUsers,@odUsers,@ciUsers,@csUsers,@cmUsers,@sfUsers,@ntUsers) AND countingType=0)
				BEGIN
					INSERT #tempBillingDetails
					SELECT DISTINCT @commServUniqueId, -1, '', -1, '', -1, U.LicType, -1, '', -1, '', -1, '', -1, -1, -1, U.ObjectName, -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
                    FROM #tempPeakUsage U
					INNER JOIN #licMapTbl L ON L.licType=U.LicType AND L.countingType=0
                    WHERE U.UsageType=18 AND U.LicType IN (@mbUsers,@spUsers,@gmUsers,@gdUsers,@odUsers,@sfUsers,@ntUsers)
					UNION
					SELECT DISTINCT @commServUniqueId, -1, '', -1, '', -1, @ciUsers, -1, '', -1, '', -1, '', -1, -1, -1, U.ObjectName, -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
                    FROM #tempPeakUsage U
					INNER JOIN #licMapTbl L ON L.licType=@ciUsers AND L.countingType=0
                    WHERE U.UsageType=18 AND U.VMFlag&1>0
					UNION
					SELECT DISTINCT @commServUniqueId, -1, '', -1, '', -1, @csUsers, -1, '', -1, '', -1, '', -1, -1, -1, U.ObjectName, -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
                    FROM #tempPeakUsage U
					INNER JOIN #licMapTbl L ON L.licType=@csUsers AND L.countingType=0
                    WHERE U.UsageType=18 AND U.VMFlag&4>0
					UNION
					SELECT DISTINCT @commServUniqueId, -1, '', -1, '', -1, @cmUsers, -1, '', -1, '', -1, '', -1, -1, -1, U.ObjectName, -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
                    FROM #tempPeakUsage U
					INNER JOIN #licMapTbl L ON L.licType=@cmUsers AND L.countingType=0
                    WHERE U.UsageType=18 AND U.VMFlag&2>0
					--find if MBX-E, MBX-F & MBX-A skus are defined. If yes, they need to be billed using a different logic
					--These 3 skus are expected to have the following structure (MBX-E: ExMB, Gmail), (MBX-F: Gdrive, OneDrive, Sharepoint), (MBX-A: Compliance Search, Case Manager)
					SELECT @mbxa=ISNULL(L1.bgId,0) FROM #licMapTbl L1, #licMapTbl L2 WHERE L1.licType=@csUsers AND L2.licType=@cmUsers
					SELECT @mbxf=ISNULL(L1.bgId,0) FROM #licMapTbl L1, #licMapTbl L2, #licMapTbl L3 WHERE L1.licType=@spUsers AND L2.licType=@gdUsers AND L3.licType=@odUsers
					SELECT @mbxe=ISNULL(L1.bgId,0) FROM #licMapTbl L1, #licMapTbl L2 WHERE L1.licType=@mbUsers AND L2.licType=@gmUsers
				END
				--Live sync for VM pairs (only CAL is billed)
				IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@LiveSyncVMLicType AND countingType=0)--live sync for vm pairs CAL usage
				BEGIN
					INSERT #tempBillingDetails
					SELECT DISTINCT @commServUniqueId, ClientId, ClientName, -1, '', -1, @LiveSyncVMLicType, -1, '', -1, '', -1, '', -1, -1, -1, U.ObjectName, -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
					FROM #tempPeakUsage U
					WHERE U.UsageType=26
				END
				--HyperScale storage usage
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@hyperScale AND countingType=1)--VM with App TB usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, U.ClientId, U.ClientName, U.SubclientId, U.SubclientName, -1, @hyperScale, U.BackupSetId, CASE VMFlag WHEN 1 THEN 'HyperScale Appliance' WHEN 2 THEN 'HyperScale Reference Architecture' ELSE 'N/A' END AS BackupSetName,
					U.InstanceId, U.InstanceName, -1, '', -1, 0, U.AppSizeMB, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 1, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=33
                END
				--OI usage (backup)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@OILicType AND countingType=1)--backup usage from OI clients
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, U.ClientId, U.ClientName, U.SubclientId, U.SubclientName, U.AppTypeId, @OILicType, U.BackupSetId, U.BackupSetName, U.InstanceId, U.InstanceName,
                    U.SPId, U.SPName, U.JobId, 0, U.AppSizeMB, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 1, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=1--backup jobs
                    AND U.CapacityFlag=64
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@OILicType AND countingType=0)--OI CAL usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, ClientId, ClientName, -1, '', -1, @OILicType, -1, '', -1, '', -1, '', -1, -1, -1, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
					FROM #tempPeakUsage U
					WHERE U.UsageType=30
                END
				--VOI usage (backup)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@VOILicType AND countingType=1)--backup usage from VOI clients
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, U.ClientId, U.ClientName, U.SubclientId, U.SubclientName, U.AppTypeId, @VOILicType, U.BackupSetId, U.BackupSetName, U.InstanceId, U.InstanceName,
                    U.SPId, U.SPName, U.JobId, 0, U.AppSizeMB, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 1, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=1--backup jobs
                    AND U.CapacityFlag=128
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@VOILicType AND countingType=0)--VOI CAL usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, ClientId, ClientName, -1, '', -1, @VOILicType, -1, '', -1, '', -1, '', -1, -1, -1, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
					FROM #tempPeakUsage U
					WHERE U.UsageType=31
                END
                --content indexed objects (only CAL is billed)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@CIObjects AND countingType=0)--CIObjects CAL usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, -1, '', -1, '', -1, @CIObjects, -1, '', -1, '', -1, '', -1, -1, U.AppSizeMB, U.ObjectName, -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=25
					--get total ciobject usage
                    SELECT @CIObjectUsage=SUM(ISNULL(U.AppSizeMB,0))
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=25
					IF @contractType>0
					BEGIN
						SET @CIObjectTenantCount=0
						DELETE FROM #CIObjectTenantTable
						INSERT #CIObjectTenantTable
						SELECT  DISTINCT OrgGUID,0 FROM #tempBillingDetails WITH (NOLOCK) WHERE csid=@commServUniqueId
						SELECT @CIObjectTenantCount=COUNT(tenantId) FROM #CIObjectTenantTable
						IF ISNULL(@CIObjectTenantCount,0) > 0
						BEGIN
							UPDATE #CIObjectTenantTable SET usage=CEILING((CAST(ISNULL(@CIObjectUsage,0) AS FLOAT)/@CIObjectTenantCount)/1000000)--share usage equally among all tenants in this commcell
						END
					END
                END
                --Appliance Store Usage (only capacity is billed)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@appStoreUsage AND countingType=1)--Archive TB usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, -1, '', -1, '', -1, @appStoreUsage, -1, '', -1, '', -1, '', -1, -1, U.AppSizeMB, '', ObjectId, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 1, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=8
                END
                --Dedupe Store Space (only capacity is billed)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@dedupeStoreSpace AND countingType=1)--Archive TB usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, -1, '', -1, '', -1, @dedupeStoreSpace, -1, '', -1, '', -1, '', -1, -1, U.AppSizeMB, '', ObjectId, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 1, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=5
                END
                --Disk Library Space (only capacity is billed)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@diskLibrarySpace AND countingType=1)--Archive TB usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, -1, '', -1, '', -1, @diskLibrarySpace, -1, '', -1, '', -1, '', -1, -1, U.AppSizeMB, '', ObjectId, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 1, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=9
                END
				--Traditional licenses except laptop and desktop
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType<1000 AND countingType=1)--traditional license backup TB usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT @commServUniqueId, U.ClientId, U.ClientName, U.SubclientId, U.SubclientName, U.AppTypeId, U.LicType, U.BackupSetId, U.BackupSetName, U.InstanceId, U.InstanceName,
                    U.SPId, U.SPName, U.JobId, 0, SUM(U.AppSizeMB), '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 1, U.BasePlanName
                    FROM #tempPeakUsage U
                    INNER JOIN #licMapTbl L ON L.licType=U.licType AND L.countingType=1
                    WHERE U.UsageType=1--backup jobs
					AND U.LicType<>2
                    GROUP BY U.LicType, U.ClientId, U.ClientName, U.SubclientId, U.SubclientName, U.AppTypeId, U.BackupSetId, U.BackupSetName, U.InstanceId, U.InstanceName,
                    U.SPId, U.SPName, U.JobId, U.Organization, U.OrgGUID, U.PlanName, U.BasePlanName
                END
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType<1000 AND countingType=0)--traditional license backup CAL usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT @commServUniqueId, U.ClientId, U.ClientName, -1, '', -1, U.LicType, -1, '', -1, '', -1, '', -1, -1, -1, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
                    FROM #tempPeakUsage U
                    INNER JOIN #licMapTbl L ON L.licType=U.licType AND L.countingType=0
                    WHERE U.UsageType=1--backup jobs
					AND U.LicType<>2
                    GROUP BY U.LicType, U.ClientId, U.ClientName, U.Organization, U.OrgGUID, U.PlanName, U.BasePlanName
                END
				--Traditional laptop and desktop license
				IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=2 AND countingType=1) OR @esimFlag=1--traditional license backup TB usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, U.ClientId, U.ClientName, U.SubclientId, U.SubclientName, U.AppTypeId, U.LicType, U.BackupSetId, U.BackupSetName, U.InstanceId, U.InstanceName,
                    U.SPId, U.SPName, U.JobId, 0, U.AppSizeMB, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 1, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=1--backup jobs
					AND U.LicType=2
                END
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=2 AND countingType=0) OR @esimFlag=1--traditional license backup CAL usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT DISTINCT @commServUniqueId, U.ClientId, U.ClientName, -1, '', -1, U.LicType, -1, '', -1, '', -1, '', -1, -1, -1, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 1, 0, U.BasePlanName
                    FROM #tempPeakUsage U
                    WHERE U.UsageType=1--backup jobs
					AND U.LicType=2
                END
                --Traditional agents
                IF EXISTS (SELECT 1 FROM #agMapTbl WHERE countingType=1)--traditional agents backup TB usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT @commServUniqueId, U.ClientId, U.ClientName, U.SubclientId, U.SubclientName, U.AppTypeId, U.LicType, U.BackupSetId, U.BackupSetName, U.InstanceId, U.InstanceName,
                    U.SPId, U.SPName, U.JobId, 0, SUM(U.AppSizeMB), '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 0, 1, U.BasePlanName
                    FROM #tempPeakUsage U
                    INNER JOIN #agMapTbl A ON A.agType=U.AppTypeId AND A.countingType=1
                    WHERE U.UsageType=1--backup jobs
                    GROUP BY U.AppTypeId, U.ClientId, U.ClientName, U.SubclientId, U.SubclientName, U.LicType, U.BackupSetId, U.BackupSetName, U.InstanceId, U.InstanceName,
                    U.SPId, U.SPName, U.JobId, U.Organization, U.OrgGUID, U.PlanName, U.BasePlanName
                END
                IF EXISTS (SELECT 1 FROM #agMapTbl WHERE countingType=0)--traditional agents backup CAL usage
                BEGIN
                    INSERT #tempBillingDetails
                    SELECT @commServUniqueId, U.ClientId, U.ClientName, -1, '', U.AppTypeId, U.LicType, -1, '', -1, '', -1, '', -1, -1, -1, '', -1, U.Organization, U.OrgGUID, U.PlanName, 0, 0, 0, U.BasePlanName
                    FROM #tempPeakUsage U
                    INNER JOIN #agMapTbl A ON A.agType=U.AppTypeId AND A.countingType=0
                    WHERE U.UsageType=1--backup jobs
                    GROUP BY U.AppTypeId, U.ClientId, U.ClientName, U.LicType, U.Organization, U.OrgGUID, U.PlanName, U.BasePlanName
                END
                -------------- summarize usages from license reporting V3 tables --------------
				IF @contractType=0 --usages for CommCell based contracts
                BEGIN
					--license usage summary
					INSERT #tempSkuLicenses
					SELECT @commServUniqueId AS csid,licType,
					CASE
						WHEN (licType IN (@FSOnlyServerLicType,@FSOnlyVMLicType,@DLOnlyLicType,@APPServerLicType,@VMOnlyLicType,@VMWithAppLicType,@DPELicType,@DAELicType,@DPSLicType,@DPRLicType,@ProtectedVMLicType,@VirtualMachineLicType,@appStoreUsage,@dedupeStoreSpace,@diskLibrarySpace,@OILicType,@VOILicType,@hyperScale)
							OR licType<1000) AND countingType=1
							THEN ISNULL(SUM(appSizeMB*1024*1024),0)
						ELSE 0
					END AS capacityUsage,
					CASE
						WHEN (licType IN (@FSOnlyServerLicType,@FSOnlyVMLicType,@DLOnlyLicType,@APPServerLicType,@DPELicType,@DAELicType,@DPSLicType,@DPRLicType,@OILicType,@VOILicType)
							OR licType<1000) AND countingType=0
							THEN ISNULL(COUNT(DISTINCT ClientId),0)
						WHEN licType IN (@VMOnlyLicType,@VMWithAppLicType,@ProtectedVMLicTypeInSku,@epUsers,@sharingUsers,@eDiscoveryUsers)
							AND countingType=0
							THEN ISNULL(COUNT(DISTINCT ObjectId),0)
						WHEN licType IN (@VMSocketsLicType)
							AND countingType=0
							THEN ISNULL(SUM(AppSizeMB),0)
						WHEN licType IN (@LiveSyncVMLicType)
							AND countingType=0
							THEN ISNULL(COUNT(ClientName),0)
						WHEN licType IN (@mSimUsers, @sfUsers, @ntUsers, @ciUsers)
							AND countingType=0
							THEN ISNULL(COUNT(DISTINCT ObjectName),0)
						WHEN licType IN (@mbUsers, @spUsers, @gmUsers, @gdUsers, @odUsers, @csUsers, @cmUsers)
							AND countingType=0
							AND (@mbxa<=1 OR @mbxf<=0 OR @mbxe<=0)
							THEN ISNULL(COUNT(DISTINCT ObjectName),0)
						WHEN licType IN (@CIObjects)
							AND countingType=0
							THEN CEILING(CAST(ISNULL(@CIObjectUsage,0) AS FLOAT)/1000000)
						ELSE 0
					END AS licenseUsage,
					0 AS bgid,PlanName,BasePlanName
                    FROM #tempBillingDetails
                    WHERE (licType IN (@FSOnlyServerLicType,@FSOnlyVMLicType,@DLOnlyLicType,@APPServerLicType,@VMOnlyLicType,@VMWithAppLicType,@DPELicType,@DAELicType,@DPSLicType,@DPRLicType,
						  @ProtectedVMLicTypeInSku,@appStoreUsage,@dedupeStoreSpace,@diskLibrarySpace,@epUsers,@sharingUsers,@eDiscoveryUsers,@VMSocketsLicType,@LiveSyncVMLicType,
						  @mSimUsers,@sfUsers,@ntUsers,@ciUsers,@mbUsers, @spUsers, @gmUsers, @gdUsers, @odUsers, @csUsers, @cmUsers,@CIObjects,@OILicType,@VOILicType,@hyperScale)
                    OR licType<1000)
					AND csid=@commServUniqueId
                    AND	entityType=1
                    GROUP BY LicType, countingType, PlanName, BasePlanName
					--agent usage summary
					INSERT #tempAgents
					SELECT @commServUniqueId AS csid,AppTypeId AS typeId,
					CASE countingType WHEN 1 THEN ISNULL(SUM(appSizeMB*1024*1024),0) ELSE 0 END	AS capacityUsage,
					CASE countingType WHEN 1 THEN 0 ELSE ISNULL(COUNT(DISTINCT ClientId),0) END AS agentUsage,
					0 AS bgid, 0 AS licType
					FROM #tempBillingDetails
					WHERE csid=@commServUniqueId
                    AND	entityType=0
                    GROUP BY AppTypeId, countingType
				END
				ELSE --usages for tenant based contracts
                BEGIN
					--license usage summary
					INSERT #tempSkuLicenses
					SELECT OrgGUID AS csid,licType,
					CASE
						WHEN (licType IN (@FSOnlyServerLicType,@FSOnlyVMLicType,@DLOnlyLicType,@APPServerLicType,@VMOnlyLicType,@VMWithAppLicType,@DPELicType,@DAELicType,@DPSLicType,@DPRLicType,@ProtectedVMLicType,@VirtualMachineLicType,@appStoreUsage,@dedupeStoreSpace,@diskLibrarySpace,@OILicType,@VOILicType,@hyperScale)
							OR licType<1000) AND countingType=1
							THEN ISNULL(SUM(appSizeMB*1024*1024),0)
						ELSE 0
					END AS capacityUsage,
					CASE
						WHEN (licType IN (@FSOnlyServerLicType,@FSOnlyVMLicType,@DLOnlyLicType,@APPServerLicType,@DPELicType,@DAELicType,@DPSLicType,@DPRLicType,@OILicType,@VOILicType)
							OR licType<1000) AND countingType=0
							THEN ISNULL(COUNT(DISTINCT ClientId),0)
						WHEN licType IN (@VMOnlyLicType,@VMWithAppLicType,@ProtectedVMLicTypeInSku,@epUsers,@sharingUsers,@eDiscoveryUsers)
							AND countingType=0
							THEN ISNULL(COUNT(DISTINCT ObjectId),0)
						WHEN licType IN (@VMSocketsLicType)
							AND countingType=0
							THEN ISNULL(SUM(AppSizeMB),0)
						WHEN licType IN (@LiveSyncVMLicType)
							AND countingType=0
							THEN ISNULL(COUNT(ClientName),0)
						WHEN licType IN (@mSimUsers, @sfUsers, @ntUsers, @ciUsers)
							AND countingType=0
							THEN ISNULL(COUNT(DISTINCT ObjectName),0)
						WHEN licType IN (@mbUsers, @spUsers, @gmUsers, @gdUsers, @odUsers, @csUsers, @cmUsers)
							AND countingType=0
							AND (@mbxa<=1 OR @mbxf<=0 OR @mbxe<=0)
							THEN ISNULL(COUNT(DISTINCT ObjectName),0)
						ELSE 0
					END AS licenseUsage,
					0 AS bgid,PlanName,BasePlanName
                    FROM #tempBillingDetails
                    WHERE (licType IN (@FSOnlyServerLicType,@FSOnlyVMLicType,@DLOnlyLicType,@APPServerLicType,@VMOnlyLicType,@VMWithAppLicType,@DPELicType,@DAELicType,@DPSLicType,@DPRLicType,
						  @ProtectedVMLicTypeInSku,@appStoreUsage,@dedupeStoreSpace,@diskLibrarySpace,@epUsers,@sharingUsers,@eDiscoveryUsers,@VMSocketsLicType,@LiveSyncVMLicType,
						  @mSimUsers,@sfUsers,@ntUsers,@ciUsers,@mbUsers, @spUsers, @gmUsers, @gdUsers, @odUsers, @csUsers, @cmUsers,@OILicType,@VOILicType,@hyperScale)
                    OR licType<1000)
					AND csid=@commServUniqueId
                    AND	entityType=1
                    GROUP BY OrgGUID, LicType, countingType, PlanName, BasePlanName
					UNION
					--CIobject usage summary for each tenant
					SELECT tenantId AS csid,@CIObjects AS licType,0 AS capacityUsage, ISNULL(SUM(usage),0) AS licenseUsage,0 AS bgid,'' AS PlanName,'' AS BasePlanName
                    FROM #CIObjectTenantTable
                    GROUP BY tenantId
					--agent usage summary
					INSERT #tempAgents
					SELECT OrgGUID AS csid,AppTypeId AS typeId,
					CASE countingType WHEN 1 THEN ISNULL(SUM(appSizeMB*1024*1024),0) ELSE 0 END	AS capacityUsage,
					CASE countingType WHEN 1 THEN 0 ELSE ISNULL(COUNT(DISTINCT ClientId),0) END AS agentUsage,
					0 AS bgid, 0 AS licType
					FROM #tempBillingDetails
					WHERE csid=@commServUniqueId
                    AND	entityType=0
                    GROUP BY OrgGUID, AppTypeId, countingType
				END
				--summarize remaining granular application users based on the presence of MBX skus
				IF @mbxa>0 AND @mbxf>0 AND @mbxe>0--all 3 MBX skus are present
				BEGIN
					--summarize MBX-A sku first
					IF @contractType=0--usages for commcell based contracts
					BEGIN
						INSERT #tempSkuLicenses
						SELECT @commServUniqueId,@cmUsers,0 AS capacityUsage,ISNULL(COUNT(DISTINCT ObjectName),0) AS licenseUsage,0 AS bgid,PlanName,BasePlanName
						FROM #tempBillingDetails
						WHERE licType IN (@csUsers, @cmUsers)
						AND csid=@commServUniqueId
						AND	entityType=1
						GROUP BY PlanName, BasePlanName
					END
					ELSE--usages for tenant based contracts
					BEGIN
						INSERT #tempSkuLicenses
						SELECT OrgGUID,@cmUsers,0 AS capacityUsage,ISNULL(COUNT(DISTINCT ObjectName),0) AS licenseUsage,0 AS bgid,PlanName,BasePlanName
						FROM #tempBillingDetails
						WHERE licType IN (@csUsers, @cmUsers)
						AND csid=@commServUniqueId
						AND	entityType=1
						GROUP BY OrgGUID, PlanName, BasePlanName
					END
					--remove MBX-A users from MBX-F & MBX-E
					DELETE T1
					FROM #tempBillingDetails T1, #tempBillingDetails T2
					WHERE T1.ObjectName=T2.ObjectName
					AND T1.licType IN (@spUsers, @gdUsers, @odUsers, @mbUsers, @gmUsers)
					AND	T2.licType IN (@csUsers, @cmUsers)
					AND T1.csid=@commServUniqueId AND T2.csid=@commServUniqueId AND T1.entityType=1 AND T2.entityType=1 AND T1.countingType=0 AND T2.countingType=0
					--summarize MBX-F sku next
					IF @contractType=0--usages for commcell based contracts
					BEGIN
						INSERT #tempSkuLicenses
						SELECT @commServUniqueId,@spUsers,0 AS capacityUsage,ISNULL(COUNT(DISTINCT ObjectName),0) AS licenseUsage,0 AS bgid,PlanName,BasePlanName
						FROM #tempBillingDetails
						WHERE licType IN (@spUsers, @gdUsers, @odUsers)
						AND csid=@commServUniqueId
						AND	entityType=1
						GROUP BY PlanName, BasePlanName
					END
					ELSE--usages for tenant based contracts
					BEGIN
						INSERT #tempSkuLicenses
						SELECT OrgGUID,@spUsers,0 AS capacityUsage,ISNULL(COUNT(DISTINCT ObjectName),0) AS licenseUsage,0 AS bgid,PlanName,BasePlanName
						FROM #tempBillingDetails
						WHERE licType IN (@spUsers, @gdUsers, @odUsers)
						AND csid=@commServUniqueId
						AND	entityType=1
						GROUP BY OrgGUID, PlanName, BasePlanName
					END
					--remove MBX-F users from MBX-E
					DELETE T1
					FROM #tempBillingDetails T1, #tempBillingDetails T2
					WHERE T1.ObjectName=T2.ObjectName
					AND T1.licType IN (@mbUsers, @gmUsers)
					AND	T2.licType IN (@spUsers, @gdUsers, @odUsers)
					AND T1.csid=@commServUniqueId AND T2.csid=@commServUniqueId AND T1.entityType=1 AND T2.entityType=1 AND T1.countingType=0 AND T2.countingType=0
					--summarize MBX-E sku last
					IF @contractType=0--usages for commcell based contracts
					BEGIN
						INSERT #tempSkuLicenses
						SELECT @commServUniqueId,@mbUsers,0 AS capacityUsage,ISNULL(COUNT(DISTINCT ObjectName),0) AS licenseUsage,0 AS bgid,PlanName,BasePlanName
						FROM #tempBillingDetails
						WHERE licType IN (@mbUsers, @gmUsers)
						AND csid=@commServUniqueId
						AND	entityType=1
						GROUP BY PlanName, BasePlanName
					END
					ELSE--usages for tenant based contracts
					BEGIN
						INSERT #tempSkuLicenses
						SELECT OrgGUID,@mbUsers,0 AS capacityUsage,ISNULL(COUNT(DISTINCT ObjectName),0) AS licenseUsage,0 AS bgid,PlanName,BasePlanName
						FROM #tempBillingDetails
						WHERE licType IN (@mbUsers, @gmUsers)
						AND csid=@commServUniqueId
						AND	entityType=1
						GROUP BY OrgGUID, PlanName, BasePlanName
					END
				END
            END
            ELSE IF (@table1Exist=2 AND @table2Exist=2)
            BEGIN
                -------------- collect usages of various licenses --------------
                DELETE FROM #tempUsageDetails
                DELETE FROM #tempCALDetails
                INSERT #tempUsageDetails
                SELECT nJobType, AppId, JobId, ClientId, AppTypeId, SPId, AppSizeMB, LicType, IsVM, CapacityFlag, Organization, OrgGUID, PlanName
                FROM cf_SurveyLicSCLPeakUsageDetails C WITH (NOLOCK)
                INNER JOIN cf_SurveyResultFuncV1(231, @commServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
                WHERE C.CommServUniqueId = @commServUniqueId
                AND C.MonthStart BETWEEN (SELECT DATEADD(MONTH,@subMonth,@i_Month)) AND @i_Month
                INSERT #tempCALDetails
                SELECT ObjectType, ClientId, JobId, AppSizeMB, ObjectId, ObjectName, Organization, OrgGUID, PlanName
                FROM cf_SurveyLicSCLPeakCALDetails C WITH (NOLOCK)
                INNER JOIN cf_SurveyResultFuncV1(231, @commServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
                WHERE C.CommServUniqueId = @commServUniqueId
                AND C.MonthStart BETWEEN (SELECT DATEADD(MONTH,@subMonth,@i_Month)) AND @i_Month
                AND C.ObjectType IN (1,2,3,17,19,20,22,23,24,26)--only these licenses from CAL table are used in billing
                UPDATE #tempUsageDetails SET OrgGUID=-1, Organization=@spName WHERE (OrgGUID='N/A' OR Organization IS NULL OR OrgGUID IS NULL OR Organization='NULL' OR OrgGUID='NULL')
                UPDATE #tempCALDetails SET OrgGUID=-1, Organization=@spName WHERE (OrgGUID='N/A' OR Organization IS NULL OR OrgGUID IS NULL OR Organization='NULL' OR OrgGUID='NULL')
                UPDATE #tempUsageDetails SET PlanName='N/A' WHERE (PlanName IS NULL OR PlanName='NULL')
                UPDATE #tempCALDetails SET PlanName='N/A' WHERE (PlanName IS NULL OR PlanName='NULL')
                --find those clients which should be billed as applicationServers but are actually mapped under FSO
                DELETE FROM #appClientsUnderFSO_Backup
                INSERT #appClientsUnderFSO_Backup
                SELECT DISTINCT ClientId FROM #tempCALDetails WHERE ObjectType=1
                UNION
                SELECT DISTINCT ClientId FROM #tempCALDetails WHERE ObjectType=18
                EXCEPT
                SELECT DISTINCT ClientId FROM #tempCALDetails WHERE ObjectType=26
                --FSO usage (backup)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@FSOnlyServerLicType AND countingType=1)--fso with backup TB usage
                BEGIN
                    INSERT #tempSCLUsageDetails
                    SELECT @commServUniqueId,U.nJobType,U.AppId,U.JobId,U.ClientId,U.AppTypeId,U.SPId,U.AppSizeMB,@FSOnlyServerLicType,U.Organization,U.OrgGUID,0,1,U.PlanName
                    FROM #tempUsageDetails U
                    INNER JOIN #tempCALDetails C ON U.ClientId=C.ClientId AND C.ObjectType=3
                    WHERE U.nJobType=0
                    AND U.ClientId NOT IN (SELECT DISTINCT ClientId FROM #appClientsUnderFSO_Backup)--ACV clients should be charged as AppServers
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@FSOnlyServerLicType AND countingType=0)--fso backup CAL usage
                BEGIN
                    INSERT #tempSCLCALDetails
                    SELECT DISTINCT @commServUniqueId,U.ClientId,'',@FSOnlyServerLicType,U.Organization,U.OrgGUID,0,1,U.PlanName
                    FROM #tempCALDetails U
                    INNER JOIN #tempUsageDetails C ON U.ClientId=C.ClientId AND U.ObjectType=3
                    WHERE C.nJobType=0
                    AND U.ClientId NOT IN (SELECT DISTINCT ClientId FROM #appClientsUnderFSO_Backup)--ACV clients should be charged as AppServers
                END
                --DLO usage (backup)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@DLOnlyLicType AND countingType=1)--dlo with backup TB usage
                BEGIN
                    INSERT #tempSCLUsageDetails
                    SELECT @commServUniqueId,U.nJobType,U.AppId,U.JobId,U.ClientId,U.AppTypeId,U.SPId,U.AppSizeMB,@DLOnlyLicType,U.Organization,U.OrgGUID,0,1,U.PlanName
                    FROM #tempUsageDetails U
                    INNER JOIN #tempCALDetails C ON U.ClientId=C.ClientId AND C.ObjectType=2
                    WHERE U.nJobType=0
                    AND U.ClientId NOT IN (SELECT DISTINCT ClientId FROM #appClientsUnderFSO_Backup)--ACV clients should be charged as AppServers
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@DLOnlyLicType AND countingType=0)--dlo backup CAL usage
                BEGIN
                    INSERT #tempSCLCALDetails
                    SELECT DISTINCT @commServUniqueId,U.ClientId,'',@DLOnlyLicType,U.Organization,U.OrgGUID,0,1,U.PlanName
                    FROM #tempCALDetails U
                    INNER JOIN #tempUsageDetails C ON U.ClientId=C.ClientId AND U.ObjectType=2
                    WHERE C.nJobType=0
                    AND U.ClientId NOT IN (SELECT DISTINCT ClientId FROM #appClientsUnderFSO_Backup)--ACV clients should be charged as AppServers
                END
                --AppServer usage (backup)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@APPServerLicType AND countingType=1)--appServer with backup TB usage
                BEGIN
                    INSERT #tempSCLUsageDetails
                    SELECT @commServUniqueId,U.nJobType,U.AppId,U.JobId,U.ClientId,U.AppTypeId,U.SPId,U.AppSizeMB,@APPServerLicType,U.Organization,U.OrgGUID,0,1,U.PlanName
                    FROM #tempUsageDetails U
                    INNER JOIN #tempCALDetails C ON U.ClientId=C.ClientId AND C.ObjectType=1
                    WHERE U.nJobType=0
                    UNION--add those ACV clients which are listed under FSO
                    SELECT @commServUniqueId,U.nJobType,U.AppId,U.JobId,U.ClientId,U.AppTypeId,U.SPId,U.AppSizeMB,@APPServerLicType,U.Organization,U.OrgGUID,0,1,U.PlanName
                    FROM #tempUsageDetails U
                    INNER JOIN #tempCALDetails C ON U.ClientId=C.ClientId AND C.ObjectType=3
                    WHERE U.nJobType=0
                    AND U.ClientId IN (SELECT DISTINCT ClientId FROM #appClientsUnderFSO_Backup)
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@APPServerLicType AND countingType=0)--appServer backup CAL usage
                BEGIN
                    INSERT #tempSCLCALDetails
                    SELECT DISTINCT @commServUniqueId,U.ClientId,'',@APPServerLicType,U.Organization,U.OrgGUID,0,1,U.PlanName
                    FROM #tempCALDetails U
                    INNER JOIN #tempUsageDetails C ON U.ClientId=C.ClientId AND U.ObjectType=1
                    WHERE C.nJobType=0
                    UNION--add those ACV clients which are listed under FSO
                    SELECT DISTINCT @commServUniqueId,U.ClientId,'',@APPServerLicType,U.Organization,U.OrgGUID,0,1,U.PlanName
                    FROM #tempCALDetails U
                    INNER JOIN #tempUsageDetails C ON U.ClientId=C.ClientId AND U.ObjectType=3
                    WHERE C.nJobType=0
                    AND U.ClientId IN (SELECT DISTINCT ClientId FROM #appClientsUnderFSO_Backup)
                END
                --VM with App usage
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@VMWithAppLicType AND countingType=1)--VM with App TB usage
                BEGIN
                    INSERT #tempSCLUsageDetails
                    SELECT @commServUniqueId,-1,-1,C.JobId,C.ObjectId,-1,-1,C.AppSizeMB,@VMWithAppLicType,C.Organization,C.OrgGUID,0,1,C.PlanName
                    FROM #tempCALDetails C
                    WHERE C.ObjectType=26
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@VMWithAppLicType AND countingType=0)--VM with App CAL usage
                BEGIN
                    INSERT #tempSCLCALDetails
                    SELECT DISTINCT @commServUniqueId,ObjectId,'',@VMWithAppLicType,Organization,OrgGUID,0,1,PlanName
                    FROM #tempCALDetails
                    WHERE ObjectType=26
                END
                --VM only usage
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@VMOnlyLicType AND countingType=1)--VM only TB usage
                BEGIN
                    INSERT #tempSCLUsageDetails
                    SELECT @commServUniqueId,-1,-1,C.JobId,C.ObjectId,-1,-1,C.AppSizeMB,@VMOnlyLicType,C.Organization,C.OrgGUID,0,1,C.PlanName
                    FROM #tempCALDetails C
                    WHERE C.ObjectType=20
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@VMOnlyLicType AND countingType=0)--VM only CAL usage
                BEGIN
                    INSERT #tempSCLCALDetails
                    SELECT DISTINCT @commServUniqueId,ObjectId,'',@VMOnlyLicType,Organization,OrgGUID,0,1,PlanName
                    FROM #tempCALDetails
                    WHERE ObjectType=20
                END
                --Backup usage (DPE)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@DPELicType AND countingType=1)--Backup TB usage
                BEGIN
                    INSERT #tempSCLUsageDetails
                    SELECT @commServUniqueId,U.nJobType,U.AppId,U.JobId,U.ClientId,U.AppTypeId,U.SPId,U.AppSizeMB,@DPELicType,U.Organization,U.OrgGUID,0,1,U.PlanName
                    FROM #tempUsageDetails U
                    WHERE U.nJobType=0
                    AND U.CapacityFlag=0
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@DPELicType AND countingType=0)--Backup CAL usage
                BEGIN
                    INSERT #tempSCLCALDetails
                    SELECT DISTINCT @commServUniqueId,ClientId,'',@DPELicType,Organization,OrgGUID,0,1,PlanName
                    FROM #tempUsageDetails U
                    WHERE U.nJobType=0
                    AND U.CapacityFlag=0
                END
                --Archive usage (DAE)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@DAELicType AND countingType=1)--Archive TB usage
                BEGIN
                    INSERT #tempSCLUsageDetails
                    SELECT @commServUniqueId,U.nJobType,U.AppId,U.JobId,U.ClientId,U.AppTypeId,U.SPId,U.AppSizeMB,@DAELicType,U.Organization,U.OrgGUID,0,1,U.PlanName
                    FROM #tempUsageDetails U
                    WHERE U.nJobType=1
                    AND U.CapacityFlag=0
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@DAELicType AND countingType=0)--Archive CAL usage
                BEGIN
                    INSERT #tempSCLCALDetails
                    SELECT DISTINCT @commServUniqueId,ClientId,'',@DAELicType,Organization,OrgGUID,0,1,PlanName
                    FROM #tempUsageDetails U
                    WHERE U.nJobType=1
                    AND U.CapacityFlag=0
                END
                --Snap usage (DPS)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@DPSLicType AND countingType=1)--Snap TB usage
                BEGIN
                    INSERT #tempSCLUsageDetails
                    SELECT @commServUniqueId,U.nJobType,U.AppId,U.JobId,U.ClientId,U.AppTypeId,U.SPId,U.AppSizeMB,@DPSLicType,U.Organization,U.OrgGUID,0,1,U.PlanName
                    FROM #tempUsageDetails U
                    WHERE U.nJobType=2
                    AND U.CapacityFlag=0
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@DPSLicType AND countingType=0)--Snap CAL usage
                BEGIN
                    INSERT #tempSCLCALDetails
                    SELECT DISTINCT @commServUniqueId,ClientId,'',@DPSLicType,Organization,OrgGUID,0,1,PlanName
                    FROM #tempUsageDetails U
                    WHERE U.nJobType=2
                    AND U.CapacityFlag=0
                END
                --Replication usage (DPR)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@DPRLicType AND countingType=1)--Replication TB usage
                BEGIN
                    INSERT #tempSCLUsageDetails
                    SELECT @commServUniqueId,U.nJobType,U.AppId,U.JobId,U.ClientId,U.AppTypeId,U.SPId,U.AppSizeMB,@DPRLicType,U.Organization,U.OrgGUID,0,1,U.PlanName
                    FROM #tempUsageDetails U
                    WHERE U.nJobType=3
                    AND U.CapacityFlag=0
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@DPRLicType AND countingType=0)--Replication CAL usage
                BEGIN
                    INSERT #tempSCLCALDetails
                    SELECT DISTINCT @commServUniqueId,ClientId,'',@DPRLicType,Organization,OrgGUID,0,1,PlanName
                    FROM #tempUsageDetails U
                    WHERE U.nJobType=3
                    AND U.CapacityFlag=0
                END
                --VM sockets (only CAL is billed)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@VMSocketsLicType AND countingType=0)--VM Sockets CAL usage
                BEGIN
                    INSERT #tempSCLCALDetails
                    SELECT DISTINCT @commServUniqueId,AppSizeMB,ObjectName,@VMSocketsLicType,Organization,OrgGUID,0,1,PlanName
                    FROM #tempCALDetails
                    WHERE ObjectType=19
                END
                --Protected VMs
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@ProtectedVMLicType AND countingType=1)--protected VM TB usage
                BEGIN
                    INSERT #tempSCLUsageDetails
                    SELECT @commServUniqueId,-1,-1,C.JobId,C.ObjectId,-1,-1,C.AppSizeMB,@ProtectedVMLicType,C.Organization,C.OrgGUID,0,1,C.PlanName
                    FROM #tempCALDetails C
                    WHERE C.ObjectType IN (20,26)
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@ProtectedVMLicType AND countingType=0)--protected VM CAL usage
                BEGIN
                    INSERT #tempSCLCALDetails
                    SELECT DISTINCT @commServUniqueId,ObjectId,'',@ProtectedVMLicType,Organization,OrgGUID,0,1,PlanName
                    FROM #tempCALDetails
                    WHERE ObjectType IN (20,26)
                END
                --Virtual Machines
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@VirtualMachineLicType AND countingType=1)--protected VM TB usage
                BEGIN
                    INSERT #tempSCLUsageDetails
                    SELECT @commServUniqueId,-1,-1,C.JobId,C.ObjectId,-1,-1,C.AppSizeMB,@VirtualMachineLicType,C.Organization,C.OrgGUID,0,1,C.PlanName
                    FROM #tempCALDetails C
                    WHERE C.ObjectType IN (20,26)
                END
                ELSE IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@VirtualMachineLicType AND countingType=0)--protected VM CAL usage
                BEGIN
                    INSERT #tempSCLCALDetails
                    SELECT DISTINCT @commServUniqueId,ObjectId,'',@VirtualMachineLicType,Organization,OrgGUID,0,1,PlanName
                    FROM #tempCALDetails
                    WHERE ObjectType IN (20,26)
                END
                --Endpoint Users (only CAL is billed)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@epUsers AND countingType=0)--ep users CAL usage
                BEGIN
                    INSERT #tempSCLCALDetails
                    SELECT @commServUniqueId,ObjectId,ObjectName,@epUsers,Organization,OrgGUID,0,1,PlanName
                    FROM #tempCALDetails
                    WHERE ObjectType=22
                END
                --Sharing Users (only CAL is billed)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@sharingUsers AND countingType=0)--ep sharing users CAL usage
                BEGIN
                    INSERT #tempSCLCALDetails
                    SELECT @commServUniqueId,ObjectId,ObjectName,@sharingUsers,Organization,OrgGUID,0,1,PlanName
                    FROM #tempCALDetails
                    WHERE ObjectType=23
                END
                --eDiscovery Users (only CAL is billed)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@eDiscoveryUsers AND countingType=0)--ep ediscovery users CAL usage
                BEGIN
                    INSERT #tempSCLCALDetails
                    SELECT @commServUniqueId,ObjectId,ObjectName,@eDiscoveryUsers,Organization,OrgGUID,0,1,PlanName
                    FROM #tempCALDetails
                    WHERE ObjectType=24
                END
                --mSim Users (only CAL is billed)
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType=@mSimUsers AND countingType=0)--mSim users CAL usage
                BEGIN
                    INSERT #tempSCLCALDetails
                    SELECT @commServUniqueId,-1,ObjectName,@mSimUsers,Organization,OrgGUID,0,1,PlanName
                    FROM #tempCALDetails
                    WHERE ObjectType=17
                END
                --Traditional licenses
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType<1000 AND countingType=1)--traditional license backup TB usage
                BEGIN
                    INSERT #tempSCLUsageDetails
                    SELECT @commServUniqueId,0,U.AppId,U.JobId,U.ClientId,U.AppTypeId,U.SPId,SUM(U.AppSizeMB),U.LicType,U.Organization,U.OrgGUID,0,1,U.PlanName
                    FROM #tempUsageDetails U
                    INNER JOIN #licMapTbl L ON L.licType=U.licType AND L.countingType=1
                    WHERE U.nJobType=0
                    GROUP BY U.LicType, U.ClientId, U.AppTypeId, U.AppId, U.SPId, U.JobId, U.Organization, U.OrgGUID, U.PlanName
                END
                IF EXISTS (SELECT 1 FROM #licMapTbl WHERE licType<1000 AND countingType=0)--traditional license backup CAL usage
                BEGIN
                    INSERT #tempSCLCALDetails
                    SELECT @commServUniqueId,U.ClientId,'',U.LicType,U.Organization,U.OrgGUID,0,1,U.PlanName
                    FROM #tempUsageDetails U
                    INNER JOIN #licMapTbl L ON L.licType=U.licType AND L.countingType=0
                    WHERE U.nJobType=0
                    GROUP BY U.LicType, U.ClientId, U.Organization, U.OrgGUID, U.PlanName
                END
                --Traditional agents
                IF EXISTS (SELECT 1 FROM #agMapTbl WHERE countingType=1)--traditional agents backup TB usage
                BEGIN
                    INSERT #tempSCLUsageDetails
                    SELECT @commServUniqueId,0,U.AppId,U.JobId,U.ClientId,U.AppTypeId,U.SPId,SUM(U.AppSizeMB),U.LicType,U.Organization,U.OrgGUID,0,0,U.PlanName
                    FROM #tempUsageDetails U
                    INNER JOIN #agMapTbl A ON A.agType=U.AppTypeId AND A.countingType=1
                    WHERE U.nJobType=0
                    GROUP BY U.AppTypeId, U.ClientId, U.LicType, U.AppId, U.SPId, U.JobId, U.Organization, U.OrgGUID, U.PlanName
                END
                IF EXISTS (SELECT 1 FROM #agMapTbl WHERE countingType=0)--traditional agents backup CAL usage
                BEGIN
                    INSERT #tempSCLCALDetails
                    SELECT @commServUniqueId,U.ClientId,'',U.AppTypeId,U.Organization,U.OrgGUID,0,0,U.PlanName
                    FROM #tempUsageDetails U
                    INNER JOIN #agMapTbl A ON A.agType=U.AppTypeId AND A.countingType=0
                    WHERE U.nJobType=0
                    GROUP BY U.AppTypeId, U.ClientId, U.Organization, U.OrgGUID, U.PlanName
                END
                -------------- summarize usages from license reporting V2 tables --------------
                --summarize capacity usages for fso, dlo, appserver, vmonly, vmwithapp, protectedVM DPE, DAE, DPS, DPR and traditional licenses
                IF @contractType=0 --usages for CommCell based contracts
                BEGIN
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT csid AS csid,licType,ISNULL(SUM(appSizeMB*1024*1024),0) AS appSize
                        FROM #tempSCLUsageDetails
                        WHERE (licType IN (@FSOnlyServerLicType,@DLOnlyLicType,@APPServerLicType,@VMOnlyLicType,@VMWithAppLicType,@DPELicType,@DAELicType,@DPSLicType,@DPRLicType,@ProtectedVMLicType,@VirtualMachineLicType)
                        OR licType<1000)
                        AND entityType=1
                        AND csid=@commServUniqueId
                        GROUP BY csid, LicType
                    )L ON L.csid=T.csid AND L.licType=T.licType
                    WHEN MATCHED THEN
                        UPDATE SET T.capacityUsage = T.capacityUsage + L.appSize
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.csid,L.LicType,L.AppSize,0,0);
                END
                ELSE --usages for tenant based contracts
                BEGIN
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId,licType,ISNULL(SUM(appSizeMB*1024*1024),0) AS appSize
                        FROM #tempSCLUsageDetails
                        WHERE (licType IN (@FSOnlyServerLicType,@DLOnlyLicType,@APPServerLicType,@VMOnlyLicType,@VMWithAppLicType,@DPELicType,@DAELicType,@DPSLicType,@DPRLicType,@ProtectedVMLicType,@VirtualMachineLicType)
                        OR licType<1000)
                        AND entityType=1
                        AND csid=@commServUniqueId
                        GROUP BY organizationId, LicType
                    )L ON L.organizationId=T.csid AND L.licType=T.licType
                    WHEN MATCHED THEN
                        UPDATE SET T.capacityUsage = T.capacityUsage + L.appSize
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,L.LicType,L.AppSize,0,0);
                END
                --summarize CAL usages for fso, dlo, appserver, vmonly, vmwithapp, protectedVM, DPE, DAE, DPS, DPR, eSim and traditional licenses
                IF @contractType=0 --usages for CommCell based contracts
                BEGIN
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT csid AS csid,licType,COUNT(DISTINCT ObjectId) AS clientCount
                        FROM #tempSCLCALDetails
                        WHERE (licType IN (@FSOnlyServerLicType,@DLOnlyLicType,@APPServerLicType,@DPELicType,@DAELicType,@DPSLicType,@DPRLicType,@VMOnlyLicType,@VMWithAppLicType,@ProtectedVMLicType,@VirtualMachineLicType,@epUsers,@sharingUsers,@eDiscoveryUsers)
                        OR licType<1000)
                        AND entityType=1
                        AND csid=@commServUniqueId
                        GROUP BY csid, LicType
                    )L ON L.csid=T.csid AND L.licType=T.licType
                    WHEN MATCHED THEN
                        UPDATE SET T.licenseUsage=T.licenseUsage + L.clientCount
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.csid,L.LicType,0,L.clientCount,0);
                END
                ELSE --usages for tenant based contracts
                BEGIN
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId,licType,COUNT(DISTINCT ObjectId) AS clientCount
                        FROM #tempSCLCALDetails
                        WHERE (licType IN (@FSOnlyServerLicType,@DLOnlyLicType,@APPServerLicType,@DPELicType,@DAELicType,@DPSLicType,@DPRLicType,@VMOnlyLicType,@VMWithAppLicType,@ProtectedVMLicType,@VirtualMachineLicType,@epUsers,@sharingUsers,@eDiscoveryUsers)
                        OR licType<1000)
                        AND entityType=1
                        AND csid=@commServUniqueId
                        GROUP BY organizationId, LicType
                    )L ON L.organizationId=T.csid AND L.licType=T.licType
                    WHEN MATCHED THEN
                        UPDATE SET T.licenseUsage=T.licenseUsage + L.clientCount
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,L.LicType,0,L.clientCount,0);
                END
                --summarize usages for vmSocket licenses
                IF @contractType=0 --usages for CommCell based contracts
                BEGIN
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT csid AS csid,licType,ISNULL(SUM(ObjectId),0) AS clientCount
                        FROM #tempSCLCALDetails
                        WHERE licType IN (@VMSocketsLicType)
                        AND entityType=1
                        AND csid=@commServUniqueId
                        GROUP BY csid, LicType
                    )L ON L.csid=T.csid AND L.licType=T.licType
                    WHEN MATCHED THEN
                        UPDATE SET T.licenseUsage=T.licenseUsage + L.clientCount
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.csid,L.LicType,0,L.clientCount,0);
                END
                ELSE --usages for tenant based contracts
                BEGIN
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId,licType,ISNULL(SUM(ObjectId),0) AS clientCount
                        FROM #tempSCLCALDetails
                        WHERE licType IN (@VMSocketsLicType)
                        AND entityType=1
                        AND csid=@commServUniqueId
                        GROUP BY organizationId, LicType
                    )L ON L.organizationId=T.csid AND L.licType=T.licType
                    WHEN MATCHED THEN
                        UPDATE SET T.licenseUsage=T.licenseUsage + L.clientCount
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,L.LicType,0,L.clientCount,0);
                END
                --summarize usages for mSim licenses
                IF @contractType=0 --usages for CommCell based contracts
                BEGIN
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT csid AS csid,licType,COUNT(DISTINCT ObjectName) AS clientCount
                        FROM #tempSCLCALDetails
                        WHERE licType IN (@mSimUsers)
                        AND entityType=1
                        AND csid=@commServUniqueId
                        GROUP BY csid, LicType
                    )L ON L.csid=T.csid AND L.licType=T.licType
                    WHEN MATCHED THEN
                        UPDATE SET T.licenseUsage=T.licenseUsage + L.clientCount
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.csid,L.LicType,0,L.clientCount,0);
                END
                ELSE --usages for tenant based contracts
                BEGIN
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId,licType,COUNT(DISTINCT ObjectName) AS clientCount
                        FROM #tempSCLCALDetails
                        WHERE licType IN (@mSimUsers)
                        AND entityType=1
                        AND csid=@commServUniqueId
                        GROUP BY organizationId, LicType
                    )L ON L.organizationId=T.csid AND L.licType=T.licType
                    WHEN MATCHED THEN
                        UPDATE SET T.licenseUsage=T.licenseUsage + L.clientCount
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,L.LicType,0,L.clientCount,0);
                END
                --summarize capacity usages for traditional agents
                IF @contractType=0 --usages for CommCell based contracts
                BEGIN
                    MERGE INTO #tempAgents T
                    USING(
                        SELECT csid AS csid,appTypeId,ISNULL(SUM(appSizeMB*1024*1024),0) AS appSize
                        FROM #tempSCLUsageDetails
                        WHERE entityType=0
                        AND csid=@commServUniqueId
                        GROUP BY csid, appTypeId
                    )L ON L.csid=T.csid AND L.appTypeId=T.typeId
                    WHEN MATCHED THEN
                        UPDATE SET T.capacityUsage = T.capacityUsage + L.appSize
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.csid,L.appTypeId,L.AppSize,0,0,0);
                END
                ELSE --usages for tenant based contracts
                BEGIN
                    MERGE INTO #tempAgents T
                    USING(
                        SELECT organizationId,appTypeId,ISNULL(SUM(appSizeMB*1024*1024),0) AS appSize
                        FROM #tempSCLUsageDetails
                        WHERE entityType=0
                        AND csid=@commServUniqueId
                        GROUP BY organizationId, appTypeId
                    )L ON L.organizationId=T.csid AND L.appTypeId=T.typeId
                    WHEN MATCHED THEN
                        UPDATE SET T.capacityUsage = T.capacityUsage + L.appSize
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,L.appTypeId,L.AppSize,0,0,0);
                END
                --summarize CAL usages for traditional agents
                IF @contractType=0 --usages for CommCell based contracts
                BEGIN
                    MERGE INTO #tempAgents T
                    USING(
                        SELECT csid AS csid,LicType,COUNT(DISTINCT ObjectId) AS clientCount
                        FROM #tempSCLCALDetails
                        WHERE entityType=0
                        AND csid=@commServUniqueId
                        GROUP BY csid, LicType
                    )L ON L.csid=T.csid AND L.LicType=T.typeId
                    WHEN MATCHED THEN
                        UPDATE SET T.agentUsage=T.agentUsage + L.clientCount
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.csid,L.LicType,0,L.clientCount,0,0);
                END
                ELSE --usages for tenant based contracts
                BEGIN
                    MERGE INTO #tempAgents T
                    USING(
                        SELECT organizationId,licType,COUNT(DISTINCT ObjectId) AS clientCount
                        FROM #tempSCLCALDetails
                        WHERE entityType=0
                        AND csid=@commServUniqueId
                        GROUP BY organizationId, LicType
                    )L ON L.organizationId=T.csid AND L.licType=T.typeId
                    WHEN MATCHED THEN
                        UPDATE SET T.agentUsage=T.agentUsage + L.clientCount
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,L.LicType,0,L.clientCount,0,0);
                END
                -- add CIObjects license CAL usage
                SET @CIObjectFlg = 0
                SET @CIObjectUsage=0
                IF object_id('dbo.cf_SurveyLicPeakCALClientCountHistory') IS NOT NULL
                BEGIN--there should be atleast one entry in this new table
                    IF EXISTS (SELECT 1 FROM cf_SurveyLicPeakCALClientCountHistory WITH (NOLOCK) WHERE CommServUniqueId = @commServUniqueId AND DATEADD(M, DATEDIFF(M, 0, dbo.GetDateTime(date)),0) BETWEEN (SELECT DATEADD(MONTH,@subMonth,@i_Month)) AND @i_Month)
                    BEGIN
                        SET @CIObjectFlg=1
                    END
                END
                IF @CIObjectFlg=1
                BEGIN
                    SELECT @CIObjectUsage=MAX(SCLContentIndexedObject)
                    FROM cf_SurveyLicPeakCALClientCountHistory C WITH (NOLOCK)
                    INNER JOIN cf_SurveyResultFuncV1(228, @commServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
                    WHERE C.CommServUniqueId = @commServUniqueId
                    AND DATEADD(M, DATEDIFF(M, 0, dbo.GetDateTime(date)),0) BETWEEN (SELECT DATEADD(MONTH,@subMonth,@i_Month)) AND @i_Month
                    GROUP BY C.CommservUniqueId, DATEADD(M, DATEDIFF(M, 0, dbo.GetDateTime(date)),0)
                END
                ELSE
                BEGIN
                    SELECT @CIObjectUsage=MAX(C.CIObjects)
                    FROM cf_SurveyCapacityLicensePeakUsage C WITH (NOLOCK)
                    INNER JOIN cf_SurveyResultFuncV1(3, @commServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) AS R  ON C.CommServUniqueId = R.CommServUniqueId
                    WHERE C.MonthStart BETWEEN (SELECT DATEADD(MONTH,@subMonth,@i_Month)) AND @i_Month
                    GROUP BY C.CommservUniqueId, C.MonthStart
                END
                IF @contractType=0----usages for CommCell based contracts
                BEGIN
                    INSERT #tempLicenses
                    SELECT @commServUniqueId, @CIObjects, 0, CEILING(CAST(@CIObjectUsage AS FLOAT)/1000000), 0
                END
                ELSE----usages for tenant based contracts
                BEGIN
                    SET @CIObjectTenantCount=0
                    DELETE FROM #CIObjectTenantTable
                    INSERT #CIObjectTenantTable
                    SELECT  DISTINCT OrgGUID,0 FROM cf_SurveyLicSCLPeakUsageDetails WITH (NOLOCK) WHERE CommServUniqueId=@commServUniqueId
                    UNION
                    SELECT DISTINCT OrgGUID,0 FROM cf_SurveyLicSCLPeakCALDetails WITH (NOLOCK) WHERE CommServUniqueId=@commServUniqueId
                    SELECT @CIObjectTenantCount=COUNT(tenantId) FROM #CIObjectTenantTable
                    UPDATE #CIObjectTenantTable SET usage=CAST(@CIObjectUsage AS DECIMAL(18,3))/@CIObjectTenantCount--share usage equally among all tenants in this commcell
                    INSERT #tempLicenses
                    SELECT tenantId, @CIObjects, 0, CEILING(usage/1000000), 0
                    FROM #CIObjectTenantTable
                END
            END
            ELSE IF (@table1Exist=1 AND @table2Exist=1)
            BEGIN
                --Get license usages for regular licTypes
                INSERT #tempDetails--column [entityType]=0 if same entries are be applicable for agent usages and license usages; for all other entries it will be 1 meaning, it is applicable only to licenses
                SELECT C.CommServUniqueId,C.ClientId,C.SPId,C.AppId,C.AppTypeId,C.LicType,C.IsVM,C.JobId,C.nJobType,C.AppSizeMB,-1,0,0,0,0,C.Organization,C.OrgGUID FROM cf_SurveyLicPeakUsageDetails C WITH (NOLOCK)
                INNER JOIN cf_SurveyResultFuncV1(216, @commServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
                WHERE C.CommServUniqueId = @commServUniqueId
                AND C.MonthStart BETWEEN (SELECT DATEADD(MONTH,@subMonth,@i_Month)) AND @i_Month
				--VSA V2 change
				UPDATE #tempDetails SET LicType=143 WHERE AppTypeId=106
			    --if organization or orgGuid is null, change it to default
                UPDATE #tempDetails SET organization=@spName, organizationId='-1' WHERE csid=@commServUniqueId AND (organization=NULL OR organizationId=NULL OR organization='NULL' OR organizationId='NULL')
                IF @contractType=0--usages for CommCell based contracts
                BEGIN
                    --add client count for licenses
                    INSERT #tempLicenses
                    SELECT @commServUniqueId, licType, 0, COUNT(DISTINCT ClientId), 0 FROM #tempDetails WHERE csid=@commServUniqueId GROUP BY licType
                    --add capacity usage for licenses
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT @commServUniqueId AS csId,licType,ISNULL(SUM(appSizeMB*1024*1024),0) AS appSize FROM #tempDetails WHERE csid=@commServUniqueId AND jobType=0 GROUP BY licType
                    ) L ON L.csid=T.csid AND L.LicType=T.licType
                    WHEN MATCHED THEN
                        UPDATE SET T.capacityUsage=L.appSize
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.csid,L.LicType,L.AppSize,0,0);
                    --add client count for agents
                    INSERT #tempAgents
                    SELECT @commServUniqueId, appTypeId, 0, COUNT(DISTINCT ClientId), 0, 0 FROM #tempDetails WHERE csid=@commServUniqueId GROUP BY appTypeId
                    --add capacity usages for agents
                    MERGE INTO #tempAgents T
                    USING(
                        SELECT @commServUniqueId AS csId,appTypeId,ISNULL(SUM(appSizeMB*1024*1024),0) AS appSize FROM #tempDetails WHERE csid=@commServUniqueId AND jobType=0 GROUP BY appTypeId
                    ) A ON A.csid=T.csid AND A.appTypeId=T.typeId
                    WHEN MATCHED THEN
                        UPDATE SET T.capacityUsage=A.appSize
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (A.csid,A.appTypeId,A.AppSize,0,0,0);
                END
                ELSE--usages for tenant based contracts
                BEGIN
                    --add client count for licenses
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, licType, COUNT(DISTINCT ClientId) AS clientCount FROM #tempDetails WHERE csid=@commServUniqueId
                        GROUP BY organizationId,licType
                    ) L ON L.organizationId=T.csid AND L.LicType=T.licType
                    WHEN MATCHED THEN
                        UPDATE SET T.licenseUsage=T.licenseUsage + L.clientCount
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,L.LicType,0,L.clientCount,0);
                    --add capacity usage for licenses
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId,licType,ISNULL(SUM(appSizeMB*1024*1024),0) AS appSize FROM #tempDetails WHERE csid=@commServUniqueId AND jobType=0
                        GROUP BY organizationId, licType
                    ) L ON L.organizationId=T.csid AND L.LicType=T.licType
                    WHEN MATCHED THEN
                        UPDATE SET T.capacityUsage=T.capacityUsage + L.appSize
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,L.LicType,L.AppSize,0,0);
                    --add client count for agents
                    MERGE INTO #tempAgents T
                    USING(
                        SELECT organizationId, appTypeId, COUNT(DISTINCT ClientId) AS clientCount FROM #tempDetails WHERE csid=@commServUniqueId
                        GROUP BY organizationId,appTypeId
                    ) A ON A.organizationId=T.csid AND A.appTypeId=T.typeId
                    WHEN MATCHED THEN
                        UPDATE SET T.agentUsage=T.agentUsage + A.clientCount
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (A.organizationId,A.appTypeId,0,A.clientCount,0,0);
                    --add capacity usages for agents
                    MERGE INTO #tempAgents T
                    USING(
                        SELECT organizationId,appTypeId,ISNULL(SUM(appSizeMB*1024*1024),0) AS appSize FROM #tempDetails WHERE csid=@commServUniqueId AND jobType=0
                        GROUP BY organizationId, appTypeId
                    ) A ON A.organizationId=T.csid AND A.appTypeId=T.typeId
                    WHEN MATCHED THEN
                        UPDATE SET T.capacityUsage=T.capacityUsage + A.appSize
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (A.organizationId,A.appTypeId,A.AppSize,0,0,0);
                END
				--store the regular license details to be used while finding new license types
                TRUNCATE TABLE #tempRegularLicDetails
                INSERT #tempRegularLicDetails
                SELECT clientId,spId,appId,appTypeId,licType,isVM,jobId,jobType,appSizeMB,vmClientId,organization,organizationId FROM #tempDetails
                WHERE csid = @commServUniqueId
                --####--First get the usages for DPE (100002), DAE (100004), DPS (100005), DPR (100006)
                DECLARE @DPESize BIGINT = 0, @DAESize BIGINT = 0, @DPSSize BIGINT = 0, @DPRSize BIGINT = 0
                DECLARE @DPECount INT = 0, @DAECount INT = 0, @DPSCount INT = 0, @DPRCount INT = 0
                INSERT #tempDetails
				SELECT @commServUniqueId,C.ClientId,C.SPId,C.AppId,C.AppTypeId,
				CASE nJobType WHEN 0 THEN @DPELicType WHEN 1 THEN @DAELicType WHEN 2 THEN @DPSLicType ELSE @DPRLicType END,
				C.IsVM,C.JobId,C.nJobType,C.AppSizeMB,-1,0,1,0,0,C.Organization,C.OrgGUID
				FROM cf_SurveyLicPeakUsageDetails C WITH (NOLOCK)
                INNER JOIN cf_SurveyResultFuncV1(216, @commServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
                WHERE C.CommServUniqueId = @commServUniqueId
                AND C.MonthStart BETWEEN (SELECT DATEADD(MONTH,@subMonth,@i_Month)) AND @i_Month
				AND nJobType IN (0,1,2,3) AND CapacityFlag=0
				UPDATE #tempDetails SET organization=@spName, organizationId='-1'
				WHERE (organization=NULL OR organizationId=NULL OR organization='NULL' OR organizationId='NULL')
				AND licType IN (@DPELicType,@DAELicType,@DPSLicType,@DPRLicType)
				AND csid=@commServUniqueId
                IF @contractType=0--usages for CommCell based contracts
                BEGIN
                    SELECT @DPECount=COUNT(DISTINCT clientId) FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@DPELicType
                    SELECT @DPESize=ISNULL(SUM(AppSizeMB)*1024*1024,0) FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@DPELicType
                    SELECT @DAECount=COUNT(DISTINCT clientId) FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@DAELicType
                    SELECT @DAESize=ISNULL(SUM(AppSizeMB)*1024*1024,0) FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@DAELicType
                    SELECT @DPSCount=COUNT(DISTINCT clientId) FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@DPSLicType
                    SELECT @DPSSize=ISNULL(SUM(AppSizeMB)*1024*1024,0) FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@DPSLicType
                    SELECT @DPRCount=COUNT(DISTINCT clientId) FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@DPRLicType
                    SELECT @DPRSize=ISNULL(SUM(AppSizeMB)*1024*1024,0) FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@DPRLicType
                    INSERT INTO #tempLicenses VALUES (@commServUniqueId,@DPELicType,@DPESize,@DPECount,0)
                    INSERT INTO #tempLicenses VALUES (@commServUniqueId,@DAELicType,@DAESize,@DAECount,0)
                    INSERT INTO #tempLicenses VALUES (@commServUniqueId,@DPSLicType,@DPSSize,@DPSCount,0)
                    INSERT INTO #tempLicenses VALUES (@commServUniqueId,@DPRLicType,@DPRSize,@DPRCount,0)
                END
                ELSE--usages for tenant based contracts
                BEGIN
                    --add client counts for DPE,DAE,DPS & DPR licenses within an organization
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, COUNT(DISTINCT ClientId) AS clientCount FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@DPELicType
                        GROUP BY organizationId
                    ) L ON L.organizationId=T.csid AND T.licType=@DPELicType
                    WHEN MATCHED THEN
                        UPDATE SET T.licenseUsage=T.licenseUsage + L.clientCount
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,@DPELicType,0,L.clientCount,0);
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, COUNT(DISTINCT ClientId) AS clientCount FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@DAELicType
                        GROUP BY organizationId
                    ) L ON L.organizationId=T.csid AND T.licType=@DAELicType
                    WHEN MATCHED THEN
                        UPDATE SET T.licenseUsage=T.licenseUsage + L.clientCount
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,@DAELicType,0,L.clientCount,0);
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, COUNT(DISTINCT ClientId) AS clientCount FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@DPSLicType
                        GROUP BY organizationId
                    ) L ON L.organizationId=T.csid AND T.licType=@DPSLicType
                    WHEN MATCHED THEN
                        UPDATE SET T.licenseUsage=T.licenseUsage + L.clientCount
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,@DPSLicType,0,L.clientCount,0);
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, COUNT(DISTINCT ClientId) AS clientCount FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@DPRLicType
                        GROUP BY organizationId
                    ) L ON L.organizationId=T.csid AND T.licType=@DPRLicType
                    WHEN MATCHED THEN
                        UPDATE SET T.licenseUsage=T.licenseUsage + L.clientCount
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,@DPRLicType,0,L.clientCount,0);
                    --add TB usages for DPE,DAE,DPS & DPR licenses within an organization
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, ISNULL(SUM(appSizeMB*1024*1024),0) AS appSize FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@DPELicType
                        GROUP BY organizationId
                    ) L ON L.organizationId=T.csid AND T.licType=@DPELicType
                    WHEN MATCHED THEN
                        UPDATE SET T.capacityUsage=T.capacityUsage + L.appSize
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,@DPELicType,L.AppSize,0,0);
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, ISNULL(SUM(appSizeMB*1024*1024),0) AS appSize FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@DAELicType
                        GROUP BY organizationId
                    ) L ON L.organizationId=T.csid AND T.licType=@DAELicType
                    WHEN MATCHED THEN
                        UPDATE SET T.capacityUsage=T.capacityUsage + L.appSize
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,@DAELicType,L.AppSize,0,0);
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, ISNULL(SUM(appSizeMB*1024*1024),0) AS appSize FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@DPSLicType
                        GROUP BY organizationId
                    ) L ON L.organizationId=T.csid AND T.licType=@DPSLicType
                    WHEN MATCHED THEN
                        UPDATE SET T.capacityUsage=T.capacityUsage + L.appSize
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,@DPSLicType,L.AppSize,0,0);
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, ISNULL(SUM(appSizeMB*1024*1024),0) AS appSize FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@DPRLicType
                        GROUP BY organizationId
                    ) L ON L.organizationId=T.csid AND T.licType=@DPRLicType
                    WHEN MATCHED THEN
                        UPDATE SET T.capacityUsage=T.capacityUsage + L.appSize
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,@DPRLicType,L.AppSize,0,0);
                END
                --###--Next get usages for the VM license types - for Protected VM and for the 2 new license types (VM with Application, VM w/o Package)
                DECLARE @VMOnlyCount INT = 0, @VMOnlySize BIGINT = 0, @VMWithAppCount INT = 0, @VMWithAppSize BIGINT = 0, @protectedVMCount INT = 0, @protectedVMSize BIGINT = 0, @VSAAppTypeId INT=106
                TRUNCATE TABLE #tempNewVMLicTypes
                INSERT #tempNewVMLicTypes
                SELECT C.ClientId, C.VMClientId, C.LicType, C.AppTypeId, C.JobId, C.Organization, C.OrgGUID FROM cf_SurveyLicPeakCLALicClientCount C WITH (NOLOCK)
                INNER JOIN cf_SurveyResultFuncV1(216, @commServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
                WHERE C.CommServUniqueId = @commServUniqueId
                AND C.MonthStart BETWEEN (SELECT DATEADD(MONTH,@subMonth,@i_Month)) AND @i_Month
                AND C.LicType IN (@ProtectedVMLicType,@ACVLicType)
                --if organization or orgGuid is null, change it to default
                UPDATE #tempNewVMLicTypes SET organization=@spName, organizationId='-1' WHERE (organization=NULL OR organizationId=NULL OR organization='NULL' OR organizationId='NULL')
                --**entityType=2-client Count rows for VMs; entityType=3-capacity usage rows for VMs
                --get client count details for VM with APP = 200003 & Protected VMs = 100019
                INSERT #tempDetails
                SELECT @commServUniqueId, -1, -1, -1, -1,
                CASE WHEN licType=@ACVLicType THEN @VMWithAppLicType WHEN licType=@ProtectedVMLicType THEN @ProtectedVMLicTypeInSku END,
                1, -1, -1, -1, VMClientId, 0, 2, 0, 0, organization, organizationId  FROM #tempNewVMLicTypes
                ----Get capacity usage of VM with APP = 200003
                --so if a VM is protected, we will take that job for ACV licType
                UPDATE ACV SET ACV.jobId=P.jobId
                FROM #tempNewVMLicTypes ACV
                INNER JOIN
                (SELECT VMClientId,jobId FROM #tempNewVMLicTypes WHERE licType=@ProtectedVMLicType) P
                ON P.VMClientId=ACV.VMClientId
                WHERE ACV.jobId=0 AND ACV.licType=@ACVLicType
                INSERT #tempDetails
                SELECT @commServUniqueId, R.clientId, R.spId, R.appId, R.appTypeId, @VMWithAppLicType, R.isVM, R.jobId, R.jobType, R.appSizeMB, -1, 0, 3, 0, 0, R.organization, R.organizationId FROM #tempNewVMLicTypes T
                INNER JOIN #tempRegularLicDetails R ON R.jobId=T.jobId AND T.licType=@ACVLicType--these are the cases where VM is protected (applications on the VM may or may not be protected separately)
                UNION
                SELECT @commServUniqueId, R.clientId, R.spId, R.appId, R.appTypeId, @VMWithAppLicType, R.isVM, R.jobId, R.jobType, R.appSizeMB, -1, 0, 3, 0, 0, R.organization, R.organizationId FROM #tempNewVMLicTypes T
                INNER JOIN #tempRegularLicDetails R ON R.clientId=T.VMClientId AND R.appTypeId=T.appTypeId AND T.licType=@ACVLicType AND T.jobId=0--these are the cases where VM is not protected but applications are protected
                --for the protected VMs, if any application data is protected separately, we need to remove those jobs before finding FS only server
                --hence we are marking such rows for deletion in a temp table
                DELETE FROM #appJobs --clean temp table if it has entries from previous iteration of while loop
                INSERT #appJobs
                SELECT R.jobId FROM #tempNewVMLicTypes T
                INNER JOIN #tempRegularLicDetails R ON R.clientId=T.VMClientId AND R.appTypeId=T.appTypeId AND T.licType=@ACVLicType AND T.jobId>0
                --Remove all VMs which are already counted towards VM with APP bucket
                DELETE #tempNewVMLicTypes
                WHERE VMClientId IN (SELECT DISTINCT VMClientId FROM #tempDetails where licType=@VMWithAppLicType AND csid=@commServUniqueId)
                --Remaining will be the VMs to be put into VM only bucket
                --Get client count details for VM Only bucket = 200001
                INSERT #tempDetails
                SELECT @commServUniqueId, -1, -1, -1, -1, @VMOnlyLicType, 1, -1, -1, -1, VMClientId, 0, 2, 0, 0, organization, organizationId  FROM #tempNewVMLicTypes
                TRUNCATE TABLE #tempNewVMLicTypes
                --Get capacity usage of Protected VMs = 100019 (or 100011)
                INSERT #tempDetails
                SELECT @commServUniqueId, clientId, spId, appId, @VSAAppTypeId, @ProtectedVMLicTypeInSku, isVM, jobId, jobType, appSizeMB, -1, 0, 3, 0, 0, organization, organizationId
                FROM #tempRegularLicDetails
                WHERE appTypeId=@VSAAppTypeId
                --Remove all jobs that have been counted in VM with APP bucket
                DELETE FROM #tempRegularLicDetails
                WHERE jobId IN
                (SELECT jobId FROM #tempDetails
                WHERE licType=@VMWithAppLicType AND entityType=3 AND csid=@commServUniqueId)
                --Also remove those jobs which were marked above for deletion
                DELETE FROM #tempRegularLicDetails
                WHERE jobId IN
                (SELECT jobId FROM #appJobs)
                --Get capacity usage of VM Only bucket = 200001
                INSERT #tempDetails
                SELECT @commServUniqueId, clientId, spId, appId, @VSAAppTypeId, @VMOnlyLicType, isVM, jobId, jobType, appSizeMB, -1, 0, 3, 0, 0, organization, organizationId
                FROM #tempRegularLicDetails
                WHERE appTypeId=@VSAAppTypeId
                --Remove all jobs that have been counted in VM Only bucket (we can just remove all the remaining VSA jobs)
                DELETE FROM #tempRegularLicDetails
                WHERE appTypeId=@VSAAppTypeId
                IF @contractType=0--usages for CommCell based contracts
                BEGIN
                    SELECT @protectedVMCount=COUNT(DISTINCT VMClientId) FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@ProtectedVMLicTypeInSku AND entityType=2
                    SELECT @protectedVMSize=ISNULL(SUM(appSizeMB*1024*1024),0) FROM #tempDetails WHERE csid = @commServUniqueId AND licType=@ProtectedVMLicTypeInSku AND jobType=0 AND entityType=3
                    SELECT @VMWithAppCount=COUNT(DISTINCT VMClientId) FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@VMWithAppLicType AND entityType=2
                    SELECT @VMWithAppSize=ISNULL(SUM(appSizeMB*1024*1024),0) FROM #tempDetails WHERE csid = @commServUniqueId AND licType=@VMWithAppLicType AND jobType=0 AND entityType=3
                    SELECT @VMOnlyCount=COUNT(DISTINCT VMClientId) FROM #tempDetails WHERE csid = @commServUniqueId AND licType=@VMOnlyLicType AND entityType=2
                    SELECT @VMOnlySize=ISNULL(SUM(appSizeMB*1024*1024),0) FROM #tempDetails WHERE csid = @commServUniqueId AND licType=@VMOnlyLicType AND jobType=0 AND entityType=3
                    INSERT INTO #tempLicenses VALUES (@commServUniqueId,@VMOnlyLicType,@VMOnlySize,@VMOnlyCount,0)
                    INSERT INTO #tempLicenses VALUES (@commServUniqueId,@VMWithAppLicType,@VMWithAppSize,@VMWithAppCount,0)
                    INSERT INTO #tempLicenses VALUES (@commServUniqueId,@ProtectedVMLicTypeInSku,@protectedVMSize,@protectedVMCount,0)
                END
                ELSE--usages for Tenant based contracts
                BEGIN
                    --add client counts for VMonly, VMwithApp and ProtectedVM licenses within an organization
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, COUNT(DISTINCT VMClientId) AS clientCount FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@ProtectedVMLicTypeInSku AND entityType=2
                        GROUP BY organizationId
                    ) L ON L.organizationId=T.csid AND T.licType=@ProtectedVMLicTypeInSku
                    WHEN MATCHED THEN
                        UPDATE SET T.licenseUsage=T.licenseUsage + L.clientCount
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,@ProtectedVMLicTypeInSku,0,L.clientCount,0);
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, COUNT(DISTINCT VMClientId) AS clientCount FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@VMWithAppLicType AND entityType=2
                        GROUP BY organizationId
                    ) L ON L.organizationId=T.csid AND T.licType=@VMWithAppLicType
                    WHEN MATCHED THEN
                        UPDATE SET T.licenseUsage=T.licenseUsage + L.clientCount
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,@VMWithAppLicType,0,L.clientCount,0);
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, COUNT(DISTINCT VMClientId) AS clientCount FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@VMOnlyLicType AND entityType=2
                        GROUP BY organizationId
                    ) L ON L.organizationId=T.csid AND T.licType=@VMOnlyLicType
                    WHEN MATCHED THEN
                        UPDATE SET T.licenseUsage=T.licenseUsage + L.clientCount
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,@VMOnlyLicType,0,L.clientCount,0);
                    --add TB usages for VMonly, VMwithApp and ProtectedVM licenses within an organization
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, ISNULL(SUM(appSizeMB*1024*1024),0) AS appSize FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@ProtectedVMLicTypeInSku AND jobType=0 AND entityType=3
                        GROUP BY organizationId
                    ) L ON L.organizationId=T.csid AND T.licType=@ProtectedVMLicTypeInSku
                    WHEN MATCHED THEN
                        UPDATE SET T.capacityUsage=T.capacityUsage + L.appSize
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,@ProtectedVMLicTypeInSku,L.AppSize,0,0);
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, ISNULL(SUM(appSizeMB*1024*1024),0) AS appSize FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@VMWithAppLicType AND jobType=0 AND entityType=3
                        GROUP BY organizationId
                    ) L ON L.organizationId=T.csid AND T.licType=@VMWithAppLicType
                    WHEN MATCHED THEN
                        UPDATE SET T.capacityUsage=T.capacityUsage + L.appSize
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,@VMWithAppLicType,L.AppSize,0,0);
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, ISNULL(SUM(appSizeMB*1024*1024),0) AS appSize FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@VMOnlyLicType AND jobType=0 AND entityType=3
                        GROUP BY organizationId
                    ) L ON L.organizationId=T.csid AND T.licType=@VMOnlyLicType
                    WHEN MATCHED THEN
                        UPDATE SET T.capacityUsage=T.capacityUsage + L.appSize
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,@VMOnlyLicType,L.AppSize,0,0);
                END
                --####--Now get usages for the remaining 3 new license types (File System Only Server, DLO, Application Server)
                DECLARE @FSOnlyServerCount INT = 0, @DLOCount INT = 0, @APPServerCount INT = 0
                DECLARE @FSOnlyServerSize BIGINT = 0, @DLOSize BIGINT = 0, @APPServerSize BIGINT = 0
                --get Application Server usages
                INSERT #tempDetails
                SELECT @commServUniqueId,clientId,spId,appId,AppTypeId,@APPServerLicType,isVM,jobId,jobType,appSizeMB,-1,0,1,0,0,organization,organizationId FROM #tempRegularLicDetails
                WHERE clientId IN (SELECT DISTINCT clientId FROM #tempRegularLicDetails WHERE licType IN (3,16,17))
                --Remove all clients which are already counted towards application server
                DELETE #tempRegularLicDetails
                WHERE clientId IN (SELECT DISTINCT clientId FROM #tempRegularLicDetails WHERE licType IN (3,16,17))
                --get DLO usages
                INSERT #tempDetails
                SELECT @commServUniqueId,clientId,spId,appId,AppTypeId,@DLOnlyLicType,isVM,jobId,jobType,appSizeMB,-1,0,1,0,0,organization,organizationId FROM #tempRegularLicDetails
                WHERE clientId IN (SELECT DISTINCT clientId FROM #tempRegularLicDetails WHERE licType=2)
                --Remove all clients which are already counted towards LaptopDesktop
                DELETE #tempRegularLicDetails
                WHERE clientId IN (SELECT DISTINCT clientId FROM #tempRegularLicDetails WHERE licType=2)
                INSERT #tempDetails
                SELECT @commServUniqueId,clientId,spId,appId,AppTypeId,@FSOnlyServerLicType,isVM,jobId,jobType,appSizeMB,-1,0,1,0,0,organization,organizationId FROM #tempRegularLicDetails
                WHERE clientId IN (SELECT DISTINCT clientId FROM #tempRegularLicDetails WHERE licType=1)
                IF @contractType=0--usages for CommCell based contracts
                BEGIN
                    SELECT @APPServerCount=COUNT(DISTINCT clientId) FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@APPServerLicType
                    SELECT @APPServerSize=ISNULL(SUM(appSizeMB*1024*1024),0) FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@APPServerLicType AND jobType=0
                    SELECT @DLOCount=COUNT(DISTINCT clientId) FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@DLOnlyLicType
                    SELECT @DLOSize=ISNULL(SUM(appSizeMB*1024*1024),0) FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@DLOnlyLicType AND jobType=0
                    SELECT @FSOnlyServerCount=COUNT(DISTINCT clientId) FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@FSOnlyServerLicType
                    SELECT @FSOnlyServerSize=ISNULL(SUM(appSizeMB*1024*1024),0) FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@FSOnlyServerLicType AND jobType=0
                    INSERT INTO #tempLicenses VALUES (@commServUniqueId,@FSOnlyServerLicType,@FSOnlyServerSize,@FSOnlyServerCount,0)
                    INSERT INTO #tempLicenses VALUES (@commServUniqueId,@DLOnlyLicType,@DLOSize,@DLOCount,0)
                    INSERT INTO #tempLicenses VALUES (@commServUniqueId,@APPServerLicType,@APPServerSize,@APPServerCount,0)
                END
                ELSE--usages for Tenant based contracts
                BEGIN
                    --add client counts for FSO, DLO and AppServer licenses within an organization
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, COUNT(DISTINCT ClientId) AS clientCount FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@APPServerLicType
                        GROUP BY organizationId
                    ) L ON L.organizationId=T.csid AND T.licType=@APPServerLicType
                    WHEN MATCHED THEN
                        UPDATE SET T.licenseUsage=T.licenseUsage + L.clientCount
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,@APPServerLicType,0,L.clientCount,0);
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, COUNT(DISTINCT ClientId) AS clientCount FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@DLOnlyLicType
                        GROUP BY organizationId
                    ) L ON L.organizationId=T.csid AND T.licType=@DLOnlyLicType
                    WHEN MATCHED THEN
                        UPDATE SET T.licenseUsage=T.licenseUsage + L.clientCount
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,@DLOnlyLicType,0,L.clientCount,0);
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, COUNT(DISTINCT ClientId) AS clientCount FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@FSOnlyServerLicType
                        GROUP BY organizationId
                    ) L ON L.organizationId=T.csid AND T.licType=@FSOnlyServerLicType
                    WHEN MATCHED THEN
                        UPDATE SET T.licenseUsage=T.licenseUsage + L.clientCount
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,@FSOnlyServerLicType,0,L.clientCount,0);
                    --add TB usages for FSO, DLO and AppServer licenses within an organization
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, ISNULL(SUM(appSizeMB*1024*1024),0) AS appSize FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@APPServerLicType AND jobType=0
                        GROUP BY organizationId
                    ) L ON L.organizationId=T.csid AND T.licType=@APPServerLicType
                    WHEN MATCHED THEN
                        UPDATE SET T.capacityUsage=T.capacityUsage + L.appSize
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,@APPServerLicType,L.AppSize,0,0);
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, ISNULL(SUM(appSizeMB*1024*1024),0) AS appSize FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@DLOnlyLicType AND jobType=0
                        GROUP BY organizationId
                    ) L ON L.organizationId=T.csid AND T.licType=@DLOnlyLicType
                    WHEN MATCHED THEN
                        UPDATE SET T.capacityUsage=T.capacityUsage + L.appSize
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,@DLOnlyLicType,L.AppSize,0,0);
                    MERGE INTO #tempLicenses T
                    USING(
                        SELECT organizationId, ISNULL(SUM(appSizeMB*1024*1024),0) AS appSize FROM #tempDetails WHERE csid=@commServUniqueId AND licType=@FSOnlyServerLicType AND jobType=0
                        GROUP BY organizationId
                    ) L ON L.organizationId=T.csid AND T.licType=@FSOnlyServerLicType
                    WHEN MATCHED THEN
                        UPDATE SET T.capacityUsage=T.capacityUsage + L.appSize
                    WHEN NOT MATCHED THEN
                        INSERT VALUES (L.organizationId,@FSOnlyServerLicType,L.AppSize,0,0);
                END
                TRUNCATE TABLE #tempRegularLicDetails
                --###--Following licenses are still not available in the new way. So continue getting it in the old way from cf_SurveyCapacityLicensePeakUsage table
                IF @contractType=0--for tenant based contracts, usages of these licenses can be found only after new tables start fetching these values
                BEGIN
                    INSERT #tempLicenses
                    SELECT CommServUniqueId, LicType, SUM(capacityUsage),SUM(licenseUsage),0
                    FROM
                    (SELECT LP.CommServUniqueId,LP.ArchivedMailBoxes,CEILING(CAST(LP.CIObjects AS FLOAT)/1000000) AS CIObjects,LP.VMSockets,LP.EndpointUsers,LP.SharingUsers,
                    LP.eDiscoveryUsers,(LP.UsedDiskSpaceMB*1024*1024) AS UsedDiskSpaceMB,(LP.DedupDataSizeMB*1024*1024) AS DedupDataSizeMB,LP.AppClassVMs,LP.MBArchivedUsers
                    FROM cf_SurveyCapacityLicensePeakUsage LP WITH (NOLOCK) INNER JOIN
                    cf_SurveyResultFuncV1(3, @commServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) AS R  ON LP.CommServUniqueId = R.CommServUniqueId
                    WHERE LP.MonthStart BETWEEN (SELECT DATEADD(MONTH,@subMonth,@i_Month)) AND @i_Month
                    ) T
                    CROSS APPLY
                    (
                        VALUES
                        (100013,0,ISNULL(ArchivedMailBoxes,0)),
                        (100017,0,ISNULL(CIObjects,0)),
                        (100018,0,ISNULL(VMSockets,0)),
                        (100024,0,ISNULL(EndpointUsers,0)),
                        (100025,0,ISNULL(SharingUsers,0)),
                        (100026,0,ISNULL(eDiscoveryUsers,0)),
                        (100015,ISNULL(UsedDiskSpaceMB,0),0),
                        (100016,ISNULL(DedupDataSizeMB,0),0),
                        (100027,0,ISNULL(AppClassVMs,0)),
                        (100028,0,ISNULL(MBArchivedUsers,0))
                    )C (LicType,capacityUsage,licenseUsage)
                    GROUP BY CommServUniqueId, LicType
                END
            END
            ELSE
            BEGIN
                --  1. find capacity usage of agents for this client group. This will be stored in #tempAgents table
                INSERT #tempAgents
                SELECT CP.CommServUniqueId,CP.TypeId,
                SUM(CP.BackupSize),CP.UsedAgents,0,CP.LicType
                FROM cf_SurveyAgentCapacityPeakUsage CP WITH (NOLOCK) INNER JOIN
                cf_SurveyResultFuncV1(3, @commServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) AS R  ON CP.CommServUniqueId = R.CommServUniqueId
                WHERE CP.MonthStart BETWEEN (SELECT DATEADD(MONTH,@subMonth,@i_Month)) AND @i_Month
                GROUP BY CP.CommServUniqueId,CP.TypeId,CP.UsedAgents,CP.LicType
                --  2. find capacity & client usage of licenses for this client group. This will be stored in #tempLicenses table
                --  from cf_SurveyAgentCapacityPeakUsage (gives capacity usage of agent type licenses for this client group)
                INSERT #tempLicenses
                SELECT CP.CommServUniqueId,CP.LicType,
                SUM(CP.BackupSize),0,0
                FROM cf_SurveyAgentCapacityPeakUsage CP WITH (NOLOCK) INNER JOIN
                cf_SurveyResultFuncV1(3, @commServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) AS R
                ON CP.CommServUniqueId = R.CommServUniqueId
                INNER JOIN cf_SurveyLicType AS licType WITH (NOLOCK) ON CP.LicType = licType.id
                WHERE CP.MonthStart BETWEEN (SELECT DATEADD(MONTH,@subMonth,@i_Month)) AND @i_Month
                GROUP BY CP.CommServUniqueId,CP.LicType
                --  from cf_SurveyAgentLicensePeakUsage (gives license count of agent type licenses for this client group)
                MERGE into #tempLicenses T
                USING(
                    SELECT LP.CommServUniqueId,min(licType.id) AS LicType,SUM(LP.PermLicensesUsed) AS PermLicensesUsed
                    FROM cf_SurveyAgentLicensePeakUsage LP WITH (NOLOCK) INNER JOIN
                    cf_SurveyResultFuncV1(3, @commServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) AS R  ON LP.CommServUniqueId = R.CommServUniqueId
                    INNER JOIN cf_SurveyLicType licType WITH (NOLOCK) ON licType.id = LP.TypeId
                    WHERE LP.MonthStart BETWEEN (SELECT DATEADD(MONTH,@subMonth,@i_Month)) AND @i_Month
                    GROUP BY LP.CommServUniqueId,licType.name
                ) S ON (T.csid=S.CommServUniqueId AND T.lictype=S.LicType)
                WHEN MATCHED --Update the existing items
                    THEN UPDATE SET T.licenseUsage=S.PermLicensesUsed
                WHEN NOT MATCHED BY TARGET --Insert the new items
                    THEN INSERT VALUES (S.CommServUniqueId,S.LicType,0,S.PermLicensesUsed,0);
                --  from cf_SurveyCapacityLicensePeakUsage (gives both capacity usage & license count of capacity type licenses for this client group)
                INSERT #tempLicenses
                SELECT CommServUniqueId, LicType, SUM(capacityUsage),SUM(licenseUsage),0
                FROM
                (SELECT LP.CommServUniqueId,LP.ProtectedVMs,LP.ArchivedMailBoxes,CEILING(CAST(LP.CIObjects AS FLOAT)/1000000) AS CIObjects,LP.VMSockets,LP.EndpointUsers,LP.SharingUsers,
                    LP.eDiscoveryUsers,(LP.BackupSize*1024*1024) AS BackupSize,(LP.ArchiveSize*1024*1024) AS ArchiveSize,
                    (LP.SnapshotSize*1024*1024) AS SnapshotSize,(LP.ReplicationSize*1024*1024) AS ReplicationSize,
                    (LP.UsedDiskSpaceMB*1024*1024) AS UsedDiskSpaceMB,(LP.DedupDataSizeMB*1024*1024) AS DedupDataSizeMB,LP.AppClassVMs,LP.MBArchivedUsers
                    FROM cf_SurveyCapacityLicensePeakUsage LP WITH (NOLOCK) INNER JOIN
                    cf_SurveyResultFuncV1(3, @commServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) AS R  ON LP.CommServUniqueId = R.CommServUniqueId
                    WHERE LP.MonthStart BETWEEN (SELECT DATEADD(MONTH,@subMonth,@i_Month)) AND @i_Month
                ) T
                CROSS APPLY
                (
                    VALUES
                    (100011,0,ISNULL(ProtectedVMs,0)),
                    (100013,0,ISNULL(ArchivedMailBoxes,0)),
                    (100017,0,ISNULL(CIObjects,0)),
                    (100018,0,ISNULL(VMSockets,0)),
                    (100024,0,ISNULL(EndpointUsers,0)),
                    (100025,0,ISNULL(SharingUsers,0)),
                    (100026,0,ISNULL(eDiscoveryUsers,0)),
                    (100002,ISNULL(BackupSize,0),0),
                    (100004,ISNULL(ArchiveSize,0),0),
                    (100005,ISNULL(SnapshotSize,0),0),
                    (100006,ISNULL(ReplicationSize,0),0),
                    (100015,ISNULL(UsedDiskSpaceMB,0),0),
                    (100016,ISNULL(DedupDataSizeMB,0),0),
                    (100027,0,ISNULL(AppClassVMs,0)),
                    (100028,0,ISNULL(MBArchivedUsers,0))
                )C (LicType,capacityUsage,licenseUsage)
                GROUP BY CommServUniqueId, LicType
            END
            --##--following updations should be performed irrespective of the contractType when, both new and old logic are used
            --updating V4 details table below
            UPDATE #tempBillingDetails
            SET licType=
            (
                SELECT MIN(id) AS id FROM cf_SurveyLicType WITH (NOLOCK) WHERE name=(SELECT name FROM cf_SurveyLicType WITH (NOLOCK) WHERE id=licType)
            ), appTypeId=
            (
                SELECT MIN(id) AS id FROM cf_SurveyAgentType WITH (NOLOCK) WHERE name=(SELECT name FROM cf_SurveyAgentType WITH (NOLOCK) WHERE id=appTypeId)
            ) WHERE csid=@commServUniqueId
            --updating V3 details table below
            UPDATE #tempSCLUsageDetails
            SET licType=
            (
                SELECT MIN(id) AS id FROM cf_SurveyLicType WITH (NOLOCK) WHERE name=(SELECT name FROM cf_SurveyLicType WITH (NOLOCK) WHERE id=licType)
            ), appTypeId=
            (
                SELECT MIN(id) AS id FROM cf_SurveyAgentType WITH (NOLOCK) WHERE name=(SELECT name FROM cf_SurveyAgentType WITH (NOLOCK) WHERE id=appTypeId)
            ) WHERE csid=@commServUniqueId
            UPDATE #tempSCLCALDetails
            SET licType=
                CASE WHEN entityType=1 THEN --licenses
                (
                    SELECT MIN(id) AS id FROM cf_SurveyLicType WITH (NOLOCK) WHERE name=(SELECT name FROM cf_SurveyLicType WITH (NOLOCK) WHERE id=licType)
                ) WHEN entityType=0 THEN --agents
                (
                    SELECT MIN(id) AS id FROM cf_SurveyAgentType WITH (NOLOCK) WHERE name=(SELECT name FROM cf_SurveyAgentType WITH (NOLOCK) WHERE id=licType)
                ) END
            WHERE csid=@commServUniqueId
            --updating V2 details table below
            UPDATE #tempDetails
            SET appTypeId=
            (
                SELECT MIN(id) AS id FROM cf_SurveyAgentType WITH (NOLOCK) WHERE name=(SELECT name FROM cf_SurveyAgentType WITH (NOLOCK) WHERE id=appTypeId)
            ) WHERE csid=@commServUniqueId
            UPDATE #tempDetails
            SET licType=
            (
                SELECT MIN(id) AS id FROM cf_SurveyLicType WITH (NOLOCK) WHERE name=(SELECT name FROM cf_SurveyLicType WITH (NOLOCK) WHERE id=licType)
            ) WHERE csid=@commServUniqueId
            IF @contractType=0--following updations are for CommCell based contracts. The same for tenant based contracts is placed outside the cursor loop
            BEGIN
                --  update agents with correct type id
                --  different versions of same agents will have same name but, different IDs in cf_SurveyAgentType table
                --  e.g., 4 versions of sql agents will have typeID=4,16,70,81. But only the least id (4) will be mapped to the billing group
                --  hence irrespective of the version of the sql agent, we have to make these ids to 4, so that they all get mapped to the corresponding billing group while computing usage
                UPDATE #tempAgents
                SET typeId=
                (
                    SELECT MIN(id) AS id FROM cf_SurveyAgentType WITH (NOLOCK) WHERE name=(SELECT name FROM cf_SurveyAgentType WITH (NOLOCK) WHERE id=typeId)
                ) WHERE csid=@commServUniqueId
                --  update licenses with correct licType
                --  different versions of same licenses will have same name but, different IDs in cf_SurveyLicType table
                --  e.g., different AppClass1 will have typeID=3,4,7,9,18 etc. But only the least id (3) will be mapped to the billing group
                --  hence irrespective of the version, we have to make these ids to 3, so that they all get mapped to the corresponding billing group while computing usage
                UPDATE #tempLicenses
                SET licType=
                (
                    SELECT MIN(id) AS id FROM cf_SurveyLicType WITH (NOLOCK) WHERE name=(SELECT name FROM cf_SurveyLicType WITH (NOLOCK) WHERE id=licType)
                ) WHERE csid=@commServUniqueId
				UPDATE #tempSkuLicenses
                SET licType=
                (
                    SELECT MIN(id) AS id FROM cf_SurveyLicType WITH (NOLOCK) WHERE name=(SELECT name FROM cf_SurveyLicType WITH (NOLOCK) WHERE id=licType)
                ) WHERE csid=@commServUniqueId
                -- remove duplicate rows from #tempAgents
                DELETE FROM #tblAgents--clear the existing table contents after first iteration of while loop
                INSERT #tblAgents
                SELECT csid,typeId,SUM(capacityUsage),SUM(agentUsage),bgid,licType FROM #tempAgents WHERE csid=@commServUniqueId GROUP BY csid,typeId,bgid,licType ORDER BY csid,typeId,licType
                DELETE FROM #tempAgents WHERE csid=@commServUniqueId
                INSERT #tempAgents
                SELECT * FROM #tblAgents WHERE csid=@commServUniqueId
                -- remove duplicate rows from #tempLicenses
                DELETE FROM #tblLicenses--clear the existing table contents after first iteration of while loop
                INSERT #tblLicenses
                SELECT csid,lictype,SUM(capacityUsage),SUM(licenseUsage),bgid FROM #tempLicenses WHERE csid=@commServUniqueId GROUP BY csid,lictype,bgid ORDER BY csid,lictype
                DELETE FROM #tempLicenses WHERE csid=@commServUniqueId
                INSERT #tempLicenses
                SELECT * FROM #tblLicenses WHERE csid=@commServUniqueId
				DELETE FROM #tblSkuLicenses--clear the existing table contents after first iteration of while loop
                INSERT #tblSkuLicenses
                SELECT csid,lictype,SUM(capacityUsage),SUM(licenseUsage),bgid,planName,basePlanName FROM #tempSkuLicenses WHERE csid=@commServUniqueId GROUP BY csid,lictype,bgid,planName,basePlanName ORDER BY csid,lictype
                DELETE FROM #tempSkuLicenses WHERE csid=@commServUniqueId
                INSERT #tempSkuLicenses
                SELECT * FROM #tblSkuLicenses WHERE csid=@commServUniqueId
            END
            IF (@table1Exist=0 OR @table2Exist=0)
            BEGIN
                ----following hack for pseudo client is required, only when old logic is used
                --  MR 160888 - Hack for commcells below SP7
                --  App-Class-1 (licType=3) & Virtual Server (licType=143) licenses were not getting consumed for pseudo clients till SP7
                --  So capacity calculation for these licenes does not include usages of pseudo clients but, this gets recorded correctly against 'Usage by Agent Type'
                --  Hence usage of these licenses have to be replaced with agent usages
                --  updating APP-CLASS-1 usage
                UPDATE L
                SET L.capacityUsage=A.usage
                FROM #tempLicenses L
                INNER JOIN
                (SELECT csid,SUM(capacityUsage) AS usage FROM #tempAgents
                WHERE typeId IN (6,59,9,15,53,4,16,3,5,10,22,41,37,69,70,71,81,91,104,1091,125,128)
                GROUP BY csid) A
                ON L.csid = A.csid
                WHERE L.licType=3
                AND L.csid=CONVERT(NVARCHAR(40),@commServUniqueId)
                -- updating VSA usage
                UPDATE L
                SET L.capacityUsage=A.usage
                FROM #tempLicenses L
                INNER JOIN
                (SELECT csid,SUM(capacityUsage) AS usage FROM #tempAgents
                WHERE typeId IN (106)
                GROUP BY csid) A
                ON L.csid = A.csid
                WHERE L.licType=143
                AND L.csid=CONVERT(NVARCHAR(40),@commServUniqueId)
            END
            --Now loop back to the next commcell
            FETCH NEXT FROM @CommCellsCursor INTO @commServUniqueId;
        END
        CLOSE @CommCellsCursor;
        DEALLOCATE @CommCellsCursor;
        -- ----------------------------------------------------------------------------
        IF @contractType <> 0
        BEGIN
            --if any tenant is not defined in the contract, change it to default
            --This will ensure all usages in a commcell will get counted, even if all tenants are not defined in the contract
            UPDATE #tempLicenses SET csid='-1' WHERE csid NOT IN
            (SELECT DISTINCT tenantId FROM cm_ContractToTenantToBillingGroupMap WHERE contractId=@contractId)
			UPDATE #tempSkuLicenses SET csid='-1' WHERE csid NOT IN
            (SELECT DISTINCT tenantId FROM cm_ContractToTenantToBillingGroupMap WHERE contractId=@contractId)
            UPDATE #tempAgents SET csid='-1' WHERE csid NOT IN
            (SELECT DISTINCT tenantId FROM cm_ContractToTenantToBillingGroupMap WHERE contractId=@contractId)
        END
        -- ----------------------------------------------------------------------------
        --  clear the corresponding temp table entries based on whether you want to generate royalty report or detailed report
        IF @i_DetailedReport = 0
        BEGIN
            --we need only royalty report. Hence emptying contents for detailed report
            DELETE FROM #tempDetails
            DELETE FROM #tempSCLUsageDetails
            DELETE FROM #tempSCLCALDetails
            DELETE FROM #tempBillingDetails
        END
        ELSE
        BEGIN
            --we need only detailed report. Hence emptying contents for royalty report
            DELETE FROM #tempLicenses
			DELETE FROM #tempSkuLicenses
            DELETE FROM #tempAgents
        END
        -- ----------------------------------------------------------------------------
        --following updations & duplicate row removal is for tenant based contracts
        IF @contractType > 0
        BEGIN
            --  update agents with correct type id
            --  different versions of same agents will have same name but, different IDs in cf_SurveyAgentType table
            --  e.g., 4 versions of sql agents will have typeID=4,16,70,81. But only the least id (4) will be mapped to the billing group
            --  hence irrespective of the version of the sql agent, we have to make these ids to 4, so that they all get mapped to the corresponding billing group while computing usage
            UPDATE #tempAgents
            SET typeId=
            (
                SELECT MIN(id) AS id FROM cf_SurveyAgentType WITH (NOLOCK) WHERE name=(SELECT name FROM cf_SurveyAgentType WITH (NOLOCK) WHERE id=typeId)
            )
            --  update licenses with correct licType
            --  different versions of same licenses will have same name but, different IDs in cf_SurveyLicType table
            --  e.g., different AppClass1 will have typeID=3,4,7,9,18 etc. But only the least id (3) will be mapped to the billing group
            --  hence irrespective of the version, we have to make these ids to 3, so that they all get mapped to the corresponding billing group while computing usage
            UPDATE #tempLicenses
            SET licType=
            (
                SELECT MIN(id) AS id FROM cf_SurveyLicType WITH (NOLOCK) WHERE name=(SELECT name FROM cf_SurveyLicType WITH (NOLOCK) WHERE id=licType)
            )
			UPDATE #tempSkuLicenses
            SET licType=
            (
                SELECT MIN(id) AS id FROM cf_SurveyLicType WITH (NOLOCK) WHERE name=(SELECT name FROM cf_SurveyLicType WITH (NOLOCK) WHERE id=licType)
            )
            -- remove duplicate rows from #tempAgents
            DELETE FROM #tblAgents--clear the existing table contents after first iteration of while loop
            INSERT #tblAgents
            SELECT csid,typeId,SUM(capacityUsage),SUM(agentUsage),bgid,licType FROM #tempAgents GROUP BY csid,typeId,bgid,licType ORDER BY csid,typeId,licType
            DELETE FROM #tempAgents
            INSERT #tempAgents
            SELECT * FROM #tblAgents
            -- remove duplicate rows from #tempLicenses
            DELETE FROM #tblLicenses--clear the existing table contents after first iteration of while loop
            INSERT #tblLicenses
            SELECT csid,lictype,SUM(capacityUsage),SUM(licenseUsage),bgid FROM #tempLicenses GROUP BY csid,lictype,bgid ORDER BY csid,lictype
            DELETE FROM #tempLicenses
            INSERT #tempLicenses
            SELECT * FROM #tblLicenses
			DELETE FROM #tblSkuLicenses--clear the existing table contents after first iteration of while loop
            INSERT #tblSkuLicenses
            SELECT csid,lictype,SUM(capacityUsage),SUM(licenseUsage),bgid,planName,basePlanName FROM #tempSkuLicenses GROUP BY csid,lictype,bgid,planName,basePlanName ORDER BY csid,lictype
            DELETE FROM #tempSkuLicenses
            INSERT #tempSkuLicenses
            SELECT * FROM #tblSkuLicenses
        END
		-- ----------------------------------------------------------------------------
        --  handle regular vs plan based skus
		INSERT INTO #tempLicenses
		SELECT csid,S.lictype,capacityUsage,ISNULL(SUM(licenseUsage),0),ISNULL(L.bgid,0) AS bgid
		FROM #tempSkuLicenses S
		LEFT JOIN #licMapTbl L
		ON L.licType=S.lictype AND ((L.planType=1 AND L.planName=S.planName) OR (L.planType=2 AND L.planName=S.basePlanName))
		GROUP BY csid,S.lictype,capacityUsage,L.bgid
        -- ----------------------------------------------------------------------------
        --  Clients with only FS installed should be billed at FS rate while, FS installed along with APP Class agents should be free
        --  Pure file systems are now accurately counted using dummy license type 'File System Only Server'
        --  If billing sku is associated to old Server File System license, we use the below logic to convert it to FSonlyServer
        --  Server File System usage = Server File System usage - (AppClass1 + AppClass2 + AppClass3 usages)
        IF @contractType=0--this is needed only for CommCell based contracts
        BEGIN
            UPDATE T
            SET T.licenseUsage = (CASE WHEN T.licenseUsage - T2.licUsage < 0 THEN 0 ELSE T.licenseUsage - T2.licUsage END)--we don't want negative vaule for license usage hence making it 0. In simple words, if total app class usage is more than file system usage, all the file system licenses will become free
            FROM #tempLicenses T
            INNER JOIN (
                SELECT T1.csid,SUM(T1.licenseUsage) AS licUsage
                FROM #tempLicenses T1
                WHERE T1.licType IN (3,16,17)--(3=AppClass1, 16=AppClass3, 17=AppClass2)
                GROUP BY T1.csid
            )T2 ON T.csid = T2.csid
            WHERE T.licType = 1--(1=ServerFileSystem)
        END
        -- ----------------------------------------------------------------------------
        --  update the agent list with the billing groups they are associated to, if any
        UPDATE A
        SET A.bgid=R.bgid
        FROM #tempAgents A
        INNER JOIN
        (
            SELECT ISNULL(billingGroupId,0) AS bgid,entityId FROM cm_BillingGroupToLicenseMap WITH (NOLOCK)
            WHERE billingGroupId IN (SELECT bgid FROM #bgMapTbl)
            AND entityType=0
        ) R
        ON A.typeId = R.entityId
        --  update the license list with the billing groups they are associated to, if any
        UPDATE L
        SET L.bgid=R.bgid
        FROM #tempLicenses L
        INNER JOIN
        (
            SELECT ISNULL(billingGroupId,0) AS bgid,entityId FROM cm_BillingGroupToLicenseMap WITH (NOLOCK)
            WHERE billingGroupId IN (SELECT bgid FROM #bgMapTbl)
            AND entityType=1
        ) R
        ON L.lictype = R.entityId
		WHERE L.bgid<=0
        -- ----------------------------------------------------------------------------
        --update details table (for V4) with the SKUs that are mapped to licenses/agents
        UPDATE U
        SET U.bgId=L.bgId
        FROM #tempBillingDetails U
        INNER JOIN #licMapTbl L ON L.licType=U.licType AND L.countingType=U.countingType AND ((L.planType=1 AND L.planName=U.PlanName) OR (L.planType=2 AND L.planName=U.BasePlanName))
        WHERE U.entityType=1--licenses
		UPDATE U
        SET U.bgId=L.bgId
        FROM #tempBillingDetails U
        INNER JOIN #licMapTbl L ON L.licType=U.licType AND L.countingType=U.countingType
        WHERE U.entityType=1--licenses
		AND U.bgId<=0
        --AND L.countingType=1--capacity usage
        UPDATE U
        SET U.bgId=A.bgId
        FROM #tempBillingDetails U
        INNER JOIN #agMapTbl A ON A.agType=U.appTypeId AND A.countingType=U.countingType
        WHERE U.entityType=0--agents
        --AND A.countingType=1--capacity usage
        --update details table (for V3) with the SKUs that are mapped to licenses/agents
        UPDATE U
        SET U.bgId=L.bgId
        FROM #tempSCLUsageDetails U
        INNER JOIN #licMapTbl L ON L.licType=U.licType
        WHERE U.entityType=1--licenses
        AND L.countingType=1--capacity usage
        UPDATE C
        SET C.bgId=L.bgId
        FROM #tempSCLCALDetails C
        INNER JOIN #licMapTbl L ON L.licType=C.licType
        WHERE C.entityType=1--licenses
        AND L.countingType=0--CAL usage
        UPDATE U
        SET U.bgId=A.bgId
        FROM #tempSCLUsageDetails U
        INNER JOIN #agMapTbl A ON A.agType=U.appTypeId
        WHERE U.entityType=0--agents
        AND A.countingType=1--capacity usage
        UPDATE C
        SET C.bgId=A.bgId
        FROM #tempSCLCALDetails C
        INNER JOIN #agMapTbl A ON A.agType=C.licType
        WHERE C.entityType=0--agents
        AND A.countingType=0--CAL usage
        --update details table (for V2) with the SKUs that are mapped to AGENTS. Also update the counting type i.e., whether this SKU is to count client usage or capcity usage
        UPDATE D
        SET D.bgid=R.bgid, D.countingType=R.countingType,D.countingEntity=0--countingEntity=0 for AGENTS
        FROM #tempDetails D
        INNER JOIN
        (
            SELECT ISNULL(BL.billingGroupId,0) AS bgid,entityId,B.countingType FROM cm_BillingGroupToLicenseMap BL WITH (NOLOCK)
            INNER JOIN cm_BillingGroup B ON B.billingGroupId=BL.billingGroupId
            WHERE BL.billingGroupId IN (SELECT bgid FROM #bgMapTbl)
            AND entityType=0--agents
        ) R
        ON D.appTypeId = R.entityId
        WHERE D.bgid = 0 AND D.entityType=0--this update is required only for those entries which are applicable to agents
        --update details table with the SKUs that are mapped to LICENSES. Also update the counting type i.e., whether this SKU is to count client usage or capcity usage
        UPDATE D
        SET D.bgid=R.bgid, D.countingType=R.countingType,D.countingEntity=1--countingEntity=1 for LICENSES
        FROM #tempDetails D
        INNER JOIN
        (
            SELECT ISNULL(BL.billingGroupId,0) AS bgid,entityId,B.countingType FROM cm_BillingGroupToLicenseMap BL WITH (NOLOCK)
            INNER JOIN cm_BillingGroup B ON B.billingGroupId=BL.billingGroupId
            WHERE BL.billingGroupId IN (SELECT bgid FROM #bgMapTbl)
            AND entityType=1--licenses
        ) R
        ON D.lictype = R.entityId
        WHERE D.bgid = 0 --if already agent SKU is mapped to a row, it will not get mapped again to license SKU
        --we should count only backup job (jobType=0) sizes for capacity SKUs (countingType=1)
        UPDATE #tempDetails
        SET bgid=0
        WHERE bgid > 0 AND countingType=1 and jobType <> 0
        AND licType NOT IN (@DAELicType, @DPSLicType, @DPRLicType)--for these 3 licenses we should count archive, snap and replicate jobs
        -- ----------------------------------------------------------------------------
        -- MR 166297 - Conditional billing of eSIM usage
        -- eSIM billing groups are usually priced much lower than the DPF billing groups. Laptop backups can either be billed at DPF rate or at eSIM rate
        -- customer can use the end point user licenses for backing up laptop data - in such cases we should charge them only for eSIM usage even though Laptop&Desktop data is also recorded in cloud
        -- if customer doesn't use any end point license then, laptop backup should get charged at DPF rate
        -- but we are also setting a limit on the eSIM usage - one end point user should be using only a max of 5 devices and should not be backing up data more than 2TB
        -- if this limit exceeds then, we should charge them at the DPF rate instead of eSIM rate
        -- From SP9, in this billing system, 'Server File System' license will be replaced with 'File System Only Server' and 'Laptop and Desktop' will be replaced with 'Laptop and Desktop Count'. Hence corresponding change has been added in the below code
        IF @contractType=0--this conditional billing is currently for CommCell based contracts
        BEGIN
            -- reset all eSim variables after each iteration of loop
            SET @eSimOn = 0 -- [0=flag is ON, bill at eSim rate] [1,2,3=flag is OFF, bill at DPF rate]
            SET @userCount = 0
            SET @deviceCount = 0
            SET @deviceSize = 0
            SET @DPF_billingGroupID = 0 -- placeholder for the Data Protection Foundation billing group at which the 'Server File System' usage is charged in this contract
            SET @eSIM_billingGroupID = 0 -- placeholder for the eSIM billing group at which the 'end point user' usage is charged in this contract
            SET @comment = ''
            SET @FSOLicType = 0
            SET @DLOLicType = 0
            -- find number of eSim users, if any
            SELECT @userCount=SUM(licenseUsage)
            FROM #tempLicenses
            WHERE lictype=100024 --[End point users]=license type 100024
            -- find if eSim SKU is associated to this contract
            SELECT TOP 1 @eSIM_billingGroupID=bgid
            FROM #tempLicenses
            WHERE lictype=100024 --[End point users]=license type 100024
            ORDER BY csid,lictype
            IF @eSIM_billingGroupID = 0
            BEGIN
                SET @eSimOn = -1 -- eSIM SKU is not defined in the contract
            END
            -- find the ID of the DPF billing group in this contract (i.e., find the billing group which is used to charge 'Server File System' OR 'File System Only Server' usage)
            SELECT TOP 1 @DPF_billingGroupID=bgid, @FSOLicType=lictype
            FROM #licMapTbl
            WHERE lictype IN (1,100029) --[Server File System]=license type 1, [File System Only Server]=license type 100029
            AND bgid > 0
            ORDER BY lictype
            IF @FSOLicType=100029
            BEGIN
                SET @DLOLicType=200002 --during this computation, when billing sku has the new File System Only license, we should take into account the new DLO license only
            END
            ELSE
            BEGIN
                SET @DLOLicType=2 --take older Laptop and Desktop license when billing sku has older Server File System license
            END
            -- when end point user count is greater than 0, and if the contract is associated to eSIM SKU then, check if eSim flag should remain ON or OFF
            IF @userCount > 0 AND @eSIM_billingGroupID > 0
            BEGIN
                -- find laptop usage
                SELECT @deviceCount=SUM(licenseUsage), @deviceSize=SUM(capacityUsage)
                FROM #tempLicenses
                WHERE lictype=@DLOLicType --[Laptop and Desktop]=license type 2, [Laptop and Desktop Count]=license type 200002
                IF (@deviceCount > (@userCount*@maxDeviceCount) AND @deviceSize > (@userCount*CONVERT(BIGINT,@maxDeviceSizeInGB)*1073741824))
                BEGIN
                    SET @eSimOn = 1 --even though there is eSim usage, we will charge the customer at DPF rate because, he has exceeded the maximum allowed device count & usage size per user
                END
                ELSE
                BEGIN
                    IF @deviceCount > (@userCount*@maxDeviceCount)
                    BEGIN
                        SET @eSimOn = 2 --even though there is eSim usage, we will charge the customer at DPF rate because, he has exceeded the maximum allowed device count per user
                    END
                    IF @deviceSize > (@userCount*CONVERT(BIGINT,@maxDeviceSizeInGB)*1073741824)
                    BEGIN
                        SET @eSimOn = 3 --even though there is eSim usage, we will charge the customer at DPF rate because, he has exceeded the maximum allowed usage size per user
                    END
                END
            END
            -- if eSIM flag is OFF then, bill the customer at DPF rate instead of eSIM rate
            IF @eSimOn > 0
            BEGIN
                -- since usage exceeds the maximum allowed eSIM limit, customer should be charged for the LaptopDesktop usage at the normal DPF rate instead of being charged at eSIM rate
                UPDATE #tempLicenses
                SET bgid = @DPF_billingGroupID
                WHERE lictype=@DLOLicType --[Laptop and Desktop]=license type 2, [Laptop and Desktop Count]=license type 200002
                -- no billing group will be associated to eSIM and this usage will come up in the exception report (this is the expected behavior)
                UPDATE #tempLicenses
                SET bgid = 0
                WHERE lictype=100024 --[End point users]=license type 100024
            END
            ELSE
            BEGIN
                -- this is to make sure that, even if the DPF billing group has LaptopDesktop license associated to it, it will not get billed if, the the end point user is getting billed for eSim usage
                IF @userCount > 0 AND @eSIM_billingGroupID > 0
                BEGIN
                    UPDATE #tempLicenses
                    SET bgid = 0
                    WHERE lictype=@DLOLicType --[Laptop and Desktop]=license type 2, [Laptop and Desktop Count]=license type 200002
                END
            END
            -- construct the comment to be displayed at the end of exception list, if any
            IF @userCount > 0
            BEGIN
                IF @eSimOn = 0
                BEGIN
                    SET @comment = 'Please note: eSim SKU has been applied on the Laptop and Desktop usage'
                END
                ELSE IF @eSimOn = 1
                BEGIN
                    SET @comment = 'Please note: eSim SKU could not be applied as the usage exceeded the maximum allowed limit of '+CONVERT(VARCHAR(10),@maxDeviceSizeInGB/1024)+'TB and '+CONVERT(VARCHAR(10),@maxDeviceCount)+' devices per user. Hence Laptop and Desktop usage will be charged at the DPF rate'
                END
                ELSE IF @eSimOn = 2
                BEGIN
                    SET @comment = 'Please note: eSim SKU could not be applied as the usage exceeded the maximum allowed limit of '+CONVERT(VARCHAR(10),@maxDeviceCount)+' devices per user. Hence Laptop and Desktop usage will be charged at the DPF rate'
                END
                ELSE IF @eSimOn = 3
                BEGIN
                    SET @comment = 'Please note: eSim SKU could not be applied as the usage exceeded the maximum allowed limit of '+CONVERT(VARCHAR(10),@maxDeviceSizeInGB/1024)+'TB per user. Hence Laptop and Desktop usage will be charged at the DPF rate'
                END
            END
        END
        -- ----------------------------------------------------------------------------
        --  below queries are all to find the usage & cost of licenses/agents that are mapped to some billing group
        --  find usage for the billing groups having licenses
        INSERT #tempUsage
        SELECT csid,bgid,B.billingGroupName,B.countingType,
        CASE WHEN B.countingType=1 THEN sum(ISNULL(capacityUsage,0))
             WHEN B.countingType=0 THEN sum(ISNULL(licenseUsage,0))
        END AS usage,'','',0,0,0,0
         FROM #tempLicenses
        INNER JOIN cm_BillingGroup B WITH (NOLOCK) ON bgid = B.billingGroupId
        WHERE ISNULL(bgid,0) <> 0
        GROUP BY csid,bgid,B.billingGroupName,B.countingType
        --  find usage for the billing groups having agents with counting type=[capacity]
        MERGE into #tempUsage T
        USING(
            SELECT csid,bgid,B.billingGroupName,B.countingType,
            SUM(ISNULL(capacityUsage,0)) AS usage
            FROM #tempAgents
            INNER JOIN cm_BillingGroup B WITH (NOLOCK) ON bgid = B.billingGroupId
            WHERE ISNULL(bgid,0) <> 0
            AND B.countingType=1
            GROUP BY csid,bgid,B.billingGroupName,B.countingType
        ) S ON (T.csid=S.csid AND T.bgid=S.bgid AND T.countingType=S.countingType)
        WHEN MATCHED --Update the existing items
            THEN UPDATE SET T.usage=(T.usage+S.usage)
        WHEN NOT MATCHED BY TARGET --Insert the new items
            THEN INSERT VALUES (S.csid,S.bgid,S.billingGroupName,S.countingType,S.usage,'','',0,0,0,0);
        --  find usage for the billing groups having agents counting type=[client count]
        MERGE into #tempUsage T
        USING(
            SELECT csid,bgid,billingGroupName,countingType,SUM(ISNULL(agentUsage,0)) AS usage
            FROM
            (SELECT csid,typeid,bgid,B.billingGroupName,B.countingType,MAX(agentUsage) as agentUsage
            --SUM(ISNULL(agentUsage,0)) AS usage
            FROM #tempAgents
            INNER JOIN cm_BillingGroup B WITH (NOLOCK) ON bgid = B.billingGroupId
            WHERE ISNULL(bgid,0) <> 0
            AND B.CountingType=0
            GROUP BY csid,typeid,bgid,B.billingGroupName,B.countingType
            ) TA
            GROUP BY csid,bgid,billingGroupName,countingType
        ) S ON (T.csid=S.csid AND T.bgid=S.bgid AND T.countingType=S.countingType)
        WHEN MATCHED --Update the existing items
            THEN UPDATE SET T.usage=(T.usage+S.usage)
        WHEN NOT MATCHED BY TARGET --Insert the new items
            THEN INSERT VALUES (S.csid,S.bgid,S.billingGroupName,S.countingType,S.usage,'','',0,0,0,0);
        -- ----------------------------------------------------------------------------
        IF @contractType=0
        BEGIN
            --  find CommCell ID & name to be displayed to the user in the details table
            --  CCId=CCID & CCName=CustomerName+CommServerName - from cf_CommcellIdNameMap
            UPDATE U
            SET U.ccid=T.CommCellID, U.ccname=(T.CustomerName+' - '+T.CommServName)
            FROM #tempUsage U
            INNER JOIN
            (
            SELECT ID, CommCellID, CustomerName, CommServName
            FROM cf_CommcellIdNameMap WITH (NOLOCK)
            )T ON U.csid=T.ID
        END
        ELSE
        BEGIN
            --  find tenant name
            UPDATE U
            SET U.ccname=T.tenantName--for tenant based contracts, we will store tenant names in the ccname column
            FROM #tempUsage U
            INNER JOIN
            (
            SELECT tenantId,CASE WHEN tenantName='(default)' THEN @spName WHEN tenantName=NULL THEN @spName ELSE tenantName END AS tenantName FROM cm_ContractToTenantToBillingGroupMap WITH (NOLOCK) WHERE contractId=@contractId
            )T ON U.csid=T.tenantId
        END
        -- ----------------------------------------------------------------------------
        --  following queries are to bill the user based on the total usage of each billing group (combining usage of all CS/tenant together)
        IF @contractType=0
        BEGIN
            INSERT #tempBilling
            SELECT B.billingGroupId,B.BillingGroupName,'',0,0,Price,LowerLimit,UpperLimit,0,0,0,0,0,'-1',''
            FROM cm_ContractToBillingGroupMap C WITH (NOLOCK)
            INNER JOIN cm_BillingGroup B WITH (NOLOCK) ON B.billingGroupId=C.billingGroupId
            WHERE contractId=@contractId
            --AND (upperLimit > 0 OR price > 0)--(either the row should give a tiered price, where price>0 & upperLimit=-1) OR (it should give the baseLine, where price=0 & upperLimit > 0)
            AND (price > 0)--baseline tier shouldn't be shown, hence modifying the earlier condition which is now commented out above
            GROUP BY B.billingGroupId,billingGroupName,price,lowerLimit,upperLimit
            ORDER BY  billingGroupName,lowerLimit
        END
        ELSE
        BEGIN
            INSERT #tempBilling
            SELECT B.billingGroupId,B.BillingGroupName,'',0,MIN(baseline),Price,LowerLimit,UpperLimit,0,0,0,0,0,tenantId,''
            FROM cm_ContractToTenantToBillingGroupMap C WITH (NOLOCK)
            INNER JOIN cm_BillingGroup B WITH (NOLOCK) ON B.billingGroupId=C.billingGroupId
            WHERE contractId=@contractId
            GROUP BY B.billingGroupId,billingGroupName,price,lowerLimit,upperLimit,tenantId
            ORDER BY  tenantId,billingGroupName,lowerLimit
            --some SKUs might be defined only for default tenant. Other tenants in the contract might be missing it
            --In such cases, these missing SKUs should be added with the pricing of default tenant
            --first find missing SKUs
            DELETE FROM #tempTenantUsage
            INSERT #tempTenantUsage--reusing this temp table
            SELECT tenantId,'','',billingGroupId,0,0,0,0,0 FROM
            (SELECT tenantId FROM cm_ContractToTenantToBillingGroupMap WITH (NOLOCK) WHERE contractId=@contractId AND tenantId<>'-1' GROUP BY tenantId) T
            CROSS APPLY
            (SELECT billingGroupId FROM cm_ContractToTenantToBillingGroupMap WITH (NOLOCK) WHERE contractId=@contractId AND tenantId='-1') B
            DECLARE @missingSKUs TABLE (tenantId NVARCHAR(40),billingGroupId INT)
            INSERT @missingSKUs
            SELECT DISTINCT T.tenantId,T.countingType FROM #tempTenantUsage T
            LEFT JOIN (SELECT tenantId,billingGroupId FROM cm_ContractToTenantToBillingGroupMap WITH (NOLOCK) WHERE contractId=@contractId AND tenantId<>'-1' GROUP BY tenantId,billingGroupId) C
            ON T.tenantId=C.tenantId AND T.countingType=C.billingGroupId
            WHERE C.tenantId IS NULL
            --enter missing SKUs with default pricing into #tempBilling table
            --only SKU picing should be inherited. Baseline should be defined individually for each tenant and hence shouldn't be inherited
            INSERT #tempBilling
            SELECT M.billingGroupId,B.BillingGroupName,'',0,0,Price,LowerLimit,UpperLimit,0,0,0,0,0,tenantId,''
            FROM @missingSKUs M
            INNER JOIN
            (SELECT billingGroupId,Price,LowerLimit,UpperLimit
            FROM cm_ContractToTenantToBillingGroupMap C WITH (NOLOCK)
            WHERE contractId=@contractId AND C.tenantId='-1' AND billingGroupId IN (SELECT DISTINCT billingGroupId FROM @missingSKUs)
            GROUP BY billingGroupId,price,lowerLimit,upperLimit,tenantId
            ) D ON D.billingGroupId=M.billingGroupId
            INNER JOIN cm_BillingGroup B WITH (NOLOCK) ON B.billingGroupId=D.billingGroupId
            ORDER BY tenantId,B.billingGroupName,D.billingGroupId,lowerLimit
            --clean up before moving on further
            DELETE FROM @missingSKUs
            DELETE FROM #tempTenantUsage
        END
        --  update description & counting type here
        --  cannot store this in #tempUsage as it doesn't have data on agent licenses with no usage even though capacity licenses with no usage is recorded in it
        --  hence it will not have the details of those billing groups mapped to only agent licenses having no usage data
        UPDATE B
        SET B.description=U.description, B.countingType=U.countingType
        FROM #tempBilling B
        INNER JOIN
        (
        SELECT billingGroupName,description,countingType
        FROM cm_BillingGroup WITH (NOLOCK)
        GROUP BY billingGroupName,description,countingType
        ) U ON U.billingGroupName=B.billingGroupName
        --update baseline
        IF @contractType=0--find baseline for CommCell based contract
        BEGIN
            UPDATE B
            SET B.baseLine=U.upperLimit
            FROM #tempBilling B
            INNER JOIN
            (
            SELECT billingGroupName, upperLimit
            FROM cm_BillingGroup G WITH (NOLOCK)
            INNER JOIN cm_ContractToBillingGroupMap C WITH (NOLOCK)
            ON G.billingGroupId=C.billingGroupId
            WHERE price=0
            AND contractId=@contractId
            ) U ON U.billingGroupName=B.billingGroupName
            --  update total usage
            UPDATE B
            SET TotalUsage=(U.usage-B.BaseLine)--baseline should be removed from total usage, before splitting it into usage of each tier
            ,ActualUsage=U.usage--total usage including baseline that has to be displayed in the usage summary section
            FROM #tempBilling B
            INNER JOIN
            (
            SELECT bgName,countingType,
            CASE WHEN countingType=1 THEN CASE WHEN @contractType=0 THEN CEILING(CAST(SUM(usage) AS FLOAT)/@bytesInTB) ELSE ROUND(CAST(SUM(usage) AS FLOAT)/@bytesInTB,5) END--for tenant based contracts, do not round off to whole number
                 WHEN countingType=0 THEN SUM(usage)
            END AS usage
            FROM #tempUsage
            GROUP BY bgName,countingType
            ) U ON U.bgName=B.BillingGroupName
            --since baseline usage is removed from total usage already, lower limit of the first tier should be made 0 instead of starting from baseline
            --only required for CommCell based contracts. For tenant based, lowerLimit is already 0
            UPDATE #tempBilling
            SET LowerLimit=0
            WHERE LowerLimit=BaseLine
        END
        ELSE--find baseline for Tenant based contract
        BEGIN
            --baseline in the #tempBilling table is already updated above. Only #tempUsage table needs to be updated here
            --baseline of tenant based contracts is mapped in #tempUsage table
            UPDATE U
            SET U.baseLine=T.baseline
            FROM #tempUsage U
            INNER JOIN
            (
            SELECT tenantId,billingGroupId,MIN(baseline) AS 'baseline' FROM #tempBilling GROUP BY tenantId,billingGroupId
            )T ON T.tenantId=U.csid AND T.billingGroupId=U.bgid
            --update utility usage column of #tempUsage table
            UPDATE #tempUsage SET utilityUsage=CASE WHEN ROUND(CAST(usage AS FLOAT)/@bytesInTB,5) > baseline THEN ROUND(CAST(usage AS FLOAT)/@bytesInTB,5) - baseline ELSE 0 END
            WHERE countingType=1
            UPDATE #tempUsage SET utilityUsage=CASE WHEN usage > baseline THEN usage - baseline ELSE 0 END
            WHERE countingType=0
            --update tenant name in #tempBilling table
            UPDATE B
            SET B.tenantName=T.tenantName
            FROM #tempBilling B
            INNER JOIN
            (
            SELECT tenantId,CASE WHEN tenantName='(default)' THEN @spName WHEN tenantName=NULL THEN @spName ELSE tenantName END AS tenantName FROM cm_ContractToTenantToBillingGroupMap WITH (NOLOCK) WHERE contractId=@contractId
            )T ON B.tenantId=T.tenantId
            --  update total usage
            UPDATE B
            SET TotalUsage=U.utilityUsage
            ,ActualUsage=U.usage--total usage including baseline that has to be displayed in the usage summary section
            FROM #tempBilling B
            INNER JOIN
            (
            SELECT csid,bgName,countingType,SUM(utilityUsage) AS utilityUsage,
            CASE WHEN countingType=1 THEN CASE WHEN @contractType=0 THEN CEILING(CAST(SUM(usage) AS FLOAT)/@bytesInTB) ELSE ROUND(CAST(SUM(usage) AS FLOAT)/@bytesInTB,5) END--for tenant based contracts, do not round off to whole number
                 WHEN countingType=0 THEN SUM(usage)
            END AS usage
            FROM #tempUsage
            GROUP BY csid,bgName,countingType
            ) U ON U.csid=B.tenantId AND U.bgName=B.BillingGroupName
        END
        --  find the usage in each tier
        UPDATE #tempBilling
        SET UsagePerTier = CASE
                        WHEN UpperLimit > 0 AND TotalUsage > UpperLimit THEN UpperLimit - LowerLimit
                        ELSE (
                            CASE
                                WHEN TotalUsage > LowerLimit  THEN (TotalUsage-LowerLimit)
                                ELSE 0
                            END)
                        END
        --  find cost per tier
        UPDATE #tempBilling
        SET CostPerTier = UsagePerTier * Price
        -- find the total cost
        IF @contractType=0
        BEGIN
            UPDATE B
            SET B.TotalCost=T.TotalCost
            FROM #tempBilling B
            INNER JOIN
            (
            SELECT BillingGroupName, SUM(CostPerTier) AS TotalCost
            FROM #tempBilling
            GROUP BY BillingGroupName
            ) T ON T.BillingGroupName = B.BillingGroupName
        END
        ELSE
        BEGIN
            UPDATE B
            SET B.TotalCost=T.TotalCost
            FROM #tempBilling B
            INNER JOIN
            (
            SELECT tenantId, BillingGroupName, SUM(CostPerTier) AS TotalCost
            FROM #tempBilling
            GROUP BY tenantId,BillingGroupName
            ) T ON T.tenantId = B.tenantId AND T.BillingGroupName = B.BillingGroupName
            --find average sku cost and cost per sku for tenant based contracts
            UPDATE U
            SET averageCost=CASE WHEN B.TotalCost<=0 THEN 0 WHEN B.TotalUsage<=0 THEN 0 ELSE ROUND(B.TotalCost/B.TotalUsage,2) END
            FROM #tempUsage U
            INNER JOIN
            (
            SELECT tenantId,BillingGroupId,TotalCost,TotalUsage FROM #tempBilling GROUP BY tenantId,BillingGroupId,TotalCost,TotalUsage
            )B ON B.tenantId=U.csid AND B.BillingGroupId=U.bgid
            UPDATE #tempUsage
            SET costPerSku=ROUND(averageCost*utilityUsage,2)
        END
        -- --------------------------RESULTSET FOR DETAIL TABLE--------------------------------------------------
    IF @i_InvokedFrom=0--output these resultsets only when this stored procedure is invoked from billing portal
    BEGIN
        IF @contractType=0
        BEGIN
            --  ResultSet #0, #10, #20
            --  display capacity usage under each billing group by each CS of this client group
            SELECT
            CASE WHEN U.id = (SELECT TOP 1 id FROM #tempUsage T WHERE T.csid=U.csid AND countingType=1 ORDER BY id) THEN U.ccid ELSE '' END AS 'CommCell ID',
            CASE WHEN U.id = (SELECT TOP 1 id FROM #tempUsage T WHERE T.csid=U.csid AND countingType=1 ORDER BY id) THEN U.ccname ELSE '' END AS 'CommCell Name',
            bgName AS 'SKU',CONVERT(VARCHAR(50),ROUND(CAST(SUM(usage) AS FLOAT)/@bytesInTB,5)) AS 'Usage (TB)'
            FROM #tempUsage U
            WHERE countingType=1
            GROUP BY id,csid,ccid,ccname,bgName
            ORDER BY ccid
            --  ResultSet #1, #11, #21
            --  display  client count under each billing group by each CS of this client group
            SELECT
            CASE WHEN U.id = (SELECT TOP 1 id FROM #tempUsage T WHERE T.csid=U.csid AND countingType=0 ORDER BY id) THEN U.ccid ELSE '' END AS 'CommCell ID',
            CASE WHEN U.id = (SELECT TOP 1 id FROM #tempUsage T WHERE T.csid=U.csid AND countingType=0 ORDER BY id) THEN U.ccname ELSE '' END AS 'CommCell Name',
            bgName AS 'SKU',
            sum(usage) AS 'Usage'
            FROM #tempUsage U
            WHERE countingType=0
            GROUP BY id,csid,ccid,ccname,bgName
            ORDER BY ccid
        END
        ELSE
        BEGIN
            DELETE #tempTenantUsage--delete existing entries, if any
            INSERT #tempTenantUsage
            SELECT U.csid,ISNULL(U.ccname,'Sub Total'),bgName,1,
            ROUND(CAST(SUM(usage) AS FLOAT)/@bytesInTB,5),
            SUM(baseline),SUM(utilityUsage),0,0
            FROM #tempUsage U
            WHERE countingType=1
            GROUP BY
                GROUPING SETS((csid,ccname,bgName),(csid))
            INSERT #tempTenantUsage
            SELECT U.csid,ISNULL(U.ccname,'Sub Total'),bgName,0,
            SUM(usage),SUM(baseline),SUM(utilityUsage),0,0
            FROM #tempUsage U
            WHERE countingType=0
            GROUP BY
                GROUPING SETS((csid,ccname,bgName),(csid))
            --  ResultSet #0, #10, #20
            --  display capacity usage under each billing group by each tenant of this client group
            SELECT
            CASE WHEN U.id = (SELECT TOP 1 id FROM #tempTenantUsage T WHERE T.tenantId=U.tenantId AND countingType=1 ORDER BY id) THEN @bullet+ U.tenantName
                 ELSE CASE WHEN U.tenantName LIKE 'Sub Total' THEN U.tenantName
                      ELSE '' END
                 END AS 'Tenant Name',
            bgName AS 'SKU', totalUsage AS 'Total Usage (TB)', baseline AS 'Baseline (TB)',utilityUsage AS 'Utility Usage (TB)'
            FROM #tempTenantUsage U WHERE countingType=1
            --  ResultSet #1, #11, #21
            --  display  client count under each billing group by each tenant of this client group
            SELECT
            CASE WHEN U.id = (SELECT TOP 1 id FROM #tempTenantUsage T WHERE T.tenantId=U.tenantId AND countingType=0 ORDER BY id) THEN @bullet+ U.tenantName
                 ELSE CASE WHEN U.tenantName LIKE 'Sub Total' THEN U.tenantName
                      ELSE '' END
                 END AS 'Tenant Name',
            bgName AS 'SKU', totalUsage AS 'Total Usage', baseline AS 'Baseline',utilityUsage AS 'Utility Usage'
            FROM #tempTenantUsage U WHERE countingType=0
        END
        -- --------------------------RESULTSET FOR DETAIL TABLE--------------------------------------------------
        IF @contractType=0
        BEGIN
            --  ResultSet #2, #12, #22
            --  display capacity usage and cost based on each billing group
            SELECT
            ISNULL(BillingGroupName,'Sub Total') AS 'SKU',
            ISNULL(CONVERT(VARCHAR(10),LowerLimit),'') AS 'Lower Limit (TB)',ISNULL(CONVERT(VARCHAR(10),UpperLimit),'') AS 'Upper Limit (TB)',
            CASE WHEN Price IS NULL THEN ''
            ELSE CONVERT(VARCHAR(MAX),Price)
            END AS 'Price per Tier',
            SUM(UsagePerTier) AS 'Usage per Tier (TB)', SUM(CostPerTier) AS 'Cost per Tier'
            FROM #tempBilling B
            WHERE CountingType=1
            GROUP BY
                GROUPING SETS((BillingGroupId,BillingGroupName,LowerLimit,UpperLimit,Price),(BillingGroupId))
            --  ResultSet #3, #13, #23
            --  display client count and cost based on each billing group
            SELECT
            ISNULL(BillingGroupName,'Sub Total') AS 'SKU',
            ISNULL(CONVERT(VARCHAR(10),LowerLimit),'') AS 'Lower Limit',ISNULL(CONVERT(VARCHAR(10),UpperLimit),'') AS 'Upper Limit',
            CASE WHEN Price IS NULL THEN ''
            ELSE CONVERT(VARCHAR(MAX),Price)
            END AS 'Price per Tier',
            SUM(UsagePerTier) AS 'Usage per Tier', SUM(CostPerTier) AS 'Cost per Tier'
            FROM #tempBilling B
            WHERE CountingType=0
            GROUP BY
                GROUPING SETS((BillingGroupId,BillingGroupName,LowerLimit,UpperLimit,Price),(BillingGroupId))
        END
        ELSE
        BEGIN
            --  ResultSet #2, #12, #22
            --  display capacity usage and cost based on each billing group
            --  first fetch resultset
            DELETE #tempTenantUsage--delete existing entries, if any
            INSERT #tempTenantUsage--we are just reusing tempTenant table. Hence column names and values may not match
            SELECT tenantId, ISNULL(tenantName,'Sub Total'), BillingGroupName, BaseLine,
            LowerLimit AS totalUsage,UpperLimit AS baseline,
            Price AS utilityUsage, SUM(UsagePerTier) AS averageCost, SUM(CostPerTier) AS totalCost
            FROM #tempBilling B
            WHERE CountingType=1
            GROUP BY
                GROUPING SETS((tenantId,BillingGroupId,tenantName,BillingGroupName,BaseLine,LowerLimit,UpperLimit,Price),(tenantId,BillingGroupId))
            --  now display resultset
            SELECT
            CASE WHEN U.id = (SELECT TOP 1 id FROM #tempTenantUsage T WHERE T.tenantId=U.tenantId AND T.bgName=U.bgName ORDER BY id) THEN @bullet+ U.tenantName
                 ELSE CASE WHEN U.tenantName LIKE 'Sub Total' THEN U.tenantName
                      ELSE '' END
                 END AS 'Tenant Name',
            CASE WHEN U.id = (SELECT TOP 1 id FROM #tempTenantUsage T WHERE T.tenantId=U.tenantId AND T.bgName=U.bgName ORDER BY id) THEN U.bgName
                 ELSE '' END AS 'SKU',
            CASE WHEN U.id = (SELECT TOP 1 id FROM #tempTenantUsage T WHERE T.tenantId=U.tenantId AND T.bgName=U.bgName ORDER BY id) THEN CONVERT(VARCHAR(10),U.countingType)
                 ELSE '' END AS 'Baseline (TB)',
            ISNULL(CONVERT(VARCHAR(MAX),totalUsage),'') AS 'Lower Limit (TB)', ISNULL(CONVERT(VARCHAR(MAX),baseline),'') AS 'Upper Limit (TB)',
            ISNULL(CONVERT(VARCHAR(MAX),utilityUsage),'') AS 'Price per Tier', averageCost AS 'Usage per Tier (TB)', totalCost AS 'Cost per Tier'
            FROM #tempTenantUsage U
            --  ResultSet #3, #13, #23
            --  display client count and cost based on each billing group
            --  first fetch resultset
            DELETE #tempTenantUsage--delete existing entries, if any
            INSERT #tempTenantUsage--we are just reusing tempTenant table. Hence column names and values may not match
            SELECT tenantId, ISNULL(tenantName,'Sub Total'), BillingGroupName, BaseLine,
            LowerLimit AS totalUsage,UpperLimit AS baseline,
            Price AS utilityUsage, SUM(UsagePerTier) AS averageCost, SUM(CostPerTier) AS totalCost
            FROM #tempBilling B
            WHERE CountingType=0
            GROUP BY
                GROUPING SETS((tenantId,BillingGroupId,tenantName,BillingGroupName,BaseLine,LowerLimit,UpperLimit,Price),(tenantId,BillingGroupId))
            --  now display resultset
            SELECT
            CASE WHEN U.id = (SELECT TOP 1 id FROM #tempTenantUsage T WHERE T.tenantId=U.tenantId AND T.bgName=U.bgName ORDER BY id) THEN @bullet+ U.tenantName
                 ELSE CASE WHEN U.tenantName LIKE 'Sub Total' THEN U.tenantName
                      ELSE '' END
                 END AS 'Tenant Name',
            CASE WHEN U.id = (SELECT TOP 1 id FROM #tempTenantUsage T WHERE T.tenantId=U.tenantId AND T.bgName=U.bgName ORDER BY id) THEN U.bgName
                 ELSE '' END AS 'SKU',
            CASE WHEN U.id = (SELECT TOP 1 id FROM #tempTenantUsage T WHERE T.tenantId=U.tenantId AND T.bgName=U.bgName ORDER BY id) THEN CONVERT(VARCHAR(10),U.countingType)
                 ELSE '' END AS 'Baseline',
            ISNULL(CONVERT(VARCHAR(MAX),totalUsage),'') AS 'Lower Limit', ISNULL(CONVERT(VARCHAR(MAX),baseline),'') AS 'Upper Limit',
            ISNULL(CONVERT(VARCHAR(MAX),utilityUsage),'') AS 'Price per Tier', averageCost AS 'Usage per Tier', totalCost AS 'Cost per Tier'
            FROM #tempTenantUsage U
        END
        -- --------------------------RESULTSET FOR SUMMARY TABLE--------------------------------------------------
        DECLARE @totalBaseline FLOAT = 0
        DECLARE @totalActualUsage FLOAT = 0
        IF @contractType=0
        BEGIN
            --  ResultSet #4, #14, #24
            --  display summary of capacity usage & cost
            SELECT @totalBaseline=SUM(T.BaseLine),@totalActualUsage=SUM(T.ActualUsage) FROM (SELECT DISTINCT BillingGroupName, baseline, ActualUsage FROM #tempBilling WHERE CountingType=1) T
            SELECT ISNULL(BillingGroupName,'Total') AS 'SKU',ISNULL(CONVERT(VARCHAR(10),ActualUsage),@totalActualUsage) AS 'Total Usage (TB)',ISNULL(CONVERT(VARCHAR(10),BaseLine),@totalBaseline) AS 'Baseline (TB)',
            SUM(UsagePerTier) AS 'Utility Usage (TB)',SUM(CostPerTier) AS 'Total Cost'
            FROM #tempBilling
            WHERE CountingType=1
            GROUP BY
                GROUPING SETS((BillingGroupName,Description,BaseLine,ActualUsage),())
            --  ResultSet #5, #15, #25
            --  display summary of client count usage & cost
            SELECT @totalBaseline=SUM(T.BaseLine),@totalActualUsage=SUM(T.ActualUsage) FROM (SELECT DISTINCT BillingGroupName, baseline, ActualUsage FROM #tempBilling WHERE CountingType=0) T
            SELECT ISNULL(BillingGroupName,'Total') AS 'SKU',ISNULL(CONVERT(VARCHAR(10),ActualUsage),@totalActualUsage) AS 'Total Usage',ISNULL(CONVERT(VARCHAR(10),BaseLine),@totalBaseline) AS 'Baseline',
            SUM(UsagePerTier) AS 'Utility Usage',SUM(CostPerTier) AS 'Total Cost'
            FROM #tempBilling
            WHERE CountingType=0
            GROUP BY
                GROUPING SETS((BillingGroupName,Description,BaseLine,ActualUsage),())
        END
        ELSE
        BEGIN
            DELETE #tempTenantUsage--delete existing entries, if any
            INSERT #tempTenantUsage
            SELECT tenantId,'',BillingGroupName,1,ActualUsage,BaseLine,SUM(UsagePerTier),0,SUM(CostPerTier)
            FROM #tempBilling
            WHERE CountingType=1
            GROUP BY tenantId,BillingGroupName,Description,BaseLine,ActualUsage
            INSERT #tempTenantUsage
            SELECT tenantId,'',BillingGroupName,0,ActualUsage,BaseLine,SUM(UsagePerTier),0,SUM(CostPerTier)
            FROM #tempBilling
            WHERE CountingType=0
            GROUP BY tenantId,BillingGroupName,Description,BaseLine,ActualUsage
            --  ResultSet #4, #14, #24
            --  display summary of capacity usage & cost
            SELECT ISNULL(bgName,'Total') AS 'SKU',SUM(totalUsage) AS 'Total Usage (TB)',SUM(baseline) AS 'Baseline (TB)',SUM(utilityUsage) AS 'Utility Usage (TB)',SUM(totalCost) AS 'Total Cost'
            FROM #tempTenantUsage
            WHERE countingType=1
            GROUP BY
                GROUPING SETS((bgName),())
            --  ResultSet #5, #15, #25
            --  display summary of client count usage & cost
            SELECT ISNULL(bgName,'Total') AS 'SKU',SUM(totalUsage) AS 'Total Usage',SUM(baseline) AS 'Baseline',SUM(utilityUsage) AS 'Utility Usage',SUM(totalCost) AS 'Total Cost'
            FROM #tempTenantUsage
            WHERE countingType=0
            GROUP BY
                GROUPING SETS((bgName),())
        END
        -- --------------------------RESULTSET FOR BILL HEADER--------------------------------------------------
        --  ResultSet #6, #16, #26
        --  display the total cost to be paid by customer before and after considering the minimum fee committed in the contract
        IF(SELECT COUNT(*) FROM #tempBilling) > 0
        BEGIN
            DECLARE @tempTbl TABLE(groupName NVARCHAR(512),totalCost FLOAT, minFee FLOAT)
            DELETE FROM @tempTbl--clear the existing table contents after first iteration of while loop
            INSERT @tempTbl
            SELECT
            (SELECT name FROM cf_CommCellGroup WITH (NOLOCK) WHERE id = @i_GroupId),
            SUM(CostPerTier),ISNULL(@minFee,0)
            FROM #tempBilling
            SELECT groupName AS 'Service Provider', totalCost AS 'Total Cost', minFee AS 'Minimum Fee',
            CASE WHEN minFee > totalCost THEN minFee ELSE totalCost END AS 'Amount Due', @comment AS 'Comment'
            FROM @tempTbl
            SELECT @totalAmountDue=@totalAmountDue+(CASE WHEN minFee > totalCost THEN minFee ELSE totalCost END) FROM @tempTbl
        END
        ELSE
        BEGIN
            -- populate basic data when usage is not available
            DECLARE @ccGrpName VARCHAR(512) = 'Not Available'
            SELECT @ccGrpName=ISNULL(name,'Not Available') FROM cf_CommCellGroup WITH (NOLOCK) WHERE id = @i_GroupId AND LEN(name) > 0
            SELECT @ccGrpName AS 'Service Provider',0 AS 'Total Cost',0 AS 'Minimum Fee',0 AS 'Amount Due','' AS 'Comment'
        END
        ---- --------------------------RESULTSET FOR DETAIL TABLE--------------------------------------------------
        --  ResultSet #7, #17, #27
        --  display the exception list with capacity usage
        IF @contractType=0
        BEGIN
            --  ResultSet #7, #17, #27
            SELECT 'Dummy resultset','CommCell based report'
            --  ResultSet #8, #18, #28
            SELECT 'Dummy resultset','CommCell based report'
        END
        ELSE
        BEGIN
            DELETE #tempTenantUsage--delete existing entries, if any
            INSERT #tempTenantUsage
            SELECT U.csid,ISNULL(U.ccname,'Sub Total'),bgName,countingType,0,0,
            utilityUsage,averageCost,SUM(costPerSku)
            FROM #tempUsage U
            GROUP BY
                GROUPING SETS((csid,ccname,bgName,countingType,utilityUsage,averageCost),(csid))
            --  ResultSet #7, #17, #27
            --  display capacity usage under each billing group by each tenant of this client group
            SELECT
            CASE WHEN U.id = (SELECT TOP 1 id FROM #tempTenantUsage T WHERE T.tenantId=U.tenantId ORDER BY id) THEN @bullet+ U.tenantName
                 ELSE CASE WHEN U.tenantName LIKE 'Sub Total' THEN U.tenantName
                      ELSE '' END
                 END AS 'Tenant Name',
            bgName AS 'SKU', CASE WHEN U.tenantName LIKE 'Sub Total' THEN '' ELSE CASE WHEN countingType=1 THEN 'Capacity (TB)' ELSE 'Client Count' END END AS 'Counting Type',
            utilityUsage AS 'Utility Usage',
            averageCost AS 'Average Price per SKU',totalCost AS 'Cost per SKU'
            FROM #tempTenantUsage U
            --  ResultSet #8, #18, #28
            SELECT 'Dummy resultset','Tenant based report'
        END
        -- --------------------------RESULTSET FOR ADDITIONAL DETAILS TABLE--------------------------------------------------
        --  ResultSet #9, #19, #29
        --remove those rows which are not mapped to any billing group
        DELETE #tempDetails WHERE bgid<=0
        --**entityType=2-client Count rows for VMs; entityType=3-capacity usage rows for VMs
        --for VMs the capacity details and client count details are stored in separate rows. We have to remove those rows which are not same as the of the counting type of Billing SKU
        --1) billing SKU counts capacity. Hence remove client count rows
        DELETE FROM #tempDetails
        WHERE entityType=2 AND countingType=1
        --2) billing SKU counts clients. Hence remove capacity rows
        DELETE FROM #tempDetails
        WHERE entityType=3 AND countingType=0
        --older SKUs are mapped to retired licType 100011(Virtual Machines). They should be remapped to the new licType=100029(Protected Virtual Machines)
        UPDATE #tempDetails SET licType=@ProtectedVMLicType WHERE licType=@VirtualMachineLicType
        SELECT CC.CommCellID AS 'CommCell ID', B.billingGroupName AS 'SKU',
        (CASE WHEN T.countingType=0 THEN 'CAL Usage' ELSE 'Capacity Usage' END) AS 'Counting Type',
        ISNULL(T.clientId,-1) AS 'Client ID',
        (CASE WHEN T.clientId=-1 THEN 'NA' ELSE ISNULL(ISNULL(C.ClientDisplayName, C.ClientName),'NA') END) AS 'Client Name',
        (CASE WHEN T.countingEntity=0 THEN 'Agent' ELSE 'License' END) AS 'Counting Entity',
        (CASE WHEN T.licType=-1 THEN 'NA' ELSE ISNULL(L.name,'NA') END) AS 'License Name',
        (CASE WHEN T.appTypeId=-1 THEN 'NA' ELSE ISNULL(A.name,'NA') END) AS 'Agent Name',
        (CASE WHEN T.isVM=0 THEN 'No' WHEN T.isVM=1 THEN 'YES' ELSE 'NA' END) AS 'Is VM',
        (CASE WHEN T.appId=-1 THEN 'NA' ELSE ISNULL(SA.SubclientName,'NA') END) AS 'Subclient Name',
        (CASE WHEN T.jobType=0 THEN 'Backup' WHEN T.jobType=1 THEN 'Archive' WHEN T.jobType=2 THEN 'Snapshot' WHEN T.jobType=3 THEN 'Replication' WHEN T.jobType=-1 THEN 'NA' ELSE CONVERT(VARCHAR(10),T.jobType) END) AS 'Job Type',
        (CASE WHEN T.jobId=-1 THEN 'NA' ELSE CONVERT(VARCHAR(20),T.jobId) END) AS 'Job ID',
        (CASE WHEN T.jobId=-1 THEN 'NA' ELSE CONVERT(VARCHAR(20),T.AppSizeMB) END) AS 'Application Size (MB)',
        ISNULL(T.vmClientId,-1) AS 'VM Client ID',
        (CASE WHEN T.vmClientId=-1 THEN 'NA' ELSE ISNULL(ISNULL(V.ClientDisplayName, V.ClientName),'NA') END) AS 'VM Name',
        ISNULL(T.organizationId,-1) AS 'Tenant ID',
        ISNULL(T.organization,@spName) AS 'Tenant Name'
        FROM #tempDetails T
        INNER JOIN cf_CommcellIdNameMap CC WITH (NOLOCK) ON CC.ID=T.csid
        INNER JOIN cm_BillingGroup B WITH (NOLOCK) ON B.billingGroupId = T.bgid
        LEFT JOIN cf_SurveyClient C WITH (NOLOCK) ON C.ClientId=T.clientId AND C.CommServUniqueId=T.csid
        LEFT JOIN cf_SurveyLicType AS L WITH (NOLOCK) ON L.id = T.licType
        LEFT JOIN cf_SurveyAgentType AS A WITH (NOLOCK) ON A.id = T.appTypeId
        LEFT JOIN cf_SurveySubclientAssociation AS SA WITH (NOLOCK) ON SA.CommservUniqueId = T.csid AND SA.ClientId = T.ClientId AND SA.AppId = T.AppId AND SA.AppTypeId = T.appTypeId
        LEFT JOIN cf_SurveyClient V WITH (NOLOCK) ON V.ClientId=T.vmClientId AND V.CommServUniqueId=T.csid
        --WHERE T.bgid > 0--display only those details part of some SKU
        ORDER BY CC.ID, B.billingGroupName, ISNULL(C.ClientDisplayName, C.ClientName), L.name, SA.AgentName, SA.SubclientName, ISNULL(V.ClientDisplayName, V.ClientName)
    END
    ELSE IF @i_InvokedFrom=2--display details when invoked from SP13 custom reports
    BEGIN
        IF object_id('tempdb.dbo.#tempDetailsTableV3') IS NOT NULL
        BEGIN
            --  ResultSet #9, #19, #29
            -- ----------------------usages from V3 tables
            DELETE #tempSCLUsageDetails WHERE bgid<=0
            DELETE #tempSCLCALDetails WHERE bgid<=0
            INSERT #tempDetailsTableV3
            --Capacity details of licenses other than on VMs
            SELECT DISTINCT (@i_Month-1), bgId, 1, C.nJobType, C.jobId, C.licType, C.ClientId, C.appTypeId, C.appId, C.SPId, C.appSizeMB, -1, -1, 'N/A', 'N/A', 'N/A', -1, C.csid, C.organizationId, C.organization, 3, C.planName
            FROM #tempSCLUsageDetails C--Capacity usage
            WHERE C.entityType=1--licenses
            AND C.licType NOT IN (@VMWithAppLicType,@VMOnlyLicType,@ProtectedVMLicType,@VirtualMachineLicType)
            UNION
            --Capacity details of licenses on VMs
            SELECT DISTINCT (@i_Month-1), bgId, 1, -1, C.jobId, C.licType, -1, -1, -1, -1, C.appSizeMB, C.clientId, -1, 'N/A', 'N/A', 'N/A', -1, C.csid, C.organizationId, C.organization, 3, C.planName
            FROM #tempSCLUsageDetails C--Capacity usage
            WHERE C.entityType=1--licenses
            AND C.licType IN (@VMWithAppLicType,@VMOnlyLicType,@ProtectedVMLicType,@VirtualMachineLicType)
            UNION
            --CAL details of FSO, DLO, AppServer backups and DPE, DAE, DPS, DPR
            SELECT DISTINCT (@i_Month-1), bgId, 0, -1, -1, C.licType, C.ObjectId, -1, -1, -1, -1, -1, -1, 'N/A', 'N/A', 'N/A', -1, C.csid, C.organizationId, C.organization, 3, C.planName
            FROM #tempSCLCALDetails C--CAL usage
            WHERE C.entityType=1--licenses
            AND licType IN (@FSOnlyServerLicType,@DLOnlyLicType,@APPServerLicType,@DPELicType,@DAELicType,@DPSLicType,@DPRLicType)
            UNION
            --CAL details of VMs
            SELECT DISTINCT (@i_Month-1), bgId, 0, -1, -1, C.licType, -1, -1, -1, -1 ,-1, C.ObjectId, -1, 'N/A', 'N/A', 'N/A', -1, C.csid, C.organizationId, C.organization, 3, C.planName
            FROM #tempSCLCALDetails C--CAL usage
            WHERE C.entityType=1--licenses
            AND licType IN (@VMWithAppLicType,@VMOnlyLicType,@ProtectedVMLicType,@VirtualMachineLicType)
            UNION
            --CAL details of eSim
            SELECT DISTINCT (@i_Month-1), bgId, 0, -1, -1, C.licType, -1, -1, -1, -1, -1, -1, C.ObjectId, C.objectName, 'N/A', 'N/A', -1, C.csid, C.organizationId, C.organization, 3, C.planName
            FROM #tempSCLCALDetails C--CAL usage
            WHERE C.entityType=1--licenses
            AND licType IN (@epUsers,@sharingUsers,@eDiscoveryUsers)
            UNION
            --CAL details of mSim
            SELECT DISTINCT (@i_Month-1), bgId, 0, -1, -1, C.licType, -1, -1, -1, -1, -1, -1, -1, 'N/A', C.objectName, 'N/A', -1, C.csid, C.organizationId, C.organization, 3, C.planName
            FROM #tempSCLCALDetails C--CAL usage
            WHERE C.entityType=1--licenses
            AND licType IN (@mSimUsers)
            UNION
            --CAL details of vmSockets
            SELECT DISTINCT (@i_Month-1), bgId, 0, -1, -1, C.licType, -1, -1, -1, -1, -1, -1, -1, 'N/A', 'N/A', C.objectName, C.ObjectId, C.csid, C.organizationId, C.organization, 3, C.planName
            FROM #tempSCLCALDetails C--CAL usage
            WHERE C.entityType=1--licenses
            AND licType IN (@VMSocketsLicType)
            UNION
            --CAL details of traditional licenses
            SELECT DISTINCT (@i_Month-1), bgId, 0, -1, -1, C.licType, C.ObjectId, -1, -1, -1, -1, -1, -1, 'N/A', 'N/A', 'N/A', -1, C.csid, C.organizationId, C.organization, 3, C.planName
            FROM #tempSCLCALDetails C--CAL usage
            WHERE C.entityType=1--licenses
            AND licType < 1000
            UNION
            --Capacity details of agents
            SELECT DISTINCT (@i_Month-1), bgId, 1, C.nJobType, C.jobId, C.licType, C.ClientId, C.appTypeId, C.appId, C.SPId, C.appSizeMB, -1, -1, 'N/A', 'N/A', 'N/A', -1, C.csid, C.organizationId, C.organization, 3, C.planName
            FROM #tempSCLUsageDetails C--Capacity usage
            WHERE C.entityType=0--agents
            UNION
            --CAL details of Agents
            SELECT DISTINCT (@i_Month-1), bgId, 0, -1, -1, -1, C.ObjectId, C.licType, -1, -1, -1, -1, -1, 'N/A', 'N/A', 'N/A', -1, C.csid, C.organizationId, C.organization, 3, C.planName
            FROM #tempSCLCALDetails C--CAL usage
            WHERE C.entityType=0--agents
            -- ----------------------usages from V2 tables
            --remove those rows which are not mapped to any billing group
            DELETE #tempDetails WHERE bgid<=0
            --**entityType=2-client Count rows for VMs; entityType=3-capacity usage rows for VMs
            --for VMs the capacity details and client count details are stored in separate rows. We have to remove those rows which are not same as the of the counting type of Billing SKU
            --1) billing SKU counts capacity. Hence remove client count rows
            DELETE FROM #tempDetails
            WHERE entityType=2 AND countingType=1
            --2) billing SKU counts clients. Hence remove capacity rows
            DELETE FROM #tempDetails
            WHERE entityType=3 AND countingType=0
            --older SKUs are mapped to retired licType 100011(Virtual Machines). They should be remapped to the new licType=100029(Protected Virtual Machines)
            UPDATE #tempDetails SET licType=@ProtectedVMLicType WHERE licType=@VirtualMachineLicType
            INSERT #tempDetailsTableV3
            SELECT (@i_Month-1), T.bgid, T.countingType, T.jobType, T.jobId, T.licType, ISNULL(T.clientId,-1), T.appTypeId, T.appId, T.spId,
            CASE WHEN T.jobId=-1 THEN -1 ELSE T.appSizeMB END, ISNULL(T.vmClientId,-1), -1, 'N/A', 'N/A', 'N/A', -1, T.csid, ISNULL(T.organizationId,-1), ISNULL(T.organization,@spName), 2, 'N/A'
            FROM #tempDetails T
        END
    END
    ELSE IF @i_InvokedFrom=3--display details when invoked from SP14 custom reports
    BEGIN
        --  ResultSet #9, #19, #29
        IF object_id('tempdb.dbo.#tempDetailsV4') IS NOT NULL
        BEGIN
            -- ----------------------usages from V3 tables
            DELETE #tempSCLUsageDetails WHERE bgid<=0
            DELETE #tempSCLCALDetails WHERE bgid<=0
            INSERT #tempDetailsV4
            --Capacity details of licenses other than on VMs
            SELECT DISTINCT (@i_Month-1), bgId, 1, 3, C.csid, C.ClientId, 'N/A', C.appId, 'N/A', C.appTypeId, C.licType, -1, 'N/A', -1, 'N/A', C.SPId, 'N/A', C.jobId, C.nJobType, C.appSizeMB, 'N/A', -1, C.organization, C.organizationId, C.planName, 'N/A', 'N/A', 'N/A', '', '', 'N/A', 'N/A', 'N/A', NULL, NULL, NULL, NULL, NULL
            FROM #tempSCLUsageDetails C--Capacity usage
            WHERE C.entityType=1--licenses
            AND C.licType NOT IN (@VMWithAppLicType,@VMOnlyLicType,@ProtectedVMLicType,@VirtualMachineLicType)
            UNION
            --Capacity details of licenses on VMs
            SELECT DISTINCT (@i_Month-1), bgId, 1, 3, C.csid, -1, 'N/A', -1, 'N/A', -1, C.licType, -1, 'N/A', -1, 'N/A', -1, 'N/A', C.jobId, -1, C.appSizeMB, 'N/A', C.clientId, C.organization, C.organizationId, C.planName, 'N/A', 'N/A', 'N/A', '', '', 'N/A', 'N/A', 'N/A', NULL, NULL, NULL, NULL, NULL
            FROM #tempSCLUsageDetails C--Capacity usage
            WHERE C.entityType=1--licenses
            AND C.licType IN (@VMWithAppLicType,@VMOnlyLicType,@ProtectedVMLicType,@VirtualMachineLicType)
            UNION
            --CAL details of FSO, DLO, AppServer backups and DPE, DAE, DPS, DPR
            SELECT DISTINCT (@i_Month-1), bgId, 0, 3, C.csid, C.ObjectId, 'N/A', -1, 'N/A', -1, C.licType, -1, 'N/A', -1, 'N/A', -1, 'N/A', -1, -1, -1, 'N/A', -1, C.organization, C.organizationId, C.planName, 'N/A', 'N/A', 'N/A', '', '', 'N/A', 'N/A', 'N/A', NULL, NULL, NULL, NULL, NULL
            FROM #tempSCLCALDetails C--CAL usage
            WHERE C.entityType=1--licenses
            AND licType IN (@FSOnlyServerLicType,@DLOnlyLicType,@APPServerLicType,@DPELicType,@DAELicType,@DPSLicType,@DPRLicType)
            UNION
            --CAL details of VMs
            SELECT DISTINCT (@i_Month-1), bgId, 0, 3, C.csid, -1, 'N/A', -1, 'N/A', -1, C.licType, -1, 'N/A', -1, 'N/A', -1, 'N/A', -1, -1, -1, 'N/A', C.ObjectId, C.organization, C.organizationId, C.planName, 'N/A', 'N/A', 'N/A', '', '', 'N/A', 'N/A', 'N/A', NULL, NULL, NULL, NULL, NULL
            FROM #tempSCLCALDetails C--CAL usage
            WHERE C.entityType=1--licenses
            AND licType IN (@VMWithAppLicType,@VMOnlyLicType,@ProtectedVMLicType,@VirtualMachineLicType)
            UNION
            --CAL details of eSim
            SELECT DISTINCT (@i_Month-1), bgId, 0, 3, C.csid, -1, 'N/A', -1, 'N/A', -1, C.licType, -1, 'N/A', -1, 'N/A', -1, 'N/A', -1, -1, -1, C.objectName, C.ObjectId, C.organization, C.organizationId, C.planName, 'N/A', 'N/A', 'N/A', '', '', 'N/A', 'N/A', 'N/A', NULL, NULL, NULL, NULL, NULL
            FROM #tempSCLCALDetails C--CAL usage
            WHERE C.entityType=1--licenses
            AND licType IN (@epUsers,@sharingUsers,@eDiscoveryUsers)
            UNION
            --CAL details of mSim
            SELECT DISTINCT (@i_Month-1), bgId, 0, 3, C.csid, -1, 'N/A', -1, 'N/A', -1, C.licType, -1, 'N/A', -1, 'N/A', -1, 'N/A', -1, -1, -1, C.objectName, -1, C.organization, C.organizationId, C.planName, 'N/A', 'N/A', 'N/A', '', '', 'N/A', 'N/A', 'N/A', NULL, NULL, NULL, NULL, NULL
            FROM #tempSCLCALDetails C--CAL usage
            WHERE C.entityType=1--licenses
            AND licType IN (@mSimUsers)
            UNION
            --CAL details of vmSockets
            SELECT DISTINCT (@i_Month-1), bgId, 0, 3, C.csid, -1, 'N/A', -1, 'N/A', -1, C.licType, -1, 'N/A', -1, 'N/A', -1, 'N/A', -1, -1, C.ObjectId, C.objectName, -1, C.organization, C.organizationId, C.planName, 'N/A', 'N/A', 'N/A', '', '', 'N/A', 'N/A', 'N/A', NULL, NULL, NULL, NULL, NULL
            FROM #tempSCLCALDetails C--CAL usage
            WHERE C.entityType=1--licenses
            AND licType IN (@VMSocketsLicType)
            UNION
            --CAL details of traditional licenses
            SELECT DISTINCT (@i_Month-1), bgId, 0, 3, C.csid, C.ObjectId, 'N/A', -1, 'N/A', -1, C.licType, -1, 'N/A', -1, 'N/A', -1, 'N/A', -1, -1, -1, 'N/A', -1, C.organization, C.organizationId, C.planName, 'N/A', 'N/A', 'N/A', '', '', 'N/A', 'N/A', 'N/A', NULL, NULL, NULL, NULL, NULL
            FROM #tempSCLCALDetails C--CAL usage
            WHERE C.entityType=1--licenses
            AND licType < 1000
            UNION
            --Capacity details of agents
            SELECT DISTINCT (@i_Month-1), bgId, 1, 3, C.csid, C.ClientId, 'N/A', C.appId, 'N/A', C.appTypeId, C.licType, -1, 'N/A', -1, 'N/A', C.SPId, 'N/A', C.jobId, C.nJobType, C.appSizeMB, 'N/A', -1, C.organization, C.organizationId, C.planName, 'N/A', 'N/A', 'N/A', '', '', 'N/A', 'N/A', 'N/A', NULL, NULL, NULL, NULL, NULL
            FROM #tempSCLUsageDetails C--Capacity usage
            WHERE C.entityType=0--agents
            UNION
            --CAL details of Agents
            SELECT DISTINCT (@i_Month-1), bgId, 0, 3, C.csid, C.ObjectId, 'N/A', -1, 'N/A', -1, C.licType, -1, 'N/A', -1, 'N/A', -1, 'N/A', -1, -1, -1, 'N/A', -1, C.organization, C.organizationId, C.planName, 'N/A', 'N/A', 'N/A', '', '', 'N/A', 'N/A', 'N/A', NULL, NULL, NULL, NULL, NULL
            FROM #tempSCLCALDetails C--CAL usage
            WHERE C.entityType=0--agents
            ---- ----------------------usages from V2 tables
            --remove those rows which are not mapped to any billing group
            DELETE #tempDetails WHERE bgid<=0
            --**entityType=2-client Count rows for VMs; entityType=3-capacity usage rows for VMs
            --for VMs the capacity details and client count details are stored in separate rows. We have to remove those rows which are not same as the of the counting type of Billing SKU
            --1) billing SKU counts capacity. Hence remove client count rows
            DELETE FROM #tempDetails
            WHERE entityType=2 AND countingType=1
            --2) billing SKU counts clients. Hence remove capacity rows
            DELETE FROM #tempDetails
            WHERE entityType=3 AND countingType=0
            --older SKUs are mapped to retired licType 100011(Virtual Machines). They should be remapped to the new licType=100029(Protected Virtual Machines)
            UPDATE #tempDetails SET licType=@ProtectedVMLicType WHERE licType=@VirtualMachineLicType
            INSERT #tempDetailsV4
            SELECT DISTINCT (@i_Month-1), bgId, T.countingType, 2, T.csid, ISNULL(T.clientId,-1), 'N/A', T.appId, 'N/A', T.appTypeId, T.licType, -1, 'N/A', -1, 'N/A', T.SPId, 'N/A',
            T.jobId, T.jobType, CASE WHEN T.jobId=-1 THEN -1 ELSE T.appSizeMB END, 'N/A', ISNULL(T.vmClientId,-1), ISNULL(T.organization,@spName), ISNULL(T.organizationId,-1), 'N/A', 'N/A', 'N/A', 'N/A', '', '', 'N/A', 'N/A', 'N/A', NULL, NULL, NULL, NULL, NULL
            FROM #tempDetails T
            --add name-id mappings for client, vm, subclient and storage policy to usages collected from V2 & V3 tables
            UPDATE T SET T.ClientName=ISNULL(ISNULL(CL.ClientDisplayName, CL.ClientName),'N/A'), T.SubclientName=ISNULL(SCL.SubclientName, 'N/A'), T.SPName=ISNULL(SP.PolicyName, 'N/A')
            FROM #tempDetailsV4 T
            LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=T.ClientId AND CL.CommServUniqueId=T.csid
            LEFT JOIN cf_SurveySubclientAssociation SCL WITH (NOLOCK) ON SCL.AppId=T.SubclientId AND SCL.ClientId=T.ClientId AND SCL.CommServUniqueId=T.csid
            LEFT JOIN (SELECT DISTINCT CommServUniqueId,PolicyId,PolicyName FROM cf_SurveyCopyBasicRetention WITH (NOLOCK))SP ON SP.PolicyId=T.spId AND SP.CommServUniqueId=T.csid
            UPDATE T SET T.ObjectName=ISNULL(ISNULL(VMCL.ClientDisplayName, VMCL.ClientName),'N/A')
            FROM #tempDetailsV4 T
            LEFT JOIN cf_SurveyClient VMCL WITH (NOLOCK) ON VMCL.ClientId=T.ObjectId AND VMCL.CommServUniqueId=T.csid
            WHERE T.licType IN (@VMWithAppLicType,@VMOnlyLicType,@ProtectedVMLicType,@VirtualMachineLicType)
            -- ----------------------usages from V4 tables
            INSERT #tempDetailsV4
            SELECT DISTINCT (@i_Month-1), bgId, countingType, 4, csid, ClientId, ClientName, SubclientId, SubclientName, AppTypeId, LicType, BackupSetId, BackupSetName, InstanceId, InstanceName, SPId, SPName,
            JobId, JobType, AppSizeMB, ObjectName, ObjectId, Organization, OrgGUID, PlanName, 'N/A', 'N/A', 'N/A', '', '', 'N/A', 'N/A', 'N/A', NULL, NULL, NULL, NULL, BasePlanName
            FROM #tempBillingDetails WHERE bgid>0
        END
    END
    ELSE--following resultsets should be inserted into temp tables when when this stored procedure is invoked from billing history custom report
    BEGIN
        -- --------------------------RESULTSET FOR SUMMARY TABLE--------------------------------------------------
        IF object_id('tempdb.dbo.#SKUTotals') IS NOT NULL
        BEGIN
            IF @contractType=0
            BEGIN
                --  summary of capacity usage & cost
                INSERT #SKUTotals
                SELECT @i_GroupId,ISNULL(BillingGroupName,'Total') AS 'SKU',1,SUM(UsagePerTier) AS 'Utility Usage (TB)',SUM(CostPerTier) AS 'Total Cost',@i_Month
                FROM #tempBilling
                WHERE CountingType=1
                GROUP BY
                    GROUPING SETS((BillingGroupName,Description,BaseLine,ActualUsage),())
                --  summary of client count usage & cost
                INSERT #SKUTotals
                SELECT @i_GroupId,ISNULL(BillingGroupName,'Total') AS 'SKU',0,SUM(UsagePerTier) AS 'Utility Usage',SUM(CostPerTier) AS 'Total Cost',@i_Month
                FROM #tempBilling
                WHERE CountingType=0
                GROUP BY
                    GROUPING SETS((BillingGroupName,Description,BaseLine,ActualUsage),())
            END
            ELSE
            BEGIN
                DELETE #tempTenantUsage--delete existing entries, if any
                INSERT #tempTenantUsage
                SELECT tenantId,'',BillingGroupName,1,ActualUsage,BaseLine,SUM(UsagePerTier),0,SUM(CostPerTier)
                FROM #tempBilling
                WHERE CountingType=1
                GROUP BY tenantId,BillingGroupName,Description,BaseLine,ActualUsage
                INSERT #tempTenantUsage
                SELECT tenantId,'',BillingGroupName,0,ActualUsage,BaseLine,SUM(UsagePerTier),0,SUM(CostPerTier)
                FROM #tempBilling
                WHERE CountingType=0
                GROUP BY tenantId,BillingGroupName,Description,BaseLine,ActualUsage
                --  display summary of capacity usage & cost
                INSERT #SKUTotals
                SELECT @i_GroupId,ISNULL(bgName,'Total') AS 'SKU',1,SUM(utilityUsage) AS 'Utility Usage (TB)',SUM(totalCost) AS 'Total Cost',@i_Month
                FROM #tempTenantUsage
                WHERE countingType=1
                GROUP BY
                    GROUPING SETS((bgName),())
                --  display summary of client count usage & cost
                INSERT #SKUTotals
                SELECT @i_GroupId,ISNULL(bgName,'Total') AS 'SKU',0,SUM(utilityUsage) AS 'Utility Usage',SUM(totalCost) AS 'Total Cost',@i_Month
                FROM #tempTenantUsage
                WHERE countingType=0
                GROUP BY
                    GROUPING SETS((bgName),())
            END
        END
        -- --------------------------RESULTSET FOR BILL HEADER--------------------------------------------------
        --  display the total cost to be paid by customer
        IF object_id('tempdb.dbo.#BillTotals') IS NOT NULL
        BEGIN
            INSERT #BillTotals
            SELECT @i_GroupId, SUM(CostPerTier), @i_Month FROM #tempBilling
        END
    END
        -- ----------------------------------------------------------------------------
        SET @monthCount = @monthCount - 1 -- decrementing while loop counter
        SELECT @i_Month=DATEADD(MONTH,-1,@i_Month) -- getting previous month for quarter billing
        END
    IF @i_InvokedFrom=0--output these resultsets only when this stored procedure is invoked from billing portal
    BEGIN
        ---- --------------------------FINAL RESULTSET --------------------------------------------------
        --  ResultSet #10 (for Monthly bill) or #30 (for Quarterly bill)
        SELECT @totalAmountDue AS 'Amount Due', @baseCurrency AS 'Currency', @useAsPO AS 'Use As PO'
    END
    END TRY
	BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
		SET @retValue=ERROR_NUMBER()
		SET @errMsg=ERROR_MESSAGE()
	END CATCH
-- ----------------------------------------------------------------------------
--   CLEAN UP
-- ----------------------------------------------------------------------------
-- drop all the temp tables created
IF object_id('tempdb.dbo.#tempAgents') IS NOT null DROP TABLE #tempAgents
IF object_id('tempdb.dbo.#tempSkuLicenses') IS NOT null DROP TABLE #tempSkuLicenses
IF object_id('tempdb.dbo.#tempLicenses') IS NOT null DROP TABLE #tempLicenses
IF object_id('tempdb.dbo.#tempUsage') IS NOT null DROP TABLE #tempUsage
IF object_id('tempdb.dbo.#tempBilling') IS NOT null DROP TABLE #tempBilling
IF object_id('tempdb.dbo.#tempDetails') IS NOT null DROP TABLE #tempDetails
IF object_id('tempdb.dbo.#tempTenantUsage') IS NOT null DROP TABLE #tempTenantUsage
IF object_id('tempdb.dbo.#tempSCLUsageDetails') IS NOT null DROP TABLE #tempSCLUsageDetails
IF object_id('tempdb.dbo.#tempSCLCALDetails') IS NOT null DROP TABLE #tempSCLCALDetails
IF object_id('tempdb.dbo.#tempUsageDetails') IS NOT null DROP TABLE #tempUsageDetails
IF object_id('tempdb.dbo.#tempCALDetails') IS NOT null DROP TABLE #tempCALDetails
IF object_id('tempdb.dbo.#tempPeakUsage') IS NOT null DROP TABLE #tempPeakUsage
IF object_id('tempdb.dbo.#tempBillingDetails') IS NOT null DROP TABLE #tempBillingDetails
IF object_id('tempdb.dbo.#appClientsUnderFSO_Backup') IS NOT null DROP TABLE #appClientsUnderFSO_Backup
IF object_id('tempdb.dbo.#tblAgents') IS NOT null DROP TABLE #tblAgents
IF object_id('tempdb.dbo.#tblLicenses') IS NOT null DROP TABLE #tblLicenses
IF object_id('tempdb.dbo.#tblSkuLicenses') IS NOT null DROP TABLE #tblSkuLicenses
IF object_id('tempdb.dbo.#appJobs') IS NOT null DROP TABLE #appJobs
IF object_id('tempdb.dbo.#latestTenantDetails') IS NOT null DROP TABLE #latestTenantDetails
IF object_id('tempdb.dbo.#licMapTbl') IS NOT null DROP TABLE #licMapTbl
IF object_id('tempdb.dbo.#agMapTbl') IS NOT null DROP TABLE #agMapTbl
IF object_id('tempdb.dbo.#bgMapTbl') IS NOT null DROP TABLE #bgMapTbl
IF object_id('tempdb.dbo.#CIObjectTenantTable') IS NOT null DROP TABLE #CIObjectTenantTable
IF object_id('tempdb.dbo.#tempRegularLicDetails') IS NOT null DROP TABLE #tempRegularLicDetails
IF object_id('tempdb.dbo.#tempNewVMLicTypes') IS NOT null DROP TABLE #tempNewVMLicTypes
IF object_id('tempdb.dbo.#AppUsers') IS NOT null DROP TABLE #AppUsers
IF @retValue <> 0
BEGIN
	ROLLBACK TRANSACTION
	SELECT @retValue AS errorCode, @errMsg AS errorMessage
END
ELSE
	COMMIT TRANSACTION
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CM_GenerateInvoice')
	delete from GxQscripts where name = 'CM_GenerateInvoice'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CM_GenerateInvoice')
	delete from GXDBVersions where aliasname = 'CM_GenerateInvoice'
GO

insert into GXDBVersions values(2, 'CM_GenerateInvoice',  '00010001000200490000', 'CM_GenerateInvoice', '00010001000200490000')
GO

