

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CMPopulateReferencesByDefinition.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CMPopulateReferencesByDefinition.sp,v $ $Id: CMPopulateReferencesByDefinition.sp,v 1.1.2.18.8.1 2021/01/15 22:33:40 ssivananthan Exp $";
--
--  +========================================================================+
--  |   Procedure:  CMPopulateReferencesByDefinition
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CMPopulateReferencesByDefinition')
BEGIN
	print '>>> Drop Stored Procedure: CMPopulateReferencesByDefinition <<<'
	drop procedure CMPopulateReferencesByDefinition
END
IF EXISTS (select * from GxQscripts where name='CMPopulateReferencesByDefinition')
	delete from GxQscripts where name = 'CMPopulateReferencesByDefinition'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CMPopulateReferencesByDefinition')
	delete from GXDBVersions where aliasname = 'CMPopulateReferencesByDefinition'
GO
print '... Creating Procedure: CMPopulateReferencesByDefinition'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CMPopulateReferencesByDefinition
  @inDefId INT
AS
  DECLARE @errorCode INTEGER
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
BEGIN TRY
SET @errorCode = 0
DECLARE @ownerId			INT = 0
DECLARE @cloudId 			INT = 0
DECLARE @entityStatus 		INT = 0
DECLARE @defXml				XML
DECLARE @PermissionList		varchar(100)
DECLARE @CaseId				INT
DECLARE @specialFlag			INT = 0 -- 1: Add to case with search Criteria only.
  SET @defXml = (select defXml from CMDefinition where id = @inDefId)
  SET @ownerId = ISNULL((SELECT ref.value('@ownerId', 'INTEGER')FROM @defXml.nodes('Ida_CMDefinitionReq/cmDef') R(ref)),0)
  SET @specialFlag = ISNULL((SELECT ref.value('@specialFlag', 'INTEGER')FROM @defXml.nodes('Ida_CMDefinitionReq/cmDef') R(ref)),0)
SET @cloudId = ISNULL((SELECT ref.value('@cloudID', 'INTEGER')FROM @defXml.nodes('Ida_CMDefinitionReq/cmDef/defXml/searchReq/listOfCIServer') R(ref)),0)
  IF @cloudId > 0 	SET @entityStatus  = 1
	SET @CaseId = (select clientId from CMDefinition  (NOLOCK) where id = @inDefId	)
SELECT @PermissionList = '25'
--Security
	DECLARE @isCommcellLevelAssociation INT = 0
	IF OBJECT_ID('tempdb.dbo.#tempSubclientSecurityObjects') IS NOT Null DROP TABLE #tempSubclientSecurityObjects
CREATE TABLE #tempSubclientSecurityObjects ( [clientId] INT, [appTypeId] INT DEFAULT 0, [instanceId] INT DEFAULT 0, [backupsetId] INT DEFAULT 0,  [subclientId ] INT DEFAULT 0 )
EXEC sec_getIdaObjectsForUser @ownerId, 7, @PermissionList, 0, '#tempSubclientSecurityObjects'
--	SELECT @isCommcellLevelAssociation=1 from #tempSubclientSecurityObjects sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
-----------------------------------------------------------------------------------------
--		for all defids, get list of custodians and their destAppIds
-----------------------------------------------------------------------------------------
	-- get dest Appids
	DECLARE @holds table(id int, holdType int, subclientId int)
	insert into @holds
	select
		xt.id,
		x.m.value( '@holdType[1]', 'integer' ),
		x.m.value( '@subclientId[1]', 'integer' )
	from
		CMDefinition xt
		cross apply xt.defxml.nodes( '/Ida_CMDefinitionReq/cmDef/defXml/holdInfo' ) x(m)
		where xt.id = @inDefId
	--Filter Case Manager & GDPR clients
	DECLARE @EDiscoveryClients Table (clientId int)
	Insert into @EDiscoveryClients(clientId)
    SELECT distinct c.id from [dbo].[APP_Client] c
	INNER JOIN APP_ClientProp cp ON cp.componentNameId= c.id AND cp.attrName = N'EDiscovery Subtype' AND cp.attrVal in (N'1',N'2') and cp.modified = 0
	IF OBJECT_ID('tempdb.dbo.#tempReference') IS NOT Null DROP TABLE #tempReference
    CREATE TABLE #tempReference(defId int, destAppid int, srcAppid int, refTime int, refJobId int, commcellId int, modified int, status int, entityId int, entityStatus int)
	IF  EXISTS (SELECT 1 from @holds where holdType IN (4, 5)) AND @specialFlag = 1
	BEGIN
		INSERT INTO #tempReference
		SELECT DISTINCT H.id, H.subclientId, 0, 0, 0, 2, 0, 0, 0, 0
		FROM @holds H
	GOTO END_HERE
	END
---------------------------------------------------------------------------------
	--File System : File Servers
---------------------------------------------------------------------------------
--For File Servers
IF  EXISTS (SELECT 1 from @holds where holdType = 4)
BEGIN
	DECLARE @GenericEntity TABLE
	(
		id_auto int IDENTITY(1,1),
		entityType integer,
		commcellId integer ,
		clientId integer ,
		clientgroupId integer
	)
    -- get associated clients\clientgroups
    INSERT INTO @GenericEntity
    SELECT
    ISNULL(Tbl.Col.value('@entityType', 'int'),0) ,
    ISNULL(Tbl.Col.value('@commCellId', 'int'),2) ,
    ISNULL(Tbl.Col.value('@clientId', 'int'),0),
    ISNULL(Tbl.Col.value('@clientGroupId', 'int'),0)
    FROM @defXml.nodes('/Ida_CMDefinitionReq/cmDef/defXml/associations') as Tbl(Col)
	-- Expand client groups into clients
	DECLARE @FSclientList TABLE (id INT)
	INSERT INTO @FSclientList
SELECT clientId FROM @GenericEntity where entityType = 3 --3
	INSERT INTO @FSclientList
	SELECT CG.clientId
	FROM APP_ClientGroupAssoc (NOLOCK) CG
INNER JOIN   (SELECT clientgroupid FROM @GenericEntity WHERE entityType = 28 /*28*/) AS ET
	ON CG.clientGroupId = ET.clientgroupId
	-- retrieve source subclients
	DECLARE @FSsubclientList TABLE (src INT, appTypeId INT)
	INSERT INTO @FSsubclientList
	SELECT A.id ,
	CASE WHEN A.appTypeId = 33 THEN A.appTypeId --- If it's windows type then map it to windows, everything else (mac etc.,) to unix
   	ELSE 29
	END
	FROM APP_Application (NOLOCK) A
	JOIN @FSclientList F ON F.id = A.clientId
	WHERE dbo.isFileSystemAppType(A.appTypeId) = 1 							  -- Finding all the file system app types
	      -- A.appTypeId in (33, 29)
		  AND dbo.IsSubClientValid(A.appTypeId, A.subclientStatus, 0) = 1     -- subclient is valid
		  AND (A.subclientStatus & 536) != 536                                -- not an indexing subclient
		  AND (A.subclientStatus & (16|32)) = 0                               -- do not backup flags are no set
		  AND (A.subclientStatus & (2|4)) = 0                                 -- subclient is not deleted
	-- map source subclients to dest subclients
	Insert into #tempReference
	SELECT DISTINCT @inDefId, A.id , F.src , 0, 0, 2, 0, 0, 0, 0
	FROM App_Application (NOLOCK) A
	JOIN @FSsubclientList F ON F.appTypeId = A.appTypeId
	WHERE A.clientId = @CaseId
		  AND dbo.IsSubClientValid(A.appTypeId, A.subclientStatus, 0) = 1     -- subclient is valid
		  AND (A.subclientStatus & 536) != 536                                -- not an indexing subclient
		  AND (A.subclientStatus & (16|32)) = 0                               -- do not backup flags are no set
		  AND (A.subclientStatus & (2|4)) = 0                                 -- subclient is not deleted
END
--LapTops
IF  EXISTS (SELECT 1 from @holds where holdType = 5)
BEGIN
	--Get the list of laptop Users from Definition
	IF OBJECT_ID('tempdb.dbo.#defUsers') IS NOT Null DROP TABLE #defUsers
	CREATE TABLE #defUsers (id int, uGuid nvarchar(40), uSmtp nvarchar(max), isGroup int, uName nvarchar(max))
	INSERT INTO #defUsers
	SELECT distinct @inDefId, req.value('@guid','nvarchar(40)'), req.value('@smtp','nvarchar(max)'), req.value('@isGuid','INT'), req.value('@name','nvarchar(max)')
    FROM @defXml.nodes('/Ida_CMDefinitionReq/cmDef/defXml/custodianInfo') AS T(req)
	--Expand userGroups into users
	INSERT INTO #defUsers
	SELECT GrpUsers.id, GrpUsers.userGuid, GrpUsers.email, 0, GrpUsers.login
	FROM
	(
		--internal groups
		SELECT UMUsers.id, UMUsers.userGuid, UMUsers.email, UMUsers.login FROM   UMUserGroup WITH(NOLOCK)
		INNER JOIN #defUsers D ON UMUserGroup.groupid = D.id
		INNER JOIN UMUsers WITH(NOLOCK) ON UMUserGroup.userid = UMUsers.id
		WHERE D.isGroup = 1 AND UMUserGroup.groupid = D.id
		UNION
		--external groups
		SELECT UMUsers.id,  UMUsers.userGuid, UMUsers.email, UMUsers.login FROM UMDSGroupMaps WITH(NOLOCK)
		INNER JOIN UMUserGroup WITH(NOLOCK) ON UMDSGroupMaps.umDSgroupId = UMUserGroup.groupId
		INNER JOIN #defUsers D ON UMUserGroup.groupId = D.id
		INNER JOIN UMUsers WITH(NOLOCK) ON UMUsers.id = UMUserGroup.userId
		WHERE D.isGroup = 1 AND UMDSGroupMaps.umgroupid = D.id
	) AS GrpUsers
	WHERE GrpUsers.id NOT IN (select id from #defUsers)
	--Get the list of Laptops for the given users --
	DECLARE @laptopClients TABLE (clientId INT)
	INSERT INTO @laptopClients
	EXEC dbo.CMGetLaptopClients @inDefId, 0, 0
	--get all source appIds
	DECLARE @lapTopSubClients TABLE (srcAppId INT, appType INT)
	INSERT INTO @lapTopSubClients
	SELECT A.id,
	CASE WHEN A.appTypeId = 33 THEN A.appTypeId --- If it's windows type then map it to windows, everything else (mac etc.,) to unix
   		 ELSE 29
	END
	FROM APP_Application (NOLOCK) A
	WHERE A.clientId IN (SELECT clientid from @laptopClients)
	      AND dbo.isFileSystemAppType(A.appTypeId) = 1                        -- If it's a valid filesystem subclient
		  AND dbo.IsSubClientValid(A.appTypeId, A.subclientStatus, 0) = 1     -- subclient is valid
		  AND (A.subclientStatus & 536) != 536                                -- not an indexing subclient
		  AND (A.subclientStatus & (16|32)) = 0                               -- do not backup flags are no set
		  AND (A.subclientStatus & (2|4)) = 0                                 -- subclient is not deleted
	--Map each Src AppId with dest appid.
	Insert into #tempReference
	SELECT DISTINCT @inDefId, A.id , F.srcAppId , 0, 0, 2, 0, 0,0,0
	FROM App_Application (NOLOCK) A
	JOIN @lapTopSubClients F ON F.appType = A.appTypeId
	WHERE A.clientId = @CaseId
		  AND dbo.IsSubClientValid(A.appTypeId, A.subclientStatus, 0) = 1     -- subclient is valid
		  AND (A.subclientStatus & 536) != 536                                -- not an indexing subclient
		  AND (A.subclientStatus & (16|32)) = 0                               -- do not backup flags are no set
		  AND (A.subclientStatus & (2|4)) = 0                                 -- subclient is not deleted
END
-----------------------------------------------------------------------------------------
-- for each custodian get source appids from email policy assoc table
-----------------------------------------------------------------------------------------
IF EXISTS (SELECT 1 FROM @holds where holdType in (1, 2, 3))
BEGIN
-- Map custodians to their destAppids
DECLARE @tempCustodian Table (caseId int, defId int, smtp NVARCHAR(255),  userguid nvarchar(40),  holdType int, destAppId int)
	Insert into @tempCustodian
	select distinct D.clientId, C.definitionid, C.smtp, C.userGuid, C.holdType, H.subclientId
	from CMCustodian C
	join CMDefinition D ON D.id = C.definitionid
	join @holds H ON H.id = C.definitionId and  H.holdType = C.holdType
	where D.Id = @inDefId AND C.modified = 0
	IF EXISTS (SELECT 1 FROM @tempCustodian)
		BEGIN
		Insert into #tempReference
		SELECT DISTINCT TC.defId, TC.destAppId, E.subclientId, 0, 0, 2, 0, 0,0,0
		FROM @tempCustodian TC
		JOIN APP_EmailConfigPolicyAssoc E ON  E.smtpAdrress = TC.smtp OR (TC.userGuid <> NULL AND E.userGuid = TC.userguid)
		JOIN APP_BackupsetProp B ON B.attrName = 'Exchange OnePass Backupset Type' AND CAST(TC.holdType AS NVARCHAR(12)) = B.attrVal AND B.componentNameId = E.backupsetId
		WHERE TC.holdType = 1 AND E.clientId NOT IN (SELECT clientId from @EDiscoveryClients)
		AND E.subClientId in (select TOP 1 appid from JMBkpStats where appid = E.subClientId AND status in (1, 3, 14))
		AND  (@isCommcellLevelAssociation = 1  OR (E.subClientId IN (SELECT DISTINCT subclientId FROM #tempSubclientSecurityObjects)))
		Insert into #tempReference
		SELECT DISTINCT H.id, H.subclientId, S.componentNameId, 0, 0, 2, 0, 0, 0, 0
		FROM @holds H
		JOIN APP_SubClientProp S On S.cs_attrName = CHECKSUM(N'Exchange OnePass Subclient Type')  AND S.attrName = 'Exchange OnePass Subclient Type' AND CAST(H.holdType AS NVARCHAR(12)) = S.attrVal
		WHERE H.holdType IN (2, 3) AND S.componentNameId NOT IN (SELECT id from App_application where clientId IN (SELECT clientId from @EDiscoveryClients))
		AND S.componentNameId in (select TOP 1 appid from JMBkpStats where appid = S.componentNameId  AND status in (1, 3, 14))
		AND  (@isCommcellLevelAssociation = 1  OR (S.componentNameId IN (SELECT DISTINCT subclientId FROM #tempSubclientSecurityObjects)))
		END
	ELSE
		Insert into #tempReference
		SELECT DISTINCT H.id, H.subclientId, S.componentNameId, 0, 0, 2, 0, 0, @cloudId, @entityStatus
		FROM @holds H
		JOIN APP_SubClientProp S On CAST(H.holdType AS NVARCHAR(12)) = S.attrVal AND  S.cs_attrName = CHECKSUM(N'Exchange OnePass Subclient Type') AND S.attrName = 'Exchange OnePass Subclient Type'
		WHERE H.holdType IN (1, 2, 3) AND S.componentNameId NOT IN (SELECT id from App_application where clientId IN (SELECT clientId from @EDiscoveryClients))
		AND S.componentNameId in (select TOP 1 appid from JMBkpStats where appid = S.componentNameId  AND status in (1, 3, 14))
		AND  (@isCommcellLevelAssociation = 1  OR (S.componentNameId IN (SELECT DISTINCT subclientId FROM #tempSubclientSecurityObjects)))
	--Include Classic Compliance Archiver agent subclients
	Insert into #tempReference
	SELECT DISTINCT H.id, H.subclientId, A.id, 0, 0, 2, 0, 0,@cloudId, @entityStatus
	FROM @holds H
	JOIN APP_Application A WITH(NOLOCK) On A.apptypeId = 67
JOIN APP_Client C WITH(NOLOCK) ON A.clientId = C.id AND (C.status & 0x4000000) = 0
	WHERE H.holdType  = 2 AND A.clientId NOT IN ( SELECT clientId from @EDiscoveryClients)
	AND A.id = (select TOP 1 appid from JMBkpStats where appid = A.id  AND status in (1, 3, 14))
	AND  (@isCommcellLevelAssociation = 1  OR (A.id IN (SELECT DISTINCT subclientId FROM #tempSubclientSecurityObjects)))
END
END_HERE:
INSERT INTO CMReference
SELECT T.defId, T.destAppid, T.srcAppid, 0,0,2,0,0, T.entityId, T.entityStatus
FROM #tempReference T LEFT OUTER JOIN CMReference C
ON T.defId = C.definitionId AND T.destAppid = C.destAppId AND T.srcAppid = C.srcAppId
WHERE C.definitionId IS NULL
DROP TABLE #tempSubclientSecurityObjects
IF OBJECT_ID('tempdb.dbo.#tempReference') IS NOT Null DROP TABLE #tempReference
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
END CATCH;
	select @errorCode
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'CMPopulateReferencesByDefinition')
	delete from GxQscripts where name = 'CMPopulateReferencesByDefinition'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CMPopulateReferencesByDefinition')
	delete from GXDBVersions where aliasname = 'CMPopulateReferencesByDefinition'
GO

insert into GXDBVersions values(2, 'CMPopulateReferencesByDefinition',  'v1.1.2.18.8.1', 'CMPopulateReferencesByDefinition', 'v1.1.2.18.8.1')
GO

