

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CMPopulateReference.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CMPopulateReference.sp,v $ $Id: CMPopulateReference.sp,v 1.1.2.3 2018/10/23 03:10:02 nuppu Exp $";
--
--  +========================================================================+
--  |   Procedure:  CMPopulateReference
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CMPopulateReference')
BEGIN
	print '>>> Drop Stored Procedure: CMPopulateReference <<<'
	drop procedure CMPopulateReference
END
IF EXISTS (select * from GxQscripts where name='CMPopulateReference')
	delete from GxQscripts where name = 'CMPopulateReference'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CMPopulateReference')
	delete from GXDBVersions where aliasname = 'CMPopulateReference'
GO
print '... Creating Procedure: CMPopulateReference'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CMPopulateReference
  @inCaseId INT
AS
  DECLARE @errorCode INTEGER
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
BEGIN TRY
BEGIN TRAN
SET @errorCode = 0
-----------------------------------------------------------------------------------------
--		for all defids, get list of custodians and their destAppIds
-----------------------------------------------------------------------------------------
	-- get dest Appids
	DECLARE @holds table(id int, holdType int, subclientId int)
	insert into @holds
	select
		xt.id,
		x.m.value( '@holdType[1]', 'integer' ),
		x.m.value( '@subclientId[1]', 'integer' )
	from
		CMDefinition xt
		cross apply xt.defxml.nodes( '/Ida_CMDefinitionReq/cmDef/defXml/holdInfo' ) x(m)
		where xt.clientId = @inCaseId OR @inCaseId = 0
	-- Map custodians to their destAppids
DECLARE @tempCustodian Table (caseId int, defId int, smtp NVARCHAR(255), userguid nvarchar(40), holdType int, destAppId int)
	Insert into @tempCustodian
	select distinct D.clientId, C.definitionid, C.smtp, C.userGuid, C.holdType, H.subclientId
	from CMCustodian C
	join CMDefinition D ON D.id = C.definitionid
	join @holds H ON H.id = C.definitionId and  H.holdType = C.holdType
	where C.modified = 0 AND (D.clientId = @inCaseId OR @inCaseId = 0)
	--Filter Case Manager & GDPR clients
	DECLARE @EDiscoveryClients Table (clientId int)
	Insert into @EDiscoveryClients(clientId)
    SELECT distinct c.id from [dbo].[APP_Client] c
	INNER JOIN APP_ClientProp cp ON cp.componentNameId=c.id AND cp.attrName = N'EDiscovery Subtype' AND cp.attrVal in (1,2)
-----------------------------------------------------------------------------------------
-- for each custodian get source appids from email policy assoc table
-----------------------------------------------------------------------------------------
	DECLARE @tempReference Table (defId int, destAppid int, srcAppid int, refTime int, refJobId int, commcellId int, modified int, status int)
IF EXISTS (SELECT 1 FROM @tempCustodian)
	BEGIN
	Insert into @tempReference
	SELECT DISTINCT TC.defId, TC.destAppId, E.subclientId, 0, 0, 2, 0, 0
	FROM @tempCustodian TC
	JOIN APP_EmailConfigPolicyAssoc E ON  E.smtpAdrress = TC.smtp  OR (TC.userGuid <> NULL AND E.userGuid = TC.userguid)
	JOIN APP_BackupsetProp B ON B.attrName = 'Exchange OnePass Backupset Type' AND B.attrVal = TC.holdType AND B.componentNameId = E.backupsetId
	WHERE TC.holdType = 1 AND E.clientId NOT IN (SELECT clientId from @EDiscoveryClients)
	AND E.subClientId in (select TOP 1 appid from JMBkpStats where appid = E.subClientId AND status in (1, 3, 14))
	Insert into @tempReference
	SELECT DISTINCT H.id, H.subclientId, S.componentNameId, 0, 0, 2, 0, 0
	FROM @holds H
	JOIN APP_SubClientProp S On S.attrName = 'Exchange OnePass Subclient Type' AND S.attrVal = H.holdType
	WHERE H.holdType IN (2, 3) AND S.componentNameId NOT IN (SELECT id from App_application where clientId IN (SELECT clientId from @EDiscoveryClients))
	AND S.componentNameId in (select TOP 1 appid from JMBkpStats where appid = S.componentNameId  AND status in (1, 3, 14))
	END
ELSE
	Insert into @tempReference
	SELECT DISTINCT H.id, H.subclientId, S.componentNameId, 0, 0, 2, 0, 0
	FROM @holds H
	JOIN APP_SubClientProp S On S.attrName = 'Exchange OnePass Subclient Type' AND S.attrVal = H.holdType
	WHERE H.holdType IN (1, 2, 3) AND S.componentNameId NOT IN (SELECT id from App_application where clientId IN (SELECT clientId from @EDiscoveryClients))
	AND S.componentNameId in (select TOP 1 appid from JMBkpStats where appid = S.componentNameId  AND status in (1, 3, 14))
INSERT INTO CMReference
SELECT T.defId, T.destAppid, T.srcAppid, 0,0,2,0,0
FROM @tempReference T LEFT OUTER JOIN CMReference C
ON T.defId = C.definitionId AND T.destAppid = C.destAppId AND T.srcAppid = C.srcAppId
WHERE C.definitionId IS NULL
	COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
	ROLLBACK TRANSACTION
END CATCH;
	select @errorCode
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'CMPopulateReference')
	delete from GxQscripts where name = 'CMPopulateReference'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CMPopulateReference')
	delete from GXDBVersions where aliasname = 'CMPopulateReference'
GO

insert into GXDBVersions values(2, 'CMPopulateReference',  '00010001000200030000', 'CMPopulateReference', '00010001000200030000')
GO

