

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CMPopulateCustodiansByDefinition.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CMPopulateCustodiansByDefinition.sp,v $ $Id: CMPopulateCustodiansByDefinition.sp,v 1.1.2.7 2020/09/19 13:59:05 kveerapandian Exp $";
--
--  +========================================================================+
--  |   Procedure:  CMPopulateCustodiansByDefinition
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CMPopulateCustodiansByDefinition')
BEGIN
	print '>>> Drop Stored Procedure: CMPopulateCustodiansByDefinition <<<'
	drop procedure CMPopulateCustodiansByDefinition
END
IF EXISTS (select * from GxQscripts where name='CMPopulateCustodiansByDefinition')
	delete from GxQscripts where name = 'CMPopulateCustodiansByDefinition'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CMPopulateCustodiansByDefinition')
	delete from GXDBVersions where aliasname = 'CMPopulateCustodiansByDefinition'
GO
print '... Creating Procedure: CMPopulateCustodiansByDefinition'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CMPopulateCustodiansByDefinition
  @inXML XML,
  @inDefId INT
AS
  DECLARE @errorCode INTEGER
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
BEGIN TRY
DECLARE @nowTime INT
SET     @nowTime    = dbo.GetUnixTime (GetUTCdate())
SET 	@errorCode = 0
DECLARE @users table(id int, uGuid nvarchar(40), uSmtp nvarchar(max), isGroup int, uName nvarchar(max))
	INSERT INTO @users (id , uGuid, uSmtp, isGroup, uName)
SELECT distinct @inDefId, req.value('@guid','nvarchar(40)'), req.value('@smtp','nvarchar(max)'), req.value('@isGuid','INT'), req.value('@name','nvarchar(max)')
    FROM @inXML.nodes('Ida_CMCustodians/custodians') AS T(req)
	--Populate user Guids here
	IF Exists (SELECT TOP 1 uSmtp from @users where id = @inDefId)
	UPDATE @users
	SET uGuid  = A.userGuid
	FROM APP_EmailConfigPolicyAssoc A (NOLOCK)
	WHERE A.smtpAdrress = uSmtp AND A.modified = 0  AND id = @inDefId
	DECLARE @holds table(id int, holdType int, subclientId int)
DECLARE @tempuserholds table(defId int, uGuid nvarchar(40), usmtp nvarchar(max), holdType int, modified INT, status int,  uName nvarchar(max))
	IF EXISTS (SELECT 1 FROM @users)
	BEGIN
		insert into @holds
		select
			xt.id,
			x.m.value( '@holdType[1]', 'integer' ),
			x.m.value( '@subclientId[1]', 'integer' )
		from
			CMDefinition xt
			cross apply xt.defxml.nodes( '/Ida_CMDefinitionReq/cmDef/defXml/holdInfo' ) x(m)
			where xt.Id = @inDefId
		insert into @tempuserholds
		select distinct u.id, u.uGuid, u.uSmtp, h.holdType, 0, 0, u.uName
		from @users u, @holds h
		where u.id = h.id
	END
	-- merge into Custodian table
	MERGE CMCustodian TARGET
	USING @tempuserholds SOURCE
	ON (TARGET.definitionId = SOURCE.defId AND (TARGET.smtp = SOURCE.usmtp  OR (SOURCE.uGuid <> NULL AND TARGET.userGuid = SOURCE.uGuid)) AND TARGET.holdType= SOURCE.holdType AND  TARGET.modified = SOURCE.modified)
	WHEN NOT MATCHED BY TARGET
	THEN INSERT (definitionId, userGuid, smtp, holdType, modified, status, name)
	VALUES (SOURCE.defId, SOURCE.uGuid, SOURCE.usmtp, SOURCE.holdType, 0, 0, SOURCE.uName)
	WHEN NOT MATCHED BY SOURCE AND Target.definitionId IN (select distinct defId from @tempuserholds )
	THEN UPDATE SET modified = @nowTime;
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
END CATCH;
	select @errorCode
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'CMPopulateCustodiansByDefinition')
	delete from GxQscripts where name = 'CMPopulateCustodiansByDefinition'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CMPopulateCustodiansByDefinition')
	delete from GXDBVersions where aliasname = 'CMPopulateCustodiansByDefinition'
GO

insert into GXDBVersions values(2, 'CMPopulateCustodiansByDefinition',  '00010001000200070000', 'CMPopulateCustodiansByDefinition', '00010001000200070000')
GO

