

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CMPopulateCustodian.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CMPopulateCustodian.sp,v $ $Id: CMPopulateCustodian.sp,v 1.1.2.5 2018/10/23 03:09:59 nuppu Exp $";
--
--  +========================================================================+
--  |   Procedure:  CMPopulateCustodian
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CMPopulateCustodian')
BEGIN
	print '>>> Drop Stored Procedure: CMPopulateCustodian <<<'
	drop procedure CMPopulateCustodian
END
IF EXISTS (select * from GxQscripts where name='CMPopulateCustodian')
	delete from GxQscripts where name = 'CMPopulateCustodian'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CMPopulateCustodian')
	delete from GXDBVersions where aliasname = 'CMPopulateCustodian'
GO
print '... Creating Procedure: CMPopulateCustodian'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CMPopulateCustodian
  @inCaseId INT
AS
  DECLARE @errorCode INTEGER
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
BEGIN TRY
DECLARE @nowTime INT
SET     @nowTime    = dbo.GetUnixTime (GetUTCdate())
SET 	@errorCode = 0
DECLARE @users table(id int, uGuid nvarchar(40), uSmtp nvarchar(max), isGroup int, uName nvarchar(max))
	insert into @users
	select
		xt.id,
x.m.value( '@guid[1]', 'nvarchar(40)' ),
		x.m.value( '@smtp[1]', 'nvarchar(max)' ),
		x.m.value( '@isGroup[1]', 'integer' ),
		x.m.value( '@name[1]', 'nvarchar(max)' )
	from
		CMDefinition xt
		cross apply xt.defxml.nodes( '/Ida_CMDefinitionReq/cmDef/defXml/custodianInfo' ) x(m)
		where xt.clientId = @inCaseId OR @inCaseId = 0
	DECLARE @holds table(id int, holdType int, subclientId int)
DECLARE @tempuserholds table(defId int, uGuid nvarchar(40), usmtp nvarchar(max), holdType int, modified INT, status int, uName nvarchar(max))
	IF EXISTS (SELECT 1 FROM @users)
	BEGIN
		insert into @holds
		select
			xt.id,
			x.m.value( '@holdType[1]', 'integer' ),
			x.m.value( '@subclientId[1]', 'integer' )
		from
			CMDefinition xt
			cross apply xt.defxml.nodes( '/Ida_CMDefinitionReq/cmDef/defXml/holdInfo' ) x(m)
			where xt.clientId = @inCaseId OR @inCaseId = 0
		insert into @tempuserholds
		select u.id, u.uGuid, u.uSmtp, h.holdType, 0, 0, u.uName
		from @users u, @holds h
		where u.id = h.id AND u.isGroup = 0
	END
		-- merge into Custodian table
		MERGE CMCustodian TARGET
		USING @tempuserholds SOURCE
		ON (TARGET.definitionId = SOURCE.defId AND (TARGET.smtp = SOURCE.usmtp  OR (SOURCE.uGuid <> NULL AND TARGET.userGuid = SOURCE.uGuid)) AND TARGET.holdType= SOURCE.holdType AND  TARGET.modified = SOURCE.modified)
		WHEN NOT MATCHED BY TARGET
		THEN INSERT (definitionId, userGuid, smtp, holdType, modified, status, name)
		VALUES (SOURCE.defId, SOURCE.uGuid, SOURCE.usmtp, SOURCE.holdType, 0, 0, SOURCE.uName)
		WHEN NOT MATCHED BY SOURCE AND Target.definitionId IN (select distinct defId from @tempuserholds )
		THEN UPDATE SET modified = @nowTime;
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
END CATCH;
	select @errorCode
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'CMPopulateCustodian')
	delete from GxQscripts where name = 'CMPopulateCustodian'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CMPopulateCustodian')
	delete from GXDBVersions where aliasname = 'CMPopulateCustodian'
GO

insert into GXDBVersions values(2, 'CMPopulateCustodian',  '00010001000200050000', 'CMPopulateCustodian', '00010001000200050000')
GO

