

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CMGetHoldDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CMGetHoldDetails.sp,v $ $Id: CMGetHoldDetails.sp,v 1.1.2.5 2020/11/03 01:30:18 ssivananthan Exp $";
--
--  +========================================================================+
--  |   Procedure:  CMGetHoldDetails
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:
--  |
--  |       Input:  clientId
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CMGetHoldDetails')
BEGIN
	print '>>> Drop Stored Procedure: CMGetHoldDetails <<<'
	drop procedure CMGetHoldDetails
END
IF EXISTS (select * from GxQscripts where name='CMGetHoldDetails')
	delete from GxQscripts where name = 'CMGetHoldDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CMGetHoldDetails')
	delete from GXDBVersions where aliasname = 'CMGetHoldDetails'
GO
print '... Creating Procedure: CMGetHoldDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CMGetHoldDetails
  @inCaseId INT,
  @outXml XML OUTPUT
AS
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET @outXml = N''
BEGIN TRY
DECLARE @caseDetails table (appName varchar(255),  backupsetId int, backupsetName varchar(255), subclientId int, appType int, holdType int )
	insert into @caseDetails
	select '', b.id, b.name, s.id, s.appTypeId, 0
	from APP_BackupSetName b, APP_Application s
	where s.backupSet = b.id  AND s.clientId = @inCaseId
	update @caseDetails
	set appName = (select name from APP_iDAType where type = appType),
holdType = CASE WHEN EXISTS (select attrval from APP_BackupSetProp WITH (NOLOCK) where componentNameId = backupsetId AND attrname = ('Case Manager Hold Type') ) THEN ISNULL((select attrval from APP_BackupSetProp WITH (NOLOCK) where componentNameId = backupsetId AND attrname = ('Case Manager Hold Type')),0)
					WHEN apptype = 137 THEN (select attrval from APP_BackupSetProp WITH (NOLOCK) where componentNameId = backupsetId AND attrname = 'Exchange OnePass Backupset Type' AND attrval IN (1, 2, 3))
					--handle old cases/if prop (Case Manager Hold Type) not exists
					WHEN (apptype = 33 or apptype = 29)  AND (EXISTS (select C.id from CMDefinition D WITH (NOLOCK) JOIN CMCustodian C WITH (NOLOCK) ON D.id = C.definitionId and D.clientId = @inCaseId)) THEN 5
					WHEN apptype = 33 THEN 4
					WHEN apptype = 29 THEN 4
					ELSE 0
					END
	set @outXml = (select holdType AS '@holdType',
						appName AS '@appName',
						backupsetName AS '@holdName',
						subclientId AS '@subclientId'
						from @caseDetails
						FOR XML PATH('holdInfo'), ROOT('Ida_CMCaseDetailsResp')
					)
	if @outXml IS NULL
             set @outXml = '<Ida_CMCaseDetailsResp />'
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @outXml = (SELECT @@ERROR AS '@result' FOR XML PATH('Ida_CMCaseDetailsResp'))
END CATCH;
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'CMGetHoldDetails')
	delete from GxQscripts where name = 'CMGetHoldDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CMGetHoldDetails')
	delete from GXDBVersions where aliasname = 'CMGetHoldDetails'
GO

insert into GXDBVersions values(2, 'CMGetHoldDetails',  '00010001000200050000', 'CMGetHoldDetails', '00010001000200050000')
GO

