

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CMDefinitionOperations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CMDefinitionOperations.sp,v $ $Id: CMDefinitionOperations.sp,v 1.1.2.9 2020/09/01 17:59:17 ssivananthan Exp $";
--
--  +========================================================================+
--  |   Procedure:  CMDefinitionOperations
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CMDefinitionOperations')
BEGIN
	print '>>> Drop Stored Procedure: CMDefinitionOperations <<<'
	drop procedure CMDefinitionOperations
END
IF EXISTS (select * from GxQscripts where name='CMDefinitionOperations')
	delete from GxQscripts where name = 'CMDefinitionOperations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CMDefinitionOperations')
	delete from GXDBVersions where aliasname = 'CMDefinitionOperations'
GO
print '... Creating Procedure: CMDefinitionOperations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CMDefinitionOperations
  @inXML XML,
  @outXml XML OUTPUT
AS
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
BEGIN TRY
DECLARE @inMode 	int
DECLARE @inDefId 	int
DECLARE @inDefName	NVARCHAR(255)
DECLARE @DefXml 	XML
DECLARE @inCaseId 	int
DECLARE @nowTime    int
SET     @nowTime    = dbo.GetUnixTime (GetUTCdate())
SET @inMode = ISNULL (( SELECT ref.value('@mode', 'INTEGER')FROM @inXML.nodes('Ida_CMDefinitionReq') R(ref)), 0)
SET @inDefName =  ISNULL((SELECT ref.value('@name', 'NVARCHAR(255)') FROM @inXML.nodes('Ida_CMDefinitionReq/cmDef') R(ref)), '')
SET @inCaseId = ISNULL((SELECT ref.value('@caseId', 'INTEGER')FROM @inXML.nodes('Ida_CMDefinitionReq/cmDef') R(ref)), 0)
    SET @outXml = N''
	-----------------------------------------------------------------------------------------------------------------------
												-- Create Definition --
	-----------------------------------------------------------------------------------------------------------------------
	IF @inMode = 1
	BEGIN
		BEGIN TRAN
		INSERT INTO CMDefinition
		SELECT @inDefName, @inCaseId, @inXML, 0
		set @outXml = (
						select @@IDENTITY AS '@id'
						FOR XML PATH('cmDef'), ROOT('Ida_CMDefinitionResp')
					)
		if @outXml IS NULL
             set @outXml = '<Ida_CMDefinitionResp />'
		COMMIT TRAN
	END
	-----------------------------------------------------------------------------------------------------------------------
												-- Update Definition --
	-----------------------------------------------------------------------------------------------------------------------
	ELSE IF @inMode = 2
	BEGIN
		SET @inDefId = ISNULL((SELECT ref.value('@id', 'INTEGER')FROM @inXML.nodes('Ida_CMDefinitionReq/cmDef') R(ref)),0)
		SET @DefXml = (select defXml from CMDefinition where id = @inDefId)
		BEGIN TRAN
			--Move the existing record into history table to keep history
			INSERT INTO CMDefinitionHistory
			SELECT d.id, d.name, d.clientId, d.defXml, @nowTime, 0
			FROM CMDefinition d where d.id = @inDefId
			-- update the record in actual table.
			UPDATE CMDefinition
			SET defXml = @inXML,
				name = @inDefName
			WHERE id = @inDefId
		 set @outXml = (
             select 0 AS '@result'
             FOR XML PATH('Ida_CMDefinitionResp'))
		COMMIT TRAN
	END
	-----------------------------------------------------------------------------------------------------------------------
												-- Delete Definition --
	-----------------------------------------------------------------------------------------------------------------------
	ELSE IF @inMode = 3
	BEGIN
		DECLARE @defIds TABLE ( id	int	)
		INSERT INTO @defIds SELECT ISNULL(Tbl.Col.value('@id', 'int'), 0) FROM @inXML.nodes('/Ida_CMDefinitionReq/cmDef') as Tbl(Col)
		BEGIN TRAN
		--Move the existing records into history table to keep history
		INSERT INTO CMDefinitionHistory
		SELECT d.id, d.name, d.clientId, d.defXml, @nowTime, 0
		FROM CMDefinition d where d.id IN (select id from @defIds)
		--delete from actual table
		DELETE CMDefinition	WHERE id IN (SELECT id from @defIds)
		set @outXml = (
             select 0 AS '@result'
             FOR XML PATH('Ida_CMDefinitionResp'))
		COMMIT TRAN
	END
	-----------------------------------------------------------------------------------------------------------------------
												-- Get Definitions --
	-----------------------------------------------------------------------------------------------------------------------
	IF (@inMode = 4) -- FETCH
	BEGIN
	SET @inDefId = ISNULL((SELECT ref.value('@id', 'INTEGER')FROM @inXML.nodes('Ida_CMDefinitionReq/cmDef') R(ref)),0)
		 set @outXml = (
						SELECT id AS '@id',
							name AS '@name',
							clientId As '@caseId',
							ISNULL((SELECT MIN(cmr.refTime) from CMReference cmr where cmr.definitionId = id and cmr.srcAppId != 0), 0)  AS '@processedTime',
							cmDefReq.cmDef.value('@ingestionMode','varchar') as '@ingestionMode',
							defXml.query('/Ida_CMDefinitionReq/cmDef/defXml/*') AS 'defXml'
							FROM CMDefinition c cross apply c.defXml.nodes('/Ida_CMDefinitionReq/cmDef') as cmDefReq(cmDef)
						where clientId = @inCaseId and (id = @inDefId OR @inDefId = 0)
						FOR XML PATH('cmDef'), ROOT('Ida_CMDefinitionResp')
					)
		if @outXml IS NULL
             set @outXml = '<Ida_CMDefinitionResp />'
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @outXml = (SELECT @@ERROR AS '@result',  'Failed to perform CMDefinition operation' AS '@errorString' FOR XML PATH('Ida_CMDefinitionResp'))
	IF XACT_STATE() <> 0
    BEGIN
        ROLLBACK TRANSACTION;
    END
END CATCH;
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'CMDefinitionOperations')
	delete from GxQscripts where name = 'CMDefinitionOperations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CMDefinitionOperations')
	delete from GXDBVersions where aliasname = 'CMDefinitionOperations'
GO

insert into GXDBVersions values(2, 'CMDefinitionOperations',  '00010001000200090000', 'CMDefinitionOperations', '00010001000200090000')
GO

