

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CC_OAuthAppOperation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CC_OAuthAppOperation.sp,v $ $Id: CC_OAuthAppOperation.sp,v 1.8.14.2 2018/03/27 08:41:18 jiechen Exp $";
-- =============================================
-- Author:		Rohit Iyer
-- Create date: 10/09/2013
-- Description:	Operation on Oauth Application
-- =============================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CC_OAuthAppOperation <<<'

IF EXISTS (select * from sysobjects where name='CC_OAuthAppOperation')
	drop procedure CC_OAuthAppOperation
IF EXISTS (select * from GxQscripts where name='CC_OAuthAppOperation')
	delete from GxQscripts where name = 'CC_OAuthAppOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CC_OAuthAppOperation')
	delete from GXDBVersions where aliasname = 'CC_OAuthAppOperation'
GO
print '... Creating Procedure: CC_OAuthAppOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CC_OAuthAppOperation
  @in_xml XML
AS
BEGIN TRY
SET NOCOUNT ON
DECLARE @cnt1				INT
DECLARE @cnt2				INT
DECLARE @creatorId      	INT
DECLARE @localeId			INT
DECLARE @isAdminUser 		INT
DECLARE @operationType      INT
DECLARE @i_id      			INT
DECLARE @i_providerId      	INT
DECLARE @webconsoleXML		XML
DECLARE @i_appType      	INT
DECLARE @i_appId  	    	nvarchar(100)
DECLARE @i_appSecret     	nvarchar(255)
DECLARE @i_emailAddress 	nvarchar(255)
DECLARE @i_redirectURI 		nvarchar(255)
DECLARE @tempSecret			nvarchar(255)
DECLARE @i_flags        INT
DECLARE @nowTime			INT
DECLARE @warningCode		INT
DECLARE @warningMessage		VARCHAR(MAX)
DECLARE @errorCode 			INT
DECLARE @errorMessage 		VARCHAR(MAX)
DECLARE @xmlText XML
--declare the table to store the application for which the information has to be set
DECLARE @tempOauthTable TABLE
(
id				integer,
umdsProviderId 	integer,
appID 			NVARCHAR(MAX),
appSecret 		NVARCHAR(MAX),
emailAddress 	NVARCHAR(MAX),
appType 		integer,
flags       	integer
)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @xmlText       	=    @in_xml
SET @operationType  =	 @xmlText.value('(/App_CCSetApplicationInfoReq/@opType)[1]', 'INT')
INSERT INTO @tempOauthTable(id , umdsProviderId, appID , appSecret  , emailAddress , appType , flags )
SELECT  ISNULL(ref.value('@id', 'INT'),0) 									AS agent0,
		ISNULL(ref.value('@providerId', 'INT'),0) 									AS agent1,
		ISNULL(ref.value('@appId', 'nvarchar(256)'),'') 							AS agent2,
		ISNULL(ref.value('@appSecret', 'nvarchar(255)'),'') 						AS agent3,
		ISNULL(ref.value('@creatorEmail', 'nvarchar(255)'),'')						AS agent4,
		ISNULL(ref.value('@appType',  'INT'),0) 									AS agent5,
		ISNULL(ref.value('@isEnabled',  'INT'),0)  										AS agent6
FROM    @xmlText.nodes('App_CCSetApplicationInfoReq/oauthApplications') R ( ref )
SET @creatorId = ISNULL((SELECT  ref.value('@userId', 'int') AS col1
                         FROM    @xmlText.nodes('App_CCSetApplicationInfoReq/processinginstructioninfo/user') R ( ref )),0)
SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS col1
                         FROM    @xmlText.nodes('App_CCSetApplicationInfoReq/processinginstructioninfo/locale') R ( ref )),0)
SET @errorCode = 0
SET @errorMessage = ''
--check requesting user details
IF (NOT EXISTS(SELECT 1 FROM UMUsers WITH(nolock) WHERE id = @creatorId))
BEGIN
	SET @errorCode	= 1
SET @errorMessage = ( SELECT message FROM EvLocaleMsgs WITH(nolock) WHERE messageId = (475 | (CAST(POWER(2, 24) AS BIGINT) * 35))  AND [localeId] = @localeId )
    SET @errorMessage = REPLACE(@errorMessage, '^1%s', @creatorId)
    GOTO SEND_RESPONSE
END
--Only users belonging to the "MASTER" user group should be able modify OAuth Application Details
EXEC sec_isUserAdmin @creatorId, @isAdminUser OUT
IF(@isAdminUser = 0)
BEGIN
	SET @errorCode	= 1
SET @errorMessage = ( SELECT message FROM EvLocaleMsgs WITH(nolock) WHERE messageId = (2034 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId )
    GOTO SEND_RESPONSE
END
--@CNT1 will denote the number of rows in temp table after insertion of appIds
--@CNT2 will denote the number of rows in temp table after deletion of invalid appId
--(@CNT1 - @CNT2) will give us the number of invalid appIds that were sent from gui/cmd and we can send back a warning message accordingly
SET @cnt1  = 	(SELECT COUNT(*) FROM @tempOauthTable)
IF(@cnt1 = 0)
BEGIN
	SET @warningCode    = 1
	SET @warningMessage = 'No OAuth Application info provided'
	GOTO SEND_RESPONSE
END
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
--Declare a table variable to store the list of Webconsoles to be used as redirect Webconsoles.
DECLARE @WebconsoleListTbl TABLE
(
id				integer,
appID			nvarchar(255),
weconsoleURL 	nvarchar(255)
)
--For Add/Update operation , insert the list of webconsole URLs sent from GUI
INSERT INTO @WebconsoleListTbl
SELECT 	ISNULL(ref.value('../@id' , 'integer'),0),
		ISNULL(ref.value('../@appId' , 'nvarchar(255)') , ''),
		ISNULL(ref.value('@val' , 'nvarchar(255)'),'WTF')
	    FROM   @xmlText.nodes('App_CCSetApplicationInfoReq/oauthApplications/redirectWebconsole') R ( ref )
--1. ADD
--2. DELETE
--3. UPDATE
--4. RENEW
IF(@operationType = 3)
BEGIN
--delete all entries from temp table which do not have a matching row in the actual table
	DELETE TOT
		FROM @tempOauthTable TOT LEFT JOIN CC_OAuthApplication OOA ON TOT.id = OOA.id
		WHERE OOA.appID IS NULL
	SET @cnt2 = (SELECT COUNT(*) FROM @tempOauthTable)
	IF(@cnt1 > @cnt2)
	BEGIN
		SET @warningCode    = 1
		SET @warningMessage = 'Some Applications for the update operation do not exist.'
	END
	DECLARE @AppTableCur CURSOR
	--if cursor is already open , close it
	IF ( CURSOR_STATUS('variable', '@AppTableCur') > 0) /* cursor is open */
		CLOSE @AppTableCur
	SET @AppTableCur = CURSOR
		FOR SELECT DISTINCT id, umdsProviderId ,appID, appSecret, emailAddress, appType , flags
		 FROM @tempOauthTable
			OPEN @AppTableCur
				FETCH NEXT FROM @AppTableCur INTO @i_id ,@i_providerId ,@i_appId, @i_appSecret, @i_emailAddress , @i_appType , @i_flags
				WHILE @@FETCH_STATUS = 0
				BEGIN
					--check if the application with the same name or same appID already exists.
					--If so , send back an error indicating the reason.
					IF EXISTS(SELECT 1 FROM CC_OAuthApplication WHERE appID = @i_appId AND id <> @i_id )
					BEGIN
						SET @errorCode	= 1
						SET @errorMessage = 'Failed to update. Application with appId ['+@i_appId+'] already exists'
						DEALLOCATE @AppTableCur
						GOTO SEND_RESPONSE
					END
					BEGIN
							--Update all common fields which can be updated for every request
							UPDATE CC_OAuthApplication
							SET umdsProviderId = @i_providerId , appID = @i_appId , appType = @i_appType , flags = @i_flags
							WHERE id = @i_id
							IF(@i_appSecret <> '')	--Check for only appSecret
							BEGIN
								UPDATE CC_OAuthApplication
								SET  appSecret = @i_appSecret
								WHERE id = @i_id
							END
							IF EXISTS(select 1 from @WebconsoleListTbl WHERE appID = @i_appId ) --check for only redirectURI
							BEGIN
								UPDATE CC_OAuthApplication
								SET  assocWebconsole = (SELECT weconsoleURL as '@name'
														FROM @WebconsoleListTbl
														WHERE appID = @i_appId
														for xml path('webconsole'), root('webconsoleList'), TYPE)
								WHERE id = @i_id
							END
							IF(@i_emailAddress <> '') --check for only emailAddress
							BEGIN
								UPDATE CC_OAuthApplication
								SET  emailAddress = @i_emailAddress
								WHERE id = @i_id
							END
					END
				FETCH NEXT FROM @AppTableCur INTO @i_id ,@i_providerId ,@i_appId, @i_appSecret, @i_emailAddress , @i_appType , @i_flags
				END
			DEALLOCATE @AppTableCur
END
ELSE IF (@operationType = 1)    --ADD
BEGIN
	DELETE TOT
	FROM @tempOauthTable TOT INNER JOIN CC_OAuthApplication OOA ON TOT.id = OOA.id
	SET @cnt2 = (SELECT COUNT(*) FROM @tempOauthTable)
	IF(@cnt1 > @cnt2)
	BEGIN
		SET @errorCode	= 1
		SET @errorMessage = 'Failed to add. Application with given appID already exists'
		GOTO SEND_RESPONSE
	END
	DECLARE @AppTableCur2 CURSOR
	--if cursor is already open , close it
	IF ( CURSOR_STATUS('variable', '@AppTableCur2') > 0) /* cursor is open */
		CLOSE @AppTableCur2
	SET @AppTableCur2 = CURSOR
		FOR SELECT DISTINCT umdsProviderId ,appID, appSecret, emailAddress, appType , flags
		 FROM @tempOauthTable
			OPEN @AppTableCur2
				FETCH NEXT FROM @AppTableCur2 INTO @i_providerId ,@i_appId, @i_appSecret, @i_emailAddress , @i_appType , @i_flags
				WHILE @@FETCH_STATUS = 0
				BEGIN
					IF EXISTS(SELECT 1 FROM CC_OAuthApplication WHERE appID = @i_appId)
					BEGIN
						SET @errorCode	= 1
						SET @errorMessage = 'Failed to add. Application with appID ['+@i_appId+'] already exists'
						DEALLOCATE @AppTableCur2
						GOTO SEND_RESPONSE
					END
						INSERT INTO [CommServ].[dbo].[CC_OAuthApplication]
						(
						umdsProviderId,
						appID,
						appSecret,
						emailAddress,
						assocWebconsole,
						appType,
						ownerId,
						flags,
						created,
						modified,
						props
						)
						VALUES
						(
						@i_providerId,
						@i_appId ,
						@i_appSecret,
						@i_emailAddress,
						'',
						@i_appType,
						@creatorId,
						@i_flags,
						@nowTime,
						0,
						'<props />'
						)
						UPDATE CC_OAuthApplication
						SET  assocWebconsole = (SELECT weconsoleURL as '@name'
											FROM @WebconsoleListTbl
											WHERE appID = @i_appId
											for xml path('webconsole'), root('webconsoleList'), TYPE)
						WHERE id = @@IDENTITY
				FETCH NEXT FROM @AppTableCur2 INTO @i_providerId ,@i_appId, @i_appSecret, @i_emailAddress , @i_appType , @i_flags
				END
			DEALLOCATE @AppTableCur2
END
ELSE IF(@operationType = 2)  --Delete operation
BEGIN
	DELETE TOT
	FROM @tempOauthTable TOT LEFT JOIN CC_OAuthApplication OOA ON TOT.id = OOA.id
	WHERE OOA.appID IS NULL
	SET @cnt2 = (SELECT COUNT(*) FROM @tempOauthTable)
	IF(@cnt1 > @cnt2)
	BEGIN
		SET @warningCode    = 1
		SET @warningMessage = 'Some Applications for the update operation do not exist.'
	END
		DELETE OOA
			FROM CC_OAuthApplication OOA INNER JOIN @tempOauthTable TOT ON TOT.appId = OOA.appId
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode     = ERROR_NUMBER()
    SET @errorMessage  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	IF ( CURSOR_STATUS('variable', '@AppTableCur') > 0) /* cursor is open */
		CLOSE  @AppTableCur
    IF ( CURSOR_STATUS('variable', '@AppTableCur') = -1) /* cursor is closed */
    DEALLOCATE @AppTableCur
    IF ( CURSOR_STATUS('variable', '@AppTableCur2') > 0) /* cursor is open */
		CLOSE  @AppTableCur2
    IF ( CURSOR_STATUS('variable', '@AppTableCur2') = -1) /* cursor is closed */
    DEALLOCATE @AppTableCur2
END CATCH
SEND_RESPONSE:
SET @xmlText = ( SELECT  @errorCode AS '@errorCode', @errorMessage AS '@errorString', @warningCode AS '@warningCode' , @warningMessage AS '@warningMessage'
                 FOR xml path('error'),ROOT('App_CCSetApplicationInfoResp')
               )
SET NOCOUNT OFF
select @xmlText as 'out_xml'
GO

IF EXISTS (select * from GxQscripts where name = 'CC_OAuthAppOperation')
	delete from GxQscripts where name = 'CC_OAuthAppOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CC_OAuthAppOperation')
	delete from GXDBVersions where aliasname = 'CC_OAuthAppOperation'
GO

insert into GXDBVersions values(2, 'CC_OAuthAppOperation',  '00010008001400020000', 'CC_OAuthAppOperation', '00010008001400020000')
GO

