

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CC_GetOAuthAppInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CC_GetOAuthAppInfo.sp,v $ $Id: CC_GetOAuthAppInfo.sp,v 1.6.58.2 2018/03/27 09:15:41 jiechen Exp $";
-- =============================================
-- Author:		Rohit Iyer
-- Create date: 10/09/2013
-- Description:	Get OAuth Application Details
-- =============================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CC_GetOAuthAppInfo <<<'

IF EXISTS (select * from sysobjects where name='CC_GetOAuthAppInfo')
	drop procedure CC_GetOAuthAppInfo
IF EXISTS (select * from GxQscripts where name='CC_GetOAuthAppInfo')
	delete from GxQscripts where name = 'CC_GetOAuthAppInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CC_GetOAuthAppInfo')
	delete from GXDBVersions where aliasname = 'CC_GetOAuthAppInfo'
GO
print '... Creating Procedure: CC_GetOAuthAppInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CC_GetOAuthAppInfo
  @in_Xml XML
AS
BEGIN TRY
SET NOCOUNT ON
DECLARE @nRows 			INT
DECLARE @requestorId      INT
DECLARE @localeId  		INT
DECLARE @propLevel		INT
DECLARE @providerId		INT
DECLARE @appType		INT
DECLARE @isAdminUser 	INT
DECLARE @errorCode 		INT
DECLARE @errorMessage 	VARCHAR(MAX)
DECLARE @xmlText 		XML
DECLARE @applicationList XML
DECLARE @r_errors XML
--The following table will hold the list of appIds for which the request is sent.
DECLARE @AppIdsTable TABLE
(
appId NVARCHAR(max)
)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @errorCode = 0
SET @errorMessage = ''
SET @xmlText = @in_xml
--Get Params from XML request
SET @requestorId = ISNULL((SELECT  ref.value('@userId', 'int') AS col1
                         FROM    @xmlText.nodes('App_CCGetApplicationInfoReq/processinginstructioninfo/user') R ( ref )),0)
SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS col1
                         FROM    @xmlText.nodes('App_CCGetApplicationInfoReq/processinginstructioninfo/locale') R ( ref )),0)
SET @propLevel = ISNULL((SELECT ref.value('@propLevel', 'int') AS col1
						 FROM    @xmlText.nodes('App_CCGetApplicationInfoReq') R ( ref )), 0)
SET @providerId = ISNULL((SELECT ref.value('@providerId', 'int') AS col1
						 FROM    @xmlText.nodes('App_CCGetApplicationInfoReq') R ( ref )), 0)
SET @appType = ISNULL((SELECT ref.value('@appType', 'int') AS col1
						 FROM    @xmlText.nodes('App_CCGetApplicationInfoReq') R ( ref )), 0)--First and foremost, check for the requesting user detail
IF (NOT EXISTS(SELECT 1 FROM UMUsers WHERE id = @requestorId))
BEGIN
	SET @errorCode	= 1
    SET @errorMessage = ( SELECT message FROM EvLocaleMsgs WHERE messageId = 1234  AND [localeId] = @localeId )
    SET @errorMessage = REPLACE(@errorMessage, '^1%s', @requestorId)
    GOTO SEND_RESPONSE
END
IF(@propLevel = 0)
BEGIN
	SET @errorCode	= 1
    SET @errorMessage = 'Property Filter settings not found'
    GOTO SEND_RESPONSE
END
--Only users belonging to the "MASTER" user group should be able to view app details for now, may be changed in the future
EXEC sec_isUserAdmin @requestorId, @isAdminUser OUT
IF(@isAdminUser = 0)
BEGIN
	SET @errorCode	= 1
    SET @errorMessage = ( SELECT message FROM EvLocaleMsgs WHERE messageId = 1234 AND [localeId] = @localeId )
    GOTO SEND_RESPONSE
END
--Insert appKeys from request into temp table only if @propLevel = 1
--For propLevel = 1, we will return all applications for the requesting user, hence no insertion into temp Table
--Check if all params in the request [propLevel, providerId , appType and appIds] are set and if not, send back an error message.
--If propLevel =1 , no need to check for the rest of the params.
--If proplevel <>1 , then either appIds or [appType, provider] info should be set as we would need some criterion on which to send back application details.
IF(@propLevel <> 1)
BEGIN
	INSERT INTO @AppIdsTable
	SELECT  ISNULL(ref.value('@val', 'nvarchar(256)'),'') AS appKey
			FROM    @xmlText.nodes('App_CCGetApplicationInfoReq/appIds') R ( ref )
--delete all rows from AppIdsTable where the appId value = 0 or appType <> 1(we only want to fetch OAuth application details),as such application do not exist
	DELETE AIT
		FROM  @AppIdsTable AIT LEFT JOIN CC_OAuthApplication OAA ON AIT.appId = OAA.appID
		WHERE OAA.appID IS NULL
	SET @nRows = (SELECT CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END FROM @AppIdsTable)
	IF(@nRows =0)
	BEGIN
		SET @errorCode	= 1
		SET @errorMessage = 'No valid AppIds to fetch data. Exiting'
		GOTO SEND_RESPONSE
	END
	IF(( @providerId = 0 AND @appType = 0) AND
		( NOT EXISTS( SELECT 1 FROM @AppIdsTable ) ))
	BEGIN
		SET @errorCode	= 1
		SET @errorMessage = 'No application Filter criterion found. Please check request'
		GOTO SEND_RESPONSE
	END
END
--If propLeve =1 , the request if meant to fetch all applications for the requesting userId, hence no AppIds would be sent in this case
IF @propLevel = 1
BEGIN
SET  @applicationList = (SELECT OAA.id				AS '@id',
								OAA.appID 			AS '@appId',
								OAA.umdsProviderId 	AS '@providerId',
								OAA.appType 		AS '@appType',
								(CASE WHEN ((OAA.flags & 1) > 0) THEN 'true' ELSE 'false' END) AS '@isEnabled'
						FROM CC_OAuthApplication OAA
						FOR XML PATH('oauthApplications') )
END
ELSE
BEGIN
	IF( @providerId <> 0 OR @appType <> 0 )
	BEGIN
		SET  @applicationList = (SELECT OAA.id				AS '@id',
										OAA.appID 			AS '@appId',
										OAA.umdsProviderId 	AS '@providerId',
										OAA.appType 		AS '@appType',
										(CASE WHEN ((OAA.flags & 1) > 0) THEN 'true' ELSE 'false' END) AS '@isEnabled',
										(case when @propLevel >10 THEN OAA.emailAddress ELSE NULL END ) 	AS '@creatorEmail',
										(case when @propLevel >20 THEN OAA.appSecret   ELSE	NULL END)   AS '@appSecret',
										(case when @propLevel >10 THEN ( select ref.value('@name','nvarchar(255)') as '@val' FROM  OAA.assocWebconsole.nodes('/webconsoleList/webconsole') R ( ref ) for xml path('redirectWebconsole') ,type) ELSE NULL END)
								FROM 	CC_OAuthApplication OAA
								WHERE 	( @appType =0 OR OAA.appType = @appType ) AND ( @providerId = 0 OR OAA.umdsProviderId = @providerId )
								FOR XML PATH('oauthApplications') )
	END
	ELSE IF ( EXISTS( SELECT 1 FROM @AppIdsTable ) )
	BEGIN
		SET  @applicationList = (SELECT OAA.id				AS '@id',
										OAA.appID 			AS '@appId',
										OAA.umdsProviderId 	AS '@providerId',
										OAA.appType 		AS '@appType',
										(CASE WHEN ((OAA.flags & 1) > 0) THEN 'true' ELSE 'false' END) AS '@isEnabled',
										(case when @propLevel >10 THEN OAA.emailAddress ELSE NULL END ) AS '@creatorEmail',
										(case when @propLevel >20 THEN OAA.appSecret   ELSE	NULL END)   AS '@appSecret',
										(case when @propLevel >10 THEN ( select ref.value('@name','nvarchar(255)') as '@val' FROM  OAA.assocWebconsole.nodes('webconsoleList/webconsole') R ( ref ) for xml path('redirectWebconsole') , type)  ELSE NULL END)
								FROM 	CC_OAuthApplication OAA INNER JOIN @AppIdsTable AIT ON OAA.appID = AIT.appId
								FOR XML PATH('oauthApplications') )
	END
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode     = ERROR_NUMBER()
    SET @errorMessage  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SEND_RESPONSE:
SET @r_errors = (SELECT @errorCode 	 AS '@errorCode',
						@errorMessage AS '@errorString'
					FOR xml PATH('error'))
SET @xmlText = ( SELECT  ISNULL(@r_errors,'') , ISNULL(@applicationList ,'')
                 FOR xml path(''),ROOT('App_CCGetApplicationInfoResp')
               )
SET NOCOUNT OFF
SELECT @xmlText as 'out_xml'
GO

IF EXISTS (select * from GxQscripts where name = 'CC_GetOAuthAppInfo')
	delete from GxQscripts where name = 'CC_GetOAuthAppInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CC_GetOAuthAppInfo')
	delete from GXDBVersions where aliasname = 'CC_GetOAuthAppInfo'
GO

insert into GXDBVersions values(2, 'CC_GetOAuthAppInfo',  '00010006005800020000', 'CC_GetOAuthAppInfo', '00010006005800020000')
GO

