

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCRUpdateFlagsByCCRId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCRUpdateFlagsByCCRId.sp,v $ $Id: CCRUpdateFlagsByCCRId.sp,v 1.13.2.32.14.1 2021/03/09 23:53:14 nbirru Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "CCRUpdateFlagsByCCRId"								|
--	|																		|
--	|THIS PROCEDURE WILL TEST TO SEE IF THE STRING "NEWSTRING" IS ALREADY A	|
--	| NAME IN THE TABLE, AND IF NOT INSERTS IT BEFORE RETURNING ALL ROWS 	|
--	| THAT MATCH THE SEARCH CRITERIA "ID < compVal".						|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A STORED PROCEDURE		|
--	| AND RETURNING RESULTS	                                                |
--  | Tinku:CCM:Archive File Id's are no longer unique						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CCRUpdateFlagsByCCRId')
BEGIN
	print '>>> Drop Stored Procedure: CCRUpdateFlagsByCCRId <<<'
	drop procedure CCRUpdateFlagsByCCRId
END
IF EXISTS (select * from GxQscripts where name='CCRUpdateFlagsByCCRId')
	delete from GxQscripts where name = 'CCRUpdateFlagsByCCRId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRUpdateFlagsByCCRId')
	delete from GXDBVersions where aliasname = 'CCRUpdateFlagsByCCRId'
GO
print '... Creating Procedure: CCRUpdateFlagsByCCRId'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CCRUpdateFlagsByCCRId
  @CCRId integer,
  @UpdateCCREndTime integer,
  @in_isaddResources integer,
  @in_CSCCCheck integer
AS
  DECLARE @retVal integer
  DECLARE @errorString varchar(256)
--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	declare @in_CCRId	integer
	set @in_CCRId = @CCRId
	declare @in_updateCCREndTime	integer
	set @in_UpdateCCREndTime = @UpdateCCREndTime
	SET @retVal = 0
	set @errorString = ''
	declare @CommServe_Id	integer
	set @CommServe_Id = (select clientId from APP_Platform where (platformType & 1) = 1)
	IF object_id('tempdb.dbo.#tmpsimClient') IS NOT NULL drop table #tmpsimClient
	create table #tmpsimClient(
								ClientId			integer
								)
	INSERT INTO  #tmpsimClient(ClientId)		select distinct ClientId  from simInstalledPackages(nolock)
	-- Get the Client and proxy pairs here
	IF object_id('tempdb.dbo.#tmpClientProxyPairs') IS NOT NULL drop table #tmpClientProxyPairs
	create table #tmpClientProxyPairs(ClientId		integer,
							instanceId			integer,
							proxyClientId			integer,
							ClientAppType				integer,
						isIndexServer				integer DEFAULT 0,  --0 meaning proxyclient, 1 meaning index server
						iscloudindexServer 	integer DEFAULT 0,    -- 1 meaning cloud index server
						cloudindexServer 	integer DEFAULT 0,
						isproxyclientGroup 	integer DEFAULT 0 , -- 1 meaning client Group
						clientGroup		 	integer DEFAULT 0,
						subclientId		 	integer DEFAULT 0
						)
	IF object_id('tempdb.dbo.#tmpCCRsubClientProxyPairs') IS NOT NULL drop table #tmpCCRsubClientProxyPairs
	create table #tmpCCRsubClientProxyPairs(ClientId	integer,
							instanceId					integer,
							ClientAppType				integer,
							subclientId		 			integer DEFAULT 0,
							issubclientProxy 			integer DEFAULT 0
						)
	IF object_id('tempdb.dbo.#tmpCCRClientInputInternal') IS NOT NULL drop table #tmpCCRClientInputInternal
	create table #tmpCCRClientInputInternal
                        (   ClientId        integer,
                            subclientId     integer,
                            INSTANCE        integer,
                            appTypeId       integer,
							DataPathId      integer,
							CCRNetworkReadinessFlag integer
                        )
	INSERT INTO #tmpCCRClientInputInternal
 	SELECT DISTINCT A.CLIENTID,A.Id, A.INSTANCE ,C.appTypeId, 0, 0
	    FROM APP_Application A (NOLOCK)
			INNER JOIN CCRToSubClient C (NOLOCK) ON C.subclientId = A.Id AND C.CCRId = @in_CCRId
	    And (A.subclientStatus & 6) = 0     -- uninstalled OR deleted
	EXEC APPGetProxyClientInfo   '#tmpCCRClientInputInternal','#tmpClientProxyPairs',@in_isaddResources
	CREATE INDEX  #tmpClientProxyPairs_ClientId_instanceId_proxyClientId ON #tmpClientProxyPairs (ClientId,instanceId,	proxyClientId)
	INSERT INTO #tmpCCRsubClientProxyPairs(ClientId	, instanceId, ClientAppType , subclientId, issubclientProxy )
	SELECT A.ClientId	, A.instance, A.appTypeId , A.id, CASE WHEN proxy.subclientId IS NULL THEN 0 ELSE 1 END
	FROM APP_Application  A  WITH (READUNCOMMITTED)
	INNER JOIN  CCRToSubCLient as CCRSC  ON CCRSC.CCRId = @in_CCRId AND A.ID = CCRSC.subclientid AND A.clientId = CCRSC.ClientId
	LEFT OUTER JOIN  #tmpClientProxyPairs proxy ON CCRSC.AppTypeId  = proxy.ClientAppType AND CCRSC.clientId = proxy.ClientId AND
	 A.APPTYPEID =proxy.ClientAppType AND A.INSTANCE = proxy.instanceId AND A.ID = proxy.subclientId
	 CREATE INDEX  #tmpCCRsubClientProxyPairs_ClientId_instanceId_subclientId ON #tmpCCRsubClientProxyPairs (ClientId,ClientAppType,	subclientId)
	-- Get the proxy pairs here
	IF object_id('tempdb.dbo.#tmpProxyPairs') IS NOT NULL drop table #tmpProxyPairs
	create table #tmpProxyPairs(ClientId		integer,
							proxySourceClientId			integer,
							proxyDestinationClientId	integer,
							ClientAppType				integer,
							instanceId			integer,
							subclientId		 			integer
			)
	INSERT INTO #tmpProxyPairs(ClientId	, proxySourceClientId ,	proxyDestinationClientId ,	ClientAppType,instanceId,subclientId)
	select DISTINCT P1.ClientId, P1.proxyClientId,P2.proxyClientId, P1.ClientAppType, P1.instanceId ,P1.subclientId
	FROM #tmpClientProxyPairs P1 INNER JOIN #tmpClientProxyPairs P2 ON P1.ClientId = P2.ClientId and P1.instanceId = P2.instanceId AND P1.subclientId = P2.subclientId
WHERE P1.proxyClientId<>P2.proxyClientId AND P1.ClientAppType != 38
	-- Get the data path
	IF object_id('tempdb.dbo.#tmpDataPath') IS NOT NULL drop table #tmpDataPath
		create table #tmpDataPath(DataPathId		INTEGER,
								  HostClientId		INTEGER,
								  poweredOffMA      INTEGER
								  )
	INSERT INTO #tmpDataPath(DataPathId	, HostClientId	,poweredOffMA)
	SELECT mcf.DataPathId,mcf.HostClientId, CASE WHEN  MH.ClientId IS NULL THEN  0
											ELSE  1 END
	FROM   MMDataPath as mcf WITH (NOLOCK)
	LEFT OUTER JOIN MMHost as MH WITH (READUNCOMMITTED)
ON MH.ClientId =mcf.HostClientId AND (MH.Attribute & 32768) = 32768	AND MH.OfflineReason=7
	WHERE  mcf.HostClientId!=2
--To update networkFlag and update CCRTOsubclient table at the end
	DELETE FROM #tmpCCRClientInputInternal
	INSERT INTO #tmpCCRClientInputInternal
 	SELECT DISTINCT C.CLIENTID,C.SubclientId, 0 ,C.appTypeId, C.DataPathId, 0
	    FROM  CCRToSubClient C (NOLOCK) where C.CCRId = @in_CCRId
	IF (@in_CSCCCheck = 1)
	BEGIN
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag | 4
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK) ON CCRSC.AppTypeId not in(13) AND 	CCRSC.clientId = CCRCC.fromClientId and
															@CommServe_Id = CCRCC.toClientId and CCRCC.flag = 0 and CCRCC.IsDip =0 and CCRCC.serviceType = 0
		INNER JOIN #tmpsimClient sub ON CCRCC.toClientId = sub.ClientId
		SET	@retVal = @@ERROR
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for Client To CS'
		END
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag | 8
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK) ON CCRSC.AppTypeId not in(13) AND 	CCRSC.clientId = CCRCC.toClientId and
															   @CommServe_Id = CCRCC.fromClientId and CCRCC.flag = 0 and CCRCC.IsDip =0 and	CCRCC.serviceType = 0
		INNER JOIN #tmpsimClient sub ON CCRCC.toClientId = sub.ClientId
		SET	@retVal = @@ERROR
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for CS to Client'
		END
	END
	ELSE
	BEGIN
		-- Step 1: Client To MA
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag |  1
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK) ON CCRSC.AppTypeId not in(13) AND CCRSC.clientId = CCRCC.fromClientId
												  AND CCRCC.flag = 0 and CCRCC.IsDip =0 and	CCRCC.serviceType = 0
		INNER JOIN  #tmpDataPath as mcf WITH (NOLOCK) ON mcf.DataPathId = CCRSC.DataPathId and mcf.HostClientId = CCRCC.toClientId  AND mcf.poweredOffMA= 0
		INNER JOIN  #tmpsimClient sub ON CCRCC.toClientId = sub.ClientId
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for Client To MA'
		END
	-- Step 2: proxy Client To MA
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag |  4096
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN #tmpCCRsubClientProxyPairs A  ON A.ClientId  = CCRSC.ClientId  AND A.ClientAppType =CCRSC.AppTypeId AND A.subclientid = CCRSC.subclientid
		INNER JOIN #tmpClientProxyPairs proxy ON  CCRSC.AppTypeId  = proxy.ClientAppType AND CCRSC.clientId = proxy.ClientId AND A.instanceId = proxy.instanceId AND (( A.issubclientProxy= 0 AND proxy.subclientId = 0)  OR(A.issubclientProxy= 1 AND A.subclientid= proxy.subclientid))
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK) ON  proxy.proxyClientId = CCRCC.fromClientId
												  AND CCRCC.flag = 0 and CCRCC.IsDip =0 and	CCRCC.serviceType = 0
		INNER JOIN  #tmpDataPath as mcf WITH (NOLOCK) ON mcf.DataPathId = CCRSC.DataPathId and mcf.HostClientId = CCRCC.toClientId  AND mcf.poweredOffMA= 0
		INNER JOIN  #tmpsimClient sub ON CCRCC.toClientId = sub.ClientId
		SET	@retVal = @@ERROR
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for Client To MA'
		END
		-- Step 3: MA to Client
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag | 2
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK)  ON CCRSC.AppTypeId not in(13) AND CCRSC.clientId = CCRCC.toClientId and
													CCRCC.flag = 0 and CCRCC.IsDip =0 and CCRCC.serviceType = 0
		INNER JOIN #tmpDataPath as mcf  WITH (NOLOCK) ON mcf.DataPathId = CCRSC.DataPathId and mcf.HostClientId = CCRCC.fromClientId AND mcf.poweredOffMA= 0
		INNER JOIN #tmpsimClient sub ON	 CCRCC.toClientId = sub.ClientId
		SET	@retVal = @@ERROR
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for MA To Client'
		END
	-- Step 4: MA to proxy Client
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag |  8192
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN #tmpCCRsubClientProxyPairs A  ON A.ClientId  = CCRSC.ClientId  AND A.ClientAppType =CCRSC.AppTypeId AND A.subclientid = CCRSC.subclientid
		INNER JOIN #tmpClientProxyPairs proxy ON  CCRSC.AppTypeId  = proxy.ClientAppType AND CCRSC.clientId = proxy.ClientId AND A.instanceId = proxy.instanceId AND ( ( A.issubclientProxy= 0 AND proxy.subclientId = 0)  OR(A.issubclientProxy= 1 AND A.subclientid= proxy.subclientid))
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK) ON  proxy.proxyClientId = CCRCC.toClientId
												  AND CCRCC.flag = 0 and CCRCC.IsDip =0 and	CCRCC.serviceType = 0
		INNER JOIN  #tmpDataPath as mcf WITH (NOLOCK) ON mcf.DataPathId = CCRSC.DataPathId and mcf.HostClientId = CCRCC.fromClientId  AND mcf.poweredOffMA= 0
		INNER JOIN  #tmpsimClient sub ON CCRCC.toClientId = sub.ClientId
		SET	@retVal = @@ERROR
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for MA To proxy Client'
		END
		-- Step 5: Client to CS
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag | 4
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK) ON CCRSC.AppTypeId not in(13) AND 	CCRSC.clientId = CCRCC.fromClientId and
															@CommServe_Id = CCRCC.toClientId and CCRCC.flag = 0 and CCRCC.IsDip =0 and CCRCC.serviceType = 0
		INNER JOIN #tmpsimClient sub ON CCRCC.toClientId = sub.ClientId
		SET	@retVal = @@ERROR
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for Client To CS'
		END
		-- Step 6: PROXY Client to CS
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag | 16384
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN #tmpCCRsubClientProxyPairs A  ON A.ClientId  = CCRSC.ClientId  AND A.ClientAppType =CCRSC.AppTypeId AND A.subclientid = CCRSC.subclientid
		INNER JOIN #tmpClientProxyPairs proxy ON  CCRSC.AppTypeId  = proxy.ClientAppType AND CCRSC.clientId = proxy.ClientId AND A.instanceId = proxy.instanceId AND ( ( A.issubclientProxy= 0 AND proxy.subclientId = 0)  OR(A.issubclientProxy= 1 AND A.subclientid= proxy.subclientid))
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK) ON 	proxy.proxyClientId =  CCRCC.fromClientId and
															@CommServe_Id = CCRCC.toClientId and CCRCC.flag = 0 and CCRCC.IsDip =0 and CCRCC.serviceType = 0
		INNER JOIN #tmpsimClient sub ON CCRCC.toClientId = sub.ClientId
		SET	@retVal = @@ERROR
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for Client To CS'
		END
		-- Step 7: CS to Client
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag | 8
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK) ON CCRSC.AppTypeId not in(13) AND 	CCRSC.clientId = CCRCC.toClientId and
															   @CommServe_Id = CCRCC.fromClientId and CCRCC.flag = 0 and CCRCC.IsDip =0 and	CCRCC.serviceType = 0
		INNER JOIN #tmpsimClient sub ON CCRCC.toClientId = sub.ClientId
		SET	@retVal = @@ERROR
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for CS to Client'
		END
		-- Step 8: CS to PROXY Client
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag | 32768
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN #tmpCCRsubClientProxyPairs A  ON A.ClientId  = CCRSC.ClientId  AND A.ClientAppType =CCRSC.AppTypeId AND A.subclientid = CCRSC.subclientid
		INNER JOIN #tmpClientProxyPairs proxy ON  CCRSC.AppTypeId  = proxy.ClientAppType AND CCRSC.clientId = proxy.ClientId AND A.instanceId = proxy.instanceId AND ( ( A.issubclientProxy= 0 AND proxy.subclientId = 0)  OR(A.issubclientProxy= 1 AND A.subclientid= proxy.subclientid))
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK) ON 	proxy.proxyClientId = CCRCC.toClientId and
															   @CommServe_Id = CCRCC.fromClientId and CCRCC.flag = 0 and CCRCC.IsDip =0 and	CCRCC.serviceType = 0
		INNER JOIN #tmpsimClient sub ON CCRCC.toClientId = sub.ClientId
		SET	@retVal = @@ERROR
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for CS to Client'
		END
		-- Step 9: CS to MA
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag | 16
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK) ON @CommServe_Id = CCRCC.fromClientId AND CCRCC.toClientId = CCRSC.clientId and CCRCC.flag = 0 and CCRCC.IsDip =0 and	CCRCC.serviceType = 0
		INNER JOIN  #tmpDataPath as mcf WITH (NOLOCK) ON	mcf.DataPathId = CCRSC.DataPathId and mcf.HostClientId = CCRCC.toClientId AND mcf.poweredOffMA= 0
		SET	@retVal = @@ERROR
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for CS To MA'
		END
		-- Step 10: MA to CS
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag | 32
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK) ON  @CommServe_Id = CCRCC.toClientId AND CCRCC.fromClientId = CCRSC.clientId
																and CCRCC.flag = 0 and CCRCC.IsDip =0 and CCRCC.serviceType = 0
		INNER JOIN  #tmpDataPath as mcf WITH (NOLOCK) ON	mcf.DataPathId = CCRSC.DataPathId and mcf.HostClientId = CCRCC.fromClientId AND mcf.poweredOffMA= 0
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag | 524288
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN  #tmpDataPath as mcf WITH (NOLOCK) ON	mcf.DataPathId = CCRSC.DataPathId AND mcf.poweredOffMA= 1
		SET	@retVal = @@ERROR
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for MA To CS'
		END
		IF object_id('tempdb.dbo.#tmpClientRemoteCachePairs') IS NOT NULL drop table #tmpClientRemoteCachePairs
		create table #tmpClientRemoteCachePairs(
								subclientId			integer,
								ClientId			integer,
								AssociateremotecacheClientId			integer
								)
		IF object_id('tempdb.dbo.#tmpClientRemoteCachePairsAll') IS NOT NULL drop table #tmpClientRemoteCachePairsAll
		create table #tmpClientRemoteCachePairsAll(ClientId		integer,
							RemoteClientId			integer,
							RemoteClientCategory 			integer DEFAULT 0  --1 remoteclient, 4 LM
								)
		create INDEX #tmpClientRemoteCachePairsAll_ClientId on #tmpClientRemoteCachePairsAll (ClientId)
		IF object_id('tempdb.dbo.#tmpClientDDBMAPairs') IS NOT NULL drop table #tmpClientDDBMAPairs
		create table #tmpClientDDBMAPairs(
								subclientId			integer,
								ClientId			integer,
								MAClientId			integer,
								poweredOffMA			integer
								)
		-- Get the Client and Remote Software cache pairs (if remote client and client is not same )
		-- Get the Laptop Client and  Edge Index Server (if remote client and client is not same )
			-- additional check
		if(@in_isaddResources=1)
			EXEC CCRGetRemoteCachePairInfo  @CCRId ,'#tmpClientRemoteCachePairsAll'
		IF object_id('tempdb.dbo.#tempSubclientProp') IS NOT null DROP TABLE #tempSubclientProp
		CREATE TABLE #tempSubclientProp(
		subClientId					integer,
		associatedsubclientPolicyId 	integer,
		Deduplication				integer
		)
		INSERT INTO #tempSubclientProp (subClientId,associatedsubclientPolicyId,Deduplication)
		SELECT sc.subClientId,prop.attrVal, ISNULL(SProp.attrVal,1) FROM CCRToSubClient(nolock) AS sc
		INNER JOIN APP_SubclientProp prop WITH (NOLOCK) ON  prop.componentNameId = sc.subClientId  AND prop.attrName = 'Associated subclient Policy' AND prop.modified = 0 AND prop.cs_attrName = CHECKSUM(N'Associated subclient Policy')
		LEFT OUTER JOIN APP_SubclientProp SProp WITH (NOLOCK) ON  SProp.componentNameId =  prop.attrVal AND SProp.attrName = 'Single Instancing Option'  AND SProp.modified = 0 AND Sprop.cs_attrName = CHECKSUM(N'Single Instancing Option')
WHERE sc.CCRId = @in_CCRId AND SC.AppTypeId not in(13, 88,84)
		INSERT INTO #tempSubclientProp (subClientId,associatedsubclientPolicyId,Deduplication)
		SELECT sc.subClientId,0, ISNULL(prop.attrVal,1) FROM CCRToSubClient(nolock) AS sc
		LEFT OUTER JOIN APP_SubclientProp prop WITH (NOLOCK) ON  prop.componentNameId = sc.subClientId AND prop.attrName = 'Single Instancing Option' AND prop.modified = 0 AND prop.cs_attrName = CHECKSUM(N'Single Instancing Option')
		LEFT OUTER JOIN #tempSubclientProp SProp WITH (NOLOCK) ON  SProp.subClientId = sc.subClientId
		WHERE SProp.subClientId is NULL
AND sc.CCRId = @in_CCRId AND SC.AppTypeId not in(13, 88,84)
		insert into  #tmpClientRemoteCachePairs
		SELECT DISTINCT sc.subclientid, sc.ClientId ,  pa.RemoteClientId as remotecache
		FROM CCRToSubClient(nolock) AS sc INNER JOIN #tmpClientRemoteCachePairsAll(nolock)   AS pa ON
pa.ClientId =  sc.ClientId AND sc.CCRId = @in_CCRId AND SC.AppTypeId not in(13, 88,84)
		LEFT OUTER JOIN #tmpClientRemoteCachePairs existing ON existing.subclientId = sc.subclientid AND existing.ClientId = sc.ClientId
		AND pa.ClientId = existing.AssociateremotecacheClientId
		where existing.subclientId is null
		insert into #tmpClientDDBMAPairs
			SELECT DISTINCT sc.subclientid, sc.clientId,  IdxSS.ClientId as ddbMAid,0
			FROM CCRToSubClient(nolock) AS sc INNER JOIN app_application(nolock)   AS AA ON
aa.id=sc.subclientid AND sc.CCRId = @in_CCRId AND SC.AppTypeId not in(13, 88,84)
				INNER JOIN #tempSubclientProp prop with (readuncommitted)  ON
				sc.subClientId = prop.subClientId
				and prop.Deduplication =1
				INNER JOIN archGroup(nolock) AG ON AA.dataArchGrpId = AG.id
				INNER JOIN archSubclientCopyDDBMap CSD WITH (READUNCOMMITTED) ON CSD.copyID = AG.defaultCopy AND CSD.appId = SC.subClientId
				INNER JOIN  IdxSIDBSubStore(nolock) IdxSS ON CSD.SIDBStoreId = IdxSS.SIDBStoreId
				LEFT OUTER JOIN MMDataPath MD ON  MD.CopyId = AG.defaultCopy AND IdxSS.ClientId = MD.HostClientId
				where  IdxSS.ClientId <> sc.clientId AND MD.HostClientId IS null
				AND CSD.SIDBStoreId > 0
		update tp
		set poweredOffMA = 1
		from #tmpClientDDBMAPairs  as tp
		INNER JOIN MMHost as MH WITH (READUNCOMMITTED)
ON MH.ClientId =tp.MAClientId AND (MH.Attribute & 32768) = 32768	AND MH.OfflineReason=7
		IF object_id('tempdb.dbo.#tempSubclientProp') IS NOT NULL drop table #tempSubclientProp
	-- Step 11: Client To ddbMA
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag | 64
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK) ON CCRSC.AppTypeId not in(13) AND 	CCRSC.clientId = CCRCC.fromClientId and
															CCRCC.flag = 0 and CCRCC.IsDip =0 and CCRCC.serviceType = 0
		INNER JOIN #tmpClientDDBMAPairs tp ON tp.clientId = CCRCC.fromClientId and tp.subclientId = CCRSC.subclientid and tp.MAClientId = CCRCC.toClientId  AND tp.poweredOffMA= 0
		INNER JOIN #tmpsimClient sub
		ON CCRCC.toClientId = sub.ClientId
		SET	@retVal = @@ERROR
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for Client To DDBMA'
		END
	-- Step 12: PROXY Client To ddbMA
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag | 65536
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN #tmpCCRsubClientProxyPairs A  ON A.ClientId  = CCRSC.ClientId  AND A.ClientAppType =CCRSC.AppTypeId AND A.subclientid = CCRSC.subclientid
		INNER JOIN #tmpClientProxyPairs proxy ON  CCRSC.AppTypeId  = proxy.ClientAppType AND CCRSC.clientId = proxy.ClientId AND A.instanceId = proxy.instanceId AND ( ( A.issubclientProxy= 0 AND proxy.subclientId = 0)  OR(A.issubclientProxy= 1 AND A.subclientid= proxy.subclientid))
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK) ON 	proxy.proxyClientId =  CCRCC.fromClientId and
															CCRCC.flag = 0 and CCRCC.IsDip =0 and CCRCC.serviceType = 0
		INNER JOIN #tmpClientDDBMAPairs tp ON tp.clientId =  CCRSC.clientId and tp.subclientId = CCRSC.subclientid and tp.MAClientId = CCRCC.toClientId AND tp.poweredOffMA= 0
		INNER JOIN #tmpsimClient sub
		ON CCRCC.toClientId = sub.ClientId
		SET	@retVal = @@ERROR
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for proxy Client To DDBMA'
		END
		-- Step 13: ddbMA to Client
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag | 128
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK) ON CCRSC.AppTypeId not in(13) AND CCRSC.clientId = CCRCC.toClientId
												AND CCRCC.flag = 0 and CCRCC.IsDip =0 and CCRCC.serviceType = 0
		INNER JOIN #tmpClientDDBMAPairs tp ON tp.clientId = CCRCC.toClientId  and tp.subclientId = CCRSC.subclientid and tp.MAClientId = CCRCC.fromClientId AND tp.poweredOffMA= 0
		INNER JOIN #tmpsimClient sub
		ON CCRCC.toClientId = sub.ClientId
		SET	@retVal = @@ERROR
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for ddbMA To Client'
		END
		-- Step 14: ddbMA to proxy Client
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag | 131072
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN #tmpCCRsubClientProxyPairs A  ON A.ClientId  = CCRSC.ClientId  AND A.ClientAppType =CCRSC.AppTypeId AND A.subclientid = CCRSC.subclientid
		INNER JOIN #tmpClientProxyPairs proxy ON  CCRSC.AppTypeId  = proxy.ClientAppType AND CCRSC.clientId = proxy.ClientId AND A.instanceId = proxy.instanceId AND ( ( A.issubclientProxy= 0 AND proxy.subclientId = 0)  OR(A.issubclientProxy= 1 AND A.subclientid= proxy.subclientid))
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK) ON  proxy.proxyClientId = CCRCC.toClientId
												AND CCRCC.flag = 0 and CCRCC.IsDip =0 and CCRCC.serviceType = 0
		INNER JOIN #tmpClientDDBMAPairs tp ON tp.clientId = CCRCC.toClientId  and tp.subclientId = CCRSC.subclientid and tp.MAClientId = CCRCC.fromClientId AND tp.poweredOffMA= 0
		INNER JOIN #tmpsimClient sub
		ON CCRCC.toClientId = sub.ClientId
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag | 1048576
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN  #tmpClientDDBMAPairs tp ON tp.clientId = CCRSC.ClientId  and tp.subclientId = CCRSC.subclientid
		AND tp.poweredOffMA= 1
		SET	@retVal = @@ERROR
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for ddbMA To proxy Client'
		END
		drop table #tmpClientDDBMAPairs
		-- Step 15: proxy client to proxy Client
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag | 262144
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN #tmpCCRsubClientProxyPairs A  ON A.ClientId  = CCRSC.ClientId  AND A.ClientAppType =CCRSC.AppTypeId AND A.subclientid = CCRSC.subclientid
		INNER JOIN #tmpProxyPairs proxy ON  CCRSC.AppTypeId  = proxy.ClientAppType AND CCRSC.clientId = proxy.ClientId  AND A.instanceId = proxy.instanceId AND ( ( A.issubclientProxy= 0 AND proxy.subclientId = 0)  OR(A.issubclientProxy= 1 AND A.subclientid= proxy.subclientid))
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK) ON 	proxy.proxyDestinationClientId = CCRCC.toClientId and
															   proxy.proxySourceClientId = CCRCC.fromClientId and CCRCC.flag = 0 and CCRCC.IsDip =0 and	CCRCC.serviceType = 0
		INNER JOIN #tmpsimClient sub ON CCRCC.toClientId = sub.ClientId
		SET	@retVal = @@ERROR
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for  proxy Client To proxy Client'
		END
			IF object_id('tempdb.dbo.#tmpProxyPairs') IS NOT NULL drop table #tmpProxyPairs
		IF object_id('tempdb.dbo.#tmpClientProxyPairs') IS NOT NULL drop table #tmpClientProxyPairs
		IF object_id('tempdb.dbo.#tmpCCRsubClientProxyPairs') IS NOT NULL drop table #tmpCCRsubClientProxyPairs
		IF object_id('tempdb.dbo.#tmpMADDBMAPairs') IS NOT NULL drop table #tmpMADDBMAPairs
		create table #tmpMADDBMAPairs(
								subclientid			integer,
								MAClientId			integer,
								DDBMAClientId		integer
								)
		insert into #tmpMADDBMAPairs
		SELECT distinct sc.subclientid,DP.HostClientId, IdxSS.ClientId  FROM
		CCRToSubClient(nolock) AS sc INNER JOIN app_application(nolock)   AS AA ON
aa.id=sc.subclientid AND sc.CCRId = @in_CCRId AND SC.AppTypeId not in(13, 88,84)
			INNER JOIN archGroup(nolock) AG ON AA.dataArchGrpId = AG.id
			INNER JOIN archSubclientCopyDDBMap CSD WITH (READUNCOMMITTED) ON CSD.copyID = AG.defaultCopy AND CSD.appId = SC.subClientId
			INNER JOIN  IdxSIDBSubStore(nolock) IdxSS ON CSD.SIDBStoreId = IdxSS.SIDBStoreId
			INNER JOIN MMDatapath(nolock) DP ON DP.CopyId = AG.defaultCopy and sc.DataPathId = dp.DataPathId
			WHERE
			 IdxSS.ClientId <> DP.HostClientId
			AND CSD.SIDBStoreId > 0
			AND IdxSS.SIDBStoreId in
					(SELECT SIDBStoreId FROM IdxSIDBSubStore (nolock)
						GROUP BY SIDBStoreId
						HAVING COUNT(SubStoreId) > 1)
		--tmpMADDBMAPairs
		DELETE tp
		FROM #tmpMADDBMAPairs tp
		INNER JOIN  MMHost as MH WITH (READUNCOMMITTED)
		ON tp.MAClientId = MH.ClientId
WHERE (MH.Attribute & 32768) = 32768	AND MH.OfflineReason=7
		DELETE tp
		FROM #tmpMADDBMAPairs tp
		INNER JOIN  MMHost as MH WITH (READUNCOMMITTED)
		ON tp.DDBMAClientId = MH.ClientId
WHERE (MH.Attribute & 32768) = 32768	AND MH.OfflineReason=7
		-- Step 16: MA To ddbMA
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag | 512
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN #tmpMADDBMAPairs tp WITH (NOLOCK) ON CCRSC.subclientid = tp.subclientid and CCRSC.AppTypeId not in(13)
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK) ON tp.DDBMAClientId = CCRCC.toClientId and 	CCRCC.flag = 0 and CCRCC.IsDip =0 and CCRCC.serviceType = 0
																AND tp.MAClientId = CCRCC.fromClientId
		INNER JOIN #tmpDataPath as mcf WITH (NOLOCK) ON mcf.DataPathId = CCRSC.DataPathId and mcf.HostClientId = tp.MAClientId  AND mcf.poweredOffMA= 0
		SET	@retVal = @@ERROR
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for Client To DDBMA'
		END
		-- Step 17: ddbMA to MA
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag | 256
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN #tmpMADDBMAPairs tp WITH (NOLOCK) ON CCRSC.subclientid = tp.subclientid and 	CCRSC.AppTypeId not in(13)
		INNER JOIN #tmpDataPath as mcf WITH (NOLOCK) ON mcf.DataPathId = CCRSC.DataPathId and mcf.HostClientId = tp.MAClientId AND mcf.poweredOffMA= 0
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK) ON  tp.DDBMAClientId = CCRCC.fromClientId and
		tp.MAClientId = CCRCC.toClientId and
		CCRCC.flag = 0 and CCRCC.IsDip =0 and
		CCRCC.serviceType = 0
		SET	@retVal = @@ERROR
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for ddbMA To Client'
		END
		drop table #tmpMADDBMAPairs
	-- Step 18: Client To remotecache
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag | 1024
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN #tmpClientRemoteCachePairs tp WITH (NOLOCK) ON  CCRSC.AppTypeId not in(13) AND tp.subclientId = CCRSC.subclientid
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK) ON  CCRSC.clientId = CCRCC.fromClientId and tp.clientId = CCRCC.fromClientId and
																tp.AssociateremotecacheClientId = CCRCC.toClientId and CCRCC.flag = 0 and CCRCC.IsDip =0 and CCRCC.serviceType = 0
		INNER JOIN #tmpsimClient sub ON CCRCC.toClientId = sub.ClientId
		SET	@retVal = @@ERROR
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for Client To remotecache'
		END
	-- Step 19: remotecache to Client
		update CCRSC
set CCRNetworkReadinessFlag = CCRNetworkReadinessFlag | 2048
		from #tmpCCRClientInputInternal as CCRSC
		INNER JOIN #tmpClientRemoteCachePairs tp WITH (NOLOCK) ON  CCRSC.AppTypeId not in(13) AND tp.subclientId = CCRSC.subclientid
		INNER JOIN CCRClientToClient as CCRCC WITH (NOLOCK) ON CCRSC.clientId = CCRCC.toClientId and tp.clientId = CCRCC.toClientId and tp.AssociateremotecacheClientId = CCRCC.fromClientId and
																CCRCC.flag = 0 and CCRCC.IsDip =0 and CCRCC.serviceType = 0
		INNER JOIN #tmpsimClient sub ON CCRCC.toClientId = sub.ClientId
		SET	@retVal = @@ERROR
		IF		(@retVal != 0)
		BEGIN
				SET @errorString = @errorString + 'Failed to update the CCRNetworkReadinessFlag for remotecache To Client'
		END
		drop table #tmpClientRemoteCachePairs
		drop table #tmpClientRemoteCachePairsAll
	END
	--Check the activity control to see if the activity at the subclient level is disabled.
	IF object_id('tempdb.dbo.#tblsubclients') is not null DROP TABLE #tblsubclients
	create table #tblsubclients	(clientId INT, AppTypeId INT,instanceId INT, subClientId INT)
	INSERT INTO #tblsubclients(clientId , AppTypeId ,instanceID,  subClientId )
		 --CommCell Level Bkp activity is disabled
   		 SELECT CCR.clientId,0 AS AppTypeId,JM.instanceID,0 AS subClientId FROM  JMJobAction AS JM WITH (READUNCOMMITTED)
		INNER JOIN CCRToSubClient as CCR   WITH (READUNCOMMITTED)
		ON CCR.CCRId =  @in_CCRId AND JM.OpType = 4 AND JM.Action = 1 AND
				  (JM.ClientId = 1  AND JM.instanceID = 1 AND JM.AppType = 0 AND JM.AppId = 1 AND JM.clientGroupId = 0)
		UNION
		 -- Client Group Level Bkp activity is disabled
		SELECT CCR.clientId,0 AS AppTypeId,JM.instanceID AS instanceID, 0 AS subClientId FROM  JMJobAction AS JM WITH (READUNCOMMITTED)
		INNER JOIN CCRToSubClient as CCR   WITH (READUNCOMMITTED)
		ON CCR.CCRId =  @in_CCRId AND JM.OpType = 4 AND JM.Action = 1 AND
		(JM.ClientId = 1 AND JM.AppType = 0  AND JM.instanceID = 1 AND JM.AppId = 1 AND JM.clientGroupId > 0
						AND JM.clientGroupId IN (select clientGroupId from APP_ClientGroupAssoc
						where clientId = CCR.clientId))
		UNION
		  -- Client Level Bkp activity is disabled
		SELECT CCR.clientId,0 AS AppTypeId,JM.instanceID,0 AS subClientId FROM  JMJobAction AS JM WITH (READUNCOMMITTED)
		INNER JOIN CCRToSubClient as CCR   WITH (READUNCOMMITTED)
		ON CCR.CCRId =  @in_CCRId AND JM.OpType = 4 AND JM.Action = 1 AND
		(CCR.ClientId = JM.ClientId AND JM.AppType = 0 AND JM.AppId = 1 AND JM.instanceID = 1)
		UNION
		-- AppType Level Bkp activity is disabled
		SELECT CCR.clientId,CCR.AppTypeId AS AppTypeId,JM.instanceID,0 AS subClientId FROM  JMJobAction AS JM WITH (READUNCOMMITTED)
		INNER JOIN CCRToSubClient as CCR   WITH (READUNCOMMITTED)
		ON CCR.CCRId =  @in_CCRId AND JM.OpType = 4 AND JM.Action = 1 AND
		(CCR.ClientId = JM.ClientId AND CCR.AppTypeId = JM.AppType AND JM.AppId = 1 AND JM.instanceID = 1)
		UNION
		   -- subClient Level Bkp activity is disabled
		SELECT CCR.clientId,CCR.AppTypeId AS AppTypeId,JM.instanceID,CCR.SubClientId AS subClientId FROM  JMJobAction AS JM WITH (READUNCOMMITTED)
		INNER JOIN CCRToSubClient as CCR   WITH (READUNCOMMITTED)
		ON CCR.CCRId =  @in_CCRId AND JM.OpType = 4 AND JM.Action = 1 AND
		(JM.ClientId = 1 AND CCR.SubClientId = JM.AppId AND JM.AppType = 0 AND CCR.subClientId != 1  AND JM.instanceID = 1)
       UNION
           -- instanceID Level Bkp activity is disabled
        SELECT CCR.clientId,CCR.AppTypeId AS AppTypeId,JM.instanceID,CCR.SubClientId AS subClientId FROM  JMJobAction AS JM WITH (READUNCOMMITTED)
        INNER JOIN APP_APPLICATION as A   WITH (READUNCOMMITTED)
        ON  JM.OpType = 4 AND JM.Action = 1 AND JM.APPID = 1 AND A.INSTANCE =JM.instanceID
        INNER JOIN CCRToSubClient as CCR   WITH (READUNCOMMITTED)
         ON   JM.clientGroupId = 0 AND JM.ClientId = 1 AND CCR.CCRId =  @in_CCRId AND CCR.SubClientId = A.ID AND JM.AppType = 0 AND CCR.subClientId != 1
	Update CCR
	  SET CCRNetworkReadinessFlag |= T.CCRNetworkReadinessFlag
	FROM CCRToSubClient AS CCR
	INNER JOIN #tmpCCRClientInputInternal T ON CCR.CCRId = @in_CCRId AND CCR.clientId = T.ClientId AND CCR.AppTypeId = T.AppTypeId AND CCR.subclientId = T.subclientid
	AND CCR.DataPathId = T.DataPathId AND T.CCRNetworkReadinessFlag > 0
	Update CCR
SET CCRResultFlag = CCRResultFlag | 64
	FROM CCRToSubClient AS CCR
	INNER JOIN APP_Application A  WITH (READUNCOMMITTED) ON A.ClientId  = CCR.ClientId  AND 	a.id=CCR.subclientid AND A.APPTYPEID =CCR.AppTypeId
	INNER JOIN #tblsubclients tmp ON
	CCR.CCRId =  @in_CCRId AND CCR.ClientId = tmp.ClientId
	AND ((CCR.AppTypeId = tmp.AppTypeId AND tmp.AppTypeId>0 ) OR (tmp.AppTypeId=0))
	AND ((A.instance = tmp.instanceID AND tmp.instanceID>0 ) OR (tmp.instanceID=1))
	AND ((CCR.SubClientId = tmp.SubClientId AND tmp.SubClientId>0 ) OR (tmp.SubClientId=0))
	DROP TABLE #tblsubclients
	update CCRSC
set CCRResultFlag = CCRResultFlag | 1
	from CCRToSubCLient as CCRSC
WHERE (CCRSC.CCRNetworkReadinessFlag & ( 1  +
2  +
4  +
8  +
16  +
32  +
64  +
128  +
256  +
512  +
1024  +
2048  +
4096  +
8192  +
16384  +
32768  +
65536  +
131072  +
262144  )
		) > 0
/*		update CCRSC
set CCRResultFlag = CCRResultFlag | 256
	from CCRToSubCLient as CCRSC
WHERE (CCRSC.CCRNetworkReadinessFlag & ( 524288  +
1048576)
		) > 0*/
	if(@in_UpdateCCREndTime > 0)
	BEGIN
		--Unix Time Stamp.
		update CCRCommCellReadiness
		set CCREndTime = datediff(second, '01/01/1970', GetUTCDate())
		where CCRId = @in_CCRId
	END
	select @retVal, @errorString
	IF object_id('tempdb.dbo.#tmpsimClient') IS NOT NULL drop table #tmpsimClient
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CCRUpdateFlagsByCCRId')
	delete from GxQscripts where name = 'CCRUpdateFlagsByCCRId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRUpdateFlagsByCCRId')
	delete from GXDBVersions where aliasname = 'CCRUpdateFlagsByCCRId'
GO

insert into GXDBVersions values(2, 'CCRUpdateFlagsByCCRId',  'v1.13.2.32.14.1', 'CCRUpdateFlagsByCCRId', 'v1.13.2.32.14.1')
GO

