

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCRMediaCapacity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCRMediaCapacity.sp,v $ $Id: CCRMediaCapacity.sp,v 1.84.12.11 2020/12/15 10:57:06 sjohnson Exp $";
--
--  +========================================================================+
--  | Stored Precedure: CCRMediaCapacity()
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CCRMediaCapacity')
BEGIN
	print '>>> Drop Stored Procedure: CCRMediaCapacity <<<'
	drop procedure CCRMediaCapacity
END
IF EXISTS (select * from GxQscripts where name='CCRMediaCapacity')
	delete from GxQscripts where name = 'CCRMediaCapacity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRMediaCapacity')
	delete from GXDBVersions where aliasname = 'CCRMediaCapacity'
GO
print '... Creating Procedure: CCRMediaCapacity'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CCRMediaCapacity
  @i_ccrID INTEGER
AS
  DECLARE @retVal INTEGER;
  DECLARE @errorString VARCHAR(1024);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/****************************************************************************************/
/************ Initialize and declare temparary variables ********************************/
/****************************************************************************************/
	DECLARE @startdate			datetime
	DECLARE @retValFlag			INTEGER
	DECLARE @l_appID				INTEGER
	IF EXISTS ( select * from sysobjects where name='#tmpbkpst' )
 		drop table #tmpbkpst
	IF EXISTS ( select * from sysobjects where name='#tmpcopylibrary' )
 		drop table #tmpcopylibrary
	IF EXISTS ( select * from sysobjects where name='#tmplibrarymountpath' )
 		drop table #tmplibrarymountpath
	IF EXISTS ( select * from sysobjects where name='#tmpDataPath' )
 		drop table #tmpDataPath
	DECLARE @cursor1			INTEGER
	SET @retVal = 0
	SET @retValFlag = 0
	SET @errorString = ''
	SET @cursor1 = 0
/****************************************************************************************/
/********************** Create temparary tables *****************************************/
/****************************************************************************************/
	create table #tmpbkpst
	(
		commCellId INT,
		jobId integer,
		appid	integer,
		bkplevel integer,
		copyid integer,
		startdate datetime,
		uncompbytes bigint,
		compbytes bigint,
		flag integer,
		dataWritten	bigint
	)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to create table #tmpbkpst'
			GOTO CX_ERROR_EXIT
	END
	create table #tmpcopylibrary
	(
		copyid integer,
		datapathid integer,
		libraryid integer,
		librarySubType integer,
		sparegroupid integer,
		freecapacity bigint,
		mediaagentid integer,
		drivepoolid integer,
		statusvector integer,
		librarytypeid integer,
		ActiveVolumeId	integer,
		MediagroupId	integer,
		OnlineDriveCount	integer,
		lowWaterMark		integer,
		libraryAttributes	integer
	)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to create table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	create table #tmplibrarymountpath
	(
		libraryid integer,
		mountpathid integer,
		mediaid integer,
		lowwatermark integer,
		highwatermark integer,
		reservedspace BIGINT,
		totalvaliddata bigint,
		statusvector integer,
		totalspacemb BIGINT,
		freespacemb BIGINT
	)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to create table #tmplibrarymountpath'
			GOTO CX_ERROR_EXIT
	END
	create table #tmpDataPath	(DataPathId		integer,
					 HostClientId		integer,
					 CopyId				integer,
					 SpareGroupId		integer,
					 DrivePoolId		integer)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to create table #tmpDataPath'
			GOTO CX_ERROR_EXIT
	END
	declare @appIdtbl table(appId	integer)
/****************************************************************************************/
/******************** Insert into temprary tables ***************************************/
/****************************************************************************************/
	insert into @appIdtbl
	SELECT	DISTINCT SubClientId
	FROM	CCRToSubClient WITH (READUNCOMMITTED)
	WHERE	CCRId = @i_ccrID
	and clientId not in (select PMClientID from APP_VMToPMMap) --skip physical clients readiness
	-- select Full,Incr,Diff for all appIds
	insert into #tmpbkpst
	select JB.commcellId,JB.jobId,JB.appId, JB.BkpLevel, JB.CopyId, DATEADD(second, JB.servstartdate, '01/01/1970'), JB.totalUncompBytes, JB.TotalCompBytes, 0, 0
	from @appIdTbl tt INNER JOIN JMBkpStats JB WITH (READUNCOMMITTED)
			ON tt.appId = JB.appId
		INNER JOIN (SELECT	appId,MAX(servStartDate) AS servStartDate
					FROM	JMBkpStats WITH (READUNCOMMITTED)
					WHERE	status=1 and bkplevel in (1,2,4,0x40 /*SYNTHETIC_FULL*/, 0x80 /*SYNTHETIC_FULL_AND_INCR*/, 0x4000 /*SYNTHETIC_FULL_AND_INCR_BEFORE*/) GROUP BY appId,bkpLevel)  T
			ON JB.appId = T.appId AND JB.servStartDate = T.servStartDate
	--update value of sizeonMedia
	-- use primary copy size first
	CREATE TABLE #JobSizeOnMedia (jobId INT, commCellId INT, sizeOnMedia BIGINT)
	INSERT INTO #JobSizeOnMedia (JobId,commcellId , sizeOnMedia)
		SELECT	S.jobId, S.commcellId ,SUM(S.sizeOnMedia)
		FROM	JMJobDataStats S WITH (READUNCOMMITTED)
				INNER JOIN #tmpbkpst B ON S.commcellId = B.commCellId and S.jobid = B.jobid
				INNER JOIN archGroup AG WITH (NOLOCK) ON S.archGrpId = AG.id
				and S.archGrpCopyId = AG.defaultCopy
				and S.status = 100 and S.disabled & 256 = 0
		GROUP BY S.jobId,S.commcellId
	UPDATE	B SET dataWritten = S.sizeOnMedia
	FROM #tmpbkpst B INNER JOIN #JobSizeOnMedia S
	ON 	S.commcellId = B.commCellId and S.jobid = B.jobid
	DROP TABLE #JobSizeOnMedia
	UPDATE	#tmpbkpst
	SET		dataWritten = X.sizeOnMedia
	FROM	(SELECT	T.jobid, T.commcellId, MAX(T.sizeOnMedia) AS sizeOnMedia
			FROM	(SELECT	S.jobid, S.commcellId, S.archGrpCopyId, SUM(S.sizeOnMedia) AS sizeOnMedia
					FROM	JMJobDataStats S WITH (READUNCOMMITTED), #tmpbkpst B
					WHERE	S.commcellId = B.commCellId and S.jobid = B.jobid and S.AuxCopyJobId = 0
					AND  B.dataWritten = 0
					GROUP BY S.jobid, S.commcellId, S.archGrpCopyId) AS T
			GROUP BY T.jobid, T.commcellId) AS X
	WHERE	#tmpbkpst.jobId = X.jobId AND #tmpbkpst.commCellId = X.commcellId
	AND  #tmpbkpst.dataWritten = 0
	UPDATE #tmpbkpst
	SET dataWritten = BS.totalBackupSize
	FROM JMBKPSTATS BS
			JOIN #tmpbkpst T
				ON BS.JOBID = T.JOBID AND BS.commCellId = T.commCellId
	WHERE T.dataWritten = 0
	-- delete Diff,Incr backups if full exists
	delete #tmpbkpst
	where (bkpLevel = 2 or bkpLevel = 4) and exists(select * from #tmpbkpst tt where tt.appId=#tmpbkpst.appId and bkpLevel in( 1,0x40 /*SYNTHETIC_FULL*/, 0x80 /*SYNTHETIC_FULL_AND_INCR*/, 0x4000 /*SYNTHETIC_FULL_AND_INCR_BEFORE*/))
	-- delete Diff backups if incrs exists
	delete #tmpbkpst
	where (bkpLevel = 4) and exists(select * from #tmpbkpst tt where tt.appId=#tmpbkpst.appId and bkpLevel = 2)
	delete from  #tmpbkpst where startdate <> (select MAX(startdate) from #tmpbkpst)
/****************************************************************************************/
/********************* Media capacity ****************************************/
/****************************************************************************************/
	insert into #tmpDataPath
	select distinct MD.DataPathId, MDP.ClientId, MD.CopyId, MD.SpareGroupId, MD.DrivePoolId
	From MMDrivePool as MDP WITH (READUNCOMMITTED), MMDataPath as MD WITH (READUNCOMMITTED)
	where MD.DrivePoolId > 0 AND MD.DrivePoolId = MDP.DrivePoolId
	-- for non magnetic
	insert into #tmpcopylibrary
	select distinct a.copyid, a.datapathid, b.libraryid, c.LibrarySubType, a.sparegroupid, 0, a.HostClientId, a.DrivePoolId, 0, c.librarytypeid, 0, 0, 0, 0, c.LibraryAttribute
	from #tmpDataPath a, MMSpareGroup b WITH (READUNCOMMITTED), MMLibrary c WITH (READUNCOMMITTED), CCRToSubClient d WITH (READUNCOMMITTED)
	where d.CCRId = @i_ccrID AND d.DataPathId = a.DataPathId
	and a.sparegroupid > 0
	and a.sparegroupid = b.sparegroupid
	and b.libraryid = c.libraryid
	and c.librarytypeid != 3
	and clientId not in (select PMClientID from APP_VMToPMMap) --skip physical clients readiness
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to insert into table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	-- for magnetic
	insert into #tmpcopylibrary
	select distinct a.copyid, a.datapathid, d.libraryid, d.LibrarySubType, 0, 0, a.HostClientId, a.DrivePoolId, 0, d.librarytypeid, 0, 0, 0, d.LowWaterMarkMB, d.LibraryAttribute
	from #tmpDataPath a, MMDrivePool b WITH (READUNCOMMITTED), MMMasterPool c WITH (READUNCOMMITTED),
	MMLibrary d WITH (READUNCOMMITTED), MMMountPath e WITH (READUNCOMMITTED), MMMediaSide f WITH (READUNCOMMITTED),
	MMMedia g WITH (READUNCOMMITTED), CCRToSubClient h WITH (READUNCOMMITTED)
	where h.CCRId = @i_ccrID AND h.DataPathId = a.DataPathId
	AND a.drivepoolid = b.drivepoolid
	and b.masterpoolid = c.masterpoolid
	and c.libraryid = d.libraryid
	and d.libraryid = g.libraryid
	and g.mediaid = f.mediaid
	and f.mediasideid = e.mediasideid
	and d.librarytypeid = 3
	and h.clientId not in (select PMClientID from APP_VMToPMMap) --skip physical clients readiness
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to insert into table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	insert into #tmplibrarymountpath
	select distinct a.libraryid, e.mountpathid, f.mediaid, d.LowWaterMarkMB, e.MaxDataToWriteMB, e.MagneticSpaceRsrvInMB, 0, 0, f.totalspacemb,	CASE WHEN e.MountPathTypeId !=7 THEN f.FreeBytesMB ELSE 9223372036854775807 END
	from #tmpcopylibrary a, MMDrivePool b WITH (READUNCOMMITTED), MMMasterPool c WITH (READUNCOMMITTED),
	MMLibrary d WITH (READUNCOMMITTED), MMMountPath e WITH (READUNCOMMITTED), MMMediaSide f WITH (READUNCOMMITTED),
	MMMedia g WITH (READUNCOMMITTED)
	where a.drivepoolid = b.drivepoolid
	and b.masterpoolid = c.masterpoolid
	and c.libraryid = g.libraryid
	and a.libraryid = d.libraryid
	and g.mediaid = f.mediaid
	and f.mediasideid = e.mediasideid
	and a.librarytypeid = 3
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmplibrarymountpath'
			GOTO CX_ERROR_EXIT
	END
	update #tmpcopylibrary
	set ActiveVolumeId = V.VolumeId,	MediagroupId = V.MediagroupId
	from MMVolume as V WITH (READUNCOMMITTED), ArchStream as AST WITH (READUNCOMMITTED), #tmpcopylibrary as tt,
	MMMediaGroup as MG WITH (READUNCOMMITTED)
	where LibraryTypeId <> 3 and tt.CopyId = AST.ArchGroupCopyId
	and AST.MediaGroupId = MG.MediaGroupId AND MG.DrivePoolId = tt.DrivePoolId
	AND AST.MediaGroupId = V.MediagroupId and V.VolumeFlags = 1
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	UPDATE	#tmpcopylibrary
SET	statusvector =  32
	where librarytypeid != 3
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	UPDATE	#tmpcopylibrary
SET	statusvector =  16| 4
	where librarytypeid = 3
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	-- get ma, library, drivepool online, and standalone media status
	UPDATE	T
SET	statusvector = statusvector | 1
	FROM #tmpcopylibrary T
	INNER JOIN MMHost as MH WITH (READUNCOMMITTED)
	ON T.mediaagentid = MH.ClientId
	WHERE MH.MmHostEnabled =1
AND ( MH.MmHostSoftState =1 OR ((MH.Attribute & 32768) = 32768	AND MH.OfflineReason=7))
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	-- library
	UPDATE	#tmpcopylibrary
SET	statusvector = statusvector | 2
	where libraryid in ( select LibraryId from MMLibrary WITH (READUNCOMMITTED)
						where LibrarySoftState = 1
						and LibraryEnabled = 1
						and LibraryBroken = 0
					)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	UPDATE	#tmpcopylibrary
SET	statusvector = statusvector | 4
	WHERE libraryid in (select LibraryId from MMLibraryController WITH (READUNCOMMITTED)
															where LibraryControllerSoftState = 1
															-- and LibraryControllerActive = 1
															-- and LibraryControllerAlive = 1
															and LibraryControllerEnabled = 1
						)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	-- drivepool
	UPDATE	#tmpcopylibrary
SET	statusvector = statusvector | 8
	WHERE drivepoolid in (select DrivePoolId from MMDrivePool WITH (READUNCOMMITTED)
							where DrivePoolSoftState = 1
							and DrivePoolEnabled = 1)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	-- Masterpool
	UPDATE	#tmpcopylibrary
SET	statusvector = statusvector | 256
	WHERE drivepoolid in (select DrivePoolId from MMDrivePool WITH (READUNCOMMITTED)
		where MasterPoolId in(select MasterPoolId from MMMasterPool WITH (READUNCOMMITTED)
		where MasterPoolSoftState = 1 and MasterPoolEnabled = 1))
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	--DriveAllocation policy on the masterPool
	UPDATE	#tmpcopylibrary
SET	statusvector = statusvector | 1024
	WHERE drivepoolid in (select DrivePoolId from MMDrivePool WITH (READUNCOMMITTED)
		where MasterPoolId in(select MasterPoolId from MMMasterPool WITH (READUNCOMMITTED)
		where MaxSwitchForHost <> 0))
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	-- drives
	UPDATE	tt
	SET	OnlineDriveCount = tmp.offline
	from
	(select  tt.LibraryId as LibraryId, count(*) as offline
		from MMDrive as MD WITH (READUNCOMMITTED)
		,MMMasterPool as MMP WITH (READUNCOMMITTED)
		,#tmpcopylibrary tt
		where MD.MasterPoolId = MMP.MasterPoolId and MD.DriveSoftState = 1
		and MD.DriveEnabled = 1 and MD.DriveBroken = 0
		and MD.CleaningRequired = 0
		and tt.LibraryId = MMP.LibraryId and tt.LibraryTypeId <> 3
		group by  tt.LibraryId
		 ) tmp,#tmpcopylibrary as tt
	where tt.LibraryId = tmp.LibraryId and tt.LibraryTypeId <> 3
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	UPDATE	#tmpcopylibrary
SET	statusvector = statusvector | 128
	WHERE (librarytypeid = 3) OR (librarytypeid != 3 and OnlineDriveCount <> 0)
		OR (librarySubType = 3 and libraryid in (select pool.LibraryId from MMMasterPool pool join MMDrive drive on pool.MasterPoolId = drive.MasterPoolId where OfflineReason IN(16, 17)) )
		--16 = DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER
		--17 = DRIVE_STATUS_USED_BY_ANOTHER_CS
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	-- stand alone media
	-- Get the active volume Id from the mediagroup table
	-- and then see if that is the media which is loaded into the drive.
	UPDATE	#tmpcopylibrary
SET	statusvector = statusvector | 16
	FROM	#tmpcopylibrary as tt
	WHERE tt.librarytypeid in (4, 5) and tt.ActiveVolumeId <> 0 and
	exists (select * from MMDrive as MD WITH (READUNCOMMITTED), MMDrivePool as MHDP WITH (READUNCOMMITTED), MMMedia as MM WITH (READUNCOMMITTED)
		where MHDP.DrivePoolId = tt.DrivePoolId AND MHDP.MasterPoolId = MD.MasterPoolId
		and MD.DriveOccupied = 1 and MD.MediaId > 0 AND MD.MediaId = MM.MediaId
		and (MD.MediaId in(select MediaId from MMVolume WITH (READUNCOMMITTED) where VolumeId = tt.ActiveVolumeId OR MediaGroupId = tt.MediaGroupId)
			OR MM.IsInMediaGroup = 0))
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	--If the media Group has no ActiveVolumeID set
	UPDATE	#tmpcopylibrary
SET	statusvector = statusvector | 16
	FROM	#tmpcopylibrary as tt
	WHERE tt.librarytypeid in (4, 5) and tt.ActiveVolumeId = 0 and
	exists (select * from MMDrive as MD WITH (READUNCOMMITTED), MMDrivePool as MHDP WITH (READUNCOMMITTED), MMMedia as MM WITH (READUNCOMMITTED)
		where MHDP.DrivePoolId = tt.DrivePoolId AND MHDP.MasterPoolId = MD.MasterPoolId
		and MD.DriveOccupied = 1 and
		((MD.MediaId > 0 and MD.MediaId = MM.MediaId and MM.MediaFlags = 1 and
		(MM.IsInMediaGroup > 0 and
		tt.mediaGroupId in (select mediagroupid from MMVolume WITH (READUNCOMMITTED) where mediaid = mm.mediaid AND VolumeFlags in(1, 7))) OR
		(MM.IsInMediaGroup = 0)) OR (MD.MediaId = 0)))
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	-- stand alone media
	UPDATE	#tmpcopylibrary
SET	statusvector = statusvector | 16
	WHERE librarytypeid not in (4, 5)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	-- mount path
	UPDATE	#tmplibrarymountpath
SET	statusvector = statusvector | 32
	WHERE	mountpathid in (select mp.mountpathid from MMMountPath mp WITH (READUNCOMMITTED)
						join MMMountPathToStorageDevice mmpsd WITH (READUNCOMMITTED) on mp.MountPathId = mmpsd.MountPathId
						join MMDevice md WITH (READUNCOMMITTED) on md.DeviceId = mmpsd.DeviceId
						where mp.IsEnabled = 1
							and mp.IsOffline = 0
							and md.DeviceEnabled = 1
							and md.DeviceBroken = 0
							AND mp.MountPathTypeId NOT IN ( 0, 1, 3, 6))
	--Need to handle old mount paths created in 8.0 or by EzOperation
	UPDATE  #tmplibrarymountpath
SET statusvector = statusvector | 32
    WHERE	mountpathid in (select mountpathid from MMMountPath WITH (READUNCOMMITTED)
                            where IsEnabled = 1
                            and IsOffline = 0
							AND MountPathTypeId IN ( 0, 1, 3, 6))
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmplibrarymountpath'
			GOTO CX_ERROR_EXIT
	END
	--Fix for an MR#81719: CommCell Readiness  incorrectly reports disabled for write
	--When there is at least one mountpath exists which is available to write
	--then the library is available.
	UPDATE	#tmplibrarymountpath
SET	statusvector = statusvector | 512
	WHERE LibraryId not in (select LibraryId from MMMountPath WITH (READUNCOMMITTED)
							where MaxConcurrentWriters > 0
							group by LibraryId
							having count(*) > 0)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmplibrarymountpath'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
	-- tape capacity
	--free capacity available for spare media
	UPDATE	#tmpcopylibrary
	SET	freecapacity = #temp.totFreeBytes
	FROM ( SELECT     isnull(sum(CAST(totalSpaceMB as bigint)), 0) as totFreeBytes,tt.datapathid as dataPathId
			FROM    MMMediaSide  as MMS WITH (READUNCOMMITTED) ,MMMedia as MM WITH (READUNCOMMITTED),MMVolume as MV WITH (READUNCOMMITTED) ,#tmpcopylibrary as tt
			WHERE  MMS.MediaId = MM.MediaId
			AND MM.SpareGroupId = tt.SpareGroupId
			AND MMS.MediaSideId = MV.MediaSideId
			AND tt.SpareGroupId > 0
			AND MM.MediaId = MV.MediaId
			AND MM.MediaLocation <> 3
	AND (MM.IsInMediaGroup = 0)
			AND tt.LibraryTypeId != 3
	and tt.LibraryId = MM.LibraryId
			AND (
					(MM.origCCcommCellID > 0 AND MM.origCCcommCellID = 2)
 				    OR (MM.origCCcommCellID > 0 AND MM.origCCcommCellID != 2
AND ((MM.Attributes & 268435456) != 0
OR (tt.LibraryAttributes & 32 != 0))
 					)
		                   OR MM.origCCcommCellID = 0
				)
			GROUP BY tt.datapathid
			)as #temp ,#tmpcopylibrary as tcl
	WHERE #temp.dataPathId=tcl.datapathid
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	--free capacity available for assigned media
	UPDATE	#tmpcopylibrary
	SET	freecapacity = freecapacity + #temp.totFreeBytes
	FROM ( SELECT     isnull(sum(CAST(freebytesmb as bigint)), 0) as totFreeBytes,tt.datapathid as dataPathId
			FROM    MMMediaSide  as MMS WITH (READUNCOMMITTED),MMMedia as MM WITH (READUNCOMMITTED),MMVolume as MV WITH (READUNCOMMITTED),#tmpcopylibrary as tt
			WHERE  MMS.MediaId = MM.MediaId
			AND MM.SpareGroupId = tt.SpareGroupId
			AND MMS.MediaSideId = MV.MediaSideId
			AND tt.SpareGroupId > 0
			AND MM.MediaId = MV.MediaId
			AND MM.MediaLocation <> 3
	AND  ((MM.IsInMediaGroup <> 0) AND MV.MediaGroupId = tt.MediaGroupId)
			AND tt.LibraryTypeId != 3
	and tt.LibraryId = MM.LibraryId
			AND (
					(MM.origCCcommCellID > 0 AND MM.origCCcommCellID = 2)
 				    OR (MM.origCCcommCellID > 0 AND MM.origCCcommCellID != 2
AND ((MM.Attributes & 268435456) != 0
OR (tt.LibraryAttributes & 32 != 0))
 					)
		                   OR MM.origCCcommCellID = 0
				)
			GROUP BY tt.datapathid
			)as #temp ,#tmpcopylibrary as tcl
	WHERE #temp.dataPathId=tcl.datapathid
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	UPDATE      #tmplibrarymountpath
	SET         totalvaliddata = dbo.MMS2FUNC_GetMediaValidData(MediaId)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmplibrarymountpath'
			GOTO CX_ERROR_EXIT
	END
	UPDATE	#tmplibrarymountpath
SET	statusvector = statusvector | 64
	WHERE  ( (highwatermark > 0)
		  and
                 (totalvaliddata/(1024*1024)) > highwatermark
	       )
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmplibrarymountpath'
			GOTO CX_ERROR_EXIT
	END
	UPDATE	#tmplibrarymountpath
SET	statusvector = statusvector | 64
	WHERE  freespacemb = 0
	AND libraryId NOT IN (
	SELECT libraryId FROM MMMountPath e WITH (READUNCOMMITTED)
	WHERE e.LibraryId = libraryid
AND e.MountPathName = 'CVDiskFolder')
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmplibrarymountpath'
			GOTO CX_ERROR_EXIT
	END
	UPDATE	T
	SET T.freecapacity =SUB.freecapacity
	FROM #tmpcopylibrary T
	INNER JOIN (SELECT t.libraryid,ISNULL(SUM(highwatermark - totalvaliddata/(1024*1024) - reservedspace),0) AS freecapacity FROM #tmplibrarymountpath	t INNER JOIN MMMountPath AS MM WITH (READUNCOMMITTED)
					ON t.MountPathId = MM.MountPathId
					AND mm.MountPathTypeId !=7
					AND t.highwatermark > 0
AND (statusvector & 64) = 0
AND (statusvector & 32) = 32
					GROUP BY T.libraryid )  SUB
	 ON T.libraryid = SUB.libraryid
	 AND T.sparegroupid = 0
	UPDATE	T
	SET T.freecapacity = T.freecapacity+ SUB.freecapacity
	FROM #tmpcopylibrary T
	INNER JOIN (SELECT t.libraryid,ISNULL(SUM(t.freespacemb - t.reservedspace),0) AS freecapacity FROM #tmplibrarymountpath	t INNER JOIN MMMountPath AS MM WITH (READUNCOMMITTED)
					ON t.MountPathId = MM.MountPathId
					AND mm.MountPathTypeId !=7
					AND t.highwatermark <= 0
					and MM.MaxConcurrentWriters > 0
AND (statusvector & 64) = 0
AND (statusvector & 32) = 32
					GROUP BY T.libraryid )  SUB
	 ON T.libraryid = SUB.libraryid
	 AND T.sparegroupid = 0
	UPDATE	T
	SET T.freecapacity = SUB.freecapacity
	FROM #tmpcopylibrary T
	INNER JOIN (SELECT t.libraryid,MAX(t.freespacemb ) AS freecapacity FROM #tmplibrarymountpath	t INNER JOIN MMMountPath AS MM WITH (READUNCOMMITTED)
					ON t.MountPathId = MM.MountPathId
					AND mm.MountPathTypeId =7
AND (statusvector & 64) = 0
AND (statusvector & 32) = 32
					GROUP BY T.libraryid )  SUB
	 ON T.libraryid = SUB.libraryid
	 AND T.sparegroupid = 0
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	UPDATE	#tmpcopylibrary
	SET	statusvector = a.statusvector | b.statusvector
	from #tmpcopylibrary a, #tmplibrarymountpath b
	where a.libraryid = b.libraryid
and ((b.statusvector & 32) > 0
OR (b.statusvector & 64) > 0
OR (b.statusvector & 512) > 0)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	UPDATE	#tmpcopylibrary
SET	statusvector = statusvector | 64
	WHERE  freecapacity = 0 OR freecapacity <= lowWaterMark
	AND libraryId NOT IN (
	SELECT libraryId FROM MMMountPath e WITH (READUNCOMMITTED)
	WHERE e.LibraryId = libraryid
AND e.MountPathName = 'CVDiskFolder')
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	UPDATE	#tmpcopylibrary
SET statusvector = statusvector | 2048
WHERE LibraryId In (select LibraryId from MMLibrary WITH (READUNCOMMITTED) where (ExtendedAttributes & 512) > 0)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
	UPDATE	#tmpcopylibrary
SET statusvector = statusvector | 2048
WHERE mediaagentid In (select ClientId from MMHost WITH (READUNCOMMITTED) where (Attribute & 16) > 0)
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table #tmpcopylibrary'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
	UPDATE	MMDataPath
	SET		ReadinessFlag = T.statusvector
	FROM	MMDataPath MD
		INNER JOIN #tmpcopylibrary T
			ON MD.DataPathId = T.datapathid
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table MMDataPath'
			GOTO CX_ERROR_EXIT
	END
	Update CCR
set CCRResultFlag = CCRResultFlag | 128,
CCRResourceReadinessFlag = CCRResourceReadinessFlag | 16
	from CCRToSubClient as CCR WITH (READUNCOMMITTED)
	INNER JOIN APP_Client AC WITH (READUNCOMMITTED)
	ON CCR.CCRId =  @i_ccrID AND CCR.ClientId = AC.Id AND AC.spaceCheckFlags > 0
	and CCR.ClientId NOT IN (SELECT PMClientID FROM APP_VMToPMMap)
	UPDATE	CCRToSubClient
SET		CCRResultFlag = CCRResultFlag | 2
	WHERE	DataPathId IN (SELECT datapathid FROM #tmpcopylibrary
WHERE (statusvector & (1+2+4+8+128+256+1024)) != (1+2+4+8+128+256+1024)
OR    ( (statusvector & 16) = 0
									AND (librarytypeid in (4, 5)) )
OR    ( (statusvector & 32) != 32
									AND librarytypeid = 3 )
OR    ( (statusvector & 64) = 64)
OR    ( (statusvector & 512) = 512
									AND librarytypeid = 3 )
OR	  ( (statusvector & (2048 | 4096)) > 0 )
						  )
			AND CCRId = @i_ccrID
			and clientId not in (select PMClientID from APP_VMToPMMap) --skip physical clients readiness
	SELECT	@retVal = @@ERROR
	IF		@retVal != 0
	BEGIN
			SET @errorString = 'Failed to update table CCRToSubClient'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
	--Update the info in CCRToSubClient table
	update CCRToSubClient
	set lastUnCompBytes = a.uncompbytes, lastCompBytes = a.compbytes, capacityAvailable =  b.freecapacity, dataWritten = a.dataWritten
	from #tmpbkpst a, #tmpcopylibrary b, CCRToSubClient as c WITH (READUNCOMMITTED)
	where a.appid = c.SubClientId and b.datapathid = c.DataPathId and c.CCRId  = @i_ccrID
		and clientId not in (select PMClientID from APP_VMToPMMap) --skip physical client resource readiness
	--For stand alone Drives where there is no media inside the drive,
	-- The capacity is set to zero. So, set it to last UnCompressed Bytes,
	-- so that we will not say the Capacity is low.
	update CCRToSubClient
	set capacityAvailable = (lastUnCompBytes/1024)
	from #tmpbkpst a, #tmpcopylibrary b, CCRToSubClient as c WITH (READUNCOMMITTED)
	where a.appid = c.SubClientId and b.datapathid = c.DataPathId and c.CCRId  = @i_ccrID
	and b.librarytypeid in(4,5) and c.capacityAvailable = 0
	and clientId not in (select PMClientID from APP_VMToPMMap) --skip physical client resource readiness
	-- update capacity for subclient which are part of this CCR and not updated yet
	update CCRToSubClient
	set capacityAvailable = case when b.librarytypeid in(4,5) then (lastUnCompBytes/1024) else b.freecapacity end
	FROM #tmpcopylibrary b INNER JOIN CCRToSubClient as c WITH (READUNCOMMITTED)
	ON b.datapathid = c.DataPathId and c.CCRId  = @i_ccrID
	and c.capacityAvailable = 0
	and clientId not in (select PMClientID from APP_VMToPMMap) --skip physical client resource readiness
	--CapacityAvaiable should be checked against the dataWritten column instead of uncompbytes/compbytes
	update CCRToSubClient
set CCRResultFlag = CCRResultFlag | 2
	where CCRId = @i_ccrID AND CapacityAvailable > 0
	AND dataWritten > 0
	AND (CapacityAvailable < (dataWritten / (1024 * 1024)))
	and clientId not in (select PMClientID from APP_VMToPMMap) --skip physical client resource readiness
	--Update CCRResultFlag if invalid data path is configured
	update CCRToSubClient
set CCRResultFlag = CCRResultFlag | 2
where CCRId = @i_ccrID AND CCRResourceReadinessFlag & 8192 > 0
	--As Reosurce readiness check is the last check to be done as part of the
	--CommCellreadiness check, so update the CCREndTime with the current time
	--before returning
	--Unix Time Stamp.
	update CCRCommCellReadiness
	set CCREndTime = datediff(second, '01/01/1970', GetUTCDate())
	where CCRId = @i_ccrID
	select @retVal, @errorString
--  	:into retVal, errorString	--skip for mssql7--
	from #tmpbkpst a, #tmpcopylibrary b
	where a.copyid = b.copyid
--  	return	--skip for mssql7--
/****************************************************************************************/
/**************** Drop temparary table **************************************************/
/****************************************************************************************/
CX_ERROR_EXIT:
	DROP TABLE #tmpbkpst
	DROP TABLE #tmpcopylibrary
	DROP TABLE #tmplibrarymountpath
	DROP TABLE #tmpDataPath
	IF @cursor1 = 1
	BEGIN
			CLOSE		findLast
			DEALLOCATE	findLast
	END
GO

IF EXISTS (select * from GxQscripts where name = 'CCRMediaCapacity')
	delete from GxQscripts where name = 'CCRMediaCapacity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRMediaCapacity')
	delete from GXDBVersions where aliasname = 'CCRMediaCapacity'
GO

insert into GXDBVersions values(2, 'CCRMediaCapacity',  '00010084001200110000', 'CCRMediaCapacity', '00010084001200110000')
GO

