

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCRGetWebServerWebConsoleUrl.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCRGetWebServerWebConsoleUrl.sp,v $ $Id: CCRGetWebServerWebConsoleUrl.sp,v 1.1.2.3 2020/04/02 18:53:54 samrutkar Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "CCRGetWebServerWebConsoleUrl"								|
--	|																		|
--	|THIS PROCEDURE WILL TEST TO SEE IF THE STRING "NEWSTRING" IS ALREADY A	|
--	| NAME IN THE TABLE, AND IF NOT INSERTS IT BEFORE RETURNING ALL ROWS 	|
--	| THAT MATCH THE SEARCH CRITERIA "ID < compVal".						|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A STORED PROCEDURE		|
--	| AND RETURNING RESULTS	                                                |
--  | Tinku:CCM:Archive File Id's are no longer unique						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCRGetWebServerWebConsoleUrl')
BEGIN
	print '>>> Drop Stored Procedure: CCRGetWebServerWebConsoleUrl <<<'
	drop procedure CCRGetWebServerWebConsoleUrl
END
IF EXISTS (select * from GxQscripts where name='CCRGetWebServerWebConsoleUrl')
	delete from GxQscripts where name = 'CCRGetWebServerWebConsoleUrl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRGetWebServerWebConsoleUrl')
	delete from GXDBVersions where aliasname = 'CCRGetWebServerWebConsoleUrl'
GO
print '... Creating Procedure: CCRGetWebServerWebConsoleUrl'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCRGetWebServerWebConsoleUrl
  @i_CCRID INTEGER
AS
  DECLARE @ClientId INTEGER
  DECLARE @WebUrl NVARCHAR(1024)
  DECLARE @IsWebServer INTEGER
IF OBJECT_ID ('tempdb..#WebServerList') IS NOT NULL DROP TABLE #WebServerList
CREATE TABLE #WebServerList (componentNameId INT,IISPort INT,ApachePort INT,name NVARCHAR(MAX),hostName NVARCHAR(MAX))
INSERT INTO #WebServerList
exec SimGetAvaliableDM2WebServers
IF OBJECT_ID('tempdb..#WebConsoleList') IS NOT NULL DROP TABLE #WebConsoleList
CREATE TABLE #WebConsoleList (clientId INT,WebConsoleUrl NVARCHAR(MAX))
INSERT INTO #WebConsoleList (clientId)
SELECT DISTINCT S.clientId FROM simInstalledPackages S
INNER JOIN CCRToSubclient CCR  ON CCR.clientId = S.clientId AND (@i_CCRID = 0  OR CCR.CCRId = @i_CCRID)
WHERE simPackageId IN  (1135,726)
	UPDATE W
	SET WebConsoleUrl = attrval+'/api/getoemid' from
	App_clientProp ACP
	INNER JOIN #WebConsoleList W ON W.clientId = ACP.componentNameId
	AND  attrName = 'WebURL' and attrVal IS NOT NULL
DECLARE @WebServerForExchange table (webServerId INT)
IF EXISTS (select 1 from CCRToSubclient where appTypeId = 137 AND ccrid = @i_ccrid)
BEGIN
	DECLARE @i_clientId INT
	DECLARE clientListCur CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR
SELECT DISTINCT clientId from CCRToSubclient where appTypeId = 137 AND ccrid = @i_ccrid
	OPEN clientListCur
	FETCH clientListCur into @i_clientId
	WHILE   @@FETCH_STATUS = 0
	BEGIN
		INSERT INTO @WebServerForExchange
		exec AppGetWebSearchServerClientId @i_clientId,0,0
		FETCH clientListCur into @i_clientId
	END
END
select DISTINCT componentNameId as 'ClientId',
'http://'+hostName+':'+CAST(IISPort AS NVARCHAR(MAX))+'/searchsvc/cvwebservice.svc/getoemid' AS 'WebUrl',1 AS 'IsWebServer'
from #WebServerList T
INNER JOIN CCRToSubclient CCR  ON CCR.clientId = T.componentNameId where (@i_CCRID = 0  OR CCR.CCRId = @i_CCRID)
UNION
select DISTINCT componentNameId as 'ClientId',
'http://'+hostName+':'+CAST(IISPort AS NVARCHAR(MAX))+'/searchsvc/cvwebservice.svc/getoemid' AS 'WebUrl',1 AS 'IsWebServer'
from #WebServerList T
INNER JOIN @WebServerForExchange CCR  ON CCR.webServerId = T.componentNameId
UNION
	select clientId as 'ClientId', WebConsoleUrl AS 'WebUrl',0 AS 'IsWebServer' from #WebConsoleList
IF OBJECT_ID ('tempdb..#WebServerList') IS NOT NULL DROP TABLE #WebServerList
IF OBJECT_ID('tempdb..#WebConsoleList') IS NOT NULL DROP TABLE #WebConsoleList

IF EXISTS (select * from GxQscripts where name = 'CCRGetWebServerWebConsoleUrl')
	delete from GxQscripts where name = 'CCRGetWebServerWebConsoleUrl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRGetWebServerWebConsoleUrl')
	delete from GXDBVersions where aliasname = 'CCRGetWebServerWebConsoleUrl'
GO

insert into GXDBVersions values(2, 'CCRGetWebServerWebConsoleUrl',  '00010001000200030000', 'CCRGetWebServerWebConsoleUrl', '00010001000200030000')
GO

