

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCRGetSpaceRequirements.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCRGetSpaceRequirements.sp,v $ $Id: CCRGetSpaceRequirements.sp,v 1.26.58.2 2018/03/20 19:51:06 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "CCRGetSpaceRequirements"						|
--	|																		|
--	|THIS PROCEDURE WILL TEST TO SEE IF THE STRING "NEWSTRING" IS ALREADY A	|
--	| NAME IN THE TABLE, AND IF NOT INSERTS IT BEFORE RETURNING ALL ROWS 	|
--	| THAT MATCH THE SEARCH CRITERIA "ID < compVal".						|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A STORED PROCEDURE		|
--	| AND RETURNING RESULTS	                                                |
--  | Tinku:CCM:Archive File Id's are no longer unique						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCRGetSpaceRequirements <<<'

IF EXISTS (select * from sysobjects where name='CCRGetSpaceRequirements')
	drop procedure CCRGetSpaceRequirements
IF EXISTS (select * from GxQscripts where name='CCRGetSpaceRequirements')
	delete from GxQscripts where name = 'CCRGetSpaceRequirements'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRGetSpaceRequirements')
	delete from GXDBVersions where aliasname = 'CCRGetSpaceRequirements'
GO
print '... Creating Procedure: CCRGetSpaceRequirements'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCRGetSpaceRequirements
  @i_CommCellId integer,
  @i_faliedCompOnly integer 
AS
  DECLARE @o_LibraryId integer
  DECLARE @o_LibraryName NVARCHAR(255)
  DECLARE @o_LibTypeId integer
  DECLARE @o_SpareGroupId integer
  DECLARE @o_SpareGroupName NVARCHAR(256)
  DECLARE @o_LowWaterMark integer
  DECLARE @o_HighWaterMark integer
  DECLARE @o_UsableSpareCount integer
  DECLARE @o_MountPathId integer
  DECLARE @o_MountPathName NVARCHAR(256)
  DECLARE @o_MaxDataToWriteMB BIGINT
  DECLARE @o_MagneticSpaceRsrvInMB BIGINT
  DECLARE @o_TotalSpaceMB BIGINT
  DECLARE @o_FreeBytesMB BIGINT
  DECLARE @o_NumSubrows integer
  DECLARE @o_MediaType integer
  DECLARE @o_deviceTypeId integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	create table #tmpSpaceReq
	(
		c_LibraryId				integer,
		c_LibraryName			nvarchar(255),
		c_LibTypeId				integer,
		c_SpareGroupId			integer,
		c_SpareGroupName		nvarchar(256),
		c_LowWaterMark			integer,
		c_HighWaterMark			integer,
		c_UsableSpareCount		integer,
		c_MountPathId			integer,
		c_MountPathName			nvarchar(256),
		c_MaxDataToWriteMB		BIGINT,
		c_MagneticSpaceRsrvInMB		BIGINT,
		c_TotalSpaceMB			BIGINT,
		c_FreeBytesMB			BIGINT,
		c_NumSubrows			integer,
		c_MediaType				integer,
		c_deviceTypeId			integer
	)
	insert into #tmpSpaceReq
	select ML.LibraryId, ML.AliasName, ML.LibraryTypeId, 0, '', 0, 0, 0, MMP.MountPathId,MMP.MountPathName, 0, 0, 0, 0, 0, 0, 0
	from MMLibrary as ML WITH (READUNCOMMITTED)inner join MMS2getMountPathNameGUIView  as MMP WITH (READUNCOMMITTED)
	on ML.LibraryId >0  AND LibraryTypeId = 3 AND ML.LibraryId=MMP.LibraryId
	inner join MMMountPath  as MP WITH (READUNCOMMITTED)
	 on MP.MountPathName not like 'CVDiskFolder'
	and MP.MountPathId = MMP.MountPathId
	--library without mountpath
	insert into #tmpSpaceReq
	select ML.LibraryId, ML.AliasName, ML.LibraryTypeId, 0, '', 0, 0, 0, -1,'N/A', 0, 0, 0, 0, 0, 0, 0
	from MMLibrary as ML WITH (READUNCOMMITTED)
	where ML.LibraryId > 0 AND LibraryTypeId = 3 AND ML.LibraryId not in( select LibraryId from MMMountPath WITH (READUNCOMMITTED))
	insert into #tmpSpaceReq
	select ML.LibraryId, ML.aliasName, ML.LibraryTypeId, SpareGroupId, SpareGroupName,
	LowwaterMark, HighwaterMark, 0, 0, '', 0, 0, 0, 0, 0, ML.defaultMediaTypeId, 0
	from MMSpareGroup as MS WITH (READUNCOMMITTED), MMLibrary as ML WITH (READUNCOMMITTED)
	where SpareGroupId > 0 AND SparegroupType IN(1, 2, 32)
	AND SpareGroupId > 0 AND MS.LibraryId = ML.LibraryId
	AND ML.LibraryTypeId IN(1, 2, 4, 5)
	--MR 46983: delete cleaning Media for VTL
	--DELETE #tmpSpaceReq FROM #tmpSpaceReq
	--WHERE c_MediaType = 8990 and c_SpareGroupName ='Cleaning Media'
	update #tmpSpaceReq
	SET c_UsableSpareCount = (Select count(*)
							From MMMedia as MM WITH (READUNCOMMITTED)
							WHERE MM.SpareGroupId = tt.c_SpareGroupId
							AND MM.IsInMediaGroup = 0 AND MM.MediaLocation IN(1,2))
	From #tmpSpaceReq as tt
	where tt.c_LibTypeId IN(1, 2, 4, 5)
	update #tmpSpaceReq
	SET c_MaxDataToWriteMB =(CASE WHEN MMP.MaxDataToWriteMB < 0 THEN MMS.TotalSpaceMB ELSE MMP.MaxDataToWriteMB END),
		c_MagneticSpaceRsrvInMB = MMP.MagneticSpaceRsrvInMB,
		c_TotalSpaceMB = MMS.TotalSpaceMB,
		c_FreeBytesMB = MMS.FreeBytesMB
	FROM	MMMountPath as MMP WITH (READUNCOMMITTED), MMMediaSide as MMS WITH (READUNCOMMITTED), MMMedia as MM WITH (READUNCOMMITTED)
      WHERE	MMP.MountPathId > 0 AND MMP.MediaSideId = MMS.MediaSideId AND MMS.MediaId = MM.MediaId
			  AND  #tmpSpaceReq.c_LibraryId = MMP.LibraryID AND #tmpSpaceReq.c_LibTypeId = 3
				AND #tmpSpaceReq.c_MountPathId=MMP.MountPathId AND  #tmpSpaceReq.c_LibraryId = MM.LibraryID
	IF (@i_faliedCompOnly = 1)
	BEGIN
delete #tmpSpaceReq where (c_LibTypeId = 3 AND c_FreeBytesMB >  c_MagneticSpaceRsrvInMB)  OR
(c_LibTypeId != 3 AND  c_UsableSpareCount > c_LowWaterMark)
	END
	update #tmpSpaceReq
	Set c_NumSubrows = (Select count(*) from #tmpSpaceReq as a
						where #tmpSpaceReq.C_LibraryId = a.C_LibraryId
						group by a.c_LibraryId)
	--get deviceType Id, MMMountPath::MountPathTypeId = 7( MOUNT_PATH_EXTERNAL_REMOTE_HOST)
	update #tmpSpaceReq
	Set c_deviceTypeId = ISNULL((select D.DeviceTypeId from MMDevice D WITH (READUNCOMMITTED), MMMountPathToStorageDevice SD WITH (READUNCOMMITTED), MMMountPath P WITH (READUNCOMMITTED)
						where SD.MountPathId = c_MountPathId AND D.DeviceId = SD.DeviceId AND P.MountPathId =c_MountPathId AND P.MountPathTypeId = 7 ),0)
	select c_LibraryId, c_LibraryName, c_LibTypeId, c_SpareGroupId, c_SpareGroupName,
	c_LowWaterMark, c_HighWaterMark, c_UsableSpareCount, c_MountPathId, c_MountPathName,
	c_MaxDataToWriteMB, c_MagneticSpaceRsrvInMB, c_TotalSpaceMB, c_FreeBytesMB, c_NumSubrows, c_MediaType, c_deviceTypeId
	from #tmpSpaceReq
	order by c_LibraryName, c_LibTypeId
	drop table #tmpSpaceReq
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CCRGetSpaceRequirements')
	delete from GxQscripts where name = 'CCRGetSpaceRequirements'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRGetSpaceRequirements')
	delete from GXDBVersions where aliasname = 'CCRGetSpaceRequirements'
GO

insert into GXDBVersions values(2, 'CCRGetSpaceRequirements',  '00010026005800020000', 'CCRGetSpaceRequirements', '00010026005800020000')
GO

