

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCRGetRemoteCachePairInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCRGetRemoteCachePairInfo.sp,v $ $Id: CCRGetRemoteCachePairInfo.sp,v 1.1.2.5 2018/07/05 16:33:10 nshah Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCRGetRemoteCachePairInfo <<<'

IF EXISTS (select * from sysobjects where name='CCRGetRemoteCachePairInfo')
	drop procedure CCRGetRemoteCachePairInfo
IF EXISTS (select * from GxQscripts where name='CCRGetRemoteCachePairInfo')
	delete from GxQscripts where name = 'CCRGetRemoteCachePairInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRGetRemoteCachePairInfo')
	delete from GXDBVersions where aliasname = 'CCRGetRemoteCachePairInfo'
GO
print '... Creating Procedure: CCRGetRemoteCachePairInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCRGetRemoteCachePairInfo
  @in_CCRId integer,
  @tableOutput NVARCHAR(MAX)
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @remoteClientreq INT = 1|2|4
IF object_id('tempdb.dbo.#tmpClientRemoteCachePairsinternal') IS NOT NULL drop table #tmpClientRemoteCachePairsinternal
create table #tmpClientRemoteCachePairsinternal(ClientId		integer,
						RemoteClientId			integer,
						RemoteClientCategory 			integer DEFAULT 0  --1 remoteclient, 4 LM
							)
	-- Get the Client and Remote Software cache pairs (if remote client and client is not same )
	IF (@remoteClientreq&1 =1)
	BEGIN
		insert into  #tmpClientRemoteCachePairsinternal
		SELECT DISTINCT cl.id, sc.id as remotecache,1
		FROM app_client(nolock) AS sc INNER JOIN patchUpdateAgentInfo(nolock)   AS pa ON
			pa.clientId=sc.id  and pa.isEnabled =1
			INNER JOIN APP_ClientProp prop with (readuncommitted)  ON
(cast(pa.id as varchar(255))=prop.attrval)
			and prop.attrName = 'UPDATE CACHE AGENT ID'  and prop.Modified = 0
			INNER JOIN APP_Client as cl WITH (READUNCOMMITTED) ON cl.Id = prop.componentNameId
			and pa.clientId <>cl.id
		LEFT OUTER JOIN #tmpClientRemoteCachePairsinternal existing ON existing.ClientId = sc.id AND existing.RemoteClientId = cl.id
			where existing.ClientId is null
	END
	-- Get the Laptop Client and  Edge Index Server (if remote client and client is not same )
	IF (@remoteClientreq&2 =2)
	BEGIN
		IF ((SELECT COUNT(CCR.SubClientId)  from CCRToSubClient CCR INNER JOIN APP_CLIENT  C ON C.ID  = CCR.ClientId AND CCR.CCRId = @in_CCRId  AND (C.status & 0x1000) > 0  )>0)
		BEGIN
			IF object_id('tempdb.dbo.#tmpClientLaptopEdgeIndexPairsAll') IS NOT NULL drop table #tmpClientLaptopEdgeIndexPairsAll
			CREATE TABLE #tmpClientLaptopEdgeIndexPairsAll(ClientId		integer,
								AssociateEdgeIndexServer	integer
								)
			insert into  #tmpClientLaptopEdgeIndexPairsAll
			SELECT DISTINCT
				SC.clientId as laptopClient,DM.ClientId  as indexserverClient
				FROM App_client CL
				INNER JOIN App_SyncCloudconfig SC (NOLOCK) ON cl.id = SC.clientId
				INNER JOIN App_SyncCloudfolder SF (NOLOCK)on SF.syncwebfolderid = SC.syncwebfolderid
				INNER JOIN APP_Application APP (NOLOCK)ON app.id = SC.subclientid
				INNER JOIN APP_EdgeDriveAssociation EA (NOLOCK)ON EA.clientid = APP.clientid
				INNER JOIN DM2Cloud CLD (NOLOCK) ON EA.entityId = CLD.pseudoClientId
				INNER JOIN DM2SearchServerCoreInfo DM (NOLOCK) ON CLD.CloudId = DM.CloudId
				WHERE (CL.status & 4096) >0 AND SC.synctype = 3 AND SF.flag & 0x10 = 0x10 AND EA.entitytype=3
			insert into  #tmpClientRemoteCachePairsinternal
			SELECT DISTINCT pa.clientId,  pa.AssociateEdgeIndexServer as remotecache, 2
			FROM CCRToSubClient(nolock) AS sc INNER JOIN #tmpClientLaptopEdgeIndexPairsAll(nolock)   AS pa ON
				pa.ClientId =  sc.ClientId AND sc.CCRId = @in_CCRId
			LEFT OUTER JOIN #tmpClientRemoteCachePairsinternal existing ON existing.ClientId = pa.clientId AND existing.RemoteClientId = pa.AssociateEdgeIndexServer
			where existing.ClientId is null
			IF object_id('tempdb.dbo.#tmpClientLaptopEdgeIndexPairsAll') IS NOT NULL drop table #tmpClientLaptopEdgeIndexPairsAll
		END
	END
	IF (@remoteClientreq&4 =4)
	BEGIN
		DECLARE @inputClient TABLE(clientId INT)
		INSERT @inputCLient
		--SELECT id FROM APP_CLient
		select distinct clientid
		from CCRToSubClient
		where CCRId = @in_CCRId
		DECLARE monPolCursor CURSOR FAST_FORWARD FOR
													SELECT monitorPolicyId
													FROM APP_MonitoringPolicy WITH(NOLOCK)
													WHERE status NOT IN (3,1) --filtering disabled and deleted
			DECLARE @monPolId INT
		DECLARE @clientInfo TABLE (monPolId INT, clientId INT, AnalyticsClientId INT)
		DECLARE @ApplicableAssocForMonitoringPolicy TABLE (clientId INT, isPackageInstalled INT, clientMangledHostName NVARCHAR(1024), randomGUID NVARCHAR(1024))
		OPEN monPolCursor
		FETCH NEXT FROM monPolCursor INTO @monPolId
		WHILE  @@FETCH_STATUS = 0
		BEGIN
				DELETE @ApplicableAssocForMonitoringPolicy
			INSERT @ApplicableAssocForMonitoringPolicy
				EXEC LMGetApplicableAssocForMonitoringPolicy  @monPolId, 0 , 1
				INSERT @clientInfo
				SELECT @monPolId, clientId, 0
				FROM @ApplicableAssocForMonitoringPolicy
				FETCH NEXT FROM monPolCursor INTO @monPolId
		END
		CLOSE monPolCursor
		DEALLOCATE  monPolCursor
		UPDATE C
		SET c.AnalyticsCLientId = CloudClient.ClientId
		FROM @clientInfo C, (SELECT SC.ClientId, cloudInfo.monitorPolicyId
											FROM (SELECT CONVERT(INT, attrVal ) cloudId, AM.monitorPolicyId
																FROM APP_MonitoringPolicy AM
																INNER JOIN APP_MonitoringPolicyProp AMP WITH(NOLOCK)
																ON AM.monitorPolicyId = AMP.monitorPolicyId
																WHERE AM.status NOT IN (1, 3) AND AMP.attrName = 'Cloud Id' AND CONVERT(INT, attrVal ) > 0 ) cloudInfo
												INNER JOIN DM2SearchServerCoreInfo SC WITH(NOLOCK)
														ON SC.CloudId = cloudInfo.cloudId
												INNER JOIN DM2CloudCoreRole CR WITH(NOLOCK)
														ON CR.cloudId = SC.CloudId
												WHERE CR.roleId = 3) CloudClient
		WHERE C.monPolId = CloudClient.monitorPolicyId
		--Deleting info for whihc cloud is deconfigured and we are not able to get the analyticsclient
		DELETE @clientInfo
		WHERE AnalyticsClientId = 0
		INSERT INTO #tmpClientRemoteCachePairsinternal(ClientId,RemoteClientId,RemoteClientCategory)
		SELECT DISTINCT A.clientId, AnalyticsClientId  ,4      FROM @clientInfo A INNER JOIN @inputClient  B  ON A.clientId = B.clientId
		LEFT OUTER JOIN #tmpClientRemoteCachePairsinternal existing ON existing.ClientId = B.clientId AND existing.RemoteClientId = A.AnalyticsClientId
			where existing.ClientId is null
	END
	IF (LEN(@tableOutput)>0)
	BEGIN
	  DECLARE @outputSQLStatement NVARCHAR(MAX)
	  SET @outputSQLStatement = 'INSERT INTO '+ @tableOutput +'(clientId, RemoteClientId,RemoteClientCategory) '
	  SET @outputSQLStatement += ' SELECT DISTINCT ClientId,RemoteClientId,RemoteClientCategory      FROM #tmpClientRemoteCachePairsinternal where ClientId !=RemoteClientId '
	  EXEC (@outputSQLStatement)
	 END
	 ELSE
	 BEGIN
		SELECT DISTINCT ClientId,RemoteClientId,RemoteClientCategory      FROM #tmpClientRemoteCachePairsinternal where ClientId !=RemoteClientId
	 END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CCRGetRemoteCachePairInfo')
	delete from GxQscripts where name = 'CCRGetRemoteCachePairInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRGetRemoteCachePairInfo')
	delete from GXDBVersions where aliasname = 'CCRGetRemoteCachePairInfo'
GO

insert into GXDBVersions values(2, 'CCRGetRemoteCachePairInfo',  '00010001000200050000', 'CCRGetRemoteCachePairInfo', '00010001000200050000')
GO

