

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCRGetProxyClientInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCRGetProxyClientInfo.sp,v $ $Id: CCRGetProxyClientInfo.sp,v 1.1.2.31 2019/04/13 03:30:28 dkraplanee Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "MMS2UpdateSlotNBayConfig"								|
--	|																		|
--	|THIS PROCEDURE WILL TEST TO SEE IF THE STRING "NEWSTRING" IS ALREADY A	|
--	| NAME IN THE TABLE, AND IF NOT INSERTS IT BEFORE RETURNING ALL ROWS 	|
--	| THAT MATCH THE SEARCH CRITERIA "ID < compVal".						|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A STORED PROCEDURE		|
--	| AND RETURNING RESULTS	                                                |
--  | Tinku:CCM:Archive File Id's are no longer unique						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCRGetProxyClientInfo')
BEGIN
	print '>>> Drop Stored Procedure: CCRGetProxyClientInfo <<<'
	drop procedure CCRGetProxyClientInfo
END
IF EXISTS (select * from GxQscripts where name='CCRGetProxyClientInfo')
	delete from GxQscripts where name = 'CCRGetProxyClientInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRGetProxyClientInfo')
	delete from GXDBVersions where aliasname = 'CCRGetProxyClientInfo'
GO
print '... Creating Procedure: CCRGetProxyClientInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCRGetProxyClientInfo
  @in_CCRId integer,
  @in_isaddResources integer,
  @tableOutput NVARCHAR(MAX)
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF object_id('tempdb.dbo.#tmpClientProxyPairsinternal') IS NOT NULL drop table #tmpClientProxyPairsinternal
create table #tmpClientProxyPairsinternal(ClientId		integer,
						instanceId			integer,
						proxyClientId			integer,
						ClientAppType				integer,
						isIndexServer				integer DEFAULT 0,  --0 meaning proxyclient, 1 meaning index server
						iscloudindexServer 	integer DEFAULT 0,    -- 1 meaning cloud index server
						cloudindexServer 	integer DEFAULT 0,
						isproxyclientGroup 	integer DEFAULT 0 , -- 1 meaning client Group
						clientGroup		 	integer DEFAULT 0,
						subclientId		 	integer DEFAULT 0
						)
-- Get the Client and proxy pairs here (AMAZON CLOUD)
IF ((SELECT COUNT(*) FROM CCRToSubClient WHERE appTypeId = 134  AND CCRId = @in_CCRId   )>0)
BEGIN
	IF object_id('tempdb.dbo.#tmpcloudproxyClientInfo') IS NOT NULL drop table #tmpcloudproxyClientInfo
	create table #tmpcloudproxyClientInfo(ClientId		integer,
					instanceId			integer,
					ClientAppType				integer,
					cloudAppsInstType	integer,
					ProxyClientXml XML
					)
	insert into #tmpcloudproxyClientInfo (ClientId,instanceId,ClientAppType)
	SELECT DISTINCT A.CLIENTID, A.INSTANCE ,C.appTypeId
	FROM APP_Application A (NOLOCK)
INNER JOIN CCRToSubClient C (NOLOCK) ON C.ClientId = A.CLIENTID AND C.appTypeId = 134   AND A.APPTYPEID = C.APPTYPEID AND C.CCRId = @in_CCRId
	And (A.subclientStatus & 6) = 0  	-- uninstalled OR deleted
	UPDATE C
	SET cloudAppsInstType = ISNULL(prop.attrVal, 0)
	FROM #tmpcloudproxyClientInfo C
	INNER JOIN APP_InstanceProp prop (NOLOCK)
	ON	prop.componentNameId = C.instanceId
	AND prop.attrName = 'Cloud Apps Instance Type'
	AND prop.modified = 0
	UPDATE C
	SET ProxyClientXml = ISNULL(prop.attrVal, '')
	FROM #tmpcloudproxyClientInfo C
	INNER JOIN APP_InstanceProp prop (NOLOCK)
	ON	prop.componentNameId = C.instanceId AND prop.modified = 0
	AND ((prop.attrName = 'Proxy Clients' AND C.cloudAppsInstType IN (1,2))
			OR (prop.attrName = 'Amazon S3 Proxy Clients' AND C.cloudAppsInstType =5)
			OR (prop.attrName = 'Azure Proxy Clients' AND C.cloudAppsInstType =6)
			OR (prop.attrName = 'Proxy Clients' AND C.cloudAppsInstType =7)
			OR (prop.attrName = 'Oracle Cloud Proxy Clients' AND C.cloudAppsInstType =14)
			OR (prop.attrName = 'Openstack Proxy Clients' AND C.cloudAppsInstType =15)
			OR (prop.attrName = 'Google Cloud Proxy Clients' AND C.cloudAppsInstType =20)
			OR (prop.attrName = 'Azure DL Proxy Clients' AND C.cloudAppsInstType =21)
			)
	UPDATE C
	SET ProxyClientXml = ISNULL(prop.attrVal, '')
	FROM #tmpcloudproxyClientInfo C
	INNER JOIN APP_InstanceProp prop (NOLOCK)
	ON	prop.componentNameId = C.instanceId AND prop.modified = 0
	AND (prop.attrName = 'Vs Member Servers' AND C.cloudAppsInstType =4)
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,instanceId,proxyClientId,ClientAppType)
	SELECT DISTINCT c.ClientId,C.instanceId, a.value('(@clientId)[1]', 'int') as proxy,C.ClientAppType
	FROM #tmpcloudproxyClientInfo C
	CROSS APPLY C.ProxyClientXml.nodes('App_GeneralCloudProperties/proxyServers') rc(a)
	WHERE
       a.value('@clientId', 'int') IS NOT NULL
	UNION
	SELECT distinct c.ClientId,C.instanceId, a.value('(@clientId)[1]', 'int') as proxy,C.ClientAppType
	FROM #tmpcloudproxyClientInfo C
	CROSS APPLY C.ProxyClientXml.nodes('App_MemberServers/memberServers/client') rc(a)
	WHERE
       a.value('@clientId', 'int') IS NOT NULL
	UNION
	SELECT c.ClientId, C.instanceId, cast(prop.attrVal as int ),C.ClientAppType
	FROM #tmpcloudproxyClientInfo C
		INNER JOIN APP_InstanceProp prop (NOLOCK)
		ON	prop.componentNameId = C.instanceId AND prop.modified = 0
		AND (prop.attrName = 'Salesforce backup client' AND C.cloudAppsInstType =3)
	DROP TABLE #tmpcloudproxyClientInfo
END
IF ((SELECT COUNT(*) FROM CCRToSubClient (NOLOCK) WHERE appTypeId = 64  AND CCRId = @in_CCRId   )>0)
			-- Get the Client and proxy pairs here (green plum ,HADOOP, GPFS, UXFS)
BEGIN
	IF object_id('tempdb.dbo.#tmpproxyClientInfo') IS NOT NULL drop table #tmpproxyClientInfo
	create table #tmpproxyClientInfo(ClientId		integer,
					instanceId			integer,
					ClientAppType				integer,
					DistributedAppsInstType	integer
					)
	insert into #tmpproxyClientInfo (ClientId,instanceId,ClientAppType)
	SELECT DISTINCT A.CLIENTID, A.INSTANCE,C.appTypeId
	FROM APP_Application A (NOLOCK)
INNER JOIN CCRToSubClient C (NOLOCK) ON C.ClientId = A.CLIENTID AND C.appTypeId = 64   AND A.APPTYPEID = C.APPTYPEID AND C.CCRId = @in_CCRId
	And (A.subclientStatus & 6) = 0 	-- uninstalled OR deleted
	UPDATE C
	SET DistributedAppsInstType = ISNULL(prop.attrVal, 0)
	FROM #tmpproxyClientInfo C
	INNER JOIN APP_InstanceProp prop (NOLOCK)
	ON	prop.componentNameId = C.instanceId
	AND prop.attrName = 'Distributed Cluster Type'
	AND prop.modified = 0
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,instanceId,proxyClientId,ClientAppType)
	SELECT DISTINCT tmp.ClientId,tmp.instanceId,CAST(prop.attrVal AS INT), tmp.ClientAppType FROM #tmpproxyClientInfo tmp
	INNER JOIN APP_InstanceProp prop (NOLOCK)
	ON	prop.componentNameId = tmp.instanceId
	AND prop.attrName = 'Greenplum Master Client Id'
	AND tmp.DistributedAppsInstType =1  --GREENPLUM
	AND prop.modified = 0
	UNION
	SELECT DISTINCT tmp.ClientId,tmp.instanceId,CAST(prop.attrVal AS INT),tmp.ClientAppType FROM #tmpproxyClientInfo tmp
	INNER JOIN APP_InstanceProp prop (NOLOCK)
	ON	prop.componentNameId = tmp.instanceId
	AND prop.attrName = 'Coordinator Node'
	AND tmp.DistributedAppsInstType <>1  --GREENPLUM
	AND prop.modified = 0
	IF object_id('tempdb.dbo.#tmpproxyClientXML') IS NOT NULL drop table #tmpproxyClientXML
	create table #tmpproxyClientXML(ClientId		integer,
				instanceId			integer,
				proxystandbyxml XML,
				ClientAppType				integer
				)
	INSERT INTO #tmpproxyClientXML (ClientId,instanceId,proxystandbyxml,ClientAppType)
	SELECT tmp.ClientId,tmp.instanceId,CAST ( substring (prop.attrVal, CHARINDEX('<App_DataAccessNodes>',prop.attrVal ), LEN(prop.attrVal)-CHARINDEX('<App_DataAccessNodes>',prop.attrVal) +1)  AS XML) ,A.APPTYPEID  FROM #tmpproxyClientInfo tmp
	INNER JOIN APP_Application A (NOLOCK)
ON	tmp.ClientId = A.CLIENTID AND A.APPTYPEID = 64
	INNER JOIN APP_SubClientProp prop (NOLOCK)
	ON	prop.componentNameId = A.ID
	AND prop.attrName = 'Data Access Nodes'
	AND tmp.DistributedAppsInstType <>1  ---HADOOP, GPFS, UXFS
	AND prop.modified = 0
	And (A.subclientStatus & 6) = 0 	-- uninstalled OR deleted
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,instanceId,proxyClientId,ClientAppType)
	SELECT distinct c.ClientId,C.instanceId, a.value('(@clientId)[1]', 'int') as proxy,C.ClientAppType
	FROM #tmpproxyClientXML C
	CROSS APPLY C.proxystandbyxml.nodes('App_DataAccessNodes/dataAccessNodes') rc(a)
	  WHERE
       a.value('@clientId', 'int') IS NOT NULL
END
IF ((SELECT COUNT(*) FROM CCRToSubClient (NOLOCK) WHERE appTypeId = 137  AND CCRId = @in_CCRId   )>0)
			-- Get the Client and proxy pairs here (EXCHANGE ONE PASS)
BEGIN
	IF object_id('tempdb.dbo.#tmpexchproxyClientxml') IS NOT NULL drop table #tmpexchproxyClientxml
	create table #tmpexchproxyClientxml(ClientId		integer,
					instanceId INT,
					AppsType	integer,
					ProxyClientXml XML
					)
	IF object_id('tempdb.dbo.#tmpexchproxyClientInfo') IS NOT NULL drop table #tmpexchproxyClientInfo
	create table #tmpexchproxyClientInfo(pseudoClientId		integer,
										instanceId INT,
										entityType integer,
										clientId integer ,
										clientgroupId integer,
										ClientAppType  integer
					)
	insert into #tmpexchproxyClientxml (ClientId,AppsType,instanceId)
	SELECT DISTINCT C.CLIENTID, C.appTypeId,A.instance
	FROM CCRToSubClient C (NOLOCK)
	INNER JOIN APP_Application A (NOLOCK)
	ON A.ID = C.SubClientId AND A.appTypeId =C.appTypeId
AND C.appTypeId = 137 AND C.CCRId = @in_CCRId
	 And (A.subclientStatus & 6) = 0  	-- uninstalled OR deleted
	UPDATE t
	SET ProxyClientXml = CAST ( substring (P.attrVal, CHARINDEX('<App_MemberServers>',P.attrVal ), LEN(P.attrVal)-CHARINDEX('<App_MemberServers>',P.attrVal) +1)  AS XML)
	FROM APP_IDAProp P (NOLOCK)
	INNER JOIN APP_IDAName N (NOLOCK) ON  P.componentNameId = N.id
	INNER JOIN #tmpexchproxyClientxml t (NOLOCK) ON  t.AppsType = N.appTypeId
	AND N.clientId = t.ClientId
	AND attrName = 'OnePass Member Servers' AND p.modified = 0
	INSERT INTO #tmpexchproxyClientInfo(pseudoClientId,entityType,clientId,clientgroupId,ClientAppType,instanceId)
	SELECT c.ClientId,
		ISNULL(a.value('@_type_', 'int'),0) ,
		ISNULL(a.value('@clientId', 'int'),0),
		ISNULL(a.value('@clientGroupId', 'int'),0),
		C.AppsType,
		C.instanceId
	FROM #tmpexchproxyClientxml C
	 CROSS APPLY C.ProxyClientXml.nodes('App_MemberServers/memberServers/client') rc(a)
	  WHERE
       a.value('@clientId', 'int') IS NOT NULL
	  OR a.value('@clientGroupId', 'int') IS NOT NULL
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT DISTINCT  c.pseudoClientId, C.clientId as proxy,C.ClientAppType,C.instanceId
	FROM #tmpexchproxyClientInfo C
	  WHERE
C.entityType = 3 AND  C.clientId>1
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,isproxyclientGroup,clientGroup,instanceId)
	SELECT DISTINCT  c.pseudoClientId, ACG.clientId as proxy,C.ClientAppType,1,ACG.clientGroupId,C.instanceId
	FROM #tmpexchproxyClientInfo C
	INNER JOIN APP_ClientGroupAssoc ACG
	ON  ACG.clientGroupId = C.clientgroupId
	INNER JOIN simInstalledPackages P
ON P.ClientId =  ACG.clientId AND P.simPackageID IN ( 152, 151 )
	  WHERE
C.entityType =28 and C.clientId = 0
	-- Backup Proxy List : So delete clients with deconfigured/deleted  agents.
	delete #tmpClientProxyPairsinternal where proxyClientId in (select E.proxyClientId from  #tmpClientProxyPairsinternal E,App_IdaName Ida WITH (READUNCOMMITTED) where
E.proxyClientId = Ida.clientId and Ida.appTypeId = 54 and (status & 6) > 0) and isproxyclientGroup>0
	if(@in_isaddResources=1)
	BEGIN
		IF object_id('tempdb.dbo.#tmpexchIndexServerInfo') IS NOT NULL drop table #tmpexchIndexServerInfo
		create table #tmpexchIndexServerInfo(pseudoClientId		integer,
									instanceId			integer,
									indexServer 	integer,
									iscloudindexServer 	integer
									)
		INSERT INTO #tmpexchIndexServerInfo(pseudoClientId,instanceId,indexServer,iscloudindexServer)
		 SELECT T.clientId ,T.instanceId,cast(attrVal as integer),1
				FROM  APP_iDAName N INNER JOIN #tmpexchproxyClientxml T  ON T.clientId = N.clientId
				INNER JOIN APP_IDAProp P ON N.apptypeId = T.AppsType AND P.componentNameId = N.id AND
				P.attrname = 'OnePass Index Server' AND P.modified = 0
		UPDATE I
		SET iscloudindexServer = 0
		FROM #tmpexchIndexServerInfo I
		INNER JOIN simInstalledPackages P
		ON P.ClientId = I.indexServer
		IF object_id('tempdb.dbo.#tmpexchIndexServerClient') IS NOT NULL drop table #tmpexchIndexServerClient
		create table #tmpexchIndexServerClient(pseudoClientId		integer,
									instanceId INTEGER,
									indexServer 	integer,
									iscloudindexServer 	integer,
									cloudindexServer 	integer
									)
		INSERT INTO #tmpexchIndexServerClient(pseudoClientId,instanceId,indexServer,iscloudindexServer,cloudindexServer)
		SELECT I.pseudoClientId,I.instanceId,I.indexServer,I.iscloudindexServer,0
		FROM #tmpexchIndexServerInfo I
		WHERE iscloudindexServer = 0
		UNION
		SELECT I.pseudoClientId,I.instanceId, DS.ClientId,I.iscloudindexServer,I.indexServer
		FROM DM2SearchServerCoreInfo DS
		INNER JOIN Dm2Cloud DC ON
		DS.cloudid = DC.cloudId
		INNER JOIN #tmpexchIndexServerInfo I ON
		I.indexServer  = DC.pseudoClientId
		AND I.iscloudindexServer =1
		update t
		SET T.isIndexServer =  1 ,
			T.iscloudindexServer = I.iscloudindexServer,
			T.cloudindexServer = I.cloudindexServer,
			T.isproxyclientGroup = 0,
			T.clientGroup =0
		FROM #tmpClientProxyPairsinternal T
		INNER JOIN  #tmpexchIndexServerClient I
		ON T.ClientId = I.pseudoClientId  AND T.proxyClientId = I.indexServer
		INSERT INTO #tmpClientProxyPairsinternal(ClientId,instanceId,proxyClientId,ClientAppType,isIndexServer,iscloudindexServer,cloudindexServer)
SELECT DISTINCT  I.pseudoClientId,I.instanceId,I.indexServer,137,1,I.iscloudindexServer,I.cloudindexServer
		 FROM #tmpexchIndexServerClient I
		 LEFT OUTER JOIN #tmpClientProxyPairsinternal T ON T.ClientId = I.pseudoClientId  AND T.proxyClientId = I.indexServer  AND T.instanceId = I.instanceId
		 WHERE T.proxyClientId IS NULL
		 drop table #tmpexchIndexServerInfo
		 drop table #tmpexchIndexServerClient
	 END
	 drop table #tmpexchproxyClientxml
	 drop table #tmpexchproxyClientInfo
END
IF ((SELECT COUNT(*) FROM CCRToSubClient (NOLOCK) WHERE appTypeId = 80  AND CCRId = @in_CCRId   )>0)
			-- Get the Client and proxy pairs here (CV_APPTYPE_ORACLE_RAC)
BEGIN
	IF object_id('tempdb.dbo.#tmporacleRACClientInfo') IS NOT NULL drop table #tmporacleRACClientInfo
	create table #tmporacleRACClientInfo(ClientId		integer,
					instanceId			integer,
					ClientAppType				integer
					)
	insert into #tmporacleRACClientInfo (ClientId,instanceId,ClientAppType)
	SELECT DISTINCT A.CLIENTID, A.INSTANCE,C.appTypeId
	FROM APP_Application A (NOLOCK)
INNER JOIN CCRToSubClient C (NOLOCK) ON C.ClientId = A.CLIENTID AND C.appTypeId = 80   AND A.APPTYPEID = C.APPTYPEID AND C.CCRId = @in_CCRId
	And (A.subclientStatus & 6) = 0 	-- uninstalled OR deleted
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT DISTINCT  c.ClientId, orcl.ClientId as proxy,C.ClientAppType,instanceId
	FROM #tmporacleRACClientInfo C
	INNER JOIN APP_OracleRacInstance as orcl WITH (READUNCOMMITTED)
	 ON C.instanceId = orcl.InstaceId
END
IF ((SELECT COUNT(*) FROM CCRToSubClient (NOLOCK) WHERE appTypeId = 53  AND CCRId = @in_CCRId   )>0)
			-- Get the Client and proxy pairs here (CV_APPTYPE_MSEXCHANGE_DATABASE)
BEGIN
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT DISTINCT CP.componentNameId,(select id from APP_Client C WITH (READUNCOMMITTED) where c.net_hostname like CP.attrName),CCRS.appTypeId ,(SELECT instance FROM APP_Application  A(NOLOCK) WHERE A.ID = CCRS.SubClientId AND A.appTypeId =CCRS.appTypeId )
	from APP_ClientProp CP WITH (READUNCOMMITTED) join CCRToSubClient CCRS WITH (READUNCOMMITTED) on CP.componentnameId = CCRS.clientId
	where attrType = 125--PROPERTY_DAG_MEMBERSERVER
	and CCRS.ccrId = @in_ccrid
	and modified = 0
END
IF ((SELECT COUNT(*) FROM CCRToSubClient (NOLOCK) WHERE appTypeId = 106  AND CCRId = @in_CCRId   )>0)
			-- Get the Client and proxy pairs here (CV_APPTYPE_VIRTUAL_SERVER)
BEGIN
	IF object_id('tempdb.dbo.#tabVSA_clients') IS NOT NULL drop table #tabVSA_clients
	CREATE TABLE #tabVSA_clients (vsaClientId int);
	insert into #tabVSA_clients
	SELECT DISTINCT clientId
	FROM APP_IDAName IDA WITH (READUNCOMMITTED)
WHERE appTypeId = 106
			AND EXISTS (SELECT clientId FROM CCRToSubClient CCRS WITH (READUNCOMMITTED) WHERE IDA.clientId = CCRS.ClientId AND CCRS.CCRID = @in_ccrid)
	DECLARE @pseudoVSAClients XML;
	SET @pseudoVSAClients = (SELECT (
	SELECT vsaClientId  AS '@id'
	FROM #tabVSA_clients
	FOR XML PATH('client'), TYPE) FOR XML PATH('pseudoVSAClients'));
	IF object_id('tempdb.dbo.#pseudoVSANodes') IS NOT null	DROP TABLE #pseudoVSANodes
	CREATE TABLE #pseudoVSANodes(pseudoClient int, clientId int, clientGroupId int,instanceId integer,subClientId integer );
	insert into #pseudoVSANodes
	EXEC AppGetVSMemberServersXML @pseudoVSAClients,1
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId,subclientId)
SELECT  distinct pseudoClient, clientId,106 ,C.instanceId,C.subclientId
	from #pseudoVSANodes C
	where clientId>0
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,isproxyclientGroup,clientGroup,instanceId,subclientId)
SELECT DISTINCT  c.pseudoClient, ACG.clientId as proxy,106,1,ACG.clientGroupId,C.instanceId,C.subclientId
	FROM #pseudoVSANodes C
	INNER JOIN APP_ClientGroupAssoc ACG
	ON  ACG.clientGroupId = C.clientgroupId
	LEFT OUTER JOIN #tmpClientProxyPairsinternal T ON T.ClientId = c.pseudoClient  AND T.proxyClientId = ACG.clientId  AND T.instanceId = C.instanceId	 AND T.subclientId = C.subclientId
	  WHERE
       C.clientGroupId>0 and C.clientId=0 and  T.proxyClientId IS NULL
	-- Backup Proxy List : delete clients with no VSA packages. 713 is VSA package.
	delete #tmpClientProxyPairsinternal where proxyClientId not in (select E.proxyClientId from  #tmpClientProxyPairsinternal  E,simInstalledPackages SIP WITH (READUNCOMMITTED) where
E.proxyClientId = SIP.ClientId and SIP.simPackageID in( 713,1136 ) )
and ClientAppType = 106
	-- Backup Proxy List : So delete clients with deconfigured/deleted VSA agents.
	delete #tmpClientProxyPairsinternal where proxyClientId in (select E.proxyClientId from  #tmpClientProxyPairsinternal E,App_IdaName Ida WITH (READUNCOMMITTED) where
E.clientId = Ida.ClientId and Ida.appTypeId = 106 and (status & 4) = 4)
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
SELECT  distinct pseudoClient, attrVal, 106 ,C.instanceId
	from #pseudoVSANodes C
	INNER JOIN APP_InstanceProp prop (NOLOCK)
	ON prop.componentNameId = C.instanceId  AND ATTRNAME LIKE 'FBR Unix MA' AND prop.modified =0
	where ISNUMERIC(attrVal)=1 AND attrVal IN(SELECT ID FROM APP_Client)
	AND CAST (attrVal AS INT )>1
END
IF ((SELECT COUNT(*) FROM CCRToSubClient (NOLOCK) WHERE appTypeId = 103  AND CCRId = @in_CCRId   )>0)
			-- Get the Client and proxy pairs here (CV_APPTYPE_DB2_DPF )
BEGIN
	IF object_id('tempdb.dbo.#tmpDB2multinodeproxyClientInfo') IS NOT NULL drop table #tmpDB2multinodeproxyClientInfo
	create table #tmpDB2multinodeproxyClientInfo(ClientId		integer,
					instanceId			integer,
					ClientAppType				integer
					)
	insert into #tmpDB2multinodeproxyClientInfo (ClientId,instanceId,ClientAppType)
	SELECT DISTINCT A.CLIENTID, A.INSTANCE ,C.appTypeId
	FROM APP_Application A (NOLOCK)
INNER JOIN CCRToSubClient C (NOLOCK) ON C.ClientId = A.CLIENTID AND C.appTypeId = 103   AND A.APPTYPEID = C.APPTYPEID AND C.CCRId = @in_CCRId
	And (A.subclientStatus & 6) = 0  	-- uninstalled OR deleted
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT  DISTINCT C.ClientId, members.t_pClientId,C.ClientAppType,C.instanceId
	FROM #tmpDB2multinodeproxyClientInfo C
	INNER JOIN   (
					SELECT distinct t_instance = IP.componentNameId, t_pClientId = substring(T1.Data, CHARINDEX(',', T1.Data)+1, LEN(T1.Data))
							FROM    APP_InstanceProp IP WITH (NOLOCK) CROSS APPLY dbo.SplitString(IP.attrVal, ' ') T1
							WHERE   IP.attrName = 'DB2 Partition Clients' and IP.modified = 0
            )members
			ON  members.t_instance = C.instanceId
	IF object_id('tempdb.dbo.#tmpDB2multinodeproxyClientInfo') IS NOT NULL drop table #tmpDB2multinodeproxyClientInfo
END
IF ((SELECT COUNT(*) FROM CCRToSubClient (NOLOCK) WHERE appTypeId = 135  AND CCRId = @in_CCRId   )>0)
			-- Get the Client and proxy pairs here (CV_APPTYPE_SAP_HANA )
BEGIN
	IF object_id('tempdb.dbo.#tmpSapHanaProxyClientInfo') IS NOT NULL drop table #tmpSapHanaProxyClientInfo
	create table #tmpSapHanaProxyClientInfo(ClientId		integer,
					instanceId			integer,
					ClientAppType				integer
					)
	insert into #tmpSapHanaProxyClientInfo (ClientId,instanceId,ClientAppType)
	SELECT DISTINCT A.CLIENTID, A.INSTANCE ,C.appTypeId
	FROM APP_Application A (NOLOCK)
INNER JOIN CCRToSubClient C (NOLOCK) ON C.ClientId = A.CLIENTID AND C.appTypeId = 135   AND A.APPTYPEID = C.APPTYPEID AND C.CCRId = @in_CCRId
	And (A.subclientStatus & 6) = 0 	-- uninstalled OR deleted
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT  DISTINCT C.ClientId, members.t_pClientId,C.ClientAppType,C.instanceId
	FROM #tmpSapHanaProxyClientInfo C
	INNER JOIN   (
					SELECT distinct t_instance = IP.componentNameId, t_pClientId = substring(T1.Data, CHARINDEX(',', T1.Data)+1, LEN(T1.Data))
							FROM    APP_InstanceProp IP WITH (NOLOCK) CROSS APPLY dbo.SplitString(IP.attrVal, '+') T1
							WHERE   IP.attrName = 'Database Clients' and IP.modified = 0
            )members
			ON  members.t_instance = C.instanceId
	IF object_id('tempdb.dbo.#tmpSapHanaProxyClientInfo') IS NOT NULL drop table #tmpSapHanaProxyClientInfo
END
IF ((SELECT COUNT(*) FROM CCRToSubClient (NOLOCK) WHERE appTypeId = 81  AND CCRId = @in_CCRId   )>0)
			-- Get the Client and proxy pairs here (CV_APPTYPE_MSSQL )
BEGIN
	IF object_id('tempdb.dbo.#tmpsqlProxyClientInfo') IS NOT NULL drop table #tmpsqlProxyClientInfo
	create table #tmpsqlProxyClientInfo(ClientId		integer,
					instanceId			integer,
					ClientAppType				integer,
					ProxyClientXml XML
					)
	insert into #tmpsqlProxyClientInfo (ClientId,instanceId,ClientAppType)
	SELECT DISTINCT A.CLIENTID, A.INSTANCE ,C.appTypeId
	FROM APP_Application A (NOLOCK)
INNER JOIN CCRToSubClient C (NOLOCK) ON C.ClientId = A.CLIENTID AND C.appTypeId = 81   AND A.APPTYPEID = C.APPTYPEID AND C.CCRId = @in_CCRId
	And (A.subclientStatus & 6) = 0 	-- uninstalled OR deleted
	UPDATE C
	SET ProxyClientXml = ISNULL(prop.attrVal, '')
	FROM #tmpsqlProxyClientInfo C
	INNER JOIN APP_InstanceProp prop (NOLOCK)
	ON	prop.componentNameId = C.instanceId AND prop.modified = 0
	AND prop.attrName = 'Availability Replicas'
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,instanceId,proxyClientId,ClientAppType)
	SELECT DISTINCT c.ClientId,C.instanceId, a.value('(@clientId)[1]', 'int') as proxy,C.ClientAppType
	FROM #tmpsqlProxyClientInfo C
	CROSS APPLY C.ProxyClientXml.nodes('/App_SQLAvailabilityReplicas/SQLAvailabilityReplicasList/replicaClient') rc(a)
	WHERE
       a.value('@clientId', 'int') IS NOT NULL
	IF object_id('tempdb.dbo.#tmpsqlProxyClientInfo') IS NOT NULL drop table #tmpsqlProxyClientInfo
END
IF ((SELECT COUNT(*) FROM CCRToSubClient (NOLOCK) WHERE appTypeId = 78  AND CCRId = @in_CCRId   )>0)
			-- Get the Client and proxy pairs here (CV_APPTYPE_MS_SHAREPOINTV2_DOC )
BEGIN
	IF object_id('tempdb.dbo.#tmpsharepointProxyClientInfo') IS NOT NULL drop table #tmpsharepointProxyClientInfo
	create table #tmpsharepointProxyClientInfo(ClientId		integer,
					instanceId			integer,
					ClientAppType				integer,
					ProxyClientXml XML
					)
	insert into #tmpsharepointProxyClientInfo (ClientId,instanceId,ClientAppType)
	SELECT DISTINCT A.CLIENTID, A.INSTANCE ,C.appTypeId
	FROM APP_Application A (NOLOCK)
INNER JOIN CCRToSubClient C (NOLOCK) ON C.ClientId = A.CLIENTID AND C.appTypeId = 78   AND A.APPTYPEID = C.APPTYPEID AND C.CCRId = @in_CCRId
	And (A.subclientStatus & 6) = 0 	-- uninstalled OR deleted
	LEFT OUTER JOIN simInstalledPackages sim (NOLOCK) ON sim.ClientId = A.CLIENTID
	WHERE sim.ClientId IS NULL
	UPDATE C
		SET ProxyClientXml = ISNULL(prop.stringVal, '')
	FROM #tmpsharepointProxyClientInfo C
		-- Relocated 'SharePoint Member Servers' XML Document from APP_ClientProp to APP_ComponentProp Table since attrVal limited to max data size of NVARCHAR(1024)
		INNER JOIN APP_ComponentProp prop (NOLOCK) ON
			prop.componentType = 3			-- CV_COMPONENT_TYPE_CLIENT
			AND prop.propertyTypeId = 1046	-- CV_COMPONENT_SHAREPOINT_SECONDARY_MEMBER_SERVERS		-- Old APP_ClientProp 'SharePoint Member Servers'
			AND prop.componentId = C.ClientId
			AND prop.modified = 0
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,instanceId,proxyClientId,ClientAppType)
	SELECT DISTINCT c.ClientId,C.instanceId, a.value('(@clientId)[1]', 'int') as proxy,C.ClientAppType
	FROM #tmpsharepointProxyClientInfo C
	CROSS APPLY C.ProxyClientXml.nodes('/App_MemberServers/memberServers/client') rc(a)
	WHERE
       a.value('@clientId', 'int') IS NOT NULL
	UNION
	SELECT DISTINCT c.ClientId,C.instanceId, ISNULL(prop.attrVal, '') as proxy,C.ClientAppType
	FROM #tmpsharepointProxyClientInfo C
	INNER JOIN APP_ClientProp prop (NOLOCK)
	ON	prop.componentNameId = C.ClientId AND prop.modified = 0
	AND prop.attrName = 'SharePoint Primary Member Server'
	IF object_id('tempdb.dbo.#tmpsharepointProxyClientInfo') IS NOT NULL drop table #tmpsharepointProxyClientInfo
END
IF ((SELECT COUNT(*) FROM CCRToSubClient S (NOLOCK) INNER JOIN APP_Client C (NOLOCK) ON  S.clientid= C.id AND ((C.status & 0x8000000) >0 OR (C.status & 0x0080) >0) AND CCRId = @in_CCRId   )>0)
			-- Get the Client and proxy pairs here (CV_STATUS_NON_NDMP ) Networkshare
			-- Get the Client and proxy pairs here (CV_STATUS_NAS ) NAS
BEGIN
	IF object_id('tempdb.dbo.#tmpNASNetworkShareProxyClientInfo') IS NOT NULL drop table #tmpNASNetworkShareProxyClientInfo
	create table #tmpNASNetworkShareProxyClientInfo(ClientId		integer,
					instanceId			integer,
					ClientAppType				integer,
					ProxyClientXml XML
					)
	insert into #tmpNASNetworkShareProxyClientInfo (ClientId,instanceId,ClientAppType)
	SELECT DISTINCT A.CLIENTID, A.INSTANCE ,C.appTypeId
	FROM APP_Application A (NOLOCK)
	INNER JOIN CCRToSubClient C (NOLOCK) ON C.ClientId = A.CLIENTID AND A.APPTYPEID = C.APPTYPEID AND C.CCRId = @in_CCRId
	INNER JOIN APP_Client C1 (NOLOCK) ON C1.Id = A.CLIENTID
AND ((C1.status & 0x8000000) >0 OR (C1.status & 0x0080) >0)
	 And (A.subclientStatus & 6) = 0  	-- uninstalled OR deleted
	UPDATE t
	SET ProxyClientXml = ISNULL(P.attrVal, '')
	FROM APP_IDAProp P (NOLOCK)
	INNER JOIN APP_IDAName N (NOLOCK) ON  P.componentNameId = N.id
	INNER JOIN #tmpNASNetworkShareProxyClientInfo t (NOLOCK) ON  t.ClientAppType = N.appTypeId
	AND N.clientId = t.ClientId
	AND attrName = 'Backup Configuration Nodes' AND p.modified = 0
	IF object_id('tempdb.dbo.#tmpNASNetworkShareAllClientInfo') IS NOT NULL drop table #tmpNASNetworkShareAllClientInfo
	create table #tmpNASNetworkShareAllClientInfo(pseudoClientId		integer,
										instanceId INT,
										entityType integer,
										clientId integer ,
										clientgroupId integer,
										ClientAppType  integer
					)
	INSERT INTO #tmpNASNetworkShareAllClientInfo(pseudoClientId,entityType,clientId,clientgroupId,ClientAppType,instanceId)
	SELECT c.ClientId,
		ISNULL(a.value('@_type_', 'int'),0) ,
		ISNULL(a.value('@clientId', 'int'),0),
		ISNULL(a.value('@clientGroupId', 'int'),0),
		C.ClientAppType,
		C.instanceId
	FROM #tmpNASNetworkShareProxyClientInfo C
	 CROSS APPLY C.ProxyClientXml.nodes('App_BackupConfigurationNodes/backupDataAccessNodes') rc(a)
	  WHERE
       a.value('@clientId', 'int') IS NOT NULL
	  OR a.value('@clientGroupId', 'int') IS NOT NULL
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT DISTINCT  c.pseudoClientId, C.clientId as proxy,C.ClientAppType,C.instanceId
	FROM #tmpNASNetworkShareAllClientInfo C
	  WHERE
C.entityType = 3 AND  C.clientId>1
	UNION
	SELECT DISTINCT t.ClientId,ISNULL(P.attrVal, '')as proxy ,t.ClientAppType,t.instanceId
	FROM APP_IDAProp P (NOLOCK)
	INNER JOIN APP_IDAName N (NOLOCK) ON  P.componentNameId = N.id
	INNER JOIN #tmpNASNetworkShareProxyClientInfo t (NOLOCK) ON  t.ClientAppType = N.appTypeId
	AND N.clientId = t.ClientId  AND P.attrVal <> '0'
	AND (P.attrName = 'FPOLICY PRIMARY CLIENT' OR P.attrName = 'FPOLICY SECONDARY CLIENT') AND P.modified = 0
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,isproxyclientGroup,clientGroup,instanceId)
	SELECT DISTINCT  c.pseudoClientId, ACG.clientId as proxy,C.ClientAppType,1,ACG.clientGroupId,C.instanceId
	FROM #tmpNASNetworkShareAllClientInfo C
	INNER JOIN APP_ClientGroupAssoc ACG
	ON  ACG.clientGroupId = C.clientgroupId
	INNER JOIN simInstalledPackages P
ON P.ClientId =  ACG.clientId AND ((P.simPackageID = 51 AND C.ClientAppType = 13) OR
(P.simPackageID = 1 AND C.ClientAppType = 33 )OR
(P.simPackageID = 1002 ))
	  WHERE
C.entityType =28 and C.clientId = 0
	IF object_id('tempdb.dbo.#tmpNASNetworkShareSubClientInfo') IS NOT NULL drop table #tmpNASNetworkShareSubClientInfo
	create table #tmpNASNetworkShareSubClientInfo(ClientId		integer,
					instanceId			integer,
					ClientAppType				integer,
					subClientId				integer,
					ProxyClientXml XML ,
					SnapBackupsEnabled int DEFAULT 0,
					Snapcopyproxy	   int DEFAULT 0,
					Snaptotapeproxy	   int DEFAULT 0
					)
	INSERT INTO #tmpNASNetworkShareSubClientInfo(ClientId,instanceId,ClientAppType,subClientId)
	SELECT N.ClientId ,N.instanceId, N.ClientAppType,A.ID FROM
	APP_Application A (NOLOCK)
	INNER JOIN	#tmpNASNetworkShareProxyClientInfo N
		ON A.clientId =  N.ClientId AND A.appTypeId = N.ClientAppType AND A.instance = N.instanceId
		And (A.subclientStatus & 6) = 0  	-- uninstalled OR deleted
	UPDATE t
	SET SnapBackupsEnabled = ISNULL(prop.attrVal, 0)
	FROM APP_ClientProp prop (NOLOCK)
	INNER JOIN #tmpNASNetworkShareSubClientInfo t (NOLOCK) ON  prop.componentNameId =  T.ClientId
    AND prop.modified = 0 AND prop.attrName = 'Snap Backups Enabled' AND LEN(prop.ATTRVAL)>0
	UPDATE t1
	SET SnapBackupsEnabled = ISNULL(prop.SnapBackupsEnabled, 0)	,
		Snapcopyproxy =  ISNULL(prop.Snapcopyproxy, 0)	,
		Snaptotapeproxy = CASE WHEN ISNULL(prop.SnaptotapeproxyEnabled, 0) = 1 THEN ISNULL(prop.Snaptotapeproxy, 0)	ELSE 0 END
	FROM (SELECT  P.componentNameId, [Snap copy : proxy to use] AS Snapcopyproxy, [Enable Snap Backups] AS SnapBackupsEnabled ,[Snap to tape : proxy to use] AS Snaptotapeproxy, [Snap to tape : proxy enabled] AS SnaptotapeproxyEnabled
		FROM
			(SELECT p.componentNameId, P.attrName, CAST(P.attrVal AS BIGINT) AS size from APP_SubClientProp p
	INNER JOIN #tmpNASNetworkShareSubClientInfo T ON  P.componentNameId= T.subClientId AND T.SnapBackupsEnabled =1
	WHERE attrName IN ('Snap copy : proxy to use', 'Enable Snap Backups', 'Snap to tape : proxy to use', 'Snap to tape : proxy enabled') and modified=0)S
	 PIVOT (MAX(size) FOR attrName IN ([Snap copy : proxy to use], [Enable Snap Backups],[Snap to tape : proxy to use], [Snap to tape : proxy enabled])) AS P
	)  prop
	INNER JOIN #tmpNASNetworkShareSubClientInfo t1 (NOLOCK) ON  prop.componentNameId =  T1.subClientId
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId,subclientId)
	SELECT DISTINCT  c.ClientId, C.Snapcopyproxy as proxy,C.ClientAppType,C.instanceId,C.subclientId
	FROM #tmpNASNetworkShareSubClientInfo C
	WHERE
	C.SnapBackupsEnabled = 1 AND C.Snapcopyproxy>0
	UNION
	SELECT DISTINCT  c.ClientId, C.Snaptotapeproxy as proxy,C.ClientAppType,C.instanceId,C.subclientId
	FROM #tmpNASNetworkShareSubClientInfo C
	WHERE
	C.SnapBackupsEnabled = 1 AND C.Snaptotapeproxy>0
	UPDATE t
	SET ProxyClientXml = ISNULL(prop.attrVal, '')
	FROM APP_SubClientProp prop (NOLOCK)
	INNER JOIN #tmpNASNetworkShareSubClientInfo t (NOLOCK) ON  prop.componentNameId =  T.subClientId AND
    prop.modified = 0 AND prop.attrName = 'Backup Configuration Nodes' AND LEN(prop.ATTRVAL)>0
	DELETE FROM #tmpNASNetworkShareSubClientInfo WHERE subClientId NOT IN ( SELECT DISTINCT C.subClientId
	FROM #tmpNASNetworkShareSubClientInfo C
	CROSS APPLY C.ProxyClientXml.nodes('App_BackupConfigurationNodes/backupDataAccessNodes') rc(a)
	WHERE
       a.value('@clientId', 'int') IS NOT  NULL
	     OR a.value('@clientGroupId', 'int') IS NOT  NULL	)
	IF ((SELECT COUNT(*) FROM	#tmpNASNetworkShareSubClientInfo   )>0)
	BEGIN
		IF object_id('tempdb.dbo.#tmpNASNetworkShareAllSubClientInfo') IS NOT NULL drop table #tmpNASNetworkShareAllSubClientInfo
			create table #tmpNASNetworkShareAllSubClientInfo(pseudoClientId		integer,
										instanceId INT,
										entityType integer,
										clientId integer ,
										clientgroupId integer,
										ClientAppType  integer,
										subclientId  integer
					)
		INSERT INTO #tmpNASNetworkShareAllSubClientInfo(pseudoClientId,entityType,clientId,clientgroupId,ClientAppType,instanceId,subclientId)
		SELECT c.ClientId,
		ISNULL(a.value('@_type_', 'int'),0) ,
		ISNULL(a.value('@clientId', 'int'),0),
		ISNULL(a.value('@clientGroupId', 'int'),0),
		C.ClientAppType,
		C.instanceId,
		C.subclientId
		FROM #tmpNASNetworkShareSubClientInfo C
		CROSS APPLY C.ProxyClientXml.nodes('App_BackupConfigurationNodes/backupDataAccessNodes') rc(a)
		WHERE
		a.value('@clientId', 'int') IS NOT NULL
		OR a.value('@clientGroupId', 'int') IS NOT NULL
		INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId,subclientId)
		SELECT DISTINCT  c.pseudoClientId, C.clientId as proxy,C.ClientAppType,C.instanceId,subclientId
		FROM #tmpNASNetworkShareAllSubClientInfo C
		WHERE
C.entityType = 3 AND  C.clientId>1
		INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,isproxyclientGroup,clientGroup,instanceId,subclientId)
		SELECT DISTINCT  c.pseudoClientId, ACG.clientId as proxy,C.ClientAppType,1,ACG.clientGroupId,C.instanceId,subclientId
		FROM #tmpNASNetworkShareAllSubClientInfo C
		INNER JOIN APP_ClientGroupAssoc ACG
		ON  ACG.clientGroupId = C.clientgroupId
		INNER JOIN simInstalledPackages P
ON P.ClientId =  ACG.clientId AND ((P.simPackageID = 51 AND C.ClientAppType = 13) OR
(P.simPackageID = 1 AND C.ClientAppType = 33 )OR
(P.simPackageID = 1002 ))
		WHERE
C.entityType =28 and C.clientId = 0
		IF object_id('tempdb.dbo.#tmpNASNetworkShareAllSubClientInfo') IS NOT NULL drop table #tmpNASNetworkShareAllSubClientInfo
	END
	IF object_id('tempdb.dbo.#tmpNASNetworkShareAllClientInfo') IS NOT NULL drop table #tmpNASNetworkShareAllClientInfo
	IF object_id('tempdb.dbo.#tmpNASNetworkShareProxyClientInfo') IS NOT NULL drop table #tmpNASNetworkShareProxyClientInfo
END
IF((SELECT COUNT(*) FROM CCRToSubClient S (NOLOCK) INNER JOIN APP_ClientProp prop (NOLOCK) ON  S.clientid= prop.componentNameId AND  prop.modified = 0 AND prop.attrName ='Open VMS proxy client'  AND CCRId = @in_CCRId   )>0)
			-- OPEN VMS
			-- IBMI
BEGIN
	IF object_id('tempdb.dbo.#TMPOpenVMSproxyclientlist') IS NOT NULL drop table #TMPOpenVMSproxyclientlist
	create table #TMPOpenVMSproxyclientlist(ClientId		integer,
					instanceId			integer,
					ClientAppType				integer,
					ProxyClientXml XML
					)
	insert into #TMPOpenVMSproxyclientlist (ClientId,instanceId,ClientAppType)
	SELECT DISTINCT A.CLIENTID, A.INSTANCE ,C.appTypeId
	FROM APP_Application A (NOLOCK)
INNER JOIN CCRToSubClient C (NOLOCK) ON C.ClientId = A.CLIENTID AND C.appTypeId = 38    AND A.APPTYPEID = C.APPTYPEID AND C.CCRId = @in_CCRId
	And (A.subclientStatus & 6) = 0 	-- uninstalled OR deleted
	LEFT OUTER JOIN simInstalledPackages sim (NOLOCK) ON sim.ClientId = A.CLIENTID
	WHERE sim.ClientId IS NULL
	UPDATE C
		SET ProxyClientXml = ISNULL(prop.attrVal, '')
	FROM #TMPOpenVMSproxyclientlist C
		INNER JOIN APP_ClientProp prop (NOLOCK) ON
			 prop.componentNameId = C.ClientId
			AND prop.modified = 0
			AND prop.attrName ='Open VMS proxy client list'
	IF object_id('tempdb.dbo.#TMPOpenVMSproxyAllClientInfo') IS NOT NULL drop table #TMPOpenVMSproxyAllClientInfo
	create table #TMPOpenVMSproxyAllClientInfo(pseudoClientId		integer,
										instanceId INT,
										entityType integer,
										clientId integer ,
										clientgroupId integer,
										ClientAppType  integer
					)
	INSERT INTO #TMPOpenVMSproxyAllClientInfo(pseudoClientId,entityType,clientId,clientgroupId,ClientAppType,instanceId)
	SELECT c.ClientId,
		ISNULL(a.value('@_type_', 'int'),0) ,
		ISNULL(a.value('@clientId', 'int'),0),
		ISNULL(a.value('@clientGroupId', 'int'),0),
		C.ClientAppType,
		C.instanceId
	FROM #TMPOpenVMSproxyclientlist C
	 CROSS APPLY C.ProxyClientXml.nodes('App_BackupConfigurationNodes/backupDataAccessNodes') rc(a)
	  WHERE
       a.value('@clientId', 'int') IS NOT NULL
	  OR a.value('@clientGroupId', 'int') IS NOT NULL
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT DISTINCT  c.pseudoClientId, C.clientId as proxy,C.ClientAppType,C.instanceId
	FROM #TMPOpenVMSproxyAllClientInfo C
	  WHERE
C.entityType = 3 AND  C.clientId>1
	UNION
	SELECT  DISTINCT A.CLIENTID,CAST (prop.attrVal AS INT ) attrVal, A.appTypeId, A.INSTANCE FROM  CCRToSubClient S (NOLOCK)  INNER JOIN APP_ClientProp prop (NOLOCK) ON
	 S.clientid = prop.componentNameId AND prop.attrName = 'Open VMS proxy client'  AND CCRId = @in_CCRId  AND  prop.modified = 0
	INNER JOIN APP_Application A (NOLOCK) ON A.clientId  = S.ClientId  AND A.ID = S.subclientid
	AND ISNUMERIC (prop.attrVal) =1
	AND CAST (prop.attrVal AS INT )>1
	And (A.subclientStatus & 6) = 0  	-- uninstalled OR deleted
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,isproxyclientGroup,clientGroup,instanceId)
	SELECT DISTINCT  c.pseudoClientId, ACG.clientId as proxy,C.ClientAppType,1,ACG.clientGroupId,C.instanceId
	FROM #TMPOpenVMSproxyAllClientInfo C
	INNER JOIN APP_ClientGroupAssoc ACG
	ON  ACG.clientGroupId = C.clientgroupId
	INNER JOIN simInstalledPackages P
ON P.ClientId =  ACG.clientId AND ((P.simPackageID = 1137) OR
(P.simPackageID = 1138)
									   )
	  WHERE
C.entityType =28 and C.clientId = 0
	IF object_id('tempdb.dbo.#TMPOpenVMSproxyclientlist') IS NOT NULL drop table #TMPOpenVMSproxyclientlist
	IF object_id('tempdb.dbo.#TMPOpenVMSproxyAllClientInfo') IS NOT NULL drop table #TMPOpenVMSproxyAllClientInfo
END
IF((SELECT COUNT(*) FROM CCRToSubClient S (NOLOCK) INNER JOIN APP_ClientProp prop (NOLOCK) ON  S.clientid= prop.componentNameId AND  prop.modified = 0 AND prop.attrName ='HAC Cluster Nodes'  AND CCRId = @in_CCRId   )>0)
			--HAC Cluster Nodes
BEGIN
	IF object_id('tempdb.dbo.#tmpproxyHACClientXML') IS NOT NULL drop table #tmpproxyHACClientXML
	CREATE TABLE #tmpproxyHACClientXML(ClientId		integer,
				proxynodesxml XML
				)
	INSERT INTO #tmpproxyHACClientXML (ClientId,proxynodesxml)
	SELECT DISTINCT  S.ClientId,  SUBSTRING(attrVal, CHARINDEX('>', attrVal)+1, LEN(attrVal)) AS nodes
    FROM CCRToSubClient S (NOLOCK)
	  INNER JOIN APP_ClientProp prop(NOLOCK)
	ON prop.componentNameId = S.ClientId AND attrName = 'HAC Cluster Nodes'  AND prop.modified =0 AND s.CCRId = @in_CCRId
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
		SELECT DISTINCT proxyInfo.ClientId, proxyInfo.proxy,clientInfo.appTypeId,clientInfo.INSTANCE
	FROM (SELECT DISTINCT c.ClientId, a.value('(@val)[1]', 'int') as proxy
	FROM #tmpproxyHACClientXML C
	CROSS APPLY C.proxynodesxml.nodes('App_ClientList/clientId') rc(a)
	WHERE
       a.value('@val', 'int') IS NOT NULL	) AS proxyInfo
	INNER JOIN  (SELECT DISTINCT A.CLIENTID, A.INSTANCE,C.appTypeId
	FROM APP_Application A (NOLOCK)
INNER JOIN CCRToSubClient C (NOLOCK) ON C.ClientId = A.CLIENTID AND C.appTypeId = 64   AND A.APPTYPEID = C.APPTYPEID AND C.CCRId = @in_CCRId
		And (A.subclientStatus & 6) = 0 	-- uninstalled OR deleted
	)
	AS clientInfo
	ON clientInfo.CLIENTID =  proxyInfo.ClientId
	DROP TABLE #tmpproxyHACClientXML
END
IF ((SELECT COUNT(*) FROM CCRToSubClient S (NOLOCK) INNER JOIN APP_VMToPMMap C (NOLOCK) ON  S.clientid= C.vmclientid AND CCRId = @in_CCRId INNER JOIN APP_Client A ON A.id= S.ClientId and A.simOperatingSystemId <> 16)>0)
			-- Get the Cluster nodes pairs and exclude NAS Cluster client
BEGIN
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT DISTINCT C.vmclientid,C.pmclientid,S.APPTYPEID,A.INSTANCE
	FROM CCRToSubClient S (NOLOCK) INNER JOIN APP_VMToPMMap C (NOLOCK) ON  S.clientid= C.vmclientid AND CCRId = @in_CCRId
	INNER JOIN APP_Application A (NOLOCK) ON
	S.ClientId = A.CLIENTID AND A.ID= S.subclientid
	INNER JOIN APP_Client AC ON AC.ID = S.ClientId and AC.simOperatingSystemId <> 16
	And (A.subclientStatus & 6) = 0 	-- uninstalled OR deleted
END
IF ((SELECT COUNT(*) FROM CCRToSubClient WHERE appTypeId = 124  AND CCRId = @in_CCRId   )>0)
			-- PSEUDO_CLIENT_OBJECT_LINK
BEGIN
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT  DISTINCT A.CLIENTID,CAST (prop.attrVal AS INT ), A.appTypeId, A.INSTANCE  FROM CCRToSubClient S (NOLOCK) INNER JOIN APP_ClientProp prop (NOLOCK) ON
	 S.clientid = prop.componentNameId AND prop.attrName = 'Object Server Member Servers List'  AND CCRId = @in_CCRId  AND  prop.modified = 0
INNER JOIN APP_Application A (NOLOCK) ON A.clientId  = S.ClientId and S.appTypeId = 124  AND A.ID = S.subclientid
	AND ISNUMERIC (prop.attrVal) =1
	AND CAST (prop.attrVal AS INT )>1
	And (A.subclientStatus & 6) = 0  	-- uninstalled OR deleted
END
IF((SELECT COUNT(*) FROM CCRToSubClient S (NOLOCK) INNER JOIN DM2Cloud C (NOLOCK) ON  S.clientid=  C.pseudoClientId AND C.CloudType IN ( 1,4,5)  AND CCRId = @in_CCRId   )>0)
			----index server
BEGIN
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT  DISTINCT  C.pseudoClientId ,S.ClientId,A.appTypeId,A.instance
		FROM   DM2SearchServerCoreInfo S (nolock)
		INNER JOIN DM2Cloud C (nolock) on c.cloudId = s.CloudId
		INNER JOIN CCRToSubClient CCR (NOLOCK) ON CCR.clientid=  C.pseudoClientId AND CCR.CCRId = @in_CCRId
		INNER JOIN APP_Application A (nolock) ON CCR.subclientid= A.id AND CCR.clientid= A.clientId
		And (A.subclientStatus & 6) = 0 	-- uninstalled OR deleted
	WHERE S.CloudType IN ( 1,4,5) AND C.CloudType IN ( 1,4,5)	AND CCR.CCRId = @in_CCRId
END
IF((SELECT COUNT(*) FROM CCRToSubClient S (NOLOCK) INNER JOIN app_client Cl (nolock) on S.clientId =cl.id INNER JOIN DM2Cloud C (NOLOCK) ON  c.name = Cl.name AND C.CloudType IN (2)  AND CCRId = @in_CCRId   )>0)
			----Content analyzer
BEGIN
	IF object_id('tempdb.dbo.#tmpContentAnalyzer') IS NOT NULL drop table #tmpContentAnalyzer
	create table #tmpContentAnalyzer(
								ClientId		integer,
								proxyClientId	integer,
								ClientAppType				integer,
								instanceId			integer,
								CLOUDID 	integer DEFAULT 0
								)
	INSERT INTO #tmpContentAnalyzer(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT DISTINCT  Cl.id ,S.ClientId,A.appTypeId,A.instance
		FROM  APP_Application A (nolock)
		INNER JOIN app_client Cl (nolock) on a.clientId =cl.id
		INNER JOIN DM2Cloud C (nolock) on   c.name = Cl.name
		INNER JOIN DM2SearchServerCoreInfo S (nolock) ON c.cloudId = s.CloudId
		INNER JOIN CCRToSubClient CCR (NOLOCK) ON CCR.clientid=  cl.id AND CCR.CCRId = @in_CCRId
		And (A.subclientStatus & 6) = 0 	-- uninstalled OR deleted
	WHERE S.CloudType IN ( 2) AND C.CloudType IN ( 2)
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT  DISTINCT  ClientId,proxyClientId,ClientAppType,instanceId
	FROM #tmpContentAnalyzer
	UNION
	SELECT  DISTINCT  ClientId ,CAST (prop.attrVal AS INT ),ClientAppType,instanceId
	FROM #tmpContentAnalyzer c
	INNER JOIN APP_ClientProp prop (NOLOCK)
	ON	prop.componentNameId = C.proxyClientId AND prop.modified = 0
	AND prop.attrName IN('MessageQueue ClientId','Content Extractor ClientId')
	AND ISNUMERIC (prop.attrVal) =1
	AND CAST (prop.attrVal AS INT )>1
	UPDATE C
	SET C.CLOUDID = CAST (prop.attrVal AS INT )
	FROM #tmpContentAnalyzer c
	INNER JOIN APP_ClientProp prop (NOLOCK)
	ON	prop.componentNameId = C.ClientId AND prop.modified = 0
	AND prop.attrName IN('Analytics CACloudId')
	AND ISNUMERIC (prop.attrVal) =1
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,instanceId,proxyClientId,ClientAppType,isIndexServer,iscloudindexServer,cloudindexServer)
	SELECT  DISTINCT  CCR.ClientId ,CCR.instanceID, S.clientId,CCR.ClientAppType,1,1,c.pseudoClientId
		FROM  DM2SearchServerCoreInfo S (nolock)
		INNER JOIN DM2Cloud C (nolock) on c.cloudId = s.CloudId
		INNER JOIN #tmpContentAnalyzer CCR (NOLOCK) ON CCR.CLOUDID=  C.CloudId
	WHERE S.CloudType IN ( 1,4,5) AND C.CloudType IN ( 1,4,5)	AND c.pseudoClientId>0
	DROP TABLE #tmpContentAnalyzer
END
IF (LEN(@tableOutput)>0)
BEGIN
  DECLARE @outputSQLStatement NVARCHAR(MAX)
  SET @outputSQLStatement = 'INSERT INTO '+ @tableOutput +'(clientId, proxyClientId,ClientAppType,isIndexServer,iscloudindexServer,cloudindexServer,isproxyclientGroup ,clientGroup	,instanceId,subclientId) '
  SET @outputSQLStatement += ' SELECT DISTINCT clientId, proxyClientId,ClientAppType,isIndexServer,iscloudindexServer ,cloudindexServer ,isproxyclientGroup ,clientGroup ,instanceId,subclientId FROM #tmpClientProxyPairsinternal'
  EXEC (@outputSQLStatement)
 END
 ELSE
 BEGIN
	SELECT DISTINCT clientId, proxyClientId ,ClientAppType,isIndexServer
	,iscloudindexServer
	,cloudindexServer
	,isproxyclientGroup
	,clientGroup
	,instanceId
	,subclientId
	 FROM #tmpClientProxyPairsinternal
	 order by instanceId
 END
IF object_id('tempdb.dbo.#tmpClientProxyPairsinternal') IS NOT NULL drop table #tmpClientProxyPairsinternal
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CCRGetProxyClientInfo')
	delete from GxQscripts where name = 'CCRGetProxyClientInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRGetProxyClientInfo')
	delete from GXDBVersions where aliasname = 'CCRGetProxyClientInfo'
GO

insert into GXDBVersions values(2, 'CCRGetProxyClientInfo',  '00010001000200310000', 'CCRGetProxyClientInfo', '00010001000200310000')
GO

