

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCRGetOffLineEntityCount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCRGetOffLineEntityCount.sp,v $ $Id: CCRGetOffLineEntityCount.sp,v 1.9.208.6 2019/08/26 14:17:05 dkraplanee Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "CCRGetOffLineEntityCount"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCRGetOffLineEntityCount')
BEGIN
	print '>>> Drop Stored Procedure: CCRGetOffLineEntityCount <<<'
	drop procedure CCRGetOffLineEntityCount
END
IF EXISTS (select * from GxQscripts where name='CCRGetOffLineEntityCount')
	delete from GxQscripts where name = 'CCRGetOffLineEntityCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRGetOffLineEntityCount')
	delete from GXDBVersions where aliasname = 'CCRGetOffLineEntityCount'
GO
print '... Creating Procedure: CCRGetOffLineEntityCount'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCRGetOffLineEntityCount
  @i_jobId integer,
  @i_CCRId integer
AS
  DECLARE @o_TotalLibraryCount int
  DECLARE @o_OffLineLibraryCount int
  DECLARE @o_TotalDriveCount int
  DECLARE @o_OffLineDriveCount int
  DECLARE @o_TotalMACount int
  DECLARE @o_OffLineMACount int
  DECLARE @o_TotalClientCount int
  DECLARE @o_OffLineClientCount int
	SET NOCOUNT ON
	DECLARE	@l_OffLineLibraryCount	INTEGER
	DECLARE	@l_OffLineDriveCount	INTEGER
	DECLARE	@l_OffLineMACount		INTEGER
	DECLARE	@l_OffLineClientCount	INTEGER
	DECLARE	@l_TotalLibraryCount	INTEGER
	DECLARE	@l_TotalDriveCount		INTEGER
	DECLARE	@l_TotalMACount			INTEGER
	DECLARE	@l_TotalClientCount		INTEGER
	DECLARE @tmpExternalClient TABLE (id INT)
	DECLARE @disabledCliententities integer = 1
	DECLARE @clOpt		integer =0
	DECLARE @tblClients	TABLE (t_clId int)
	DECLARE @MAId           integer =0
	DECLARE @tblMA          TABLE (t_id int)
	DECLARE @userId			integer =1
	IF (@i_jobId>0)
	BEGIN
SET @disabledCliententities = dbo.GetOptionInt(985522432, @i_jobId, 0, 0)
SET @userId			= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
		INSERT INTO @tblClients EXEC rptOptGetClients @i_jobId, @clOpt OUTPUT
INSERT INTO @tblMA	EXEC RptOptGetObjectList @i_jobId, 587766369, @MAId OUTPUT		--: REPORTOPTION_MEDIA_AGENT_LIST
	--begin--For VSA pseudo clients, we need to involve the member servers
		declare @pseudoVSAClients xml;
		set @pseudoVSAClients = (select (
		select t_clId as '@id'
		from @tblClients C
		where Exists (select clientId
				from APP_IDAName IDA WITH (READUNCOMMITTED)
				where C.t_clId = IDA.clientId
AND appTypeId = 106
					AND not exists (select clientId from simInstalledPackages SIM WITH (READUNCOMMITTED) where IDA.clientId=SIM.clientId )
				)
		for xml path('client'), TYPE) for xml path('pseudoVSAClients'));
		--select @pseudoVSAClients --gets the pseudo vsa clients in the CS as xml rows
		IF object_id('tempdb.dbo.#pseudoVSANodes') IS NOT null	DROP TABLE #pseudoVSANodes
		CREATE TABLE #pseudoVSANodes(pseudoClient int, node int);
		insert into #pseudoVSANodes
		EXEC AppGetVSMemberServersXML @pseudoVSAClients
		insert into @tblClients
		select distinct node from #pseudoVSANodes N where not exists(select t_clId from @tblClients C where C.t_clId = N.node)
		DROP TABLE #pseudoVSANodes
	--end
	END
	IF object_id('tempdb.dbo.#tmpCCRToSubClient') IS NOT null	DROP TABLE #tmpCCRToSubClient
	IF object_id('tempdb.dbo.#temp_ma') IS NOT null	DROP TABLE #temp_ma
	SELECT * INTO #tmpCCRToSubClient from  CCRToSubClient S WITH (READUNCOMMITTED)  where  CCRId = @i_CCRId
	select * INTO #temp_ma from MMHost WITH (READUNCOMMITTED) where ClientId > 1
	IF @userId > 0
	BEGIN
		IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		EXEC sec_getUserObjects @userId, 2013 , 0, '#rptUserObjects'	-- SUB_CLIENT_ITEM = to get SUB_CLIENT_ITEM it will be having client/appType/instance/backupSet/subclient/
		delete #rptUserObjects
		WHERE clientGroupId <> 0 or commcellId <> 2
		DELETE #tmpCCRToSubClient
		FROM #tmpCCRToSubClient, CCRToSubClient t WITH (READUNCOMMITTED)
		WHERE #tmpCCRToSubClient.SubClientId=t.SubClientId AND
		0 = (	select	count(*) from #rptUserObjects
			where	clientId IN (0, #tmpCCRToSubClient.ClientId) AND
				appTypeId IN (0,#tmpCCRToSubClient.appTypeId)
				)
	 TRUNCATE TABLE #rptUserObjects
EXEC sec_getUserObjects @userId, 2048, 0, '#rptUserObjects'
    delete #rptUserObjects
    WHERE clientGroupId <> 0 OR clientId <> 0 OR libraryID <> 0 OR archGroupID <> 0
    OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
    OR taskId <> 0
    delete #temp_ma
    WHERE 0 = (select count(*) from #rptUserObjects where mediaAgentId in (0, #temp_ma.ClientId))
    DROP TABLE #rptUserObjects
	END
	--Get NBU client list
	INSERT INTO @tmpExternalClient
	SELECT C.id
	FROM APP_Client C WITH (READUNCOMMITTED) , APP_CommCell Cell WITH (READUNCOMMITTED)
	WHERE C.origCCId = Cell.id and Cell.type = 100
SET @l_TotalLibraryCount = (select count(*) from MMLibrary WITH (READUNCOMMITTED) where LibraryId > 0 AND LibraryTypeId != 8 )
	SET @l_OffLineLibraryCount = (select count(*)
								from MMLibrary WITH (READUNCOMMITTED)
where LibraryId > 0 AND LibraryTypeId != 8 AND
									(LibrarySoftState = 0 OR LibraryEnabled = 0 OR LibraryBroken = 1 OR
									ExtendedAttributes & 512 > 0 OR
									LibraryId NOT IN(select LibraryId from MMLibraryController WITH (READUNCOMMITTED)
														where LibraryControllerSoftState = 1
														AND LibraryControllerActive = 1
														AND LibraryControllerEnabled = 1)))
	SET @l_TotalDriveCount = (select count(*) from MMDrive WITH (READUNCOMMITTED) where DriveId > 0)
	SET @l_OffLineDriveCount = (select count(*)
								from MMDrive WITH (READUNCOMMITTED)
								where DriveId > 0 AND
									(DriveSoftState = 0 OR DriveEnabled = 0 OR DriveBroken = 1 OR
									Attributes & 256 > 0))
	--do not consider NBU mediaagent
	SET @l_TotalMACount = (select count(*) from #temp_ma WITH (READUNCOMMITTED) where ClientId > 1
							AND ClientId NOT IN (select id from @tmpExternalClient)
							AND (@MAId = 0 OR ClientId in (select t_id from @tblMA)))
	SET @l_OffLineMACount = (select count(*)
								from #temp_ma WITH (READUNCOMMITTED)
								where ClientId > 1 AND
									(MMHostSoftState = 0 OR MMHostEnabled = 0 OR
									Attribute & 16 > 0)
									AND ClientId NOT IN (select id from @tmpExternalClient)
									AND (@MAId = 0 OR ClientId in (select t_id from @tblMA)))
-- 24/08/08 -- chandra(knaidu@commvault.com)
-- We don't have information about the all the clients
-- So we are going report only the clients that are selected
--
--	SET @l_TotalClientCount	= (select count(*) from App_Client  WITH (READUNCOMMITTED)
--								WHERE id in ( select clientId from APP_IDAName WITH (READUNCOMMITTED)
--												WHERE clientid NOT IN (select clientid from APP_Platform WITH (READUNCOMMITTED)  WHERE platformtype =1)))
--								+  (select count(*) from App_Client as C WITH (READUNCOMMITTED), APP_Platform as AP WITH (READUNCOMMITTED)
--										WHERE C.id =AP.ClientId AND AP.platformtype =1)
	IF OBJECT_ID('tempdb..#ExcludedClients') IS NOT NULL DROP TABLE #ExcludedClients
	CREATE TABLE #ExcludedClients (ClientId int)
	INSERT INTO #ExcludedClients
		SELECT DISTINCT CL.id							-- Client IDs of DAG Member Servers
		FROM  APP_ClientProp CP WITH (NOLOCK) INNER JOIN APP_Client CL WITH (NOLOCK)
			  ON CL.net_hostname LIKE CP.attrName
		WHERE CP.attrType = 125 AND CP.modified = 0
	SET @l_TotalClientCount	= (select count(distinct S.ClientId)
								from #tmpCCRToSubClient S WITH (READUNCOMMITTED) left outer join #ExcludedClients EC ON S.ClientId = EC.ClientId
where not (EC.ClientId is not null and S.appTypeId = 53) -- excluding Exchange DB subclients of DAG Member Servers
								and CCRId = @i_CCRId
								AND  (@clOpt = 0 OR EXISTS (SELECT t_clId FROM @tblClients where t_clId = S.clientId)) )
	SET @l_OffLineClientCount = (select count(distinct S.ClientId)
									from #tmpCCRToSubClient S WITH (READUNCOMMITTED) left outer join #ExcludedClients EC ON S.ClientId = EC.ClientId
where not (EC.ClientId is not null and S.appTypeId = 53 and CCRResultFlag = 64) -- excluding Exchange DB subclients of DAG Member Servers with backup disabled
									and CCRId = @i_CCRId
AND (@disabledCliententities = 1 OR (@disabledCliententities = 0 AND (CCRResultFlag& 64) != 64 ) )
									and CCRResultFlag <> 0
									AND  (@clOpt = 0 OR EXISTS (SELECT t_clId FROM @tblClients where t_clId = S.clientId)) )
	SELECT @l_TotalLibraryCount, @l_OffLineLibraryCount, @l_TotalDriveCount, @l_OffLineDriveCount,
	@l_TotalMACount, @l_OffLineMACount, @l_TotalClientCount, @l_OffLineClientCount
	DROP TABLE #tmpCCRToSubClient
	DROP TABLE #temp_ma
GO


IF EXISTS (select * from GxQscripts where name = 'CCRGetOffLineEntityCount')
	delete from GxQscripts where name = 'CCRGetOffLineEntityCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRGetOffLineEntityCount')
	delete from GXDBVersions where aliasname = 'CCRGetOffLineEntityCount'
GO

insert into GXDBVersions values(2, 'CCRGetOffLineEntityCount',  '00010009020800060000', 'CCRGetOffLineEntityCount', '00010009020800060000')
GO

