

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCRGetIndexServerCheck.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCRGetIndexServerCheck.sp,v $ $Id: CCRGetIndexServerCheck.sp,v 1.1.2.4 2020/05/26 17:59:19 samrutkar Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "MMS2UpdateSlotNBayConfig"								|
--	|																		|
--	|THIS PROCEDURE WILL TEST TO SEE IF THE STRING "NEWSTRING" IS ALREADY A	|
--	| NAME IN THE TABLE, AND IF NOT INSERTS IT BEFORE RETURNING ALL ROWS 	|
--	| THAT MATCH THE SEARCH CRITERIA "ID < compVal".						|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A STORED PROCEDURE		|
--	| AND RETURNING RESULTS	                                                |
--  | Tinku:CCM:Archive File Id's are no longer unique						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCRGetIndexServerCheck')
BEGIN
	print '>>> Drop Stored Procedure: CCRGetIndexServerCheck <<<'
	drop procedure CCRGetIndexServerCheck
END
IF EXISTS (select * from GxQscripts where name='CCRGetIndexServerCheck')
	delete from GxQscripts where name = 'CCRGetIndexServerCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRGetIndexServerCheck')
	delete from GXDBVersions where aliasname = 'CCRGetIndexServerCheck'
GO
print '... Creating Procedure: CCRGetIndexServerCheck'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCRGetIndexServerCheck
  @in_CCRId integer
AS
  DECLARE @clientId integer
  DECLARE @cloudId integer
IF object_id('tempdb.dbo.#tmpCCRClientInputInternal') IS NOT NULL drop table #tmpCCRClientInputInternal
CREATE TABLE #tmpCCRClientInputInternal
                        (   ClientId        integer,
                            subclientId     integer,
                            INSTANCE        integer,
                            appTypeId       integer
                        )
IF object_id('tempdb.dbo.#tmpClientProxyPairs') IS NOT NULL drop table #tmpClientProxyPairs
CREATE TABLE #tmpClientProxyPairs(ClientId      integer,
                            instanceId          integer,
                            proxyClientId           integer,
                            ClientAppType               integer,
                        isIndexServer               integer DEFAULT 0,  --0 meaning proxyclient, 1 meaning index server
                        iscloudindexServer  integer DEFAULT 0,    -- 1 meaning cloud index server
                        cloudindexServer    integer DEFAULT 0,
                        isproxyclientGroup  integer DEFAULT 0 , -- 1 meaning client Group
                        clientGroup         integer DEFAULT 0,
                        subclientId         integer DEFAULT 0,
						cloudId          integer DEFAULT 0,
                        )
    INSERT INTO #tmpCCRClientInputInternal
     SELECT DISTINCT A.CLIENTID,A.Id, A.INSTANCE ,A.appTypeId
        FROM APP_Application A (NOLOCK)
        INNER JOIN CCRToSubClient C (NOLOCK) ON C.subclientId = A.Id AND C.CCRId = @in_CCRId
        And (A.subclientStatus & 6) = 0     -- uninstalled OR deleted
		where @in_CCRId != 0
		UNION
		SELECT DISTINCT A.CLIENTID,A.Id, A.INSTANCE ,A.appTypeId
        FROM APP_Application A (NOLOCK)
        INNER JOIN CCRToSubClient C (NOLOCK) ON C.subclientId = A.Id
        And (A.subclientStatus & 6) = 0     -- uninstalled OR deleted
		where @in_CCRId = 0
    -- Get the Client and proxy pairs here
    EXEC APPGetProxyClientInfo   '#tmpCCRClientInputInternal','#tmpClientProxyPairs',1
	SELECT DISTINCT I.clientId,DC.cloudId
		FROM DM2SearchServerCoreInfo DS
		INNER JOIN Dm2Cloud DC ON
		DS.cloudid = DC.cloudId
		INNER JOIN #tmpClientProxyPairs I ON
		I.cloudIndexServer  = DC.pseudoClientId
		AND I.iscloudindexServer =1
		UNION
	 SELECT DISTINCT subquery.ClientId, D.cloudId from APP_SubclientProp SubP  WITH (NOLOCK)
	        INNER JOIN APP_CLIENT AC  WITH (NOLOCK) on AC.name = SubP.attrVal
	        INNER JOIN (
	                SELECT sp.attrVal, APP.appTypeId, APP.INSTANCE, APP.ClientId
                    FROM APP_SubClientProp SP  WITH (NOLOCK)
                         INNER JOIN APP_Application APP  WITH (NOLOCK)  ON SP.componentNameId = APP.ID AND SP.modified = 0 AND attrName like 'Associated subclient Policy' AND cs_attrName = CHECKSUM(N'Associated subclient Policy')
                         INNER JOIN CCRToSubClient C (NOLOCK) ON C.subclientId = APP.id AND (C.CCRId = @in_CCRId)
                         where (APP.subclientStatus & 6) = 0 AND @in_CCRId != 0
					UNION
		 			SELECT sp.attrVal, APP.appTypeId, APP.INSTANCE, APP.ClientId
                    FROM APP_SubClientProp SP  WITH (NOLOCK)
                         INNER JOIN APP_Application APP  WITH (NOLOCK)  ON SP.componentNameId = APP.ID AND SP.modified = 0 AND attrName like 'Associated subclient Policy' AND cs_attrName = CHECKSUM(N'Associated subclient Policy')
                         INNER JOIN CCRToSubClient C (NOLOCK) ON C.subclientId = APP.id
                         where (APP.subclientStatus & 6) = 0 AND @in_CCRId = 0
					   ) subquery on SubP.componentNameId  = subquery.attrVal AND attrName = '3dfs NFS Servers' AND SubP.modified = 0
	                   INNER JOIN App_EdgeDriveAssociation WITH (NOLOCK) ON subquery.clientId = App_EdgeDriveAssociation.clientId
	                                    INNER JOIN DM2Cloud D WITH (NOLOCK) ON D.pseudoClientId = App_EdgeDriveAssociation.entityId
	                                    and entityType = 3
IF OBJECT_ID('tempdb.dbo.#tmpClientProxyPairs') IS NOT NULL drop table #tmpClientProxyPairs
IF OBJECT_ID('tempdb.dbo.#tmpCCRClientInputInternal') IS NOT NULL drop table #tmpCCRClientInputInternal
IF OBJECT_ID('tempdb.dbo.#tmpClientProxyPairs') IS NOT NULL drop table #tmpClientProxyPairs

IF EXISTS (select * from GxQscripts where name = 'CCRGetIndexServerCheck')
	delete from GxQscripts where name = 'CCRGetIndexServerCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRGetIndexServerCheck')
	delete from GXDBVersions where aliasname = 'CCRGetIndexServerCheck'
GO

insert into GXDBVersions values(2, 'CCRGetIndexServerCheck',  '00010001000200040000', 'CCRGetIndexServerCheck', '00010001000200040000')
GO

