

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCRGetIndexCacheOffLineReasons.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCRGetIndexCacheOffLineReasons.sp,v $ $Id: CCRGetIndexCacheOffLineReasons.sp,v 1.15.40.8.20.1 2021/03/09 23:53:20 nbirru Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "MMS2UpdateSlotNBayConfig"								|
--	|																		|
--	|THIS PROCEDURE WILL TEST TO SEE IF THE STRING "NEWSTRING" IS ALREADY A	|
--	| NAME IN THE TABLE, AND IF NOT INSERTS IT BEFORE RETURNING ALL ROWS 	|
--	| THAT MATCH THE SEARCH CRITERIA "ID < compVal".						|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A STORED PROCEDURE		|
--	| AND RETURNING RESULTS	                                                |
--  | Tinku:CCM:Archive File Id's are no longer unique						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CCRGetIndexCacheOffLineReasons')
BEGIN
	print '>>> Drop Stored Procedure: CCRGetIndexCacheOffLineReasons <<<'
	drop procedure CCRGetIndexCacheOffLineReasons
END
IF EXISTS (select * from GxQscripts where name='CCRGetIndexCacheOffLineReasons')
	delete from GxQscripts where name = 'CCRGetIndexCacheOffLineReasons'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRGetIndexCacheOffLineReasons')
	delete from GXDBVersions where aliasname = 'CCRGetIndexCacheOffLineReasons'
GO
print '... Creating Procedure: CCRGetIndexCacheOffLineReasons'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CCRGetIndexCacheOffLineReasons
  @in_ClientList varchar(max)
AS
  DECLARE @o_ClientId integer
  DECLARE @ClientName varchar(255)
  DECLARE @ClientNetHostName varchar(255)
  DECLARE @IdxAccessPathId integer
  DECLARE @IdxCacheId integer
  DECLARE @IdxCachePath varchar(255)
  DECLARE @Enabled integer
  DECLARE @SoftState integer
  DECLARE @o_OfflineReason integer
  DECLARE @Priority integer
  DECLARE @IdxLowSpace integer
--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	IF object_id('TempDB.dbo.#tmpMMHostId') IS NOT NULL drop table #tmpMMHostId
	create table #tmpMMHostId	(tClientId	integer,
								HostSoftState	integer,
								HostEnabled	integer)
	DECLARE @tmpExternalClient TABLE (id INT)
	--Get NBU client list
	INSERT INTO @tmpExternalClient
	SELECT C.id
	FROM APP_Client C WITH (READUNCOMMITTED) , APP_CommCell Cell WITH (READUNCOMMITTED)
	WHERE C.origCCId = Cell.id and Cell.type = 100
	UNION
    -- These are POWER MANAGED MA CLIENT which are off presently
    SELECT C.id
    FROM APP_Client C WITH (READUNCOMMITTED)
    INNER JOIN  MMHost as MH WITH (READUNCOMMITTED)
ON MH.ClientId =C.id AND (MH.Attribute & 32768) = 32768 AND MH.OfflineReason=7
	IF(@in_ClientList = '')
	BEGIN
		insert into #tmpMMHostId
		select MH.ClientId, MH.MMHostSoftState, MH.MMHostEnabled
		from MMHost as MH WITH (READUNCOMMITTED)
where MH.ClientId > 1 AND RolesBitMask & 2 > 0 --Only use the MA having Index Role assigned
	END
	ELSE
	BEGIN
		insert into #tmpMMHostId
exec ('SELECT distinct ClientId, MMHostSoftState, MMHostEnabled FROM MMHost WITH (READUNCOMMITTED) WHERE RolesBitMask & 2 > 0 AND ClientId IN ' + @in_ClientList)
	END
	--skip physicalVM clients from index cache readiness
	DELETE #tmpMMHostId
	WHERE tClientId in (select PMClientID from APP_VMToPMMap)
	-- skip external NBU clients
	delete  #tmpMMHostId FROM #tmpMMHostId, @tmpExternalClient WHERE tClientId = id
	--Update the Index Accesspath table with the proper reason when the mediaAgant is either not reachable or disables.
	UPDATE IdxAccessPath
	SET OfflineReason = 12
	FROM #tmpMMHostId as tt, IdxAccessPath as IDX WITH (READUNCOMMITTED)
	WHERE OfflineReason = 0 AND IDX.ClientId = tt.tClientId AND (tt.HostSoftState = 0 OR tt.HostEnabled = 0)
	--Update the Index Accesspath table with the proper reason when the mediaAgant is either not reachable or disables.
	UPDATE IdxAccessPath
	SET OfflineReason = 0
	FROM #tmpMMHostId as tt, IdxAccessPath as IDX WITH (READUNCOMMITTED)
	WHERE IDX.OfflineReason = 12 AND IDX.ClientId = tt.tClientId AND
	tt.HostSoftState = 1 AND tt.HostEnabled = 1
	IF OBJECT_ID('tempdb..#clientPropTbl') IS NOT NULL
		DROP TABLE #clientPropTbl
	CREATE TABLE #clientPropTbl (clientId INT, FreeDiskSpace BIGINT, AlertSpace BIGINT, IsCacheEnabled INT, MinimumSpace BIGINT, offlineReason INT)
	INSERT INTO #clientPropTbl
	SELECT  componentNameId                 AS clientId,
		    CASE ISNUMERIC([Idx: free disk size]) WHEN 1 THEN CAST([Idx: free disk size] AS BIGINT) ELSE 0 END  AS FreeDiskSpace,
			CASE ISNUMERIC([Idx: alert space]) WHEN 1 THEN CAST([Idx: alert space] AS BIGINT) ELSE 0 END AS AlertSpace,
			CASE ISNUMERIC([Idx: cache enabled]) WHEN 1 THEN CAST([Idx: cache enabled] AS INT) ELSE 0 END  AS IsCacheEnabled,
			CASE ISNUMERIC([Idx: min space]) WHEN 1 THEN CAST([Idx: min space] AS BIGINT) ELSE 0 END  AS MinimumSpace,
			CASE ISNUMERIC([Idx: disabled reason]) WHEN 1 THEN CAST([Idx: disabled reason] AS BIGINT) ELSE 0 END  AS offlineReason
	FROM    (SELECT cp.componentNameId, cp.attrName, cp.attrVal
			 FROM #tmpMMHostId H INNER JOIN APP_ClientProp as cp ON H.tClientId = cp.componentNameId AND modified = 0) AS clients
	PIVOT
	(
		MAX(attrVal) FOR attrName IN ([Idx: free disk size], [Idx: alert space], [Idx: cache enabled], [Idx: min space], [Idx: disabled reason])
	) AS P
	UPDATE #clientPropTbl
	SET IsCacheEnabled = 0,
	Offlinereason = 12
	FROM #tmpMMHostId as tt, #clientPropTbl as IDX WITH (READUNCOMMITTED)
	WHERE IsCacheEnabled = 1 AND IDX.ClientId = tt.tClientId AND (tt.HostSoftState = 0 OR tt.HostEnabled = 0)
	SELECT cl.Id, cl.displayname, cl.net_HostName, IDX.IdxAccessPathId, IDX.IdxCacheId, IDX.Path,
	IDX.Enabled, IDX.SoftState,
	(CASE WHEN cl.releaseId = 16
				-- Following are enums defined in mms2idxdefines.h. In 11.0 we have just 4 limited valid reasons which is populated by MM service in App_ClientProp
				-- As the 10.0 and 11.0 reports code is common, we have to map new codes to old ones (from "IndexCacheOfflineReason" enum to "IndexAccessPathOfflineReason" enum)
			THEN CASE IsCacheEnabled
					WHEN 1 THEN 0
					ELSE (CASE CP.offlineReason
							WHEN 2 THEN 14							-- IDXCACHE_NOT_ACCESSIBLE (mms2idxdefines.h)
							WHEN 3 THEN 13							-- IDXACCPATH_DISK_FULL (mms2idxdefines.h)
							ELSE CP.offlineReason					-- 0: IDXCACHE_OFFLINE_DEFAULT OR 1: IDXACCPATH_CACHEDISABLED
						END)
				 END
		  ELSE IDX.OfflineReason
	END) AS OfflineReason, IDX.Priority,
	(CASE WHEN cl.releaseId = 16 THEN 0
		  ELSE cl.spaceCheckFlags END) spaceCheckFlags
	FROM IdxAccessPath as IDX WITH (READUNCOMMITTED)
		 INNER JOIN IdxCache IC WITH (READUNCOMMITTED) ON IC.IdxCacheId = IDX.IdxCacheId AND IC.IdxCacheType = 1
		 INNER JOIN APP_Client as cl ON IDX.ClientId = cl.Id
		 INNER JOIN #tmpMMHostId as tt ON tt.tClientId = cl.Id
		 LEFT OUTER JOIN #clientPropTbl CP ON tt.tClientId = CP.clientId
	ORDER BY cl.Name
	DROP TABLE #tmpMMHostId
	DROP TABLE #clientPropTbl
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CCRGetIndexCacheOffLineReasons')
	delete from GxQscripts where name = 'CCRGetIndexCacheOffLineReasons'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRGetIndexCacheOffLineReasons')
	delete from GXDBVersions where aliasname = 'CCRGetIndexCacheOffLineReasons'
GO

insert into GXDBVersions values(2, 'CCRGetIndexCacheOffLineReasons',  'v1.15.40.8.20.1', 'CCRGetIndexCacheOffLineReasons', 'v1.15.40.8.20.1')
GO

