

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCRGetErrorCodesForRpt.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCRGetErrorCodesForRpt.sp,v $ $Id: CCRGetErrorCodesForRpt.sp,v 1.27.2.43 2020/11/03 08:13:06 nbirru Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "MMS2UpdateSlotNBayConfig"								|
--	|																		|
--	|THIS PROCEDURE WILL TEST TO SEE IF THE STRING "NEWSTRING" IS ALREADY A	|
--	| NAME IN THE TABLE, AND IF NOT INSERTS IT BEFORE RETURNING ALL ROWS 	|
--	| THAT MATCH THE SEARCH CRITERIA "ID < compVal".						|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A STORED PROCEDURE		|
--	| AND RETURNING RESULTS	                                                |
--  | Tinku:CCM:Archive File Id's are no longer unique						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CCRGetErrorCodesForRpt')
BEGIN
	print '>>> Drop Stored Procedure: CCRGetErrorCodesForRpt <<<'
	drop procedure CCRGetErrorCodesForRpt
END
IF EXISTS (select * from GxQscripts where name='CCRGetErrorCodesForRpt')
	delete from GxQscripts where name = 'CCRGetErrorCodesForRpt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRGetErrorCodesForRpt')
	delete from GXDBVersions where aliasname = 'CCRGetErrorCodesForRpt'
GO
print '... Creating Procedure: CCRGetErrorCodesForRpt'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CCRGetErrorCodesForRpt
  @i_CCRId integer,
  @i_ClientId integer,
  @i_appTypeId integer,
  @i_userId integer,
  @i_excludeDisabled integer,
  @i_additionresoucechk integer,
  @tableOutput VARCHAR(MAX) = '',
  @i_CSCCCheck integer
AS
  DECLARE @o_clientId integer
  DECLARE @o_clientName varchar(255)
  DECLARE @o_clientNetHostName varchar(255)
  DECLARE @o_SubClientId integer
  DECLARE @o_SubClientName varchar(255)
  DECLARE @o_SpName varchar(255)
  DECLARE @o_MAName varchar(255)
  DECLARE @o_DataPathId integer
  DECLARE @o_AppTypeId integer
  DECLARE @o_CCRResultFlag integer
  DECLARE @o_CCRNetworkReadinessFlag integer
  DECLARE @o_CCRResourceReadinessFlag integer
  DECLARE @o_lastUnCompressBytes bigint
  DECLARE @o_lastCompBytes bigint
  DECLARE @o_capacityAvailable bigint
  DECLARE @o_DataPathReadinessFlag integer
  DECLARE @o_MAHostClientId integer
  DECLARE @o_MANetHostName varchar(255)
  DECLARE @o_DrivePoolId integer
  DECLARE @o_DrivePoolName varchar(255)
  DECLARE @o_MasterPoolId integer
  DECLARE @o_MasterPoolName varchar(255)
  DECLARE @o_LibraryId integer
  DECLARE @o_LibraryName varchar(255)
  DECLARE @o_MountPathId integer
  DECLARE @o_MountPathName varchar(255)
  DECLARE @o_CCToMANetCheckErrorCode integer
  DECLARE @o_MAToCCNetCheckErrorCode integer
  DECLARE @o_MAToCSNetCheckErrorCode integer
  DECLARE @o_CCToCSNetCheckErrorCode integer
  DECLARE @o_CSToCCNetCheckErrorCode integer
  DECLARE @o_CSToMANetCheckErrorCode integer
  DECLARE @o_spaceCheckFlag integer
  DECLARE @o_DIPErrorCodes varchar(MAX)
  DECLARE @o_DataWritten bigint
  DECLARE @o_xml xml
  DECLARE @o_RemoteCachexml NVARCHAR(MAX)
  DECLARE @o_ProxyClientxml NVARCHAR(MAX)
--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE  @FetchWebReport INT = 0
	IF (@tableOutput <> '')
	BEGIN
		IF object_id('tempdb.dbo.' +@tableoutput) IS NULL
        BEGIN
            PRINT 'Invalid Table Object'
            RETURN
        END
		SET @FetchWebReport= 1
	END
	declare @in_CCRId 		integer
	declare @in_AppTypeId 	integer
	declare @CommServe_Id	integer
	set @CommServe_Id = (select top(1)clientId from APP_Platform WITH (READUNCOMMITTED) where (platformType & 1) = 1 order by clientId asc)
	set @in_CCRId = @i_CCRId
	set @in_AppTypeId = @i_appTypeId
	IF OBJECT_ID('tempdb..#CCRIdSubclient') IS NOT NULL DROP TABLE #CCRIdSubclient
	CREATE TABLE #CCRIdSubclient (CCRId INT, appId INT,appTypeId int,clientId int)
	IF (@in_CCRId = 0)
	BEGIN
		INSERT INTO #CCRIdSubclient
		select max(CCRId),SubClientId,CCR.apptypeId,CCR.clientId from CCRToSubClient CCR
		INNER JOIN APP_Application AP ON AP.id = CCR.SubClientId group by SubClientId,CCR.apptypeId,CCR.clientId
		DELETE C
		FROM (SELECT MAX(CCRID) as ccrid,clientId from #CCRIdSubclient group by clientId) T
		INNER JOIN #CCRIdSubclient C ON T.clientId = C.clientId AND T.ccrid <> C.ccrid
		INSERT INTO #CCRIdSubclient
		select max(ccrId), 0,0,CCR.clientId from CCRToSubClient CCR where SubClientId = 0
		GROUP BY ClientId
	END
	ELSE
	BEGIN
		IF (@i_ClientId = 0)
		BEGIN
			INSERT INTO #CCRIdSubclient
			select CCRId,SubClientId,CCR.apptypeId,CCR.clientId from CCRToSubClient CCR where CCRId = @in_CCRId
		END
		ELSE
		BEGIN
			INSERT INTO #CCRIdSubclient
			select CCRId,SubClientId,CCR.apptypeId,CCR.clientId from CCRToSubClient CCR where CCRId = @in_CCRId and clientId = @i_ClientId
		END
	END
	IF @i_userId > 0
	BEGIN
		IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @i_userId,  2013, 0, '#rptUserObjects'  --SUB_CLIENT_ITEM
		delete #rptUserObjects
		WHERE clientGroupId <> 0 OR commcellID <> 2
		DELETE t
		FROM #CCRIdSubclient t INNER JOIN App_application AP ON Ap.clientId = t.clientId AND (AP.id = t.appId)
		LEFT OUTER JOIN #rptUserObjects u ON
		(u.clientId = t.clientId or u.clientId = 0)
		AND (u.appTypeId = t.appTypeId or u.apptypeId = 0)
		AND (u.instanceId = AP.instance or u.instanceId = 0)
		AND (u.backupsetId = AP.backupSet or u.backupsetId = 0)
		AND (u.subClientId  = t.appId or u.subclientId = 0)
		where t.appId != 0 AND u.clientId IS NULL AND u.appTypeId IS NULL AND u.instanceId IS NULL AND u.backupsetId IS NULL AND u.subClientId IS NULL
		DELETE t
		FROM #CCRIdSubclient t INNER JOIN App_application AP ON Ap.clientId = t.clientId
		LEFT OUTER JOIN #rptUserObjects u ON
		(u.clientId = t.clientId or u.clientId = 0)
		AND (u.appTypeId = t.appTypeId or u.apptypeId = 0)
		AND (u.instanceId = AP.instance or u.instanceId = 0)
		AND (u.backupsetId = AP.backupSet or u.backupsetId = 0)
		AND (u.subClientId  = t.appId or u.subclientId = 0)
		where t.appId = 0 AND u.clientId IS NULL AND u.appTypeId IS NULL AND u.instanceId IS NULL AND u.backupsetId IS NULL AND u.subClientId IS NULL
		DROP TABLE #rptUserObjects
	END
	if object_id('tempdb.dbo.#tmpResult1') is not null DROP TABLE #tmpResult1
	IF object_id('TempDB.dbo.#tmpDataPath1') IS NOT NULL drop table #tmpDataPath1
	If object_id('TempDB.dbo.#tmpDataInterfacePairs') IS NOT NULL drop table #tmpDataInterfacePairs
	if object_id('tempdb.dbo.#tmpDDBResult1') is not null DROP TABLE #tmpDDBResult1
	create table #tmpDDBResult1( clientId		integer,
					SubClientId					integer,
					DataPathId					integer,
					MAHostClientId				integer,
					CCToDDBMANetCheckErrorCode	integer,
					DDBMAToCCNetCheckErrorCode	integer,
					DDBMAToMANetCheckErrorCode	integer,
					MAToDDBMANetCheckErrorCode	integer,
					DDBMAHostClientId			integer,
					DDBMAHostName				varchar(1024)
	)
	if object_id('tempdb.dbo.#tmpRemoteCacheResult1') is not null DROP TABLE #tmpRemoteCacheResult1
	create table #tmpRemoteCacheResult1( clientId		integer,
					SubClientId					integer,
					RemoteClientId				integer,
					CCToRemoteClientNetCheckErrorCode	integer,
					RemoteClientToCCNetCheckErrorCode	integer,
					RemoteClientHostName				varchar(1024),
					isIndexServer				integer DEFAULT 0  --0 meaning remote cache client, 1 meaning index server client
	)
	if object_id('tempdb.dbo.#tmpproxyClientResult1') is not null DROP TABLE #tmpproxyClientResult1
	create table #tmpproxyClientResult1( clientId		integer,
					SubClientId					integer,
					proxyClientId				integer,
					MAHostClientId		integer,
					proxyCCToMANetCheckErrorCode	integer,
					MAToproxyCCNetCheckErrorCode	integer,
					proxyCCToCSNetCheckErrorCode	integer,
					CSToproxyCCNetCheckErrorCode	integer,
					proxyClientHostName				varchar(1024),
					proxyMAHostName					varchar(1024),
					isDDBMA				int ,
					isIndexServer				integer DEFAULT 0  ,--0 meaning proxyclient, 1 meaning index server
					iscloudindexServer 	integer DEFAULT 0,    -- 1 meaning cloud index server
					cloudindexServer 	integer DEFAULT 0,
					isproxyclientGroup 	integer DEFAULT 0 , -- 1 meaning client Group
					clientGroup		 	integer DEFAULT 0
	)
	if object_id('tempdb.dbo.#tmpProxyClientDDBResult1') is not null DROP TABLE #tmpProxyClientDDBResult1
	create table #tmpProxyClientDDBResult1( clientId		integer,
					SubClientId						integer,
					proxyClientId					integer,
					proxyCCToDDBMANetCheckErrorCode	integer,
					DDBMAToproxyCCNetCheckErrorCode	integer,
					DDBMAHostClientId			integer,
					DDBMAHostName				varchar(1024)
	)
	create table #tmpResult1( 	clientId		integer,
					SubClientId		integer,
					DataPathId		integer,
					AppTypeId		integer,
					CCRResultFlag		integer,
					CCRNetworkReadinessFlag			integer,
					CCRResourceReadinessFlag		integer,
					lastUnCompressBytes	bigint,
					lastCompBytes		bigint,
					capacityAvailable	bigint,
					DataPathReadinessFlag	integer,
					MAHostClientId		integer,
					LibraryId		integer,
					LibraryTypeId		integer,
					MountPathId		integer,
					DrivePoolId		integer,
					MasterPoolId		integer,
					CCToMANetCheckErrorCode	integer,
					MAToCCNetCheckErrorCode	integer,
					MAToCSNetCheckErrorCode	integer,
					CCToCSNetCheckErrorCode	integer,
					CSToCCNetCheckErrorCode	integer,
					CSToMANetCheckErrorCode	integer,
					clientName				nvarchar(1024),
					clientHostName			nvarchar(1024),
					MAHostName				nvarchar(1024),
					LibraryName				nvarchar(1024),
					MountPathName			nvarchar(1024),
					DrivePoolName			nvarchar(1024),
					MasterPoolName			nvarchar(1024),
					SubClientName			nvarchar(1024),
					SpName					nvarchar(1024),
					MAName					nvarchar(1024),
					spaceCheckFlag	integer,
					DIPErrorCodes			varchar(1024),
					dataWritten					BIGINT,
					report_RptDDBMAResp xml,
					report_RptRemoteCacheResp xml,
					report_RptproxyClientResp xml
					)
	IF object_id('tempdb.dbo.#tmpProxyPairs') IS NOT NULL drop table #tmpProxyPairs
	create table #tmpProxyPairs(ClientId		integer,
							proxySourceClientId			integer,
							proxyDestinationClientId	integer,
							proxyDestinationNetCheckErrorCode integer,
							proxyDestinatioHostName			nvarchar(1024),
							ClientAppType				integer,
							isIndexServer				integer DEFAULT 0 , --0 meaning proxyclient, 1 meaning index server
							iscloudindexServer 	integer DEFAULT 0,    -- 1 meaning cloud index server
							cloudindexServer 	integer DEFAULT 0,
							isproxyclientGroup 	integer DEFAULT 0 , -- 1 meaning client Group
							clientGroup		 	integer DEFAULT 0
			)
	create table #tmpDataPath1	(DataPathId		integer,
					 HostClientId		integer,
					 ReadinessFlag		integer,
					 DrivePoolId		integer)
	create table #tmpDataInterfacePairs (
					clientId	integer,
					clientInterface varchar(1024),
					mediaAgentId integer,
					mediaAgentInterface varchar(1024),
					errorCode1		integer,
					errorCode2		integer,
					errorCode		varchar(1024),
					flag			integer
					)
	insert into #tmpDataPath1
	select distinct MD.DataPathId, MDP.ClientId, MD.ReadinessFlag, MD.DrivePoolId
	From MMDrivePool as MDP WITH (READUNCOMMITTED), MMDataPath as MD WITH (READUNCOMMITTED)
	where MD.DrivePoolId = MDP.DrivePoolId
	-- CLIENT TO DDB MA INFORMATION
	IF object_id('TempDB.dbo.#tmpClientDDBMAPairs') IS NOT NULL drop table #tmpClientDDBMAPairs
	create table #tmpClientDDBMAPairs(
							subclientId			integer,
							ClientId			integer,
							MAClientId			integer
							)
	-- CLIENT TO remote cache client INFORMATION
	IF object_id('TempDB.dbo.#tmpClientRemoteCachePairs') IS NOT NULL drop table #tmpClientRemoteCachePairs
	create table #tmpClientRemoteCachePairs(
							subclientId			integer,
							ClientId			integer,
							AssociateremotecacheClientId			integer,
							isIndexServer				integer DEFAULT 0  --0 meaning proxyclient, 1 meaning index server
							)
	IF object_id('tempdb.dbo.#tmpClientRemoteCachePairsAll') IS NOT NULL drop table #tmpClientRemoteCachePairsAll
	create table #tmpClientRemoteCachePairsAll(ClientId		integer,
						RemoteClientId			integer,
						RemoteClientCategory 			integer DEFAULT 0  --1 remoteclient, 4 LM
							)
	CREATE INDEX #tmpClientRemoteCachePairsAll_ClientId on #tmpClientRemoteCachePairsAll (ClientId)
		-- additional check
	if(@i_additionresoucechk=1)
	EXEC CCRGetRemoteCachePairInfo  @in_CCRId ,'#tmpClientRemoteCachePairsAll'
	IF object_id('tempdb.dbo.#tempSubclientProp') IS NOT null DROP TABLE #tempSubclientProp
	CREATE TABLE #tempSubclientProp(
	subClientId					integer,
	associatedsubclientPolicyId 	integer,
	Deduplication				integer
	)
	CREATE INDEX #tempSubclientProp_SubClientId on #tempSubclientProp( SubClientId)
	IF object_id('tempdb.dbo.#appid') IS NOT null DROP TABLE #appid
	CREATE TABLE #appId (subclientId INT,AppTypeId INT,ClientId INT)
	INSERT INTO #appId
select sc.appId,sc.AppTypeId,sc.ClientId from #CCRIdSubclient SC where SC.AppTypeId NOT IN (13,88,84)
	INSERT INTO #tempSubclientProp (subClientId,associatedsubclientPolicyId,Deduplication)
	SELECT sc.subClientId,prop.attrVal, ISNULL(SProp.attrVal,1) FROM #appid sc
	INNER JOIN APP_SubclientProp prop WITH (NOLOCK) ON  prop.componentNameId = sc.subClientId AND prop.attrName = 'Associated subclient Policy' AND prop.modified = 0
	LEFT OUTER JOIN APP_SubclientProp SProp WITH (NOLOCK) ON  SProp.componentNameId =  prop.attrVal AND SProp.attrName = 'Single Instancing Option'  AND SProp.modified = 0
	INSERT INTO #tempSubclientProp (subClientId,associatedsubclientPolicyId,Deduplication)
	SELECT sc.subClientId,0, ISNULL(prop.attrVal,1) FROM #appid sc
	LEFT OUTER JOIN APP_SubclientProp prop WITH (NOLOCK) ON  prop.componentNameId = sc.subClientId AND prop.attrName = 'Single Instancing Option' AND prop.modified = 0
	LEFT OUTER JOIN #tempSubclientProp SProp WITH (NOLOCK) ON  SProp.subClientId = sc.subClientId
	WHERE SProp.subClientId is NULL
	insert into  #tmpClientRemoteCachePairs
	SELECT DISTINCT sc.subclientid, sc.ClientId ,  pa.RemoteClientId as remotecache, CASE WHEN pa.RemoteClientCategory = 1 THEN 0 ELSE 1 END
	FROM #appid sc INNER JOIN #tmpClientRemoteCachePairsAll(nolock)   AS pa ON
	pa.clientId =  sc.ClientId
--	and pa.RemoteClientCategory = 0
	insert into #tmpClientDDBMAPairs
		SELECT DISTINCT sc.subclientid, sc.clientId,  IdxSS.ClientId as ddbMAid
		FROM #appid AS sc INNER JOIN app_application(nolock)   AS AA ON
			aa.id=sc.subclientid
			INNER JOIN #tempSubclientProp prop with (readuncommitted)  ON
			sc.subClientId = prop.subClientId
			and  prop.Deduplication = 1
			INNER JOIN archGroup(nolock) AG ON AA.dataArchGrpId = AG.id
			INNER JOIN archSubclientCopyDDBMap CSD WITH (READUNCOMMITTED) ON CSD.copyID = AG.defaultCopy AND CSD.appId = SC.subClientId
			INNER JOIN  IdxSIDBSubStore(nolock) IdxSS ON CSD.SIDBStoreId = IdxSS.SIDBStoreId
			AND
			 IdxSS.ClientId NOT IN (SELECT HostClientId FROM MMDataPath WHERE CopyId = AG.defaultCopy)
			  AND IdxSS.ClientId <> sc.clientId
			  AND CSD.SIDBStoreId > 0
	IF object_id('tempdb.dbo.#tempSubclientProp') IS NOT NULL drop table #tempSubclientProp
	-- DDB MA TO MA INFORMATION
	IF object_id('TempDB.dbo.#tmpMADDBMAPairs') IS NOT NULL drop table #tmpMADDBMAPairs
	create table #tmpMADDBMAPairs(
							subclientid			integer,
							MAClientId			integer,
							DDBMAClientId		integer
							)
		IF OBJECT_ID('tempdb..#CCRIdSubclientwithDataPath') IS NOT NULL DROP TABLE #CCRIdSubclientwithDataPath
		CREATE TABLE #CCRIdSubclientwithDataPath (subclientId INT, dataArchGrpId INT, DataPathId INT)
		INSERT INTO #CCRIdSubclientwithDataPath
		SELECT distinct CSC.subclientid,AA.dataArchGrpID, CSC.DataPathId  FROM #CCRIdSubclient SC
				INNER JOIN app_application(nolock)   AS AA ON aa.id=sc.appId
				INNER JOIN CCRToSubClient(nolock) CSC ON
				 CSC.CCRId = sc.CCRId and CSC.clientId = sc.clientId and CSC.subclientId = sc.appId
where  AA.appTypeId not in  (13,88,84)
				insert into #tmpMADDBMAPairs
				select DISTINCT SC.subclientId,DP.HostClientId, IdxSS.ClientId  FROM #CCRIdSubclientwithDataPath SC
				INNER JOIN archGroup(nolock) AG ON SC.dataArchGrpId = AG.id
				INNER JOIN archSubclientCopyDDBMap CSD WITH (READUNCOMMITTED) ON CSD.copyID = AG.defaultCopy AND CSD.appId = SC.subClientId
				INNER JOIN  IdxSIDBSubStore(nolock) IdxSS ON CSD.SIDBStoreId = IdxSS.SIDBStoreId
				INNER JOIN MMDatapath(nolock) DP ON DP.CopyId = AG.defaultCopy and sc.DataPathId = dp.DataPathId
				WHERE
				 IdxSS.ClientId <> DP.HostClientId
				AND CSD.SIDBStoreId > 0
		IF OBJECT_ID('tempdb..#CCRIdSubclientwithDataPath') IS NOT NULL DROP TABLE #CCRIdSubclientwithDataPath
	--delete #tmpClientDDBMAPairs from #tmpMADDBMAPairs ,#tmpClientDDBMAPairs clientDDB where 	#tmpMADDBMAPairs.subclientid = clientDDB.subclientId
	--and #tmpMADDBMAPairs.DDBMAClientId = clientDDB.MAClientId
	INSERT INTO #tmpMADDBMAPairs
	SELECT  DISTINCT sc.subclientid, sc.DataPathId,AA.MAClientId
	FROM CCRToSubClient(nolock) AS sc INNER JOIN #tmpClientDDBMAPairs   AS AA ON
	AA.subclientid=sc.subclientid
	LEFT OUTER JOIN #tmpMADDBMAPairs   AS EXISTINGROWS ON
	EXISTINGROWS.subclientid = AA.subclientid AND EXISTINGROWS.MAClientId = AA.ClientId AND EXISTINGROWS.DDBMAClientId = AA.MAClientId
	where CCRId = @in_CCRId AND EXISTINGROWS.subclientid IS NULL
	INSERT into #tmpResult1
	select distinct CCRS.ClientId, CCRS.SubClientId, CCRS.DataPathId, CCRS.AppTypeId, CCRS.CCRResultFlag, CCRS.CCRNetworkReadinessFlag, CCRS.CCRResourceReadinessFlag,
	CCRS.lastUncompBytes, CCRS.lastCompBytes, CCRS.capacityAvailable, mcf.ReadinessFlag,
	mcf.HostClientId, 0, 0, 0, mcf.DrivePoolId, 0, 0, 0, 0, 0, 0, 0, '', '', '', '', '','', '', '', '','',0, NULL, CCRS.dataWritten,
	null,null,null
	from CCRToSubClient as CCRS WITH (READUNCOMMITTED) INNER JOIN #tmpDataPath1 as mcf
				ON mcf.DataPathId = CCRS.DataPathId AND (CCRS.ClientId = @i_ClientId OR @i_ClientId =0)	AND (CCRS.AppTypeId = @in_AppTypeId OR 0 = @in_AppTypeId)
				INNER JOIN #CCRIdSubclient CSC ON CSC.CCRId = CCRS.CCRId AND CSC.clientId = CCRS.ClientId AND CSC.appId = CCRS.SubClientId
	CREATE INDEX  #tmpResult1_ClientId_SubClientId_ApptypeId ON #tmpResult1 (ClientId,ApptypeId,SubClientId)
--fix need to do here for user capability Check
--got all qualified entries, do the security check before more details and summary
DELETE  T
FROM #tmpResult1 T
INNER JOIN simInstalledPackages P WITH (NOLOCK)
ON T.clientId = P.ClientId
INNER JOIN App_SubclientProp prop WITH (NOLOCK)
ON T.subclientId = prop.componentNameId
AND prop.cs_attrName = CHECKSUM(N'Index SubClient')
    AND     prop.attrName = N'Index SubClient'
    AND     prop.attrVal = '1'
    AND     prop.modified = 0
	--Updating this flags here so that if i_CSCCCheck is true then we will skip other computation
	update tt
    set CCToCSNetCheckErrorCode = cc.errorCode
    from CCRClientToClient as cc WITH (READUNCOMMITTED)
    INNER JOIN #tmpResult1 tt ON tt.clientId = cc.fromClientId
where tt.ApptypeId not in (13,88) AND @CommServe_Id = cc.ToClientId and cc.isdip = 0 AND
    cc.serviceType = 0
	update tt
    set CSToCCNetCheckErrorCode = cc.errorCode
    from CCRClientToClient as cc WITH (READUNCOMMITTED)
    INNER JOIN #tmpResult1 tt ON tt.clientId = cc.ToClientId
where tt.ApptypeId not in (13,88) AND @CommServe_Id = cc.fromClientId and cc.isdip = 0 AND
    cc.serviceType = 0
	IF ( @FetchWebReport = 0)
	update #tmpResult1
    set spaceCheckFlag = CL.spaceCheckFlags
    from APP_Client AS CL WITH (READUNCOMMITTED)
    where CL.id = #tmpResult1.ClientId
        and clientId not in (select PMClientID from APP_VMToPMMap WITH (READUNCOMMITTED)) --skip physical clients readiness
and (CCRResourceReadinessFlag  & 16 <> 0)
	IF (@i_CSCCCheck = 1)
		GOTO EXIT_CODE
	insert into #tmpRemoteCacheResult1
		select distinct tt.clientId,tt.SubClientId	,RemoteCachePairs.AssociateremotecacheClientId,0,0,'' , RemoteCachePairs.isIndexServer
	from #tmpResult1 tt inner join  #tmpClientRemoteCachePairs RemoteCachePairs ON
			RemoteCachePairs.SubClientId = tt.subclientId and RemoteCachePairs.clientId = tt.clientId
and tt.ApptypeId not in (13,88)
	update #tmpRemoteCacheResult1
	set RemoteClientHostName = CL.Net_HostName
	from APP_Client AS CL WITH (READUNCOMMITTED)
	where Cl.id = #tmpRemoteCacheResult1.RemoteClientId
	--tmpRemoteCacheResult1 UPDATING client to RemoteCache information
	update #tmpRemoteCacheResult1
	set CCToRemoteClientNetCheckErrorCode = cc.errorCode
	from CCRClientToClient as cc WITH (READUNCOMMITTED), #tmpRemoteCacheResult1 as tt
	where tt.clientId = cc.fromClientId and tt.RemoteClientId = cc.ToClientId and cc.isdip = 0 AND
		  cc.serviceType = 0
--tmpRemoteCacheResult1 UPDATING RemoteCache to client information
	update #tmpRemoteCacheResult1
	set RemoteClientToCCNetCheckErrorCode = cc.errorCode
	from CCRClientToClient as cc WITH (READUNCOMMITTED), #tmpRemoteCacheResult1 as tt
	where  tt.clientId = cc.toClientId and  tt.RemoteClientId = cc.FromClientId and cc.isdip =0 AND
		  cc.serviceType = 0
	drop table #tmpClientRemoteCachePairs
	drop table #tmpClientRemoteCachePairsAll
	-- Get the Client and proxy pairs here
	IF object_id('tempdb.dbo.#tmpClientProxyPairs') IS NOT NULL drop table #tmpClientProxyPairs
	create table #tmpClientProxyPairs(ClientId		integer,
							instanceId			integer,
							proxyClientId			integer,
							ClientAppType				integer,
						isIndexServer				integer DEFAULT 0,  --0 meaning proxyclient, 1 meaning index server
						iscloudindexServer 	integer DEFAULT 0,    -- 1 meaning cloud index server
						cloudindexServer 	integer DEFAULT 0,
						isproxyclientGroup 	integer DEFAULT 0 , -- 1 meaning client Group
						clientGroup		 	integer DEFAULT 0,
						subclientId		 	integer DEFAULT 0
						)
	IF object_id('tempdb.dbo.#tmpCCRClientInputInternal') IS NOT NULL drop table #tmpCCRClientInputInternal
	create table #tmpCCRClientInputInternal
                        (   ClientId        integer,
                            subclientId     integer,
                            INSTANCE        integer,
                            appTypeId       integer
                        )
	INSERT INTO #tmpCCRClientInputInternal
 		SELECT DISTINCT A.CLIENTID,A.Id, A.INSTANCE ,C.appTypeId
	    FROM APP_Application A (NOLOCK)
		INNER JOIN #CCRIdSubclient CSC ON A.clientId = CSC.clientId AND A.Id = CSC.appId
		INNER JOIN CCRToSubClient C (NOLOCK) ON C.ClientId = CSC.CLIENTID AND CSC.appId = C.subclientId AND CSC.APPTYPEID = C.APPTYPEID AND CSC.CCRId = C.CCRId
		And (A.subclientStatus & 6) = 0     -- uninstalled OR deleted
	CREATE INDEX  #tmpClientProxyPairs_ClientId_instanceId_proxyClientId ON #tmpClientProxyPairs (ClientId,instanceId,	proxyClientId)
	-- Get the Client and proxy pairs here
	EXEC APPGetProxyClientInfo   '#tmpCCRClientInputInternal','#tmpClientProxyPairs',@i_additionresoucechk
	DROP TABLE #tmpCCRClientInputInternal
	IF object_id('tempdb.dbo.#tmpCCRsubClientProxyPairs') IS NOT NULL drop table #tmpCCRsubClientProxyPairs
	create table #tmpCCRsubClientProxyPairs(ClientId	integer,
							instanceId					integer,
							ClientAppType				integer,
							subclientId		 			integer DEFAULT 0,
							issubclientProxy 			integer DEFAULT 0
						)
	INSERT INTO #tmpCCRsubClientProxyPairs(ClientId	, instanceId, ClientAppType , subclientId, issubclientProxy )
	SELECT DISTINCT A.ClientId	, A.instance, A.appTypeId , A.id, CASE WHEN proxy.subclientId IS NULL THEN 0 ELSE 1 END
	FROM APP_Application  A  WITH (READUNCOMMITTED)
	INNER JOIN  #appid as CCRSC  ON  A.ID = CCRSC.subclientid AND A.clientId = CCRSC.ClientId
	LEFT OUTER JOIN  #tmpClientProxyPairs proxy ON CCRSC.AppTypeId  = proxy.ClientAppType AND CCRSC.clientId = proxy.ClientId AND
	 A.APPTYPEID =proxy.ClientAppType AND A.INSTANCE = proxy.instanceId AND A.ID = proxy.subclientId
	INSERT INTO #tmpproxyClientResult1( clientId ,	SubClientId	, proxyClientId, MAHostClientId	, isDDBMA,isIndexServer,iscloudindexServer,	cloudindexServer , isproxyclientGroup ,	clientGroup	)
	SELECT distinct proxy.ClientId,tt.subclientId,proxy.proxyClientId,tt.MAHostClientId,0,proxy.isIndexServer,proxy.iscloudindexServer,	proxy.cloudindexServer , proxy.isproxyclientGroup ,	proxy.clientGroup
	FROM 	 #tmpClientProxyPairs proxy
	INNER JOIN  #tmpResult1 tt
	ON proxy.ClientId = tt.clientId
			and tt.ApptypeId  = proxy.ClientAppType
	INNER JOIN   #tmpCCRsubClientProxyPairs A
	ON proxy.ClientId = A.CLIENTID AND proxy.ClientAppType = A.ClientAppType AND A.instanceId = proxy.instanceId    and a.subclientId= tt.subclientId AND ( ( A.issubclientProxy= 0 AND proxy.subclientId = 0) OR(A.issubclientProxy= 1 AND A.subclientid= proxy.subclientid) )
	CREATE INDEX #tmpproxyClientResult1_IDX ON #tmpproxyClientResult1 (clientId,subclientId,proxyClientId,MAHostClientId)
	INSERT INTO #tmpproxyClientResult1( clientId ,	SubClientId	, proxyClientId, MAHostClientId	, isDDBMA,isIndexServer,iscloudindexServer,	cloudindexServer , isproxyclientGroup ,	clientGroup	)
	select distinct proxy.ClientId,tt.subclientId,proxy.proxyClientId,clientDDB.DDBMAClientId,1,proxy.isIndexServer,proxy.iscloudindexServer,	proxy.cloudindexServer , proxy.isproxyclientGroup ,	proxy.clientGroup
	FROM 	 #tmpClientProxyPairs proxy
	INNER JOIN 	#tmpResult1 tt ON proxy.ClientId = tt.clientId
	INNER JOIN  #tmpMADDBMAPairs clientDDB ON
	clientDDB.SubClientId = tt.subclientId and clientDDB.MAClientId = tt.MAHostClientId
	INNER JOIN   #tmpCCRsubClientProxyPairs A
	ON proxy.ClientId = A.CLIENTID AND proxy.ClientAppType = A.ClientAppType AND A.instanceId = proxy.instanceId    and a.subclientId= tt.subclientId AND ( ( A.issubclientProxy= 0 AND proxy.subclientId = 0) OR(A.issubclientProxy= 1 AND A.subclientid= proxy.subclientid) )
	LEFT OUTER JOIN #tmpproxyClientResult1 existing ON
	existing.ClientId = proxy.ClientId and existing.SubClientId =  tt.subclientId and existing.proxyClientId = proxy.proxyClientId and existing.MAHostClientId =  clientDDB.DDBMAClientId
	WHERE existing.ClientId IS NULL OR existing.SubClientId  IS NULL OR  existing.proxyClientId IS NULL OR existing.MAHostClientId  IS NULL
	-- Get the proxy pairs here
	INSERT INTO #tmpProxyPairs(ClientId	, proxySourceClientId ,	proxyDestinationClientId ,	ClientAppType,isIndexServer,iscloudindexServer,	cloudindexServer , isproxyclientGroup ,	clientGroup	)
select DISTINCT P1.ClientId, P1.proxyClientId,P2.proxyClientId, CASE WHEN P1.ClientAppType  = 137 THEN  54 ELSE P1.ClientAppType END
	,P2.isIndexServer,P2.iscloudindexServer,	P2.cloudindexServer , P2.isproxyclientGroup ,	P2.clientGroup
	FROM #tmpClientProxyPairs P1 INNER JOIN #tmpClientProxyPairs P2 ON P1.ClientId = P2.ClientId and P1.instanceId = P2.instanceId AND P1.subclientId = P2.subclientId
WHERE P1.proxyClientId<>P2.proxyClientId AND P1.ClientAppType != 38
	IF object_id('tempdb.dbo.#tmpClientProxyPairs') IS NOT NULL drop table #tmpClientProxyPairs
	update tt
	set proxyDestinationNetCheckErrorCode = cc.errorCode
	from CCRClientToClient as cc WITH (READUNCOMMITTED), #tmpProxyPairs as tt
	where tt.proxySourceClientId = cc.fromClientId and tt.proxyDestinationClientId = cc.ToClientId and cc.isdip = 0 AND
		  cc.serviceType = 0
	update tt
	set proxyDestinatioHostName = CL.Net_HostName
	from APP_Client AS CL WITH (READUNCOMMITTED)
	INNER JOIN #tmpProxyPairs as tt
	ON Cl.id = tt.proxyDestinationClientId
	update tt
	set proxyDestinatioHostName = proxyDestinatioHostName +
									CASE WHEN tt.iscloudindexServer>0 THEN '( '  +(SELECT CL1.name
																			from APP_Client AS CL1 WITH (READUNCOMMITTED)
																			WHERE  Cl1.id  = tt.cloudindexServer) + ' )'
									WHEN  tt.isproxyclientGroup >0 THEN '( ' +( SELECT CG1.name
																			from APP_ClientGroup AS CG1 WITH (READUNCOMMITTED)
																			WHERE  CG1.id  = tt.clientGroup ) + ' )'
																			else ''
									END
	from APP_Client AS CL WITH (READUNCOMMITTED)
	INNER JOIN #tmpProxyPairs as tt
	ON Cl.id = tt.proxyDestinationClientId
	and ((tt.iscloudindexServer>0  ) or (tt.isproxyclientGroup>0  ))
	update tt
	set proxyCCToMANetCheckErrorCode = cc.errorCode
	from CCRClientToClient as cc WITH (READUNCOMMITTED), #tmpproxyClientResult1 as tt
	where tt.proxyClientId = cc.fromClientId and tt.MAHostClientId = cc.ToClientId and cc.isdip = 0 AND
		  cc.serviceType = 0
	update tt
	set MAToproxyCCNetCheckErrorCode = cc.errorCode
	from CCRClientToClient as cc WITH (READUNCOMMITTED), #tmpproxyClientResult1 as tt
	where tt.proxyClientId = cc.toClientId and tt.MAHostClientId = cc.FromClientId and cc.isdip =0 AND
		  cc.serviceType = 0
	update tt
	set proxyCCToCSNetCheckErrorCode = cc.errorCode
	from CCRClientToClient as cc WITH (READUNCOMMITTED), #tmpproxyClientResult1 as tt
	where  tt.proxyClientId = cc.fromClientId and @CommServe_Id = cc.ToClientId and cc.isdip = 0 AND
	cc.serviceType = 0
	update tt
	set CSToproxyCCNetCheckErrorCode = cc.errorCode
	from CCRClientToClient as cc WITH (READUNCOMMITTED), #tmpproxyClientResult1 as tt
	where @CommServe_Id = cc.fromClientId and tt.proxyClientId = cc.ToClientId and cc.isdip = 0 AND
    cc.serviceType = 0
	update tt
	set proxyClientHostName = CL.Net_HostName
	from APP_Client AS CL WITH (READUNCOMMITTED)
	INNER JOIN #tmpproxyClientResult1 as tt
	ON Cl.id = tt.proxyClientId
	update tt
	set proxyClientHostName =
	proxyClientHostName+ CASE WHEN tt.iscloudindexServer>0 THEN '( '  +(SELECT CL1.name
																			from APP_Client AS CL1 WITH (READUNCOMMITTED)
																			WHERE  Cl1.id  = tt.cloudindexServer) + ' )'
									WHEN  tt.isproxyclientGroup >0 THEN '( ' +( SELECT CG1.name
																			from APP_ClientGroup AS CG1 WITH (READUNCOMMITTED)
																			WHERE  CG1.id  = tt.clientGroup ) + ' )'
																			else ''
									END
	from APP_Client AS CL WITH (READUNCOMMITTED)
	INNER JOIN #tmpproxyClientResult1 as tt
	ON Cl.id = tt.proxyClientId
	update tt
	set proxyMAHostName = CL.Net_HostName
	from APP_Client AS CL WITH (READUNCOMMITTED)
	INNER JOIN #tmpproxyClientResult1 as tt
	ON Cl.id = tt.MAHostClientId
	insert into #tmpDDBResult1
		select distinct tt.clientId,tt.SubClientId	,tt.DataPathId,tt.MAHostClientId,0,0,0,0,clientDDB.DDBMAClientId,''
	from #tmpResult1 tt inner join  #tmpMADDBMAPairs clientDDB ON
			clientDDB.SubClientId = tt.subclientId and clientDDB.MAClientId = tt.MAHostClientId
and tt.ApptypeId not in (13,88)
	update tt
	set tt.LibraryId = MMP.LibraryId from MMMasterPool MMP WITH (READUNCOMMITTED)
			INNER JOIN MMDrivePool MMD WITH (READUNCOMMITTED) ON  MMP.MasterPoolId =MMD.MasterPoolId
			INNER JOIN #tmpResult1 tt ON  MMD.DrivePoolId = tt.DrivePoolId
	update tt
	set tt.LibraryTypeId = ml.LibraryTypeId from MMLibrary as ml WITH (READUNCOMMITTED)
	INNER JOIN #tmpResult1 as tt ON ml.LibraryId = tt.LibraryId
	update tt
	set tt.MasterPoolId = ml.MasterPoolId from MMDrivePool as ml WITH (READUNCOMMITTED)
	INNER JOIN #tmpResult1 as tt ON ml.DrivePoolId = tt.DrivePoolId
	update tt
	set tt.MountPathId = mmp.MountPathId
	from MMMountPath as mmp WITH (READUNCOMMITTED)
	INNER JOIN MMMediaSide as mms WITH (READUNCOMMITTED) ON mmp.MediaSideId = mms.MediaSideId
	INNER JOIN MMMedia as mm WITH (READUNCOMMITTED) ON  mms.MediaId = mm.MediaId
	INNER JOIN #tmpResult1 as tt ON mm.LibraryId = tt.LibraryId
	where tt.LibraryTypeId = 3
	update tt
	set tt.CCToMANetCheckErrorCode = cc.errorCode
	from CCRClientToClient as cc WITH (READUNCOMMITTED)
	INNER JOIN  #tmpResult1 as tt ON  tt.clientId = cc.fromClientId
where tt.ApptypeId not in (13,88) AND tt.MAHostClientId = cc.ToClientId and cc.isdip = 0 AND
		  cc.serviceType = 0
	update tt
	set tt.MAToCCNetCheckErrorCode = cc.errorCode
	from CCRClientToClient as cc WITH (READUNCOMMITTED)
	INNER JOIN  #tmpResult1 as tt ON  tt.clientId = cc.toClientId and tt.MAHostClientId = cc.FromClientId
where tt.ApptypeId not in (13,88)  and cc.isdip =0 AND
		  cc.serviceType = 0
	update tt
	set MAToCSNetCheckErrorCode = cc.errorCode
	from CCRClientToClient as cc WITH (READUNCOMMITTED)
	INNER JOIN #tmpResult1 tt ON tt.MAHostClientId = cc.fromClientId
	where  @CommServe_Id = cc.ToClientId and cc.isdip = 0 AND
	cc.serviceType = 0
	update tt
	set CCToCSNetCheckErrorCode = cc.errorCode
	from CCRClientToClient as cc WITH (READUNCOMMITTED)
	INNER JOIN #tmpResult1 tt ON tt.clientId = cc.fromClientId
where tt.ApptypeId not in (13,88) AND @CommServe_Id = cc.ToClientId and cc.isdip = 0 AND
	cc.serviceType = 0
	--tmpClientDDBMAPairs UPDATING client to ddb MA information
	update tt
	set CCToDDBMANetCheckErrorCode = cc.errorCode
	from CCRClientToClient as cc WITH (READUNCOMMITTED)
	INNER JOIN #tmpDDBResult1 as tt ON tt.clientId = cc.fromClientId and tt.DDBMAHostClientId = cc.ToClientId
	where cc.isdip = 0 AND
		  cc.serviceType = 0
--tmpClientDDBMAPairs UPDATING ddb MA to client information
	update tt
	set DDBMAToCCNetCheckErrorCode = cc.errorCode
	from CCRClientToClient as cc WITH (READUNCOMMITTED)
	INNER JOIN #tmpDDBResult1 as tt ON tt.clientId = cc.toClientId and  tt.DDBMAHostClientId = cc.FromClientId
	where    cc.isdip =0 AND
		  cc.serviceType = 0
--tmpMADDBMAPairs UPDATING ddb MA to ma information
	update tt
	set DDBMAToMANetCheckErrorCode = cc.errorCode
	from CCRClientToClient as cc WITH (READUNCOMMITTED)
	INNER JOIN #tmpDDBResult1 as tt ON  tt.DDBMAHostClientId = cc.fromClientId AND tt.MAHostClientId = cc.ToClientId
	where cc.isdip = 0 AND
		  cc.serviceType = 0
	update tt
	set MAToDDBMANetCheckErrorCode = cc.errorCode
	from CCRClientToClient as cc WITH (READUNCOMMITTED)
	INNER JOIN #tmpDDBResult1 as tt ON  tt.DDBMAHostClientId =cc.ToClientId and tt.MAHostClientId = cc.fromClientId
	where  cc.isdip =0 AND
		  cc.serviceType = 0
	IF ( @FetchWebReport = 0)
	BEGIN
		update tt
		set tt.DDBMAHostName = CL.Net_HostName
		from APP_Client AS CL WITH (READUNCOMMITTED)
		INNER JOIN #tmpDDBResult1 tt
		ON Cl.id = tt.DDBMAHostClientId
		update tt
		set tt.clientHostName = CL.Net_HostName,tt.clientName = CL.displayname
		from APP_Client AS CL WITH (READUNCOMMITTED)
		INNER JOIN #tmpResult1 tt
		ON Cl.id = tt.ClientId
		update tt
		set MAHostName = CL.Net_HostName
		from APP_Client AS CL WITH (READUNCOMMITTED)
		INNER JOIN #tmpResult1 tt ON Cl.id = tt.MAHostClientId
		update tt
		set LibraryName = ML.AliasName
		from MMLibrary AS ML WITH (READUNCOMMITTED)
		INNER JOIN #tmpResult1 tt ON ML.LibraryId = tt.LibraryId
		update tt
		set DrivePoolName = MDP.DrivePoolName
		from MMDrivePool AS MDP WITH (READUNCOMMITTED)
		INNER JOIN #tmpResult1 tt ON MDP.DrivePoolId = tt.DrivePoolId
		update tt
		set MasterPoolName = MDP.MasterPoolName
		from MMMasterPool as MDP WITH (READUNCOMMITTED)
		INNER JOIN #tmpResult1 tt ON MDP.MasterPoolId = tt.MasterPoolId
		update tt
		set MountPathName = MMP.MountPathName
		from MMS2getMountPathNameGUIView as MMP WITH (READUNCOMMITTED)
		INNER JOIN #tmpResult1 tt ON MMP.MountPathId = tt.MountPathId
	-- Update the SubClient Name,Storage Policy Name,Media Agent Name
		update #tmpResult1
		set SubClientName = APP.subClientName,MAName=AC.displayname,SpName = AG.name
		from APP_Application as APP WITH (READUNCOMMITTED),APP_Client AC WITH (READUNCOMMITTED),archGroup AG WITH (READUNCOMMITTED)
		where APP.id = SubClientId AND APP.dataArchGrpID = AG.id  AND
			  MAHostClientID = AC.id
	END
	-- Update The DataInterface Pairs Error codes
-- DIP error codes will be repeseneted as interface1/interface2*errorcode1*errorcode2
-- Errorcode1 is FOR inteface1->interface2,ErrorCode2 is FOR interface2->interface1
	insert into #tmpDataInterfacePairs
	select tt.clientId,ap.srcInterface,tt.MAHostClientId,ap.destInterface,0,0,NULL,0
	from (SELECT DISTINCT clientId,MAHostClientId from #tmpResult1) as tt,
		  (select srcClientId,srcInterface,destClientId,destInterface,isActive from archPipeLine WITH (READUNCOMMITTED)
		   union
		   select destClientId,destInterface,srcClientId,srcInterface,isActive from archPipeLine WITH (READUNCOMMITTED)) as ap
	where tt.clientid=ap.srcClientId AND tt.MAHostClientId = ap.destClientId AND ap.isActive = 1
	update #tmpDataInterfacePairs
	set errorcode1=CCR.errorCode
	from #tmpDataInterfacePairs tt,CCRClientToClient CCR WITH (READUNCOMMITTED)
	where tt.clientId=CCR.fromClientId and tt.clientInterface = CCR.FromClientInterfaceName COLLATE SQL_Latin1_General_CP1_CI_AS and
		  tt.mediaAgentId = CCR.ToClientId and tt.mediaAgentInterface = CCR.ToClientInterfaceName COLLATE SQL_Latin1_General_CP1_CI_AS and
		  isDip = 1 and serviceType = 0
	update #tmpDataInterfacePairs
	set errorcode2=CCR.errorCode
	from #tmpDataInterfacePairs tt,CCRClientToClient CCR WITH (READUNCOMMITTED)
	where tt.mediaAgentId=CCR.fromClientId and tt.mediaAgentInterface = CCR.FromClientInterfaceName COLLATE SQL_Latin1_General_CP1_CI_AS and
		  tt.clientId = CCR.ToClientId and tt.clientInterface = CCR.ToClientInterfaceName COLLATE SQL_Latin1_General_CP1_CI_AS and
		  CCR.isDip = 1 and CCR.serviceType = 0
	update #tmpDataInterfacePairs
	set errorCode= clientInterface+'/'+mediaAgentInterface+'*'+cast(errorCode1 as varchar)+'*'+cast(errorCode2 as varchar)
	update #tmpDataInterfacePairs
	set flag = 1
	where errorCode1 !=0 OR errorCode2 != 0
	declare @tmpClientId integer
	declare @tmpMAClientId integer
	declare @flag			integer
	declare @errorCode		varchar(1024)
-- not match BY SOURCE to avoid using old state, if current state having client ready
	MERGE #tmpResult1 AS T1
    USING #tmpDataInterfacePairs T2 ON
        T2.flag=1 AND t1.clientId = T2.clientId and t1.MAHostClientId = T2.mediaAgentId
    WHEN MATCHED THEN
        UPDATE
		set	  DIPErrorCodes = case isnull(DIPErrorCodes,'null') when 'null' then errorCode else DIPErrorCodes + ',' + errorCode end,
CCRResultFlag = CCRResultFlag| 8
WHEN NOT MATCHED BY SOURCE AND (CCRResultFlag& 8 > 0) THEN
        UPDATE
set  CCRResultFlag = CCRResultFlag -  8;
-- Update CCRToSubClient Table to show that the connection is not ready
IF	EXISTS (SELECT * FROM #tmpResult1 WHERE (CCRResultFlag & 8) <> 0)
	update CCRToSubClient
set CCRToSubClient.CCRResultFlag = CCRToSubClient.CCRResultFlag|8
	from #tmpResult1 as tr
where tr.CCRResultFlag&8 = 8 AND tr.subClientId = CCRToSubClient.subClientId AND tr.dataPathId = CCRToSubClient.DataPathId
and (CCRToSubClient.CCRResultFlag|8) = 0
EXIT_CODE:
IF object_id('TempDB.dbo.#tempDDBDathInfo') IS NOT NULL drop table #tempDDBDathInfo
create table #tempDDBDathInfo
(
SubClientId	integer,
DDBMAHostClientId integer,
DDBAccessPathId	  integer,
DDBAccessPath varchar(1024)
)
INSERT INTO #tempDDBDathInfo
SELECT distinct tt1.SubClientId, IdxSS.ClientId, IdxAP.IdxAccessPathId, IdxAP.Path
FROM #tmpResult1 tt1
		INNER JOIN app_application(nolock)   AS AA ON AA.id=tt1.SubClientId
		INNER JOIN archGroup(nolock) AG ON AA.dataArchGrpId = AG.id
		INNER JOIN archSubclientCopyDDBMap CSD WITH (READUNCOMMITTED) ON CSD.copyID = AG.defaultCopy AND CSD.appId = tt1.subClientId
		INNER JOIN  IdxSIDBSubStore(nolock) IdxSS ON CSD.SIDBStoreId = IdxSS.SIDBStoreId
		INNER JOIN IdxAccessPath IdxAP ON IdxSS.IdxAccessPathId = IdxAP.IdxAccessPathId
IF ( @FetchWebReport = 0)
BEGIN
		update tt
set report_RptDDBMAResp = (select
 tt1.SubClientId as [@SubClientId],
DataPathId	as	[@DataPathId],
	CCToDDBMANetCheckErrorCode as	[@CCToDDBMANetCheckErrorCode],
	DDBMAToCCNetCheckErrorCode as	[@DDBMAToCCNetCheckErrorCode],
	DDBMAToMANetCheckErrorCode as	[@DDBMAToMANetCheckErrorCode],
	MAToDDBMANetCheckErrorCode as	[@MAToDDBMANetCheckErrorCode],
	tt1.DDBMAHostClientId as	[@DDBMAHostClientId],
	DDBMAHostName [@DDBMAHostName],
	datapaths.DataPathInformation.query('.')
	from (select  dd.SubClientId ,
				(select DDBAccessPathId [@id],
				DDBAccessPath [@name]
				from  #tempDDBDathInfo dd1
				where dd1.SubClientId = dd.SubClientId
				FOR XML PATH ('DataPathInformation'),type) as DataPathInformation
				from  #tempDDBDathInfo dd
				group by  dd.SubClientId) as datapaths
	inner join #tmpDDBResult1 tt1
    on tt1.SubClientId = datapaths.SubClientId
and  tt1.SubClientId= tt.SubClientId and tt1.DataPathId= tt.DataPathId
FOR XML PATH ('DDBMAInfo'),root('Rpt_RptDDBMAResp'))
from #tmpResult1 as tt
update tt
set report_RptproxyClientResp = (select
 tt1.SubClientId as [@SubClientId],
 tt1.proxyClientId	as	[@proxyClientId],
 tt1.proxyCCToMANetCheckErrorCode as	[@proxyCCToMANetCheckErrorCode],
 tt1.MAToproxyCCNetCheckErrorCode as	[@MAToproxyCCNetCheckErrorCode],
 tt1.proxyCCToCSNetCheckErrorCode as	[@proxyCCToCSNetCheckErrorCode],
 tt1.CSToproxyCCNetCheckErrorCode as	[@CSToproxyCCNetCheckErrorCode],
 tt1.proxyClientHostName as	[@proxyClientHostName],
 tt1.proxyMAHostName as	[@proxyMAHostName],
 tt1.isDDBMA as	[@isDDBMA],
 tt1.isIndexServer as	[@isIndexServer],
 (select
 DISTINCT pairs.proxyDestinationClientId as [@proxyDestinationClientId],
 pairs.proxyDestinationNetCheckErrorCode	as	[@proxyDestinationNetCheckErrorCode],
 pairs.proxyDestinatioHostName	as	[@proxyDestinatioHostName],
 pairs.isIndexServer as	[@isIndexServer]
 FROM #tmpProxyPairs pairs
 where  tt1.clientId= pairs.clientId and  tt1.proxyClientId= pairs.proxySourceClientId and tt.CCRNetworkReadinessFlag>0
 FOR XML PATH ('ProxyReadiness'),type)
from #tmpproxyClientResult1  tt1
where  tt1.SubClientId= tt.SubClientId and tt1.MAHostClientId= tt.MAHostClientId and tt.CCRNetworkReadinessFlag>0
FOR XML PATH ('ProxyClientInfo'),root('RptProxyClientResp'))
from #tmpResult1 as tt
update tt
set report_RptRemoteCacheResp = (select
 tt1.SubClientId as [@SubClientId],
 tt1.RemoteClientId	as	[@RemoteClientId],
 tt1.CCToRemoteClientNetCheckErrorCode as	[@CCToRemoteClientNetCheckErrorCode],
 tt1.RemoteClientToCCNetCheckErrorCode as	[@RemoteClientToCCNetCheckErrorCode],
 tt1.RemoteClientHostName as	[@RemoteClientHostName],
 tt1.isIndexServer as	[@isIndexServer]
from #tmpRemoteCacheResult1  tt1
where  tt1.SubClientId= tt.SubClientId and tt1.clientId= tt.clientId and tt.CCRNetworkReadinessFlag>0
FOR XML PATH ('RemoteCacheInfo'),root('RptRemoteCacheResp'))
from #tmpResult1 as tt
END
ELSE
BEGIN
	/* This table will be created from caller
	if object_id('tempdb.dbo.#tmpDDBResultWebReport') is not null DROP TABLE #tmpDDBResultWebReport
    create table #tmpDDBResultWebReport(
                   SubClientId                 integer,
                    CCToDDBMANetCheckErrorCode  integer,
                    DDBMAToCCNetCheckErrorCode  integer,
                    DDBMAToMANetCheckErrorCode  integer,
                    MAToDDBMANetCheckErrorCode  integer,
					MAHostClientId              integer,
                    DDBMAHostClientId           integer
    )
	*/
	INSERT INTO #tmpDDBResultWebReport
		SELECT DISTINCT tt1.SubClientId ,
			ISNULL(tt1.CCToDDBMANetCheckErrorCode,0),
			ISNULL(tt1.DDBMAToCCNetCheckErrorCode,0),
			ISNULL(tt1.DDBMAToMANetCheckErrorCode,0),
			ISNULL(tt1.MAToDDBMANetCheckErrorCode,0),
			ISNULL(tt1.MAHostClientId,0),
			ISNULL(tt1.DDBMAHostClientId,0)
	FROM #tmpDDBResult1 tt1
	where CCToDDBMANetCheckErrorCode >0 OR DDBMAToCCNetCheckErrorCode >0  OR DDBMAToMANetCheckErrorCode >0  OR MAToDDBMANetCheckErrorCode > 0
	--ProxyPair Readiness
	/* This table will be created from caller
	 IF OBJECT_ID('tempdb.dbo.#tmpproxyClientResultForWebReport') is not null DROP TABLE #tmpproxyClientResultForWebReport
     CREATE TABLE #tmpproxyClientResultForWebReport( --clientId       integer,
                    SubClientId                 integer,
                    proxyClientId               integer,
                    --MAHostClientId      integer,
                    proxyCCToMANetCheckErrorCode    integer,
                    MAToproxyCCNetCheckErrorCode    integer,
                    proxyCCToCSNetCheckErrorCode    integer,
                    CSToproxyCCNetCheckErrorCode    integer,
                    proxyClientHostName             varchar(1024),
                    proxyMAHostName                 varchar(1024),
                    isDDBMA             int ,
                    isIndexServer               integer DEFAULT 0  ,--0 meaning proxyclient, 1 meaning index server
					ProxyReadiness		XML
           )
		   */
		INSERT INTO #tmpproxyClientResultForWebReport
		SELECT
		tt1.SubClientId ,
		tt1.proxyClientId,
		tt1.proxyCCToMANetCheckErrorCode ,
		tt1.MAToproxyCCNetCheckErrorCode ,
		tt1.proxyCCToCSNetCheckErrorCode ,
		tt1.CSToproxyCCNetCheckErrorCode ,
		tt1.proxyClientHostName ,
		tt1.proxyMAHostName ,
		tt1.isDDBMA ,
		tt1.isIndexServer ,
		(select
		DISTINCT pairs.proxyDestinationClientId as [@proxyDestinationClientId],
		pairs.proxyDestinationNetCheckErrorCode	as	[@proxyDestinationNetCheckErrorCode],
		pairs.proxyDestinatioHostName	as	[@proxyDestinatioHostName],
		pairs.isIndexServer as	[@isIndexServer]
		FROM #tmpProxyPairs pairs
		where  tt1.clientId= pairs.clientId and  tt1.proxyClientId= pairs.proxySourceClientId and tt.CCRNetworkReadinessFlag>0
		FOR XML PATH ('ProxyReadiness'),type)
		from #tmpproxyClientResult1  tt1
		,(select distinct subclientId,CCRNetworkReadinessFlag,MAHostClientId from #tmpResult1) as tt
		where tt1.SubClientId= tt.SubClientId and tt1.MAHostClientId= tt.MAHostClientId and tt.CCRNetworkReadinessFlag>0
		--RptRemoteCacheResp
	/* This table will be created from caller
	IF OBJECT_ID('tempdb.dbo.#tmpRemoteCacheResultForWebReport') is not null DROP TABLE #tmpRemoteCacheResultForWebReport
    CREATE TABLE #tmpRemoteCacheResultForWebReport(
                    SubClientId                 integer,
                    RemoteClientId              integer,
                    CCToRemoteClientNetCheckErrorCode   integer,
                    RemoteClientToCCNetCheckErrorCode   integer,
                    RemoteClientHostName                varchar(1024),
                    isIndexServer               integer DEFAULT 0  --0 meaning remote cache client, 1 meaning index server client
    )
	*/
		INSERT INTO #tmpRemoteCacheResultForWebReport
		select
		tt1.SubClientId ,
		tt1.RemoteClientId	,
		tt1.CCToRemoteClientNetCheckErrorCode,
		tt1.RemoteClientToCCNetCheckErrorCode,
		tt1.RemoteClientHostName,
		tt1.isIndexServer
		from #tmpRemoteCacheResult1  tt1,#tmpResult1 as tt
		where  tt1.SubClientId= tt.SubClientId and tt1.clientId= tt.clientId and tt.CCRNetworkReadinessFlag>0
END
IF (@tableOutput = '')
BEGIN
	select clientId, clientName,clientHostName, SubClientId,SubClientName,SpName,MAName,DataPathId, AppTypeId, CCRResultFlag,
	CCRNetworkReadinessFlag	, CCRResourceReadinessFlag	, lastUnCompressBytes,
	lastCompBytes, capacityAvailable, DataPathReadinessFlag, MAHostClientId, MAHostName,
	DrivePoolId, DrivePoolName, MasterPoolId, MasterPoolName, LibraryId, LibraryName,
	MountPathId, MountPathName, CCToMANetCheckErrorCode, MAToCCNetCheckErrorCode,
	MAToCSNetCheckErrorCode, CCToCSNetCheckErrorCode, CSToCCNetCheckErrorCode, CSToMANetCheckErrorCode,
	spaceCheckFlag,DIPErrorCodes, dataWritten,
	report_RptDDBMAResp,report_RptRemoteCacheResp,report_RptproxyClientResp
	from #tmpResult1 as tt
WHERE (CCRResultFlag!= 64 OR 0=@i_excludeDisabled)
END
ELSE
BEGIN
	 IF object_id('tempdb.dbo.' +@tableoutput) IS NULL
        BEGIN
            PRINT 'Invalid Table Object'
            RETURN
        END
    DECLARE @sqlString NVARCHAR(MAX)
       SET @sqlString  = 'INSERT INTO '+ @tableOutput +'
			select clientId,SubClientId,DataPathId, AppTypeId, CCRResultFlag,
	CCRNetworkReadinessFlag	, CCRResourceReadinessFlag	, lastUnCompressBytes,
	lastCompBytes, capacityAvailable, DataPathReadinessFlag, MAHostClientId,
	DrivePoolId,MasterPoolId, LibraryId,
	MountPathId, CCToMANetCheckErrorCode, MAToCCNetCheckErrorCode,
	MAToCSNetCheckErrorCode, CCToCSNetCheckErrorCode, CSToCCNetCheckErrorCode, CSToMANetCheckErrorCode,
	DIPErrorCodes, dataWritten
	from #tmpResult1 as tt
WHERE (CCRResultFlag!= 64 )'
	EXEC (@sqlString)
END
	drop table #tmpResult1
	drop table #tmpClientDDBMAPairs
	drop table #tmpMADDBMAPairs
	drop table #tmpDataPath1
	drop table #tmpDDBResult1
	drop table #tempDDBDathInfo
	drop table #tmpDataInterfacePairs
	DROP TABLE #tmpproxyClientResult1
	DROP TABLE #tmpProxyClientDDBResult1
	IF object_id('tempdb.dbo.#appid') IS NOT null DROP TABLE #appid
	IF object_id('tempdb.dbo.#tmpProxyPairs') IS NOT NULL drop table #tmpProxyPairs
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CCRGetErrorCodesForRpt')
	delete from GxQscripts where name = 'CCRGetErrorCodesForRpt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRGetErrorCodesForRpt')
	delete from GXDBVersions where aliasname = 'CCRGetErrorCodesForRpt'
GO

insert into GXDBVersions values(2, 'CCRGetErrorCodesForRpt',  '00010027000200430000', 'CCRGetErrorCodesForRpt', '00010027000200430000')
GO

