

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCRGetClientToClientByCCRId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source scode.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCRGetClientToClientByCCRId.sp,v $ $Id: CCRGetClientToClientByCCRId.sp,v 1.57.2.40 2020/12/21 19:13:06 nbirru Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "CCRGetClientToClientByCCRId"								|
--	|																		|
--	|THIS PROCEDURE WILL TEST TO SEE IF THE STRING "NEWSTRING" IS ALREADY A	|
--	| NAME IN THE TABLE, AND IF NOT INSERTS IT BEFORE RETURNING ALL ROWS 	|
--	| THAT MATCH THE SEARCH CRITERIA "ID < compVal".						|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A STORED PROCEDURE		|
--	| AND RETURNING RESULTS	                                                |
--  | Tinku:CCM:Archive File Id's are no longer unique						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CCRGetClientToClientByCCRId')
BEGIN
	print '>>> Drop Stored Procedure: CCRGetClientToClientByCCRId <<<'
	drop procedure CCRGetClientToClientByCCRId
END
IF EXISTS (select * from GxQscripts where name='CCRGetClientToClientByCCRId')
	delete from GxQscripts where name = 'CCRGetClientToClientByCCRId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRGetClientToClientByCCRId')
	delete from GXDBVersions where aliasname = 'CCRGetClientToClientByCCRId'
GO
print '... Creating Procedure: CCRGetClientToClientByCCRId'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CCRGetClientToClientByCCRId
  @in_CCRId integer,
  @in_FetchOnly integer,
  @in_isaddResources integer,
  @in_ischeckCSCConly integer
AS
  DECLARE @fromClientId integer
  DECLARE @fromClientName char(255)
  DECLARE @fromClientPlatType integer
  DECLARE @fromClientInterface varchar(255)
  DECLARE @toClientId integer
  DECLARE @toClientName char(255)
  DECLARE @toClientPlatType integer
  DECLARE @toClientInterface varchar(255)
  DECLARE @netCheckErrorCode integer
  DECLARE @netCheckErrorString varchar(1024)
  DECLARE @subClientAppType integer
  DECLARE @isDip integer
  DECLARE @fromClientMangledHostName varchar(1024)
  DECLARE @toClientMangledHostName varchar(1024)
  DECLARE @serviceType integer
  DECLARE @dipClientMangledHostName varchar(1024)
--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	declare @l_CCRId	integer
	set @l_CCRId = @in_CCRId
	declare @l_FetchOnly	integer
	set @l_FetchOnly = @in_FetchOnly
	declare @CommServe_Id	integer
	set @CommServe_Id = (select top(1)clientId from APP_Platform WITH (READUNCOMMITTED) where (platformType & 1) = 1 order by clientId asc)
	DECLARE @isClusterCS INT = 0
	SELECT @isClusterCS = attrVal FROM App_ClientProp with(nolock)
	WHERE componentNameId = @CommServe_Id
	AND attrName LIKE 'Virtual Client' AND modified = 0
	IF object_id('TempDB.dbo.#tmpClntToClnt') IS NOT NULL drop table #tmpClntToClnt
	IF object_id('TempDB.dbo.#tmpArchPipeLine') IS NOT NULL drop table #tmpArchPipeLine
	IF object_id('TempDB.dbo.#tmpDataPath') IS NOT NULL drop table #tmpDataPath
	IF object_id('tempdb.dbo.#tmpRepSet') IS NOT NULL drop table #tmpRepSet
	IF object_id('tempdb.dbo.#tmpClientMAPairs') IS NOT NULL drop table #tmpClientMAPairs
	IF object_id('tempdb.dbo.#tmpClientProxyPairs') IS NOT NULL drop table #tmpClientProxyPairs
	IF object_id('tempdb.dbo.#tmpClientDDBMAPairs') IS NOT NULL drop table #tmpClientDDBMAPairs
	IF object_id('tempdb.dbo.#tmpClientRemoteCachePairs') IS NOT NULL drop table #tmpClientRemoteCachePairs
	IF object_id('tempdb.dbo.#tmpClientRemoteCachePairsAll') IS NOT NULL drop table #tmpClientRemoteCachePairsAll
	IF object_id('tempdb.dbo.#tmpMADDBMAPairs') IS NOT NULL drop table #tmpMADDBMAPairs
	IF object_id('tempdb.dbo.#ClientWithoutSubclients') IS NOT NULL drop table #ClientWithoutSubclients
	create table #tmpClntToClnt	(FromclientId		integer,
								ToClientId			integer,
								tsubClientAppType	integer,
								svcType			integer)
	create index #tmpClntToClnt_FromclientId_ToClientId on #tmpClntToClnt	(FromclientId,ToClientId)
	create table #tmpArchPipeLine	(	srcClientId		integer,
										srcInterface		varchar(256),
										destClientId		integer,
										destInterface		varchar(256),
										srcNetHostName		varchar(256),
										destNetHostName		varchar(256),
										isActive			integer,
										tsubClientAppType	integer,
										srcPlatType			integer,
										destPlatType		integer,
										fromClientReleaseId	integer,
										toClientReleaseId	integer,
										srcMangledHostName	varchar(256),
										destMangledHostName	varchar(256),
										svcType		integer
									)
	create table #tmpDataPath	(DataPathId		integer,
					 HostClientId		integer)
	create table #tmpRepSet(sourceClientId		integer,
					destClientId		integer
					)
	create table #tmpClientMAPairs(ClientId		integer,
							MAClientId			integer,
							tsubClientAppType	integer,
							instanceId			integer
							)
	-- Get the Client and proxy pairs here
	create table #tmpClientProxyPairs(ClientId		integer,
							instanceId			integer,
							proxyClientId			integer,
							ClientAppType				integer,
						isIndexServer				integer DEFAULT 0,  --0 meaning proxyclient, 1 meaning index server
						iscloudindexServer 	integer DEFAULT 0,    -- 1 meaning cloud index server
						cloudindexServer 	integer DEFAULT 0,
						isproxyclientGroup 	integer DEFAULT 0 , -- 1 meaning client Group
						clientGroup		 	integer DEFAULT 0,
						subclientId		 	integer DEFAULT 0
						)
	CREATE INDEX  #tmpClientProxyPairs_ClientId_instanceId_proxyClientId ON #tmpClientProxyPairs (ClientId,instanceId,	proxyClientId)
	create table #tmpClientDDBMAPairs(ClientId		integer,
							MAClientId			integer,
							tsubClientAppType	integer,
							instanceId			integer,
							poweredOffMA			integer
							)
	create table #tmpClientRemoteCachePairs(ClientId		integer,
							AssociateremotecacheClientId	integer,
							tsubClientAppType				integer
							)
	create table #tmpClientRemoteCachePairsAll(ClientId		integer,
						RemoteClientId			integer,
						RemoteClientCategory 			integer DEFAULT 0  --1 remoteclient, 4 LM
							)
	create INDEX #tmpClientRemoteCachePairsAll_ClientId on #tmpClientRemoteCachePairsAll (ClientId)
	create table #tmpMADDBMAPairs(MAClientId		integer,
							DDBMAClientId			integer,
							tsubClientAppType	integer
							)
	create table #ClientWithoutSubclients (clientId int)
	INSERT INTO #ClientWithoutSubclients
	SELECT C.id from App_client C WITH (NOLOCK)
                INNER JOIN    (select clientid,max(HighestSP) AS 'HighestSP' from simInstalledPackages WITH (NOLOCK) group by ClientId
                ) sim  ON sim.ClientId = C.id
                LEFT OUTER JOIN APP_Application AP WITH (NOLOCK) ON  C.id = AP.clientId
                where AP.clientId IS NULL AND (c.releaseId > 16 or (c.releaseId = 16 and sim.highestSP >= 17))
	--in_ischeckCSCConly CHECK SHOUDL BE DONE HAVING in_isaddResources AS ZERO, CALLER NEED TO TAKE CARE PRESENTLY
	--if(@in_ischeckCSCConly=1)
		-- SET @in_isaddResources=0
	DECLARE @tmpExternalClient TABLE (clientId INT)
	--Get NBU client list
	INSERT INTO @tmpExternalClient
	SELECT C.id
	FROM APP_Client C WITH (READUNCOMMITTED)
	INNER JOIN APP_CommCell Cell WITH (READUNCOMMITTED)
	ON C.origCCId = Cell.id and Cell.type = 100
	UNION
	-- These are POWER MANAGED MA CLIENT which are off presently
	SELECT C.id
	FROM APP_Client C WITH (READUNCOMMITTED)
	INNER JOIN  MMHost as MH WITH (READUNCOMMITTED)
ON MH.ClientId =C.id AND (MH.Attribute & 32768) = 32768	AND MH.OfflineReason=7
	insert into #tmpDataPath
	select distinct MD.DataPathId, MDP.ClientId
	From MMDrivePool as MDP WITH (READUNCOMMITTED)
	INNER JOIN MMDataPath as MD WITH (READUNCOMMITTED)
	ON MD.DrivePoolId = MDP.DrivePoolId
	LEFT OUTER JOIN MMHost as MH WITH (READUNCOMMITTED)
ON MH.ClientId =MDP.ClientId AND (MH.Attribute & 32768) = 32768	AND MH.OfflineReason=7
	where MH.ClientId IS NULL
	-- here I need to add other Database agent now --todo
	-- Get the Client and MA pairs
	insert into #tmpClientMAPairs
	select distinct sc.ClientId, mcf.HostClientId, SC.AppTypeId,A.INSTANCE
	from CCRToSubClient as sc WITH (READUNCOMMITTED)
	INNER JOIN APP_Application A  WITH (READUNCOMMITTED) ON A.ClientId  = sc.ClientId  AND 	a.id=sc.subclientid AND A.APPTYPEID =SC.AppTypeId
	INNER JOIN APP_Client as cl WITH (READUNCOMMITTED)
	ON cl.Id = sc.ClientId
AND SC.AppTypeId not in(13, 88,84)
		AND sc.CCRId = @l_CCRId
	INNER JOIN #tmpDataPath as mcf
		ON sc.DataPathId = mcf.DataPathId --and sc.ClientId != mcf.HostClientId
		AND mcf.HostClientId NOT IN(select ClientId From CCRToSubClient WITH (READUNCOMMITTED) where AppTypeId IN(13, 88))
	-- Get the Client and Remote Software cache pairs (if remote client and client is not same )
		-- Get the Client and proxy pairs here
	-- Get the Laptop Client and  Edge Index Server (if remote client and client is not same )
	-- additional check
	if(@in_isaddResources=1)
		EXEC CCRGetRemoteCachePairInfo  @l_CCRId ,'#tmpClientRemoteCachePairsAll'
	insert into  #tmpClientRemoteCachePairs
	SELECT DISTINCT pa.clientId,  pa.RemoteClientId as remotecache, SC.AppTypeId
	FROM CCRToSubClient(nolock) AS sc INNER JOIN #tmpClientRemoteCachePairsAll(nolock)   AS pa ON
		pa.ClientId =  sc.ClientId AND sc.CCRId = @l_CCRId
	IF object_id('tempdb.dbo.#tempSubclientProp') IS NOT null DROP TABLE #tempSubclientProp
	CREATE TABLE #tempSubclientProp(
	subClientId					integer,
	associatedsubclientPolicyId 	integer,
	Deduplication				integer
	)
	INSERT INTO #tempSubclientProp (subClientId,associatedsubclientPolicyId,Deduplication)
	SELECT sc.subClientId,prop.attrVal, ISNULL(SProp.attrVal,1) FROM CCRToSubClient(nolock) AS sc
	INNER JOIN APP_SubclientProp prop WITH (NOLOCK) ON  prop.componentNameId = sc.subClientId AND prop.attrName = 'Associated subclient Policy' AND prop.modified = 0
	LEFT OUTER JOIN APP_SubclientProp SProp WITH (NOLOCK) ON  SProp.componentNameId =  prop.attrVal AND SProp.attrName = 'Single Instancing Option'  AND SProp.modified = 0
WHERE sc.CCRId = @in_CCRId AND SC.AppTypeId not in(13, 88,84)
	INSERT INTO #tempSubclientProp (subClientId,associatedsubclientPolicyId,Deduplication)
	SELECT sc.subClientId,0, ISNULL(prop.attrVal,1) FROM CCRToSubClient(nolock) AS sc
	LEFT OUTER JOIN APP_SubclientProp prop WITH (NOLOCK) ON  prop.componentNameId = sc.subClientId AND prop.attrName = 'Single Instancing Option' AND prop.modified = 0
	LEFT OUTER JOIN #tempSubclientProp SProp WITH (NOLOCK) ON  SProp.subClientId = sc.subClientId
	WHERE SProp.subClientId is NULL
AND sc.CCRId = @in_CCRId AND SC.AppTypeId not in(13, 88,84)
	CREATE INDEX #tempSubclientProp_SubClientId on #tempSubclientProp( SubClientId)
	-- Get the Client and DDBMA pairs (if client side ddba enable and ddb ma is not in backup ma )
	insert into #tmpClientDDBMAPairs
	SELECT DISTINCT sc.clientId,  IdxSS.ClientId as ddbMAid, SC.AppTypeId,AA.INSTANCE,0
	FROM CCRToSubClient(nolock) AS sc INNER JOIN app_application(nolock)   AS AA ON
aa.id=sc.subclientid AND sc.CCRId = @l_CCRId AND SC.AppTypeId not in(13, 88,84)
		INNER JOIN #tempSubclientProp prop   ON
		sc.subClientId = prop.subClientId
		and  prop.Deduplication = 1
		INNER JOIN archGroup(nolock) AG ON AA.dataArchGrpId = AG.id
		INNER JOIN archSubclientCopyDDBMap CSD WITH (READUNCOMMITTED) ON CSD.copyID = AG.defaultCopy AND CSD.appId = SC.subClientId
		INNER JOIN  IdxSIDBSubStore(nolock) IdxSS ON CSD.SIDBStoreId = IdxSS.SIDBStoreId
			LEFT OUTER JOIN MMDataPath MD ON  MD.CopyId = AG.defaultCopy AND IdxSS.ClientId = MD.HostClientId
		  where  IdxSS.ClientId <> sc.clientId AND MD.HostClientId IS null
		  AND CSD.SIDBStoreId > 0
	IF object_id('tempdb.dbo.#tmpCCRClientInputInternal') IS NOT NULL drop table #tmpCCRClientInputInternal
	create table #tmpCCRClientInputInternal
                        (   ClientId        integer,
                            subclientId     integer,
                            INSTANCE        integer,
                            appTypeId       integer
                        )
	INSERT INTO #tmpCCRClientInputInternal
	 SELECT DISTINCT A.CLIENTID,A.Id, A.INSTANCE ,C.appTypeId
	    FROM APP_Application A (NOLOCK)
		INNER JOIN CCRToSubClient C (NOLOCK) ON  A.id = C.SubClientId AND C.CCRId =  @l_CCRId
	    And (A.subclientStatus & 6) = 0     -- uninstalled OR deleted
	-- Get the Client and proxy pairs here
	EXEC APPGetProxyClientInfo   '#tmpCCRClientInputInternal','#tmpClientProxyPairs',@in_isaddResources
	DROP TABLE #tmpCCRClientInputInternal
		-- Get the PROXY Client and MA pairs (PROXY CLIENT WILL BE HAVING PACKAGE INSTALLED AND COMMUNICATE WITH CS,MA)
	insert into #tmpClientMAPairs
	SELECT DISTINCT proxy.proxyClientId, C.MAClientId, C.tsubClientAppType,proxy.instanceId
	from #tmpClientProxyPairs as proxy
	INNER JOIN #tmpClientMAPairs C ON C.ClientId = proxy.ClientId AND C.instanceId = proxy.instanceId
	AND C.tsubClientAppType =proxy.ClientAppType
	LEFT OUTER JOIN #tmpClientMAPairs existing ON
	existing.ClientId = proxy.proxyClientId and existing.MAClientId =  C.MAClientId
	WHERE existing.ClientId IS NULL OR existing.MAClientId  IS NULL
	-- Get the PROXY Client and DDBMA pairs (if client side ddba enable and ddb ma is not in backup ma )
	insert into #tmpClientDDBMAPairs
	SELECT DISTINCT proxy.proxyClientId, C.MAClientId, C.tsubClientAppType,proxy.instanceId,0
	from #tmpClientProxyPairs as proxy
	INNER JOIN #tmpClientDDBMAPairs C ON C.ClientId = proxy.ClientId AND C.instanceId = proxy.instanceId
	AND C.tsubClientAppType =proxy.ClientAppType
	LEFT OUTER JOIN #tmpClientDDBMAPairs existing ON
	existing.ClientId = proxy.proxyClientId and existing.MAClientId =  C.MAClientId
	WHERE existing.ClientId IS NULL OR existing.MAClientId  IS NULL
	update tp
	set poweredOffMA = 1
	from #tmpClientDDBMAPairs  as tp
	INNER JOIN MMHost as MH WITH (READUNCOMMITTED)
ON MH.ClientId =tp.MAClientId AND (MH.Attribute & 32768) = 32768	AND MH.OfflineReason=7
	-- Get the Proxies pairs as they also need to comunicate with each others.
	INSERT INTO #tmpClientRemoteCachePairs
select DISTINCT  P1.proxyClientId,P2.proxyClientId, CASE WHEN P1.ClientAppType  = 137 THEN  54 ELSE P1.ClientAppType END
	FROM #tmpClientProxyPairs P1 INNER JOIN #tmpClientProxyPairs P2 ON P1.ClientId = P2.ClientId and P1.instanceId = P2.instanceId AND P1.subclientId = P2.subclientId
WHERE P1.proxyClientId<>P2.proxyClientId AND P1.ClientAppType != 38 AND P1.ClientId NOT IN (SELECT P3.ClientId FROM #tmpClientProxyPairs P3 WHERE P3.ClientAppType in (29, 33))
	IF object_id('tempdb.dbo.#tmpClientProxyPairs') IS NOT NULL drop table #tmpClientProxyPairs
	IF object_id('tempdb.dbo.#tempSubclientProp') IS NOT NULL drop table #tempSubclientProp
	-- Get the MA and DDBMA pairs (if client side ddba enable and ddb ma is not in backup ma )
	insert into #tmpMADDBMAPairs
	SELECT distinct DP.HostClientId, IdxSS.ClientId, SC.AppTypeId  FROM
	CCRToSubClient(nolock) AS sc INNER JOIN app_application(nolock)   AS AA ON
aa.id=sc.subclientid AND sc.CCRId = @l_CCRId AND SC.AppTypeId not in(13, 88,84)
		INNER JOIN archGroup(nolock) AG ON AA.dataArchGrpId = AG.id
		INNER JOIN archSubclientCopyDDBMap CSD WITH (READUNCOMMITTED) ON CSD.copyID = AG.defaultCopy AND CSD.appId = SC.subClientId
		INNER JOIN IdxSIDBSubStore(nolock) IdxSS ON CSD.SIDBStoreId = IdxSS.SIDBStoreId
		INNER JOIN MMDatapath(nolock) DP ON DP.CopyId = AG.defaultCopy and sc.DataPathId = dp.DataPathId
		WHERE
		 IdxSS.ClientId <> DP.HostClientId
		AND CSD.SIDBStoreId > 0
		AND IdxSS.SIDBStoreId in
				(SELECT SIDBStoreId FROM IdxSIDBSubStore (nolock)
					GROUP BY SIDBStoreId
					HAVING COUNT(SubStoreId) > 1)
	-- Get the Source and Destination clients for replications sets
	INSERT INTO #tmpRepSet(sourceClientId,destClientId)
	SELECT DISTINCT APP.clientId,destClientId
	FROM	CCRToSubClient as sc WITH (READUNCOMMITTED),APP_Application APP WITH (READUNCOMMITTED), APP_BackupSetName BSN WITH (READUNCOMMITTED),
			(SELECT componentNameId as backupSetId,attrVal as destClientId FROM APP_BackupSetProp WITH (READUNCOMMITTED) WHERE attrName = 'FLR Destination HostId') AS DEST
	WHERE	sc.CCRId = @l_CCRId AND sc.subClientId = APP.id AND APP.backupSet = BSN.id AND BSN.id = DEST.backupSetId AND APP.appTypeId = 84
		--tmpMADDBMAPairs
	DELETE tp
	FROM #tmpMADDBMAPairs tp
	INNER JOIN  MMHost as MH WITH (READUNCOMMITTED)
	ON tp.MAClientId = MH.ClientId
WHERE (MH.Attribute & 32768) = 32768	AND MH.OfflineReason=7
	DELETE tp
	FROM #tmpMADDBMAPairs tp
	INNER JOIN  MMHost as MH WITH (READUNCOMMITTED)
	ON tp.DDBMAClientId = MH.ClientId
WHERE (MH.Attribute & 32768) = 32768	AND MH.OfflineReason=7
	--first insert the rows from MA to DDBMA
	insert into #tmpClntToClnt
	select distinct MAClientId, DDBMAClientId, tsubClientAppType,0
	from #tmpMADDBMAPairs tp
	where not exists(select * from #tmpClntToClnt as tt
	where tt.FromClientId = tp.MAClientId and tt.ToClientId = tp.DDBMAClientId)
	--then insert the rows for ddbMA to MA
	insert into #tmpClntToClnt
	select distinct DDBMAClientId,MAClientId, tsubClientAppType,0
	from #tmpMADDBMAPairs tp
	where not exists(select * from #tmpClntToClnt as tt
		where tt.FromClientId = tp.DDBMAClientId   and tt.ToClientId = tp.MAClientId)
	--first insert the rows from APP_Client to MA
	--For NAS Ida's we need to get the DrivePool's APP_Client to MediaAgent
	--For Oracle RAC Ida's no need to put the entries for the dummy Clients
	insert into #tmpClntToClnt
	select distinct ClientId, MAClientID, tsubClientAppType,0
	from #tmpClientMAPairs tp
	where not exists(select * from #tmpClntToClnt as tt
	where tt.FromClientId = tp.ClientId and tt.ToClientId = tp.MAClientId)
	--first insert the rows from APP_Client to ddbMA
	insert into #tmpClntToClnt
	select distinct ClientId, MAClientID, tsubClientAppType,0
	from #tmpClientDDBMAPairs tp
	where not exists(select * from #tmpClntToClnt as tt
	where tt.FromClientId = tp.ClientId and tt.ToClientId = tp.MAClientId)
	AND tp.poweredOffMA= 0
	--first insert the rows from APP_Client to remotecache
	insert into #tmpClntToClnt
	select distinct ClientId, AssociateremotecacheClientId, tsubClientAppType,0
	from #tmpClientRemoteCachePairs	 tp
	where not exists(select * from #tmpClntToClnt as tt
	where tt.FromClientId = tp.ClientId and tt.ToClientId = tp.AssociateremotecacheClientId)
	-- Insert the Data Interface Pairs
	-- Client to MA data interface pair
	insert into #tmpArchPipeLine
	select distinct srcClientId, srcInterface, destClientId, destInterface, '', '', isActive, 0, 0, 0, 0, 0, '', '' ,0
	from (
		    select srcClientId,srcInterface,destClientId,destInterface,isActive from archPipeLine WITH (READUNCOMMITTED)
		    union
		    select destClientId,destInterface,srcClientId,srcInterface,isActive from archPipeLine WITH (READUNCOMMITTED)
			)  as ap,#tmpClientMAPairs tp
	where isActive = 1 AND  tp.clientId = ap.srcClientId AND tp.MAClientId = ap.destClientId
	AND not exists(select * from #tmpArchPipeLine as tt
	where ap.srcClientId = tt.srcClientId and ap.destClientId = tt.destClientId and ap.srcInterface = tt.srcInterface COLLATE SQL_Latin1_General_CP1_CI_AS  and ap.destInterface= tt.destInterface COLLATE SQL_Latin1_General_CP1_CI_AS )
	--then insert the rows for MA to APP_Client
	insert into #tmpClntToClnt
	select distinct MAClientId,ClientId, tsubClientAppType,0
	from #tmpClientMAPairs tp
	where not exists(select * from #tmpClntToClnt as tt
		where tt.FromClientId = tp.MAClientId   and tt.ToClientId = tp.clientId)
	--then insert the rows for ddbMA to APP_Client
	insert into #tmpClntToClnt
	select distinct MAClientId,ClientId, tsubClientAppType,0
	from #tmpClientDDBMAPairs tp
	where not exists(select * from #tmpClntToClnt as tt
		where tt.FromClientId = tp.MAClientId   and tt.ToClientId = tp.clientId)
	AND tp.poweredOffMA= 0
	--then insert the rows for remotecache to APP_Client
	insert into #tmpClntToClnt
	select distinct AssociateremotecacheClientId,ClientId, tsubClientAppType,0
	from #tmpClientRemoteCachePairs tp
	where not exists(select * from #tmpClntToClnt as tt
		where tt.FromClientId = tp.AssociateremotecacheClientId   and tt.ToClientId = tp.clientId)
	-- MA to Client data interface pair
	insert into #tmpArchPipeLine
	select distinct srcClientId, srcInterface,destClientId, destInterface,'', '', isActive, 0, 0, 0, 0, 0, '', '' ,0
	FROM (
		    select srcClientId,srcInterface,destClientId,destInterface,isActive from archPipeLine WITH (READUNCOMMITTED)
		    union
		    select destClientId,destInterface,srcClientId,srcInterface,isActive from archPipeLine WITH (READUNCOMMITTED)
			)  as ap,#tmpClientMAPairs tp
	WHERE isActive = 1 AND tp.MAClientId = ap.srcClientId AND tp.clientId = ap.destClientId
	AND not exists(select * from #tmpArchPipeLine as tt
	where ap.srcClientId = tt.srcClientId and ap.destClientId = tt.destClientId and ap.srcInterface = tt.srcInterface COLLATE SQL_Latin1_General_CP1_CI_AS  and ap.destInterface= tt.destInterface COLLATE SQL_Latin1_General_CP1_CI_AS )
	--Insert rows from MA to CS
	insert into #tmpClntToClnt
	select distinct MAClientId, @CommServe_Id, tsubClientAppType,0
	from #tmpClientMAPairs tp
	where MAClientId != @CommServe_Id and
	not exists(select * from #tmpClntToClnt as tt
		where tt.FromClientId = tp.MAClientId and tt.ToClientId = @CommServe_Id)
	--Insert the rows from CS to MA
	insert into #tmpClntToClnt
	select distinct @CommServe_Id, MAClientId,tsubClientAppType,0
	from #tmpClientMAPairs tp
	where MAClientId != @CommServe_Id and
	not exists(select * from #tmpClntToClnt as tt
		where tt.FromClientId = @CommServe_Id and tt.ToClientId = tp.MAClientId)
	--Insert the rows from APP_Client to CS
	insert into #tmpClntToClnt
	select distinct ClientId, @CommServe_Id, tsubClientAppType,0
	from #tmpClientMAPairs tp
	where tp.ClientId != @CommServe_Id and
	not exists(select * from #tmpClntToClnt as tt
		where tt.FromClientId = tp.ClientId and tt.ToClientId = @CommServe_Id)
	INSERT INTO #tmpClntToClnt
	SELECT @CommServe_Id,C.clientId,0,0
	FROM #ClientWithoutSubclients C
	INNER JOIN CCRToSubClient CC ON C.clientId = CC.ClientId AND CC.CCRId = @in_CCRId
	INSERT INTO #tmpClntToClnt
	SELECT C.clientId,@CommServe_Id,0,0
	FROM #ClientWithoutSubclients C
	INNER JOIN CCRToSubClient CC ON C.clientId = CC.ClientId AND CC.CCRId = @in_CCRId
	--------------------------------------------
	--				CDR INFO				  --
	--------------------------------------------
	--  CommServe To Source On FLR port
		insert into #tmpClntToClnt
		select distinct @CommServe_Id, tRep.sourceClientId, 84,1
		from  #tmpRepSet tRep
		where not exists(select * from #tmpClntToClnt as tt
		where tt.FromClientId = @CommServe_Id  and tt.ToClientId = tRep.sourceClientId and tt.svcType = 1 )
	-- Source to CommServ On CVD
		insert into #tmpClntToClnt
		select distinct tRep.sourceClientId,@CommServe_Id,84,0
		from  #tmpRepSet tRep
		where tRep.sourceClientId != @CommServe_Id AND
  		not exists(select * from #tmpClntToClnt as tt
		where tt.FromClientId = tRep.sourceClientId and tt.ToClientId = @CommServe_Id and tt.svcType = 0 )
	-- CommServ To Destination on FLR Port
		insert into #tmpClntToClnt
		select distinct @CommServe_Id, tRep.destClientId, 84,1
		from  #tmpRepSet tRep
		where @CommServe_Id !=  tRep.destClientId AND
		not exists(select * from #tmpClntToClnt as tt
        where tt.FromClientId = @CommServe_Id and tt.ToClientId = tRep.destClientId and tt.svcType = 1)
	-- Destnation To Commserv on CVD port
		insert into #tmpClntToClnt
		select distinct tRep.destClientId,@CommServe_Id,84,0
		from  #tmpRepSet tRep
		where tRep.destClientId != @CommServe_Id AND
		not exists(select * from #tmpClntToClnt as tt
		where tt.FromClientId = tRep.destClientId and tt.ToClientId = @CommServe_Id and tt.svcType = 0 )
	-- Source To Destination on FLR Port
		insert into #tmpClntToClnt
		select distinct tRep.sourceClientId,tRep.destClientId,84,1
		from  #tmpRepSet tRep
		where not exists(select * from #tmpClntToClnt as tt
        where tt.FromClientId = tRep.sourceClientId and tt.ToClientId = tRep.destClientId and tt.svcType = 1)
	-- Source To Destination on FLR Port using Date Interface Pairs
 		insert into #tmpArchPipeLine
		select distinct ap.srcClientId, ap.srcInterface, ap.destClientId, ap.destInterface, '', '', ap.isActive, 0, 0, 0, 0, 0, '', '' ,1
		from (
		    	select srcClientId,srcInterface,destClientId,destInterface,isActive from archPipeLine WITH (READUNCOMMITTED)
		    	union
		    	select destClientId,destInterface,srcClientId,srcInterface,isActive from archPipeLine WITH (READUNCOMMITTED)
				)  as ap,#tmpRepSet tRep
		where isActive = 1 AND  tRep.SourceClientId = ap.srcClientId AND tRep.DestClientId = ap.destClientId
		AND not exists(select * from #tmpArchPipeLine as tt
		where ap.srcClientId = tt.srcClientId and ap.destClientId = tt.destClientId and ap.srcInterface = tt.srcInterface COLLATE SQL_Latin1_General_CP1_CI_AS and ap.destInterface= tt.destInterface COLLATE SQL_Latin1_General_CP1_CI_AS and tt.svcType = 1)
	-- Destination To Source on FLR port
		insert into #tmpClntToClnt
		select distinct tRep.destClientId,tRep.sourceClientId,84,1
		from  #tmpRepSet tRep, APP_Client as cl WITH (READUNCOMMITTED)
		where tRep.destClientId = cl.id and
   		not exists(select * from #tmpClntToClnt as tt
   		where tt.FromClientId = tRep.destClientId and tt.ToClientId = tRep.sourceClientId and tt.svcType = 1)
	-- DataInterfacePairs Destination To Source on FLR Port
 		insert into #tmpArchPipeLine
		select distinct ap.srcClientId, ap.srcInterface, ap.destClientId, ap.destInterface, '', '', ap.isActive, 0, 0, 0, 0, 0, '', '' ,1
		from (
		    	select srcClientId,srcInterface,destClientId,destInterface,isActive from archPipeLine WITH (READUNCOMMITTED)
		    	union
		    	select destClientId,destInterface,srcClientId,srcInterface,isActive from archPipeLine WITH (READUNCOMMITTED)
				)  as ap,#tmpRepSet tRep
		where isActive = 1 AND  tRep.destClientId = ap.srcClientId AND tRep.SourceClientId = ap.destClientId
		AND not exists(select * from #tmpArchPipeLine as tt
		where ap.srcClientId = tt.srcClientId and ap.destClientId = tt.destClientId and ap.srcInterface = tt.srcInterface COLLATE SQL_Latin1_General_CP1_CI_AS and ap.destInterface= tt.destInterface COLLATE SQL_Latin1_General_CP1_CI_AS and tt.svcType = 1)
	--Insert the rows from CS to APP_Client
	insert into #tmpClntToClnt
	select distinct @CommServe_Id, ClientId, tsubClientAppType,0
	from #tmpClientMAPairs tp
	where
	not exists(select * from #tmpClntToClnt as tt
		where tt.FromClientId = @CommServe_Id and tt.ToClientId = ClientId and tt.svcType = 0)
	--Remove entries from #tmpClntToClnt where from and to client are the same
	delete from #tmpClntToClnt where FromclientId = ToClientId AND ToClientId!=2
	update #tmpArchPipeLine
	set isActive = 1
	from #tmpArchPipeLine as ta, #tmpClntToClnt as tc
	where ta.srcClientId = tc.FromClientId and ta.destClientId = tc.ToClientId
	delete from #tmpArchPipeLine
	where isActive = 0
	-- delete DIP defined for NBU client
	OR      srcClientId IN(select clientId from @tmpExternalClient)
    OR      destClientId IN(select clientId from @tmpExternalClient)
	OR 		srcClientId  = destClientId
	IF EXISTS (Select * from #tmpClntToClnt)
	BEGIN
		DELETE from #tmpClntToClnt
		WHERE EXISTS (select * from #tmpArchPipeLine where srcClientId = FromClientId and destClientId = ToClientId)
		-- SubClients with No Stroage policy will have mediaAgentId as 1 so remove those
		-- So delete these entries
		DELETE from #tmpClntToClnt
		WHERE FromClientId = 1 OR ToClientId = 1
		-- delete NBU client
		OR      FromClientId IN(select clientId from @tmpExternalClient)
        OR      ToClientId IN(select clientId from @tmpExternalClient)
	END
	insert into #tmpArchPipeLine
	select tt.fromClientId, '', tt.ToClientId, '', '', '', 1, tt.tsubClientAppType, 0, 0, 0, 0, '', '', tt.svcType
	from #tmpClntToClnt as tt
	update #tmpArchPipeLine
	set tsubClientAppType = tc.tsubClientAppType
	from #tmpClntToClnt as tc
	where tc.FromclientId = srcClientId and tc.ToClientId = destClientId
	update #tmpArchPipeLine
	Set srcInterface = Cl.net_Hostname
	From App_Client as Cl WITH (READUNCOMMITTED)
	where #tmpArchPipeLine.srcClientId = Cl.id and  #tmpArchPipeLine.srcInterface=''
	update #tmpArchPipeLine
	Set srcNetHostName = Cl.net_Hostname
	From App_Client as Cl WITH (READUNCOMMITTED)
	where #tmpArchPipeLine.srcClientId = Cl.id
	update #tmpArchPipeLine
	Set destInterface = Cl.net_Hostname
	From App_Client as Cl WITH (READUNCOMMITTED)
	where #tmpArchPipeLine.destClientId = Cl.id and  #tmpArchPipeLine.destInterface=''
	update #tmpArchPipeLine
	Set destNetHostName = Cl.net_Hostname
	From App_Client as Cl WITH (READUNCOMMITTED)
	where #tmpArchPipeLine.destClientId = Cl.id
	update 	#tmpArchPipeLine
	Set srcPlatType	= (select SUM(PT.PlatformType)
	from APP_Platform as PT WITH (READUNCOMMITTED)
	where #tmpArchPipeLine.srcClientId = PT.ClientId)
	update 	#tmpArchPipeLine
	Set destPlatType = (select SUM(PT.PlatformType)
	from APP_Platform as PT WITH (READUNCOMMITTED)
	where #tmpArchPipeLine.destClientId = PT.ClientId)
	update 	#tmpArchPipeLine
	set fromClientReleaseId = MR.maxRelId
	from #tmpArchPipeLine tt INNER JOIN
	(
		select cId, max(LU.ReleaseId) as maxRelId
		from LicUsage as LU WITH (READUNCOMMITTED)
		where LU.OpType = 'Install' AND LU.InstallFlag = 0
		Group by cID
	) MR ON MR.CId = tt.srcClientId
	update 	#tmpArchPipeLine
	set toClientReleaseId = MR.maxRelId
	from #tmpArchPipeLine tt INNER JOIN
	(
		select cId, max(LU.ReleaseId) as maxRelId
		from LicUsage as LU WITH (READUNCOMMITTED)
		where LU.OpType = 'Install' AND LU.InstallFlag = 0
		Group by cID
	) MR ON MR.CId = tt.destClientId
--CVD service
--	update #tmpArchPipeLine
--	Set svcType = 0
--	from #tmpArchPipeLine t
--	where tsubClientapptype  in (42, 43)
--CDR service
--	update #tmpArchPipeLine
--	Set svcType = 1
--	from #tmpArchPipeLine t
--	where tsubClientapptype =84
	--No need to check the network connectivity for the clients where the backup activity is disabled
		IF object_id('tempdb.dbo.#clientIdToDelete') IS NOT NULL drop table #clientIdToDelete
	create table #clientIdToDelete	(clientId		integer	)
	--delete vsa pseudo client from participating in network readiness check
	INSERT INTO #clientIdToDelete
	SELECT DISTINCT IDA.clientId
	from APP_IDAName (nolock) IDA
	INNER JOIN CCRToSubClient CCRS on IDA.clientId = CCRS.ClientId AND CCRS.CCRId = @in_CCRId
	LEFT OUTER JOIN simInstalledPackages SIM on IDA.clientId = SIM.clientId
WHERE IDA.appTypeId = 106 AND CCRS.CCRId = @in_CCRId
	AND SIM.clientId  IS NULL
	INSERT INTO #clientIdToDelete
	SELECT C.id
	FROM APP_Client C
	INNER JOIN CCRToSubClient CCRS on C.id = CCRS.ClientId AND CCRS.CCRId = @in_CCRId
WHERE C.status & 0x4000000 = 0x4000000
	AND CCRS.CCRId = @in_CCRId
	INSERT INTO #clientIdToDelete
	SELECT	CCR.ClientId
	FROM	CCRToSubClient CCR
	LEFT OUTER JOIN simInstalledPackages SIM on CCR.clientId = SIM.clientId
	LEFT OUTER JOIN #clientIdToDelete  TODEL on CCR.ClientId = TODEL.clientId
	LEFT OUTER JOIN App_ClientProp ACP with(nolock)
    ON ACP.componentNameId = ccr.ClientId
    AND ACP.attrName LIKE 'Virtual Client' AND ACP.modified = 0
	WHERE CCR.CCRId = @in_CCRId AND
	TODEL.clientId IS NULL AND
	(SIM.clientId IS NULL AND ACP.componentNameId IS NULL)
	IF @isClusterCS = 1
	BEGIN
		INSERT INTO #clientIdToDelete
		SELECT PMClientId FROM APP_VMToPMMap WITH (NOLOCK)  where VMClientId = @CommServe_Id
	END
	DELETE T FROM #tmpArchPipeLine T
	INNER JOIN #clientIdToDelete C ON C.ClientId = T.srcClientId OR C.clientId = T.destClientId
	IF (@in_ischeckCSCConly>0)
	BEGIN
		DELETE T FROM #tmpArchPipeLine T
		LEFT OUTER JOIN (SELECT DISTINCT ClientId FROM CCRToSubClient WHERE CCRId = @l_CCRId ) SUB
		ON (T.srcClientId= ClientId and T.destClientId =   @CommServe_Id)
		 OR (T.destClientId= ClientId and T.srcClientId =   @CommServe_Id)
		WHERE SUB.ClientId IS NULL
	END
	if(@l_FetchOnly != 1)
	BEGIN
		--First update the table for the entries in the current list as the
		-- APP_Client names might have been changed since the last run.
		IF OBJECT_ID('tempdb..#tempdeleteCCRClientToClient') IS NOT NULL DROP TABLE #tempdeleteCCRClientToClient
		CREATE TABLE #tempdeleteCCRClientToClient(clientId INT)
		IF OBJECT_ID('tempdb..#tempupdateCCRClientToClient') IS NOT NULL DROP TABLE #tempupdateCCRClientToClient
		CREATE TABLE #tempupdateCCRClientToClient(fromClientId INT, ToClientId INT,
			FromClientInterfaceName NVARCHAR(2048), ToClientInterfaceName  NVARCHAR(2048))
		--Do not delete the deconfigured clients from CCRClientToClient to allow laptop pruning logic to delete them properly
		INSERT INTO #tempdeleteCCRClientToClient
        select fromclientId  FROM CCRClientToClient T WITH (NOLOCK)
        LEFT OUTER JOIN APP_Client C WITH (NOLOCK) ON C.id = T.fromclientId
        where C.id IS NULL
		UNION
        select ToClientId  FROM CCRClientToClient T WITH (NOLOCK)
        LEFT OUTER JOIN APP_Client C WITH (NOLOCK) ON C.id = ToClientId
        where C.id IS NULL
		UNION
		select clientId from #clientIdToDelete
		INSERT INTO #tempupdateCCRClientToClient
		select srcClientId,destClientId,srcInterface,DestInterface from #tmpArchPipeLine as tt
        INNER JOIN CCRClientToClient C WITH (NOLOCK)
        ON tt.srcClientId = C.FromClientId and tt.destClientId = C.ToClientId
         -- If it is a cluster CS
        IF @isClusterCS = 1
        BEGIN
			INSERT INTO #tempdeleteCCRClientToClient
            SELECT fromclientId FROM CCRClientToClient T WITH (NOLOCK)
            INNER JOIN APP_VMToPMMap C  WITH (NOLOCK)   ON C.PMClientId = T.fromclientId
            where VMClientId = @CommServe_Id
			UNION
            SELECT ToClientId FROM CCRClientToClient T WITH (NOLOCK)
            INNER JOIN APP_VMToPMMap C  WITH (NOLOCK)   ON C.PMClientId = ToClientId
            where VMClientId = @CommServe_Id
        END
         IF OBJECT_ID('tempdb..#tempInsertCCRClientToClient') IS NOT NULL DROP TABLE #tempInsertCCRClientToClient
		CREATE TABLE #tempInsertCCRClientToClient ( FromClientId INT,FromClientInterfaceName NVARCHAR(MAX),
		ToClientId INT,ToClientInterfaceName NVARCHAR(MAX),
		NumberOfNWHops INT,NWDelayInMilliSec INT,LastUpdateTime BIGINT,IsEnabled INT,Flag INT,errorCode INT,lastOnlineTime BIGINT,serviceType INT,IsDip INT,lastOfflineTime BIGINT)
		INSERT INTO #tempInsertCCRClientToClient (FromClientId,FromClientInterfaceName,ToClientId,ToClientInterfaceName
                        ,NumberOfNWHops,NWDelayInMilliSec,LastUpdateTime,IsEnabled,Flag,errorCode,lastOnlineTime,serviceType,IsDip,lastOfflineTime)
		SELECT DISTINCT tt.srcClientId, tt.srcInterface, tt.destClientId, tt.DestInterface,
        0, 0, 0, 0, 1, 0, 0 , tt.svcType, 0, 0
        from #tmpArchPipeLine as tt
		LEFT OUTER JOIN CCRClientToClient as cc WITH (READUNCOMMITTED) ON
		cc.FromClientId = tt.srcClientId and cc.ToClientId = tt.destClientId
                                and tt.svcType = cc.serviceType
		where CC.fromClientId IS NULL AND CC.ToClientId IS NULL AND CC.serviceType IS NULL
        --then clear out the flag and error String fields, so that the
        -- APP_Application that checks the network connectivity will update them easily.
      --check if DIP
        --First initialize the value to 0, then see if it is a DIP and set it correctly.
		IF OBJECT_ID('tempdb..#tempUpdateDIP') IS NOT NULL DROP TABLE #tempUpdateDIP
		CREATE TABLE #tempUpdateDIP (fromClientId INT, toClientId INT,isDip INT)
		INSERT INTO #tempUpdateDIP
        SELECT fromClientId, ToClientId,1
        from CCRClientToClient as CCRCC WITH (READUNCOMMITTED)
        INNER JOIN APP_Client as AP WITH (READUNCOMMITTED)
        ON FromClientId =AP.id AND FromClientInterfaceName !=AP.net_hostname
		UNION
        SELECT fromClientId, ToClientId,1
        from CCRClientToClient as CCRCC WITH (READUNCOMMITTED)
        INNER JOIN APP_Client as AP WITH (READUNCOMMITTED)
        ON
        ToClientId =AP.id AND ToClientInterfaceName !=AP.net_hostname
		UNION
		SELECT fromClientId, ToClientId,1
        from #tempInsertCCRClientToClient as CCRCC WITH (READUNCOMMITTED)
        INNER JOIN APP_Client as AP WITH (READUNCOMMITTED)
        ON FromClientId =AP.id AND FromClientInterfaceName !=AP.net_hostname
		UNION
        SELECT fromClientId, ToClientId,1
        from #tempInsertCCRClientToClient as CCRCC WITH (READUNCOMMITTED)
        INNER JOIN APP_Client as AP WITH (READUNCOMMITTED)
        ON
        ToClientId =AP.id AND ToClientInterfaceName !=AP.net_hostname
		INSERT INTO #tempUpdateDIP
        select CC.fromClientId,CC.ToClientId,0 from CCRClientToClient CC WITH (NOLOCK)
		LEFT OUTER JOIN #tempUpdateDIP tt ON CC.fromClientId = tt.fromClientId AND CC.ToClientId = tt.ToClientId
		where tt.fromClientId IS NULL AND tt.ToClientId IS NULL
		DELETE tt FROM #tempUpdateDIP tt
		INNER JOIN CCRClientToClient CC WITH (NOLOCK) ON  CC.fromClientId = tt.fromClientId AND CC.ToClientId = tt.ToClientId
		AND CC.IsDip = tt.IsDip
		--Now insert into the ClientToClient Table
        INSERT INTO CCRClientToClient(FromClientId,FromClientInterfaceName,ToClientId,ToClientInterfaceName
                        ,NumberOfNWHops,NWDelayInMilliSec,LastUpdateTime,IsEnabled,Flag,errorCode,lastOnlineTime,serviceType,IsDip,lastOfflineTime)
        select FromClientId,FromClientInterfaceName,ToClientId,ToClientInterfaceName
                        ,NumberOfNWHops,NWDelayInMilliSec,LastUpdateTime,IsEnabled,Flag,errorCode,lastOnlineTime,serviceType,IsDip,lastOfflineTime
						from #tempInsertCCRClientToClient
		update C
        set  FromClientInterfaceName = tt.FromClientInterfaceName,
			 ToClientInterfaceName = tt.ToClientInterfaceName,
			  errorCode = 0, Flag = 1
        from #tempupdateCCRClientToClient as tt
        INNER JOIN CCRClientToClient C
        ON tt.FromClientId = C.FromClientId and tt.ToClientId = C.ToClientId
		UPDATE CCRCC
        set CCRCC.IsDip = tt.isDip
        from CCRClientToClient as CCRCC
		INNER JOIN #tempUpdateDIP tt ON CCRCC.fromClientId = tt.fromClientId
							AND CCRCC.ToClientId = tt.ToClientId
		DELETE CCRCC FROM CCRclienttoclient CCRCC
        INNER JOIN #tempdeleteCCRClientToClient ON clientId =  fromClientId OR clientId = ToClientId
		IF OBJECT_ID('tempdb..#tempUpdateDIP') IS NOT NULL DROP TABLE #tempUpdateDIP
		IF OBJECT_ID('tempdb..#tempdeleteCCRClientToClient') IS NOT NULL DROP TABLE #tempdeleteCCRClientToClient
		IF OBJECT_ID('tempdb..#tempupdateCCRClientToClient') IS NOT NULL DROP TABLE #tempupdateCCRClientToClient
		IF OBJECT_ID('tempdb..#tempInsertCCRClientToClient') IS NOT NULL DROP TABLE #tempInsertCCRClientToClient
	end
	IF object_id('tempdb.dbo.#clientIdToDelete') is not null drop table #clientIdToDelete
	-- First zero out the flags field
	update CCRToSubCLient
	set CCRResultFlag = 0
	where CCRId = @l_CCRId
--Check the activity control to see if the activity at the any level is disabled.
	IF object_id('tempdb.dbo.#tblsubclients') is not null DROP TABLE #tblsubclients
	create table #tblsubclients	(clientId INT, AppTypeId INT,instanceId INT, subClientId INT)
	INSERT INTO #tblsubclients(clientId , AppTypeId ,instanceID,  subClientId )
		--CommCell Level Bkp activity is disabled
		SELECT CCR.clientId,0 AS AppTypeId,JM.instanceID,0 AS subClientId FROM  JMJobAction AS JM WITH (READUNCOMMITTED)
	INNER JOIN CCRToSubClient as CCR   WITH (READUNCOMMITTED)
	ON CCR.CCRId =  @in_CCRId AND JM.OpType = 4 AND JM.Action = 1 AND
			  (JM.ClientId = 1  AND JM.instanceID = 1 AND JM.AppType = 0 AND JM.AppId = 1 AND JM.clientGroupId = 0)
	UNION
		-- Client Group Level Bkp activity is disabled
	SELECT CCR.clientId,0 AS AppTypeId,JM.instanceID AS instanceID, 0 AS subClientId FROM  JMJobAction AS JM WITH (READUNCOMMITTED)
	INNER JOIN CCRToSubClient as CCR   WITH (READUNCOMMITTED)
	ON CCR.CCRId =  @in_CCRId AND JM.OpType = 4 AND JM.Action = 1 AND
	(JM.ClientId = 1 AND JM.AppType = 0  AND JM.instanceID = 1 AND JM.AppId = 1 AND JM.clientGroupId > 0
					AND JM.clientGroupId IN (select clientGroupId from APP_ClientGroupAssoc
					where clientId = CCR.clientId))
	UNION
		-- Client Level Bkp activity is disabled
	SELECT CCR.clientId,0 AS AppTypeId,JM.instanceID,0 AS subClientId FROM  JMJobAction AS JM WITH (READUNCOMMITTED)
	INNER JOIN CCRToSubClient as CCR   WITH (READUNCOMMITTED)
	ON CCR.CCRId =  @in_CCRId AND JM.OpType = 4 AND JM.Action = 1 AND
	(CCR.ClientId = JM.ClientId AND JM.AppType = 0 AND JM.AppId = 1 AND JM.instanceID = 1)
	UNION
	-- AppType Level Bkp activity is disabled
	SELECT CCR.clientId,CCR.AppTypeId AS AppTypeId,JM.instanceID,0 AS subClientId FROM  JMJobAction AS JM WITH (READUNCOMMITTED)
	INNER JOIN CCRToSubClient as CCR   WITH (READUNCOMMITTED)
	ON CCR.CCRId =  @in_CCRId AND JM.OpType = 4 AND JM.Action = 1 AND
	(CCR.ClientId = JM.ClientId AND CCR.AppTypeId = JM.AppType AND JM.AppId = 1 AND JM.instanceID = 1)
	UNION
	   -- subClient Level Bkp activity is disabled
	SELECT CCR.clientId,CCR.AppTypeId AS AppTypeId,JM.instanceID,CCR.SubClientId AS subClientId FROM  JMJobAction AS JM WITH (READUNCOMMITTED)
	INNER JOIN CCRToSubClient as CCR   WITH (READUNCOMMITTED)
	ON CCR.CCRId =  @in_CCRId AND JM.OpType = 4 AND JM.Action = 1 AND
	(JM.ClientId = 1 AND CCR.SubClientId = JM.AppId AND JM.AppType = 0 AND CCR.subClientId != 1  AND JM.instanceID = 1)
	UNION
	   -- instanceID Level Bkp activity is disabled
	SELECT CCR.clientId,CCR.AppTypeId AS AppTypeId,JM.instanceID,CCR.SubClientId AS subClientId FROM  JMJobAction AS JM WITH (READUNCOMMITTED)
	INNER JOIN APP_APPLICATION as A   WITH (READUNCOMMITTED)
	ON  JM.OpType = 4 AND JM.Action = 1 AND JM.APPID = 1 AND A.INSTANCE =JM.instanceID
	INNER JOIN CCRToSubClient as CCR   WITH (READUNCOMMITTED)
	 ON    JM.clientGroupId = 0 AND JM.ClientId = 1 AND CCR.CCRId =  @in_CCRId AND CCR.SubClientId = A.ID AND JM.AppType = 0 AND CCR.subClientId != 1
	Update CCR
SET CCRResultFlag = CCRResultFlag | 64
	FROM CCRToSubClient AS CCR
	INNER JOIN APP_Application A  WITH (READUNCOMMITTED) ON A.ClientId  = CCR.ClientId  AND 	a.id=CCR.subclientid AND A.APPTYPEID =CCR.AppTypeId
	INNER JOIN #tblsubclients tmp ON
	CCR.CCRId =  @in_CCRId AND CCR.ClientId = tmp.ClientId
	AND ((CCR.AppTypeId = tmp.AppTypeId AND tmp.AppTypeId>0 ) OR (tmp.AppTypeId=0))
	AND ((A.instance = tmp.instanceID AND tmp.instanceID>0 ) OR (tmp.instanceID=1))
	AND ((CCR.SubClientId = tmp.SubClientId AND tmp.SubClientId>0 ) OR (tmp.SubClientId=0))
	DROP TABLE #tblsubclients
	--modified GetClientMangledHostName()
	--as per Henry use following logic, if dip is defined between MA2->CC2
	--
	--		targetInterfaceName = MA1
	--		sourceInterfaceName = MA2
	--		relayInterfaceName = CC2
	update #tmpArchPipeLine
	set srcMangledHostName = dbo.GetClientMangledHostName(TAPL.srcclientid, TAPL.srcNetHostName),
		destMangledHostName = dbo.GetClientMangledHostName(TAPL.destclientid, TAPL.destInterface)
	from
		ArchPipeLine APL WITH (READUNCOMMITTED), #tmpArchPipeLine TAPL
	where
		APL.srcInterface = TAPL.srcInterface COLLATE SQL_Latin1_General_CP1_CI_AS and
		APL.destInterface = TAPL.destInterface COLLATE SQL_Latin1_General_CP1_CI_AS
	update #tmpArchPipeLine
	set srcMangledHostName = dbo.GetClientMangledHostName(TAPL.srcclientid, TAPL.srcNetHostName) ,
		destMangledHostName = dbo.GetClientMangledHostName(TAPL.destclientid, TAPL.destInterface)
	from
		ArchPipeLine APL WITH (READUNCOMMITTED), #tmpArchPipeLine TAPL
	where
		APL.srcInterface = TAPL.destInterface COLLATE SQL_Latin1_General_CP1_CI_AS and
		APL.destInterface = TAPL.srcInterface COLLATE SQL_Latin1_General_CP1_CI_AS
	update #tmpArchPipeLine
	set srcMangledHostName = dbo.GetClientMangledHostName(srcclientid, null),
		destMangledHostName = dbo.GetClientMangledHostName(destclientid, null)
	where
		srcMangledHostName = '' AND
		destMangledHostName = ''
	-- also returning DIP flag, and dipclientMangledHostname to specify srcInterface name in case of DIP
	select distinct tt.srcclientId, tt.srcNetHostName, tt.srcPlatType, tt.srcInterface, tt.destClientId,
	tt.destNetHostName, tt.destPlatType, tt.destInterface, 0, '', tt.tsubClientAppType, ccr.IsDip ,
tt.srcMangledHostName ,tt.destMangledHostName , tt.svcType,
Case CCR.IsDip when 1
	then (
			CASE WHEN srcNetHostName = srcInterface
			THEN  dbo.GetClientMangledHostName(destClientId, destInterface)
			ELSE dbo.GetClientMangledHostName(srcclientid, srcInterface)
			END
		 )
	end
	from #tmpArchPipeLine as tt, CCRClientToClient as ccr WITH (READUNCOMMITTED)
	where ccr.FromClientId = tt.srcclientId and ccr.ToClientId = tt.destClientId
	drop table #tmpClntToClnt
	drop table #tmpArchPipeLine
	drop table #tmpDataPath
	drop table #tmpRepSet
	drop table #tmpClientMAPairs
	drop table #tmpClientDDBMAPairs
	drop table #tmpClientRemoteCachePairs
	drop table #tmpMADDBMAPairs
	drop table #tmpClientRemoteCachePairsAll
	drop table #ClientWithoutSubclients
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CCRGetClientToClientByCCRId')
	delete from GxQscripts where name = 'CCRGetClientToClientByCCRId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRGetClientToClientByCCRId')
	delete from GXDBVersions where aliasname = 'CCRGetClientToClientByCCRId'
GO

insert into GXDBVersions values(2, 'CCRGetClientToClientByCCRId',  '00010057000200400000', 'CCRGetClientToClientByCCRId', '00010057000200400000')
GO

