

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCRGetClientForSQLReadiness.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCRGetClientForSQLReadiness.sp,v $ $Id: CCRGetClientForSQLReadiness.sp,v 1.1.2.1 2020/09/01 00:51:35 samrutkar Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "CCRGetClientForSQLReadiness"								|
--	|																		|
--	|THIS PROCEDURE WILL TEST TO SEE IF THE STRING "NEWSTRING" IS ALREADY A	|
--	| NAME IN THE TABLE, AND IF NOT INSERTS IT BEFORE RETURNING ALL ROWS 	|
--	| THAT MATCH THE SEARCH CRITERIA "ID < compVal".						|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A STORED PROCEDURE		|
--	| AND RETURNING RESULTS	                                                |
--  | Tinku:CCM:Archive File Id's are no longer unique						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCRGetClientForSQLReadiness')
BEGIN
	print '>>> Drop Stored Procedure: CCRGetClientForSQLReadiness <<<'
	drop procedure CCRGetClientForSQLReadiness
END
IF EXISTS (select * from GxQscripts where name='CCRGetClientForSQLReadiness')
	delete from GxQscripts where name = 'CCRGetClientForSQLReadiness'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRGetClientForSQLReadiness')
	delete from GXDBVersions where aliasname = 'CCRGetClientForSQLReadiness'
GO
print '... Creating Procedure: CCRGetClientForSQLReadiness'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCRGetClientForSQLReadiness
  @in_CCRId integer,
  @userId integer
AS
  DECLARE @fromClientId integer
  DECLARE @fromInstanceId integer
  DECLARE @proxyclientId integer
  DECLARE @proxyInstanceId integer
DECLARE @xml xml
set @xml = '<App_GetSQLClientInstanceReq clientId = "0" instanceid = "0" ><processinginstructioninfo><user userId ="'+CAST (@userId AS VARCHAR(8))+'" /> </processinginstructioninfo></App_GetSQLClientInstanceReq>'
DECLARE @table table (i_xml xml)
INSERT INTO @table
EXEC AppGetSqlClientInstances @xml output
IF OBJECT_ID ('tempdb..#RegularClient') IS NOT NULL DROP TABLE #RegularClient
CREATE TABLE #RegularClient (clientId INT, InstanceId INT)
IF OBJECT_ID ('tempdb..#CloudClient') IS NOT NULL DROP TABLE #CloudClient
CREATE TABLE #CloudClient (clientId INT, InstanceId INT,proxyclientId INT)
IF OBJECT_ID ('tempdb..#AGClient') IS NOT NULL DROP TABLE #AGClient
CREATE TABLE #AGClient (clientId INT, InstanceId INT,replicaclientId INT, instanceName NVARCHAR(1024))
INSERT INTO #RegularClient
select
cinfo.n.value('(../@cId)[1]','INT'),
cinfo.n.value('(@insId)[1]','INT')
from @xml.nodes('/App_GetSQLClientInstanceRsp/SqlClient/SqlInstance') as cinfo(n)
INSERT INTO #CloudClient
select
cinfo.n.value('(../../@cId)[1]','INT'),
cinfo.n.value('(../@insId)[1]','INT'),
cinfo.n.value('(@proxyId)[1]','INT')
from @xml.nodes('/App_GetSQLClientInstanceRsp/SqlClient/SqlInstance/proxy') as cinfo(n)
INSERT INTO #AGClient
select
cinfo.n.value('(../../@cId)[1]','INT'),
cinfo.n.value('(../@insId)[1]','INT'),
cinfo.n.value('(@repId)[1]','INT'),
cinfo.n.value('(@name)[1]','NVARCHAR(MAX)')
from @xml.nodes('/App_GetSQLClientInstanceRsp/SqlClient/SqlInstance/replica') as cinfo(n)
where cinfo.n.value('(@role)[1]','INT') = 1
DELETE R FROM #RegularClient R
INNER JOIN #AGClient A ON A.clientId = R.clientId AND R.instanceId = a.InstanceId
DELETE R FROM #RegularClient R
INNER JOIN #CloudClient A ON A.clientId = R.clientId AND R.instanceId = a.InstanceId
select R.clientId,InstanceId,0,0 from #RegularClient R
INNER JOIN CCRToSubClient CCR WITH (NOLOCK) ON CCR.clientId = R.clientId AND CCR.CCRId = @in_CCRId
UNION
select  R.clientId,InstanceId,replicaclientId,AN.id from #AGClient  R
INNER JOIN APP_InstanceName AN WITH (NOLOCK) ON AN.name = R.instanceName
INNER JOIN CCRToSubClient CCR WITH (NOLOCK) ON CCR.clientId = R.clientId AND CCR.CCRId = @in_CCRId
UNION
select  R.clientId,InstanceId,proxyclientId,0 from #CloudClient R
INNER JOIN CCRToSubClient CCR WITH (NOLOCK) ON CCR.clientId = R.clientId AND CCR.CCRId = @in_CCRId
IF OBJECT_ID ('tempdb..#RegularClient') IS NOT NULL DROP TABLE #RegularClient
IF OBJECT_ID ('tempdb..#CloudClient') IS NOT NULL DROP TABLE #CloudClient
IF OBJECT_ID ('tempdb..#AGClient') IS NOT NULL DROP TABLE #AGClient

IF EXISTS (select * from GxQscripts where name = 'CCRGetClientForSQLReadiness')
	delete from GxQscripts where name = 'CCRGetClientForSQLReadiness'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRGetClientForSQLReadiness')
	delete from GXDBVersions where aliasname = 'CCRGetClientForSQLReadiness'
GO

insert into GXDBVersions values(2, 'CCRGetClientForSQLReadiness',  '00010001000200010000', 'CCRGetClientForSQLReadiness', '00010001000200010000')
GO

