

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCRDDBReadinessCheck.sp] ---------- 

--#define Readines_Ready_But_Dedupe_Turned_Off
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCRDDBReadinessCheck.sp,v $ $Id: CCRDDBReadinessCheck.sp,v 1.3.2.11 2019/01/04 20:00:30 dkraplanee Exp $";
--  +========================================================================+
--  | Stored Proc:  CCRDDBReadinessCheck()
--  |
--  | Description:  Get a list of DDBS and their state
--	| Ready to be used/ unusable / ready but dedupe turned off
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCRDDBReadinessCheck')
BEGIN
	print '>>> Drop Stored Procedure: CCRDDBReadinessCheck <<<'
	drop procedure CCRDDBReadinessCheck
END
IF EXISTS (select * from GxQscripts where name='CCRDDBReadinessCheck')
	delete from GxQscripts where name = 'CCRDDBReadinessCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRDDBReadinessCheck')
	delete from GXDBVersions where aliasname = 'CCRDDBReadinessCheck'
GO
print '... Creating Procedure: CCRDDBReadinessCheck'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCRDDBReadinessCheck
  @i_CCRid int
AS
  DECLARE @retVal INTEGER;
  DECLARE @errorString VARCHAR(1024);
/*
DDB Store could be, a) ready to be used b)Will run in non dedupe mode (ready but not to be used) c) Unusable
add all flags and display reason as per priority?
- 66017
- 1
- 20066
- 20067
- 20082
- 20120
	- Here check if resiliency is enabled. Depending on that check for corrup limit count/all substore
- 20109
- 20072
- 20074
- 20073 (we may add case statements to add these if required)
*/
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	SET @retVal = 0
	SET @errorString = ''
	declare @isDDBActivityDisabled int
	set @isDDBActivityDisabled = 0
	DECLARE @allowDeDupJobsWhenDDBCorrupted int
	SET     @allowDeDupJobsWhenDDBCorrupted = 0
	DECLARE @isPowerVMFeatureEnabled INT
    SET @isPowerVMFeatureEnabled = ISNULL ((SELECT value FROM MMConfigs WHERE name LIKE 'MMCONFIG_CLOUD_VM_MANAGEMENT_ENABLED_FLAG'), 0)
	IF object_id('tempdb.dbo.#StoreStates') IS NOT NULL drop table #StoreStates
	create table #StoreStates(
								AppId int,
								archGroupCopyId int,
								SIDBStoreId int,
								SIDBCorruptLimit int,
								dedupeFlags int,
								extendedFlags bigint,
								StoreFlags int,
								CommCellId int
								)
	IF object_id('tempdb.dbo.#StoreReadiness') IS NOT NULL drop table #StoreReadiness
	create table #StoreReadiness(
									AppId int,
									archGroupCopyId int,
									SIDBStoreId int,
									ReadinessLevel int,
									Reason int,
									isDedupDisabled tinyint,
									isAllowBackupCorruptStore tinyint
									)
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0)
	BEGIN
		SET @errorString = 'Failed to declare table object'
		GOTO CX_ERROR_EXIT
	END
	select @allowDeDupJobsWhenDDBCorrupted = isnull(value, 0)
	from MMConfigs WITH (READUNCOMMITTED) where name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_BACKUP_DURING_DDB_RECONSTRUCTION'
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0)
	BEGIN
		SET @errorString = 'Failed to query MMConfig'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS( SELECT 1 FROM JMJobAction WITH (NOLOCK) WHERE clientId = 1 AND appType = 0 AND mediaAgentID = 1 AND opType IN (1, 100) /*All Activity, DDB Activity*/
				AND appId = (SELECT id FROM App_Application  WITH (NOLOCK) WHERE appTypeId = 1000) AND clientGroupId = 0 AND action = 1)
	BEGIN
		set @isDDBActivityDisabled = 1
	END
	INSERT INTO #StoreStates
	SELECT distinct AA.id, AGC.id, IDS.SIDBStoreId, 0, AGC.dedupeFlags, AGC.extendedFlags, IDS.flags, IDS.CommCellId
	FROM CCRToSubClient CS with (READUNCOMMITTED)
	JOIN App_Application AA with (READUNCOMMITTED) ON CS.SubclientId = AA.id
	JOIN archGroupCopy AGC with (READUNCOMMITTED) ON AA.dataArchGrpId = AGC.archGroupId
	INNER JOIN archSubclientCopyDDBMap CSD WITH (READUNCOMMITTED) ON CSD.copyID = AGC.id AND CSD.appId = CS.subClientId
	JOIN IdxSIDBStore IDS with (READUNCOMMITTED) ON CSD.SIDBStoreId = IDS.SIDBStoreId
	WHERE CSD.SIDBStoreId > 0 and
	CS.CCRId = @i_CCRid
		--AND AGC.dedupeFlags & CVA_USE_GLOBAL_DEDUP_STORE_FLAG = 0
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0)
	BEGIN
		SET @errorString = 'Failed to insert StoreStates'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO #StoreReadiness
SELECT  DISTINCT AppId,archGroupCopyId,	SIDBStoreId,1,0,0, 0	FROM #StoreStates
	WHERE AppId > 0
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0)
	BEGIN
		SET @errorString = 'Failed to insert StoreReadiness'
		GOTO CX_ERROR_EXIT
	END
	UPDATE SR
	SET isDedupDisabled = 1
	FROM #StoreReadiness SR
	JOIN archGroupCopy AGC with (readuncommitted) ON SR.archGroupCopyId = AGC.id
WHERE AGC.dedupeFlags & 1048576 <> 0
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0)
	BEGIN
		SET @errorString = 'Failed to update StoreReadiness dedupe disabled for subclient information'
		GOTO CX_ERROR_EXIT
	END
--update associated PolicyId for subclient policy case
	IF object_id('tempdb.dbo.#tempSubclientProp') IS NOT null DROP TABLE #tempSubclientProp
	CREATE TABLE #tempSubclientProp(
	subClientId					integer,
	associatedsubclientPolicyId 	integer,
	Deduplication				integer
	)
	INSERT INTO #tempSubclientProp (subClientId,associatedsubclientPolicyId,Deduplication)
	SELECT sc.subClientId,prop.attrVal, ISNULL(SProp.attrVal,1) FROM CCRToSubClient(nolock) AS sc
	INNER JOIN APP_SubclientProp prop WITH (NOLOCK) ON  prop.componentNameId = sc.subClientId AND prop.attrName = 'Associated subclient Policy' AND prop.modified = 0
	LEFT OUTER JOIN APP_SubclientProp SProp WITH (NOLOCK) ON  SProp.componentNameId =  prop.attrVal AND SProp.attrName = 'Single Instancing Option'  AND SProp.modified = 0
WHERE sc.CCRId = @i_CCRid AND SC.AppTypeId not in(13, 88,84)
	INSERT INTO #tempSubclientProp (subClientId,associatedsubclientPolicyId,Deduplication)
	SELECT sc.subClientId,0, ISNULL(prop.attrVal,1) FROM CCRToSubClient(nolock) AS sc
	LEFT OUTER JOIN APP_SubclientProp prop WITH (NOLOCK) ON  prop.componentNameId = sc.subClientId AND prop.attrName = 'Single Instancing Option' AND prop.modified = 0
	LEFT OUTER JOIN #tempSubclientProp SProp WITH (NOLOCK) ON  SProp.subClientId = sc.subClientId
	WHERE SProp.subClientId is NULL
AND sc.CCRId = @i_CCRid AND SC.AppTypeId not in(13, 88,84)
	UPDATE SR
	SET isDedupDisabled = 1
	FROM #StoreReadiness SR
	JOIN archGroupCopy AGC with (readuncommitted) ON SR.archGroupCopyId = AGC.id
	JOIN archGroup AG with (readuncommitted) ON AGC.id = AG.defaultCopy  /* Subclient level disable is only applicable for primary copy */
	JOIN App_Application app with (readuncommitted) ON app.id = SR.AppId
	JOIN #tempSubclientProp prop with (readuncommitted) ON prop.subClientId = SR.AppId  and prop.Deduplication=0
	WHERE SR.isDedupDisabled = 0
	IF object_id('tempdb.dbo.#tempSubclientProp') IS NOT null DROP TABLE #tempSubclientProp
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0)
	BEGIN
		SET @errorString = 'Failed to update StoreReadiness dedupe disabled for subclient information'
		GOTO CX_ERROR_EXIT
	END
	UPDATE SS
	SET SIDBCorruptLimit = isnull(task.percentCorruptLimit, 0)
	from #StoreStates SS
	INNER JOIN ArchGroupCopy copy with (readuncommitted)
ON	copy.id = SS.archGroupCopyId and SS.dedupeFlags & 8 > 0
	INNER JOIN archTask task with (readuncommitted)
	ON  copy.sealStoreTaskId = task.id
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0)
	BEGIN
		SET @errorString = 'Failed to update StoreStates corrupt limit information'
		GOTO CX_ERROR_EXIT
	END
	If @isDDBActivityDisabled > 0
	BEGIN
		UPDATE SR
SET ReadinessLevel = 0, Reason = 512
		FROM #StoreReadiness SR
		SELECT	@retVal = @@ERROR
		IF (@retVal != 0)
		BEGIN
			SET @errorString = 'Failed to update StoreReadiness readiness information'
			GOTO CX_ERROR_EXIT
		END
	END
	ELSE
	BEGIN
		UPDATE SR
SET ReadinessLevel = 0, Reason = 64
		FROM #StoreReadiness SR
		JOIN #StoreStates SS ON SR.SIDBStoreID = SS.SIDBStoreId
WHERE SS.StoreFlags & 16777216 > 0
AND SR.ReadinessLevel > 0
		AND SR.isDedupDisabled = 0
		SELECT	@retVal = @@ERROR
		IF (@retVal != 0)
		BEGIN
			SET @errorString = 'Failed to update StoreReadiness readiness information'
			GOTO CX_ERROR_EXIT
		END
		UPDATE SR
SET ReadinessLevel = 0, Reason = 32
		FROM #StoreReadiness SR
		JOIN #StoreStates SS ON SR.SIDBStoreID = SS.SIDBStoreId
		JOIN archGroupCopy AGC with (readuncommitted) ON SR.archGroupCopyId = AGC.id
		JOIN archGroup AG with (readuncommitted) ON AGC.archGroupId = AG.id
WHERE SR.ReadinessLevel > 0
			AND SR.isDedupDisabled = 0
			AND (@allowDeDupJobsWhenDDBCorrupted = 0 OR AG.defaultCopy <> AGC.id) --This check should only be applicable for backups not auxcopies.
			AND (SS.SIDBStoreId in
			(
				select idxss.SIDBStoreId
				from IdxSIDBSubStore idxss with (readuncommitted)
				join IdxSIDBStore st with (readuncommitted) on idxss.SIDBStoreId = st.SIDBStoreId
				where idxss.SIDBStoreId = SS.SIDBStoreId and idxss.CommCellid = SS.CommCellId
				and ((idxss.Version > st.Version)
or  (idxss.Flags & 8192 <> 0
and st.Flags & 8192 = 0))
			))
		SELECT	@retVal = @@ERROR
		IF (@retVal != 0)
		BEGIN
			SET @errorString = 'Failed to update StoreStates readiness information'
			GOTO CX_ERROR_EXIT
		END
		UPDATE SR
SET ReadinessLevel = 0, Reason = 128
		FROM #StoreReadiness SR
		JOIN #StoreStates SS ON SR.SIDBStoreID = SS.SIDBStoreId
WHERE (SS.StoreFlags & (67108864|268435456)) = 67108864
AND SR.ReadinessLevel > 0
		AND SR.isDedupDisabled = 0
		SELECT	@retVal = @@ERROR
		IF (@retVal != 0)
		BEGIN
			SET @errorString = 'Failed to update StoreReadiness readiness information'
			GOTO CX_ERROR_EXIT
		END
		UPDATE SR
SET ReadinessLevel = 0, Reason = 256
		FROM #StoreReadiness SR
		JOIN #StoreStates SS ON SR.SIDBStoreID = SS.SIDBStoreId
WHERE (SS.StoreFlags & 1024 = 1024)
AND SR.ReadinessLevel > 0
		AND SR.isDedupDisabled = 0
		SELECT	@retVal = @@ERROR
		IF (@retVal != 0)
		BEGIN
			SET @errorString = 'Failed to update StoreReadiness readiness information'
			GOTO CX_ERROR_EXIT
		END
		IF @allowDeDupJobsWhenDDBCorrupted = 0
		BEGIN
			UPDATE SR
SET ReadinessLevel = 0,
Reason =  32
			FROM #StoreStates SS, #StoreReadiness SR
			WHERE SS.SIDBStoreId = SR.SIDBStoreId
AND SR.ReadinessLevel > 0
				AND SR.isDedupDisabled = 0
				AND SS.SIDBStoreId in
			(select idxss.SIDBStoreId
			from	MMHost host with (readuncommitted), IdxCache idxc with (readuncommitted),
					IdxAccessPath idxa with (readuncommitted), IdxSIDBSubStore idxss with (readuncommitted)
			where idxss.SIDBStoreId = SS.SIDBStoreId
			and		idxss.CommCellId = SS.CommCellId
			and		idxss.ClientId = host.ClientId
			and		idxss.IdxCacheId = idxc.IdxCacheId
			and		idxss.IdxAccessPathId = idxa.IdxAccessPathId
			-- not corrupted
			and	(
(idxss.Status = 1)
			-- ddb move is not running (comments here say inverse of what it checks:/)
OR (idxss.Flags & 1024 = 1024)
			-- Media Agent online
                OR (
                        ( host.mmhostsoftstate = 0 AND
                            (  host.OfflineReason <> 7 --HOST_STATUS_POWER_MANAGED_VM
                                OR @isPowerVMFeatureEnabled = 0
                            )
                        ) OR host.mmhostenabled = 0
                    )
			-- Index Cache online
				OR (idxc.Enabled = 0 OR idxc.SoftState = 0)
			-- Access Path online and enabled
				OR (idxa.Enabled = 0 OR idxa.SoftState = 0)
				)
			group by idxss.SIDBStoreId
			having Count (distinct idxss.SubStoreId) > SS.SIDBCorruptLimit)
			SELECT	@retVal = @@ERROR
			IF (@retVal != 0)
			BEGIN
				SET @errorString = 'Failed to update StoreStates readiness information'
				GOTO CX_ERROR_EXIT
			END
			/*
			 *Sebastian: The following query should not make a difference as above query handles it.
			 *But following format in RMDataPathStatusFilters
			 *Give same status (offline/corrupted) for above and below queries
			*/
			UPDATE SR
SET ReadinessLevel = 0, Reason = 32
			FROM #StoreReadiness SR
			JOIN #StoreStates SS ON SR.SIDBStoreId = SS.SIDBStoreId
WHERE SR.ReadinessLevel > 0
				AND SR.isDedupDisabled = 0
				AND SS.SIDBStoreId not in
				(
					select distinct idxss.SIDBStoreId
								from	MMHost host with (readuncommitted), IdxCache idxc with (readuncommitted),
										IdxAccessPath idxa with (readuncommitted), IdxSIDBSubStore idxss with (readuncommitted)
								where idxss.SIDBStoreId = SS.SIDBStoreId
								and		idxss.CommCellId = SS.CommCellId
								-- not corrupted
and		idxss.Status != 1
								-- ddb move is not running
and		(idxss.Flags & 1024 != 1024)
								-- Media Agent online
						and		idxss.ClientId = host.ClientId
						and     (( host.mmhostsoftstate > 0 OR (host.mmhostsoftstate = 0 AND host.OfflineReason = 7 AND @isPowerVMFeatureEnabled > 0 )) and host.mmhostenabled > 0)
								-- Index Cache online
						and		idxss.IdxCacheId = idxc.IdxCacheId
						and		( idxc.Enabled > 0 and idxc.SoftState > 0)
								-- Access Path online
						and		idxss.IdxAccessPathId = idxa.IdxAccessPathId
						and		(idxa.Enabled > 0 and idxa.SoftState > 0)
				)
			SELECT	@retVal = @@ERROR
			IF (@retVal != 0)
			BEGIN
				SET @errorString = 'Failed to update StoreStates readiness information'
				GOTO CX_ERROR_EXIT
			END
		END --end if @allowDeDupJobsWhenDDBCorrupted = 0
	END --end if @isDDBActivityDisabled > 0
	UPDATE CCRSC
SET CCRResultFlag = CCRResultFlag | 2,
	CCRResourceReadinessFlag = CCRResourceReadinessFlag | SR.Reason
	FROM CCRToSubclient CCRSC
	JOIN MMDataPath MD with (readuncommitted) ON CCRSC.DataPathId = MD.DataPathId
	JOIN #StoreReadiness SR ON CCRSC.SubClientId = SR.AppId AND MD.CopyId = SR.archGroupCopyId
	WHERE CCRSC.CCRId = @i_CCRid
AND SR.ReadinessLevel = 0
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0)
	BEGIN
		SET @errorString = 'Failed to update CCRToSubclient readiness information'
		GOTO CX_ERROR_EXIT
	END
CX_ERROR_EXIT:
	IF object_id('tempdb.dbo.#StoreStates') IS NOT NULL drop table #StoreStates
	IF object_id('tempdb.dbo.#StoreReadiness') IS NOT NULL drop table #StoreReadiness
	SELECT  @retVal,@errorString
--END of stored procedure
GO

IF EXISTS (select * from GxQscripts where name = 'CCRDDBReadinessCheck')
	delete from GxQscripts where name = 'CCRDDBReadinessCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCRDDBReadinessCheck')
	delete from GXDBVersions where aliasname = 'CCRDDBReadinessCheck'
GO

insert into GXDBVersions values(2, 'CCRDDBReadinessCheck',  '00010003000200110000', 'CCRDDBReadinessCheck', '00010003000200110000')
GO

