

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_ShouldUpgrade.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCM_ShouldUpgrade.sp,v $ $Id: CCM_ShouldUpgrade.sp,v 1.1.2.3.68.1 2021/04/12 17:35:11 snair Exp $";
--
--  +========================================================================+
--  | Stored Precedure: CCM_ShouldUpgrade()
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CCM_ShouldUpgrade')
BEGIN
	print '>>> Drop Stored Procedure: CCM_ShouldUpgrade <<<'
	drop procedure CCM_ShouldUpgrade
END
IF EXISTS (select * from GxQscripts where name='CCM_ShouldUpgrade')
	delete from GxQscripts where name = 'CCM_ShouldUpgrade'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_ShouldUpgrade')
	delete from GXDBVersions where aliasname = 'CCM_ShouldUpgrade'
GO
print '... Creating Procedure: CCM_ShouldUpgrade'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CCM_ShouldUpgrade
AS
  DECLARE @isUpgradeNeeded INT
-- Source
  DECLARE @sourceReleaseId INT 
  DECLARE @sourceSPNumber INT 
  DECLARE @sourceBuildNum INT 
  DECLARE @sourceTranId INT
-- Destination
  DECLARE @destReleaseId INT 
  DECLARE @destSPNumber INT 
  DECLARE @destBuildNum INT 
  DECLARE @destTranId INT
SET NOCOUNT ON
SET @isUpgradeNeeded = 0
SET @sourceReleaseId 	= 0
SET @sourceSPNumber		= 0
SET @sourceBuildNum 	= 0
SET @sourceTranId		= 0
SET @destReleaseId   	= 0
SET @destSPNumber   	= 0
SET @destBuildNum		= 0
SET @destTranId			= 0
IF EXISTS (SELECT 1 FROM MMConfigs WHERE name like 'CCM_CONFIG_ENABLE_CROSS_VERSION_CCM' AND value = 0)
BEGIN
	GOTO ERROR_EXIT
END
/*
Source CS version
*/
IF (OBJECT_ID('CommServ_Merge..CCM_simAllGalaxyRel') IS NOT NULL)
BEGIN
	SELECT TOP 1 @sourceReleaseId = id, @sourceBuildNum = buildNum FROM CommServ_Merge..CCM_simAllGalaxyRel ORDER BY id DESC
END
ELSE
BEGIN
	SET @isUpgradeNeeded = 2
	GOTO ERROR_EXIT
END
IF (OBJECT_ID('CommServ_Merge..CCM_PatchDBSPInfo') IS NOT NULL)
BEGIN
	SELECT @sourceSPNumber = SPNumber, @sourceTranId = TransactionID FROM CommServ_Merge..CCM_PatchDBSPInfo
END
ELSE
BEGIN
	SET @isUpgradeNeeded = 2
	GOTO ERROR_EXIT
END
/*
Destination CS version
*/
SELECT TOP 1 @destReleaseId = id, @destBuildNum = buildNum FROM simAllGalaxyRel ORDER BY id DESC
SELECT @destSPNumber = SPNumber, @destTranId = TransactionID FROM PatchDBSPInfo
IF (@sourceReleaseId = 0)
BEGIN
	SET @isUpgradeNeeded = 2
	GOTO ERROR_EXIT
END
IF (@sourceReleaseId < @destReleaseId)
	OR (@sourceReleaseId = @destReleaseId AND @sourceBuildNum < @destBuildNum)
	OR (@sourceReleaseId = @destReleaseId AND @sourceBuildNum = @destBuildNum AND @sourceSPNumber < @destSPNumber)
	OR (@sourceReleaseId = @destReleaseId AND @sourceBuildNum = @destBuildNum AND @sourceSPNumber = @destSPNumber AND @sourceTranId < @destTranId)
BEGIN
	SET @isUpgradeNeeded = 1
END
ELSE
BEGIN
	SET @isUpgradeNeeded = 2
END
ERROR_EXIT:
SELECT @isUpgradeNeeded, @sourceReleaseId, @sourceSPNumber, @sourceBuildNum, @sourceTranId, @destReleaseId, @destSPNumber, @destBuildNum, @destTranId
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_ShouldUpgrade')
	delete from GxQscripts where name = 'CCM_ShouldUpgrade'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_ShouldUpgrade')
	delete from GXDBVersions where aliasname = 'CCM_ShouldUpgrade'
GO

insert into GXDBVersions values(2, 'CCM_ShouldUpgrade',  'v1.1.2.3.68.1', 'CCM_ShouldUpgrade', 'v1.1.2.3.68.1')
GO

