

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_SetAnswer.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCM_SetAnswer.sp,v $ $Id: CCM_SetAnswer.sp,v 1.5 2011/08/18 15:53:18 pkrishnan Exp $";
-- =============================================
-- Author:		Krithika Chandrasekaran
-- Create date: 08/19/2009
-- Description:	Set the CCM answer file details.
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_SetAnswer <<<'

IF EXISTS (select * from sysobjects where name='CCM_SetAnswer')
	drop procedure CCM_SetAnswer
IF EXISTS (select * from GxQscripts where name='CCM_SetAnswer')
	delete from GxQscripts where name = 'CCM_SetAnswer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_SetAnswer')
	delete from GXDBVersions where aliasname = 'CCM_SetAnswer'
GO
print '... Creating Procedure: CCM_SetAnswer'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCM_SetAnswer
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @xmlText XML
AS
BEGIN
	declare @count int
	declare @MountCount int
	declare @commcellCount int
	declare @clientcommcellCount int
	declare @ClientCount int
	set @count = @xmltext.value('count(//.[@mediaTypeId])','int')
	set @commcellCount = @xmltext.value('count(TMMsg_SetAnswerFile/mountPathMap/sourceCommcell/.[@commCellId])','int')
	set @clientcommcellCount = @xmltext.value('count(TMMsg_SetAnswerFile/clientAnswerMap/sourceCommcell/.[@commCellId])','int')
	-- XML HAndle
	declare @handle int
	declare @handle2 int
	declare @i int
	declare @j int
	DECLARE	@k int
	set @i = 1
	set @j = 1
	DECLARE @ErrVal INT
	declare @tempXML xml
	SET @ERRVAL = @@ERROR
	-- Declare all variables required
	declare @mediaTypeid integer
	declare @libid integer
	declare @mediaAgentid integer
	declare @drivePoolid integer
	declare @spareGroupid integer
	declare @sourceMountPathid integer
	declare @destLibid integer
	declare @commcellid integer
	declare @commcellGUID nvarchar(max)
	declare @destinationMountPath varchar(1024)
	declare @userName varchar(1024)
	declare @password varchar(1024)
	declare @isEditable integer
	DECLARE @ErrString VARCHAR(1024)
	declare @clientcommcellid integer
	declare @oldClientName varchar(1024)
	declare @oldClientHostName varchar(1024)
	declare @newClientName varchar(1024)
	declare @newClientHostName varchar(1024)
	while @i <= @count
	BEGIN
			SET @tempXML = @xmltext.query('(//.[mediaType])[sql:variable("@i")]')
			EXEC sp_xml_preparedocument @handle OUTPUT, @tempXML
			-- Got value
			SET @mediaTypeid = ISNULL((SELECT mediaTypeId FROM OPENXML (@handle, 'mediaTypeMappings/mediaType', 1) WITH (mediaTypeId int)), 0)
			SET @libid= ISNULL((SELECT libraryId FROM OPENXML (@handle, 'mediaTypeMappings/library', 1) WITH (libraryId int)), 0)
			SET @mediaAgentid = ISNULL((SELECT mediaAgentId FROM OPENXML (@handle, 'mediaTypeMappings/mediaAgent', 1) WITH (mediaAgentId int)), 1)
			SET @drivePoolid = ISNULL((SELECT drivePoolId FROM OPENXML (@handle, 'mediaTypeMappings/drivePool', 1) WITH (drivePoolId int)), 0)
			SET @spareGroupid = ISNULL((SELECT spareMediaGroupId FROM OPENXML (@handle, 'mediaTypeMappings/spareGroup', 1) WITH (spareMediaGroupId int)), 0)
			-- Similary set for other ids
			update CCMMediaTypeAnswers
			SET
			libraryId=@libid,
			mediaAgentId=@mediaAgentid,
			DrivePoolId=@drivePoolid,
			SparePoolGroupId=@spareGroupid
			where MediaTypeId=@mediaTypeid
			-- Write update statements with all ids
			EXEC sp_xml_removedocument @handle
			SET @i = @i + 1
	END
	SET @i=1
	while @i <= @commcellCount
	BEGIN
		SET @tempXML = @xmltext.query('(TMMsg_SetAnswerFile/mountPathMap/.[sourceCommcell])[sql:variable("@i")]')
		EXEC sp_xml_preparedocument @handle OUTPUT, @tempXML
		SET @commcellid = ISNULL((SELECT commCellId FROM OPENXML (@handle, 'mountPathMap/sourceCommcell', 1) WITH (commCellId int)), 0)
		SET @commcellGUID = (SELECT csGUID FROM OPENXML (@handle, 'mountPathMap/sourceCommcell', 1) WITH (csGUID nvarchar(max)))
		SET @MountCount= @tempXML.value('count(//.[@mountPathId])','int')
		SET @k = 1
		while @k<=@MountCount
		BEGIN
			SET @tempXML = @xmltext.query('(//.[sourceMountPath])[sql:variable("@j")]')
			EXEC sp_xml_preparedocument @handle2 OUTPUT, @tempXML
			SET @sourceMountPathid = ISNULL((SELECT mountPathId FROM OPENXML (@handle2, 'mountPaths/sourceMountPath', 1) WITH (mountPathId int)), 0)
			SET @libid = ISNULL((SELECT libraryId FROM OPENXML (@handle2, 'mountPaths/destinationLibrary', 1) WITH (libraryId int)), 0)
			SET @destinationMountPath = ISNULL((SELECT destinationMountPath FROM OPENXML (@handle2, 'mountPaths', 1) WITH (destinationMountPath varchar(1024))), '')
			SET @userName = ISNULL((SELECT userName FROM OPENXML (@handle2, 'mountPaths', 1) WITH (userName varchar(1024))), '')
			SET @password = ISNULL((SELECT password  FROM OPENXML (@handle2, 'mountPaths', 1) WITH (password  varchar(1024))), '')
			SET @isEditable = ISNULL((SELECT isEditable FROM OPENXML (@handle2, 'mountPaths', 1) WITH (isEditable int)), 1)
			update CCMMountPathAnswers
			set TargetLibraryId=@libid,
			TargetMountPathName=@destinationMountPath,
			TargetMountPathUserName=@userName,
			TargetMountPathPassword=@password,
			allowEdit=@isEditable
			where /*SourceCommCellId=@commcellid*/SourceCommCellGUID = @commcellGUID and SourceMountPathId=@sourceMountPathid
			SET @ERRVAL = @@ERROR
			IF (@ERRVAL <> 0)
			BEGIN
				SET @ERRSTRING = 'Failed to Update '
				GOTO ERROR_EXIT
			END
			EXEC sp_xml_removedocument @handle2
			SET @j = @j + 1
			SET @k = @k + 1
		END
		EXEC sp_xml_removedocument @handle
	SET @i = @i + 1
	END
	SET @i=1
	SET @j=1
	while @i <= @clientcommcellCount
	BEGIN
		SET @tempXML = @xmltext.query('(TMMsg_SetAnswerFile/clientAnswerMap/.[sourceCommcell])[sql:variable("@i")]')
		EXEC sp_xml_preparedocument @handle OUTPUT, @tempXML
		SET @commcellid = ISNULL((SELECT commCellId FROM OPENXML (@handle, 'clientAnswerMap/sourceCommcell', 1) WITH (commCellId int)), 0)
		SET @commcellGUID = (SELECT csGUID FROM OPENXML (@handle, 'clientAnswerMap/sourceCommcell', 1) WITH (csGUID nvarchar(max)))
		SET @clientCount= @tempXML.value('count(//.[@oldClientName])','varchar(1024)')
		SET @k = 1
		while @k<=@clientCount
		BEGIN
			SET @tempXML = @xmltext.query('(TMMsg_SetAnswerFile/clientAnswerMap/clientAnswers)[sql:variable("@j")]')
			EXEC sp_xml_preparedocument @handle2 OUTPUT, @tempXML
			SET @oldClientName = ISNULL((SELECT oldClientName FROM OPENXML (@handle2, 'clientAnswers', 1) WITH (oldClientName varchar(1024))), '')
			SET @newClientName = ISNULL((SELECT newClientName FROM OPENXML (@handle2, 'clientAnswers', 1) WITH (newClientName varchar(1024))), '')
			SET @newClientHostName = ISNULL((SELECT newClientHostName FROM OPENXML (@handle2, 'clientAnswers', 1) WITH (newClientHostName varchar(1024))), '')
			update CCMClientAnswers
			set NewClientName=@newClientName,
			NewClientHostName=@newClientHostName
			where /*SourceCommCellId=@commcellid*/SourceCommCellGUID = @commcellGUID and OldClientName=@oldClientName
			SET @ERRVAL = @@ERROR
			IF (@ERRVAL <> 0)
			BEGIN
				SET @ERRSTRING = 'Failed to Update '
				GOTO ERROR_EXIT
			END
			EXEC sp_xml_removedocument @handle2
			SET @j=@j+1
		      	SET @k = @k + 1
		END
		EXEC sp_xml_removedocument @handle
		SET @i=@i+1
	END
	ERROR_EXIT:
	select @ErrVal as '@errcode' , @ErrString as '@errorMessage' FOR XML PATH('TMMsg_GenericResp')
END
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_SetAnswer')
	delete from GxQscripts where name = 'CCM_SetAnswer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_SetAnswer')
	delete from GXDBVersions where aliasname = 'CCM_SetAnswer'
GO

insert into GXDBVersions values(2, 'CCM_SetAnswer',  '00010005000000000000', 'CCM_SetAnswer', '00010005000000000000')
GO

