

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_SCGScopeEntityMap.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/CCM_SCGScopeEntityMap.sp,v $ $Id: CCM_SCGScopeEntityMap.sp,v 1.1.2.2 2019/06/07 03:17:11 abilbrey Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_SCGScopeEntityMap')
BEGIN
	print '>>> Drop Stored Procedure: CCM_SCGScopeEntityMap <<<'
	drop procedure CCM_SCGScopeEntityMap
END
IF EXISTS (select * from GxQscripts where name='CCM_SCGScopeEntityMap')
	delete from GxQscripts where name = 'CCM_SCGScopeEntityMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_SCGScopeEntityMap')
	delete from GXDBVersions where aliasname = 'CCM_SCGScopeEntityMap'
GO
print '... Creating Procedure: CCM_SCGScopeEntityMap'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCM_SCGScopeEntityMap
  @i_entityXML XML
AS
BEGIN
  DECLARE @entityType INTEGER
  DECLARE @entityId INTEGER
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE @entity TABLE (
		type		INT,
		id			INT,
		name		NVARCHAR(1024),
		guid		UNIQUEIDENTIFIER
	)
	INSERT INTO @entity
		SELECT
			e.value('@entityType', 'INT'),
			e.value('@entityId', 'INT'),
			e.value('@entityName', 'NVARCHAR(1024)'),
			e.value('@entityGUID', 'UNIQUEIDENTIFIER')
		FROM @i_entityXML.nodes('/entity') d(e)
	IF EXISTS (SELECT 1 FROM @entity WHERE type = 1)
	BEGIN
		SELECT
			1,	-- COMMCELL_ENTITY
			2	-- Default CommcellId
	END
	ELSE IF EXISTS (SELECT 1 FROM @entity WHERE type = 13)
	BEGIN
		SELECT TOP 1
			type,
			id
		FROM (
				SELECT
					e.type,
					u.id
				FROM UMUsers u WITH(NOLOCK)
					INNER JOIN @entity e ON
						e.type = 13
						AND u.userGUID = e.guid
						AND u.login NOT LIKE '%(Deleted%'
				UNION ALL
				SELECT
					e.type,
					u.id
				FROM UMUsers u WITH(NOLOCK)
					INNER JOIN @entity e ON
						e.type = 13
						AND u.origUserGUID = e.guid
						AND u.login NOT LIKE '%(Deleted%'
			) q
	END
	ELSE IF EXISTS (SELECT 1 FROM @entity WHERE type = 15)
	BEGIN
		SELECT
			e.type,
			g.id
		FROM UMGroups g WITH(NOLOCK)
			INNER JOIN @entity e ON
				e.type = 15
				AND g.GUID = e.guid
	END
	ELSE IF EXISTS (SELECT 1 FROM @entity WHERE type = 61)
	BEGIN
		SELECT
			e.type,
			p.id
		FROM UMDSProviders p WITH(NOLOCK)
			INNER JOIN @entity e ON
				e.type = 61
				AND p.domainName = e.name
	END
	ELSE
	BEGIN
		DECLARE @emsg NVARCHAR(MAX)
		SELECT
			@emsg = 'Unsupported entity: type[' + CAST(e.type AS NVARCHAR(12)) + '] '
				+ 'id[' + CAST(e.id AS NVARCHAR(12)) + '] '
				+ 'name[' + e.name + '] '
				+ 'GUID[' + CAST(e.guid AS NVARCHAR(60)) + '] '
		FROM @entity e
		RAISERROR(@emsg, 16, 1)
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_SCGScopeEntityMap')
	delete from GxQscripts where name = 'CCM_SCGScopeEntityMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_SCGScopeEntityMap')
	delete from GXDBVersions where aliasname = 'CCM_SCGScopeEntityMap'
GO

insert into GXDBVersions values(2, 'CCM_SCGScopeEntityMap',  '00010001000200020000', 'CCM_SCGScopeEntityMap', '00010001000200020000')
GO

