

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Remap_MountPath.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Remap_MountPath <<<'

IF EXISTS (select * from sysobjects where name='CCM_Remap_MountPath')
	drop procedure CCM_Remap_MountPath
IF EXISTS (select * from GxQscripts where name='CCM_Remap_MountPath')
	delete from GxQscripts where name = 'CCM_Remap_MountPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Remap_MountPath')
	delete from GXDBVersions where aliasname = 'CCM_Remap_MountPath'
GO
print '... Creating Procedure: CCM_Remap_MountPath'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCM_Remap_MountPath
  @i_mountPathToRemap XML
AS
SET NOCOUNT ON
BEGIN TRANSACTION RemapMountpath
	DECLARE @commcellNumber	BIGINT
	DECLARE	@commcellGUID	VARCHAR(256)
	DECLARE @mountPathId INTEGER
	DECLARE @mountPathName VARCHAR(MAX)
	DECLARE @reMapToLibraryId INTEGER
	DECLARE @errVal INT
	DECLARE @errString VARCHAR(1024)
	DECLARE @currentLibraryId INTEGER
	DECLARE @currentLibraryMountpathType integer
	DECLARE @remapToLibraryMountpathtype integer
	DECLARE @targetMountPathName varchar(max)
	DECLARE @sourceMountPathType INTEGER
	DECLARE @remapToLibraryMasterPoolId INTEGER
	SET @errVal = 0
	SET @errString = 'NO_ERROR'
	SELECT @commcellNumber = PARAM.value('@commcellNumber','BIGINT'),
				 @commcellGUID = PARAM.value('@commcellGUID','VARCHAR(256)')
	FROM @i_mountPathToRemap.nodes('/TMMsg_RemapMountPath') AS messageXML(param)
	IF @@ERROR > 0
	BEGIN
		SET @errVal = @@ERROR
		SET @errString = 'ERROR: SELECT @commcellNumber AND @commcellGUID from XML'
		GOTO ERROR_EXIT
	END
	SELECT @mountPathId = PARAM.value('@mountPathId','INTEGER'),
				 @mountPathName = PARAM.value('@mountPathName','VARCHAR(MAX)')
	FROM @i_mountPathToRemap.nodes('/TMMsg_RemapMountPath/mountPathToRemap/sourceMountPath')	AS messageXML(param)
	IF @@ERROR > 0
	BEGIN
		SET @errVal = @@ERROR
		SET @errString = 'ERROR: SELECT @mountPathId AND @mountPathName from XML'
		GOTO ERROR_EXIT
	END
	SELECT @reMapToLibraryId = PARAM.value('@libraryId','INTEGER')
	FROM @i_mountPathToRemap.nodes('/TMMsg_RemapMountPath/mountPathToRemap/destinationLibrary') AS messageXML(param)
	IF @@ERROR > 0
	BEGIN
		SET @errVal = @@ERROR
		SET @errString = 'ERROR: SELECT @reMapToLibraryId from XML'
		GOTO ERROR_EXIT
	END
	SET @currentLibraryId = ISNULL((SELECT TargetLibraryId FROM CCMMountPathAnswers WHERE SourceCommCellGUID = @commcellGUID AND SourceMountPathId = @mountPathId),0)
	IF @@ERROR > 0
	BEGIN
		SET @errVal = @@ERROR
		SET @errString = 'ERROR: SET @currentLibraryId from CCMMountPathAnswers'
		GOTO ERROR_EXIT
	END
	IF @currentLibraryId = @reMapToLibraryId
	BEGIN
		SET @errVal = -1
		SET @errString = 'ERROR: Target Library To Remap Is Same as Currently Set Library'
		GOTO ERROR_EXIT
	END
	SET @currentLibraryMountpathType = ISNULL((SELECT TOP 1 MountPathTypeId FROM MMMountPath WHERE LibraryId = @currentLibraryId),-1)
	IF @@ERROR > 0
	BEGIN
		SET @errVal = @@ERROR
		SET @errString = 'ERROR: SET @currentLibraryMountpathType from MMMountPath'
		GOTO ERROR_EXIT
	END
	SET @remapToLibraryMountpathtype = ISNULL((SELECT TOP 1 MountPathTypeId FROM MMMountPath WHERE LibraryId = @reMapToLibraryId),-1)
	IF @@ERROR > 0
	BEGIN
		SET @errVal = @@ERROR
		SET @errString = 'ERROR: SET @remapToLibraryMountpathtype from MMMountPath'
		GOTO ERROR_EXIT
	END
	IF @currentLibraryMountpathType = -1
	BEGIN
		SET @errVal = -2
		SET @errString = 'ERROR: Currently Set Library does not have any mount paths configured. No mount path to remap'
		GOTO ERROR_EXIT
	END
	IF (@remapToLibraryMountpathtype = -1)
	BEGIN
		SET @errVal = -3
		SET @errString = 'ERROR: Target Magnetic Library does not have any mount paths configured. Choose a different library'
		GOTO ERROR_EXIT
	END
	IF @currentLibraryMountpathType <> @remapToLibraryMountpathtype
	BEGIN
		IF @currentLibraryMountpathType = 0 AND @remapToLibraryMountpathtype = 4
		BEGIN
			SET @errVal = -4
			SET @errString = 'ERROR: Current Library is Regular Magnetic. But selected library is Static Shared. Choose a different library'
		END
		ELSE IF	@currentLibraryMountpathType = 4 AND @remapToLibraryMountpathtype = 0
		BEGIN
			SET @errVal = -5
			SET @errString = 'ERROR: Current Library is Static Shared. But selected library is Regular Magnetic. Choose a different library'
		END
		ELSE
		BEGIN
			SET @errVal = -6
			SET @errString = 'ERROR: Current Library Mount Path Type is different from the selected library. Choose a different library'
		END
		GOTO ERROR_EXIT
	END
	SET @targetMountPathName = (SELECT TargetMountPathName FROM CCMMountPathAnswers WHERE SourceCommCellGUID = @commcellGUID AND SourceMountPathId = @mountPathId)
	IF @@ERROR > 0
	BEGIN
		SET @errVal = @@ERROR
		SET @errString = 'ERROR: SET @targetMountPathName from CCMMountPathAnswers'
		GOTO ERROR_EXIT
	END
	SET @sourceMountPathType = (SELECT MountPathType FROM CCMMountPathAnswers WHERE SourceCommCellGUID = @commcellGUID AND SourceMountPathId = @mountPathId)
	IF @@ERROR > 0
	BEGIN
		SET @errVal = @@ERROR
		SET @errString = 'ERROR: SET @sourceMountPathType from CCMMountPathAnswers'
		GOTO ERROR_EXIT
	END
	SET @remapToLibraryMasterPoolId = ISNULL((SELECT top 1 MasterPoolId FROM MMMasterPool WHERE LibraryId = @reMapToLibraryId),0)
	IF @@ERROR > 0
	BEGIN
		SET @errVal = @@ERROR
		SET @errString = 'ERROR: SET @remapToLibraryMasterPoolId from MMMasterPool'
		GOTO ERROR_EXIT
	END
	IF @remapToLibraryMasterPoolId = 0
	BEGIN
		SET @errVal = -7
		SET @errString = 'ERROR: Selected Target Library does not have Master Pool'
		GOTO ERROR_EXIT
	END
	IF @sourceMountPathType = 0 AND @currentLibraryMountpathType = 0
	BEGIN
		UPDATE MMMedia SET LibraryId = @reMapToLibraryId
		FROM MMMountPath a, MMMediaSide b
		WHERE a.MountPathName = @targetMountPathName
		AND a.LibraryId = @currentLibraryId
		AND a.MediaSideId = b.MediaSideId
		AND b.MediaId = MMMedia.MediaId
		IF @@ERROR > 0
		BEGIN
			SET @errVal = @@ERROR
			SET @errString = 'ERROR: UPDATE MMMedia Library Id'
			GOTO ERROR_EXIT
		END
		UPDATE MMMountPath SET LibraryId = @reMapToLibraryId, MasterPoolId = @remapToLibraryMasterPoolId
		WHERE MountPathName = @targetMountPathName AND LibraryId = @currentLibraryId
		IF @@ERROR > 0
		BEGIN
			SET @errVal = @@ERROR
			SET @errString = 'ERROR: UPDATE MMMountPath Library Id and MasterPoolId'
			GOTO ERROR_EXIT
		END
	END
	ELSE IF @sourceMountPathType = 0 AND @currentLibraryMountpathType = 4
	BEGIN
		UPDATE MMMedia SET LibraryId = @reMapToLibraryId
		FROM MMMountPathToStorageDevice A, MMDeviceController B, CCMMountPathAnswers C, MMMountPath D, MMMediaSide E
		WHERE B.Folder = @targetMountPathName
		AND B.ClientId = (SELECT TargetDeviceMediaAgentId FROM CCMMountPathAnswers WHERE SourceMountPathId = @mountPathId AND SourceCommCellGUID = @commcellGUID)
		AND B.DeviceId = A.DeviceId
		AND A.MountPathId = D.MountPathId
		AND D.MediaSideId = E.MediaSideId
		AND E.MediaId = MMMedia.MediaId
		IF @@ERROR > 0
		BEGIN
			SET @errVal = @@ERROR
			SET @errString = 'ERROR: UPDATE MMMedia Library Id'
			GOTO ERROR_EXIT
		END
		UPDATE MMMountPath SET LibraryId = @reMapToLibraryId, MasterPoolId = @remapToLibraryMasterPoolId
		FROM MMMountPathToStorageDevice A, MMDeviceController B, CCMMountPathAnswers C
		WHERE B.Folder = @targetMountPathName
		AND B.ClientId = (SELECT TargetDeviceMediaAgentId FROM CCMMountPathAnswers WHERE SourceMountPathId = @mountPathId AND SourceCommCellGUID = @commcellGUID)
		AND B.DeviceId = A.DeviceId
		AND A.MountPathId = MMMountPath.MountPathId
		IF @@ERROR > 0
		BEGIN
			SET @errVal = @@ERROR
			SET @errString = 'ERROR: UPDATE MMMountPath Library Id and MasterPoolId'
			GOTO ERROR_EXIT
		END
	END
	ELSE IF @sourceMountPathType = 4 AND @currentLibraryMountpathType = 4
	BEGIN
		UPDATE MMMedia SET LibraryId = @reMapToLibraryId
		FROM CCMMountPathAnswers A, CCMDevicePathAnswers B, MMDeviceController C, MMMountPathToStorageDevice D, MMMountPath E, MMMediaSide F
		WHERE A.SourceDeviceId = B.SourceDeviceId
		AND A.SourceMountPathId = @mountPathId
		AND A.SourceCommCellGUID = @commcellGUID
		AND B.SourceCommCellGUID = @commcellGUID
		AND B.TargetDevicePath = C.Folder
		AND B.TargetMediaAgentId = C.ClientId
		AND C.DeviceId = D.DeviceId
		AND D.MountPathId = E.MountPathId
		AND E.MountPathName = @targetMountPathName
		AND E.MediaSideId = F.MediaSideId
		AND F.MediaId = MMMedia.MediaId
		IF @@ERROR > 0
		BEGIN
			SET @errVal = @@ERROR
			SET @errString = 'ERROR: UPDATE MMMedia Library Id'
			GOTO ERROR_EXIT
		END
		UPDATE MMMountPath SET LibraryId = @reMapToLibraryId, MasterPoolId = @remapToLibraryMasterPoolId
		FROM CCMMountPathAnswers A, CCMDevicePathAnswers B, MMDeviceController C, MMMountPathToStorageDevice D
		WHERE A.SourceDeviceId = B.SourceDeviceId
		AND A.SourceMountPathId = @mountPathId
		AND A.SourceCommCellGUID = @commcellGUID
		AND B.SourceCommCellGUID = @commcellGUID
		AND B.TargetDevicePath = C.Folder
		AND B.TargetMediaAgentId = C.ClientId
		AND C.DeviceId = D.DeviceId
		AND D.MountPathId = MMMountPath.MountPathId
		AND MMMountPath.MountPathName = @targetMountPathName
		IF @@ERROR > 0
		BEGIN
			SET @errVal = @@ERROR
			SET @errString = 'ERROR: UPDATE MMMountPath Library Id and MasterPoolId'
			GOTO ERROR_EXIT
		END
	END
	ELSE
	BEGIN
		SET @errVal = -8
		SET @errString = 'ERROR: Unsupported MountPathTypes For Remap Operation. No changes Made'
		GOTO ERROR_EXIT
	END
	UPDATE CCMMountPathAnswers SET TargetLibraryId = @reMapToLibraryId
	WHERE SourceCommCellGUID = @commcellGUID AND SourceMountPathId = @mountPathId
	IF @@ERROR > 0
	BEGIN
		SET @errVal = @@ERROR
		SET @errString = 'ERROR: UPDATE CCMMountPathAnswers'
		GOTO ERROR_EXIT
	END
	COMMIT	TRANSACTION RemapMountpath
	SET @errVal = 0
	SET @errString = 'NO_ERROR'
	SELECT @errVal as '@errorCode' , @errString as '@errorMessage' FOR XML PATH('EVGui_GenericResp')
	RETURN
	ERROR_EXIT:
	ROLLBACK TRANSACTION RemapMountpath
	SELECT @errVal as '@errorCode' , @errString as '@errorMessage' FOR XML PATH('EVGui_GenericResp')
	RETURN
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Remap_MountPath')
	delete from GxQscripts where name = 'CCM_Remap_MountPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Remap_MountPath')
	delete from GXDBVersions where aliasname = 'CCM_Remap_MountPath'
GO

insert into GXDBVersions values(2, 'CCM_Remap_MountPath',  '00000000000000000000', 'CCM_Remap_MountPath', '00000000000000000000')
GO

