

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Populate_GRC_State.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Populate_GRC_State <<<'

IF EXISTS (select * from sysobjects where name='CCM_Populate_GRC_State')
	drop procedure CCM_Populate_GRC_State
IF EXISTS (select * from GxQscripts where name='CCM_Populate_GRC_State')
	delete from GxQscripts where name = 'CCM_Populate_GRC_State'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Populate_GRC_State')
	delete from GXDBVersions where aliasname = 'CCM_Populate_GRC_State'
GO
print '... Creating Procedure: CCM_Populate_GRC_State'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCM_Populate_GRC_State
  @i_statexml XML,
  @i_GrcCommCellGUID varchar(36),
  @i_jobId int,
  @i_isCloudGRCJob int
AS
  DECLARE @currentEndTrackId bigint
  DECLARE @currentEndTrackTime int
SET NOCOUNT ON
	DECLARE @SubclientTrackTab	TABLE
	(
		subclientId				int,
		startTrackingId			bigint,
		startTrackingTime		int
	)
	DECLARE	@lastEndTrackingId			bigint
	DECLARE	@lastEndTrackingTime			int
	IF @i_isCloudGRCJob > 0
	BEGIN
		DECLARE @PodCellGUIDInStateFile		UNIQUEIDENTIFIER
		DECLARE @GRCCellGUIDInStateFile		UNIQUEIDENTIFIER
		DECLARE @PODCellGUIDInDB			UNIQUEIDENTIFIER
		DECLARE @GRCCellGUIDInDB			UNIQUEIDENTIFIER
		DECLARE @StateFileCreationTime		INT
		SELECT 	@PODCellGUIDInDB = csGUID FROM App_CommCell WITH(READUNCOMMITTED) WHERE id = 2
		SET		@GRCCellGUIDInDB = @i_GrcCommCellGUID
		SELECT	@PodCellGUIDInStateFile = PARAM.value('(.//podcell/@csGUID)[1]', 'UNIQUEIDENTIFIER'),
				@GRCCellGUIDInStateFile   =  PARAM.value('(.//grc/@csGUID)[1]', 'UNIQUEIDENTIFIER'),
				@StateFileCreationTime =  PARAM.value('@creationTime', 'INT')
		FROM 	@i_statexml.nodes('/App_GRCStateFileInfo') AS stateFileXML(PARAM)
		--Return failure if either of the GUIDs in state file doesn't match with the values from DB which means state file is corrupted or manually modified
		IF (@PodCellGUIDInStateFile IS NOT NULL AND @PodCellGUIDInStateFile <> @PODCellGUIDInDB)
			OR (@GRCCellGUIDInStateFile IS NOT NULL AND @GRCCellGUIDInStateFile <> @GRCCellGUIDInDB)
		BEGIN
			SET @currentEndTrackId = -1		-- -1 means state file doesn't belongs to POD-GRC combination or it's corrupted.
			GOTO CX_EXIT
		END
		--If there is no import happening we should stop the export after some days
		--We can identify this by checking the state file creation time
		DECLARE @nDaysToProduceDumpsWithNoConsumption INT = ISNULL((SELECT value from MMConfigs WHERE name = 'CCM_CONFIG_MAXIMUM_NUMBER_OF_DAYS_TO_PRODUCE_DUMPS_WITH_NO_CONSUMPTION'),
10)
		IF @nDaysToProduceDumpsWithNoConsumption > 0 AND @nDaysToProduceDumpsWithNoConsumption < DATEDIFF(DD, dbo.GetDateTime(@StateFileCreationTime), GETUTCDate())
		BEGIN
			SET @currentEndTrackId = -2		-- -2 means no successful import for last 30 days
			GOTO CX_EXIT
		END
	END
	DECLARE @GrcCommCellId 	int
	SELECT @GrcCommCellId = id FROM App_CommCell WHERE csGUID = @i_GrcCommCellGUID
	--populate state xml values into table
	INSERT	INTO @SubclientTrackTab
	SELECT	PARAM.value('@subclientId', 'int'),
			CONVERT(BIGINT, PARAM.value('@startTrackingId', 'VARCHAR(256)')),
			PARAM.value('@startTrackingTime', 'int')
	FROM 	@i_statexml.nodes('/App_GRCStateFileInfo/subclientTrackEntity') AS stateFileXML(PARAM)
	SELECT	@lastEndTrackingId = ISNULL(CONVERT(BIGINT, PARAM.value('@trackingId', 'VARCHAR(256)')), 0),
			@lastEndTrackingTime = ISNULL(PARAM.value('@trackingTime', 'int'), 0)
    FROM 	@i_statexml.nodes('/App_GRCStateFileInfo/endTrackEntity') AS stateFileXML(PARAM)
	-- Update tracking values in GRC_SubclientTrackingStats table.
	UPDATE	GRC_SubclientTrackingStats
	SET		TrackingId		= @lastEndTrackingId,
			TrackingTime	= @lastEndTrackingTime
	FROM	GRC_SubclientTrackingStats a
			INNER JOIN @SubclientTrackTab b ON a.commcellId = @GrcCommCellId AND a.subclientId = b.subclientId
	WHERE	a.TrackingId < @lastEndTrackingId
	-- Delete the tracking for the subclients which are not part of previous capture.
	DELETE GRC_SubclientTrackingStats WHERE TrackingId <> @lastEndTrackingId AND commcellId = @GrcCommCellId
	-- Get current end trackId and time.
	SET @currentEndTrackId = ISNULL((SELECT max(trackingId) FROM GRCJMJobDataStatsTracking WITH (NOLOCK)),0)
    SET @currentEndTrackTime = ISNULL((SELECT createdTime FROM GRCJMJobDataStatsTracking WITH (NOLOCK) WHERE trackingId = @currentEndTrackId), dbo.GetUnixTime(getutcdate()))
	-- Update current end trackid and time in GRC_SubclientTrackingInfo table
	-- SubclientId = 0 represents the current end tracking info. End traking info is same for all the subclients captured in a job.
	INSERT INTO GRC_SubclientTrackingInfo
	VALUES ( @i_jobId, 2 /*job commcellId*/, 0 /*subclientId*/, @currentEndTrackId, @currentEndTrackTime )
CX_EXIT:
	SELECT @currentEndTrackId, @currentEndTrackTime
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Populate_GRC_State')
	delete from GxQscripts where name = 'CCM_Populate_GRC_State'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Populate_GRC_State')
	delete from GXDBVersions where aliasname = 'CCM_Populate_GRC_State'
GO

insert into GXDBVersions values(2, 'CCM_Populate_GRC_State',  '00000000000000000000', 'CCM_Populate_GRC_State', '00000000000000000000')
GO

