

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_Validate.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Procedure to validate the incoming dump.
--  +========================================================================+
-- $Id: CCM_Merge_Validate.sp,v 1.8.62.4 2018/03/20 00:43:16 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Merge_Validate <<<'

IF EXISTS (select * from sysobjects where name='CCM_Merge_Validate')
	drop procedure CCM_Merge_Validate
IF EXISTS (select * from GxQscripts where name='CCM_Merge_Validate')
	delete from GxQscripts where name = 'CCM_Merge_Validate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Validate')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Validate'
GO
print '... Creating Procedure: CCM_Merge_Validate'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Merge_Validate
AS
  DECLARE @retVal INTEGER;
  DECLARE @errorString varchar(1024);
SET NOCOUNT ON
	---------------------------------------------------------
BEGIN TRANSACTION TRAN_Merge_Validate_Main
SET @retVal = 0
	IF NOT EXISTS (SELECT * FROM MASTER..SYSDATABASES WHERE NAME = 'CommServ_Merge')
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Validate -- DATABASE CommServ_Merge DOES NOT EXIST'
SET @retVal = (8+1)
		GOTO CX_ERROR_EXIT
	END
	DECLARE	@release_source varchar(128)
	DECLARE	@release_destination varchar(128)
	SET @release_source = (select top 1 release from CommServ_Merge..CCM_simAllGalaxyRel order by id desc)
	SET @release_destination = (select top 1 release from simAllGalaxyRel order by id desc)
	IF @release_source > @release_destination
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Validate -- SOURCE COMMCELL HAS HIGHER VERSION THAN DESTINATION: SOURCE IN [' + @release_source + '] AND DESTINATION IN [' + @release_destination + ']'
SET @retVal = (128+1)
		GOTO CX_ERROR_EXIT
	END
	-- Identify the clients which are being remerged. This is needed
	-- because validations like client limit check and client (appType) license
	-- check shouldn't be done for clients which are being re-merged
	EXEC CCM_Merge_Map 1
	-- GET ClientId TO BE MERGED
	INSERT INTO CCM_MAP_Client
	SELECT DISTINCT id, 0, name, name, net_hostname, net_hostname, origCCId, 0, 0, 0
	FROM Commserv_Merge..CCM_APP_Client
	-- Remove the ones has no Client Id. It may come from Tape Import
	WHERE id > 0
	IF	@@error > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Validate -- CCM_MAP_Client -- INSERT'
SET @retVal = (8+1)
		GOTO CX_ERROR_EXIT
	END
	-- Get new client name and net_hostname from user
	UPDATE CCM_MAP_Client SET new_name = b.new_name, new_net_hostName = b.new_net_hostName
	FROM CCM_MAP_Client a, Commserv_Merge..CCM_ClientNameMapping b
	WHERE a.old_name = b.old_name
	IF	@@error > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Validate -- CCM_MAP_Client -- UPDATE new_name'
SET @retVal = (8+1)
		GOTO CX_ERROR_EXIT
	END
	-- Give client new net_hostname if it was empty on destination
	UPDATE APP_Client SET net_hostname = b.new_net_hostname
	FROM APP_Client a, CCM_MAP_Client b
	WHERE a.name = b.new_name
	AND a.net_hostname = ''
	AND b.new_net_hostname <> ''
	IF	@@error > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Validate -- Client -- UPDATE net_hostname'
SET @retVal = (8+1)
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_Client SET exist = -1
	FROM CCM_MAP_Client a, APP_Client b
	WHERE a.new_name = b.name OR a.new_net_hostname = b.net_hostname
	IF	@@error > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Validate -- CCM_MAP_Client -- UPDATE exist'
SET @retVal = (8+1)
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_Client SET exist = -2   --CLIENT GUID CONFLICT
	FROM CCM_MAP_Client a, APP_Client b
	WHERE a.new_name = b.name AND (a.new_net_hostname = b.net_hostname OR a.new_net_hostname = '')
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Validate -- CCM_MAP_Client -- UPDATE exist 2'
SET @retVal = (8+1)
		GOTO CX_ERROR_EXIT
	END
	/*
	 *PrasadNara: 10:33 AM 6/20/2012 Set exist based on below conditions
	 * If client guid matches consider that as remerge of same client
	 * If client guid does NOT match but both client Name and Host Name matches then treat it as remerge case only when config param is set or for EDC or for TapeImport
	 * If client guid does NOT match, client name does NOT match, client host name matches consider that as new entry and merge successfully
	 * If client guid does NOT match, client name matches, client host name does NOT match fail saying name conflict
	 * If client guid does NOT match, both client name and client host name does NOT match consider that as new entry and merge successfully
	 */
	--Match with GUID
	UPDATE CCM_MAP_Client SET exist = 1, new_id = b.id
	FROM CCM_MAP_Client a, APP_Client b, Commserv_Merge..CCM_APP_Client c
	WHERE a.old_id = c.id AND b.GUID = c.GUID
		AND LEN(b.GUID) > 0 AND b.GUID <> '00000000-0000-0000-0000-000000000000'
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Validate -- CCM_MAP_Client -- UPDATE exist matching GUID'
SET @retVal = (8+1)
		GOTO CX_ERROR_EXIT
	END
	--Client name and net host name both matches
	IF EXISTS (SELECT 1 FROM MMConfigs where name = 'CCM_CONFIG_DO_NOT_FAIL_MIGRATION_FOR_CLIENT_GUID_CONFLICT' and value = 1)
	BEGIN
		-- net_hostname will be empty for client migrated through tape import
		UPDATE CCM_MAP_Client SET exist = 1, new_id = b.id
		FROM CCM_MAP_Client a, APP_Client b
		WHERE a.new_name = b.name
		AND (a.new_net_hostname = b.net_hostname OR a.new_net_hostname = '')
		AND exist <> 1
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Validate -- CCM_MAP_Client -- UPDATE exist'
SET @retVal = (8+1)
			GOTO CX_ERROR_EXIT
		END
	END
	--Client name doesn't match and net host name matches
	UPDATE CCM_MAP_Client SET exist = 0, new_id = 0
	FROM CCM_MAP_Client a, APP_Client b
	WHERE a.new_name <> b.name
	AND (a.new_net_hostname = b.net_hostname AND a.new_net_hostname <> '')
	AND a.exist <> 1
	IF	@@ERROR > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Validate -- CCM_MAP_Client -- UPDATE exist'
SET @retVal = (8+1)
		GOTO CX_ERROR_EXIT
	END
	--Check for HostName and CVD port conflict
	IF NOT EXISTS (SELECT * FROM MMConfigs where name = 'CCM_CONFIG_ALLOW_CCM_FOR_CLIENTS_WITH_SAME_HOSTNAME_CVDPORT' AND value = 1)
	BEGIN
		UPDATE CCM_MAP_Client SET exist = -3
		FROM CCM_MAP_Client a, APP_Client b, Commserv_Merge..CCM_APP_Client c
		WHERE a.new_net_hostname = b.net_hostname  AND a.new_net_hostname <> ''
		AND c.cvdPort = b.cvdPort
		AND a.old_id = c.id
		AND a.exist = 0
		IF	@@ERROR > 0
		BEGIN
			SET @errorString = 'ERROR: CCM_Merge_Validate -- CCM_MAP_Client -- UPDATE exist Hostname and cvdPort conflict'
SET @retVal = (8+1)
			GOTO CX_ERROR_EXIT
		END
	END
	-- client is invalid if only its name exists and net_hostname doesn't exist in destination
	IF EXISTS (SELECT * FROM CCM_MAP_Client WHERE exist = -1)
	BEGIN
		SELECT @errorString = 'ERROR: Following clients are already present in CommServe [' + AliasName + '] with different host name. Please change the clients name either on source CommServe or destination CommServe'
		FROM App_Commcell WHERE Id = 2
		SELECT 	@errorString = @errorString + CHAR(13) + 'Client [' + b.name + '] already present with host name ['+ b.net_hostname + ']. Importing client host name ['+ a.new_net_hostname + '].'
		FROM CCM_MAP_Client a, App_Client b
		WHERE (a.new_name = b.name OR a.new_net_hostname = b.net_hostname)
		AND a.exist = -1
SET @retVal = (8+1)
		GOTO CX_ERROR_EXIT
	END
	-- client is invalid if both its name and net_hostname exist in destination but guid differs
	IF EXISTS (SELECT * FROM CCM_MAP_Client WHERE exist = -2)
	BEGIN
		SELECT @errorString = 'ERROR: Following clients are already present in CommServe [' + AliasName + '] with different GUID. Please change the clients name either on source CommServe or destination CommServe'
		FROM App_Commcell WHERE Id = 2
		SELECT 	@errorString = @errorString + CHAR(13) + 'Client [' + b.name + '] already present with GUID ['+ CONVERT(varchar(36), b.GUID) + ']. Importing client GUID ['+ CONVERT(varchar(36), c.GUID) + '].'
		FROM CCM_MAP_Client a, App_Client b, Commserv_Merge..CCM_APP_Client c
		WHERE a.old_id = c.id AND b.GUID <> c.GUID
		AND LEN(b.GUID) > 0 AND b.GUID <> '00000000-0000-0000-0000-000000000000'
		AND (a.new_name = b.name AND (a.new_net_hostname = b.net_hostname OR a.new_net_hostname = ''))
		AND a.exist = -2
SET @retVal = (8+1)
		GOTO CX_ERROR_EXIT
	END
	-- client is invalid if only its net_hostname and CVDPort are already used for different client
	IF EXISTS (SELECT * FROM CCM_MAP_Client WHERE exist = -3)
	BEGIN
		SELECT @errorString = 'ERROR: Following clients are already present in CommServe [' + AliasName + '] with same host name and CVD port. ADVICE: 1. Change the clients host name either on source CommServe or destination CommServe.  2. Set "Allow CCM job when multiple clients exists with same host name and cvd port" parameter value to 1 in Media Management configuration when duplicate host name is expected.'
		FROM App_Commcell WHERE Id = 2
		SELECT 	@errorString = @errorString + CHAR(13) + 'Client [' + b.name + '] already present with host name ['+ b.net_hostname + '] and CVD port ['+ CONVERT(varchar, b.cvdport) + ']. Importing client name ['+ a.new_name + '].'
		FROM CCM_MAP_Client a, App_Client b, Commserv_Merge..CCM_APP_Client c
		WHERE (a.new_net_hostname = b.net_hostname  AND a.new_net_hostname <> ''
				AND a.old_id = c.id	AND b.cvdport = c.cvdport)
		AND a.exist = -3
SET @retVal = (8+1)
		GOTO CX_ERROR_EXIT
	END
	-- Delete the clients which are being re-merged
	-- The application layer (cpp code)'s validation will only
	-- need to know the new clients which are being merged
	delete FROM Commserv_Merge..CCM_APP_Client
	WHERE id in (SELECT old_id FROM CCM_MAP_Client WHERE exist = 1)
	IF	@@error > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Validate -- CCM_APP_Client -- DELETE remerged clients'
SET @retVal = (8+1)
		GOTO CX_ERROR_EXIT
	END
	delete FROM Commserv_Merge..CCM_MMHost
	FROM Commserv_Merge..CCM_MMHost a, CCM_MAP_Client b, Commserv..MMHost c
	WHERE a.ClientId = b.old_id
	  AND b.exist = 1
	  AND b.new_id = c.ClientId
	IF	@@error > 0
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Validate -- CCM_APP_Client -- DELETE remerged media agents'
SET @retVal = (8+1)
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	EXEC CCM_Merge_Map 0
	COMMIT	TRANSACTION TRAN_Merge_Validate_Main
	SELECT	@retVal,@errorString
	RETURN @retVal
CX_ERROR_EXIT:
    EXEC CCM_Merge_Map 0
    ROLLBACK TRANSACTION TRAN_Merge_Validate_Main
	SELECT	@retVal,@errorString
	RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_Validate')
	delete from GxQscripts where name = 'CCM_Merge_Validate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Validate')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Validate'
GO

insert into GXDBVersions values(2, 'CCM_Merge_Validate',  '00010008006200040000', 'CCM_Merge_Validate', '00010008006200040000')
GO

