

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_Snap.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge Snaps of a client/sub-client table.
--  +========================================================================+
-- $Id: CCM_Merge_Snap.sp,v 1.14.200.1 2018/03/20 00:48:36 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Merge_Snap <<<'

IF EXISTS (select * from sysobjects where name='CCM_Merge_Snap')
	drop procedure CCM_Merge_Snap
IF EXISTS (select * from GxQscripts where name='CCM_Merge_Snap')
	delete from GxQscripts where name = 'CCM_Merge_Snap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Snap')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Snap'
GO
print '... Creating Procedure: CCM_Merge_Snap'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Merge_Snap
  @errStr varchar(1024) OUTPUT
AS
	---------------------------------------------------------
--Code below here is from CCM_Merge_Snap.spb--
SET NOCOUNT ON
	-- Do not use transaction here, because it is called by another stored procedure with transaction
	-- CCM_Merge_Snap should be called only after CCM_Merge_Client, instance, backupset, application (sub-client), commcell
	SET @errStr = 'ERROR: GENERAL ERROR!'
	---------------------------------------------------------
	-- Merge SMControlHost will be based on GUID or SMArrayId and SMHostName
UPDATE CommServ_Merge..CCM_SMControlHost
	SET    origCCId = 2
	WHERE  origCCId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_SMControlHost -- UPDATE -- origCCId to 2'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CCM_MAP_SMControlHost
	SELECT ControlHostId, 0, origCCId, 0, SMArrayId, SMHostName, GUID, ClientId, (CASE WHEN ClientId = 1 THEN 1 ELSE 0 END), 0
FROM CommServ_Merge..CCM_SMControlHost
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMControlHost -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMControlHost SET new_origCCId = b.new_id
	FROM CCM_MAP_SMControlHost a, CCM_MAP_Commcell b
	WHERE a.old_origCCId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMControlHost -- UPDATE -- new_origCCId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMControlHost SET new_ClientId = b.new_id
	FROM CCM_MAP_SMControlHost a, CCM_MAP_Client b
	WHERE a.old_ClientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMControlHost -- UPDATE -- new_ClientId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE 	CCM_MAP_SMControlHost SET new_ClientId = b.newEntityId
	FROM 	CCM_MAP_SMControlHost a
INNER JOIN CCMMergeEntityMap b ON a.old_clientId = b.oldEntityId AND b.entityType = 3
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMControlHost -- UPDATE -- new_ClientId - 2'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMControlHost SET new_id = b.ControlHostId, exist = 1
	FROM CCM_MAP_SMControlHost a, SMControlHost b
	WHERE a.GUID = b.GUID OR a.SMArrayId = b.SMArrayId AND a.SMHostName = b.SMHostName
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMControlHost -- UPDATE -- new_id -- existing control hosts'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS(SELECT * FROM CCM_MAP_SMControlHost WHERE new_origCCId = 0 AND exist = 0)
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMControlHost -- unknown new origCCIds'
		GOTO CX_ERROR_EXIT
	END
	/*
	@TODO - properly migrate the following new columns once Snap/SRM team completely develops/integrates their new feature
	a.ClientId, a.SoftState, a.IsEnabled, a.IsActive, a.BrokenCode, a.ReasonCode, a.Flags, a.AdminConsole,
	  a.Properties, a.ReserveField3, a.ReserveField4
	  */
	INSERT INTO SMControlHost
	SELECT a.SnapShotEngineId, a.SnapVendorName, a.SMArrayId, a.SMHostIP, a.SMHostName, a.SMHostPortNumber, a.SMHostUserName, a.SMHostPassword,
	       a.SMHostFlags, a.SMHostStatus, a.SMHostDescription, a.SnapShotEngineName, a.DeviceGroupName, a.SMHostOption, a.SourceId,
	       b.new_origCCId, a.GUID, a.ReserveField1, a.ReserveField2, a.ReserveFieldStr,
		   b.new_ClientId, a.SoftState, a.IsEnabled, a.IsActive, a.BrokenCode, a.ReasonCode, a.Flags, a.AdminConsole,
		   a.Properties, a.ReserveField3, a.ReserveField4
FROM CommServ_Merge..CCM_SMControlHost a, CCM_MAP_SMControlHost b
	WHERE a.ControlHostId = b.old_id
	  AND a.GUID = b.GUID
	  AND b.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- SMControlHost -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMControlHost SET new_id = b.ControlHostId
	FROM CCM_MAP_SMControlHost a, SMControlHost b
	WHERE a.GUID = b.GUID
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMControlHost -- UPDATE -- new_id -- inserted control hostks'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS(SELECT * FROM CCM_MAP_SMControlHost WHERE new_id = 0)
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMControlHost -- unknown new ids'
		GOTO CX_ERROR_EXIT
	END
	----------------------------------------------------------------------------------------------------------------------------------------
	-- Merge SMSnap
UPDATE CommServ_Merge..CCM_SMSnap
	SET    origCCId = 2
	WHERE  origCCId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_SMSnap -- UPDATE -- origCCId to 2'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CCM_MAP_SMSnap
	SELECT SMSnapId, 0, ControlHostId, 0, origCCId, 0, GUID, 0
FROM CommServ_Merge..CCM_SMSnap
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMSnap -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMSnap SET new_origCCId = b.new_id
	FROM CCM_MAP_SMSnap a, CCM_MAP_Commcell b
	WHERE a.old_origCCId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMSnap -- UPDATE -- new_origCCId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMSnap SET new_controlHostId = b.new_id
	FROM CCM_MAP_SMSnap a, CCM_MAP_SMControlHost b
	WHERE a.old_controlHostId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMSnap -- UPDATE -- new_controlHostId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMSnap SET new_id = b.SMSnapId, exist = 1
	FROM CCM_MAP_SMSnap a, SMSnap b
	WHERE a.GUID = b.GUID
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMSnap -- UPDATE -- exist'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS(SELECT * FROM CCM_MAP_SMSnap WHERE (new_origCCId = 0 OR (new_controlHostId = 0 AND old_controlHostId <> 0)) AND exist = 0)
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMSnap -- unknown new ids (new_origCCId and new_controlHostId)'
		GOTO CX_ERROR_EXIT
	END
	/*
	@TODO - properly migrate the following new columns once Snap/SRM team completely develops/integrates their new feature
	a.ArrayVolumeId, a.UsedSpaceMB, a.ReserveField3, a.ReserveField4
	*/
	INSERT INTO SMSnap
	SELECT a.SnapShotEngineId, a.OriginalSnapEngineId, b.new_controlHostId, a.GroupId, a.SnapType, a.SnapFlags, a.PruneFlags, a.SnapStatus, a.SnapStatusUpdateTime, a.CreationTime,
	       a.RetryCount, a.DeviceEntryType, a.ConnectionType, a.SnapSourceDevice, a.SnapDevice, a.ShadowCopyId, a.UniqueIdentifier,
	       a.SourceIdentifier, a.TargetIdentifier, b.new_origCCId, a.GUID, a.ReserveField1, a.ReserveField2, a.ReserveFieldStr,
		a.ArrayVolumeId, a.LunId, a.UsedSpaceBytes, a.ReserveField3, a.ReserveField4
FROM CommServ_Merge..CCM_SMSnap a, CCM_MAP_SMSnap b
	WHERE a.SMSnapId = b.old_id
	  AND a.GUID = b.GUID
	  AND b.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- SMSnap -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMSnap SET new_id = b.SMSnapId
	FROM CCM_MAP_SMSnap a, SMSnap b
	WHERE a.GUID = b.GUID
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMSnap -- UPDATE -- new_id'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS(SELECT * FROM CCM_MAP_SMSnap WHERE new_id = 0)
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMSnap -- unknown new ids'
		GOTO CX_ERROR_EXIT
	END
	----------------------------------------------------------------------------------------------------------------------------------------
	-- Merge SMVolume
UPDATE CommServ_Merge..CCM_SMVolume
	SET    CommCellId = 2
	WHERE  CommCellId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_SMVolume -- UPDATE -- CommCellId to 2'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CCM_MAP_SMVolume
	SELECT SMVolumeId, 0, SourceClientId, 0, OriginClientId, 0, CommCellId, 0, CopyId, 0, AppId, 0, GUID, 0
FROM CommServ_Merge..CCM_SMVolume
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMVolume -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMVolume SET new_CommCellId = b.new_id
	FROM CCM_MAP_SMVolume a, CCM_MAP_Commcell b
	WHERE a.old_CommCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMVolume -- UPDATE -- new_CommCellId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMVolume SET new_SourceClientId = b.new_id
	FROM CCM_MAP_SMVolume a, CCM_MAP_Client b
	WHERE a.old_SourceClientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMVolume -- UPDATE -- new_SourceClientId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMVolume SET new_OriginClientId = b.new_id
	FROM CCM_MAP_SMVolume a, CCM_MAP_Client b
	WHERE a.old_OriginClientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMVolume -- UPDATE -- newOriginClientId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMVolume SET new_copyId = b.new_id
	FROM CCM_MAP_SMVolume a, CCM_MAP_ArchGroupCopy b
	WHERE a.old_copyId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMVolume -- UPDATE -- new_copyId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMVolume SET new_appId = b.new_id
	FROM CCM_MAP_SMVolume a, CCM_MAP_Application b
	WHERE a.old_appId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMVolume -- UPDATE -- new_appId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMVolume SET new_id = b.SMVolumeId, exist = 1
	FROM CCM_MAP_SMVolume a, SMVolume b
	WHERE a.GUID = b.GUID
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMVolume -- UPDATE -- exist'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS(SELECT * FROM CCM_MAP_SMVolume WHERE (new_CommCellId = 0 OR new_SourceClientId = 0 OR new_copyId = 0 OR new_appId = 0 OR (new_OriginClientId = 0 AND old_OriginClientId <> 0)) AND exist = 0)
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMVolume -- unknown new ids (new_CommCellId, new_SourceClientId, new_OriginClientId, new_copyId, new_appId'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS (
	SELECT b.new_SourceClientId, a.MountHostId, b.new_CommCellId, a.JobId, a.ArchFileId, b.new_copyId, b.new_appId, a.AppTypeId, a.PruneFlags,
	       a.VolumeFlags, a.VolumeStatus, a.VolumeStatusUpdateTime, a.MountStatus, a.MountStatusUpdateTime, a.LogicalUnmountTime, a.CreationTime, a.RetryCount, a.DevMode, a.UserId,
	       a.GroupId, a.SnapSource, a.MountProxyId, a.RemoteOp, a.RemoteOpStatus, a.VmHostId, a.RecoveryPointId, b.new_OriginClientId, a.SourcePath, a.MountPath, a.SourceGUID, a.MountGUID,
	       a.SourceDevice, a.MountDevice, a.MountOptions, a.ShadowSetId, a.ShadowCopyId, a.RepBasePath, a.RepRelativePath, a.OriginSourcePath, a.GUID, a.ReserveField1, a.ReserveField2,
	       a.ReserveFieldStr
FROM CommServ_Merge..CCM_SMVolume a, CCM_MAP_SMVolume b
	WHERE a.SMVolumeId = b.old_id
	  AND a.GUID = b.GUID
	  AND b.exist = 0
	  )
	BEGIN
	INSERT INTO SMVolume
	SELECT b.new_SourceClientId, a.MountHostId, b.new_CommCellId, a.JobId, a.ArchFileId, b.new_copyId, b.new_appId, a.AppTypeId, a.PruneFlags,
	       a.VolumeFlags, a.VolumeStatus, a.VolumeStatusUpdateTime, a.MountStatus, a.MountStatusUpdateTime, a.LogicalUnmountTime, a.CreationTime, a.RetryCount, a.DevMode, a.UserId,
	       a.GroupId, a.SnapSource, a.MountProxyId, a.RemoteOp, a.RemoteOpStatus, a.VmHostId, a.RecoveryPointId, b.new_OriginClientId, a.SourcePath, a.MountPath, a.SourceGUID, a.MountGUID,
	       a.SourceDevice, a.MountDevice, a.MountOptions, a.ShadowSetId, a.ShadowCopyId, a.RepBasePath, a.RepRelativePath, a.OriginSourcePath, a.GUID, a.ReserveField1, a.ReserveField2,
	       a.ReserveFieldStr
FROM CommServ_Merge..CCM_SMVolume a, CCM_MAP_SMVolume b
	WHERE a.SMVolumeId = b.old_id
	  AND a.GUID = b.GUID
	  AND b.exist = 0
	END
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- SMVolume -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMVolume SET new_id = b.SMVolumeId
	FROM CCM_MAP_SMVolume a, SMVolume b
	WHERE a.GUID = b.GUID
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMVolume -- UPDATE -- new_id'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS(SELECT * FROM CCM_MAP_SMVolume WHERE new_id = 0)
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMVolume -- unknown new ids'
		GOTO CX_ERROR_EXIT
	END
	----------------------------------------------------------------------------------------------------------------------------------------
	-- Merge SMMetaData
UPDATE CommServ_Merge..CCM_SMMetaData
	SET    origCCId = 2
	WHERE  origCCId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_SMMetaData -- UPDATE -- origCCId to 2'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CCM_MAP_SMMetaData
	SELECT MetaDataId, 0, RefId, 0, origCCId, 0, GUID, 0, RefType
FROM CommServ_Merge..CCM_SMMetaData
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMMetaData -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMMetaData SET new_origCCId = b.new_id
	FROM CCM_MAP_SMMetaData a, CCM_MAP_Commcell b
	WHERE a.old_origCCId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMMetaData -- UPDATE -- new_origCCId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMMetaData SET new_refId = b.new_id
	FROM CCM_MAP_SMMetaData a, CCM_MAP_SMSnap b
	WHERE a.old_refId = b.old_id
	AND   a.RefType = 2
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMMetaData -- UPDATE -- new_refId for snaps'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMMetaData SET new_refId = b.new_id
	FROM CCM_MAP_SMMetaData a, CCM_MAP_SMVolume b
	WHERE a.old_refId = b.old_id
	AND   a.RefType = 1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMMetaData -- UPDATE -- new_refId for volume'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMMetaData SET new_id = b.MetaDataId, exist = 1
	FROM CCM_MAP_SMMetaData a, SMMetaData b
	WHERE a.GUID = b.GUID
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMMetaData -- UPDATE -- exist'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS(SELECT * FROM CCM_MAP_SMMetaData WHERE new_origCCId = 0 AND exist = 0)
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMMetaData -- unknown new_origCCId'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO SMMetaData
	SELECT a.MetaDataType, a.RefType, b.new_refId, a.PruneFlags, a.MetaData, b.new_origCCId, a.GUID, a.ReserveField1, a.ReserveField2,
	       a.ReserveFieldStr
FROM CommServ_Merge..CCM_SMMetaData a, CCM_MAP_SMMetaData b
	WHERE a.MetaDataId = b.old_id
	  AND a.GUID = b.GUID
	  AND b.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- SMMetaData -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMMetaData SET new_id = b.MetaDataId
	FROM CCM_MAP_SMMetaData a, SMMetaData b
	WHERE a.GUID = b.GUID
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMMetaData -- UPDATE -- new_id'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS(SELECT * FROM CCM_MAP_SMMetaData WHERE new_id = 0)
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMMetaData -- unknown new ids'
		GOTO CX_ERROR_EXIT
	END
	----------------------------------------------------------------------------------------------------------------------------------------
	-- Merge SMVolSnapMap will be based on GUID
UPDATE CommServ_Merge..CCM_SMVolSnapMap
	SET    origCCId = 2
	WHERE  origCCId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_SMVolSnapMap -- UPDATE -- origCCId to 2'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CCM_MAP_SMVolSnapMap
	SELECT SMVolSnapMapId, 0, SMVolumeId, 0, SMSnapId, 0, MetaDataId, 0, origCCId, 0, GUID, 0
FROM CommServ_Merge..CCM_SMVolSnapMap
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMVolSnapMap -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMVolSnapMap SET new_origCCId = b.new_id
	FROM CCM_MAP_SMVolSnapMap a, CCM_MAP_Commcell b
	WHERE a.old_origCCId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMVolSnapMap -- UPDATE -- new_origCCId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMVolSnapMap SET new_SMVolumeId = b.new_id
	FROM CCM_MAP_SMVolSnapMap a, CCM_MAP_SMVolume b
	WHERE a.old_SMVolumeId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMVolSnapMap -- UPDATE -- new_SMVolumeId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMVolSnapMap SET new_SMSnapId = b.new_id
	FROM CCM_MAP_SMVolSnapMap a, CCM_MAP_SMSnap b
	WHERE a.old_SMSnapId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMVolSnapMap -- UPDATE -- new_SMSnapId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMVolSnapMap SET new_MetaDataId = b.new_id
	FROM CCM_MAP_SMVolSnapMap a, CCM_MAP_SMMetaData b
	WHERE a.old_MetaDataId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMVolSnapMap -- UPDATE -- new_MetaDataId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMVolSnapMap SET new_id = b.SMVolSnapMapId, exist = 1
	FROM CCM_MAP_SMVolSnapMap a, SMVolSnapMap b
	WHERE a.GUID = b.GUID
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMVolSnapMap -- UPDATE -- exist'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS(	SELECT * FROM CCM_MAP_SMVolSnapMap
				WHERE (	new_origCCId = 0 OR
						new_SMVolumeId = 0 OR
						new_SMSnapId = 0 AND old_SMSnapId > 0 OR
						new_MetaDataId = 0 AND old_MetaDataId > 0 )
				AND exist = 0 )
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMVolSnapMap -- unknown new ids (new_origCCId, new_SMVolumeId, new_SMSnapId, new_MetaDataId)'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO SMVolSnapMap
	SELECT b.new_SMVolumeId, b.new_SMSnapId, b.new_MetaDataId, a.GroupId, a.PruneFlags, b.new_origCCId, a.GUID, a.ReserveField1, a.ReserveField2,
	       a.ReserveFieldStr
FROM CommServ_Merge..CCM_SMVolSnapMap a, CCM_MAP_SMVolSnapMap b
	WHERE a.GUID = b.GUID
	  AND a.SMVolSnapMapId = b.old_id
	  AND b.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- SMVolSnapMap -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SMVolSnapMap SET new_id = b.SMVolSnapMapId
	FROM CCM_MAP_SMVolSnapMap a, SMVolSnapMap b
	WHERE a.GUID = b.GUID
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMVolSnapMap -- UPDATE new_id'
		GOTO CX_ERROR_EXIT
	END
	IF EXISTS(SELECT * FROM CCM_MAP_SMVolSnapMap WHERE new_id = 0)
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Snap -- CCM_MAP_SMVolSnapMap -- unknown new ids'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
	---------------------------------------------------------
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_Snap')
	delete from GxQscripts where name = 'CCM_Merge_Snap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Snap')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Snap'
GO

insert into GXDBVersions values(2, 'CCM_Merge_Snap',  '00010014020000010000', 'CCM_Merge_Snap', '00010014020000010000')
GO

