

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_Security_from_XML.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge Security. (Users, User Groups and Name Servers |
--	| Author          : Gokul Pattabiraman									 |
--  +========================================================================+
-- $Id: CCM_Merge_Security_from_XML.sp,v 1.4.190.4 2020/12/24 10:57:22 jswaminathan Exp $
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CCM_Merge_Security_from_XML')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Merge_Security_from_XML <<<'
	drop procedure CCM_Merge_Security_from_XML
END
IF EXISTS (select * from GxQscripts where name='CCM_Merge_Security_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_Security_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Security_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Security_from_XML'
GO
print '... Creating Procedure: CCM_Merge_Security_from_XML'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CCM_Merge_Security_from_XML
  @bfailIfExists INT,
  @bForceOverWrite INT,
  @bDeleteIfExists INT,
  @bDeleteIfExistsOnlyFromSource INT,
  @i_jobId INT
AS
  DECLARE @errCode INTEGER
  DECLARE @errStr varchar(1024)
SET NOCOUNT ON
	SET @errStr = 'ERROR: GENERAL ERROR!'
	BEGIN TRANSACTION CCMMERGESECURITY
	----------------------------------------------------------
--Code below here is from CCM_Merge_Security.spb
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_CommCell')
		DROP TABLE CCM_MAP_CommCell
		CREATE TABLE CCM_MAP_CommCell (
			old_id int,
			new_id int,
			number int,
			aliasName nvarchar(512),
			type tinyint,
			csGUID nvarchar(40),
			exist int
			)
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_UMDSProviders')
	DROP TABLE CCM_MAP_UMDSProviders
		CREATE TABLE CCM_MAP_UMDSProviders (
			old_providerId int,
			new_providerId int,
			old_providerName varchar(255),
			new_providerName varchar(255),
			netBIOSName		 varchar(255),
			old_origCCId int,
			new_origCCId int,
			Guid	varchar(40),
			old_ownerId		int,
			new_ownerId		int,
			exist		 int
			)
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_UMDSgroups')
	DROP TABLE CCM_MAP_UMDSgroups
		CREATE TABLE CCM_MAP_UMDSgroups (
			old_groupId int,
			new_groupId int,
			old_providerId int,
			new_providerId int,
			name   varchar(255),
			email  varchar(255),
			exist int
			)
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_UMGroups')
	DROP TABLE CCM_MAP_UMGroups
		CREATE TABLE CCM_MAP_UMGroups (
			old_groupId int,
			new_groupId int,
			old_groupName varchar(255),
			new_groupName varchar(255),
			old_origCCId int,
			new_origCCId int,
			old_providerId int,
			new_providerId int,
			Guid	varchar(40),
			exist		 int,
			isSystemCreated int
			)
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_UMUsers')
	DROP TABLE CCM_MAP_UMUsers
		CREATE TABLE CCM_MAP_UMUsers (
			old_userId int,
			new_userId int,
			old_login varchar(255),
			new_login varchar(255),
			old_origCCId int,
			new_origCCId int,
			Guid	varchar(40),
			exist		 int
			)
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_UMRoles')
	DROP TABLE CCM_MAP_UMRoles
	CREATE TABLE CCM_MAP_UMRoles (
			old_role_id int,
			new_role_id int,
			old_roleName varchar(255),
			new_roleName varchar(255),
			old_origCCId int,
			new_origCCId int,
			Guid varchar(40),
			exist int,
			isSystemCreated int
		)
	---------------------------------------------------------
	---------------------- Variables ------------------------
	DECLARE @bConflictsFound INT
		SET @bConflictsFound = 0
	DECLARE @release_source varchar(128)
    DECLARE @release_destination varchar(128)
SET @release_source = ISNULL((select top 1 release from #CCM_simAllGalaxyRel order by id desc),'N/A')
    SET @release_destination = ISNULL((select top 1 release from simAllGalaxyRel order by id desc),'N/A')
	---------------------------------------------------------
				-- Merge CommCell First --
	---------------------------------------------------------
	EXEC @errCode = CCM_MERGE_CommCell_from_XML @errorString = @errStr OUTPUT
	IF @@ERROR <> 0 OR @errCode <> 0 GOTO CX_ERROR_EXIT
	-- Step 1 : Merge UMDSProviders (Name Servers)
	-- CREATE MAPPR
	INSERT INTO CCM_MAP_UMDSProviders
	SELECT id, 0, hostname, ' ', domainName, origCCId, 0, GUID, ownerId, 1, 0
FROM #CCM_UMDSProviders
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMDSProviders -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Insert ID 0 -- Meaning Commcell
	INSERT INTO CCM_MAP_UMDSProviders
	values (0, 0, '', ' ', '', 2, 0, '', 1, 1, 1)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMDSProviders -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_UMDSProviders
	SET new_origCCId = MAPCC.new_id
	FROM CCM_MAP_CommCell AS MAPCC
	WHERE old_origCCId = MAPCC.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMDSProviders -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------------
	-- If same name server exists in destination commcell update new ids
	-- If NetBIOS Name is equal it is probably the same name server that exists in both CS
	UPDATE CCM_MAP_UMDSProviders
	SET new_providerId = PR.id, exist = 1
	FROM CCM_MAP_UMDSProviders AS MAPPR, UMDSProviders AS PR
	WHERE PR.domainName = MAPPR.netBIOSName
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMDSProviders -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
	ELSE
	BEGIN
		IF (SELECT COUNT(*) FROM CCM_Map_UMDSProviders WHERE exist = 1 and old_providerId <> 0) > 0
		BEGIN
			SET @bConflictsFound = 1
			IF @bfailIfExists = 1
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Security -- Conflicts found due to following Name Servers - Failing Merge'
				SELECT @errStr = @errStr + CHAR(13) + netBIOSName
				FROM CCM_MAP_UMDSProviders
				WHERE exist = 1 and old_providerId <> 0
				GOTO CX_ERROR_EXIT
			END
		END
	END
	-- Insert all new name servers
	INSERT INTO UMDSProviders
	SELECT domainName, hostName, description, login, password, trustedHostUser, trustedHostPW, flags, enabled,
		   serviceType, modified, dnsRoot, dnsRootStatus, useSecureLdap, MAPPR.new_origCCID, MPR.GUID, port, resourceId, checkTime, 1, 0
FROM CCM_MAP_UMDSProviders AS MAPPR, #CCM_UMDSProviders AS MPR
	WHERE MPR.id = MAPPR.old_providerId AND MAPPR.exist = 0 AND MAPPR.old_providerId <> 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- UMDSProviders -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Update New ids for inserted name servers
	UPDATE CCM_MAP_UMDSProviders
	SET new_providerId = PR.id
	FROM UMDSProviders AS PR, CCM_MAP_UMDSProviders AS MAPPR
	WHERE MAPPR.Guid = PR.GUID AND MAPPR.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- UMDSProviders -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
	IF @bForceOverWrite = 1
	BEGIN
		-- Update existing name servers
		UPDATE UMDSProviders
		SET domainName = MPR.domainName, hostName = MPR.hostName, description = MPR.description, trustedHostUser = MPR.trustedHostUser,
		    trustedHostPW = MPR.trustedHostPW, flags = MPR.flags, enabled = MPR.enabled, serviceType = MPR.serviceType, modified = MPR.modified,
		    dnsRoot = MPR.dnsRoot, dnsRootStatus = MPR.dnsRootStatus, useSecureLdap = MPR.useSecureLdap, port = MPR.port, origCCId = MAPPR.new_origCCId ,
		    resourceId = MPR.resourceId, checkTime = MPR.checkTime
FROM #CCM_UMDSProviders AS MPR, CCM_MAP_UMDSProviders AS MAPPR, UMDSProviders AS PR
		WHERE MAPPR.exist = 1 AND MAPPR.old_providerId = MPR.id AND MAPPR.new_providerId = PR.id
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Security -- UMDSProviders -- UPDATE'
			GOTO CX_ERROR_EXIT
		END
	END
	-- Step 3 : Merge Groups
	-- Create MAPGRP
	INSERT	INTO CCM_MAP_UMGroups
	SELECT	id, 0, name, '', origCCId,0, umdsProviderId, MAPPR.new_providerId,MAPUGR.Guid, 0, 0
FROM #CCM_UMGroups  MAPUGR, CCM_MAP_UMDSProviders MAPPR
	where MAPUGR.umdsProviderId = MAPPR.old_providerId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMGroups -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_UMGroups
	SET new_origCCId = MAPCC.new_id
	FROM CCM_MAP_CommCell AS MAPCC
	WHERE old_origCCId = MAPCC.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMGroups -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
	-- First Handle special groups
	UPDATE CCM_MAP_UMGroups
	SET new_groupId = GRP.id, exist = 1
	FROM CCM_MAP_UMGroups AS MAPGRP, UMGroups AS GRP
	WHERE MAPGRP.old_groupName IN ('master','CV_Restricted_Visibility','View All','Common Outlook Add-Ins') AND MAPGRP.old_groupName = GRP.name and GRP.umdsproviderId=0
	-- Rule based user groups like All Tenant Admins, All Tenant Users, etc. Match and merge them based on respective flags, and copy membership accordingly.
	-- Do not create a new user group.
	UPDATE MAPGRP
	SET
		new_groupId = DestGroup.id,
		new_groupName = DestGroup.name,
		exist = 1,
		isSystemCreated = 1
	FROM CCM_MAP_UMGroups AS MAPGRP
INNER JOIN #CCM_UMGroups SrcGroup
ON (MAPGRP.old_groupId = SrcGroup.id) AND ((SrcGroup.groupFlags & (CAST(0x0100 AS INT))) <> 0) AND (SrcGroup.umdsProviderID = 0)
		INNER JOIN UMGroups AS DestGroup
			ON (DestGroup.groupFlags = SrcGroup.groupFlags) AND (DestGroup.umdsProviderId = 0)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMGroups -- UPDATE new_groupId'
		GOTO CX_ERROR_EXIT
	END
	-- If same group exists in Destination CommCell then set new_ids
	UPDATE CCM_MAP_UMGroups
	SET new_groupId = GRP.id, exist = 1
	FROM CCM_MAP_UMGroups AS MAPGRP, UMGroups AS GRP
	WHERE MAPGRP.Guid = GRP.Guid  and MAPGRP.new_providerId = GRP.umdsProviderId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMGroups -- UPDATE new_groupId'
		GOTO CX_ERROR_EXIT
	END
	ELSE
	BEGIN
		IF (SELECT COUNT(*) FROM CCM_Map_UMGroups WHERE exist = 1
			AND (old_groupName NOT IN ('master','CV_Restricted_Visibility','View All','Common Outlook Add-Ins'))
			AND (isSystemCreated = 0))> 0
		BEGIN
			SET @bConflictsFound = 1
			IF @bfailIfExists = 1
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Security -- Conflicts found due to following user groups - Failing Merge'
				SELECT @errStr = @errStr + CHAR(13) + old_groupName
				FROM CCM_Map_UMGroups
				WHERE exist = 1
				AND old_groupName NOT IN ('master','CV_Restricted_Visibility','View All','Common Outlook Add-Ins')
				AND (isSystemCreated = 0)
				GOTO CX_ERROR_EXIT
			END
		END
	END
	-- Check for name Conflicts
	UPDATE CCM_MAP_UMGroups
	SET new_groupName = old_groupName + '$' + MAPCC.aliasName
	FROM CCM_MAP_UMGroups AS MAPGRP, UMGroups AS GRP, CCM_MAP_CommCell AS MAPCC
	WHERE MAPGRP.old_groupName = GRP.name AND MAPGRP.Guid <> GRP.Guid AND MAPGRP.old_origccid = MAPCC.old_id
	AND GRP.name NOT IN ('master','CV_Restricted_Visibility','View All','Common Outlook Add-Ins')
	AND (isSystemCreated = 0)
	AND  MAPGRP.new_providerId = GRP.umdsProviderId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMGroups -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
	-- Check if still there is a conflict
	UPDATE CCM_MAP_UMGroups
	SET new_groupName = CONVERT(nvarchar(128),CURRENT_TIMESTAMP) + new_groupName
	FROM CCM_MAP_UMGroups AS MAPGRP, UMGroups AS GRP
	WHERE MAPGRP.new_groupName = GRP.name AND MAPGRP.Guid <> GRP.Guid
	AND GRP.name NOT IN ('master','CV_Restricted_Visibility','View All','Common Outlook Add-Ins')
	AND (isSystemCreated = 0)
	AND  MAPGRP.new_providerId = GRP.umdsProviderId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMGroups -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
	-- Insert all new groups
	INSERT INTO UMGroups (groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, origCCId, GUID,umdsProviderId)
	SELECT	groupFlags, allCapabilities, allAssociations, selfAssociation,
			(CASE  MAPGRP.new_groupName
			 WHEN '' THEN MAPGRP.old_groupName
			 ELSE MAPGRP.new_groupName END),description, MAPGRP.new_origCCId, MGRP.GUID ,MAPGRP.new_providerId
FROM #CCM_UMGroups AS MGRP, CCM_MAP_UMGroups AS MAPGRP
	WHERE MAPGRP.old_groupId = MGRP.id AND MAPGRP.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- UMGroups -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Get New GroupIds for inserted groups
	UPDATE CCM_MAP_UMGroups
	SET new_groupId = GRP.id
	FROM CCM_MAP_UMGroups AS MAPGRP, UMGroups AS GRP
	WHERE MAPGRP.Guid = GRP.GUID AND MAPGRP.exist = 0
	AND  MAPGRP.new_providerId = GRP.umdsProviderId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMGroups -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
	-- Step 4 : Merge Group Capability with new GroupId
	-- AND Step 5: Merge UMDSGroupMaps with new UMGroupId and new UMDSGroupId
	IF @bForceOverWrite = 1
	BEGIN
		-- Update existing user groups
		UPDATE UMGroups
		SET groupFlags = MGRP.groupFlags , allCapabilities = MGRP.allCapabilities, allAssociations = MGRP.allAssociations,
		    selfAssociation = MGRP.selfAssociation,
		    name = (CASE  MAPGRP.new_groupName
					WHEN '' THEN MAPGRP.old_groupName
					ELSE MAPGRP.new_groupName END),
			description = MGRP.description
FROM CCM_MAP_UMGroups AS MAPGRP, UMGroups AS GRP, #CCM_UMGroups as MGRP
		WHERE MAPGRP.old_groupId = MGRP.id AND MAPGRP.exist = 1 AND MAPGRP.new_groupId = GRP.id
		and MAPGRP.new_providerId = GRP.umdsProviderId
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Security -- UMGroups -- UPDATE'
			GOTO CX_ERROR_EXIT
		END
	END
	-- Step 2 : Merge UMDSGroups
	-- Create MAPUGR
	INSERT INTO CCM_MAP_UMDSgroups
	SELECT id, 0, umdsProviderId, MAPPR.new_providerId,  name, email, 0
FROM #CCM_UMDSGroups MAPUGR, CCM_MAP_UMDSProviders MAPPR
	where MAPUGR.umdsProviderId = MAPPR.old_providerId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_Map_UMDSgroups -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Get new ids in map -
	UPDATE CCM_Map_UMDSgroups
	SET new_groupId = UGR.id, exist = 1
	FROM UMDSgroups AS UGR, CCM_MAP_UMDSgroups AS MAPUGR
	WHERE UGR.name = MAPUGR.name and MAPUGR.new_providerId = UGR.umdsProviderId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- UMDSgroups -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Insert only new UMDSGroups
	INSERT INTO UMDSgroups
	SELECT UMG.new_groupId, MAPPR.new_providerId , MGR.enabled, MGR.name, MGR.description, MGR.email, MGR.lastCredSetTime, MGR.oldId
FROM CCM_MAP_UMDSProviders AS MAPPR, #CCM_UMDSGroups AS MGR, CCM_Map_UMDSgroups as MAPUGR, CCM_MAP_UMGroups as UMG
	WHERE MAPPR.old_providerId = MGR.umdsProviderId AND MAPUGR.old_groupId = MGR.id AND MAPUGR.exist = 0 AND UMG.old_groupId = MGR.id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- UMDSgroups -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Get new ids in map - -group name and email will be unique
	UPDATE CCM_Map_UMDSgroups
	SET new_groupId = UGR.id
	FROM UMDSgroups AS UGR, CCM_MAP_UMDSgroups AS MAPUGR
	WHERE UGR.name = MAPUGR.name AND UGR.umdsProviderId = MAPUGR.new_providerId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- UMDSgroups -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	IF @bForceOverWrite = 1
	BEGIN
		-- Update existing user groups
		UPDATE UMDSGroups
		SET enabled = MGRP.enabled,
			description = MGRP.description,
			email = MGRP.email
FROM CCM_MAP_UMDSGroups AS MAPGRP, UMDSGroups AS GRP, #CCM_UMDSGroups as MGRP
		WHERE MAPGRP.old_groupId = MGRP.id AND MAPGRP.exist = 1 AND MAPGRP.new_groupId = GRP.id
		and MAPGRP.new_providerId = GRP.umdsProviderId
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Security -- UMGroups -- UPDATE'
			GOTO CX_ERROR_EXIT
		END
	END
	-- Step 4 : Merge Group Capability with new GroupId
	-- AND Step 5: Merge UMDSGroupMaps with new UMGroupId and new UMDSGroupId
	INSERT INTO UMDSGroupMaps
		SELECT MAPUGR.new_groupId , MAPGRP.new_groupId , MGM.flag
FROM #CCM_UMDSGroupMaps AS MGM
		INNER JOIN CCM_MAP_UMDSgroups AS MAPUGR ON MGM.umDSgroupId = MAPUGR.old_groupId
		INNER JOIN CCM_MAP_UMGroups AS MAPGRP ON MGM.umgroupId = MAPGRP.old_groupId
		LEFT JOIN UMDSGroupMaps UGM ON UGM.umdsgroupid = MAPUGR.new_groupId AND UGM.umgroupid = MAPGRP.new_groupId
		WHERE UGM.umdsgroupId IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- UMDSGroupMaps -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Step 6 : Merge Users  with new GroupId
	-- @TODO For now it is assumed no conflicts.
	DECLARE @old_adminUserId int = 0
	DECLARE @new_adminUserId int = 0
SET @old_adminUserId = isnull((SELECT top 1  id from #CCM_UMUsers WHERE flags & 0x040 > 0),0)
SET @new_adminUserId = isnull((SELECT top 1  id from CommServ..UMUsers WHERE flags & 0x040 > 0),0)
	--do not import systemcreated users
DELETE FROM #CCM_UMUsers WHERE (flags & 0x002) > 0  AND  (flags & 0x040) = 0
	-- Create MAPUSR
	INSERT INTO CCM_MAP_UMUsers
	SELECT id, 0, login, '', origCCId, 0, userGuid, 0
FROM #CCM_UMUsers WHERE flags & 0x040 = 0
AND NOT(name in ('master','View All') AND flags & 0x800 > 0)
	--No need to merge admin user, we bring admin user only to map id's in other tables to local admin user id
	--Do not merge the create as user created for the default groups
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMUsers -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- If same user exists in Destination CommCell then set new_ids
	UPDATE CCM_MAP_UMUsers
	SET new_userId = id, exist = 1, new_origCCId = MAPCC.new_id
	FROM CCM_MAP_UMUsers AS MAPUSR, UMUsers AS USR, CCM_MAP_CommCell as MAPCC
	WHERE MAPUSR.Guid = USR.userGuid AND USR.login NOT LIKE '%(Deleted%' AND old_origCCId = MAPCC.old_id
	-- Create-as users of system created user groups. Match them with their counter-parts.
	UPDATE MapUsers
	SET
		new_userId = DestUsers.id,
		new_login = DestUsers.login,
		exist = 1,
		new_origCCId = MAPCC.new_id
	FROM CCM_MAP_UMGroups MapGroups
		INNER JOIN CCM_MAP_UMUsers MapUsers
			ON (MapGroups.isSystemCreated = 1) AND (MapGroups.old_groupName = MapUsers.old_login)
INNER JOIN #CCM_UMUsers SrcUsers
ON (MapUsers.old_userId = SrcUsers.id) AND ((SrcUsers.flags & 0x800) <> 0)
		INNER JOIN UMUsers DestUsers
ON (MapGroups.new_groupName = DestUsers.login) AND ((DestUsers.flags & 0x800) <> 0)
		INNER JOIN CCM_MAP_CommCell as MAPCC
			ON (MapUsers.old_origCCId = MAPCC.old_id)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMUsers -- UPDATE new_userId'
		GOTO CX_ERROR_EXIT
	END
	ELSE
	BEGIN
		IF (SELECT COUNT(*) FROM CCM_MAP_UMUsers WHERE exist = 1) > 0
		BEGIN
			SET @bConflictsFound = 1
			IF @bfailIfExists = 1
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Security -- Conflicts Found due to following user logins - Failing Merge'
				SELECT @errStr = @errStr + CHAR(13) + old_login
				FROM CCM_Map_UMUsers
				WHERE exist = 1
				GOTO CX_ERROR_EXIT
			END
		END
	END
	UPDATE CCM_MAP_UMUsers SET new_origCCId = MAPCC.new_id FROM CCM_MAP_UMUsers AS MAPUSR, CCM_MAP_CommCell AS MAPCC
	WHERE MAPUSR.exist = 0 and old_origCCId = MAPCC.old_id
	-- Check for name Conflicts
	UPDATE CCM_MAP_UMUsers
	SET new_login = old_login + '$' + MAPCC.aliasName
	FROM CCM_MAP_UMUsers AS MAPUSR, UMUsers AS USR, CCM_MAP_CommCell AS MAPCC
	WHERE MAPUSR.old_login = USR.login AND MAPUSR.Guid <> USR.userGuid AND MAPUSR.old_origCCId = MAPCC.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMUsers -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
	-- Check if still there is a conflict
	UPDATE CCM_MAP_UMUsers
	SET new_login = CONVERT(nvarchar(128),CURRENT_TIMESTAMP) + new_login
	FROM CCM_MAP_UMUsers AS MAPUSR, UMUsers AS USR
	WHERE MAPUSR.new_login = USR.login AND MAPUSR.Guid <> USR.userGuid
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMGroups -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
	-- Insert all new users
	INSERT INTO UMUsers (name,description,login,password,email,datePasswordSet , dateExpires ,policy, enabled , flags,modified,pVer,Pager,lastLoginTime,credSetTime,umdsProviderId,userGUID,origUserGuid,origCCID,salt)
	SELECT	name, description,
			(CASE MAPUSR.new_login
			 WHEN '' THEN MAPUSR.old_login
			 ELSE MAPUSR.new_login END),
			 password, email, datePasswordSet, dateExpires, policy, enabled,
			 flags, modified, pVer, pager, lastLoginTime, credSetTime, MAPUMDS.new_providerId, userGUID, origUserGuid, MAPUSR.new_origCCID,salt
FROM #CCM_UMUsers AS MUSR, CCM_MAP_UMUsers AS MAPUSR,  CCM_MAP_UMDSProviders as MAPUMDS
	WHERE MAPUSR.old_userId = MUSR.id AND MAPUSR.exist = 0 AND MUSR.umDSproviderId = MAPUMDS.old_providerId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- UMUsers -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Get New userIDs for inserted users
	UPDATE CCM_MAP_UMUsers
	SET new_userId = USR.id
	FROM CCM_MAP_UMUsers AS MAPUSR, UMUsers AS USR
	WHERE MAPUSR.Guid = USR.userGuid AND MAPUSR.exist = 0 AND USR.login NOT LIKE '%(Deleted%'
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMUsers -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
	--Update ownerId in UMDSProviders
	UPDATE UMDSProviders
	SET ownerId = c.new_userId
	FROM UMDSProviders a INNER JOIN CCM_MAP_UMDSProviders b ON a.id = b.new_providerId AND b.exist = 0
	 INNER JOIN CCM_MAP_UMUsers c ON b.old_ownerId = c.old_userId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- UMDSProviders -- UPDATE new_ownerId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE UMDSProviders
	SET ownerCompany= d.new_providerId
	FROM UMDSProviders a
	INNER JOIN CCM_MAP_UMDSProviders b ON a.id= b.new_providerId AND b.exist = 0
INNER JOIN #CCM_UMDSProviders c ON c.id = b.old_providerId
	  INNER JOIN CCM_MAP_UMDSProviders d ON d.old_providerId = c.ownerCompany
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- UMDSProviders -- UPDATE ownerCompany'
		GOTO CX_ERROR_EXIT
	END
	-- Step 7, Step 8 ans Step 9
	-- Merge User group assoc, User preferences and UMDSUserGroup
	IF @bForceOverWrite = 1
	BEGIN
		-- Update existing Users
		UPDATE UMUsers
		SET name = MUSR.name, description = MUSR.description,
			login = (CASE MAPUSR.new_login
					 WHEN '' THEN MAPUSR.old_login
					 ELSE MAPUSR.new_login END),
			password = MUSR.password, email = MUSR.email,
		    datePasswordSet = MUSR.datePasswordSet, dateExpires = MUSR.dateExpires, policy = MUSR.policy, enabled = MUSR.enabled,
		    flags = MUSR.flags, modified = MUSR.modified, pVer = MUSR.pVer, lastLogInTime = MUSR.lastLogInTime,
		    credSetTime = MUSR.credSetTime, umDSproviderId =  MAPUMDS.new_providerId,  origCCId = MAPUSR.new_origCCId
FROM CCM_MAP_UMUsers AS MAPUSR, UMUsers AS USR , #CCM_UMUsers AS MUSR,  CCM_MAP_UMDSProviders as MAPUMDS
		WHERE MAPUSR.old_userId = MUSR.id AND MAPUSR.exist = 1 AND MAPUSR.new_userId = USR.id AND MUSR.umDSproviderId = MAPUMDS.old_providerId
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Security -- UMUsers -- UPDATE'
			GOTO CX_ERROR_EXIT
		END
		-- Delete all user preferences
		DELETE FROM UMUserPrefs
		WHERE userId IN (SELECT new_userId  FROM CCM_MAP_UMUsers)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Security -- UMUserPrefs -- DELETE'
			GOTO CX_ERROR_EXIT
		END
		-- Insert all user preferences
		INSERT INTO UMUserPrefs
		SELECT MAPUSR.new_userId , MUP.value
FROM #CCM_UMUserPrefs AS MUP, CCM_MAP_UMUsers AS MAPUSR
		WHERE MUP.userId = MAPUSR.old_userId
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Security -- UMUserPrefs -- INSERT'
			GOTO CX_ERROR_EXIT
		END
	END
	ELSE
	BEGIN
		-- Insert only new user preferences
		INSERT INTO UMUserPrefs
		SELECT MAPUSR.new_userId , MUP.value
FROM #CCM_UMUserPrefs AS MUP, CCM_MAP_UMUsers AS MAPUSR
		WHERE MUP.userId = MAPUSR.old_userId  AND MAPUSR.exist = 0
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Security -- UMUserPrefs -- INSERT'
			GOTO CX_ERROR_EXIT
		END
	END
	-- Insert new user group assocs that are not there
	INSERT INTO UMUserGroup
	SELECT MAPUSR.new_userId , MAPGRP.new_groupId , MUG.flag
FROM #CCM_UMUserGroup AS MUG
	INNER JOIN CCM_MAP_UMUsers AS MAPUSR ON MUG.userId = MAPUSR.old_userId
	INNER JOIN CCM_MAP_UMGroups AS MAPGRP ON MUG.groupId = MAPGRP.old_groupId
	LEFT JOIN UMUserGroup UUG ON UUG.userId = MAPUSR.new_userId AND UUG.groupId = MAPGRP.new_groupId
	WHERE UUG.userId IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- UMUserGroup -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Insert only new UMDSUserGroup
	INSERT INTO UMDSUserGroup
	SELECT MAPUSR.new_userId, MAPGRP.new_groupId, MUG.flag
FROM #CCM_UMDSUserGroup AS MUG
	INNER JOIN CCM_MAP_UMUsers AS MAPUSR ON MUG.userId = MAPUSR.old_userId
	INNER JOIN CCM_MAP_UMGroups AS MAPGRP ON MUG.groupId = MAPGRP.old_groupId
	LEFT JOIN UMDSUserGroup UUG ON UUG.userId = MAPUSR.new_userId AND UUG.groupId = MAPGRP.new_groupId
	WHERE UUG.userId IS NULL
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Security -- UMDSUserGroup -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	----------------------------------------------------------
	-- Merge UMRoles
	----------------------------------------------------------
	--Create MAPRL
	INSERT INTO CCM_MAP_UMRoles
	SELECT id, 0, name, ' ', commcellId, 0, GUID, 0, 0
FROM #CCM_UMRoles
	IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMRoles -- INSERT'
        GOTO CX_ERROR_EXIT
    END
	UPDATE CCM_MAP_UMRoles
    SET new_origCCId = MAPCC.new_id
    FROM CCM_MAP_CommCell AS MAPCC
    WHERE old_origCCId = MAPCC.old_id
	IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMRoles -- UPDATE'
        GOTO CX_ERROR_EXIT
    END
	--Handle special roles
	UPDATE CCM_MAP_UMRoles
    SET new_role_id = ROLE.id, exist = 1, isSystemCreated=1
    FROM CCM_MAP_UMRoles AS MAPRL INNER JOIN UMRoles AS ROLE
    ON MAPRL.old_roleName = ROLE.name
WHERE ROLE.flags & 128 = 128
	 IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMRoles -- UPDATE new_role_id'
        GOTO CX_ERROR_EXIT
    END
	-- If same role exists in Destination CommCell then set new_ids
    UPDATE CCM_MAP_UMRoles
    SET new_role_id = ROLE.id, exist = 1
    FROM CCM_MAP_UMRoles AS MAPRL, UMRoles AS ROLE
    WHERE MAPRL.Guid = ROLE.GUID
	IF  @@ERROR > 0
	BEGIN
        SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMRoles -- UPDATE new_role_id'
        GOTO CX_ERROR_EXIT
    END
	ELSE
    BEGIN
        IF (SELECT COUNT(*) FROM CCM_Map_UMRoles WHERE exist = 1
            AND isSystemCreated <> 1)> 0
        BEGIN
            SET @bConflictsFound = 1
            IF @bfailIfExists = 1
            BEGIN
                SET @errStr = 'ERROR: CCM_Merge_Security -- Conflicts found due to following roles - Failing Merge'
                SELECT @errStr = @errStr + CHAR(13) + old_roleName
                FROM CCM_Map_UMRoles
                WHERE exist = 1
                AND isSystemCreated <> 1
                GOTO CX_ERROR_EXIT
            END
        END
    END
	--Check for name conflicts
	UPDATE CCM_MAP_UMRoles
    SET new_roleName = old_roleName + '$' + MAPCC.aliasName
    FROM CCM_MAP_UMRoles AS MAPRL, UMRoles AS ROLE, CCM_MAP_CommCell AS MAPCC
    WHERE MAPRL.old_roleName = ROLE.name AND MAPRL.Guid <> ROLE.GUID AND MAPRL.old_origCCid = MAPCC.old_id
    AND MAPRL.isSystemCreated <> 1
    IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMRoles -- UPDATE'
        GOTO CX_ERROR_EXIT
    END
	-- Check if still there is a conflict
    UPDATE CCM_MAP_UMRoles
    SET new_roleName = CONVERT(nvarchar(128),CURRENT_TIMESTAMP) + new_roleName
    FROM CCM_MAP_UMRoles AS MAPRL, UMRoles AS ROLE
    WHERE MAPRL.new_roleName = ROLE.name AND MAPRL.Guid <> ROLE.GUID
    AND MAPRL.isSystemCreated <> 1
    IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMRoles -- UPDATE'
        GOTO CX_ERROR_EXIT
    END
	--insert all new roles
	INSERT INTO UMRoles(commcellId, name, description, disabled, isPrivate, flags, ownerId, created, modified, GUID, xmlProperties)
	SELECT  new_origCCId,
	        (CASE MAPRL.new_roleName
			 WHEN ' ' THEN MAPRL.old_roleName
			 ELSE MAPRL.new_roleName END), description, disabled, isPrivate, flags,
			 ISNULL((select new_userId from CCM_MAP_UMUsers where old_userId=MROLE.ownerId),@new_adminUserId),
			 created, modified, MROLE.GUID, xmlProperties
FROM #CCM_UMRoles AS MROLE, CCM_MAP_UMRoles AS MAPRL
    WHERE MAPRL.old_role_id = MROLE.id AND MAPRL.exist = 0 and MROLE.ownerId<> @old_adminUserId
	 IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Merge_Security -- UMRoles -- INSERT'
        GOTO CX_ERROR_EXIT
    END
	--insert roles of old admin
	INSERT INTO UMRoles(commcellId, name, description, disabled, isPrivate, flags, ownerId, created, modified, GUID, xmlProperties)
	SELECT  new_origCCId,
	        (CASE MAPRL.new_roleName
			 WHEN ' ' THEN MAPRL.old_roleName
			 ELSE MAPRL.new_roleName END), description, disabled, isPrivate, flags,
			 @new_adminUserId,
			 created, modified, MROLE.GUID, xmlProperties
FROM #CCM_UMRoles AS MROLE, CCM_MAP_UMRoles AS MAPRL
    WHERE MAPRL.old_role_id = MROLE.id AND MAPRL.exist = 0 and MROLE.ownerId = @old_adminUserId
	 IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Merge_Security -- UMRoles -- INSERT'
        GOTO CX_ERROR_EXIT
    END
	 -- Get New RoleIds for inserted roles
    UPDATE CCM_MAP_UMRoles
    SET new_role_id = ROLE.id
    FROM CCM_MAP_UMRoles AS MAPRL, UMRoles AS ROLE
    WHERE MAPRL.Guid = ROLE.GUID AND MAPRL.exist = 0
    IF  @@ERROR > 0
    BEGIN
        SET @errStr = 'ERROR: CCM_Merge_Security -- CCM_MAP_UMGroups -- UPDATE'
        GOTO CX_ERROR_EXIT
    END
	IF @bForceOverWrite = 1
    BEGIN
        -- Update existing user roles
        UPDATE UMRoles
        SET 	    name = (CASE  MAPRL.new_roleName
                    WHEN ' ' THEN MAPRL.old_roleName
                    ELSE MAPRL.new_roleName END),
		    description = MROLE.description, disabled = MROLE.disabled,
            isPrivate = MROLE.isPrivate, flags = MROLE.flags, ownerId = ISNULL((select new_userId from CCM_MAP_UMUsers where old_userId=MROLE.ownerId),@new_adminUserId) ,
            created = MROLE.created, modified = MROLE.modified, xmlProperties = MROLE.xmlProperties
FROM CCM_MAP_UMRoles AS MAPRL, UMRoles AS ROLE, #CCM_UMRoles as MROLE
        WHERE MAPRL.old_role_id = MROLE.id AND ROLE.id = MAPRL.new_role_id AND MAPRL.exist = 1  and MROLE.ownerId <>@old_adminUserId
        IF  @@ERROR > 0
        BEGIN
            SET @errStr = 'ERROR: CCM_Merge_Security -- UMRoles -- UPDATE'
            GOTO CX_ERROR_EXIT
        END
		-- Update existing user roles of old admin
		 UPDATE UMRoles
        SET			name = (CASE  MAPRL.new_roleName
                    WHEN ' ' THEN MAPRL.old_roleName
                    ELSE MAPRL.new_roleName END),
		    description = MROLE.description, disabled = MROLE.disabled,
            isPrivate = MROLE.isPrivate, flags = MROLE.flags, ownerId =@new_adminUserId ,
            created = MROLE.created, modified = MROLE.modified, xmlProperties = MROLE.xmlProperties
FROM CCM_MAP_UMRoles AS MAPRL, UMRoles AS ROLE, #CCM_UMRoles as MROLE
        WHERE MAPRL.old_role_id = MROLE.id AND ROLE.id = MAPRL.new_role_id AND MAPRL.exist = 1  and MROLE.ownerId = @old_adminUserId
        IF  @@ERROR > 0
        BEGIN
            SET @errStr = 'ERROR: CCM_Merge_Security -- UMRoles -- UPDATE'
            GOTO CX_ERROR_EXIT
        END
	END
	----------------------------------------------------------
	-- Merge UMRolesPermissions
	----------------------------------------------------------
	--insert permissions of newly added roles
	-- if force overwrite , remove the rolepermissions from db and add new rolepermissions
	IF @bForceOverWrite = 1
	BEGIN
		DELETE FROM UMRolesPermissions
		WHERE roleId IN (SELECT new_role_id FROM CCM_MAP_UMRoles)
	     IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Security -- UMRolesPermissions -- DELETE'
				GOTO CX_ERROR_EXIT
			END
		INSERT INTO UMRolesPermissions(roleId,hierarchyLevel,categoryId,permissionId,excludeCategory,excludePermission)
		SELECT new_role_id, hierarchyLevel,categoryId,permissionId,excludeCategory,excludePermission
FROM #CCM_UMRolesPermissions INNER JOIN CCM_MAP_UMROLES
ON #CCM_UMRolesPermissions.roleId = CCM_MAP_UMROLES.old_role_id
	     WHERE new_role_id <> 0 AND
				permissionId IN (SELECT id FROM UMPermissions) AND
			   categoryId IN (SELECT id from UMCategories)
		 IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Security -- UMRolesPermissions -- INSERT'
				GOTO CX_ERROR_EXIT
			END
	END
	ELSE
	BEGIN
		INSERT INTO UMRolesPermissions(roleId,hierarchyLevel,categoryId,permissionId,excludeCategory,excludePermission)
		SELECT new_role_id, hierarchyLevel,categoryId,permissionId,excludeCategory,excludePermission
FROM #CCM_UMRolesPermissions INNER JOIN CCM_MAP_UMROLES
ON #CCM_UMRolesPermissions.roleId = CCM_MAP_UMROLES.old_role_id
		WHERE exist=0 AND new_role_id <> 0 AND
			  permissionId IN (SELECT id FROM UMPermissions) AND
		      categoryId IN (SELECT id from UMCategories)
	 IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Security -- UMRolesPermissions -- INSERT'
				GOTO CX_ERROR_EXIT
			END
	END
	----------------------------------------------------------
	-- Merge UMRolesWithPermissionsExpanded
	----------------------------------------------------------
	-- if force overwrite , remove the rolepermissions from db and add new rolepermissions
	IF @bForceOverWrite = 1
	BEGIN
		DELETE FROM UMRolesWithPermissionsExpanded
		WHERE roleId IN (SELECT new_role_id FROM CCM_MAP_UMRoles)
		 IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Security -- UMRolesWithPermissionsExpanded -- DELETE'
				GOTO CX_ERROR_EXIT
			END
		INSERT INTO UMRolesWithPermissionsExpanded(roleId,categoryId,permissionId)
		SELECT new_role_id, categoryId, permissionId
FROM CCM_MAP_UMROLES INNER JOIN #CCM_UMRolesWithPermissionsExpanded
ON #CCM_UMRolesWithPermissionsExpanded.roleId = CCM_MAP_UMROLES.old_role_id
		WHERE new_role_id <> 0 AND
			  permissionId IN (SELECT id FROM UMPermissions) AND
		      categoryId IN (SELECT id from UMCategories)
		 IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Security -- UMRolesWithPermissionsExpanded -- INSERT'
				GOTO CX_ERROR_EXIT
			END
	END
	ELSE
	BEGIN
			--insert only for newly added roles
			INSERT INTO UMRolesWithPermissionsExpanded(roleId,categoryId,permissionId)
			SELECT new_role_id, categoryId, permissionId
FROM CCM_MAP_UMROLES INNER JOIN #CCM_UMRolesWithPermissionsExpanded
ON #CCM_UMRolesWithPermissionsExpanded.roleId = CCM_MAP_UMROLES.old_role_id
			WHERE exist = 0 AND new_role_id <> 0 AND
			  permissionId IN (SELECT id FROM UMPermissions) AND
			  categoryId IN (SELECT id from UMCategories)
			 IF	@@ERROR > 0
					BEGIN
						SET @errStr = 'ERROR: CCM_Merge_Security -- UMRolesWithPermissionsExpanded -- INSERT'
						GOTO CX_ERROR_EXIT
					END
	END
	----------------------------------------------------------
		-- Merge Synchronization / Delete Option --
	----------------------------------------------------------
	IF @bDeleteIfExists <> 0
	BEGIN
		DECLARE @tempUMDSTbl TABLE (netBIOSName varchar(255))
		DECLARE @tempGUIDTbl TABLE (GUID	varchar(40))
		IF @bDeleteIfExistsOnlyFromSource <> 0
		BEGIN
			INSERT INTO @tempUMDSTbl
			SELECT UMDS.domainName
			FROM UMDSProviders AS UMDS
			WHERE UMDS.domainName NOT IN (SELECT netBIOSName FROM CCM_MAP_UMDSProviders)
			AND UMDS.origCCId IN (SELECT new_origCCId FROM CCM_MAP_UMDSProviders)
			AND UMDS.domainName NOT IN('CTE Provider','Commcell')
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Security -- tempUMDSTbl -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			INSERT INTO @tempGUIDTbl
			SELECT GUID
			FROM UMGroups AS GRP
			WHERE GRP.GUID NOT IN (SELECT GUID FROM CCM_MAP_UMGroups)
			AND GRP.origCCID IN (SELECT new_origCCId FROM CCM_MAP_UMGroups)
			AND GRP.name NOT IN ('master','CV_Restricted_Visibility','View All','Common Outlook Add-Ins')
AND ((GRP.groupFlags & CAST(0x0100 AS INT)) = 0)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Security -- tempGUIDTbl -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			INSERT INTO @tempGUIDTbl
			SELECT userGuid
			FROM UMUSers AS USR
			WHERE USR.userGuid NOT IN (SELECT GUID FROM CCM_MAP_UMUsers)
			AND USR.origCCID IN (SELECT new_origCCId FROM CCM_MAP_UMUsers)
			AND USR.name <> 'Default Outlook User' AND USR.id > 0
			AND NOT EXISTS (SELECT * FROM TM_Task WHERE taskType IN (2,3,4) AND ownerId  = USR.id) -- Do not remove user if he owns any schedule or report
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Security -- tempGUIDTbl -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			INSERT INTO @tempGUIDTbl
            SELECT GUID
            FROM UMRoles AS ROLE
            WHERE ROLE.GUID NOT IN (SELECT Guid FROM CCM_MAP_UMRoles)
            AND ROLE.commcellId IN (SELECT new_origCCId FROM CCM_MAP_UMRoles)
AND ROLE.flags & 128 = 0
			IF  @@ERROR > 0
            BEGIN
                SET @errStr = 'ERROR: CCM_Merge_Security -- tempGUIDTbl -- INSERT'
                GOTO CX_ERROR_EXIT
            END
		END
		ELSE
		BEGIN
			INSERT INTO @tempUMDSTbl
			SELECT UMDS.domainName
			FROM UMDSProviders AS UMDS
			WHERE UMDS.domainName NOT IN (SELECT netBIOSName FROM CCM_MAP_UMDSProviders)
			AND UMDS.domainName NOT IN('CTE Provider','Commcell')
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Security -- tempUMDSTbl -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			INSERT INTO @tempGUIDTbl
			SELECT GUID
			FROM UMGroups AS GRP
			WHERE GRP.GUID NOT IN (SELECT GUID FROM CCM_MAP_UMGroups)
			AND GRP.name NOT IN ('master','CV_Restricted_Visibility','View All','Common Outlook Add-Ins')
AND ((GRP.groupFlags & CAST(0x0100 AS INT)) = 0)
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Security -- tempGUIDTbl -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			INSERT INTO @tempGUIDTbl
			SELECT userGUID
			FROM UMUSers AS USR
			WHERE USR.userGUID NOT IN (SELECT GUID FROM CCM_MAP_UMUsers)
			AND USR.name <> 'Default Outlook User'  AND USR.id > 0
			AND NOT EXISTS (SELECT * FROM TM_Task WHERE taskType IN (2,3,4) AND ownerId  = USR.id) -- Do not remove user if he owns any schedule or report
			IF	@@ERROR > 0
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_Security -- tempGUIDTbl -- INSERT'
				GOTO CX_ERROR_EXIT
			END
	        INSERT INTO @tempGUIDTbl
            SELECT GUID
            FROM UMRoles AS ROLE
            WHERE ROLE.GUID NOT IN (SELECT Guid FROM CCM_MAP_UMRoles)
AND ROLE.flags & 128 = 0
			IF  @@ERROR > 0
            BEGIN
                SET @errStr = 'ERROR: CCM_Merge_Security -- tempGUIDTbl -- INSERT'
                GOTO CX_ERROR_EXIT
            END
		END
		-------------------------------------------------------------------------------------------
		-- delete from umsecurityassociaitons
		--provider level users
		DELETE USA
		FROM UMSecurityAssociations USA
		INNER JOIN UMUsers USERS ON USA.isUser = 1 AND USA.userOrGroupId = USERS.id
		INNER JOIN UMDSProviders PROVIDERS ON USERS.umdsProviderId = PROVIDERS.id
		INNER JOIN @tempUMDSTbl UMDS ON UMDS.netBIOSName = PROVIDERS.domainName
		--provider level groups
		DELETE USA
		FROM UMSecurityAssociations USA
		INNER JOIN UMGroups GROUPS ON USA.isUser = 0 AND USA.userOrGroupId = GROUPS.id
		INNER JOIN UMDSProviders PROVIDERS ON GROUPS.umdsProviderId = PROVIDERS.id
		INNER JOIN @tempUMDSTbl UMDS ON UMDS.netBIOSName = PROVIDERS.domainName
		--users
		DELETE USA
		FROM UMSecurityAssociations USA
		INNER JOIN UMUsers USERS ON USA.isUser = 1 AND USA.userOrGroupId = USERS.id
		INNER JOIN @tempGUIDTbl TGUID ON TGUID.GUID = USERS.userGuid
		--groups
		DELETE USA
		FROM UMSecurityAssociations USA
		INNER JOIN UMGroups GROUPS ON USA.isUser = 0 AND USA.userOrGroupId = GROUPS.id
		INNER JOIN @tempGUIDTbl TGUID ON TGUID.GUID = GROUPS.Guid
		--------------------------------------------------------------------------------------------
		--delete ownership entries from umowner
		--provider level users
		DELETE OWNERS
		FROM UMOwners OWNERS
		INNER JOIN UMUsers USERS ON OWNERS.isUser = 1 AND OWNERS.userOrGroupId = USERS.id
		INNER JOIN UMDSProviders PROVIDERS ON USERS.umdsProviderId = PROVIDERS.id
		INNER JOIN @tempUMDSTbl UMDS ON UMDS.netBIOSName = PROVIDERS.domainName
		--provider level groups
		DELETE OWNERS
		FROM UMOwners OWNERS
		INNER JOIN UMGroups GROUPS ON OWNERS.isUser = 0 AND OWNERS.userOrGroupId = GROUPS.id
		INNER JOIN UMDSProviders PROVIDERS ON GROUPS.umdsProviderId = PROVIDERS.id
		INNER JOIN @tempUMDSTbl UMDS ON UMDS.netBIOSName = PROVIDERS.domainName
		--users
		DELETE OWNERS
		FROM UMOwners OWNERS
		INNER JOIN UMUsers USERS ON OWNERS.isUser = 1 AND OWNERS.userOrGroupId = USERS.id
		INNER JOIN @tempGUIDTbl TGUID ON TGUID.GUID = USERS.userGuid
		--groups
		DELETE OWNERS
		FROM UMOwners OWNERS
		INNER JOIN UMGroups GROUPS ON OWNERS.isUser = 0 AND OWNERS.userOrGroupId = GROUPS.id
		INNER JOIN @tempGUIDTbl TGUID ON TGUID.GUID = GROUPS.Guid
		---------------------------------------------------------------------------------------------
		-- Delete the Users in Name server first
		UPDATE UMUsers
		SET login = login + '(Deleted,' + CAST(id as varchar(8)) +')',
			enabled = 0, flags = 0, umDSproviderId = -1
		WHERE UMUsers.umDSproviderId IN (SELECT id FROM UMDSProviders
										 WHERE UMDSProviders.domainName IN
											(SELECT netBIOSName FROM @tempUMDSTbl))
		AND UMUsers.id <> 1
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Security -- UMUsers for name servers -- DELETE'
			GOTO CX_ERROR_EXIT
		END
		DELETE FROM UMDSProviders
		WHERE UMDSProviders.domainName IN (SELECT netBIOSName FROM @tempUMDSTbl)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Security -- UMDSProviders -- DELETE'
			GOTO CX_ERROR_EXIT
		END
		DELETE FROM UMGroupCapability
		WHERE UMGroupCapability.groupId IN (SELECT id from UMGroups
											WHERE UMGroups.GUID IN (SELECT GUID FROM @tempGUIDTbl))
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Security -- UMGroupCapability -- DELETE'
			GOTO CX_ERROR_EXIT
		END
		DELETE FROM UMUserGroup
		WHERE UMUserGroup.groupId IN (SELECT id from UMGroups
											WHERE UMGroups.GUID IN (SELECT GUID FROM @tempGUIDTbl))
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Security -- UMUserGroup -- DELETE'
			GOTO CX_ERROR_EXIT
		END
		DELETE FROM NTnotificationGroups
		WHERE groupId IN (SELECT id from UMGroups
							WHERE UMGroups.GUID IN (SELECT GUID FROM @tempGUIDTbl))
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Security -- NTnotificationGroups -- DELETE'
			GOTO CX_ERROR_EXIT
		END
		DELETE FROM UMGroupAssociation
		WHERE groupId IN (SELECT id from UMGroups
							WHERE UMGroups.GUID IN (SELECT GUID FROM @tempGUIDTbl))
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Security -- UMGroupAssociation -- DELETE'
			GOTO CX_ERROR_EXIT
		END
		DELETE FROM UMGroups
		WHERE UMGroups.GUID IN (SELECT GUID FROM @tempGUIDTbl)
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Security -- UMGroups -- DELETE'
			GOTO CX_ERROR_EXIT
		END
		UPDATE UMUsers
		SET login = login + '(Deleted,' + CAST(id as varchar(8)) +')',
			email = 'Email Disabled', password = 'Password Disabled', enabled = 0, flags = 0
		WHERE UMUsers.userGuid IN (SELECT GUID FROM @tempGUIDTbl) AND UMUsers.id <> 1
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Security -- UMUsers -- DELETE'
			GOTO CX_ERROR_EXIT
		END
		DELETE from UMSecurityAssociations
		WHERE roleId in (select id from UMRoles where GUID in(SELECT GUID FROM @tempGUIDTbl))
		DELETE from UMRolesPermissions
		WHERE roleId in (select id from UMRoles where GUID in(SELECT GUID FROM @tempGUIDTbl))
		DELETE from UMOwnerRoles
		WHERE roleId in (select id from UMRoles where GUID in(SELECT GUID FROM @tempGUIDTbl))
		DELETE from UMRolesWithPermissionsExpanded
		WHERE roleId in (select id from UMRoles where GUID in(SELECT GUID FROM @tempGUIDTbl))
		DELETE FROM UMRoles
        WHERE UMRoles.GUID IN (SELECT GUID FROM @tempGUIDTbl)
        IF  @@ERROR > 0
        BEGIN
            SET @errStr = 'ERROR: CCM_Merge_Security -- UMRoles -- DELETE'
            GOTO CX_ERROR_EXIT
        END
	END
	---------------------------------------------------------
    DECLARE @l_curImportJobId Integer
    SET @l_curImportJobId =  ISNULL
    (
        (
            @i_jobId
        ), 0
    )
	SET @errStr = 'NO_ERROR'
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_UMDSProviders')
	DROP TABLE CCM_MAP_UMDSProviders
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_UMDSgroups')
	DROP TABLE CCM_MAP_UMDSgroups
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_UMGroups')
	DROP TABLE CCM_MAP_UMGroups
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_UMUsers')
	DROP TABLE CCM_MAP_UMUsers
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_CommCell')
	DROP TABLE CCM_MAP_CommCell
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_UMRoles')
	DROP TABLE CCM_MAP_UMRoles
	----------------------------------------------------------
	COMMIT	TRANSACTION CCMMERGESECURITY
	SELECT 0, @errStr
	RETURN (0)
CX_ERROR_EXIT:
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_UMDSProviders')
	DROP TABLE CCM_MAP_UMDSProviders
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_UMDSgroups')
	DROP TABLE CCM_MAP_UMDSgroups
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_UMGroups')
	DROP TABLE CCM_MAP_UMGroups
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_UMUsers')
	DROP TABLE CCM_MAP_UMUsers
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_CommCell')
	DROP TABLE CCM_MAP_CommCell
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_UMRoles')
	DROP TABLE CCM_MAP_UMRoles
	ROLLBACK TRANSACTION CCMMERGESECURITY
	SELECT -1, @errStr
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_Security_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_Security_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Security_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Security_from_XML'
GO

insert into GXDBVersions values(2, 'CCM_Merge_Security_from_XML',  '00010004019000040000', 'CCM_Merge_Security_from_XML', '00010004019000040000')
GO

