

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_Schedule.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge schedule of a client/sub-client table.
--  +========================================================================+
-- $Id: CCM_Merge_Schedule.sp,v 1.11.208.3 2018/03/20 00:47:28 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Merge_Schedule <<<'

IF EXISTS (select * from sysobjects where name='CCM_Merge_Schedule')
	drop procedure CCM_Merge_Schedule
IF EXISTS (select * from GxQscripts where name='CCM_Merge_Schedule')
	delete from GxQscripts where name = 'CCM_Merge_Schedule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Schedule')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Schedule'
GO
print '... Creating Procedure: CCM_Merge_Schedule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Merge_Schedule
  @errStr varchar(1024) OUTPUT
AS
SET NOCOUNT ON
	-- Do not use transaction here, because it is called by another stored procedure with transaction
	-- CCM_Merge_Holiday should be called only after CCM_Merge_Client, instance, backupset, application (sub-client), commcell,calendar
	SET @errStr = 'ERROR: GENERAL ERROR!'
IF NOT EXISTS (SELECT * FROM UMUsers WHERE ((flags & 0x040) = 0x040))
	BEGIN
	    SET @errStr = 'ERROR: CCM_Merge_Schedule -- Commcell Does not have default admin user -- Fail'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge TM_Task will be based on GUID
	INSERT INTO CCM_MAP_Task
	SELECT taskId, 0, origCCId, 0, GUID, 0
	FROM Commserv_Merge..CCM_TM_Task
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_Task -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_Task SET new_origCCId = b.new_id
	FROM CCM_MAP_Task a, CCM_MAP_Commcell b
	WHERE a.old_origCCId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_Task -- UPDATE -- new_origCCId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_Task SET new_id = b.taskId, exist = 1
	FROM CCM_MAP_Task a, TM_Task b
	WHERE a.GUID = b.GUID
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_Task -- UPDATE -- new_id -- existing tasks'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO TM_TASK
	SELECT a.taskName,a.taskType,a.flags,a.status,a.created,a.modified,a.alertId,a.ownerId,a.runUserId,a.initiatedFrom,a.sequenceNumber,a.localeId,
           a.description,a.deleted,a.disabled,a.uninstalled,a.invalid,a.defaultTask,a.savedReport,a.serial,a.policyType,b.new_origCCId,a.GUID, a.isEZOperation, a.isAgentlessSRM, a.hidden
	FROM Commserv_Merge..CCM_TM_Task a, CCM_MAP_Task b
	WHERE a.taskid = b.old_id
	  AND a.GUID = b.GUID
	  AND b.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- TM_TASK -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_Task SET new_id = b.taskId
	FROM CCM_MAP_Task a, TM_Task b
	WHERE a.GUID = b.GUID
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_Task -- UPDATE -- new_id -- inserted tasks'
		GOTO CX_ERROR_EXIT
	END
	----------------------------------------------------------------------------------------------------------------------------------------
	-- Merge TM_SubTask
	INSERT INTO CCM_MAP_SubTask
	SELECT subTaskId, 0, taskId, 0, 0
	FROM Commserv_Merge..CCM_TM_SubTask
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_SubTask -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SubTask SET new_taskId = b.new_id, exist = b.exist
	FROM CCM_MAP_SubTask a, CCM_MAP_Task b
	WHERE a.old_taskId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_SubTask -- UPDATE -- new_taskId'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO TM_SubTASK
	SELECT a.subTaskName, b.new_taskId, a.subTaskType, a.operationType, a.flags, a.subTaskOrder, a.deleted, a.uninstalled, a.defaultTask,
	       a.subOperationType
	FROM Commserv_Merge..CCM_TM_SubTask a, CCM_MAP_SubTask b
	WHERE a.subTaskid = b.old_id
	  AND b.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- TM_SubTASK -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SubTask SET new_id = c.subTaskId
	FROM Commserv_Merge..CCM_TM_SubTask a, CCM_MAP_SubTask b, TM_SubTask c
	WHERE a.subTaskId = b.old_id
	  AND a.taskId = b.old_taskId
	  AND a.subTaskName = c.subTaskName
	  AND b.new_taskId = c.taskId
	  AND a.subTaskType = c.subTaskType
	  AND a.operationType = c.operationType
	  AND a.flags = c.flags
	  AND a.subTaskOrder = c.subTaskOrder
	  AND a.deleted = c.deleted
	  AND a.uninstalled = c.uninstalled
	  AND a.defaultTask = c.defaultTask
	  --AND a.subOperationType = c.subOperationType
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_SubTask -- UPDATE -- new_id'
		GOTO CX_ERROR_EXIT
	END
	----------------------------------------------------------------------------------------------------------------------------------------
	-- Merge TM_AssocEntity
	INSERT INTO CCM_MAP_AssocEntity
	SELECT assocId, 0, taskId, 0, clientId, 0, instanceId, 0, backupsetId, 0, subClientId, 0, 0
	FROM Commserv_Merge..CCM_TM_AssocEntity
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_AssocEntity -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_AssocEntity SET new_taskId = b.new_id, exist = b.exist
	FROM CCM_MAP_AssocEntity a, CCM_MAP_Task b
	WHERE a.old_taskId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_AssocEntity -- UPDATE -- new_taskId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_AssocEntity SET new_clientId = b.new_id
	FROM CCM_MAP_AssocEntity a, CCM_MAP_Client b
	WHERE a.old_clientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_AssocEntity -- UPDATE -- new_clientId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_AssocEntity SET new_instanceId = b.new_id
	FROM CCM_MAP_AssocEntity a, CCM_MAP_InstanceName b
	WHERE a.old_instanceId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_AssocEntity -- UPDATE -- new_instanceId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_AssocEntity SET new_backupsetId = b.new_id
	FROM CCM_MAP_AssocEntity a, CCM_MAP_BackupSetName b
	WHERE a.old_backupsetId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_AssocEntity -- UPDATE -- new_backupsetId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_AssocEntity SET new_subClientId = b.new_id
	FROM CCM_MAP_AssocEntity a, CCM_MAP_Application b
	WHERE a.old_subClientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_AssocEntity -- UPDATE -- new_subClientId'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO TM_AssocEntity
	SELECT a.assocType, b.new_taskId, a.flags, a.created, a.clientGroupId, b.new_clientId, a.apptypeId, b.new_instanceId, b.new_backupsetId,
	       b.new_subclientId, a.policyId, a.copyId, a.srmReportSet, a.srmReportType, a.exclude, a.trackingPolicyId, a.MediaAgentId, a.agentlessPolicyId, a.workflowId
	FROM Commserv_Merge..CCM_TM_AssocEntity a, CCM_MAP_AssocEntity b
	WHERE a.assocId = b.old_id
	  AND b.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- TM_AssocEntity -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_AssocEntity SET new_id = c.assocId
	FROM Commserv_Merge..CCM_TM_AssocEntity a, CCM_MAP_AssocEntity b, TM_AssocEntity c
	WHERE a.assocId = b.old_id
	  AND a.taskId  = b.old_taskId
	  AND a.assocType = c.assocType
	  AND b.new_taskId = c.taskId
	  AND a.flags = c.flags
	  AND a.created = c.created
	  AND a.clientGroupId = c.clientGroupId
	  AND b.new_clientId = c.clientId
	  AND a.apptypeId = c.apptypeId
	  AND b.new_instanceId = c.instanceId
	  AND b.new_backupsetId = c.backupsetId
	  AND b.new_subclientId = c.subclientId
	  AND a.policyId = c.policyId
	  AND a.copyId = c.copyId
	  AND a.srmReportSet = c.srmReportSet
	  AND a.srmReportType = c.srmReportType
	  AND a.exclude = c.exclude
	  AND a.trackingPolicyId = c.trackingPolicyId
	  AND a.MediaAgentId = c.MediaAgentId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_AssocEntity -- UPDATE -- new_id'
		GOTO CX_ERROR_EXIT
	END
	----------------------------------------------------------------------------------------------------------------------------------------
	-- Merge UMDSProviders will be based on name
	/*
	UMDSProviders and UMUsers are not captured from source commcell.
	Hence, there isn't any need for a logic to merge them.
	TM_Pattern will be associated with the default admin user of the destination commcell.
	INSERT INTO CCM_MAP_UMDSProviders
	SELECT id, 0, domainName, origCCId, 0, 0
	FROM Commserv_Merge..CCM_UMDSProviders
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_UMDSProviders -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_UMDSProviders SET new_origCCId = b.new_id
	FROM CCM_MAP_UMDSProviders a, CCM_MAP_Commcell b
	WHERE a.old_origCCId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_UMDSProviders -- UPDATE -- new_origCCId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_UMDSProviders SET new_id = b.id, exist = 1
	FROM CCM_MAP_UMDSProviders a, UMDSProviders b
	WHERE a.domainName = b.domainName
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_UMDSProviders -- UPDATE -- new_id for existing entities'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO UMDSProviders
	SELECT a.domainName, a.hostName, a.description, a.login, a.password, a.trustedHostUser, a.trustedHostPW, a.flags, a.enabled, a.serviceType,
           a.modified, a.dnsRoot, a.dnsRootStatus, a.useSecureLdap, b.new_origCCId, a.GUID
	FROM Commserv_Merge..CCM_UMDSProviders a, CCM_MAP_UMDSProviders b
	WHERE a.id = b.old_id
	  AND a.domainName = b.domainName
	  AND a.origCCId = b.old_origCCId
	  AND b.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- UMDSProviders -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_UMDSProviders SET new_id = b.id
	FROM CCM_MAP_UMDSProviders a, UMDSProviders b
	WHERE a.domainName = b.domainName
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- UMDSProviders -- UPDATE -- new_id'
		GOTO CX_ERROR_EXIT
	END
	----------------------------------------------------------------------------------------------------------------------------------------
	-- Merge UMUsers will be based on GUID
	INSERT INTO CCM_MAP_UMUsers
	SELECT id, 0, umDSproviderId, 0, userGuid, 0
	FROM Commserv_Merge..CCM_UMUsers
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_UMUsers -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_UMUsers SET new_umDSproviderId = b.new_id
	FROM CCM_MAP_UMUsers a, CCM_MAP_UMDSProviders b
	WHERE a.old_umDSproviderId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_UMUsers -- UPDATE -- new_umDSproviderId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_UMUsers SET exist = 1
	FROM CCM_MAP_UMUsers a, UMUsers b
	WHERE a.userGuid = b.userGuid
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_UMUsers -- UPDATE -- exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO UMUsers (name,description,login,password,email,datePasswordSet , dateExpires ,policy, enabled , flags,modified,pVer,Pager,lastLoginTime,credSetTime,umdsProviderId,userGUID,origUserGuid,origCCID,salt)
	SELECT a.name, a.description, a.login, a.password, a.email, a.datePasswordSet, a.dateExpires, a.policy, a.enabled, a.flags, a.modified, a.pVer,
	       a.Pager, a.lastLogInTime, a.credSetTime, b.new_umDSproviderId, a.userGuid, a.origUserGuid,a.salt
	FROM Commserv_Merge..CCM_UMUsers a, CCM_MAP_UMUsers b
	WHERE a.id = b.old_id
	  AND a.umDSproviderId = b.old_umDSproviderId
	  AND a.userGuid = b.userGuid
	  AND b.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- UMUsers -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_UMUsers SET new_id = b.id
	FROM CCM_MAP_UMUsers a, UMUsers b
	WHERE a.userGuid = b.userGuid
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_UMUsers -- UPDATE new_id'
		GOTO CX_ERROR_EXIT
	END
	*/
	----------------------------------------------------------------------------------------------------------------------------------------
	-- Merge APP_CustomCalendar should have been called before invoking this stored procedure
	----------------------------------------------------------------------------------------------------------------------------------------
	-- Merge TM_Pattern
	UPDATE Commserv_Merge..CCM_TM_Pattern
SET ownerId = (SELECT TOP 1 id FROM UMUsers WHERE ((flags & 0x040) = 0x040))
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_TM_Pattern -- UPDATE -- ownerId'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO CCM_MAP_Pattern
	SELECT patternId, 0, ownerId, ownerId, calendarId, 0, 0
	FROM Commserv_Merge..CCM_TM_Pattern
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_Pattern -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	/*
	UPDATE CCM_MAP_Pattern SET new_ownerId = b.new_id
	FROM CCM_MAP_Pattern a, CCM_MAP_UMUsers b
	WHERE a.old_ownerId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_Pattern -- UPDATE -- new_ownerId'
		GOTO CX_ERROR_EXIT
	END
	*/
	UPDATE CCM_MAP_Pattern SET new_calendarId = b.new_id
	FROM CCM_MAP_Pattern a, CCM_MAP_AppCustomCalendar b
	WHERE a.old_calendarId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_Pattern -- UPDATE -- new_calendarId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_Pattern SET new_id = c.patternId, exist = 1
	FROM Commserv_Merge..CCM_TM_Pattern a, CCM_MAP_Pattern b, TM_Pattern c
	WHERE a.patternId = b.old_id
	  AND a.ownerId = b.old_ownerId
	  AND a.calendarId = b.old_calendarId
	  AND a.name = c.name
	  AND a.ownerId = c.ownerId
	  AND a.status = c.status
	  AND a.flags = c.flags
	  AND a.freq_type = c.freq_type
	  AND a.freq_interval = c.freq_interval
	  AND a.freq_relative_interval = c.freq_relative_interval
	  AND a.freq_recurrence_factor = c.freq_recurrence_factor
	  AND a.freq_subday_interval = c.freq_subday_interval
	  AND a.skipOccurence = c.skipOccurence
	  AND a.skipDayNumber = c.skipDayNumber
	  AND a.active_start_date = c.active_start_date
	  AND a.active_start_time = c.active_start_time
	  AND a.active_end_date = c.active_end_date
	  AND a.active_end_time = c.active_end_time
	  AND a.active_end_occurence = c.active_end_occurence
	  AND a.created = c.created
	  AND a.modified = c.modified
	  AND a.tzId = c.tzId
	  AND a.calendarId = c.calendarId
	  AND a.description = c.description
	  AND a.local_start_date = c.local_start_date
	  AND a.local_end_date = c.local_end_date
	  AND a.disabled = c.disabled
	  AND a.deleted = c.deleted
	  AND a.scheduling = c.scheduling
	  AND a.freq_restart_interval = c.freq_restart_interval
   IF	@@ERROR > 0
   BEGIN
    	SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_Pattern -- UPDATE -- exist'
		GOTO CX_ERROR_EXIT
   END
   INSERT INTO TM_Pattern
   SELECT a.name, b.new_ownerId, a.status, a.flags, a.freq_type, a.freq_interval, a.freq_relative_interval, a.freq_recurrence_factor,
          a.freq_subday_interval, a.skipOccurence, a.skipDayNumber, a.active_start_date, a.active_start_time, a.active_end_date,
          a.active_end_time, a.active_end_occurence, a.created, a.modified, a.tzId, b.new_calendarId, a.description, a.local_start_date,
          a.local_end_date, a.disabled, a.deleted, a.scheduling, a.freq_restart_interval
   FROM Commserv_Merge..CCM_TM_Pattern a, CCM_MAP_Pattern b
   WHERE a.patternId = b.old_id
	 AND a.ownerId = b.old_ownerId
	 AND a.calendarId = b.old_calendarId
	 AND b.exist = 0
   IF	@@ERROR > 0
   BEGIN
    	SET @errStr = 'ERROR: CCM_Merge_Schedule -- TM_Pattern -- INSERT'
		GOTO CX_ERROR_EXIT
   END
   UPDATE CCM_MAP_Pattern SET new_id = c.patternId
   FROM Commserv_Merge..CCM_TM_Pattern a, CCM_MAP_Pattern b, TM_Pattern c
   WHERE a.patternId = b.old_id
	 AND a.ownerId = b.old_ownerId
	 AND a.calendarId = b.old_calendarId
	 AND a.name = c.name
	 AND b.new_ownerId = c.ownerId
	 AND a.status = c.status
	 AND a.flags = c.flags
	 AND a.freq_type = c.freq_type
	 AND a.freq_interval = c.freq_interval
	 AND a.freq_relative_interval = c.freq_relative_interval
	 AND a.freq_recurrence_factor = c.freq_recurrence_factor
	 AND a.freq_subday_interval = c.freq_subday_interval
	 AND a.skipOccurence = c.skipOccurence
	 AND a.skipDayNumber = c.skipDayNumber
	 AND a.active_start_date = c.active_start_date
	 AND a.active_start_time = c.active_start_time
	 AND a.active_end_date = c.active_end_date
	 AND a.active_end_time = c.active_end_time
	 AND a.active_end_occurence = c.active_end_occurence
	 AND a.created = c.created
	 AND a.modified = c.modified
	 AND a.tzId = c.tzId
	 AND b.new_calendarId = c.calendarId
	 AND a.description = c.description
	 AND a.local_start_date = c.local_start_date
	 AND a.local_end_date = c.local_end_date
	 AND a.disabled = c.disabled
	 AND a.deleted = c.deleted
	 AND a.scheduling = c.scheduling
	 AND a.freq_restart_interval = c.freq_restart_interval
   IF	@@ERROR > 0
   BEGIN
    	SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_Pattern -- UPDATE -- new_id'
		GOTO CX_ERROR_EXIT
   END
	----------------------------------------------------------------------------------------------------------------------------------------
	-- Merge TM_PatternAssoc
	INSERT INTO CCM_MAP_PatternAssoc
	SELECT patternAssocId, 0, patternId, 0, subTaskId, 0, 0
	FROM Commserv_Merge..CCM_TM_PatternAssoc
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_PatternAssoc -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_PatternAssoc SET new_patternId = b.new_id
	FROM CCM_MAP_PatternAssoc a, CCM_MAP_Pattern b
	WHERE a.old_patternId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_PatternAssoc -- UPDATE -- new_patternId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_PatternAssoc SET new_subTaskId = b.new_id
	FROM CCM_MAP_PatternAssoc a, CCM_MAP_SubTask b
	WHERE a.old_subTaskId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_PatternAssoc -- UPDATE -- new_subTaskId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_PatternAssoc SET new_id = c.patternAssocId, exist = 1
	FROM CCM_MAP_PatternAssoc b, TM_PatternAssoc c
	WHERE b.new_patternId = c.patternId
	  AND b.new_subTaskId = c.subTaskId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_PatternAssoc -- UPDATE -- exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT INTO TM_PatternAssoc
	SELECT b.new_patternId, b.new_subTaskId, a.flags, a.disabled, a.deleted, a.scheduling
	FROM Commserv_Merge..CCM_TM_PatternAssoc a, CCM_MAP_PatternAssoc b
	WHERE a.patternAssocId = b.old_id
	  AND a.patternId = b.old_patternId
	  AND a.subTaskId = b.old_subTaskId
	  AND b.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- TM_PatternAssoc -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_PatternAssoc SET new_id = c.patternAssocId
	FROM Commserv_Merge..CCM_TM_PatternAssoc a, CCM_MAP_PatternAssoc b, TM_PatternAssoc c
	WHERE a.patternAssocId = b.old_id
	  AND a.patternId = b.old_patternId
	  AND a.subTaskId = b.old_subTaskId
	  AND b.new_patternId = c.patternId
	  AND b.new_subTaskId = c.subTaskId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Schedule -- CCM_MAP_PatternAssoc -- UPDATE new_id'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_Schedule')
	delete from GxQscripts where name = 'CCM_Merge_Schedule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Schedule')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Schedule'
GO

insert into GXDBVersions values(2, 'CCM_Merge_Schedule',  '00010011020800030000', 'CCM_Merge_Schedule', '00010011020800030000')
GO

