

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_SQL_from_XML.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge tables:
--	|					SqlVersion
--	|					SqlServer
--	|					SqlDatabase
--	|					SqlLogMarkNames
--	|					SqlFileGroup
--	|					SqlFileSubClient		-- Part I
--	|					SqlBackupSet			-- Use new commCellId
--	|					SqlBackupFile			-- Use new commCellId
--	|					SqlFile
--	|					SqlFileSubClientGroup
--	|					SqlFileSubClient		-- Part II
--	|					SqlArchiveSet			-- Use new commCellId
--	|					SqlLsns					-- Use new commCellId
--	|					APP_SubClientProp			-- Update attrname = 'SQLFileGrpID'
--	|					sqlNames
--	|					Sqllogmarks
--	|					sqlDbBackupInfo
--	|					sqlFileBackupInfo
--	|					SqlArchiveInfo
--  +========================================================================+
-- $Id: CCM_Merge_SQL_from_XML.sp,v 1.1.208.1 2018/03/20 00:42:59 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Merge_SQL_from_XML <<<'

IF EXISTS (select * from sysobjects where name='CCM_Merge_SQL_from_XML')
	drop procedure CCM_Merge_SQL_from_XML
IF EXISTS (select * from GxQscripts where name='CCM_Merge_SQL_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_SQL_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_SQL_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_SQL_from_XML'
GO
print '... Creating Procedure: CCM_Merge_SQL_from_XML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCM_Merge_SQL_from_XML
  @errStr varchar(1024) OUTPUT
AS
	---------------------------------------------------------
--Code below here is from CCM_Merge_SQL.spb--
SET NOCOUNT ON
--BEGIN TRANSACTION TRAN_Merge_SQL
	SET @errStr = 'NO_ERROR'
		/*
	Only Following tables are used by SQL Server IDA in 9.0 as per kiran
	So removing merge of other
	*sqlDbBackupInfo
	*sqlFileBackupInfo
	*sqlNames
	*sqlNames2
	*sqlarchiveInfo
	*Sqllogmarks
	*/
	/*
	---------------------------------------------------------
	-- Merge SqlVersion table
	-- GET SqlVersion TO BE MERGED
	INSERT	INTO CCM_MAP_SqlVersion
	SELECT	id, 0, type, major, minor, build
	FROM Commserv_Merge..CCM_SqlVersion
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlVersion -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlVersion SET new_id = b.id
	FROM CCM_MAP_SqlVersion a, SqlVersion b
	WHERE a.type = b.type AND a.major = b.major
	AND a.minor = b.minor AND a.build = b.build
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlVersion -- UPDATE new_id 1'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO SqlVersion
	SELECT	b.commCellId, a.type, a.major, a.minor, a.build
	FROM	CCM_MAP_SqlVersion a, Commserv_Merge..CCM_SqlVersion b
	WHERE	a.type = b.type AND a.major = b.major
	AND		a.minor = b.minor AND a.build = b.build
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlVersion -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_SqlVersion SET new_id = b.id
	FROM	CCM_MAP_SqlVersion a, SqlVersion b
	WHERE	a.type = b.type AND a.major = b.major
	AND		a.minor = b.minor AND a.build = b.build
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlVersion -- UPDATE new_id 2'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge SqlServer table
	-- GET SqlServer TO BE MERGED
	INSERT	INTO CCM_MAP_SqlServer
	SELECT	sqlVersionId, 0, clientId, 0, instanceId, 0, 0
	FROM Commserv_Merge..CCM_SqlServer
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlServer -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlServer SET new_sqlVersionId = b.new_id
	FROM CCM_MAP_SqlServer a, CCM_MAP_SqlVersion b
	WHERE a.old_sqlVersionId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlServer -- UPDATE new_sqlVersionId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlServer SET new_clientId = b.new_id
	FROM CCM_MAP_SqlServer a, CCM_MAP_Client b
	WHERE a.old_clientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlServer -- UPDATE new_clientId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlServer SET new_instanceId = b.new_id
	FROM CCM_MAP_SqlServer a, CCM_MAP_InstanceName b
	WHERE a.old_instanceId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlServer -- UPDATE new_instanceId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlServer SET exist = 1
	FROM CCM_MAP_SqlServer a, SqlServer b
	WHERE a.new_instanceId = b.instanceId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlServer -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO SqlServer
	SELECT	a.new_instanceId, b.commCellId,
			b.serverName, a.new_sqlVersionId, b.sa, b.saPassword,
			b.undoFile, b.addTime, b.removalTime, b.deleteFlag,
			b.sqlNTAccount, b.sqlNTPassword, b.sqlServiceName, b.flags, a.new_clientId
	FROM	CCM_MAP_SqlServer a, Commserv_Merge..CCM_SqlServer b
	WHERE	a.old_instanceId = b.instanceId
	AND		a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlServer -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge SqlDatabase table
	-- GET SqlDatabase TO BE MERGED
	INSERT	INTO CCM_MAP_SqlDatabase
	SELECT	backupSetId, 0, sqlServerId, 0, applicationNumber, 0, 0
	FROM Commserv_Merge..CCM_SqlDatabase
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlDatabase -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlDatabase SET new_sqlServerId = b.new_instanceId
	FROM CCM_MAP_SqlDatabase a, CCM_MAP_SqlServer b
	WHERE a.old_sqlServerId = b.old_instanceId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlDatabase -- UPDATE new_sqlServerId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlDatabase SET new_backupSetId = b.new_id
	FROM CCM_MAP_SqlDatabase a, CCM_MAP_BackupSetName b
	WHERE a.old_backupSetId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlDatabase -- UPDATE new_backupSetId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlDatabase SET new_applicationNumber = b.new_id
	FROM CCM_MAP_SqlDatabase a, CCM_MAP_application b
	WHERE a.old_applicationNumber = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlDatabase -- UPDATE new_applicationNumber'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlDatabase SET exist = 1
	FROM CCM_MAP_SqlDatabase a, SqlDatabase b
	WHERE a.new_backupSetId = b.backupSetId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlDatabase -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO SqlDatabase
	SELECT	a.new_backupSetId, b.commCellId,
			a.new_sqlServerId, a.new_applicationNumber,
			b.databaseId, b.databaseName, b.creationTime,
			b.streams, b.maxStreams, b.allowFlags, b.addTime,
			b.removalTime, b.deleteFlag, b.systemFlags, b.logStreams
	FROM	CCM_MAP_SqlDatabase a, Commserv_Merge..CCM_SqlDatabase b
	WHERE	a.old_backupSetId = b.backupSetId
	AND		a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlDatabase -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge SqlLogMarkNames table
	-- GET SqlLogMarkNames TO BE MERGED
	INSERT	INTO CCM_MAP_SqlLogMarkNames
	SELECT	sqlDatabaseId, 0, name, description, lsn, markTime, 0
	FROM Commserv_Merge..CCM_SqlLogMarkNames
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlLogMarkNames -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlLogMarkNames SET new_sqlDatabaseId = b.new_backupSetId
	FROM CCM_MAP_SqlLogMarkNames a, CCM_MAP_SqlDatabase b
	WHERE a.old_sqlDatabaseId = b.old_backupSetId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlLogMarkNames -- UPDATE new_sqlDatabaseId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlLogMarkNames SET exist = 1
	FROM CCM_MAP_SqlLogMarkNames a, SqlLogMarkNames b
	WHERE a.new_sqlDatabaseId = b.sqlDatabaseId
	AND a.name = b.name AND a.description = b.description
	AND	a.lsn = b.lsn AND a.markTime = b.markTime
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlLogMarkNames -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO SqlLogMarkNames
	SELECT	b.commCellId, a.new_sqlDatabaseId, b.name, b.description, b.lsn, b.markTime
	FROM	CCM_MAP_SqlLogMarkNames a, Commserv_Merge..CCM_SqlLogMarkNames b
	WHERE	a.old_sqlDatabaseId = b.sqlDatabaseId
	AND		a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlLogMarkNames -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge SqlFileGroup table
	-- GET SqlFileGroup TO BE MERGED
	INSERT	INTO CCM_MAP_SqlFileGroup
	SELECT	id, 0, sqlDatabaseId, 0, fileGroupName
	FROM Commserv_Merge..CCM_SqlFileGroup
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileGroup -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlFileGroup SET new_sqlDatabaseId = b.new_backupSetId
	FROM CCM_MAP_SqlFileGroup a, CCM_MAP_SqlDatabase b
	WHERE a.old_sqlDatabaseId = b.old_backupSetId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileGroup -- UPDATE new_sqlDatabaseId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlFileGroup SET new_id = b.id
	FROM CCM_MAP_SqlFileGroup a, SqlFileGroup b
	WHERE a.new_sqlDatabaseId = b.sqlDatabaseId
	AND a.fileGroupName = b.fileGroupName
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileGroup -- UPDATE new_id'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO SqlFileGroup
	SELECT	b.commCellId, a.new_sqlDatabaseId, b.applicationNumber,
			b.groupId, b.fileGroupName, b.streams, b.maxStreams,
			b.addTime, b.removalTime, b.deleteFlag
	FROM	CCM_MAP_SqlFileGroup a, Commserv_Merge..CCM_SqlFileGroup b
	WHERE	a.old_sqlDatabaseId = b.sqlDatabaseId
	AND		a.fileGroupName = b.fileGroupName
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlFileGroup -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_SqlFileGroup SET new_id = b.id
	FROM	CCM_MAP_SqlFileGroup a, SqlFileGroup b
	WHERE	a.new_sqlDatabaseId = b.sqlDatabaseId
	AND		a.fileGroupName = b.fileGroupName
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlFileGroup -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge SqlFileSubClient table -- Part I
	-- GET SqlFileSubClient TO BE MERGED
	INSERT	INTO CCM_MAP_SqlFileSubClient
	SELECT	id, 0, sqlDatabaseId, 0, applicationNumber, 0, sqlFileSubClientGroupId, 0, subClientName, 0
	FROM Commserv_Merge..CCM_SqlFileSubClient
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileSubClient -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlFileSubClient SET new_sqlDatabaseId = b.new_backupSetId
	FROM CCM_MAP_SqlFileSubClient a, CCM_MAP_SqlDatabase b
	WHERE a.old_sqlDatabaseId = b.old_backupSetId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileSubClient -- UPDATE new_sqlDatabaseId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlFileSubClient SET new_applicationNumber = b.new_id
	FROM CCM_MAP_SqlFileSubClient a, CCM_MAP_Application b
	WHERE a.old_applicationNumber = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileSubClient -- UPDATE new_applicationNumber'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_SqlFileSubClient SET new_id = b.id
	FROM	CCM_MAP_SqlFileSubClient a, SqlFileSubClient b
	WHERE	a.new_sqlDatabaseId = b.sqlDatabaseId
	AND		a.subClientName = b.subClientName
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileSubClient -- UPDATE new_id 1'
		GOTO CX_ERROR_EXIT
	END
	-- Column sqlFileSubClientGroupId will be updated later
	INSERT	INTO SqlFileSubClient
	SELECT	b.commCellId, a.new_sqlDatabaseId, b.applicationNumber,
			b.subClientName, b.streams, b.maxStreams,
			b.flags, 0
	FROM	CCM_MAP_SqlFileSubClient a, Commserv_Merge..CCM_SqlFileSubClient b
	WHERE	a.old_sqlDatabaseId = b.sqlDatabaseId AND a.subClientName = b.subClientName
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlFileSubClient -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_SqlFileSubClient SET new_id = b.id
	FROM	CCM_MAP_SqlFileSubClient a, SqlFileSubClient b
	WHERE	a.new_sqlDatabaseId = b.sqlDatabaseId
	AND		a.subClientName = b.subClientName
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileSubClient -- UPDATE new_id 2'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge SqlBackupSet table
	-- GET SqlBackupSet TO BE MERGED
	INSERT	INTO CCM_MAP_SqlBackupSet
	SELECT	id, 0, commCellId, 0, sqlDatabaseId, 0,
			sqlVersionId, 0, mtfVersionId, 0, sqlFileSubClientId, 0,
			backupSetId, name, jobId_l, 0
	FROM Commserv_Merge..CCM_SqlBackupSet
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlBackupSet -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlBackupSet SET new_commCellId = b.new_id
	FROM CCM_MAP_SqlBackupSet a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlBackupSet -- UPDATE new_commCellId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlBackupSet SET new_sqlDatabaseId = b.new_backupSetId
	FROM CCM_MAP_SqlBackupSet a, CCM_MAP_SqlDatabase b
	WHERE a.old_sqlDatabaseId = b.old_backupSetId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlBackupSet -- UPDATE new_sqlDatabaseId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlBackupSet SET new_sqlVersionId = b.new_id
	FROM CCM_MAP_SqlBackupSet a, CCM_MAP_SqlVersion b
	WHERE a.old_sqlVersionId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlBackupSet -- UPDATE new_sqlVersionId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlBackupSet SET new_mtfVersionId = b.new_id
	FROM CCM_MAP_SqlBackupSet a, CCM_MAP_SqlVersion b
	WHERE a.old_mtfVersionId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlBackupSet -- UPDATE new_mtfVersionId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlBackupSet SET new_sqlFileSubClientId = b.new_id
	FROM CCM_MAP_SqlBackupSet a, CCM_MAP_SqlFileSubClient b
	WHERE a.old_sqlFileSubClientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlBackupSet -- UPDATE new_sqlFileSubClientId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlBackupSet SET new_id = b.id
	FROM CCM_MAP_SqlBackupSet a, SqlBackupSet b
	WHERE a.new_commCellId = b.commCellId
	AND a.new_sqlDatabaseId = b.sqlDatabaseId
	AND a.new_sqlFileSubClientId = b.sqlFileSubClientId
	AND a.backupSetId = b.backupSetId
	AND a.name = b.name
	AND a.jobId = b.jobId_l
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlBackupSet -- UPDATE new_id 1'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO SqlBackupSet
	SELECT	a.new_commCellId, a.new_sqlDatabaseId, b.backupSetId,
			b.name, b.description, b.userName, b.vendorId,
			a.new_sqlVersionId, a.new_mtfVersionId,
			b.timeZone, b.galaxyStartTime, b.galaxyFinishTime,
			b.compatibility, b.dbVersion, b.backupSize, b.mediaSetId,
			b.streams, b.jobId_h, b.jobId_l, a.new_sqlFileSubClientId
	FROM	CCM_MAP_SqlBackupSet a, Commserv_Merge..CCM_SqlBackupSet b
	WHERE	a.old_sqlDatabaseId = b.sqlDatabaseId AND a.old_sqlFileSubclientId = b.sqlFileSubclientId
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlBackupSet -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_SqlBackupSet SET new_id = b.id
	FROM	CCM_MAP_SqlBackupSet a, SqlBackupSet b
	WHERE	a.new_commCellId = b.commCellId
	AND		a.new_sqlDatabaseId = b.sqlDatabaseId
	AND		a.new_sqlFileSubClientId = b.sqlFileSubClientId
	AND		a.backupSetId = b.backupSetId
	AND		a.name = b.name
	AND		a.jobId = b.jobId_l
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlBackupSet -- UPDATE new_id 2'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge SqlBackupFile table
	-- GET SqlBackupFile TO BE MERGED
	INSERT	INTO CCM_MAP_SqlBackupFile
	SELECT	id, 0, commCellId, 0, sqlFileGroupId, 0, sqlBackupSetId, 0, number, physicalName, logicalName
	FROM Commserv_Merge..CCM_SqlBackupFile
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlBackupFile -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlBackupFile SET new_commCellId = b.new_id
	FROM CCM_MAP_SqlBackupFile a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlBackupFile -- UPDATE new_commCellId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlBackupFile SET new_sqlBackupSetId = b.new_id
	FROM CCM_MAP_SqlBackupFile a, CCM_MAP_SqlBackupSet b
	WHERE a.old_sqlBackupSetId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlBackupFile -- UPDATE new_sqlBackupSetId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlBackupFile SET new_sqlFileGroupId = b.new_id
	FROM CCM_MAP_SqlBackupFile a, CCM_MAP_SqlFileGroup b
	WHERE a.old_sqlFileGroupId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlBackupFile -- UPDATE new_sqlFileGroupId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlBackupFile SET new_id = b.id
	FROM CCM_MAP_SqlBackupFile a, SqlBackupFile b
	WHERE a.new_commCellId = b.commCellId
	AND	a.new_sqlFileGroupId = b.sqlFileGroupId
	AND a.new_sqlBackupSetId = b.sqlBackupSetId
	AND a.number = b.number
	AND a.physicalName = b.physicalName
	AND a.logicalName = b.logicalName
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlBackupFile -- UPDATE new_id 1'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO SqlBackupFile
	SELECT	a.new_commCellId, a.new_sqlFileGroupId, a.new_sqlBackupSetId,
			b.number, b.physicalName, b.logicalName,
			b.physicalDrive, b.pageSize, b.pageCount, b.type
	FROM	CCM_MAP_SqlBackupFile a, Commserv_Merge..CCM_SqlBackupFile b
	WHERE	a.old_commCellId = b.commCellId
	AND		a.old_sqlFileGroupId = b.sqlFileGroupId
	AND		a.old_sqlBackupSetId = b.sqlBackupSetId
	AND		a.number = b.number
	AND		a.physicalName = b.physicalName
	AND		a.logicalName = b.logicalName
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlBackupFile -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlBackupFile SET new_id = b.id
	FROM CCM_MAP_SqlBackupFile a, SqlBackupFile b
	WHERE a.new_commCellId = b.commCellId
	AND	a.new_sqlFileGroupId = b.sqlFileGroupId
	AND a.new_sqlBackupSetId = b.sqlBackupSetId
	AND a.number = b.number
	AND a.physicalName = b.physicalName
	AND a.logicalName = b.logicalName
	AND a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlBackupFile -- UPDATE new_id 2'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge SqlFile table
	-- GET SqlFile TO BE MERGED
	INSERT	INTO CCM_MAP_SqlFile
	SELECT	id, 0, sqlFileGroupId, 0, logicalName
	FROM Commserv_Merge..CCM_SqlFile
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFile -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlFile SET new_sqlFileGroupId = b.new_id
	FROM CCM_MAP_SqlFile a, CCM_MAP_SqlFileGroup b
	WHERE a.old_sqlFileGroupId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFile -- UPDATE new_sqlFileGroupId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlFile SET new_id = b.id
	FROM CCM_MAP_SqlFile a, SqlFile b
	WHERE a.new_sqlFileGroupId = b.sqlFileGroupId
	AND a.logicalName = b.logicalName
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFile -- UPDATE new_id 1'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO SqlFile
	SELECT	b.commCellId, a.new_sqlFileGroupId, b.fileId,
			b.physicalName, b.logicalName,
			b.size, b.maxSize, b.addTime, b.removalTime, b.deleteFlag
	FROM	CCM_MAP_SqlFile a, Commserv_Merge..CCM_SqlFile b
	WHERE	a.old_sqlFileGroupId = b.sqlFileGroupId
	AND		a.logicalName = b.logicalName
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlFile -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlFile SET new_id = b.id
	FROM CCM_MAP_SqlFile a, SqlFile b
	WHERE a.new_sqlFileGroupId = b.sqlFileGroupId
	AND a.logicalName = b.logicalName
	AND a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFile -- UPDATE new_id 2'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge SqlFileSubClientGroup table
	-- GET SqlFileSubClientGroup TO BE MERGED
	INSERT	INTO CCM_MAP_SqlFileSubClientGroup
	SELECT	id, 0, sqlFileGroupId, 0, sqlFileId, 0, nextId, 0, sqlFileSubClientId, 0
	FROM Commserv_Merge..CCM_SqlFileSubClientGroup
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileSubClientGroup -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlFileSubClientGroup SET new_sqlFileGroupId = b.new_id
	FROM CCM_MAP_SqlFileSubClientGroup a, CCM_MAP_SqlFileGroup b
	WHERE a.old_sqlFileGroupId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileSubClientGroup -- UPDATE new_sqlFileGroupId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlFileSubClientGroup SET new_sqlFileId = b.new_id
	FROM CCM_MAP_SqlFileSubClientGroup a, CCM_MAP_SqlFile b
	WHERE a.old_sqlFileId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileSubClientGroup -- UPDATE new_sqlFileId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlFileSubClientGroup SET new_sqlFileSubClientId = b.new_id
	FROM CCM_MAP_SqlFileSubClientGroup a, CCM_MAP_SqlFileSubClient b
	WHERE a.old_sqlFileSubClientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileSubClientGroup -- UPDATE new_sqlFileSubClientId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlFileSubClientGroup SET new_id = b.id
	FROM CCM_MAP_SqlFileSubClientGroup a, SqlFileSubClientGroup b
	WHERE a.new_sqlFileGroupId = b.sqlFileGroupId
	AND a.new_sqlFileId = b.sqlFileId
	AND a.new_sqlFileSubClientId = b.sqlFileSubClientId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileSubClientGroup -- UPDATE new_id 1'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO SqlFileSubClientGroup
	SELECT	b.commCellId, a.new_sqlFileSubClientId, a.new_sqlFileId, a.new_sqlFileGroupId, -1
	FROM	CCM_MAP_SqlFileSubClientGroup a, Commserv_Merge..CCM_SqlFileSubClientGroup b
	WHERE	a.old_sqlFileGroupId = b.sqlFileGroupId
	AND		a.old_sqlFileId = b.sqlFileId
	AND		a.old_sqlFileSubClientId = b.sqlFileSubClientId
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlFileSubClientGroup -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlFileSubClientGroup SET new_id = b.id
	FROM CCM_MAP_SqlFileSubClientGroup a, SqlFileSubClientGroup b
	WHERE a.new_sqlFileGroupId = b.sqlFileGroupId
	AND a.new_sqlFileId = b.sqlFileId
	AND a.new_sqlFileSubClientId = b.sqlFileSubClientId
	AND a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileSubClientGroup -- UPDATE new_id 2'
		GOTO CX_ERROR_EXIT
	END
	SELECT * INTO #TEMP_CCM_MAP_SqlFileSubClientGroup FROM CCM_MAP_SqlFileSubClientGroup
	UPDATE CCM_MAP_SqlFileSubClientGroup SET new_nextId = b.new_id
	FROM CCM_MAP_SqlFileSubClientGroup a, #TEMP_CCM_MAP_SqlFileSubClientGroup b
	WHERE a.old_nextId = b.old_id
	DROP TABLE #TEMP_CCM_MAP_SqlFileSubClientGroup
	UPDATE	SqlFileSubClientGroup SET nextId = b.new_nextId
	FROM	SqlFileSubClientGroup a, CCM_MAP_SqlFileSubClientGroup b
	WHERE	a.id = b.new_id
	AND		a.nextId = -1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlFileSubClientGroup -- UPDATE nextId'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge SqlFileSubClient table -- Part II
	UPDATE	CCM_MAP_SqlFileSubClient SET new_sqlFileSubClientGroupId = b.new_id
	FROM	CCM_MAP_SqlFileSubClient a, CCM_MAP_SqlFileSubClientGroup b
	WHERE	a.old_sqlFileSubClientGroupId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileSubClient -- UPDATE new_sqlFileSubClientGroupId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	SqlFileSubClient SET sqlFileSubClientGroupId = b.new_sqlFileSubClientGroupId
	FROM	SqlFileSubClient a, CCM_MAP_SqlFileSubClient b
	WHERE	a.id = b.new_id AND sqlFileSubClientGroupId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlFileSubClient -- UPDATE sqlFileSubClientGroupId'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge SqlArchiveSet table
	-- GET SqlArchiveSet TO BE MERGED
	INSERT	INTO CCM_MAP_SqlArchiveSet
	SELECT	commCellId, 0, sqlBackupSetId, 0, archiveGroup, 0, archiveFile, 0
	FROM Commserv_Merge..CCM_SqlArchiveSet
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlArchiveSet -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlArchiveSet SET new_commCellId = b.new_id
	FROM CCM_MAP_SqlArchiveSet a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlArchiveSet -- UPDATE new_commCellId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlArchiveSet SET new_sqlBackupSetId = b.new_id
	FROM CCM_MAP_SqlArchiveSet a, CCM_MAP_SqlBackupSet b
	WHERE a.old_sqlBackupSetId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlArchiveSet -- UPDATE new_sqlBackupSetId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlArchiveSet SET new_archiveGroup = b.new_id
	FROM CCM_MAP_SqlArchiveSet a, CCM_MAP_ArchGroup b
	WHERE a.old_archiveGroup = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlArchiveSet -- UPDATE new_archiveGroup'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlArchiveSet SET exist = 1
	FROM CCM_MAP_SqlArchiveSet a, SqlArchiveSet b
	WHERE a.new_commCellId = b.commCellId
	AND a.archiveFile = b.archiveFile
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlArchiveSet -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO SqlArchiveSet
	SELECT	a.new_commCellId, a.new_sqlBackupSetId, b.mediaSetId,
			b.sequenceNumber, a.new_archiveGroup, b.archiveFile, b.bIsTombstoned
	FROM	CCM_MAP_SqlArchiveSet a, Commserv_Merge..CCM_SqlArchiveSet b
	WHERE	a.old_commCellId = b.commCellId AND a.archiveFile = b.archiveFile
	AND		a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlArchiveSet -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge SqlLSNs table
	-- GET SqlLSNs TO BE MERGED
	INSERT	INTO CCM_MAP_SqlLSNs
	SELECT	commCellId, 0, sqlBackupSetId, 0, sqlDatabaseId, 0, 0
	FROM Commserv_Merge..CCM_SqlLSNs
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlLSNs -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlLSNs SET new_commCellId = b.new_id
	FROM CCM_MAP_SqlLSNs a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlLSNs -- UPDATE new_commCellId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlLSNs SET new_sqlBackupSetId = b.new_id
	FROM CCM_MAP_SqlLSNs a, CCM_MAP_SqlBackupSet b
	WHERE a.old_sqlBackupSetId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlLSNs -- UPDATE new_sqlBackupSetId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlLSNs SET new_sqlDatabaseId = b.new_backupSetId
	FROM CCM_MAP_SqlLSNs a, CCM_MAP_SqlDatabase b
	WHERE a.old_sqlDatabaseId = b.old_backupSetId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlLSNs -- UPDATE new_sqlDatabaseId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlLSNs SET exist = 1
	FROM CCM_MAP_SqlLSNs a, SqlLSNs b
	WHERE a.new_commCellId = b.commCellId
	AND a.new_sqlBackupSetId = b.sqlBackupSetId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlLSNs -- UPDATE exist'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO SqlLSNs
	SELECT	a.new_sqlBackupSetId, a.new_commCellId, a.new_sqlDatabaseId,
			b.startTime, b.finishTime, b.backupType, b.firstLSN, b.lastLSN,
			b.checkpointLSN, b.fullBackupLSN
	FROM	CCM_MAP_SqlLSNs a, Commserv_Merge..CCM_SqlLSNs b
	WHERE	a.old_commCellId = b.commCellId AND a.old_sqlBackupSetId = b.sqlBackupSetId
	AND		a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlLSNs -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Update APP_SubClientProp
	UPDATE	APP_SubClientProp SET attrVal = convert(nvarchar(1024), c.new_id)
	FROM	APP_SubClientProp a, CCM_MAP_Application b, CCM_MAP_SqlFileSubClient c
	WHERE	a.componentNameId = b.new_id
	AND		a.attrname = 'SQLFileGrpID'
	AND		a.attrVal <> N'0'
	AND		a.attrVal = convert(nvarchar(1024), c.old_id)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- APP_SubClientProp -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
	*/
	/*
	Only Following tables are used by SQL Server IDA in 9.0 as per kiran
	So removing merge of other
	*sqlDbBackupInfo
	*sqlFileBackupInfo
	*sqlNames
	*sqlNames2
	*sqlarchiveInfo
	*Sqllogmarks
	*/
	---------------------------------------------------------
	-- New SQL tables added in 6.1
	---------------------------------------------------------
	-- Merge sqlNames2 table
	INSERT	INTO CCM_MAP_SqlNames2
	SELECT	id, 0, sqlId, name, type
FROM #CCM_sqlNames2
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlNames2 -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlNames2 SET new_id = b.id
	FROM CCM_MAP_SqlNames2 a, SqlNames2 b
	WHERE a.name = b.name AND a.type = b.type
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlNames2 -- UPDATE new_id 1'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO SqlNames2
	SELECT	b.sqlId, b.name, b.type
FROM	CCM_MAP_SqlNames2 a, #CCM_sqlNames2 b
	WHERE	a.name = b.name AND a.type = b.type
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlNames2 -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_SqlNames2 SET new_id = b.id
	FROM	CCM_MAP_SqlNames2 a, SqlNames2 b
	WHERE	a.name = b.name AND a.type = b.type
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlNames2 -- UPDATE new_id 2'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge SqlNames table
	-- GET SqlNames TO BE MERGED
	INSERT	INTO CCM_MAP_SqlNames
	SELECT	id, 0, sqlId, 0, name, type
FROM #CCM_sqlNames
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlNames -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlNames set new_sqlid = a.new_id
	FROM CCM_MAP_SqlNames2 a, CCM_MAP_SqlNames b
	WHERE a.old_id = b.old_sqlid AND a.type = b.type
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlNames -- update new_sqlid'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlNames SET new_id = b.id
	FROM CCM_MAP_SqlNames a, SqlNames b
	WHERE a.new_sqlId = b.sqlId AND a.name = b.name AND a.type = b.type
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlNames -- UPDATE new_id 1'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO SqlNames
	SELECT	new_sqlId, name, type
	FROM	CCM_MAP_SqlNames
	WHERE	new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlNames -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_SqlNames SET new_id = b.id
	FROM	CCM_MAP_SqlNames a, SqlNames b
	WHERE	a.new_sqlId = b.sqlId AND a.name = b.name AND a.type = b.type
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlNames -- UPDATE new_id 2'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge SqlLogMarks table
	-- GET SqlLogMarks TO BE MERGED
	INSERT	INTO CCM_MAP_SqlLogMarks
	SELECT	id, 0, instanceId, 0, dbId, name, markTime
FROM #CCM_Sqllogmarks
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlLogMarks -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlLogMarks SET new_instanceId = b.new_id
	FROM CCM_MAP_SqlLogMarks a, CCM_MAP_InstanceName b
	WHERE a.old_instanceId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlLogMarks -- UPDATE new_instanceId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_SqlLogMarks SET new_id = b.id
	FROM	CCM_MAP_SqlLogMarks a, SqlLogMarks b
	WHERE	a.new_instanceId = b.instanceId
	AND		a.dbId = b.dbId AND	a.name = b.name AND a.markTime = b.markTime
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlLogMarks -- UPDATE new_id 1'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO SqlLogMarks
	SELECT	b.dbId, a.new_instanceId, b.dbName, b.name, b.description, b.lsn, b.markTime
FROM	CCM_MAP_SqlLogMarks a, #CCM_Sqllogmarks b
	WHERE	a.old_id = b.id
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlLogMarks -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_SqlLogMarks SET new_id = b.id
	FROM	CCM_MAP_SqlLogMarks a, SqlLogMarks b
	WHERE	a.new_instanceId = b.instanceId
	AND		a.dbId = b.dbId AND	a.name = b.name AND a.markTime = b.markTime
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlLogMarks -- UPDATE new_id 2'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge SqlDbBackupInfo table
	-- GET SqlDbBackupInfo TO BE MERGED
	INSERT	INTO CCM_MAP_SqlDbBackupInfo
	SELECT	id, 0, instanceId, 0, appId, 0, sqlNameId, 0, sqlLastLogBackup, 0, backup_set_id
FROM #CCM_sqlDbBackupInfo
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlDbBackupInfo -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlDbBackupInfo SET new_instanceId = b.new_id
	FROM CCM_MAP_SqlDbBackupInfo a, CCM_MAP_InstanceName b
	WHERE a.old_instanceId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlDbBackupInfo -- UPDATE new_instanceId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlDbBackupInfo SET new_appId = b.new_id
	FROM CCM_MAP_SqlDbBackupInfo a, CCM_MAP_Application b
	WHERE a.old_appId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlDbBackupInfo -- UPDATE new_appId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlDbBackupInfo SET new_sqlNameId = b.new_id
	FROM CCM_MAP_SqlDbBackupInfo a, CCM_MAP_SqlNames b
	WHERE a.old_sqlNameId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlDbBackupInfo -- UPDATE new_sqlNameId'
		GOTO CX_ERROR_EXIT
	END
	IF NOT EXISTS(SELECT * FROM sys.indexes WHERE name = 'CCM_MAP_SqlDbBackupInfo_Index')
	CREATE INDEX CCM_MAP_SqlDbBackupInfo_Index ON CCM_MAP_SqlDbBackupInfo (new_instanceId,new_appId, new_sqlNameId, backup_set_id, old_id)
	IF NOT EXISTS(SELECT * FROM sys.indexes WHERE name = 'CCM_sqlDbBackupInfo_Index')
CREATE INDEX CCM_sqlDbBackupInfo_Index ON #CCM_sqlDbBackupInfo (id,jobId)
	UPDATE	CCM_MAP_SqlDbBackupInfo SET new_id = b.id
FROM	CCM_MAP_SqlDbBackupInfo a, SqlDbBackupInfo b, #CCM_sqlDbBackupInfo c
	WHERE	a.new_instanceId = b.instanceId
	AND		a.new_appId = b.appId
	AND		a.new_sqlNameId = b.sqlNameId
	AND		a.backup_set_id = b.backup_set_id
	AND		a.old_id = c.id
	AND		c.jobId = b.jobId
	AND		c.backup_start_Date = b.backup_start_Date
	AND		c.backup_finish_Date = b.backup_finish_Date
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlDbBackupInfo -- UPDATE new_id 1'
		GOTO CX_ERROR_EXIT
	END
	DECLARE @SqlQuery NVARCHAR(MAX)
IF COL_LENGTH('tempdb..#CCM_sqlDbBackupInfo','database_bkup_lsn') IS NOT NULL
	BEGIN
		SET @SqlQuery =
		N'INSERT	INTO SqlDbBackupInfo
		SELECT
		b.backup_set_id, b.majorVersion, b.minorVersion, b.buildVersion,
		b.database_creation_date, b.backup_start_Date, b.backup_finish_Date,
		b.type, a.new_instanceId, a.new_appId, b.backup_size,
		b.dbId, b.first_lsn, b.last_lsn,
		b.checkpoint_lsn, b.full_bkup_lsn, a.new_sqlNameId, -1, b.sqlVssFullbackupTime,
		b.is_copy, b.backupMethod, b.backupVendor, b.jobId,
		b.replica_id, b.group_database_id, b.first_recovery_fork_guid, b.last_recovery_fork_guid, b.differential_base_guid,
		b.database_guid, b.fork_point_lsn, b.differential_base_lsn, b.compressed_backup_size, b.begins_log_chain, b.has_backup_checksums, b.database_bkup_lsn
FROM	CCM_MAP_SqlDbBackupInfo a, #CCM_sqlDbBackupInfo b
		WHERE	a.old_id = b.id
		AND		a.new_id = 0'
	END
	ELSE
	BEGIN
		SET @SqlQuery =
		N'INSERT	INTO SqlDbBackupInfo
		SELECT
		b.backup_set_id, b.majorVersion, b.minorVersion, b.buildVersion,
		b.database_creation_date, b.backup_start_Date, b.backup_finish_Date,
		b.type, a.new_instanceId, a.new_appId, b.backup_size,
		b.dbId, b.first_lsn, b.last_lsn,
		b.checkpoint_lsn, b.full_bkup_lsn, a.new_sqlNameId, -1, b.sqlVssFullbackupTime,
		b.is_copy, b.backupMethod, b.backupVendor, b.jobId,
		b.replica_id, b.group_database_id, b.first_recovery_fork_guid, b.last_recovery_fork_guid, b.differential_base_guid,
		b.database_guid, b.fork_point_lsn, b.differential_base_lsn, b.compressed_backup_size, b.begins_log_chain, b.has_backup_checksums, ''0''
FROM	CCM_MAP_SqlDbBackupInfo a, #CCM_sqlDbBackupInfo b
		WHERE	a.old_id = b.id
		AND		a.new_id = 0'
	END
	EXEC (@SqlQuery)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlDbBackupInfo -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_SqlDbBackupInfo SET new_id = b.id
FROM	CCM_MAP_SqlDbBackupInfo a, SqlDbBackupInfo b, #CCM_sqlDbBackupInfo c
	WHERE	a.new_instanceId = b.instanceId
	AND		a.new_appId = b.appId
	AND		a.new_sqlNameId = b.sqlNameId
	AND		a.backup_set_id = b.backup_set_id
	AND		a.old_id = c.id
	AND		c.jobId = b.jobId
	AND		c.backup_start_Date = b.backup_start_Date
	AND		c.backup_finish_Date = b.backup_finish_Date
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlDbBackupInfo -- UPDATE new_id 2'
		GOTO CX_ERROR_EXIT
	END
	SELECT * INTO #TEMP_CCM_MAP_SqlDbBackupInfo FROM CCM_MAP_SqlDbBackupInfo
	UPDATE	CCM_MAP_SqlDbBackupInfo SET new_sqlLastLogBackup = b.new_id
	FROM	CCM_MAP_SqlDbBackupInfo a, #TEMP_CCM_MAP_SqlDbBackupInfo b
	WHERE	a.old_sqlLastLogBackup = b.old_id
	DROP TABLE #TEMP_CCM_MAP_SqlDbBackupInfo
	UPDATE	SqlDbBackupInfo SET sqlLastLogBackup = b.new_sqlLastLogBackup
	FROM	SqlDbBackupInfo a, CCM_MAP_SqlDbBackupInfo b
	WHERE	a.id = b.new_id
	AND		a.sqlLastLogBackup = -1
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlDbBackupInfo -- UPDATE sqlLastLogBackup'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge SqlFileBackupInfo table
	-- GET SqlFileBackupInfo TO BE MERGED
	INSERT	INTO CCM_MAP_SqlFileBackupInfo
	SELECT	id, 0, sqlDbBackupInfoId, 0, sqlNameFgId, 0, sqlNamePhyId, 0, sqlNameLogId, 0, number
FROM #CCM_sqlFileBackupInfo
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileBackupInfo -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlFileBackupInfo SET new_sqlDbBackupInfoId = b.new_id
	FROM CCM_MAP_SqlFileBackupInfo a, CCM_MAP_sqlDbBackupInfo b
	WHERE a.old_sqlDbBackupInfoId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileBackupInfo -- UPDATE new_sqlDbBackupInfoId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlFileBackupInfo SET new_sqlNameFgId = b.new_id
	FROM CCM_MAP_SqlFileBackupInfo a, CCM_MAP_sqlNames b
	WHERE a.old_sqlNameFgId = b.old_id
	AND b.type = 2
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileBackupInfo -- UPDATE new_sqlNameFgId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlFileBackupInfo SET new_sqlNamePhyId = b.new_id
	FROM CCM_MAP_SqlFileBackupInfo a, CCM_MAP_sqlNames b
	WHERE a.old_sqlNamePhyId = b.old_id
	AND b.type = 3
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileBackupInfo -- UPDATE new_sqlNamePhyId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlFileBackupInfo SET new_sqlNameLogId = b.new_id
	FROM CCM_MAP_SqlFileBackupInfo a, CCM_MAP_sqlNames b
	WHERE a.old_sqlNameLogId = b.old_id
	AND b.type = 4
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileBackupInfo -- UPDATE new_sqlNameLogId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_SqlFileBackupInfo SET new_id = b.id
	FROM	CCM_MAP_SqlFileBackupInfo a, SqlFileBackupInfo b
	WHERE	a.new_sqlDbBackupInfoId = b.sqlDbBackupInfoId
	AND		a.new_sqlNameFgId = b.sqlNameFgId
	AND		a.new_sqlNamePhyId = b.sqlNamePhyId
	AND		a.new_sqlNameLogId = b.sqlNameLogId
	AND		a.number = b.number
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileBackupInfo -- UPDATE new_id 1'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO SqlFileBackupInfo
	SELECT	a.new_sqlDbBackupInfoId, b.number, b.pageSize, b.pageCount,
			b.type, a.new_sqlNameFgId, a.new_sqlNamePhyId, a.new_sqlNameLogId
FROM	CCM_MAP_SqlFileBackupInfo a, #CCM_sqlFileBackupInfo b
	WHERE	a.old_sqlDbBackupInfoId = b.sqlDbBackupInfoId
	AND		a.old_sqlNameFgId = b.sqlNameFgId
	AND		a.old_sqlNamePhyId = b.sqlNamePhyId
	AND		a.old_sqlNameLogId = b.sqlNameLogId
	AND		a.number = b.number
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlFileBackupInfo -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_SqlFileBackupInfo SET new_id = b.id
	FROM	CCM_MAP_SqlFileBackupInfo a, SqlFileBackupInfo b
	WHERE	a.new_sqlDbBackupInfoId = b.sqlDbBackupInfoId
	AND		a.new_sqlNameFgId = b.sqlNameFgId
	AND		a.new_sqlNamePhyId = b.sqlNamePhyId
	AND		a.new_sqlNameLogId = b.sqlNameLogId
	AND		a.number = b.number
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlFileBackupInfo -- UPDATE new_id 2'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge SqlArchiveInfo table
	-- GET SqlArchiveInfo TO BE MERGED
	INSERT	INTO CCM_MAP_SqlArchiveInfo
	SELECT	sqlDbBackupFileId, 0, commCellId, 0, aGroupId, 0, appId, 0, aFileId, aFileOffset, 0
FROM #CCM_sqlarchiveInfo
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlArchiveInfo -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlArchiveInfo SET new_sqlDbBackupFileId = b.new_id
	FROM CCM_MAP_SqlArchiveInfo a, CCM_MAP_sqlDbBackupInfo b
	WHERE a.old_sqlDbBackupFileId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlArchiveInfo -- UPDATE new_sqlDbBackupFileId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlArchiveInfo SET new_commCellId = b.new_id
	FROM CCM_MAP_SqlArchiveInfo a, CCM_MAP_CommCell b
	WHERE a.old_commCellId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlArchiveInfo -- UPDATE new_commCellId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlArchiveInfo SET new_aGroupId = b.new_id
	FROM CCM_MAP_SqlArchiveInfo a, CCM_MAP_ArchGroup b
	WHERE a.old_aGroupId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlArchiveInfo -- UPDATE new_aGroupId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_SqlArchiveInfo SET new_appId = b.new_id
	FROM CCM_MAP_SqlArchiveInfo a, CCM_MAP_Application b
	WHERE a.old_appId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlArchiveInfo -- UPDATE new_appId'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_SqlArchiveInfo SET exist = 1
	FROM	CCM_MAP_SqlArchiveInfo a, SqlArchiveInfo b
	WHERE	a.new_sqlDbBackupFileId = b.sqlDbBackupFileId
	AND		a.new_CommCellId = b.commCellId
	AND		a.aFileId = b.aFileId
	AND		a.aFileOffset = b.aFileOffset
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- CCM_MAP_SqlArchiveInfo -- UPDATE new_id 1'
		GOTO CX_ERROR_EXIT
	END
IF COL_LENGTH('tempdb..#CCM_sqlarchiveInfo','backupJobId') IS NOT NULL
    BEGIN
			SET @SqlQuery = N'
			INSERT	INTO SqlArchiveInfo
			SELECT	a.new_sqlDbBackupFileId, a.new_commCellId, b.aFileId, b.aFileOffset,
					a.new_aGroupId, a.new_appId, b.DbFile, b.backupJobId
FROM 	CCM_MAP_SqlArchiveInfo a, #CCM_sqlarchiveInfo b
			WHERE 	a.old_sqlDbBackupFileId = b.sqlDbBackupFileId AND
					a.old_commCellId = b.commCellId AND
					a.aFileId = b.aFileId AND
					a.aFileOffset = b.aFileOffset AND
					a.exist = 0 '
	END
	ELSE
	BEGIN	SET @SqlQuery = N'
			INSERT	INTO SqlArchiveInfo
			SELECT	a.new_sqlDbBackupFileId, a.new_commCellId, b.aFileId, b.aFileOffset,
					a.new_aGroupId, a.new_appId, b.DbFile, 0
FROM 	CCM_MAP_SqlArchiveInfo a, #CCM_sqlarchiveInfo b
			WHERE	a.old_sqlDbBackupFileId = b.sqlDbBackupFileId AND
					a.old_commCellId = b.commCellId AND
					a.aFileId = b.aFileId AND
					a.aFileOffset = b.aFileOffset AND
					a.exist = 0 '
	END
	EXEC (@SqlQuery)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SQL -- SqlArchiveInfo -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
	---------------------------------------------------------
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_SQL_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_SQL_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_SQL_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_SQL_from_XML'
GO

insert into GXDBVersions values(2, 'CCM_Merge_SQL_from_XML',  '00010001020800010000', 'CCM_Merge_SQL_from_XML', '00010001020800010000')
GO

