

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_SCPolicy_from_XML.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge All Subclient Policies						 |
--	| Author          : Gokul Pattabiraman									 |
--  +========================================================================+
-- $Id: CCM_Merge_SCPolicy_from_XML.sp,v 1.2.124.1 2018/03/20 00:32:20 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Merge_SCPolicy_from_XML <<<'

IF EXISTS (select * from sysobjects where name='CCM_Merge_SCPolicy_from_XML')
	drop procedure CCM_Merge_SCPolicy_from_XML
IF EXISTS (select * from GxQscripts where name='CCM_Merge_SCPolicy_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_SCPolicy_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_SCPolicy_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_SCPolicy_from_XML'
GO
print '... Creating Procedure: CCM_Merge_SCPolicy_from_XML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CCM_Merge_SCPolicy_from_XML
  @bfailIfExists INT,
  @bForceOverWrite INT,
  @bDeleteIfExists INT,
  @bDeleteIfExistsOnlyFromSource INT,
  @ccmParamFlags INT
AS
  DECLARE @errCode INTEGER
  DECLARE @errStr varchar(1024)
SET NOCOUNT ON
	SET @errStr = 'ERROR: GENERAL ERROR!'
	BEGIN TRANSACTION CCMMERGESCPOLICY
	---------------------------------------------------------
	DECLARE @commcellGUID	nvarchar(max)
SET @commcellGUID = (SELECT csGUID FROM #CCM_APP_CommCell WHERE id = 2 and type = 1)
	----------------------------------------------------------
	-- Map Tables for Security
	----------------------------------------------------------
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_App_BackupSetName')
	DROP TABLE CCM_MAP_App_BackupSetName
	CREATE TABLE CCM_MAP_App_BackupSetName (
			old_scpId int,
			new_scpId int,
			old_scpName varchar(255),
			new_scpName varchar(255),
			old_origCCId int,
			new_origCCId int,
			Guid	varchar(40),
			exist		 int
			)
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_App_Application')
	DROP TABLE CCM_MAP_App_Application
	CREATE TABLE CCM_MAP_App_Application (
			old_appId int,
			new_appId int,
			old_name varchar(255),
			new_name varchar(255),
			exist int
			)
	---------------------------------------------------------
	-- Create Temp Table to be used by merge operation
	EXEC CCM_MERGE_MAP 1
	--------------------------------------------------------
	---------------------- Variables ------------------------
	DECLARE @bConflictsFound INT
		SET @bConflictsFound = 0
	DECLARE @id		integer
	DECLARE @timeStamp     integer
    DECLARE @bkpsetId integer
    DECLARE @scId integer
    DECLARE @appId integer
    DECLARE @appscName nvarchar(128)
	---------------------------------------------------------
				-- Merge CommCell First --
	---------------------------------------------------------
	EXEC @errCode = CCM_MERGE_CommCell_from_XML @errorString = @errStr OUTPUT
	IF @@error <> 0 OR @errCode <> 0 GOTO CX_ERROR_EXIT
	---------------------------------------------------------
	-- Step 1 : Merge App_BackupSetName (Subclient Policies)
	-- CREATE MAPSCP
	INSERT INTO CCM_MAP_App_BackupSetName
	SELECT id, 0, name,' ', origCCId, 0, GUID, 0
FROM #CCM_APP_BackupSetName
	IF	@@error > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- CCM_MAP_App_BackupSetName -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_App_BackupSetName
	SET new_origCCId = MAPCC.new_id
	FROM CCM_MAP_CommCell AS MAPCC
	WHERE old_origCCId = MAPCC.old_id
	IF	@@error > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- CCM_MAP_App_BackupSetName -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
	-- If same SubclientPolicy exists in Destination CommCell then set new_ids
	UPDATE CCM_MAP_App_BackupSetName
	SET new_scpId = SCP.id, exist = 1
	FROM CCM_MAP_App_BackupSetName AS MAPSCP, APP_BackupSetName AS SCP
	WHERE MAPSCP.Guid = SCP.Guid
	IF	@@error > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- CCM_MAP_App_BackupSetName -- UPDATE new_groupId'
		GOTO CX_ERROR_EXIT
	END
	ELSE
	BEGIN
		IF (SELECT COUNT(*) FROM CCM_MAP_App_BackupSetName WHERE exist = 1) > 0
		BEGIN
			SET @bConflictsFound = 1
			IF @bfailIfExists = 1
			BEGIN
				SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- Conflicts Found due to following SubClient Policies - Failing Merge'
				SELECT @errStr = @errStr + CHAR(13) + old_scpName
				FROM CCM_MAP_App_BackupSetName
				WHERE exist = 1
				GOTO CX_ERROR_EXIT
			END
		END
	END
	-- Check for name Conflicts
	UPDATE CCM_MAP_App_BackupSetName
	SET new_scpName = old_scpName + '$' + MAPCC.aliasName
	FROM CCM_MAP_App_BackupSetName AS MAPSCP, APP_BackupSetName AS SCP, CCM_MAP_CommCell AS MAPCC
	WHERE MAPSCP.old_scpName = SCP.name AND MAPSCP.Guid <> SCP.Guid AND MAPSCP.old_origccid = MAPCC.old_id AND SCP.status = 128
	IF	@@error > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- CCM_MAP_App_BackupSetName -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
	-- Check if still there is a conflict
	UPDATE CCM_MAP_App_BackupSetName
	SET new_scpName = CURRENT_TIMESTAMP + new_scpName
	FROM CCM_MAP_App_BackupSetName AS MAPSCP, APP_BackupSetName AS SCP
	WHERE MAPSCP.new_scpName = SCP.name AND MAPSCP.Guid <> SCP.Guid AND SCP.status = 128
	IF	@@error > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- CCM_MAP_App_BackupSetName -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
	-- Insert all new sub client policies
	INSERT INTO APP_BackupSetName
	SELECT	(CASE  MAPSCP.new_scpName
			 WHEN '' THEN MAPSCP.old_scpName
			 ELSE MAPSCP.new_scpName END) , refTime, modified, status, ccpId, ccpTime, MAPSCP.new_origCCId, MSCP.GUID
FROM #CCM_APP_BackupSetName AS MSCP, CCM_MAP_App_BackupSetName AS MAPSCP
	WHERE MAPSCP.old_scpId = MSCP.id AND MAPSCP.exist = 0
	IF	@@error > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- APP_BackupSetName -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	-- Get New ids for inserted subclient policies
	UPDATE CCM_MAP_App_BackupSetName
	SET new_scpId = SCP.id
	FROM CCM_MAP_App_BackupSetName AS MAPSCP, APP_BackupSetName AS SCP
	WHERE MAPSCP.Guid = SCP.GUID AND MAPSCP.exist = 0
	IF	@@error > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- CCM_MAP_App_BackupSetName -- UPDATE'
		GOTO CX_ERROR_EXIT
	END
	-- Step 2 : Merge Properties of subclient policies
	IF @bForceOverWrite = 1
	BEGIN
		-- Update existing subclient policies
		UPDATE APP_BackupSetName
		SET name = (CASE  MAPSCP.new_scpName
					WHEN '' THEN MAPSCP.old_scpName
					ELSE MAPSCP.new_scpName END),
			refTime = MSCP.refTime, modified = MSCP.modified, ccpId = MSCP.ccpId, ccpTime = MSCP.ccpTime, origCCId  = MAPSCP.new_origCCId
FROM CCM_MAP_App_BackupSetName AS MAPSCP, #CCM_APP_BackupSetName AS MSCP, APP_BackupSetName AS SCP
		WHERE MAPSCP.Guid = MSCP.GUID AND MAPSCP.exist = 1 AND MAPSCP.new_scpId = SCP.id
		IF	@@error > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- APP_BackupSetName -- UPDATE'
			GOTO CX_ERROR_EXIT
		END
		-- Delete all properties
		DELETE FROM APP_BackupSetProp
		WHERE componentNameId IN (SELECT new_scpId FROM CCM_MAP_App_BackupSetName)
		IF	@@error > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- APP_BackupSetProp -- DELETE'
			GOTO CX_ERROR_EXIT
		END
		-- Merge All properties
		INSERT INTO APP_BackupSetProp
		SELECT MAPSCP.new_scpId, MSCPROP.attrName , MSCPROP.attrType, MSCPROP.attrVal, MSCPROP.created, MSCPROP.modified, MSCPROP.ccpId
FROM #CCM_APP_BackupSetProp AS MSCPROP, CCM_MAP_App_BackupSetName AS MAPSCP
		WHERE MAPSCP.old_scpId = MSCPROP.componentNameId
		IF	@@error > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- APP_BackupSetProp -- INSERT'
			GOTO CX_ERROR_EXIT
		END
	END
	ELSE
	BEGIN
		-- Merge All properties for newly created subclient policies
		INSERT INTO APP_BackupSetProp
		SELECT MAPSCP.new_scpId, MSCPROP.attrName , MSCPROP.attrType, MSCPROP.attrVal, MSCPROP.created, MSCPROP.modified, MSCPROP.ccpId
FROM #CCM_APP_BackupSetProp AS MSCPROP, CCM_MAP_App_BackupSetName AS MAPSCP
		WHERE MAPSCP.old_scpId = MSCPROP.componentNameId AND MAPSCP.exist = 0
		IF	@@error > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- APP_BackupSetProp -- INSERT'
			GOTO CX_ERROR_EXIT
		END
	END
	-- Step 3 : Merge Template subclients, properties, contents and archPipeConfig
	-- Create MAPAPP
	INSERT INTO CCM_MAP_App_Application
	SELECT id, 0, subclientName, '', 0
FROM #CCM_APP_Application
	IF	@@error > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- CCM_MAP_App_Application -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_App_Application
	SET exist = 1
	FROM CCM_MAP_App_BackupSetName AS MAPSCP, App_application AS APP
	WHERE	APP.backupSet = MAPSCP.new_scpid AND APP.subclientName = old_name
	IF	@@error > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- CCM_MAP_App_Application -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	--IF @bForceOverWrite = 1
	--BEGIN
		-- TO BE IMPLEMETED --
					-- GOKUL
		--IF	@@error > 0
		--BEGIN
			--SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- APP_BackupSetProp -- INSERT'
			--GOTO CX_ERROR_EXIT
		--END
	--END
	--ELSE
	BEGIN
		-- Merge Template subclients for newly inserted Subclient Polcicies
		INSERT INTO APP_Application
		SELECT MAPP.clientId, MAPP.appTypeId, MAPP.instance, MAPSCP.new_scpId, MAPP.appNumber, 1, 1, -- @TODO Wrong arch group ID
			   MAPP.refTime, MAPP.modified, MAPP.subclientName, MAPP.subclientStatus, MAPP.ccpId, MAPP.ccpTime, MAPP.origCCId, MAPP.GUID
FROM #CCM_APP_Application AS MAPP, CCM_MAP_App_BackupSetName AS MAPSCP
		WHERE MAPP.backupSet = MAPSCP.old_scpId AND MAPSCP.exist = 0
		IF	@@error > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- APP_Application -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		-- Get new ids for inserted Apps
		UPDATE CCM_MAP_App_Application
		SET new_appId = APP.id
FROM APP_Application AS APP, CCM_MAP_App_Application AS MAPAPP, #CCM_APP_Application AS MAPP, CCM_MAP_App_BackupSetName AS MAPSCP
		WHERE MAPAPP.old_appId = MAPP.id AND MAPP.clientId = APP.clientId AND MAPP.instance = APP.instance
			  AND MAPP.backupSet = MAPSCP.old_scpId AND MAPSCP.new_scpId = APP.backupSet AND MAPP.subclientName = APP.subclientName AND MAPAPP.exist = 0
		IF	@@error > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- CCM_MAP_App_Application -- UPDATE'
			GOTO CX_ERROR_EXIT
		END
	    -- Insert properties for subclients
	    INSERT INTO APP_SubClientProp
	    SELECT MAPAPP.new_appId , MSCPROP.attrName , MSCPROP.attrType,  MSCPROP.attrVal, MSCPROP.created, MSCPROP.modified,
			   MSCPROP.ccpId
FROM #CCM_APP_SubClientProp AS MSCPROP, CCM_MAP_App_Application AS MAPAPP
	    WHERE MAPAPP.old_appId = MSCPROP.componentNameId AND MAPAPP.exist = 0 AND MAPAPP.new_appId <> 0
		IF	@@error > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- APP_SubClientProp -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		-- Insert subclient contents
		INSERT INTO APP_ScFilterFile
		SELECT MAPAPP.new_appId, MSCF.type, MSCF.fileName, MSCF.created, MSCF.modified, MSCF.ccpId
FROM #CCM_APP_ScFilterFile AS MSCF, CCM_MAP_App_Application AS MAPAPP
		WHERE MAPAPP.old_appId = MSCF.componentNameId AND MAPAPP.exist = 0 AND MAPAPP.new_appId <> 0
		IF	@@error > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- APP_ScFilterFile -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		-- Insert ArchPipeConfig
		INSERT INTO archPipeConfig
		SELECT MAPAPP.new_appId, MAPC.compressWhere, MAPC.numNWAgents , MAPC.NWWriteSpeed
FROM #CCM_archPipeConfig AS MAPC, CCM_MAP_App_Application AS MAPAPP
		WHERE MAPAPP.old_appId = MAPC.appNumber AND MAPAPP.exist = 0 AND MAPAPP.new_appId <> 0
	    IF	@@error > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- archPipeConfig -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		----------------------------------------------------------
		-- Merge Synchronization / Delete Option --
		----------------------------------------------------------
		IF @bDeleteIfExists <> 0
		BEGIN
			DECLARE @backupSetXML XML
			IF @bDeleteIfExistsOnlyFromSource <> 0
			BEGIN
				SET @backupSetXML = (
					SELECT id '@id'
					FROM App_BackupSetName AS SCP
					WHERE SCP.status = 128 AND SCP.GUID NOT IN (SELECT GUID FROM CCM_MAP_App_BackupSetName)
					AND SCP.origCCId IN (SELECT new_origCCId FROM CCM_MAP_App_BackupSetName)
					FOR XML PATH('backupSet'), ROOT('backupSets'), TYPE
				)
				IF	@@error > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- GUIDTbl -- INSERT'
					GOTO CX_ERROR_EXIT
				END
			END
			ELSE
			BEGIN
				SET @backupSetXML = (
					SELECT id '@id'
					FROM App_BackupSetName AS SCP
					WHERE SCP.status = 128 AND SCP.GUID NOT IN(SELECT GUID FROM CCM_MAP_App_BackupSetName)
					FOR XML PATH('backupSet'), ROOT('backupSets'), TYPE
				)
				IF	@@error > 0
				BEGIN
					SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- GUIDTbl -- INSERT'
					GOTO CX_ERROR_EXIT
				END
			END
			----------- Delete Logic For Subclient Policy --------------------
			DECLARE @AppDelSCPExitCode TABLE (
				exitCode	INT
			)
			INSERT INTO @AppDelSCPExitCode
				EXEC AppDeleteSubclientPolicies 0, 0, @backupSetXML
			DECLARE @SCPExitCode INT = 0
			SELECT @SCPExitCode = exitCode FROM @AppDelSCPExitCode
			IF	@SCPExitCode <> 0
			BEGIN
				SET @errCode = @SCPExitCode
				SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- AppDeleteSubclientPolicies'
				GOTO CX_ERROR_EXIT
			END
			------------------------------------------------------------------
		END
	   -------------------------------------------------------------
	END
	---------------------------------------------------------
	-- Merge the Storage Policy associated with Sub Client Policy
	-- Answers validation --
	-- Try to answer the questions for data path based on answer tables (CCMMediaTypeAnswers)
IF EXISTS(SELECT * FROM #CCM_DataPathMapping)
	BEGIN
UPDATE #CCM_DataPathMapping
	    SET newMediaAgentId = 0, newLibraryId = 0
		IF	@@error > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- CCM_DataPathMapping -- UPDATE 1'
			GOTO CX_ERROR_EXIT
		END
UPDATE #CCM_DataPathMapping
		SET newMediaAgentId = b.mediaAgentId,
			newLibraryId    = b.libraryId,
			newDataPathId   = b.DrivePoolId,
			newSpareGroupId = b.SparePoolGroupId
		FROM CommServ..CCMMediaTypeAnswers b,
			 CommServ..MMRecFmtMedTyp c
WHERE #CCM_DataPathMapping.DriveTypeId = c.DriveTypeId
		  AND c.MediaTypeId = b.MediaTypeId
		  AND b.mediaAgentId > 1 -- 1 is Dummy Media Agent Id
		  AND b.libraryId > 0    -- 0 is Dummy Library Id
		IF	@@error > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- CCM_DataPathMapping -- UPDATE 2'
			GOTO CX_ERROR_EXIT
		END
	    -- If unanswered datapath Questions exist they will take fall back datapath in CCM_Merge_MM
		-- Unanswered Data Path questions
		-- IF EXISTS(SELECT * FROM CCM_DB_DATAPATHMAPPING WHERE newMediaAgentId = 0 OR newLibraryId = 0)
		-- BEGIN
		-- SET @errCode = 32769 -- CCM_FAILURE_ANSWERS_NEEDED
		--  SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- Answers needed for DataPath Mappings, Merge Can not Proceed'
		--  GOTO CX_ERROR_EXIT
		-- END
    END
IF EXISTS(SELECT * FROM #CCM_IdxAccessPathMapping)
    BEGIN
		-- Try to answer the questions for sidb access path based on answer tables (CCMSIDBPathAnswers)
UPDATE #CCM_IdxAccessPathMapping
		SET newClientId = 0, newPath = ''
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- CCM_IdxAccessPathMapping -- UPDATE 1'
			GOTO CX_ERROR_EXIT
		END
UPDATE #CCM_IdxAccessPathMapping
		SET newClientId = B.TargetMediaAgentId , newPath = B.TargetpathName , newUserName = B.TargetUserName, newPassword = B.TargetPasword
FROM #CCM_IdxAccessPathMapping A, Commserv..CCMSIDBPathAnswers B
		WHERE --B.SourceCommcellId = @commcellNumber
		B.SourceCommCellGUID = @commcellGUID
		AND B.SourceIdxAccessPathId = A.oldIdxAccessPathId
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- CCM_IdxAccessPathMapping -- UPDATE 2'
			GOTO CX_ERROR_EXIT
		END
		-- We are migrating Stores with dummy accesspath for both CCM and GRC, so no need to validate the answers
		-- Unanswered IdxAccess Path questions
		--IF EXISTS(SELECT * FROM CCM_DB_IDXACCESSPATHMAPPING WHERE newClientId = 0 OR (ISNULL(newPath,'') = ''))
		--	AND  (0 = (@ccmParamFlags & IS_GRC_JOB))
		--BEGIN
		--	SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- Answers needed for SIDB AccessPath Mappings, Merge Can not Proceed'
		--	GOTO CX_ERROR_EXIT
		--END
    END
   	-- Merge Custom Calendar table
	EXEC @errCode = CCM_Merge_CustomCalendar_from_XML @errStr = @errStr OUTPUT
	IF @@error <> 0 OR @errCode <> 0 GOTO CX_ERROR_EXIT
    -- Merge ArchGroup table
	EXEC @errCode = CCM_MERGE_ArchGroup_from_XML 0, @ccmParamFlags, @errStr = @errStr OUTPUT
	IF @@error <> 0 OR @errCode <> 0 GOTO CX_ERROR_EXIT
	-- Merge many copy related tables
	EXEC @errCode = CCM_MERGE_ArchGroupCopy_from_XML 0, @ccmParamFlags,  @errStr = @errStr OUTPUT
	IF @@error <> 0 OR @errCode <> 0 GOTO CX_ERROR_EXIT
	-- Merge ArchStream and MMS2MediaGroup
	EXEC @errCode = CCM_MERGE_ArchStream_from_XML @errStr = @errStr OUTPUT
	IF @@error <> 0 OR @errCode <> 0 GOTO CX_ERROR_EXIT
	-- Merge Data Paths of the Storage Policy Copy tables
	/* No need of merging datapaths for subclient policies
	EXEC @errCode = CCM_MERGE_MM_from_XML 0, 0, 1, @errStr = @errStr OUTPUT
	IF @@error <> 0 OR @errCode <> 0 GOTO CX_ERROR_EXIT
	*/
	UPDATE APP_Application
	SET dataArchGrpID = d.new_id
FROM APP_Application a, CCM_MAP_App_Application b, #CCM_APP_Application c, CCM_MAP_ArchGroup d
	WHERE a.id = b.new_appId
	  AND b.old_appId = c.id
	  AND c.dataArchGrpID = d.old_id
	IF	@@error > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- APP_Application -- UPDATE -- dataArchGrpID'
		GOTO CX_ERROR_EXIT
	END
	UPDATE APP_Application
	SET logArchGrpID = d.new_id
FROM APP_Application a, CCM_MAP_App_Application b, #CCM_APP_Application c, CCM_MAP_ArchGroup d
	WHERE a.id = b.new_appId
	  AND b.old_appId = c.id
	  AND c.logArchGrpID = d.old_id
	IF	@@error > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_SCPolicy -- APP_Application -- UPDATE -- logArchGrpID'
		GOTO CX_ERROR_EXIT
	END
	-- Drop Temp Table used by merge operation
	EXEC CCM_MERGE_MAP 0
	SET @errStr = 'NO_ERROR'
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_App_BackupSetName')
	DROP TABLE CCM_MAP_App_BackupSetName
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_App_Application')
	DROP TABLE CCM_MAP_App_Application
	---------------------------------------------------------
	COMMIT	TRANSACTION CCMMERGESCPOLICY
	SELECT 0, @errStr
	RETURN (0)
CX_ERROR_EXIT:
	-- Drop Temp Table used by merge operation
	EXEC CCM_MERGE_MAP 0
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_App_BackupSetName')
	DROP TABLE CCM_MAP_App_BackupSetName
	IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'CCM_MAP_App_Application')
	DROP TABLE CCM_MAP_App_Application
	--ROLLBACK TRANSACTION CCMMERGESCPOLICY
	IF @errCode = 0
		SELECT -1, @errStr
	ELSE
		SELECT @errCode, @errStr
	RETURN (-1)
--------------------------------------------------------------------------

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_SCPolicy_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_SCPolicy_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_SCPolicy_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_SCPolicy_from_XML'
GO

insert into GXDBVersions values(2, 'CCM_Merge_SCPolicy_from_XML',  '00010002012400010000', 'CCM_Merge_SCPolicy_from_XML', '00010002012400010000')
GO

