

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_Read_Questions_from_XML.sp] ---------- 

--TODO : Change the Actual Header Path during check-in
--  +========================================================================+
--  | Stored Precedure: Capture Init procedures.
--  +========================================================================+
-- $Id: CCM_Merge_Read_Questions_from_XML.sp,v 1.3.72.2 2018/03/20 00:47:42 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Merge_Read_Questions_from_XML <<<'

IF EXISTS (select * from sysobjects where name='CCM_Merge_Read_Questions_from_XML')
	drop procedure CCM_Merge_Read_Questions_from_XML
IF EXISTS (select * from GxQscripts where name='CCM_Merge_Read_Questions_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_Read_Questions_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Read_Questions_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Read_Questions_from_XML'
GO
print '... Creating Procedure: CCM_Merge_Read_Questions_from_XML'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Merge_Read_Questions_from_XML
  @ccmParamFlags integer,
  @i_targetMediaAgentName varchar(1024) = ''
AS
  DECLARE @errorStr varchar(1024);
---------------------------------------------------------------------
SET NOCOUNT ON
BEGIN TRANSACTION TRAN_Merge_Read_Questions
        SET @errorStr = 'NO_ERROR'
        -----------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM #CCM_App_CommCell WHERE id = 2 and type <> 1)
	    BEGIN
	        SET @errorStr = 'Read Questions is not applicable for Migration of Foreign Commcells'
	        GOTO CX_ERROR_EXIT
	    END
        -----------------------------------------------------------------------------------------
        -- New Questions - insert the new question
        -- Old Questions - do not do anything
        DECLARE @commcellNumber     INTEGER
        DECLARE @SourceCommCellName nvarchar(512)
        DECLARE @sourceCommcellGUID	nvarchar(max)
SET @commcellNumber = (SELECT number FROM #CCM_App_CommCell WHERE id = 2 and type = 1)
SET @SourceCommCellName = (SELECT aliasName FROM #CCM_App_CommCell WHERE id = 2 and type = 1)
SET @sourceCommcellGUID = (SELECT csGUID FROM #CCM_App_CommCell WHERE id = 2 and type = 1)
		DECLARE @targetMediaAgentId INTEGER = 1
		IF @i_targetMediaAgentName <> ''
			SET @targetMediaAgentId = ISNULL((SELECT id FROM App_Client WITH (READUNCOMMITTED) WHERE name = @i_targetMediaAgentName), 1)
        INSERT INTO CommServ..CCMMediaTypeAnswers
        SELECT DISTINCT b.MediaTypeId, 0, 0, 1, 0 -- 1 is Dummy Media Agent Id (CCMMediaTypeAnswers has foreign key reference to MMHost)
FROM #CCM_DataPathMapping a,
             CommServ..MMRecFmtMedTyp b
        WHERE a.DriveTypeId = b.DriveTypeId
          AND b.MediaTypeId NOT IN (SELECT d.MediaTypeId FROM CommServ..CCMMediaTypeAnswers d)
        IF	@@ERROR > 0
		BEGIN
			SET @errorStr = 'ERROR: CCM_Merge_Read_Questions -- CCMMediaTypeAnswers -- INSERT'
			GOTO CX_ERROR_EXIT
		END
        INSERT INTO CommServ..CCMClientAnswers
		SELECT @commcellNumber, @sourceCommcellGUID, @SourceCommCellName, a.name, a.net_hostname, '', ''
FROM #CCM_App_Client a left outer join CommServ..CCMClientAnswers b
		ON b.SourceCommCellGUID = @sourceCommcellGUID AND b.OldClientName = a.name AND b.OldClientHostName = a.net_hostname
		WHERE b.SourceCommCellGUID is null
        IF	@@ERROR > 0
		BEGIN
			SET @errorStr = 'ERROR: CCM_Merge_Read_Questions -- CCMClientAnswers -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO CommServ..CCMSIDBPathAnswers
		SELECT DISTINCT @commcellNumber,@sourceCommcellGUID,@SourceCommCellName, a.oldClientName, a.oldIdxAccessPathId, a.oldPath, 1, '', '', '',a.isGlobal
FROM   #CCM_IdxAccessPathMapping a left outer join CommServ..CCMSIDBPathAnswers b
		ON b.SourceCommCellGUID = @sourceCommcellGUID AND b.SourceIdxAccessPathId = a.oldIdxAccessPathId
		WHERE  b.SourceCommCellGUID is null
        IF	@@ERROR > 0
		BEGIN
			SET @errorStr = 'ERROR: CCM_Merge_Read_Questions -- CCMSIDBPathAnswers -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		--For GRC populate questions with default answers (Import as Not Accessible)
		--IF (1 = (@ccmParamFlags & 1))
		--BEGIN
			INSERT INTO CommServ..CCMMountPathAnswers
			SELECT DISTINCT @commcellNumber,@sourceCommcellGUID,@SourceCommCellName,a.SourceMediaAgentId,a.SourceMediaAgentName,
				a.MountPathId, a.MountPathName, 0, a.MountPathName, '', '', 1,a.MountPathType,0,a.SourceDeviceId,a.SourceDeviceName, 0 -- 1 indicates allowEdit from commcell GuI
FROM #CCM_MountPathMapping a left outer join CommServ..CCMMountPathAnswers b
			ON b.SourceCommCellGUID  = @sourceCommcellGUID AND b.SourceMountPathId = a.MountPathId
			WHERE b.SourceCommCellGUID is null
			IF	@@ERROR > 0
			BEGIN
				SET @errorStr = 'ERROR: CCM_Merge_Read_Questions -- CCMMountPathAnswers -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			INSERT INTO CommServ..CCMDevicePathAnswers
			SELECT DISTINCT @commcellNumber,@sourceCommcellGUID,@SourceCommCellName,a.SourceDeviceId,a.SourceDeviceName,
				a.SourceDevicePath,1,a.SourceDevicePath,'','',1, 0
FROM #CCM_DevicePathMapping a left outer join CommServ..CCMDevicePathAnswers b
			ON b.SourceCommCellGUID = @sourceCommcellGUID AND b.SourceDeviceId = a.SourceDeviceId
			WHERE b.SourceCommCellGUID is null
			IF	@@ERROR > 0
			BEGIN
				SET @errorStr = 'ERROR: CCM_Merge_Read_Questions -- CCMDevicePathAnswers -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			INSERT INTO CommServ..CCMLibraryAnswers
			SELECT DISTINCT @commcellNumber,@sourceCommcellGUID,@SourceCommCellName,a.SourceLibraryId, a.SourceLibraryName,
				1, 0, 'CCM_'+a.SourceLibraryName, 1, 1, 0
FROM #CCM_LibraryMapping a LEFT OUTER JOIN CommServ..CCMLibraryAnswers b
			ON b.SourceCommCellGUID = @sourceCommcellGUID AND b.SourceLibraryId = a.SourceLibraryId
			WHERE b.SourceCommCellGUID is null
			IF	@@ERROR > 0
			BEGIN
				SET @errorStr = 'ERROR: CCM_Merge_Read_Questions -- CCMLibraryAnswers -- INSERT'
				GOTO CX_ERROR_EXIT
			END
			--For Cloud GRC we don't show library mapping during creating schedule since we don't have any library information at that time.
			--So we ask only destination MediaAgent for attaching incoming cloud libraries.
			--If MA is selected then attach only cloud library to it.
			IF @targetMediaAgentId > 1
			BEGIN
				UPDATE	MPA
				SET		TargetDeviceMediaAgentId = @targetMediaAgentId
				FROM	CommServ..CCMMountPathAnswers MPA
				WHERE	MPA.SourceCommCellGUID = @sourceCommcellGUID
						AND MPA.MountPathType = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
						AND MPA.TargetDeviceMediaAgentId <= 1
				IF	@@ERROR > 0
				BEGIN
					SET @errorStr = 'ERROR: CCM_Merge_Read_Questions -- CCMMountPathAnswers -- UPDATE TargetDeviceMediaAgentId'
					GOTO CX_ERROR_EXIT
				END
				UPDATE	DPA
				SET		TargetMediaAgentId = @targetMediaAgentId
				FROM	CommServ..CCMDevicePathAnswers DPA
						INNER JOIN CommServ..CCMMountPathAnswers MPA ON DPA.SourceDeviceId = MPA.SourceDeviceId AND DPA.SourceCommCellGUID = MPA.SourceCommCellGUID
				WHERE	DPA.SourceCommCellGUID = @sourceCommcellGUID
						AND MPA.MountPathType = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
						AND DPA.TargetMediaAgentId <= 1
				IF	@@ERROR > 0
				BEGIN
					SET @errorStr = 'ERROR: CCM_Merge_Read_Questions -- CCMDevicePathAnswers -- UPDATE TargetMediaAgentId'
					GOTO CX_ERROR_EXIT
				END
				UPDATE	LIBA
				SET		TargetMediaAgentId = @targetMediaAgentId
				FROM	CommServ..CCMLibraryAnswers LIBA
INNER JOIN #CCM_MMMountPath MP ON LIBA.SourceLibraryId = MP.LibraryId
						INNER JOIN CommServ..CCMMountPathAnswers MPA ON MP.MountPathId = MPA.SourceMountPathId
				WHERE	LIBA.SourceCommCellGUID = @sourceCommcellGUID
						AND MPA.SourceCommCellGUID = @sourceCommcellGUID
						AND MPA.MountPathType = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
						AND LIBA.TargetMediaAgentId <= 1
				IF	@@ERROR > 0
				BEGIN
					SET @errorStr = 'ERROR: CCM_Merge_Read_Questions -- CCMLibraryAnswers -- UPDATE TargetMediaAgentId'
					GOTO CX_ERROR_EXIT
				END
			END
		--Set TargetMediaAgentId for new mount paths if library is already mapped to MA
		update  CCMMountPathAnswers
		set     TargetDeviceMediaAgentId = LIBA.TargetMediaAgentId
		from    CCMMountPathAnswers MPA
INNER JOIN #CCM_MMMountPath MP ON MP.MountPathId = MPA.SourceMountPathId AND MPA.SourceCommCellGUID = @sourceCommcellGUID
				INNER JOIN CCMLibraryAnswers LIBA ON MPA.SourceCommCellGUID = LIBA.SourceCommCellGUID AND LIBA.SourceLibraryId = MP.LibraryId
		where   MPA.TargetDeviceMediaAgentId <= 1 AND LIBA.TargetMediaAgentId > 1
		update CCMDevicePathAnswers
		set     TargetMediaAgentId = M.TargetDeviceMediaAgentId
		from    CCMDevicePathAnswers D
				INNER JOIN CCMMountPathAnswers M ON D.SourceCommCellGUID = M.SourceCommCellGUID AND D.SourceDeviceId = M.SourceDeviceId
		where   D.TargetMediaAgentId <= 1 AND M.TargetDeviceMediaAgentId > 1
        -----------------------------------------------------------------------------------------
COMMIT	TRANSACTION TRAN_Merge_Read_Questions
	IF OBJECT_ID('tempdb.dbo.#TempReadQuestionsResultSet') IS NOT NULL
	BEGIN
		INSERT INTO #TempReadQuestionsResultSet
		SELECT	0, @errorStr
	END
	ELSE
		SELECT	0, @errorStr
	RETURN (0)
CX_ERROR_EXIT:
ROLLBACK TRANSACTION TRAN_Merge_Read_Questions
RAISERROR ('%s' , 16, 1, @errorStr)
	IF OBJECT_ID('tempdb.dbo.#TempReadQuestionsResultSet') IS NOT NULL
	BEGIN
		INSERT INTO #TempReadQuestionsResultSet
		SELECT	-1, @errorStr
	END
	ELSE
		SELECT	-1, @errorStr
	RETURN (-1)
---------------------------------------------------------------------
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_Read_Questions_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_Read_Questions_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Read_Questions_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Read_Questions_from_XML'
GO

insert into GXDBVersions values(2, 'CCM_Merge_Read_Questions_from_XML',  '00010003007200020000', 'CCM_Merge_Read_Questions_from_XML', '00010003007200020000')
GO

