

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_Oracle_from_XML.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge tables:
--	|					OracleTableSpaces
--	|					OracleDataFiles
--	|					OracleObjects
--  +========================================================================+
-- $Id: CCM_Merge_Oracle_from_XML.sp,v 1.1.208.1 2018/03/20 00:37:59 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Merge_Oracle_from_XML <<<'

IF EXISTS (select * from sysobjects where name='CCM_Merge_Oracle_from_XML')
	drop procedure CCM_Merge_Oracle_from_XML
IF EXISTS (select * from GxQscripts where name='CCM_Merge_Oracle_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_Oracle_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Oracle_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Oracle_from_XML'
GO
print '... Creating Procedure: CCM_Merge_Oracle_from_XML'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Merge_Oracle_from_XML
  @errStr varchar(1024) OUTPUT
AS
	---------------------------------------------------------
--Code below here is from CCM_Merge_Oracle.spb--
SET NOCOUNT ON
--BEGIN TRANSACTION TRAN_Merge_Oracle
	SET @errStr = 'ERROR: GENERAL ERROR!'
	--------------------------------------------------------
IF(OBJECT_ID('tempdb..#CCM_OraclePluggableDBs') IS NOT NULL)
	BEGIN
		-- Merge OraclePluggableDBs table
		INSERT INTO CCM_MAP_OraclePluggableDBs
		SELECT pdbId, 0, name, created, instId, 0, dbId
FROM #CCM_OraclePluggableDBs
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OraclePluggableDBs -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_OraclePluggableDBs
		SET new_instId = B.new_id
		FROM CCM_MAP_OraclePluggableDBs A INNER JOIN CCM_MAP_InstanceName B ON A.old_instId = B.old_id
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OraclePluggableDBs -- UPDATE new_instId'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_OraclePluggableDBs
		SET new_pdbId = B.pdbId
		FROM CCM_MAP_OraclePluggableDBs A INNER JOIN OraclePluggableDBs B ON A.new_instId = B.instId AND A.name = B.name AND A.created = B.created
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OraclePluggableDBs -- UPDATE new_pdbId'
			GOTO CX_ERROR_EXIT
		END
		INSERT INTO OraclePluggableDBs
		SELECT A.name, B.new_instId, A.created, A.deleteFlag, A.deleted, A.modified, A.opType, A.dbAttributes, A.dbId
FROM #CCM_OraclePluggableDBs A INNER JOIN CCM_MAP_OraclePluggableDBs B ON A.instId = B.old_instId AND A.name = b.name AND A.created = B.created
		WHERE B.new_pdbId = 0
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Oracle -- OraclePluggableDBs -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		UPDATE CCM_MAP_OraclePluggableDBs
		SET new_pdbId = B.pdbId
		FROM CCM_MAP_OraclePluggableDBs A INNER JOIN OraclePluggableDBs B ON A.new_instId = B.instId AND A.name = B.name AND A.created = B.created
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OraclePluggableDBs -- UPDATE new_pdbId with new value'
			GOTO CX_ERROR_EXIT
		END
	END
	---------------------------------------------------------
	-- Merge OracleTableSpaces table
	-- GET OracleTableSpacesId TO BE MERGED
	INSERT	INTO CCM_MAP_OracleTableSpaces
	SELECT	id, 0, backupsetId, 0, instId, 0, pdbId, 0, name, bkpNode, tablespaceId, created, modified
FROM #CCM_OracleTableSpaces
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OracleTableSpaces -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_OracleTableSpaces SET new_instId = b.new_id
	FROM CCM_MAP_OracleTableSpaces a, CCM_MAP_InstanceName b
	WHERE a.old_instId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OracleTableSpaces -- UPDATE 1'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_OracleTableSpaces SET new_backupSetId = b.new_id
	FROM CCM_MAP_OracleTableSpaces a, CCM_MAP_BackupSetName b
	WHERE a.old_backupsetId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OracleTableSpaces -- UPDATE 2'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_OracleTableSpaces SET new_pdbId = b.new_pdbId
	FROM CCM_MAP_OracleTableSpaces a, CCM_MAP_OraclePluggableDBs b
	WHERE a.old_pdbId = b.old_pdbId AND a.new_pdbId = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OracleTableSpaces -- UPDATE new_pdbId'
		GOTO CX_ERROR_EXIT
	END
        /*
           MR# 58743 -
           Changes made  -
           to find if an entry for table space already exists
           dont rely on name alone, also check the created time.
           Making fix If the table space name, bkpset, instance,client etc
           matches but created time is different those will be considered
           as 2 different entries (deleted one and recreated another by same name).
           Same for OracleDataFiles also...
        */
	UPDATE	CCM_MAP_OracleTableSpaces SET new_id = b.id
	FROM	CCM_MAP_OracleTableSpaces a, OracleTableSpaces b
	WHERE	a.new_backupSetId = b.backupSetId
	AND		a.new_instId = b.instId
	AND		a.name = b.name
	AND		a.bkpNode = b.bkpNode
	AND		a.tablespaceId = b.tablespaceId
	AND 	a.created = b.created
	AND 	a.new_pdbId = b.pdbId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OracleTableSpaces -- UPDATE 3'
		GOTO CX_ERROR_EXIT
	END
	/*
	-- Use the source created time if source has older created time
	UPDATE	OracleTableSpaces SET created = b.created
	FROM	OracleTableSpaces a, CCM_MAP_OracleTableSpaces b
	WHERE	a.id = b.new_id
	AND		a.created > b.created
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- OracleTableSpaces -- UPDATE 1'
		GOTO CX_ERROR_EXIT
	END
	*/
	-- Use the source information if source has newer modified time
	UPDATE	OracleTableSpaces SET
			status = c.status,
			deleteFlag = c.deleteFlag,
			deleted = c.deleted,
			modified = c.modified,
			optype = c.optype,
			maxDBdataSize = c.maxDBdataSize,
			freeDBDataSize = c.freeDBDataSize
FROM	OracleTableSpaces a, CCM_MAP_OracleTableSpaces b, #CCM_OracleTableSpaces c
	WHERE	a.id = b.new_id
	AND		b.old_id = c.id
	AND		a.modified < c.modified
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- OracleTableSpaces -- UPDATE 2'
		GOTO CX_ERROR_EXIT
	END
	DECLARE @SQLQuery NVARCHAR(MAX)
IF EXISTS(SELECT * FROM TempDB.sys.columns WHERE Name = 'highwatermark' AND Object_ID = Object_ID('TempDB..#CCM_OracleTableSpaces'))
    BEGIN
		SET @SQLQuery = N'
		INSERT  INTO OracleTableSpaces
		SELECT  b.name, a.new_instId, b.bkpNode, b.status,
				b.created, b.deleteFlag, b.deleted, b.modified,
				b.optype, a.new_backupsetId, b.tablespaceId,
				b.maxDBdataSize, b.freeDBDataSize, a.new_pdbId, b.highwatermark
FROM    CCM_MAP_OracleTableSpaces a, #CCM_OracleTableSpaces b
		WHERE   a.old_id = b.id AND a.new_id = 0 '
	END
	ELSE
	BEGIN
		SET @SQLQuery = N'
		INSERT  INTO OracleTableSpaces
		SELECT  b.name, a.new_instId, b.bkpNode, b.status,
				b.created, b.deleteFlag, b.deleted, b.modified,
				b.optype, a.new_backupsetId, b.tablespaceId,
				b.maxDBdataSize, b.freeDBDataSize, a.new_pdbId, 0
FROM    CCM_MAP_OracleTableSpaces a, #CCM_OracleTableSpaces b
		WHERE   a.old_id = b.id AND a.new_id = 0 '
	END
	EXEC (@SQLQuery)
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- OracleTableSpaces -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_OracleTableSpaces SET new_id = b.id
	FROM	CCM_MAP_OracleTableSpaces a, OracleTableSpaces b
	WHERE	a.new_instId = b.instId
	AND		a.new_backupsetId = b.backupSetId
	AND		a.name = b.name
	AND		a.bkpNode = b.bkpNode
	AND		a.tablespaceId = b.tablespaceId
	AND 	a.created = b.created
	AND 	a.new_pdbId = b.pdbId
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OracleTableSpaces -- UPDATE 4'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge OracleDataFiles table
	-- GET OracleDataFilesId TO BE MERGED
	INSERT	INTO CCM_MAP_OracleDataFiles
	SELECT	id, 0, tblId, 0, backupsetId, 0, instId, 0, name, created, modified
FROM #CCM_OracleDataFiles
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OracleDataFiles -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_OracleDataFiles SET new_tblId = b.new_id
	FROM CCM_MAP_OracleDataFiles a, CCM_MAP_OracleTableSpaces b
	WHERE a.old_tblId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OracleDataFiles -- UPDATE 1'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_OracleDataFiles SET new_instId = b.new_id
	FROM CCM_MAP_OracleDataFiles a, CCM_MAP_InstanceName b
	WHERE a.old_instId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OracleDataFiles -- UPDATE 2'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_OracleDataFiles SET new_backupSetId = b.new_id
	FROM CCM_MAP_OracleDataFiles a, CCM_MAP_BackupSetName b
	WHERE a.old_backupsetId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OracleDataFiles -- UPDATE 3'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_OracleDataFiles SET new_id = b.id
	FROM	CCM_MAP_OracleDataFiles a, OracleDataFiles b
	WHERE	a.new_backupSetId = b.backupSetId
	AND		a.new_instId = b.instId
	AND		a.new_tblId = b.tblId
	AND		a.name = b.name
	AND 	a.created = b.created
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OracleDataFiles -- UPDATE 3'
		GOTO CX_ERROR_EXIT
	END
	/*
	-- Use the source created time if source has older created time
	UPDATE	OracleDataFiles SET created = b.created
	FROM	OracleDataFiles a, CCM_MAP_OracleDataFiles b
	WHERE	a.id = b.new_id
	AND		a.created > b.created
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- OracleDataFiles -- UPDATE 1'
		GOTO CX_ERROR_EXIT
	END
	*/
	-- Use the source information if source has newer modified time
	UPDATE	OracleDataFiles SET
			status = c.status,
			deleteFlag = c.deleteFlag,
			deleted = c.deleted,
			modified = c.modified,
			optype = c.optype,
			maxDBdataSize = c.maxDBdataSize,
			freeDBDataSize = c.freeDBDataSize
FROM	OracleDataFiles a, CCM_MAP_OracleDataFiles b, #CCM_OracleDataFiles c
	WHERE	a.id = b.new_id
	AND		b.old_id = c.id
	AND		a.modified < c.modified
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- OracleDataFiles -- UPDATE 2'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO OracleDataFiles
	SELECT	b.name, a.new_tblId, a.new_instId, b.bkpNode, b.status,
			b.created, b.deleteFlag, b.deleted, b.modified,
			b.optype, a.new_backupsetId,
			b.maxDBdataSize, b.freeDBDataSize, b.underDBDir, b.contType, b.totalPages, b.isAccessible
FROM	CCM_MAP_OracleDataFiles a, #CCM_OracleDataFiles b
	WHERE	a.old_id = b.id and a.new_id = 0
	/*a.old_instId = b.instId
	AND		a.old_backupsetId = b.backupSetId
	AND		a.old_tblId = b.tblId
	AND		a.name = b.name
	AND		a.new_id = 0*/
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- OracleDataFiles -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_OracleDataFiles SET new_id = b.id
	FROM	CCM_MAP_OracleDataFiles a, OracleDataFiles b
	WHERE	a.new_instId = b.instId
	AND		a.new_backupsetId = b.backupSetId
	AND		a.new_tblId = b.tblId
	AND		a.name = b.name
	AND		a.created = b.created
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OracleDataFiles -- UPDATE 4'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Merge OracleObjects table
	-- GET OracleObjectsId TO BE MERGED
	INSERT	INTO CCM_MAP_OracleObjects
	SELECT	id, 0, subClientId, 0, instId, 0, parentId, 0, objId, 0, taskId, name, type
FROM #CCM_OracleObjects
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OracleObjects -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_OracleObjects SET new_objId = b.new_id
	FROM CCM_MAP_OracleObjects a, CCM_MAP_OracleDataFiles b
	WHERE a.old_objId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OracleObjects -- UPDATE 1'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_OracleObjects SET new_parentId = b.new_id
	FROM CCM_MAP_OracleObjects a, CCM_MAP_OracleTableSpaces b
	WHERE a.old_parentId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OracleObjects -- UPDATE 2'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_OracleObjects SET new_instId = b.new_id
	FROM CCM_MAP_OracleObjects a, CCM_MAP_InstanceName b
	WHERE a.old_instId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OracleObjects -- UPDATE 3'
		GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_OracleObjects SET new_subClientId = b.new_id
	FROM CCM_MAP_OracleObjects a, CCM_MAP_Application b
	WHERE a.old_subClientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OracleObjects -- UPDATE 4'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_OracleObjects SET new_id = b.id
	FROM	CCM_MAP_OracleObjects a, OracleObjects b
	WHERE	a.new_subClientId = b.subClientId
	AND		a.new_instId = b.instId
	AND		a.new_parentId = b.parentId
	AND		a.new_objId = b.objId
	AND		a.name = b.name
	AND		a.type = b.type
	AND		a.taskId = b.taskId
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OracleObjects -- UPDATE 5'
		GOTO CX_ERROR_EXIT
	END
	INSERT	INTO OracleObjects
	SELECT	a.new_subClientId, a.taskId, a.new_instId, a.type,
			a.new_parentId, a.new_objId, b.setType, b.actionType, b.name, b.underDBDir, b.contType, b.totalPages, b.isAccessible
FROM	CCM_MAP_OracleObjects a, #CCM_OracleObjects b
	WHERE	a.old_subClientId = b.subClientId
	AND		a.old_instId = b.instId
	AND		a.old_parentId = b.parentId
	AND		a.old_objId = b.objId
	AND		a.name = b.name
	AND		a.type = b.type
	AND		a.taskId = b.taskId
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- OracleObjects -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	UPDATE	CCM_MAP_OracleObjects SET new_id = b.id
	FROM	CCM_MAP_OracleObjects a, OracleObjects b
	WHERE	a.new_subClientId = b.subClientId
	AND		a.new_instId = b.instId
	AND		a.new_parentId = b.parentId
	AND		a.new_objId = b.objId
	AND		a.name = b.name
	AND		a.type = b.type
	AND		a.taskId = b.taskId
	AND		a.new_id = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_Oracle -- CCM_MAP_OracleObjects -- UPDATE 6'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	RETURN (-1)
	---------------------------------------------------------
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_Oracle_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_Oracle_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_Oracle_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_Oracle_from_XML'
GO

insert into GXDBVersions values(2, 'CCM_Merge_Oracle_from_XML',  '00010001020800010000', 'CCM_Merge_Oracle_from_XML', '00010001020800010000')
GO

