

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_OperationWindow_from_XML.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge APP_OpWindowRule table.
--  +========================================================================+
-- $Id: CCM_Merge_OperationWindow_from_XML.sp,v 1.2.186.2 2018/12/27 16:45:15 vikashkumar Exp $
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CCM_Merge_OperationWindow_from_XML')
BEGIN
	print '>>> Drop Stored Procedure: CCM_Merge_OperationWindow_from_XML <<<'
	drop procedure CCM_Merge_OperationWindow_from_XML
END
IF EXISTS (select * from GxQscripts where name='CCM_Merge_OperationWindow_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_OperationWindow_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_OperationWindow_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_OperationWindow_from_XML'
GO
print '... Creating Procedure: CCM_Merge_OperationWindow_from_XML'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Merge_OperationWindow_from_XML
  @i_forceOverWrite integer,
  @errStr varchar(1024) OUTPUT
AS
	---------------------------------------------------------
--Code below here is from CCM_Merge_OperationWindow--
SET NOCOUNT ON
	-- Do not use transaction here, because it is called by another stored procedure with transaction
	-- CCM_Merge_OperationWindow should be called only after merge of clients, instance, backup sets and sub client ids.
	----------------------------------------------------------------------------------------------------------------------
	SET @errStr = 'ERROR: GENERAL ERROR!'
	---------------------------------------------------------
    INSERT INTO CCM_MAP_OpWindowRule
    SELECT DISTINCT id, 0, clientId, 0, appTypeId, opType, daysOfWeek, startTime, endTime, enable,
           description, utilization, weekOfTheMonth, doNotSubmitJob, clientGroupId, instanceId, 0, backupsetId, 0, subclientId, 0, startDate, endDate, 0
FROM #CCM_APP_OpWindowRule
    IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_OperationWindow -- CCM_MAP_OpWindowRule -- INSERT'
		GOTO CX_ERROR_EXIT
	END
    -- Update New Client Id
    UPDATE CCM_MAP_OpWindowRule SET newClientId = b.new_id
	FROM CCM_MAP_OpWindowRule a, CCM_MAP_Client b
	WHERE a.oldClientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_OperationWindow -- CCM_MAP_OpWindowRule -- UPDATE newClientId'
		GOTO CX_ERROR_EXIT
	END
	-- Update New Instance Id
	UPDATE CCM_MAP_OpWindowRule SET newInstanceId = b.new_id
	FROM CCM_MAP_OpWindowRule a, CCM_MAP_InstanceName b
	WHERE a.oldInstanceId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_OperationWindow -- CCM_MAP_OpWindowRule -- UPDATE newInstanceId'
		GOTO CX_ERROR_EXIT
	END
	-- Update New Backupset Id
	UPDATE CCM_MAP_OpWindowRule SET newBackupsetId = b.new_id
	FROM CCM_MAP_OpWindowRule a, CCM_MAP_BackupSetName b
	WHERE a.oldBackupsetId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_OperationWindow -- CCM_MAP_OpWindowRule -- UPDATE newBackupsetId'
		GOTO CX_ERROR_EXIT
	END
	-- Update New Sub Client Id
	UPDATE CCM_MAP_OpWindowRule SET newSubclientId = b.new_id
	FROM CCM_MAP_OpWindowRule a, CCM_MAP_Application b
	WHERE a.oldSubclientId = b.old_id
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_OperationWindow -- CCM_MAP_OpWindowRule -- UPDATE newSubclientId'
		GOTO CX_ERROR_EXIT
	END
	--If force overwrite is selected then delete existing entries
	IF 1 = @i_forceOverWrite
	BEGIN
		DELETE 	APP_OpWindowRule
		FROM	CCM_MAP_OpWindowRule a INNER JOIN APP_OpWindowRule b
				ON a.newClientId = b.clientId and
				a.newInstanceId = b.instanceId and
				a.newBackupsetId = b.backupsetId and
				a.newSubclientId = b.subclientId
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_OperationWindow -- APP_OpWindowRule -- DELETE if forceOverWrite'
			GOTO CX_ERROR_EXIT
		END
	END
	ELSE
	BEGIN
		UPDATE	CCM_MAP_OpWindowRule SET exist = 1, new_id = b.id
		FROM	CCM_MAP_OpWindowRule a, APP_OpWindowRule b
		WHERE	a.newClientId = b.clientId and
				a.newInstanceId = b.instanceId and
				a.newBackupsetId = b.backupsetId and
				a.newSubclientId = b.subclientId and
				a.appTypeId = b.appTypeId and
				a.opType = b.opType and
				a.daysOfWeek = b.daysOfWeek and
				a.startTime = b.startTime and
				a.endTime = b.endTime and
				a.enable = b.enable and
				a.description = b.description and
				a.utilization = b.utilization and
				a.weekOfTheMonth = b.weekOfTheMonth and
				a.doNotSubmitJob = b.doNotSubmitJob and
				a.clientGroupId = b.clientGroupId and -- A check for 0, as Merge is only for client/sub-client specific operation window
				a.startDate = b.startDate and
				a.endDate = b.endDate
		IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_OperationWindow -- CCM_MAP_OpWindowRule -- UPDATE exist'
			GOTO CX_ERROR_EXIT
		END
	END
	-- Insert non-exist operation windows only
	DECLARE @maxid 		INTEGER	= 0
	SET 	@maxid 				= ISNULL((SELECT MAX(id) FROM APP_OpWindowRule),0) + 1
	DECLARE @old_id	INTEGER	= 0
	DECLARE OperationWindowList CURSOR LOCAL FORWARD_ONLY FOR
	SELECT DISTINCT old_id
	FROM CCM_MAP_OpWindowRule
	OPEN OperationWindowList
	FETCH NEXT FROM OperationWindowList
	INTO @old_id
	WHILE @@FETCH_STATUS = 0
	BEGIN
		UPDATE CCM_MAP_OpWindowRule
		SET new_id = old_id + @maxid
		WHERE old_id = @old_id
		SET @maxid = @maxid + 1
		FETCH NEXT FROM OperationWindowList
		INTO @old_id
	END
	CLOSE OperationWindowList
	DEALLOCATE OperationWindowList
	INSERT INTO APP_OpWindowRule
	SELECT a.new_id,
		   a.newClientId,
	       a.appTypeId,
	       a.opType,
	       a.daysOfWeek,
	       a.startTime,
	       a.endTime,
	       a.enable,
	       a.description,
	       a.utilization,
	       a.clientGroupId,    -- clientGroupId will be 0 as the captured operation window is client/sub-client specific operation window
	       a.newInstanceId,
	       a.newBackupsetId,
	       a.newSubclientId,
	       a.startDate,
	       a.endDate,
		   0,
		   a.weekOfTheMonth,
		   a.doNotSubmitJob
	FROM CCM_MAP_OpWindowRule a
	WHERE a.exist = 0
	IF	@@ERROR > 0
	BEGIN
		SET @errStr = 'ERROR: CCM_Merge_OperationWindow -- APP_OpWindowRule -- INSERT'
		GOTO CX_ERROR_EXIT
	END
	/*
	DECLARE CCM_OpWindowRuleCursor Cursor LOCAL For
	SELECT a.newClientId,
	       a.appTypeId,
	       a.opType,
	       a.daysOfWeek,
	       a.startTime,
	       a.endTime,
	       a.enable,
	       a.description,
	       a.utilization,
	       a.clientGroupId,    -- clientGroupId will be 0 as the captured operation window is client/sub-client specific operation window
	       a.newInstanceId,
	       a.newBackupsetId,
	       a.newSubclientId,
	       a.startDate,
	       a.endDate
	FROM CCM_MAP_OpWindowRule a
	WHERE a.exist = 0
	OPEN CCM_OpWindowRuleCursor
	FETCH NEXT FROM CCM_OpWindowRuleCursor
	INTO @clientId, @appTypeId, @opType, @daysOfWeek, @startTime, @endTime, @enable, @description, @utilization, @clientGroupId, @instanceId, @backupsetId,
	     @subClientId, @startDate, @endDate
	WHILE @@FETCH_STATUS = 0
	BEGIN
	    SET @id = 0
	    SET @id = ISNULL((SELECT MAX(id) FROM APP_OpWindowRule),0) + 1
	    INSERT INTO APP_OpWindowRule
	    VALUES (@id,@clientId, @appTypeId, @opType, @daysOfWeek, @startTime, @endTime, @enable, @description, @utilization, @clientGroupId, @instanceId,
	            @backupsetId, @subClientId, @startDate, @endDate,0, -1, 0)
	    IF	@@ERROR > 0
		BEGIN
			SET @errStr = 'ERROR: CCM_Merge_OperationWindow -- APP_OpWindowRule -- INSERT'
			GOTO CX_ERROR_EXIT
		END
		FETCH NEXT FROM CCM_OpWindowRuleCursor
		INTO @clientId, @appTypeId, @opType, @daysOfWeek, @startTime, @endTime, @enable, @description, @utilization, @clientGroupId, @instanceId, @backupsetId,
	         @subClientId, @startDate, @endDate
	END
	CLOSE CCM_OpWindowRuleCursor
	DEALLOCATE CCM_OpWindowRuleCursor
	*/
	---------------------------------------------------------
	SET @errStr = 'NO_ERROR'
	RETURN (0)
CX_ERROR_EXIT:
	IF EXISTS (select * from tempdb.dbo.sysobjects where id = object_id(N'tempdb.[dbo].[##temp_CCM_OpWindowRule]'))
		DROP TABLE ##temp_CCM_OpWindowRule
  --  IF (Cursor_Status('LOCAL', 'CCM_OpWindowRuleCursor') >= -1)
--	BEGIN
	--	CLOSE CCM_OpWindowRuleCursor
	--	DEALLOCATE CCM_OpWindowRuleCursor
--	END
	RETURN (-1)
	---------------------------------------------------------
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_OperationWindow_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_OperationWindow_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_OperationWindow_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_OperationWindow_from_XML'
GO

insert into GXDBVersions values(2, 'CCM_Merge_OperationWindow_from_XML',  '00010002018600020000', 'CCM_Merge_OperationWindow_from_XML', '00010002018600020000')
GO

