

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/CCM_Merge_MediaLocation_from_XML.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Merge Media Location.
--  +========================================================================+
-- $Id: CCM_Merge_MediaLocation_from_XML.sp,v 1.2.208.1 2018/03/20 00:33:37 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CCM_Merge_MediaLocation_from_XML <<<'

IF EXISTS (select * from sysobjects where name='CCM_Merge_MediaLocation_from_XML')
	drop procedure CCM_Merge_MediaLocation_from_XML
IF EXISTS (select * from GxQscripts where name='CCM_Merge_MediaLocation_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_MediaLocation_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_MediaLocation_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_MediaLocation_from_XML'
GO
print '... Creating Procedure: CCM_Merge_MediaLocation_from_XML'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CCM_Merge_MediaLocation_from_XML
  @deleteIfNotPresentInSourceCC integer = 0,
  @deleteOnlySourceIfNotPresentInSourceCC integer = 0,
  @onConflictFail integer = 0,
  @onConflictForceOverwrite integer = 0
AS
SET NOCOUNT ON
  DECLARE @errorCode integer
  DECLARE @errorString varchar(4000)
BEGIN TRANSACTION TRAN_Merge_MediaLocation
    SET @errorCode = 0
	SET @errorString = 'ERROR: GENERAL ERROR!'
	---------------------------------------------------------
--Code below here is from CCM_Merge_MediaLocation.spb
	IF (@onConflictFail = 1 AND @onConflictForceOverwrite = 1)
	BEGIN
		SET @errorString = 'ERROR: CCM_Merge_Main -- Only one of the conflict options should be enabled'
		GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	-- Create Temp Table to be used by merge operation
	EXEC CCM_Merge_Map 1
	---------------------------------------------------------
	-- Merge CommCell table
	EXEC @errorCode = CCM_MERGE_CommCell_from_XML @errorString = @errorString OUTPUT
	IF @@error <> 0 OR @errorCode <> 0 GOTO CX_ERROR_EXIT
	---------------------------------------------------------
	-- Merge/Synchronize Media Location
	IF (@deleteIfNotPresentInSourceCC = 1)
	BEGIN
	  IF (@deleteOnlySourceIfNotPresentInSourceCC = 1)
	  BEGIN
		 -- Delete all export locations which were originally created in the source commcell
		 -- and are no more associated with any media in the destination commcell
		 DELETE FROM MMExportLocation
		 WHERE origCCId IN (SELECT new_id FROM CCM_MAP_COMMCELL)
		 AND ExportLocationId NOT IN (SELECT DISTINCT b.ExportLocationId FROM MMMedia b)
		 AND ExportLocationId > 0
		 IF	@@ERROR > 0
		 BEGIN
			SET @errorString = 'ERROR: CCM_Merge_MediaLocation -- MMExportLocation -- DELETE for synchronize'
			GOTO CX_ERROR_EXIT
		 END
	  END
	  ELSE
	  BEGIN
		-- Delete all export locations which are no more associated with any media in the destination commcell
		DELETE FROM MMExportLocation
		WHERE ExportLocationId NOT IN (SELECT DISTINCT b.ExportLocationId FROM MMMedia b)
		AND ExportLocationId > 0
		IF	@@ERROR > 0
		BEGIN
		   SET @errorString = 'ERROR: CCM_Merge_MediaLocation -- MMExportLocation -- DELETE for synchronize'
		   GOTO CX_ERROR_EXIT
		END
	  END
	END
	-- Conflicts for export locations is possible when two different export locations have the same name
	/*
	  Source commcell may have an export location with the name Recall Melbourne with GUID1
	  Destination commcell too may have a different export location with the same name Recall Melbourne with different GUID2.
	  This is a conflict and needs special handling.
	  --------------------------------------------------------------------------------------------------------------------
	       Source Commcell                           Destination Commcell                          Action
	    Name            GUID                        Name             GUID
	  --------------------------------------------------------------------------------------------------------------------
	  KUL_Vault         GUID1                     KUL_Vault          GUID1                        Re-merge
	  KUL_Vault         GUID1                     KUL_Vault          GUID2                        Conflict
	  KUL_Vault         GUID1                     KUL_Vault and GUID1 doesn't exist               First time merge
	  KUL_Vault         GUID1                     Recall Melbourne   GUID2                        First time merge
	  KUL_Vault         GUID1                     Recall Melbourne   GUID1                        Conflict
	  --------------------------------------------------------------------------------------------------------------------
	 */
	/*Change in logic - Ignore conflicts - Just consider the Media Location already exists if a location exists by the same name*/
	/*
	IF EXISTS (SELECT *
FROM #CCM_MMExportLocation a, MMExportLocation b
	           WHERE a.GUID = b.GUID
	           AND   a.ExportLocation <> b.ExportLocation)
	BEGIN
	  -- Conflict same GUID having different names in source and destination commcell
	  IF (@onConflictFail = 1)
	  BEGIN
		   SET @errorString = 'ERROR: CCM_Merge_MediaLocation -- MMExportLocation -- Fail On Conflict -- Different names for same GUID'
		   GOTO CX_ERROR_EXIT
	  END
	  ELSE IF (@onConflictForceOverwrite = 1)
	  BEGIN
	       DELETE FROM MMExportLocation
FROM MMExportLocation a, #CCM_MMExportLocation b
	       WHERE a.GUID = b.GUID
	       AND   a.ExportLocation <> b.ExportLocation
		   IF	@@ERROR > 0
		   BEGIN
		      SET @errorString = 'ERROR: CCM_Merge_MediaLocation -- MMExportLocation -- DELETE -- onConflictForceOverwrite'
		      GOTO CX_ERROR_EXIT
		   END
	  END
	END
	IF EXISTS (SELECT *
FROM #CCM_MMExportLocation a, MMExportLocation b
	           WHERE a.ExportLocation = b.ExportLocation
	           AND   a.GUID <> b.GUID)
	BEGIN
	  -- Conflict different GUID having same in source and destination commcell
	  IF (@onConflictFail = 1)
	  BEGIN
		   SET @errorString = 'ERROR: CCM_Merge_MediaLocation -- MMExportLocation -- Fail On Conflict -- Different GUIDs for same name'
		   GOTO CX_ERROR_EXIT
	  END
  	  ELSE IF (@onConflictForceOverwrite = 1)
	  BEGIN
	       DELETE FROM MMExportLocation
FROM MMExportLocation a, #CCM_MMExportLocation b
	       WHERE a.ExportLocation = b.ExportLocation
           AND   a.GUID <> b.GUID
		   IF	@@ERROR > 0
		   BEGIN
		      SET @errorString = 'ERROR: CCM_Merge_MediaLocation -- MMExportLocation -- DELETE -- onConflictForceOverwrite'
		      GOTO CX_ERROR_EXIT
		   END
	  END
	END
	*/
	INSERT INTO CCM_MAP_ExportLocation
	SELECT ExportLocationId, 0, origCCId, 0, GUID, ExportLocation, 0
FROM #CCM_MMExportLocation
	IF	@@ERROR > 0
	BEGIN
	   SET @errorString = 'ERROR: CCM_Merge_MediaLocation -- CCM_MAP_ExportLocation -- INSERT'
	   GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ExportLocation SET new_origCCId = b.new_id
	FROM CCM_MAP_ExportLocation a, CCM_MAP_Commcell b
	WHERE a.old_origCCId = b.old_id
	IF	@@ERROR > 0
	BEGIN
	   SET @errorString = 'ERROR: CCM_Merge_MediaLocation -- CCM_MAP_ExportLocation -- UPDATE -- new_origCCId'
	   GOTO CX_ERROR_EXIT
	END
	UPDATE CCM_MAP_ExportLocation SET exist = 1
	FROM CCM_MAP_ExportLocation a, MMExportLocation b
	--WHERE a.GUID = b.GUID
	WHERE a.ExportLocation = b.ExportLocation
	IF	@@ERROR > 0
	BEGIN
	   SET @errorString = 'ERROR: CCM_Merge_MediaLocation -- CCM_MAP_ExportLocation -- UPDATE -- exist'
	   GOTO CX_ERROR_EXIT
	END
	INSERT INTO MMExportLocation
	SELECT a.ExportLocation, a.Type, a.Descript, b.new_origCCId, a.GUID, a.ModifiedTime
FROM #CCM_MMExportLocation a, CCM_MAP_ExportLocation b
	WHERE /*a.GUID = b.GUID*/a.ExportLocation = b.ExportLocation
	  AND a.origCCId = b.old_origCCId
	  AND b.exist = 0
	IF	@@ERROR > 0
	BEGIN
	   SET @errorString = 'ERROR: CCM_Merge_MediaLocation -- MMExportLocation -- INSERT'
	   GOTO CX_ERROR_EXIT
	END
	---------------------------------------------------------
	EXEC CCM_Merge_Map 0
	---------------------------------------------------------
	SET @errorString = 'NO_ERROR'
COMMIT TRANSACTION TRAN_Merge_MediaLocation
    SELECT	0, @errorString
	RETURN (0)
CX_ERROR_EXIT:
    EXEC CCM_Merge_Map 0
ROLLBACK TRANSACTION TRAN_Merge_MediaLocation
    SELECT	-1, @errorString
	RETURN (-1)
GO

IF EXISTS (select * from GxQscripts where name = 'CCM_Merge_MediaLocation_from_XML')
	delete from GxQscripts where name = 'CCM_Merge_MediaLocation_from_XML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CCM_Merge_MediaLocation_from_XML')
	delete from GXDBVersions where aliasname = 'CCM_Merge_MediaLocation_from_XML'
GO

insert into GXDBVersions values(2, 'CCM_Merge_MediaLocation_from_XML',  '00010002020800010000', 'CCM_Merge_MediaLocation_from_XML', '00010002020800010000')
GO

